/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops.actions;

import com.amazonaws.services.ec2.model.LaunchTemplateVersion;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.ModifyServerGroupLaunchTemplateDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.ModifyServerGroupLaunchTemplateAtomicOperation;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.actions.PrepareUpdateAutoScalingGroup;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.services.LaunchTemplateService;
import com.netflix.spinnaker.clouddriver.aws.services.RegionScopedProviderFactory;
import com.netflix.spinnaker.clouddriver.event.EventMetadata;
import com.netflix.spinnaker.clouddriver.saga.SagaCommand;
import com.netflix.spinnaker.clouddriver.saga.flow.SagaAction;
import com.netflix.spinnaker.clouddriver.saga.models.Saga;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.util.Collections;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class ModifyServerGroupLaunchTemplate
implements SagaAction<ModifyServerGroupLaunchTemplateCommand> {
    private final CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;
    private final RegionScopedProviderFactory regionScopedProviderFactory;

    public ModifyServerGroupLaunchTemplate(CredentialsRepository<NetflixAmazonCredentials> credentialsRepository, RegionScopedProviderFactory regionScopedProviderFactory) {
        this.credentialsRepository = credentialsRepository;
        this.regionScopedProviderFactory = regionScopedProviderFactory;
    }

    @NotNull
    public SagaAction.Result apply(@NotNull ModifyServerGroupLaunchTemplateCommand command, @NotNull Saga saga) {
        LaunchTemplateVersion newVersion;
        ModifyServerGroupLaunchTemplateDescription description = command.description;
        if (!command.isReqToModifyLaunchTemplate.booleanValue()) {
            saga.log("[SAGA_ACTION] Skipping ModifyServerGroupLaunchTemplate as only mixed instances policy will be updated.");
            return new SagaAction.Result((SagaCommand)PrepareUpdateAutoScalingGroup.PrepareUpdateAutoScalingGroupCommand.builder().description(description).launchTemplateVersion(command.sourceVersion).newLaunchTemplateVersionNumber(null).isReqToUpgradeAsgToMixedInstancesPolicy(command.isReqToUpgradeAsgToMixedInstancesPolicy).build(), Collections.emptyList());
        }
        NetflixAmazonCredentials credentials = (NetflixAmazonCredentials)this.credentialsRepository.getOne(description.getAccount());
        RegionScopedProviderFactory.RegionScopedProvider regionScopedProvider = this.regionScopedProviderFactory.forRegion(credentials, description.getRegion());
        saga.log("[SAGA_ACTION] Modifying launch template (i.e. creating a new version) for EC2 Auto Scaling Group " + description.getAsgName());
        LaunchTemplateService launchTemplateService = regionScopedProvider.getLaunchTemplateService();
        try {
            boolean shouldUseMixedInstancesPolicy = command.isAsgBackedByMixedInstancesPolicy != false || command.isReqToUpgradeAsgToMixedInstancesPolicy != false;
            newVersion = launchTemplateService.modifyLaunchTemplate(credentials, description, command.sourceVersion, shouldUseMixedInstancesPolicy);
        }
        catch (Exception e) {
            throw new ModifyServerGroupLaunchTemplateAtomicOperation.LaunchTemplateException("Failed to modify launch template", e);
        }
        return new SagaAction.Result((SagaCommand)PrepareUpdateAutoScalingGroup.PrepareUpdateAutoScalingGroupCommand.builder().description(description).launchTemplateVersion(newVersion).newLaunchTemplateVersionNumber(newVersion.getVersionNumber()).isReqToUpgradeAsgToMixedInstancesPolicy(command.isReqToUpgradeAsgToMixedInstancesPolicy).build(), Collections.emptyList());
    }

    @JsonDeserialize(builder=ModifyServerGroupLaunchTemplateCommandBuilder.class)
    @JsonTypeName(value="modifyServerGroupLaunchTemplateCommand")
    public static final class ModifyServerGroupLaunchTemplateCommand
    implements SagaCommand {
        @Nonnull
        private final LaunchTemplateVersion sourceVersion;
        @Nonnull
        private final ModifyServerGroupLaunchTemplateDescription description;
        @Nonnull
        private final Boolean isReqToModifyLaunchTemplate;
        @Nonnull
        private final Boolean isReqToUpgradeAsgToMixedInstancesPolicy;
        @Nonnull
        private final Boolean isAsgBackedByMixedInstancesPolicy;
        private EventMetadata metadata;

        public void setMetadata(@NotNull EventMetadata metadata) {
            this.metadata = metadata;
        }

        @Generated
        ModifyServerGroupLaunchTemplateCommand(@Nonnull LaunchTemplateVersion sourceVersion, @Nonnull ModifyServerGroupLaunchTemplateDescription description, @Nonnull Boolean isReqToModifyLaunchTemplate, @Nonnull Boolean isReqToUpgradeAsgToMixedInstancesPolicy, @Nonnull Boolean isAsgBackedByMixedInstancesPolicy, EventMetadata metadata) {
            if (sourceVersion == null) {
                throw new IllegalArgumentException("sourceVersion is marked non-null but is null");
            }
            if (description == null) {
                throw new IllegalArgumentException("description is marked non-null but is null");
            }
            if (isReqToModifyLaunchTemplate == null) {
                throw new IllegalArgumentException("isReqToModifyLaunchTemplate is marked non-null but is null");
            }
            if (isReqToUpgradeAsgToMixedInstancesPolicy == null) {
                throw new IllegalArgumentException("isReqToUpgradeAsgToMixedInstancesPolicy is marked non-null but is null");
            }
            if (isAsgBackedByMixedInstancesPolicy == null) {
                throw new IllegalArgumentException("isAsgBackedByMixedInstancesPolicy is marked non-null but is null");
            }
            this.sourceVersion = sourceVersion;
            this.description = description;
            this.isReqToModifyLaunchTemplate = isReqToModifyLaunchTemplate;
            this.isReqToUpgradeAsgToMixedInstancesPolicy = isReqToUpgradeAsgToMixedInstancesPolicy;
            this.isAsgBackedByMixedInstancesPolicy = isAsgBackedByMixedInstancesPolicy;
            this.metadata = metadata;
        }

        @Generated
        public static ModifyServerGroupLaunchTemplateCommandBuilder builder() {
            return new ModifyServerGroupLaunchTemplateCommandBuilder();
        }

        @Generated
        public ModifyServerGroupLaunchTemplateCommandBuilder toBuilder() {
            return new ModifyServerGroupLaunchTemplateCommandBuilder().sourceVersion(this.sourceVersion).description(this.description).isReqToModifyLaunchTemplate(this.isReqToModifyLaunchTemplate).isReqToUpgradeAsgToMixedInstancesPolicy(this.isReqToUpgradeAsgToMixedInstancesPolicy).isAsgBackedByMixedInstancesPolicy(this.isAsgBackedByMixedInstancesPolicy).metadata(this.metadata);
        }

        @Nonnull
        @Generated
        public LaunchTemplateVersion getSourceVersion() {
            return this.sourceVersion;
        }

        @Nonnull
        @Generated
        public ModifyServerGroupLaunchTemplateDescription getDescription() {
            return this.description;
        }

        @Nonnull
        @Generated
        public Boolean getIsReqToModifyLaunchTemplate() {
            return this.isReqToModifyLaunchTemplate;
        }

        @Nonnull
        @Generated
        public Boolean getIsReqToUpgradeAsgToMixedInstancesPolicy() {
            return this.isReqToUpgradeAsgToMixedInstancesPolicy;
        }

        @Nonnull
        @Generated
        public Boolean getIsAsgBackedByMixedInstancesPolicy() {
            return this.isAsgBackedByMixedInstancesPolicy;
        }

        @Generated
        public EventMetadata getMetadata() {
            return this.metadata;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModifyServerGroupLaunchTemplateCommand)) {
                return false;
            }
            ModifyServerGroupLaunchTemplateCommand other = (ModifyServerGroupLaunchTemplateCommand)o;
            Boolean this$isReqToModifyLaunchTemplate = this.getIsReqToModifyLaunchTemplate();
            Boolean other$isReqToModifyLaunchTemplate = other.getIsReqToModifyLaunchTemplate();
            if (this$isReqToModifyLaunchTemplate == null ? other$isReqToModifyLaunchTemplate != null : !((Object)this$isReqToModifyLaunchTemplate).equals(other$isReqToModifyLaunchTemplate)) {
                return false;
            }
            Boolean this$isReqToUpgradeAsgToMixedInstancesPolicy = this.getIsReqToUpgradeAsgToMixedInstancesPolicy();
            Boolean other$isReqToUpgradeAsgToMixedInstancesPolicy = other.getIsReqToUpgradeAsgToMixedInstancesPolicy();
            if (this$isReqToUpgradeAsgToMixedInstancesPolicy == null ? other$isReqToUpgradeAsgToMixedInstancesPolicy != null : !((Object)this$isReqToUpgradeAsgToMixedInstancesPolicy).equals(other$isReqToUpgradeAsgToMixedInstancesPolicy)) {
                return false;
            }
            Boolean this$isAsgBackedByMixedInstancesPolicy = this.getIsAsgBackedByMixedInstancesPolicy();
            Boolean other$isAsgBackedByMixedInstancesPolicy = other.getIsAsgBackedByMixedInstancesPolicy();
            if (this$isAsgBackedByMixedInstancesPolicy == null ? other$isAsgBackedByMixedInstancesPolicy != null : !((Object)this$isAsgBackedByMixedInstancesPolicy).equals(other$isAsgBackedByMixedInstancesPolicy)) {
                return false;
            }
            LaunchTemplateVersion this$sourceVersion = this.getSourceVersion();
            LaunchTemplateVersion other$sourceVersion = other.getSourceVersion();
            if (this$sourceVersion == null ? other$sourceVersion != null : !this$sourceVersion.equals(other$sourceVersion)) {
                return false;
            }
            ModifyServerGroupLaunchTemplateDescription this$description = this.getDescription();
            ModifyServerGroupLaunchTemplateDescription other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            EventMetadata this$metadata = this.getMetadata();
            EventMetadata other$metadata = other.getMetadata();
            return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isReqToModifyLaunchTemplate = this.getIsReqToModifyLaunchTemplate();
            result = result * 59 + ($isReqToModifyLaunchTemplate == null ? 43 : ((Object)$isReqToModifyLaunchTemplate).hashCode());
            Boolean $isReqToUpgradeAsgToMixedInstancesPolicy = this.getIsReqToUpgradeAsgToMixedInstancesPolicy();
            result = result * 59 + ($isReqToUpgradeAsgToMixedInstancesPolicy == null ? 43 : ((Object)$isReqToUpgradeAsgToMixedInstancesPolicy).hashCode());
            Boolean $isAsgBackedByMixedInstancesPolicy = this.getIsAsgBackedByMixedInstancesPolicy();
            result = result * 59 + ($isAsgBackedByMixedInstancesPolicy == null ? 43 : ((Object)$isAsgBackedByMixedInstancesPolicy).hashCode());
            LaunchTemplateVersion $sourceVersion = this.getSourceVersion();
            result = result * 59 + ($sourceVersion == null ? 43 : $sourceVersion.hashCode());
            ModifyServerGroupLaunchTemplateDescription $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            EventMetadata $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ModifyServerGroupLaunchTemplate.ModifyServerGroupLaunchTemplateCommand(sourceVersion=" + this.getSourceVersion() + ", description=" + this.getDescription() + ", isReqToModifyLaunchTemplate=" + this.getIsReqToModifyLaunchTemplate() + ", isReqToUpgradeAsgToMixedInstancesPolicy=" + this.getIsReqToUpgradeAsgToMixedInstancesPolicy() + ", isAsgBackedByMixedInstancesPolicy=" + this.getIsAsgBackedByMixedInstancesPolicy() + ", metadata=" + this.getMetadata() + ")";
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class ModifyServerGroupLaunchTemplateCommandBuilder {
            @Generated
            private LaunchTemplateVersion sourceVersion;
            @Generated
            private ModifyServerGroupLaunchTemplateDescription description;
            @Generated
            private Boolean isReqToModifyLaunchTemplate;
            @Generated
            private Boolean isReqToUpgradeAsgToMixedInstancesPolicy;
            @Generated
            private Boolean isAsgBackedByMixedInstancesPolicy;
            @Generated
            private EventMetadata metadata;

            @Generated
            ModifyServerGroupLaunchTemplateCommandBuilder() {
            }

            @Generated
            public ModifyServerGroupLaunchTemplateCommandBuilder sourceVersion(@Nonnull LaunchTemplateVersion sourceVersion) {
                this.sourceVersion = sourceVersion;
                return this;
            }

            @Generated
            public ModifyServerGroupLaunchTemplateCommandBuilder description(@Nonnull ModifyServerGroupLaunchTemplateDescription description) {
                this.description = description;
                return this;
            }

            @Generated
            public ModifyServerGroupLaunchTemplateCommandBuilder isReqToModifyLaunchTemplate(@Nonnull Boolean isReqToModifyLaunchTemplate) {
                this.isReqToModifyLaunchTemplate = isReqToModifyLaunchTemplate;
                return this;
            }

            @Generated
            public ModifyServerGroupLaunchTemplateCommandBuilder isReqToUpgradeAsgToMixedInstancesPolicy(@Nonnull Boolean isReqToUpgradeAsgToMixedInstancesPolicy) {
                this.isReqToUpgradeAsgToMixedInstancesPolicy = isReqToUpgradeAsgToMixedInstancesPolicy;
                return this;
            }

            @Generated
            public ModifyServerGroupLaunchTemplateCommandBuilder isAsgBackedByMixedInstancesPolicy(@Nonnull Boolean isAsgBackedByMixedInstancesPolicy) {
                this.isAsgBackedByMixedInstancesPolicy = isAsgBackedByMixedInstancesPolicy;
                return this;
            }

            @Generated
            public ModifyServerGroupLaunchTemplateCommandBuilder metadata(EventMetadata metadata) {
                this.metadata = metadata;
                return this;
            }

            @Generated
            public ModifyServerGroupLaunchTemplateCommand build() {
                return new ModifyServerGroupLaunchTemplateCommand(this.sourceVersion, this.description, this.isReqToModifyLaunchTemplate, this.isReqToUpgradeAsgToMixedInstancesPolicy, this.isAsgBackedByMixedInstancesPolicy, this.metadata);
            }

            @Generated
            public String toString() {
                return "ModifyServerGroupLaunchTemplate.ModifyServerGroupLaunchTemplateCommand.ModifyServerGroupLaunchTemplateCommandBuilder(sourceVersion=" + this.sourceVersion + ", description=" + this.description + ", isReqToModifyLaunchTemplate=" + this.isReqToModifyLaunchTemplate + ", isReqToUpgradeAsgToMixedInstancesPolicy=" + this.isReqToUpgradeAsgToMixedInstancesPolicy + ", isAsgBackedByMixedInstancesPolicy=" + this.isAsgBackedByMixedInstancesPolicy + ", metadata=" + this.metadata + ")";
            }
        }
    }
}

