/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.event;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksRequest;
import com.amazonaws.services.autoscaling.model.LifecycleHook;
import com.netflix.spinnaker.clouddriver.aws.event.AfterResizeEvent;
import com.netflix.spinnaker.clouddriver.aws.event.AfterResizeEventHandler;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAfterResizeEventHandler
implements AfterResizeEventHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void handle(AfterResizeEvent event) {
        AutoScalingGroup autoScalingGroup = event.getAutoScalingGroup();
        if (event.getCapacity() == null || event.getCapacity().getDesired() == null) {
            return;
        }
        if (event.getCapacity().getDesired() > 0) {
            return;
        }
        if (!autoScalingGroup.getLoadBalancerNames().isEmpty() || !autoScalingGroup.getTargetGroupARNs().isEmpty()) {
            event.getTask().updateStatus("RESIZE", "Skipping explicit instance termination, server group is attached to one or more load balancers");
            return;
        }
        try {
            List<LifecycleHook> existingLifecycleHooks = DefaultAfterResizeEventHandler.fetchTerminatingLifecycleHooks(event.getAmazonAutoScaling(), autoScalingGroup.getAutoScalingGroupName());
            if (!existingLifecycleHooks.isEmpty()) {
                event.getTask().updateStatus("RESIZE", "Skipping explicit instance termination, server group has one or more lifecycle hooks");
                return;
            }
        }
        catch (Exception e) {
            this.log.error("Unable to fetch lifecycle hooks (serverGroupName: {}, arn: {})", new Object[]{autoScalingGroup.getAutoScalingGroupName(), autoScalingGroup.getAutoScalingGroupARN(), e});
            event.getTask().updateStatus("RESIZE", String.format("Skipping explicit instance termination, unable to fetch lifecycle hooks (reason: '%s')", e.getMessage()));
            return;
        }
        this.terminateInstancesInAutoScalingGroup(event.getTask(), event.getAmazonEC2(), event.getAutoScalingGroup());
    }

    private static List<LifecycleHook> fetchTerminatingLifecycleHooks(AmazonAutoScaling amazonAutoScaling, String serverGroupName) {
        DescribeLifecycleHooksRequest request = new DescribeLifecycleHooksRequest().withAutoScalingGroupName(serverGroupName);
        return amazonAutoScaling.describeLifecycleHooks(request).getLifecycleHooks().stream().filter(h -> "autoscaling:EC2_INSTANCE_TERMINATING".equalsIgnoreCase(h.getLifecycleTransition())).collect(Collectors.toList());
    }
}

