/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.lifecycle;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.aws.lifecycle.InstanceTerminationConfigurationProperties;
import com.netflix.spinnaker.clouddriver.aws.lifecycle.LaunchFailureConfigurationProperties;
import com.netflix.spinnaker.clouddriver.aws.lifecycle.LaunchFailureNotificationAgentProvider;
import com.netflix.spinnaker.clouddriver.aws.lifecycle.LaunchFailureNotificationCleanupAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.tags.EntityTagger;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={LaunchFailureConfigurationProperties.class, InstanceTerminationConfigurationProperties.class})
class LifecycleSubscriberConfiguration {
    LifecycleSubscriberConfiguration() {
    }

    @Bean
    @ConditionalOnProperty(value={"aws.lifecycle-subscribers.launch-failure.enabled"})
    LaunchFailureNotificationAgentProvider launchFailureNotificationAgentProvider(@Qualifier(value="amazonObjectMapper") ObjectMapper objectMapper, AmazonClientProvider amazonClientProvider, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository, LaunchFailureConfigurationProperties properties, EntityTagger entityTagger, AwsProvider awsProvider) {
        awsProvider.addAgents(new ArrayList<LaunchFailureNotificationCleanupAgent>(Collections.singletonList(new LaunchFailureNotificationCleanupAgent(amazonClientProvider, credentialsRepository, entityTagger))));
        return new LaunchFailureNotificationAgentProvider(objectMapper, amazonClientProvider, credentialsRepository, properties, entityTagger);
    }
}

