/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(value="aws.caching.filter")
public class AmazonCachingAgentFilter {
    List<TagFilterOption> includeTags;
    List<TagFilterOption> excludeTags;

    public List<TagFilterOption> getIncludeTags() {
        return this.includeTags;
    }

    public void setIncludeTags(List<TagFilterOption> includeTags) {
        this.includeTags = includeTags;
    }

    public List<TagFilterOption> getExcludeTags() {
        return this.excludeTags;
    }

    public void setExcludeTags(List<TagFilterOption> excludeTags) {
        this.excludeTags = excludeTags;
    }

    public boolean hasTagFilter() {
        return this.hasIncludeTagFilter() || this.hasExcludeTagFilter();
    }

    public boolean hasIncludeTagFilter() {
        return this.includeTags != null && this.includeTags.size() > 0;
    }

    public boolean hasExcludeTagFilter() {
        return this.excludeTags != null && this.excludeTags.size() > 0;
    }

    public boolean shouldRetainResource(List<ResourceTag> tags) {
        boolean retainResource;
        boolean bl = retainResource = !this.hasIncludeTagFilter();
        if (tags == null || tags.size() == 0) {
            return retainResource;
        }
        if (this.hasIncludeTagFilter()) {
            retainResource = this.includeTags.stream().anyMatch(filter -> tags.stream().anyMatch(tag -> this.tagFilterOptionMatchesResourceTag((TagFilterOption)filter, (ResourceTag)tag)));
        }
        if (retainResource && this.hasExcludeTagFilter()) {
            retainResource = this.excludeTags.stream().noneMatch(filter -> tags.stream().anyMatch(tag -> this.tagFilterOptionMatchesResourceTag((TagFilterOption)filter, (ResourceTag)tag)));
        }
        return retainResource;
    }

    private boolean tagFilterOptionMatchesResourceTag(TagFilterOption tagFilterOption, ResourceTag resourceTag) {
        if (resourceTag.key == null || !resourceTag.key.matches(tagFilterOption.name)) {
            return false;
        }
        return StringUtils.isEmpty((CharSequence)tagFilterOption.getValue()) || resourceTag.value != null && resourceTag.value.matches(tagFilterOption.value);
    }

    public static class ResourceTag {
        final String key;
        final String value;

        public ResourceTag(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class TagFilterOption {
        String name;
        String value;

        public TagFilterOption() {
        }

        public TagFilterOption(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

