/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.AmazonCloudFormationException;
import com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest;
import com.amazonaws.services.cloudformation.model.DescribeChangeSetResult;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.ListChangeSetsRequest;
import com.amazonaws.services.cloudformation.model.ListChangeSetsResult;
import com.amazonaws.services.cloudformation.model.Output;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.StackEvent;
import com.amazonaws.services.cloudformation.model.Tag;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.AgentIntervalAware;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.aws.cache.Keys;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsInfrastructureProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.cache.OnDemandAgent;
import com.netflix.spinnaker.clouddriver.cache.OnDemandMetricsSupport;
import com.netflix.spinnaker.clouddriver.cache.OnDemandType;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AmazonCloudFormationCachingAgent
implements CachingAgent,
OnDemandAgent,
AccountAware,
AgentIntervalAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AmazonCloudFormationCachingAgent.class);
    private final AmazonClientProvider amazonClientProvider;
    private final NetflixAmazonCredentials account;
    private final String region;
    private final OnDemandMetricsSupport metricsSupport;
    protected static final String ON_DEMAND_TYPE = "onDemand";
    static final Set<AgentDataType> types = new HashSet<AgentDataType>(Collections.singletonList(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.STACKS.getNs())));

    public AmazonCloudFormationCachingAgent(AmazonClientProvider amazonClientProvider, NetflixAmazonCredentials account, String region, Registry registry) {
        this.amazonClientProvider = amazonClientProvider;
        this.account = account;
        this.region = region;
        this.metricsSupport = new OnDemandMetricsSupport(registry, (OnDemandAgent)this, String.format("%s:%s", "aws", OnDemandType.CloudFormation));
    }

    public String getProviderName() {
        return AwsInfrastructureProvider.PROVIDER_NAME;
    }

    public String getOnDemandAgentType() {
        return this.getAgentType();
    }

    public OnDemandMetricsSupport getMetricsSupport() {
        return this.metricsSupport;
    }

    public boolean handles(OnDemandType type, String cloudProvider) {
        return OnDemandType.CloudFormation.equals((Object)type) && cloudProvider.equals("aws");
    }

    public OnDemandAgent.OnDemandResult handle(ProviderCache providerCache, Map<String, ?> data) {
        if (this.shouldHandle(data)) {
            log.info("Updating CloudFormation cache for account: {} and region: {}", (Object)this.account.getName(), (Object)this.region);
            DescribeStacksRequest describeStacksRequest = Optional.ofNullable((String)data.get("stackName")).map(stackName -> new DescribeStacksRequest().withStackName(stackName)).orElse(new DescribeStacksRequest());
            CacheResult result = this.queryStacks(providerCache, describeStacksRequest, true);
            Collection keys = ((Collection)result.getCacheResults().get("stacks")).stream().map(cachedata -> cachedata.getId()).collect(Collectors.toList());
            keys.forEach(key -> {
                DefaultCacheData cacheData = new DefaultCacheData(key, (int)Duration.ofMinutes(10L).getSeconds(), (Map)ImmutableMap.of((Object)"cacheTime", (Object)System.currentTimeMillis(), (Object)"cacheResults", (Object)result, (Object)"processedCount", (Object)0), (Map)ImmutableMap.of());
                providerCache.putCacheData(Namespace.ON_DEMAND.getNs(), (CacheData)cacheData);
            });
            return new OnDemandAgent.OnDemandResult(this.getOnDemandAgentType(), result, Collections.emptyMap());
        }
        return null;
    }

    private boolean shouldHandle(Map<String, ?> data) {
        String credentials = (String)data.get("credentials");
        List region = (List)data.get("region");
        return data.isEmpty() || this.account.getName().equals(credentials) && region != null && region.contains(this.region);
    }

    public Collection<Map<String, Object>> pendingOnDemandRequests(ProviderCache providerCache) {
        Collection ownedKeys = providerCache.filterIdentifiers(Namespace.ON_DEMAND.getNs(), Keys.getCloudFormationKey("*", this.region, this.getAccountName()));
        Collection onDemandEntriesToReturn = (Collection)providerCache.getAll(Namespace.ON_DEMAND.getNs(), ownedKeys).stream().map(cacheData -> {
            HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
            map.put("details", Keys.parse(cacheData.getId()));
            map.put("moniker", (Map<String, String>)cacheData.getAttributes().get("moniker"));
            map.put("cacheTime", (Map<String, String>)cacheData.getAttributes().get("cacheTime"));
            map.put("processedCount", (Map<String, String>)cacheData.getAttributes().get("processedCount"));
            map.put("processedTime", (Map<String, String>)cacheData.getAttributes().get("processedTime"));
            return map;
        }).collect(ImmutableList.toImmutableList());
        return onDemandEntriesToReturn;
    }

    public String getAgentType() {
        return String.format("%s/%s/%s", this.account.getName(), this.region, AmazonCloudFormationCachingAgent.class.getSimpleName());
    }

    public String getAccountName() {
        return this.account.getName();
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return types;
    }

    public CacheResult loadData(ProviderCache providerCache) {
        log.info(this.getAgentType() + ": agent is starting");
        ArrayList keepInOnDemand = new ArrayList();
        ArrayList evictFromOnDemand = new ArrayList();
        Long start = System.currentTimeMillis();
        CacheResult stacks = this.queryStacks(providerCache, new DescribeStacksRequest(), false);
        Collection keys = ((Collection)stacks.getCacheResults().get("stacks")).stream().map(cachedata -> cachedata.getId()).collect(Collectors.toList());
        Collection onDemandEntries = providerCache.getAll(Namespace.ON_DEMAND.getNs(), keys);
        if (!CollectionUtils.isEmpty((Collection)onDemandEntries)) {
            onDemandEntries.forEach(cacheData -> {
                long cacheTime = (Long)cacheData.getAttributes().get("cacheTime");
                if (cacheTime < start && (Integer)cacheData.getAttributes().get("processedCount") > 0) {
                    evictFromOnDemand.add(cacheData.getId());
                } else {
                    keepInOnDemand.add(cacheData.getId());
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)(onDemandEntries = providerCache.getAll(Namespace.ON_DEMAND.getNs(), keepInOnDemand)))) {
            providerCache.getAll(Namespace.ON_DEMAND.getNs(), keepInOnDemand).forEach(cacheData -> {
                cacheData.getAttributes().put("processedTime", System.currentTimeMillis());
                int processedCount = (Integer)cacheData.getAttributes().get("processedCount");
                cacheData.getAttributes().put("processedCount", processedCount + 1);
                providerCache.putCacheData(Namespace.ON_DEMAND.getNs(), cacheData);
            });
        }
        providerCache.evictDeletedItems(Namespace.ON_DEMAND.getNs(), evictFromOnDemand);
        return stacks;
    }

    public CacheResult queryStacks(ProviderCache providerCache, DescribeStacksRequest describeStacksRequest, boolean isPartialResult) {
        log.info("Describing items in {}, partial result: {}", (Object)this.getAgentType(), (Object)isPartialResult);
        AmazonCloudFormation cloudformation = this.amazonClientProvider.getAmazonCloudFormation(this.account, this.region);
        ArrayList<DefaultCacheData> stackCacheData = new ArrayList<DefaultCacheData>();
        try {
            while (true) {
                DescribeStacksResult describeStacksResult = cloudformation.describeStacks(describeStacksRequest);
                List stacks = describeStacksResult.getStacks();
                for (Stack stack : stacks) {
                    Map<String, Object> stackAttributes = this.getStackAttributes(stack, cloudformation);
                    String stackCacheKey = Keys.getCloudFormationKey(stack.getStackId(), this.region, this.account.getName());
                    HashMap<String, List<String>> relationships = new HashMap<String, List<String>>();
                    relationships.put(Keys.Namespace.STACKS.getNs(), Collections.singletonList(stackCacheKey));
                    stackCacheData.add(new DefaultCacheData(stackCacheKey, stackAttributes, relationships));
                }
                if (describeStacksResult.getNextToken() != null) {
                    describeStacksRequest.withNextToken(describeStacksResult.getNextToken());
                    continue;
                }
                break;
            }
        }
        catch (AmazonCloudFormationException e) {
            log.error("Error retrieving stacks", (Throwable)e);
        }
        log.info("Caching {} items in {}", (Object)stackCacheData.size(), (Object)this.getAgentType());
        HashMap<String, ArrayList<DefaultCacheData>> result = new HashMap<String, ArrayList<DefaultCacheData>>();
        result.put(Keys.Namespace.STACKS.getNs(), stackCacheData);
        return new DefaultCacheResult(result, isPartialResult);
    }

    private Map<String, Object> getStackAttributes(Stack stack, AmazonCloudFormation cloudformation) {
        HashMap<String, Object> stackAttributes = new HashMap<String, Object>();
        stackAttributes.put("stackId", stack.getStackId());
        stackAttributes.put("tags", stack.getTags().stream().collect(Collectors.toMap(Tag::getKey, Tag::getValue)));
        stackAttributes.put("outputs", stack.getOutputs().stream().collect(Collectors.toMap(Output::getOutputKey, Output::getOutputValue)));
        stackAttributes.put("stackName", stack.getStackName());
        stackAttributes.put("region", this.region);
        stackAttributes.put("accountName", this.account.getName());
        stackAttributes.put("accountId", this.account.getAccountId());
        stackAttributes.put("stackStatus", stack.getStackStatus());
        stackAttributes.put("creationTime", stack.getCreationTime());
        stackAttributes.put("changeSets", this.getChangeSets(stack, cloudformation));
        this.getStackStatusReason(stack, cloudformation).map(statusReason -> stackAttributes.put("stackStatusReason", statusReason));
        return stackAttributes;
    }

    private List<Map<String, Object>> getChangeSets(Stack stack, AmazonCloudFormation cloudformation) {
        ListChangeSetsRequest listChangeSetsRequest = new ListChangeSetsRequest().withStackName(stack.getStackName());
        ArrayList<Map<String, Object>> changeSets = new ArrayList<Map<String, Object>>();
        while (true) {
            ListChangeSetsResult listChangeSetsResult = cloudformation.listChangeSets(listChangeSetsRequest);
            changeSets.addAll(listChangeSetsResult.getSummaries().stream().map(summary -> {
                HashMap<String, Object> changeSetAttributes = new HashMap<String, Object>();
                changeSetAttributes.put("name", summary.getChangeSetName());
                changeSetAttributes.put("status", summary.getStatus());
                changeSetAttributes.put("statusReason", summary.getStatusReason());
                DescribeChangeSetRequest describeChangeSetRequest = new DescribeChangeSetRequest().withChangeSetName(summary.getChangeSetName()).withStackName(stack.getStackName());
                DescribeChangeSetResult describeChangeSetResult = cloudformation.describeChangeSet(describeChangeSetRequest);
                changeSetAttributes.put("changes", describeChangeSetResult.getChanges());
                log.debug("Adding change set attributes for stack {}: {}", (Object)stack.getStackName(), changeSetAttributes);
                return changeSetAttributes;
            }).collect(Collectors.toList()));
            if (listChangeSetsResult.getNextToken() == null) break;
            listChangeSetsRequest.withNextToken(listChangeSetsResult.getNextToken());
        }
        return changeSets;
    }

    private Optional<String> getStackStatusReason(Stack stack, AmazonCloudFormation cloudformation) {
        if (stack.getStackStatus().endsWith("ROLLBACK_COMPLETE")) {
            DescribeStackEventsRequest request = new DescribeStackEventsRequest().withStackName(stack.getStackName());
            return cloudformation.describeStackEvents(request).getStackEvents().stream().filter(e -> e.getResourceStatus().endsWith("FAILED")).findFirst().map(StackEvent::getResourceStatusReason);
        }
        return Optional.empty();
    }

    public Long getAgentInterval() {
        return 60000L;
    }
}

