/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.aws.data.Keys;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonImage;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonServerGroup;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import com.netflix.spinnaker.clouddriver.model.Image;
import com.netflix.spinnaker.clouddriver.model.ImageProvider;
import com.netflix.spinnaker.config.AwsConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class AmazonImageProvider
implements ImageProvider {
    private final Cache cacheView;
    private final AwsConfiguration.AmazonServerGroupProvider amazonServerGroupProvider;
    private final ObjectMapper objectMapper;

    @Autowired
    AmazonImageProvider(Cache cacheView, AwsConfiguration.AmazonServerGroupProvider amazonServerGroupProvider, @Qualifier(value="amazonObjectMapper") ObjectMapper objectMapper) {
        this.cacheView = cacheView;
        this.amazonServerGroupProvider = amazonServerGroupProvider;
        this.objectMapper = objectMapper;
    }

    public Optional<Image> getImageById(String imageId) {
        if (!imageId.startsWith("ami-")) {
            throw new RuntimeException("Image Id provided (" + imageId + ") is not a valid id for the provider " + this.getCloudProvider());
        }
        ArrayList imageIdList = new ArrayList(this.cacheView.filterIdentifiers(Namespace.IMAGES.toString(), "*" + imageId));
        if (imageIdList.isEmpty()) {
            return Optional.empty();
        }
        ArrayList imageCacheList = new ArrayList(this.cacheView.getAll(Namespace.IMAGES.toString(), imageIdList));
        AmazonImage image = (AmazonImage)this.objectMapper.convertValue((Object)((CacheData)imageCacheList.get(0)).getAttributes(), AmazonImage.class);
        image.setRegion(Keys.parse(((CacheData)imageCacheList.get(0)).getId()).get("region"));
        List<AmazonServerGroup> serverGroupList = imageCacheList.stream().filter(imageCache -> imageCache.getRelationships().get(Namespace.SERVER_GROUPS.toString()) != null).map(imageCache -> (Collection)imageCache.getRelationships().get(Namespace.SERVER_GROUPS.toString())).flatMap(Collection::stream).map(this::getServerGroupData).filter(Objects::nonNull).collect(Collectors.toList());
        image.setServerGroups(serverGroupList);
        return Optional.of(image);
    }

    public String getCloudProvider() {
        return "aws";
    }

    private AmazonServerGroup getServerGroupData(String serverGroupCacheKey) {
        Map<String, String> parsedServerGroupKey = Keys.parse(serverGroupCacheKey);
        return this.amazonServerGroupProvider.getServerGroup(parsedServerGroupKey.get("account"), parsedServerGroupKey.get("region"), parsedServerGroupKey.get("serverGroup"));
    }
}

