/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="aws.proxy")
@Component
public class AWSProxy {
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String proxyDomain;
    private String proxyWorkstation;
    private String protocol;

    public AWSProxy() {
        this(null, null, null, null, null, null, null);
    }

    public AWSProxy(String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, String protocol) {
        this(proxyHost, proxyPort, proxyUsername, proxyPassword, null, null, protocol);
    }

    public AWSProxy(String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, String proxyDomain, String proxyWorkstation, String protocol) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyDomain = proxyDomain;
        this.proxyWorkstation = proxyWorkstation;
        this.proxyPassword = proxyPassword;
        this.protocol = protocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String proxyDomain) {
        this.proxyDomain = proxyDomain;
    }

    public String getProxyWorkstation() {
        return this.proxyWorkstation;
    }

    public void setProxyWorkstation(String proxyWorkstation) {
        this.proxyWorkstation = proxyWorkstation;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProxyProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void apply(ClientConfiguration clientConfiguration) {
        clientConfiguration.setProxyHost(this.proxyHost);
        clientConfiguration.setProxyPort(Integer.parseInt(this.proxyPort));
        clientConfiguration.setProxyUsername(this.proxyUsername);
        clientConfiguration.setProxyPassword(this.proxyPassword);
        Protocol awsProtocol = Protocol.HTTP;
        if ("HTTPS".equalsIgnoreCase(this.protocol)) {
            awsProtocol = Protocol.HTTPS;
        }
        clientConfiguration.setProtocol(awsProtocol);
        if (this.isNTLMProxy()) {
            clientConfiguration.setProxyDomain(this.proxyDomain);
            clientConfiguration.setProxyWorkstation(this.proxyWorkstation);
        }
    }

    public boolean isNTLMProxy() {
        boolean isNTLMProxy = false;
        if (this.getProxyHost() != null && this.getProxyPort() != null && this.getProxyDomain() != null && this.getProxyWorkstation() != null) {
            isNTLMProxy = true;
        }
        return isNTLMProxy;
    }

    public boolean isProxyConfigMode() {
        boolean isProxy = false;
        if (this.getProxyHost() != null && this.getProxyPort() != null) {
            isProxy = true;
            try {
                Integer.parseInt(this.getProxyPort());
            }
            catch (NumberFormatException nfe) {
                isProxy = false;
            }
        }
        return isProxy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSProxy awsProxy = (AWSProxy)o;
        return this.proxyHost.equals(awsProxy.proxyHost) && this.proxyPort.equals(awsProxy.proxyPort) && this.protocol.equals(awsProxy.protocol);
    }

    public int hashCode() {
        int result = this.proxyHost.hashCode();
        result = 31 * result + this.proxyPort.hashCode() + this.protocol.hashCode();
        return result;
    }
}

