/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security;

import com.amazonaws.regions.Regions;
import com.amazonaws.util.CollectionUtils;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.spinnaker.clouddriver.aws.security.DefaultAccountConfigurationProperties;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.config.AccountsConfiguration;
import com.netflix.spinnaker.clouddriver.aws.security.config.AmazonCredentialsParser;
import com.netflix.spinnaker.clouddriver.aws.security.config.CredentialsConfig;
import com.netflix.spinnaker.credentials.Credentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.credentials.definition.BasicCredentialsLoader;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinition;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinitionSource;
import com.netflix.spinnaker.credentials.definition.CredentialsParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonBasicCredentialsLoader<T extends AccountsConfiguration.Account, U extends NetflixAmazonCredentials>
extends BasicCredentialsLoader<T, U> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AmazonBasicCredentialsLoader.class);
    protected final CredentialsConfig credentialsConfig;
    protected final AccountsConfiguration accountsConfig;
    protected final DefaultAccountConfigurationProperties defaultAccountConfigurationProperties;
    protected String defaultEnvironment;
    protected String defaultAccountType;

    public AmazonBasicCredentialsLoader(CredentialsDefinitionSource<T> definitionSource, CredentialsParser<T, U> parser, CredentialsRepository<U> credentialsRepository, CredentialsConfig credentialsConfig, AccountsConfiguration accountsConfig, DefaultAccountConfigurationProperties defaultAccountConfigurationProperties) {
        super(definitionSource, parser, credentialsRepository);
        this.credentialsConfig = credentialsConfig;
        this.accountsConfig = accountsConfig;
        this.defaultAccountConfigurationProperties = defaultAccountConfigurationProperties;
        this.defaultEnvironment = defaultAccountConfigurationProperties.getEnvironment() != null ? defaultAccountConfigurationProperties.getEnvironment() : defaultAccountConfigurationProperties.getEnv();
        String string = this.defaultAccountType = defaultAccountConfigurationProperties.getAccountType() != null ? defaultAccountConfigurationProperties.getAccountType() : defaultAccountConfigurationProperties.getEnv();
        if (!StringUtils.isEmpty((CharSequence)credentialsConfig.getAccessKeyId())) {
            System.setProperty("aws.accessKeyId", credentialsConfig.getAccessKeyId());
        }
        if (!StringUtils.isEmpty((CharSequence)credentialsConfig.getSecretAccessKey())) {
            System.setProperty("aws.secretKey", credentialsConfig.getSecretAccessKey());
        }
    }

    public void load() {
        if (CollectionUtils.isNullOrEmpty(this.accountsConfig.getAccounts()) && StringUtils.isEmpty((CharSequence)this.credentialsConfig.getDefaultAssumeRole())) {
            this.accountsConfig.setAccounts(Collections.singletonList(new AccountsConfiguration.Account(){
                {
                    this.setName(AmazonBasicCredentialsLoader.this.defaultAccountConfigurationProperties.getEnv());
                    this.setEnvironment(AmazonBasicCredentialsLoader.this.defaultEnvironment);
                    this.setAccountType(AmazonBasicCredentialsLoader.this.defaultAccountType);
                }
            }));
            if (CollectionUtils.isNullOrEmpty(this.credentialsConfig.getDefaultRegions())) {
                ArrayList<Regions> regions = new ArrayList<Regions>(Arrays.asList(Regions.US_EAST_1, Regions.US_WEST_1, Regions.US_WEST_2, Regions.EU_WEST_1));
                this.credentialsConfig.setDefaultRegions(regions.stream().map(it -> new CredentialsConfig.Region((Regions)it){
                    final /* synthetic */ Regions val$it;
                    {
                        this.val$it = regions;
                        this.setName(this.val$it.getName());
                    }
                }).collect(Collectors.toList()));
            }
        }
        this.parse(this.definitionSource.getCredentialsDefinitions());
    }

    protected void parse(Collection<T> definitions) {
        log.info("attempting to parse {} amazon accounts provided as input", (Object)definitions.size());
        Set definitionNames = definitions.stream().map(AccountsConfiguration.Account::getName).collect(Collectors.toSet());
        log.info("removing all the accounts from the credentials repository that are not present in the provided input");
        this.credentialsRepository.getAll().stream().map(Credentials::getName).filter(name -> !definitionNames.contains(name)).peek(this.loadedDefinitions::remove).forEach(arg_0 -> ((CredentialsRepository)this.credentialsRepository).delete(arg_0));
        if (definitionNames.size() == 0) {
            log.info("did not find any aws account definitions to parse");
            return;
        }
        List<Object> toApply = new ArrayList();
        if (this.credentialsConfig.getLoadAccounts().isMultiThreadingEnabled()) {
            log.info("Multi-threading is enabled for loading aws accounts. Using {} threads, with timeout: {}s", (Object)this.credentialsConfig.getLoadAccounts().getNumberOfThreads(), (Object)this.credentialsConfig.getLoadAccounts().getTimeoutInSeconds());
            toApply = this.multiThreadedParseAccounts(definitions);
        } else {
            log.info("Multi-threading is disabled. AWS accounts will be loaded serially");
            for (AccountsConfiguration.Account definition : definitions) {
                NetflixAmazonCredentials cred;
                if (!this.loadedDefinitions.containsKey(definition.getName())) {
                    cred = (NetflixAmazonCredentials)this.parser.parse((CredentialsDefinition)definition);
                    if (cred == null) continue;
                    toApply.add((Object)cred);
                    this.loadedDefinitions.put(definition.getName(), definition);
                    continue;
                }
                if (((AccountsConfiguration.Account)this.loadedDefinitions.get(definition.getName())).equals(definition) || (cred = (NetflixAmazonCredentials)this.parser.parse((CredentialsDefinition)definition)) == null) continue;
                toApply.add((Object)cred);
                this.loadedDefinitions.put(definition.getName(), definition);
            }
        }
        log.info("saving aws accounts in the credentials repository");
        Stream stream = this.parallel ? toApply.parallelStream() : toApply.stream();
        stream.forEach(arg_0 -> ((CredentialsRepository)this.credentialsRepository).save(arg_0));
        log.info("parsed and saved {} aws accounts", (Object)this.credentialsRepository.getAll().size());
    }

    private List<U> multiThreadedParseAccounts(Collection<T> definitions) {
        ArrayList<NetflixAmazonCredentials> toApply = new ArrayList<NetflixAmazonCredentials>();
        ExecutorService executorService = Executors.newFixedThreadPool(this.credentialsConfig.getLoadAccounts().getNumberOfThreads(), new ThreadFactoryBuilder().setNameFormat(AmazonCredentialsParser.class.getSimpleName() + "-%d").build());
        ArrayList<Future<NetflixAmazonCredentials>> futures = new ArrayList<Future<NetflixAmazonCredentials>>(definitions.size());
        for (AccountsConfiguration.Account account : definitions) {
            if (this.loadedDefinitions.containsKey(account.getName()) && ((AccountsConfiguration.Account)this.loadedDefinitions.get(account.getName())).equals(account)) continue;
            futures.add(executorService.submit(() -> (NetflixAmazonCredentials)this.parser.parse((CredentialsDefinition)definition2)));
        }
        for (Future future : futures) {
            try {
                NetflixAmazonCredentials cred = (NetflixAmazonCredentials)((Object)future.get(this.credentialsConfig.getLoadAccounts().getTimeoutInSeconds(), TimeUnit.SECONDS));
                if (cred == null) continue;
                toApply.add(cred);
                definitions.stream().filter(t -> t.getName().equals(cred.getName())).findFirst().ifPresentOrElse(definition -> this.loadedDefinitions.put(cred.getName(), definition), () -> log.warn("could not find the parsed aws account: '{}' in the input credential definitions.", (Object)cred.getName()));
            }
            catch (Exception e) {
                log.error("Failed to load aws account: ", (Throwable)e);
            }
        }
        try {
            executorService.shutdownNow();
        }
        catch (Exception e) {
            log.error("Failed to shutdown the aws account loading executor service.", (Throwable)e);
        }
        return toApply;
    }
}

