/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.AgentProvider;
import com.netflix.spinnaker.clouddriver.aws.AmazonCloudProvider;
import com.netflix.spinnaker.clouddriver.aws.AwsConfigurationProperties;
import com.netflix.spinnaker.clouddriver.aws.edda.EddaApiFactory;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsCleanupProvider;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsInfrastructureProvider;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonCachingAgentFilter;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.ImageCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.ReservationReportCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.config.ProviderHelpers;
import com.netflix.spinnaker.clouddriver.aws.provider.view.AmazonS3DataProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.EddaTimeoutConfig;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.config.AwsConfiguration;
import com.netflix.spinnaker.credentials.CredentialsLifecycleHandler;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
public class AmazonCredentialsLifecycleHandler
implements CredentialsLifecycleHandler<NetflixAmazonCredentials> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AmazonCredentialsLifecycleHandler.class);
    private final AwsCleanupProvider awsCleanupProvider;
    private final AwsInfrastructureProvider awsInfrastructureProvider;
    private final AwsProvider awsProvider;
    private final AmazonCloudProvider amazonCloudProvider;
    private final AmazonClientProvider amazonClientProvider;
    private final AmazonS3DataProvider amazonS3DataProvider;
    private final AwsConfigurationProperties awsConfigurationProperties;
    private final ObjectMapper objectMapper;
    @Qualifier(value="amazonObjectMapper")
    private final ObjectMapper amazonObjectMapper;
    private final EddaApiFactory eddaApiFactory;
    private final ApplicationContext ctx;
    private final Registry registry;
    private final Optional<ExecutorService> reservationReportPool;
    private final Optional<Collection<AgentProvider>> agentProviders;
    private final EddaTimeoutConfig eddaTimeoutConfig;
    private final AmazonCachingAgentFilter amazonCachingAgentFilter;
    private final DynamicConfigService dynamicConfigService;
    private final AwsConfiguration.DeployDefaults deployDefaults;
    private final CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;
    protected Set<String> publicRegions = new HashSet<String>();
    protected Set<String> awsInfraRegions = new HashSet<String>();
    protected boolean reservationReportCachingAgentScheduled = false;
    protected boolean hasPreviouslyScheduledCleanupAgents = false;

    public void credentialsAdded(@NotNull NetflixAmazonCredentials credentials) {
        this.scheduleAgents(credentials);
        this.scheduleReservationReportCachingAgent();
    }

    public void credentialsUpdated(@NotNull NetflixAmazonCredentials credentials) {
        this.unscheduleAgents(credentials);
        this.scheduleAgents(credentials);
    }

    public void credentialsDeleted(@NotNull NetflixAmazonCredentials credentials) {
        this.replaceCurrentImageCachingAgent(credentials);
        this.unscheduleAgents(credentials);
    }

    private void replaceCurrentImageCachingAgent(NetflixAmazonCredentials credentials) {
        List currentImageCachingAgents = this.awsProvider.getAgents().stream().filter(agent -> agent.handlesAccount(credentials.getName()) && agent instanceof ImageCachingAgent && ((ImageCachingAgent)agent).getIncludePublicImages()).map(agent -> (ImageCachingAgent)agent).collect(Collectors.toList());
        for (ImageCachingAgent imageCachingAgent : currentImageCachingAgents) {
            NetflixAmazonCredentials replacementCredentials = this.credentialsRepository.getAll().stream().filter(cred -> !cred.getName().equals(credentials.getName())).filter(cred -> cred.getRegions().stream().map(AmazonCredentials.AWSRegion::getName).collect(Collectors.toSet()).contains(imageCachingAgent.getRegion())).findFirst().orElse(null);
            if (replacementCredentials != null) {
                this.awsProvider.addAgents(Collections.singletonList(new ImageCachingAgent(this.amazonClientProvider, replacementCredentials, imageCachingAgent.getRegion(), this.objectMapper, this.registry, true, this.dynamicConfigService)));
                continue;
            }
            this.publicRegions.remove(imageCachingAgent.getRegion());
        }
    }

    private void unscheduleAgents(NetflixAmazonCredentials credentials) {
        this.awsInfrastructureProvider.removeAgentsForAccounts(Collections.singleton(credentials.getName()));
        this.awsCleanupProvider.removeAgentsForAccounts(Collections.singleton(credentials.getName()));
        this.awsProvider.removeAgentsForAccounts(Collections.singleton(credentials.getName()));
    }

    private void scheduleAgents(NetflixAmazonCredentials credentials) {
        this.scheduleAWSProviderAgents(credentials);
        this.scheduleAwsInfrastructureProviderAgents(credentials);
        this.scheduleAwsCleanupAgents(credentials);
    }

    private void scheduleAwsInfrastructureProviderAgents(NetflixAmazonCredentials credentials) {
        ProviderHelpers.BuildResult result = ProviderHelpers.buildAwsInfrastructureAgents(credentials, this.awsInfrastructureProvider, this.credentialsRepository, this.amazonClientProvider, this.amazonObjectMapper, this.registry, this.eddaTimeoutConfig, this.awsInfraRegions);
        this.awsInfrastructureProvider.addAgents(result.getAgents());
        this.awsInfraRegions.addAll(result.getRegionsToAdd());
    }

    private void scheduleAWSProviderAgents(NetflixAmazonCredentials credentials) {
        ProviderHelpers.BuildResult buildResult = ProviderHelpers.buildAwsProviderAgents(credentials, this.credentialsRepository, this.amazonClientProvider, this.objectMapper, this.registry, this.eddaTimeoutConfig, this.amazonCachingAgentFilter, this.awsProvider, this.amazonCloudProvider, this.dynamicConfigService, this.eddaApiFactory, this.reservationReportPool, this.agentProviders, this.ctx, this.amazonS3DataProvider, this.publicRegions);
        this.awsProvider.addAgents(buildResult.getAgents());
        this.publicRegions.addAll(buildResult.getRegionsToAdd());
        this.awsProvider.synchronizeHealthAgents();
    }

    private void scheduleAwsCleanupAgents(NetflixAmazonCredentials credentials) {
        List<Agent> newlyAddedAgents = ProviderHelpers.buildAwsCleanupAgents(credentials, this.credentialsRepository, this.amazonClientProvider, this.awsCleanupProvider, this.deployDefaults, this.awsConfigurationProperties, this.hasPreviouslyScheduledCleanupAgents);
        this.awsCleanupProvider.addAgents(newlyAddedAgents);
        log.info("The following cleanup agents have been added: {} (awsCleanupProvider.getAgentScheduler: {})", newlyAddedAgents, (Object)this.awsCleanupProvider.getAgentScheduler());
        this.hasPreviouslyScheduledCleanupAgents = true;
    }

    private void scheduleReservationReportCachingAgent() {
        if (this.reservationReportPool.isPresent() && !this.reservationReportCachingAgentScheduled) {
            for (Agent agent : this.awsProvider.getAgents()) {
                if (!(agent instanceof ReservationReportCachingAgent)) continue;
                this.reservationReportCachingAgentScheduled = true;
                return;
            }
            this.awsProvider.addAgents(Collections.singleton(new ReservationReportCachingAgent(this.registry, this.amazonClientProvider, this.amazonS3DataProvider, this.credentialsRepository, this.objectMapper, this.reservationReportPool.get(), this.ctx)));
            this.reservationReportCachingAgentScheduled = true;
        }
    }

    @Generated
    public AmazonCredentialsLifecycleHandler(AwsCleanupProvider awsCleanupProvider, AwsInfrastructureProvider awsInfrastructureProvider, AwsProvider awsProvider, AmazonCloudProvider amazonCloudProvider, AmazonClientProvider amazonClientProvider, AmazonS3DataProvider amazonS3DataProvider, AwsConfigurationProperties awsConfigurationProperties, ObjectMapper objectMapper, ObjectMapper amazonObjectMapper, EddaApiFactory eddaApiFactory, ApplicationContext ctx, Registry registry, Optional<ExecutorService> reservationReportPool, Optional<Collection<AgentProvider>> agentProviders, EddaTimeoutConfig eddaTimeoutConfig, AmazonCachingAgentFilter amazonCachingAgentFilter, DynamicConfigService dynamicConfigService, AwsConfiguration.DeployDefaults deployDefaults, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository) {
        this.awsCleanupProvider = awsCleanupProvider;
        this.awsInfrastructureProvider = awsInfrastructureProvider;
        this.awsProvider = awsProvider;
        this.amazonCloudProvider = amazonCloudProvider;
        this.amazonClientProvider = amazonClientProvider;
        this.amazonS3DataProvider = amazonS3DataProvider;
        this.awsConfigurationProperties = awsConfigurationProperties;
        this.objectMapper = objectMapper;
        this.amazonObjectMapper = amazonObjectMapper;
        this.eddaApiFactory = eddaApiFactory;
        this.ctx = ctx;
        this.registry = registry;
        this.reservationReportPool = reservationReportPool;
        this.agentProviders = agentProviders;
        this.eddaTimeoutConfig = eddaTimeoutConfig;
        this.amazonCachingAgentFilter = amazonCachingAgentFilter;
        this.dynamicConfigService = dynamicConfigService;
        this.deployDefaults = deployDefaults;
        this.credentialsRepository = credentialsRepository;
    }
}

