/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.asg;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchTemplateRollOutConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LaunchTemplateRollOutConfig.class);
    private DynamicConfigService dynamicConfigService;

    public LaunchTemplateRollOutConfig(DynamicConfigService dynamicConfigService) {
        this.dynamicConfigService = dynamicConfigService;
    }

    public boolean isIpv6EnabledForEnv(String env) {
        return this.dynamicConfigService.isEnabled("aws.features.launch-templates.ipv6." + env, false);
    }

    public boolean shouldUseLaunchTemplateForReq(String applicationInReq, NetflixAmazonCredentials credentialsInReq, String regionInReq) {
        if (!this.dynamicConfigService.isEnabled("aws.features.launch-templates", false)) {
            log.debug("Launch Template feature disabled via configuration.");
            return false;
        }
        String excludedApps = (String)this.dynamicConfigService.getConfig(String.class, "aws.features.launch-templates.excluded-applications", (Object)"");
        for (String excludedApp : excludedApps.split(",")) {
            if (!excludedApp.trim().equals(applicationInReq)) continue;
            return false;
        }
        String excludedAccounts = (String)this.dynamicConfigService.getConfig(String.class, "aws.features.launch-templates.excluded-accounts", (Object)"");
        for (String excludedAccount : excludedAccounts.split(",")) {
            if (!excludedAccount.trim().equals(credentialsInReq.getName())) continue;
            return false;
        }
        if (this.dynamicConfigService.isEnabled("aws.features.launch-templates.all-applications", false)) {
            return true;
        }
        String allowedApps = (String)this.dynamicConfigService.getConfig(String.class, "aws.features.launch-templates.allowed-applications", (Object)"");
        if (this.matchesAppAccountAndRegion(applicationInReq, credentialsInReq.getName(), regionInReq, allowedApps.split(","))) {
            return true;
        }
        String allowedAccountsAndRegions = (String)this.dynamicConfigService.getConfig(String.class, "aws.features.launch-templates.allowed-accounts-regions", (Object)"");
        for (String accountRegion : allowedAccountsAndRegions.split(",")) {
            if (!StringUtils.isNotBlank((CharSequence)accountRegion) || !accountRegion.contains(":")) continue;
            String[] parts = accountRegion.split(":");
            String account = parts[0];
            String region = parts[1];
            if (!account.trim().equals(credentialsInReq.getName()) || !region.trim().equals(regionInReq)) continue;
            return true;
        }
        String allowedAccounts = (String)this.dynamicConfigService.getConfig(String.class, "aws.features.launch-templates.allowed-accounts", (Object)"");
        for (String allowedAccount : allowedAccounts.split(",")) {
            if (!allowedAccount.trim().equals(credentialsInReq.getName())) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    private boolean matchesAppAccountAndRegion(String application, String accountName, String region, String[] applicationAccountRegions) {
        if (applicationAccountRegions != null && applicationAccountRegions.length <= 0) {
            return false;
        }
        for (String appAccountRegion : applicationAccountRegions) {
            if (!StringUtils.isNotBlank((CharSequence)appAccountRegion) || !appAccountRegion.contains(":")) continue;
            try {
                String[] parts = appAccountRegion.split(":");
                String app = parts[0];
                String account = parts[1];
                String regions = parts[2];
                if (!app.equals(application) || !account.equals(accountName) || !Arrays.asList(regions.split(",")).contains(region)) continue;
                return true;
            }
            catch (Exception e) {
                log.error("Unable to verify if application is allowed in shouldSetLaunchTemplate: {}", (Object)appAccountRegion);
                return false;
            }
        }
        return false;
    }
}

