/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.AmazonAutoScalingException;
import com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.DeleteAmazonLaunchConfigurationDescription;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import java.time.Duration;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteAmazonLaunchConfigurationAtomicOperation
implements AtomicOperation<Void> {
    private static final String BASE_PHASE = "DELETE_LAUNCH_CONFIGURATION";
    @Autowired
    private AmazonClientProvider amazonClientProvider;
    @Autowired
    private RetrySupport retrySupport;
    private final DeleteAmazonLaunchConfigurationDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public DeleteAmazonLaunchConfigurationAtomicOperation(DeleteAmazonLaunchConfigurationDescription description) {
        this.description = description;
    }

    public Void operate(List<Void> priorOutputs) {
        String region = this.description.getRegion();
        NetflixAmazonCredentials credentials = this.description.getCredentials();
        String launchConfigurationName = this.description.getLaunchConfigurationName();
        AmazonAutoScaling autoScaling = this.amazonClientProvider.getAutoScaling(credentials, region, true);
        DeleteAmazonLaunchConfigurationAtomicOperation.getTask().updateStatus(BASE_PHASE, "Deleting launch config " + launchConfigurationName + " in " + region);
        this.retrySupport.retry(() -> this.deleteLaunchConfiguration(launchConfigurationName, autoScaling), 5, Duration.ofSeconds(1L), true);
        DeleteAmazonLaunchConfigurationAtomicOperation.getTask().updateStatus(BASE_PHASE, "Finished Delete Launch Config operation for " + launchConfigurationName);
        return null;
    }

    private Boolean deleteLaunchConfiguration(String launchConfigurationName, AmazonAutoScaling autoScaling) {
        try {
            autoScaling.deleteLaunchConfiguration(new DeleteLaunchConfigurationRequest().withLaunchConfigurationName(launchConfigurationName));
            return true;
        }
        catch (AmazonAutoScalingException e) {
            if (!e.getMessage().toLowerCase().contains("launch configuration name not found")) {
                throw new IntegrationException((Throwable)e).setRetryable(Boolean.valueOf(true));
            }
            return false;
        }
    }
}

