/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.DeleteCloudFormationDescription;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.StringUtils;

public class DeleteCloudFormationAtomicOperation
implements AtomicOperation<Map> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeleteCloudFormationAtomicOperation.class);
    private static final String BASE_PHASE = "DELETE_CLOUDFORMATION_STACK";
    @Autowired
    AmazonClientProvider amazonClientProvider;
    @Autowired
    @Qualifier(value="amazonObjectMapper")
    private ObjectMapper objectMapper;
    private DeleteCloudFormationDescription description;

    public DeleteCloudFormationAtomicOperation(DeleteCloudFormationDescription deleteCloudFormationDescription) {
        this.description = deleteCloudFormationDescription;
    }

    public Map operate(List priorOutputs) {
        Task task = (Task)TaskRepository.threadLocalTask.get();
        AmazonCloudFormation amazonCloudFormation = this.amazonClientProvider.getAmazonCloudFormation(this.description.getCredentials(), this.description.getRegion());
        DeleteStackRequest deleteStackRequest = new DeleteStackRequest().withStackName(this.description.getStackName());
        if (StringUtils.hasText((String)this.description.getRoleARN())) {
            deleteStackRequest.setRoleARN(this.description.getRoleARN());
        }
        try {
            task.updateStatus(BASE_PHASE, "Deleting CloudFormation Stack");
            amazonCloudFormation.deleteStack(deleteStackRequest);
        }
        catch (AmazonServiceException e) {
            log.error("Error deleting stack {}", (Object)this.description.getStackName(), (Object)e);
            throw e;
        }
        return Collections.emptyMap();
    }
}

