/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining;
import com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings;
import com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.HealthCheck;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerDescription;
import com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import com.amazonaws.services.shield.AWSShield;
import com.amazonaws.services.shield.model.CreateProtectionRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertAmazonLoadBalancerClassicDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertAmazonLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.handlers.LoadBalancerUpsertHandler;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.IngressLoadBalancerBuilder;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.UpsertAmazonLoadBalancerResult;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.securitygroup.SecurityGroupLookupFactory;
import com.netflix.spinnaker.clouddriver.aws.model.SubnetTarget;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.services.RegionScopedProviderFactory;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.config.AwsConfiguration;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertAmazonLoadBalancerAtomicOperation
implements AtomicOperation<UpsertAmazonLoadBalancerResult>,
GroovyObject {
    private static final String BASE_PHASE = "CREATE_ELB";
    @Autowired
    private AmazonClientProvider amazonClientProvider;
    @Autowired
    private RegionScopedProviderFactory regionScopedProviderFactory;
    @Autowired
    private SecurityGroupLookupFactory securityGroupLookupFactory;
    @Autowired
    private IngressLoadBalancerBuilder ingressLoadBalancerBuilder;
    @Autowired
    private AwsConfiguration.DeployDefaults deployDefaults;
    private final UpsertAmazonLoadBalancerClassicDescription description;
    private ObjectMapper objectMapper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public UpsertAmazonLoadBalancerAtomicOperation(UpsertAmazonLoadBalancerDescription description) {
        UpsertAmazonLoadBalancerClassicDescription upsertAmazonLoadBalancerClassicDescription;
        MetaClass metaClass;
        CallSite[] callSiteArray = UpsertAmazonLoadBalancerAtomicOperation.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(ObjectMapper.class);
        this.objectMapper = (ObjectMapper)ScriptBytecodeAdapter.castToType((Object)object, ObjectMapper.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = upsertAmazonLoadBalancerClassicDescription = (UpsertAmazonLoadBalancerClassicDescription)ScriptBytecodeAdapter.castToType((Object)description, UpsertAmazonLoadBalancerClassicDescription.class);
    }

    private static Task getTask() {
        CallSite[] callSiteArray = UpsertAmazonLoadBalancerAtomicOperation.$getCallSiteArray();
        return (Task)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].call(callSiteArray[2].callGetProperty(TaskRepository.class)), Task.class);
    }

    public UpsertAmazonLoadBalancerResult operate(List priorOutputs) {
        CallSite[] callSiteArray = UpsertAmazonLoadBalancerAtomicOperation.$getCallSiteArray();
        callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Initializing load balancer creation...");
        Object operationResult = callSiteArray[5].callConstructor(UpsertAmazonLoadBalancerResult.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancers", ScriptBytecodeAdapter.createMap((Object[])new Object[0])}));
        Map.Entry entry = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)this.description)), Iterator.class);
        if (iterator != null) {
            while (iterator.hasNext()) {
                entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
                Object region = callSiteArray[8].callGetProperty((Object)entry);
                Object availabilityZones = callSiteArray[9].callGetProperty((Object)entry);
                Object regionScopedProvider = callSiteArray[10].call((Object)this.regionScopedProviderFactory, callSiteArray[11].callGroovyObjectGetProperty((Object)this.description), region);
                Object object = callSiteArray[12].callGroovyObjectGetProperty((Object)this.description);
                Object loadBalancerName = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[13].call((Object)new GStringImpl(new Object[]{callSiteArray[14].callGroovyObjectGetProperty((Object)this.description)}, new String[]{"", "-frontend"}));
                boolean isInternal = DefaultTypeTransformation.booleanUnbox((Object)(ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[15].call((Object)this.description), null) ? callSiteArray[16].call((Object)this.description) : callSiteArray[17].callSafe(callSiteArray[18].callGroovyObjectGetProperty((Object)this.description), (Object)"internal")));
                callSiteArray[19].call(callSiteArray[20].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{region, availabilityZones, loadBalancerName}, new String[]{"Beginning deployment to ", " in ", " for ", ""}));
                Object loadBalancing = callSiteArray[21].call((Object)this.amazonClientProvider, callSiteArray[22].callGroovyObjectGetProperty((Object)this.description), region, (Object)true);
                LoadBalancerDescription loadBalancer = null;
                callSiteArray[23].call(callSiteArray[24].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"Setting up listeners for ", " in ", "..."}));
                Reference listeners = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                public final class _operate_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference listeners;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _operate_closure1(Object _outerInstance, Object _thisObject, Reference listeners) {
                        Reference reference;
                        CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.listeners = reference = listeners;
                    }

                    public Object doCall(UpsertAmazonLoadBalancerClassicDescription.Listener listener) {
                        CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                        Object awsListener = callSiteArray[0].callConstructor(Listener.class);
                        callSiteArray[1].call(callSiteArray[2].call(awsListener, callSiteArray[3].callGetProperty((Object)listener)), callSiteArray[4].callGetProperty((Object)listener));
                        callSiteArray[5].call(awsListener, callSiteArray[6].call(callSiteArray[7].callGetProperty((Object)listener)));
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].callGetProperty((Object)listener)) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[9].callGetProperty((Object)listener), (Object)callSiteArray[10].callGetProperty((Object)listener))) {
                            callSiteArray[11].call(awsListener, callSiteArray[12].call(callSiteArray[13].callGetProperty((Object)listener)));
                        } else {
                            callSiteArray[14].call(awsListener, callSiteArray[15].call(callSiteArray[16].callGetProperty((Object)listener)));
                        }
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].callGetProperty((Object)listener))) {
                            callSiteArray[18].call(callSiteArray[19].callGroovyObjectGetProperty((Object)this), ScriptBytecodeAdapter.getField(_operate_closure1.class, UpsertAmazonLoadBalancerAtomicOperation.class, (String)"BASE_PHASE"), (Object)new GStringImpl(new Object[]{callSiteArray[20].callGetProperty((Object)listener)}, new String[]{"Attaching listener with SSL ServerCertificate: ", ""}));
                            callSiteArray[21].call(awsListener, callSiteArray[22].callGetProperty((Object)listener));
                        }
                        callSiteArray[23].call(this.listeners.get(), awsListener);
                        return callSiteArray[24].call(callSiteArray[25].callGroovyObjectGetProperty((Object)this), ScriptBytecodeAdapter.getField(_operate_closure1.class, UpsertAmazonLoadBalancerAtomicOperation.class, (String)"BASE_PHASE"), (Object)new GStringImpl(new Object[]{callSiteArray[26].callGetProperty(awsListener), callSiteArray[27].callGetProperty(awsListener), callSiteArray[28].callGetProperty(awsListener), callSiteArray[29].callGetProperty(awsListener)}, new String[]{"Appending listener ", ":", " -> ", ":", ""}));
                    }

                    @Generated
                    public Object call(UpsertAmazonLoadBalancerClassicDescription.Listener listener) {
                        CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                        return callSiteArray[30].callCurrent((GroovyObject)this, (Object)listener);
                    }

                    @Generated
                    public List getListeners() {
                        CallSite[] callSiteArray = _operate_closure1.$getCallSiteArray();
                        return (List)ScriptBytecodeAdapter.castToType((Object)this.listeners.get(), List.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "<$constructor$>";
                        stringArray[1] = "withInstancePort";
                        stringArray[2] = "withLoadBalancerPort";
                        stringArray[3] = "externalPort";
                        stringArray[4] = "internalPort";
                        stringArray[5] = "withProtocol";
                        stringArray[6] = "name";
                        stringArray[7] = "externalProtocol";
                        stringArray[8] = "internalProtocol";
                        stringArray[9] = "externalProtocol";
                        stringArray[10] = "internalProtocol";
                        stringArray[11] = "withInstanceProtocol";
                        stringArray[12] = "name";
                        stringArray[13] = "internalProtocol";
                        stringArray[14] = "withInstanceProtocol";
                        stringArray[15] = "name";
                        stringArray[16] = "externalProtocol";
                        stringArray[17] = "sslCertificateId";
                        stringArray[18] = "updateStatus";
                        stringArray[19] = "task";
                        stringArray[20] = "sslCertificateId";
                        stringArray[21] = "withSSLCertificateId";
                        stringArray[22] = "sslCertificateId";
                        stringArray[23] = "leftShift";
                        stringArray[24] = "updateStatus";
                        stringArray[25] = "task";
                        stringArray[26] = "protocol";
                        stringArray[27] = "loadBalancerPort";
                        stringArray[28] = "instanceProtocol";
                        stringArray[29] = "instancePort";
                        stringArray[30] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[31];
                        _operate_closure1.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_operate_closure1.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _operate_closure1.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[25].call(callSiteArray[26].callGroovyObjectGetProperty((Object)this.description), (Object)new _operate_closure1(this, this, listeners));
                try {
                    loadBalancer = (LoadBalancerDescription)ScriptBytecodeAdapter.castToType((Object)callSiteArray[27].callSafe(callSiteArray[28].callGetPropertySafe(callSiteArray[29].call(loadBalancing, callSiteArray[30].callConstructor(DescribeLoadBalancersRequest.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{loadBalancerName})))), (Object)0), LoadBalancerDescription.class);
                    callSiteArray[31].call(callSiteArray[32].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"Found existing load balancer named ", " in ", "... Using that."}));
                }
                catch (AmazonServiceException ignore) {
                }
                public final class _operate_closure2
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _operate_closure2(Object _outerInstance, Object _thisObject) {
                        CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                        return callSiteArray[0].callGetProperty(it);
                    }

                    @Generated
                    public Object doCall() {
                        CallSite[] callSiteArray = _operate_closure2.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _operate_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "value";
                        return new CallSiteArray(_operate_closure2.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _operate_closure2.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                Set securityGroups = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[33].call(callSiteArray[34].call(callSiteArray[35].callGetProperty(regionScopedProvider), callSiteArray[36].callGroovyObjectGetProperty((Object)this.description), callSiteArray[37].callGroovyObjectGetProperty((Object)this.description)), (Object)new _operate_closure2(this, this)), Set.class);
                Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[38].call((Object)log)) ? callSiteArray[39].call((Object)log, (Object)"security groups on {} {}", callSiteArray[40].callGroovyObjectGetProperty((Object)this.description), (Object)securityGroups) : null;
                String dnsName = null;
                if (!DefaultTypeTransformation.booleanUnbox((Object)loadBalancer)) {
                    callSiteArray[41].call(callSiteArray[42].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName, callSiteArray[43].callGetProperty(callSiteArray[44].callGroovyObjectGetProperty((Object)this.description)), region}, new String[]{"Creating ", " in ", ":", "..."}));
                    Object subnetIds = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[45].callGroovyObjectGetProperty((Object)this.description))) {
                        subnetIds = callSiteArray[46].call(callSiteArray[47].callGetProperty(regionScopedProvider), availabilityZones, callSiteArray[48].callGroovyObjectGetProperty((Object)this.description), callSiteArray[49].callGetProperty(SubnetTarget.class), (Object)1);
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[50].callGroovyObjectGetProperty((Object)this.deployDefaults)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[51].callGroovyObjectGetProperty((Object)this.deployDefaults))) {
                        String application = null;
                        try {
                            Object object3 = callSiteArray[52].call(callSiteArray[53].call(Names.class, callSiteArray[54].callGroovyObjectGetProperty((Object)this.description)));
                            application = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object3) ? object3 : callSiteArray[55].call(callSiteArray[56].call(Names.class, callSiteArray[57].callGroovyObjectGetProperty((Object)this.description)))));
                            public final class _operate_closure3
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;
                                private static /* synthetic */ SoftReference $callSiteArray;

                                public _operate_closure3(Object _outerInstance, Object _thisObject) {
                                    CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                                    super(_outerInstance, _thisObject);
                                }

                                public Object doCall(Object l) {
                                    CallSite[] callSiteArray = _operate_closure3.$getCallSiteArray();
                                    return callSiteArray[0].call(l);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _operate_closure3.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                    String[] stringArray = new String[1];
                                    stringArray[0] = "getInstancePort";
                                    return new CallSiteArray(_operate_closure3.class, stringArray);
                                }

                                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                    CallSiteArray callSiteArray;
                                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                        callSiteArray = _operate_closure3.$createCallSiteArray();
                                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                    }
                                    return callSiteArray.array;
                                }
                            }
                            Set ports = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].call((Object)((List)listeners.get()), (Object)new _operate_closure3(this, this)), Set.class);
                            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[59].callGroovyObjectGetProperty((Object)this.description))) {
                                callSiteArray[60].call((Object)ports, callSiteArray[61].callGroovyObjectGetProperty((Object)this.description));
                            }
                            IngressLoadBalancerBuilder.IngressLoadBalancerGroupResult ingressLoadBalancerResult = (IngressLoadBalancerBuilder.IngressLoadBalancerGroupResult)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].call((Object)this.ingressLoadBalancerBuilder, ArrayUtil.createArray((Object)application, (Object)region, (Object)callSiteArray[63].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[64].callGroovyObjectGetProperty((Object)this.description), (Object)callSiteArray[65].callGroovyObjectGetProperty((Object)this.description), (Object)ports, (Object)this.securityGroupLookupFactory)), IngressLoadBalancerBuilder.IngressLoadBalancerGroupResult.class);
                            callSiteArray[66].call(callSiteArray[67].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{ingressLoadBalancerResult}, new String[]{"Authorized app ELB Security Group ", ""}));
                            callSiteArray[68].call((Object)securityGroups, callSiteArray[69].callGetProperty((Object)ingressLoadBalancerResult));
                        }
                        catch (Exception e) {
                            callSiteArray[70].call((Object)log, (Object)"Failed to authorize app ELB security group {}-elb on application security group", application, (Object)e);
                            callSiteArray[71].call(callSiteArray[72].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{application}, new String[]{"Failed to authorize app ELB security group ", "-elb on application security group"}));
                        }
                    }
                    dnsName = ShortTypeHandling.castToString((Object)callSiteArray[73].call(LoadBalancerUpsertHandler.class, ArrayUtil.createArray((Object)loadBalancing, (Object)loadBalancerName, (Object)isInternal, (Object)availabilityZones, (Object)subnetIds, (Object)((List)listeners.get()), (Object)securityGroups)));
                    if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[74].callGroovyObjectGetProperty((Object)this.description)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[75].callGetProperty(callSiteArray[76].callGroovyObjectGetProperty((Object)this.description))) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[77].callGroovyObjectGetProperty((Object)this.description))) {
                        callSiteArray[78].call(callSiteArray[79].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"Configuring AWS Shield for ", " in ", "..."}));
                        try {
                            AWSShield shieldClient = (AWSShield)ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].call((Object)this.amazonClientProvider, callSiteArray[81].callGroovyObjectGetProperty((Object)this.description), region), AWSShield.class);
                            callSiteArray[82].call((Object)shieldClient, callSiteArray[83].call(callSiteArray[84].call(callSiteArray[85].callConstructor(CreateProtectionRequest.class), loadBalancerName), callSiteArray[86].callStatic(UpsertAmazonLoadBalancerAtomicOperation.class, callSiteArray[87].callGetProperty(callSiteArray[88].callGroovyObjectGetProperty((Object)this.description)), region, loadBalancerName)));
                            callSiteArray[89].call(callSiteArray[90].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"AWS Shield configured for ", " in ", "."}));
                        }
                        catch (Exception e) {
                            Object object4 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[91].call((Object)log)) ? callSiteArray[92].call((Object)log, (Object)new GStringImpl(new Object[]{loadBalancerName}, new String[]{"Failed to enable AWS Shield protection on ", ""}), (Object)e) : null;
                            callSiteArray[93].call(callSiteArray[94].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"Failed to configure AWS Shield for ", " in ", "."}));
                        }
                    }
                } else {
                    dnsName = ShortTypeHandling.castToString((Object)callSiteArray[95].callGetProperty((Object)loadBalancer));
                    callSiteArray[96].call(LoadBalancerUpsertHandler.class, loadBalancing, (Object)loadBalancer, (Object)((List)listeners.get()), (Object)securityGroups);
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[97].callGroovyObjectGetProperty((Object)this.description))) {
                    callSiteArray[98].call(callSiteArray[99].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"Configuring healthcheck for ", " in ", "..."}));
                    Object healthCheck = callSiteArray[100].callConstructor(ConfigureHealthCheckRequest.class, loadBalancerName, callSiteArray[101].call(callSiteArray[102].call(callSiteArray[103].call(callSiteArray[104].call(callSiteArray[105].call(callSiteArray[106].callConstructor(HealthCheck.class), callSiteArray[107].callGroovyObjectGetProperty((Object)this.description)), callSiteArray[108].callGroovyObjectGetProperty((Object)this.description)), callSiteArray[109].callGroovyObjectGetProperty((Object)this.description)), callSiteArray[110].callGroovyObjectGetProperty((Object)this.description)), callSiteArray[111].callGroovyObjectGetProperty((Object)this.description)));
                    callSiteArray[112].call(loadBalancing, healthCheck);
                    callSiteArray[113].call(callSiteArray[114].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Healthcheck configured.");
                }
                CrossZoneLoadBalancing crossZoneLoadBalancing = null;
                ConnectionDraining connectionDraining = null;
                ConnectionSettings connectionSettings = null;
                if (DefaultTypeTransformation.booleanUnbox((Object)loadBalancer)) {
                    Object currentAttributes = callSiteArray[115].callGetProperty(callSiteArray[116].call(loadBalancing, callSiteArray[117].call(callSiteArray[118].callConstructor(DescribeLoadBalancerAttributesRequest.class), loadBalancerName)));
                    Boolean crossZoneBalancingEnabled = (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[119].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[120].callGroovyObjectGetProperty((Object)this.description), callSiteArray[121].callGetPropertySafe(callSiteArray[122].callGetPropertySafe(currentAttributes)), callSiteArray[123].callGetProperty(callSiteArray[124].callGroovyObjectGetProperty((Object)this.deployDefaults))}), callSiteArray[125].callGetProperty(Closure.class)), Boolean.class);
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)crossZoneBalancingEnabled, (Object)callSiteArray[126].callGetPropertySafe(callSiteArray[127].callGetPropertySafe(currentAttributes)))) {
                        crossZoneLoadBalancing = (CrossZoneLoadBalancing)ScriptBytecodeAdapter.castToType((Object)callSiteArray[128].callConstructor(CrossZoneLoadBalancing.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"enabled", crossZoneBalancingEnabled})), CrossZoneLoadBalancing.class);
                    }
                    Boolean connectionDrainingEnabled = (Boolean)ScriptBytecodeAdapter.castToType((Object)callSiteArray[129].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[130].callGroovyObjectGetProperty((Object)this.description), callSiteArray[131].callGetPropertySafe(callSiteArray[132].callGetPropertySafe(currentAttributes)), callSiteArray[133].callGetProperty(callSiteArray[134].callGroovyObjectGetProperty((Object)this.deployDefaults))}), callSiteArray[135].callGetProperty(Closure.class)), Boolean.class);
                    Integer deregistrationDelay = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[136].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[137].callGroovyObjectGetProperty((Object)this.description), callSiteArray[138].callGetPropertySafe(callSiteArray[139].callGetPropertySafe(currentAttributes)), callSiteArray[140].callGetProperty(callSiteArray[141].callGroovyObjectGetProperty((Object)this.deployDefaults))}), callSiteArray[142].callGetProperty(Closure.class)), Integer.class);
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)connectionDrainingEnabled, (Object)callSiteArray[143].callGetPropertySafe(callSiteArray[144].callGetPropertySafe(currentAttributes))) || ScriptBytecodeAdapter.compareNotEqual((Object)deregistrationDelay, (Object)callSiteArray[145].callGetPropertySafe(callSiteArray[146].callGetPropertySafe(currentAttributes)))) {
                        connectionDraining = (ConnectionDraining)ScriptBytecodeAdapter.castToType((Object)callSiteArray[147].callConstructor(ConnectionDraining.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"enabled", connectionDrainingEnabled, "timeout", deregistrationDelay})), ConnectionDraining.class);
                    }
                    Integer idleTimeout = (Integer)ScriptBytecodeAdapter.castToType((Object)callSiteArray[148].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[149].callGroovyObjectGetProperty((Object)this.description), callSiteArray[150].callGetPropertySafe(callSiteArray[151].callGetPropertySafe(currentAttributes)), callSiteArray[152].callGetProperty(callSiteArray[153].callGroovyObjectGetProperty((Object)this.deployDefaults))}), callSiteArray[154].callGetProperty(Closure.class)), Integer.class);
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)idleTimeout, (Object)callSiteArray[155].callGetPropertySafe(callSiteArray[156].callGetPropertySafe(currentAttributes)))) {
                        connectionSettings = (ConnectionSettings)ScriptBytecodeAdapter.castToType((Object)callSiteArray[157].callConstructor(ConnectionSettings.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"idleTimeout", idleTimeout})), ConnectionSettings.class);
                    }
                } else {
                    crossZoneLoadBalancing = (CrossZoneLoadBalancing)ScriptBytecodeAdapter.castToType((Object)callSiteArray[158].callConstructor(CrossZoneLoadBalancing.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"enabled", callSiteArray[159].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[160].callGroovyObjectGetProperty((Object)this.description), callSiteArray[161].callGetProperty(callSiteArray[162].callGroovyObjectGetProperty((Object)this.deployDefaults))}), callSiteArray[163].callGetProperty(Boolean.class), callSiteArray[164].callGetProperty(Closure.class))})), CrossZoneLoadBalancing.class);
                    connectionDraining = (ConnectionDraining)ScriptBytecodeAdapter.castToType((Object)callSiteArray[165].callConstructor(ConnectionDraining.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"enabled", callSiteArray[166].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[167].callGroovyObjectGetProperty((Object)this.description), callSiteArray[168].callGetProperty(callSiteArray[169].callGroovyObjectGetProperty((Object)this.deployDefaults))}), callSiteArray[170].callGetProperty(Boolean.class), callSiteArray[171].callGetProperty(Closure.class)), "timeout", callSiteArray[172].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[173].callGroovyObjectGetProperty((Object)this.description), callSiteArray[174].callGetProperty(callSiteArray[175].callGroovyObjectGetProperty((Object)this.deployDefaults))}), callSiteArray[176].callGetProperty(Closure.class))})), ConnectionDraining.class);
                    connectionSettings = (ConnectionSettings)ScriptBytecodeAdapter.castToType((Object)callSiteArray[177].callConstructor(ConnectionSettings.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"idleTimeout", callSiteArray[178].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[179].callGroovyObjectGetProperty((Object)this.description), callSiteArray[180].callGetProperty(callSiteArray[181].callGroovyObjectGetProperty((Object)this.deployDefaults))}), callSiteArray[182].callGetProperty(Closure.class))})), ConnectionSettings.class);
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)crossZoneLoadBalancing, null) || ScriptBytecodeAdapter.compareNotEqual((Object)connectionDraining, null) || ScriptBytecodeAdapter.compareNotEqual((Object)connectionSettings, null)) {
                    LoadBalancerAttributes attributes = (LoadBalancerAttributes)ScriptBytecodeAdapter.castToType((Object)callSiteArray[183].callConstructor(LoadBalancerAttributes.class), LoadBalancerAttributes.class);
                    if (DefaultTypeTransformation.booleanUnbox((Object)crossZoneLoadBalancing)) {
                        callSiteArray[184].call((Object)attributes, (Object)crossZoneLoadBalancing);
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)connectionDraining)) {
                        callSiteArray[185].call((Object)attributes, (Object)connectionDraining);
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)connectionSettings)) {
                        callSiteArray[186].call((Object)attributes, (Object)connectionSettings);
                    }
                    callSiteArray[187].call(loadBalancing, callSiteArray[188].call(callSiteArray[189].callConstructor(ModifyLoadBalancerAttributesRequest.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancerName", loadBalancerName})), (Object)attributes));
                }
                callSiteArray[190].call(callSiteArray[191].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)new GStringImpl(new Object[]{loadBalancerName, callSiteArray[192].callGetProperty(callSiteArray[193].callGroovyObjectGetProperty((Object)this.description)), region}, new String[]{"Done deploying ", " to ", " in ", "."}));
                Object object5 = callSiteArray[194].callConstructor(UpsertAmazonLoadBalancerResult.LoadBalancer.class, loadBalancerName, (Object)dnsName);
                callSiteArray[195].call(callSiteArray[196].callGetProperty(operationResult), region, object5);
            }
        }
        callSiteArray[197].call(callSiteArray[198].callGroovyObjectGetProperty((Object)this), (Object)BASE_PHASE, (Object)"Done deploying load balancers.");
        return (UpsertAmazonLoadBalancerResult)ScriptBytecodeAdapter.castToType((Object)operationResult, UpsertAmazonLoadBalancerResult.class);
    }

    private static String loadBalancerArn(String accountId, String region, String name) {
        CallSite[] callSiteArray = UpsertAmazonLoadBalancerAtomicOperation.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{accountId, region, name}, new String[]{"arn:aws:elasticloadbalancing:", ":", ":loadbalancer/", ""}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UpsertAmazonLoadBalancerAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = UpsertAmazonLoadBalancerAtomicOperation.$getCallSiteArray()[199].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.UpsertAmazonLoadBalancerAtomicOperation");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
    }

    @Generated
    public AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public void setAmazonClientProvider(AmazonClientProvider amazonClientProvider) {
        this.amazonClientProvider = amazonClientProvider;
    }

    @Generated
    public RegionScopedProviderFactory getRegionScopedProviderFactory() {
        return this.regionScopedProviderFactory;
    }

    @Generated
    public void setRegionScopedProviderFactory(RegionScopedProviderFactory regionScopedProviderFactory) {
        this.regionScopedProviderFactory = regionScopedProviderFactory;
    }

    @Generated
    public SecurityGroupLookupFactory getSecurityGroupLookupFactory() {
        return this.securityGroupLookupFactory;
    }

    @Generated
    public void setSecurityGroupLookupFactory(SecurityGroupLookupFactory securityGroupLookupFactory) {
        this.securityGroupLookupFactory = securityGroupLookupFactory;
    }

    @Generated
    public IngressLoadBalancerBuilder getIngressLoadBalancerBuilder() {
        return this.ingressLoadBalancerBuilder;
    }

    @Generated
    public void setIngressLoadBalancerBuilder(IngressLoadBalancerBuilder ingressLoadBalancerBuilder) {
        this.ingressLoadBalancerBuilder = ingressLoadBalancerBuilder;
    }

    @Generated
    public AwsConfiguration.DeployDefaults getDeployDefaults() {
        return this.deployDefaults;
    }

    @Generated
    public void setDeployDefaults(AwsConfiguration.DeployDefaults deployDefaults) {
        this.deployDefaults = deployDefaults;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "get";
        stringArray[2] = "threadLocalTask";
        stringArray[3] = "updateStatus";
        stringArray[4] = "task";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "iterator";
        stringArray[7] = "availabilityZones";
        stringArray[8] = "key";
        stringArray[9] = "value";
        stringArray[10] = "forRegion";
        stringArray[11] = "credentials";
        stringArray[12] = "name";
        stringArray[13] = "toString";
        stringArray[14] = "clusterName";
        stringArray[15] = "getIsInternal";
        stringArray[16] = "getIsInternal";
        stringArray[17] = "contains";
        stringArray[18] = "subnetType";
        stringArray[19] = "updateStatus";
        stringArray[20] = "task";
        stringArray[21] = "getAmazonElasticLoadBalancing";
        stringArray[22] = "credentials";
        stringArray[23] = "updateStatus";
        stringArray[24] = "task";
        stringArray[25] = "each";
        stringArray[26] = "listeners";
        stringArray[27] = "getAt";
        stringArray[28] = "loadBalancerDescriptions";
        stringArray[29] = "describeLoadBalancers";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "updateStatus";
        stringArray[32] = "task";
        stringArray[33] = "collect";
        stringArray[34] = "getSecurityGroupIds";
        stringArray[35] = "securityGroupService";
        stringArray[36] = "securityGroups";
        stringArray[37] = "vpcId";
        stringArray[38] = "isInfoEnabled";
        stringArray[39] = "info";
        stringArray[40] = "name";
        stringArray[41] = "updateStatus";
        stringArray[42] = "task";
        stringArray[43] = "name";
        stringArray[44] = "credentials";
        stringArray[45] = "subnetType";
        stringArray[46] = "getSubnetIdsForZones";
        stringArray[47] = "subnetAnalyzer";
        stringArray[48] = "subnetType";
        stringArray[49] = "ELB";
        stringArray[50] = "createLoadBalancerIngressPermissions";
        stringArray[51] = "addAppGroupToServerGroup";
        stringArray[52] = "getApp";
        stringArray[53] = "parseName";
        stringArray[54] = "name";
        stringArray[55] = "getApp";
        stringArray[56] = "parseName";
        stringArray[57] = "clusterName";
        stringArray[58] = "collect";
        stringArray[59] = "healthCheckPort";
        stringArray[60] = "add";
        stringArray[61] = "healthCheckPort";
        stringArray[62] = "ingressApplicationLoadBalancerGroup";
        stringArray[63] = "account";
        stringArray[64] = "credentials";
        stringArray[65] = "vpcId";
        stringArray[66] = "updateStatus";
        stringArray[67] = "task";
        stringArray[68] = "add";
        stringArray[69] = "groupId";
        stringArray[70] = "error";
        stringArray[71] = "updateStatus";
        stringArray[72] = "task";
        stringArray[73] = "createLoadBalancer";
        stringArray[74] = "isInternal";
        stringArray[75] = "shieldEnabled";
        stringArray[76] = "credentials";
        stringArray[77] = "shieldProtectionEnabled";
        stringArray[78] = "updateStatus";
        stringArray[79] = "task";
        stringArray[80] = "getAmazonShield";
        stringArray[81] = "credentials";
        stringArray[82] = "createProtection";
        stringArray[83] = "withResourceArn";
        stringArray[84] = "withName";
        stringArray[85] = "<$constructor$>";
        stringArray[86] = "loadBalancerArn";
        stringArray[87] = "accountId";
        stringArray[88] = "credentials";
        stringArray[89] = "updateStatus";
        stringArray[90] = "task";
        stringArray[91] = "isErrorEnabled";
        stringArray[92] = "error";
        stringArray[93] = "updateStatus";
        stringArray[94] = "task";
        stringArray[95] = "DNSName";
        stringArray[96] = "updateLoadBalancer";
        stringArray[97] = "healthCheck";
        stringArray[98] = "updateStatus";
        stringArray[99] = "task";
        stringArray[100] = "<$constructor$>";
        stringArray[101] = "withHealthyThreshold";
        stringArray[102] = "withUnhealthyThreshold";
        stringArray[103] = "withTimeout";
        stringArray[104] = "withInterval";
        stringArray[105] = "withTarget";
        stringArray[106] = "<$constructor$>";
        stringArray[107] = "healthCheck";
        stringArray[108] = "healthInterval";
        stringArray[109] = "healthTimeout";
        stringArray[110] = "unhealthyThreshold";
        stringArray[111] = "healthyThreshold";
        stringArray[112] = "configureHealthCheck";
        stringArray[113] = "updateStatus";
        stringArray[114] = "task";
        stringArray[115] = "loadBalancerAttributes";
        stringArray[116] = "describeLoadBalancerAttributes";
        stringArray[117] = "withLoadBalancerName";
        stringArray[118] = "<$constructor$>";
        stringArray[119] = "findResult";
        stringArray[120] = "crossZoneBalancing";
        stringArray[121] = "enabled";
        stringArray[122] = "crossZoneLoadBalancing";
        stringArray[123] = "crossZoneBalancingDefault";
        stringArray[124] = "loadBalancing";
        stringArray[125] = "IDENTITY";
        stringArray[126] = "enabled";
        stringArray[127] = "crossZoneLoadBalancing";
        stringArray[128] = "<$constructor$>";
        stringArray[129] = "findResult";
        stringArray[130] = "connectionDraining";
        stringArray[131] = "enabled";
        stringArray[132] = "connectionDraining";
        stringArray[133] = "connectionDrainingDefault";
        stringArray[134] = "loadBalancing";
        stringArray[135] = "IDENTITY";
        stringArray[136] = "findResult";
        stringArray[137] = "deregistrationDelay";
        stringArray[138] = "timeout";
        stringArray[139] = "connectionDraining";
        stringArray[140] = "deregistrationDelayDefault";
        stringArray[141] = "loadBalancing";
        stringArray[142] = "IDENTITY";
        stringArray[143] = "enabled";
        stringArray[144] = "connectionDraining";
        stringArray[145] = "timeout";
        stringArray[146] = "connectionDraining";
        stringArray[147] = "<$constructor$>";
        stringArray[148] = "findResult";
        stringArray[149] = "idleTimeout";
        stringArray[150] = "idleTimeout";
        stringArray[151] = "connectionSettings";
        stringArray[152] = "idleTimeout";
        stringArray[153] = "loadBalancing";
        stringArray[154] = "IDENTITY";
        stringArray[155] = "idleTimeout";
        stringArray[156] = "connectionSettings";
        stringArray[157] = "<$constructor$>";
        stringArray[158] = "<$constructor$>";
        stringArray[159] = "findResult";
        stringArray[160] = "crossZoneBalancing";
        stringArray[161] = "crossZoneBalancingDefault";
        stringArray[162] = "loadBalancing";
        stringArray[163] = "TRUE";
        stringArray[164] = "IDENTITY";
        stringArray[165] = "<$constructor$>";
        stringArray[166] = "findResult";
        stringArray[167] = "connectionDraining";
        stringArray[168] = "connectionDrainingDefault";
        stringArray[169] = "loadBalancing";
        stringArray[170] = "FALSE";
        stringArray[171] = "IDENTITY";
        stringArray[172] = "findResult";
        stringArray[173] = "deregistrationDelay";
        stringArray[174] = "deregistrationDelayDefault";
        stringArray[175] = "loadBalancing";
        stringArray[176] = "IDENTITY";
        stringArray[177] = "<$constructor$>";
        stringArray[178] = "findResult";
        stringArray[179] = "idleTimeout";
        stringArray[180] = "idleTimeout";
        stringArray[181] = "loadBalancing";
        stringArray[182] = "IDENTITY";
        stringArray[183] = "<$constructor$>";
        stringArray[184] = "setCrossZoneLoadBalancing";
        stringArray[185] = "setConnectionDraining";
        stringArray[186] = "setConnectionSettings";
        stringArray[187] = "modifyLoadBalancerAttributes";
        stringArray[188] = "withLoadBalancerAttributes";
        stringArray[189] = "<$constructor$>";
        stringArray[190] = "updateStatus";
        stringArray[191] = "task";
        stringArray[192] = "name";
        stringArray[193] = "credentials";
        stringArray[194] = "<$constructor$>";
        stringArray[195] = "putAt";
        stringArray[196] = "loadBalancers";
        stringArray[197] = "updateStatus";
        stringArray[198] = "task";
        stringArray[199] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[200];
        UpsertAmazonLoadBalancerAtomicOperation.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(UpsertAmazonLoadBalancerAtomicOperation.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = UpsertAmazonLoadBalancerAtomicOperation.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

