/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeInstanceTypesRequest;
import com.amazonaws.services.ec2.model.DescribeInstanceTypesResult;
import com.amazonaws.services.ec2.model.InstanceStorageInfo;
import com.amazonaws.services.ec2.model.InstanceTypeInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.aws.cache.Keys;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsInfrastructureProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AmazonInstanceTypeCachingAgent
implements CachingAgent,
AccountAware {
    private static final TypeReference<Map<String, Object>> ATTRIBUTES = new TypeReference<Map<String, Object>>(){};
    private final String region;
    private final AmazonClientProvider amazonClientProvider;
    private final NetflixAmazonCredentials account;
    private final ObjectMapper objectMapper;

    public AmazonInstanceTypeCachingAgent(String region, AmazonClientProvider amazonClientProvider, NetflixAmazonCredentials account, ObjectMapper objectMapper) {
        this.account = account;
        this.amazonClientProvider = amazonClientProvider;
        this.region = region;
        this.objectMapper = objectMapper;
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return Collections.unmodifiableList(Arrays.asList(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.INSTANCE_TYPES.getNs()), AgentDataType.Authority.AUTHORITATIVE.forType(this.getAgentType())));
    }

    public CacheResult loadData(ProviderCache providerCache) {
        AmazonEC2 amazonEC2 = this.amazonClientProvider.getAmazonEC2(this.account, this.region);
        List<InstanceTypeInfo> instanceTypesInfo = this.getInstanceTypes(amazonEC2);
        HashMap<String, Collection<Object>> cacheResults = new HashMap<String, Collection<Object>>();
        Set<String> instanceTypes = instanceTypesInfo.stream().map(InstanceTypeInfo::getInstanceType).collect(Collectors.toSet());
        DefaultCacheData metadata = this.buildCacheDataForMetadataKey(providerCache, instanceTypes);
        cacheResults.put(this.getAgentType(), Collections.singleton(metadata));
        if (instanceTypesInfo == null || instanceTypesInfo.isEmpty()) {
            return new DefaultCacheResult(cacheResults);
        }
        List instanceTypeData = instanceTypesInfo.stream().map(i -> {
            InstanceStorageInfo info;
            Map attributes = (Map)this.objectMapper.convertValue(i, ATTRIBUTES);
            attributes.put("account", this.account.getName());
            attributes.put("region", this.region);
            attributes.put("name", i.getInstanceType());
            attributes.put("defaultVCpus", i.getVCpuInfo().getDefaultVCpus());
            attributes.put("memoryInGiB", i.getMemoryInfo().getSizeInMiB() / 1024L);
            attributes.put("supportedArchitectures", i.getProcessorInfo().getSupportedArchitectures());
            if (i.getInstanceStorageInfo() != null) {
                info = i.getInstanceStorageInfo();
                HashMap<String, Object> instanceStorageAttributes = new HashMap<String, Object>();
                instanceStorageAttributes.put("totalSizeInGB", info.getTotalSizeInGB());
                if (info.getDisks() != null && info.getDisks().size() > 0) {
                    instanceStorageAttributes.put("storageTypes", info.getDisks().stream().map(d -> d.getType()).collect(Collectors.joining(",")));
                }
                if (info.getNvmeSupport() != null) {
                    instanceStorageAttributes.put("nvmeSupport", info.getNvmeSupport());
                }
                attributes.put("instanceStorageInfo", instanceStorageAttributes);
            }
            if (i.getGpuInfo() != null) {
                info = i.getGpuInfo();
                HashMap<String, Object> gpuInfoAttributes = new HashMap<String, Object>();
                if (info.getTotalGpuMemoryInMiB() != null) {
                    gpuInfoAttributes.put("totalGpuMemoryInMiB", info.getTotalGpuMemoryInMiB());
                }
                if (info.getGpus() != null) {
                    gpuInfoAttributes.put("gpus", info.getGpus().stream().map(g -> {
                        HashMap<String, Object> gpuDeviceInfo = new HashMap<String, Object>();
                        gpuDeviceInfo.put("name", g.getName());
                        gpuDeviceInfo.put("manufacturer", g.getManufacturer());
                        gpuDeviceInfo.put("count", g.getCount());
                        gpuDeviceInfo.put("gpuSizeInMiB", g.getMemoryInfo().getSizeInMiB());
                        return gpuDeviceInfo;
                    }).collect(Collectors.toList()));
                }
                attributes.put("gpuInfo", gpuInfoAttributes);
            }
            if (i.getNetworkInfo() != null) {
                attributes.put("ipv6Supported", i.getNetworkInfo().getIpv6Supported());
            }
            return new DefaultCacheData(Keys.getInstanceTypeKey(i.getInstanceType(), this.region, this.account.getName()), attributes, Collections.emptyMap());
        }).collect(Collectors.toList());
        cacheResults.put(Keys.Namespace.INSTANCE_TYPES.getNs(), instanceTypeData);
        return new DefaultCacheResult(cacheResults);
    }

    private DefaultCacheData buildCacheDataForMetadataKey(ProviderCache providerCache, Set<String> instanceTypes) {
        MetadataAttributes metadataAttributes;
        CacheData metadata = providerCache.get(this.getAgentType(), "metadata", (CacheFilter)RelationshipCacheFilter.none());
        if (metadata != null) {
            metadataAttributes = (MetadataAttributes)this.objectMapper.convertValue((Object)metadata.getAttributes(), MetadataAttributes.class);
        } else {
            MetadataAttributes newMetadataAttributes = new MetadataAttributes();
            newMetadataAttributes.cachedInstanceTypes = instanceTypes;
            metadataAttributes = newMetadataAttributes;
        }
        return new DefaultCacheData("metadata", (Map)this.objectMapper.convertValue((Object)metadataAttributes, ATTRIBUTES), Collections.emptyMap());
    }

    private List<InstanceTypeInfo> getInstanceTypes(AmazonEC2 ec2) {
        ArrayList<InstanceTypeInfo> instanceTypeInfoList = new ArrayList<InstanceTypeInfo>();
        DescribeInstanceTypesRequest request = new DescribeInstanceTypesRequest();
        while (true) {
            DescribeInstanceTypesResult result = ec2.describeInstanceTypes(request);
            instanceTypeInfoList.addAll(result.getInstanceTypes());
            if (result.getNextToken() == null) break;
            request.withNextToken(result.getNextToken());
        }
        return instanceTypeInfoList;
    }

    public String getAgentType() {
        return this.getClass().getSimpleName() + "/" + this.region;
    }

    public String getProviderName() {
        return AwsInfrastructureProvider.PROVIDER_NAME;
    }

    public String getAccountName() {
        return this.account.getName();
    }

    static class MetadataAttributes {
        public Set<String> cachedInstanceTypes;

        MetadataAttributes() {
        }
    }
}

