/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Image;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.aws.data.Keys;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.DriftMetric;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCachingAgent
implements CachingAgent,
AccountAware,
DriftMetric,
CustomScheduledAgent,
GroovyObject {
    private final Logger log;
    private static final TypeReference<Map<String, Object>> ATTRIBUTES;
    private final Set<AgentDataType> types;
    private final AmazonClientProvider amazonClientProvider;
    private final NetflixAmazonCredentials account;
    private final String region;
    private final ObjectMapper objectMapper;
    private final Registry registry;
    private boolean includePublicImages;
    private final long pollIntervalMillis;
    private final DynamicConfigService dynamicConfigService;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ImageCachingAgent(AmazonClientProvider amazonClientProvider, NetflixAmazonCredentials account, String region, ObjectMapper objectMapper, Registry registry, boolean includePublicImages, DynamicConfigService dynamicConfigService) {
        DynamicConfigService dynamicConfigService2;
        boolean bl;
        Registry registry2;
        String string;
        NetflixAmazonCredentials netflixAmazonCredentials;
        AmazonClientProvider amazonClientProvider2;
        MetaClass metaClass;
        CallSite[] callSiteArray = ImageCachingAgent.$getCallSiteArray();
        Object object = callSiteArray[0].call(LoggerFactory.class, callSiteArray[1].callCurrent((GroovyObject)this));
        this.log = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = callSiteArray[2].call(Collections.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[3].call(callSiteArray[4].callGetProperty(AgentDataType.Authority.class), callSiteArray[5].callGetProperty(callSiteArray[6].callGetProperty(Namespace.class))), callSiteArray[7].call(callSiteArray[8].callGetProperty(AgentDataType.Authority.class), callSiteArray[9].callGetProperty(callSiteArray[10].callGetProperty(Namespace.class)))}), Set.class)), Set.class));
        this.types = (Set)ScriptBytecodeAdapter.castToType((Object)object2, Set.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.amazonClientProvider = amazonClientProvider2 = amazonClientProvider;
        this.account = netflixAmazonCredentials = account;
        this.region = string = region;
        Object object3 = callSiteArray[11].call((Object)objectMapper, callSiteArray[12].callGetProperty(SerializationFeature.class));
        this.objectMapper = (ObjectMapper)ScriptBytecodeAdapter.castToType((Object)object3, ObjectMapper.class);
        this.registry = registry2 = registry;
        this.includePublicImages = bl = includePublicImages;
        this.dynamicConfigService = dynamicConfigService2 = dynamicConfigService;
        if (includePublicImages) {
            Object object4 = callSiteArray[13].call(callSiteArray[14].callGetProperty(TimeUnit.class), (Object)60);
            this.pollIntervalMillis = DefaultTypeTransformation.longUnbox((Object)object4);
        } else {
            int n = -1;
            this.pollIntervalMillis = n;
        }
    }

    public long getPollIntervalMillis() {
        CallSite[] callSiteArray = ImageCachingAgent.$getCallSiteArray();
        return this.pollIntervalMillis;
    }

    public long getTimeoutMillis() {
        CallSite[] callSiteArray = ImageCachingAgent.$getCallSiteArray();
        return -1;
    }

    public String getProviderName() {
        CallSite[] callSiteArray = ImageCachingAgent.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[15].callGetProperty(AwsProvider.class));
    }

    @Override
    public String getAgentType() {
        CallSite[] callSiteArray = ImageCachingAgent.$getCallSiteArray();
        String scope = "public";
        if (!this.includePublicImages) {
            scope = "private";
        }
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[16].callGetProperty((Object)this.account), this.region, callSiteArray[17].callGetProperty(ImageCachingAgent.class), scope}, new String[]{"", "/", "/", "/", ""}));
    }

    public String getAccountName() {
        CallSite[] callSiteArray = ImageCachingAgent.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[18].callGetProperty((Object)this.account));
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        CallSite[] callSiteArray = ImageCachingAgent.$getCallSiteArray();
        return this.types;
    }

    public CacheResult loadData(ProviderCache providerCache) {
        CallSite[] callSiteArray = ImageCachingAgent.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (this.includePublicImages && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[19].call((Object)this.dynamicConfigService, (Object)"aws.defaults.public-images", (Object)true))) {
                callSiteArray[20].call((Object)this.log, (Object)new GStringImpl(new Object[]{callSiteArray[21].callGroovyObjectGetProperty((Object)this)}, new String[]{"short-circuiting with empty result set for public images in ", ""}));
                return (CacheResult)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].callConstructor(DefaultCacheResult.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[23].callGetProperty(callSiteArray[24].callGetProperty(Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[0]), callSiteArray[25].callGetProperty(callSiteArray[26].callGetProperty(Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[0])})), CacheResult.class);
            }
        } else if (this.includePublicImages && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].call((Object)this.dynamicConfigService, (Object)"aws.defaults.public-images", (Object)true))) {
            callSiteArray[28].call((Object)this.log, (Object)new GStringImpl(new Object[]{callSiteArray[29].callGroovyObjectGetProperty((Object)this)}, new String[]{"short-circuiting with empty result set for public images in ", ""}));
            return (CacheResult)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].callConstructor(DefaultCacheResult.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[31].callGetProperty(callSiteArray[32].callGetProperty(Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[0]), callSiteArray[33].callGetProperty(callSiteArray[34].callGetProperty(Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[0])})), CacheResult.class);
        }
        callSiteArray[35].call((Object)this.log, (Object)new GStringImpl(new Object[]{callSiteArray[36].callGroovyObjectGetProperty((Object)this)}, new String[]{"Describing items in ", ""}));
        Object amazonEC2 = callSiteArray[37].call((Object)this.amazonClientProvider, (Object)this.account, (Object)this.region, (Object)this.includePublicImages);
        Object request = callSiteArray[38].callConstructor(DescribeImagesRequest.class);
        if (this.includePublicImages) {
            callSiteArray[39].call(request, callSiteArray[40].callConstructor(Filter.class, (Object)"is-public", (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"true"})));
        } else {
            callSiteArray[41].call(request, callSiteArray[42].callConstructor(Filter.class, (Object)"is-public", (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"false"})));
        }
        List imageStates = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[43].call((Object)this.dynamicConfigService, List.class, (Object)"aws.defaults.image-states", callSiteArray[44].call(List.class)), List.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[45].call((Object)imageStates))) {
            callSiteArray[46].call((Object)this.log, (Object)new GStringImpl(new Object[]{imageStates}, new String[]{"using image state filter '", "'"}));
            callSiteArray[47].call(request, callSiteArray[48].callConstructor(Filter.class, (Object)"state", (Object)imageStates));
        }
        List images = (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[49].callGetProperty(callSiteArray[50].call(amazonEC2, request)), List.class);
        Long start = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[51].callGetProperty((Object)this.account))) {
            Object object = callSiteArray[52].callGetProperty((Object)this.amazonClientProvider);
            start = (Long)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0)), Long.class);
            public final class _loadData_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _loadData_closure1(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _loadData_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _loadData_closure1.$getCallSiteArray();
                    return callSiteArray[0].call(it);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _loadData_closure1.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadData_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "isPublic";
                    return new CallSiteArray(_loadData_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _loadData_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            public final class _loadData_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _loadData_closure2(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _loadData_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _loadData_closure2.$getCallSiteArray();
                    return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(it));
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _loadData_closure2.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadData_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "isPublic";
                    return new CallSiteArray(_loadData_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _loadData_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            images = this.includePublicImages ? (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[53].call((Object)images, (Object)new _loadData_closure1(this, this)), List.class) : (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].call((Object)images, (Object)new _loadData_closure2(this, this)), List.class);
        }
        Collection imageCacheData = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].callConstructor(ArrayList.class, callSiteArray[56].call((Object)images)), Collection.class);
        Map namedImageCacheDataMap = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].callConstructor(HashMap.class, callSiteArray[58].call((Object)images)), Map.class);
        Image image = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].call((Object)images), Iterator.class);
        if (iterator != null) {
            while (iterator.hasNext()) {
                image = (Image)ScriptBytecodeAdapter.castToType(iterator.next(), Image.class);
                Map attributes = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[60].call((Object)this.objectMapper, (Object)image, ATTRIBUTES), Map.class);
                Object imageId = callSiteArray[61].call(Keys.class, callSiteArray[62].callGetProperty((Object)image), callSiteArray[63].callGetProperty((Object)this.account), (Object)this.region);
                Object namedImageId = callSiteArray[64].call(Keys.class, callSiteArray[65].callGetProperty((Object)this.account), callSiteArray[66].callGetProperty((Object)image));
                callSiteArray[67].call((Object)imageCacheData, callSiteArray[68].callConstructor(DefaultCacheData.class, imageId, (Object)attributes, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[69].callGetProperty(callSiteArray[70].callGetProperty(Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[]{namedImageId})})));
                CacheData namedImageCacheData = (CacheData)ScriptBytecodeAdapter.castToType((Object)callSiteArray[71].call((Object)namedImageCacheDataMap, namedImageId), CacheData.class);
                if (ScriptBytecodeAdapter.compareEqual((Object)namedImageCacheData, null)) {
                    callSiteArray[72].call((Object)namedImageCacheDataMap, namedImageId, callSiteArray[73].callConstructor(DefaultCacheData.class, namedImageId, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", callSiteArray[74].callGetProperty((Object)image), "virtualizationType", callSiteArray[75].callGetProperty((Object)image), "architecture", callSiteArray[76].callGetProperty((Object)image), "creationDate", callSiteArray[77].callGetProperty((Object)image)}), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[78].callGetProperty(callSiteArray[79].callGetProperty(Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[]{imageId})})));
                    continue;
                }
                Map relationships = (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].call((Object)namedImageCacheData), Map.class);
                Collection imageRelationships = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[81].call((Object)relationships, callSiteArray[82].callGetProperty(callSiteArray[83].callGetProperty(Namespace.class))), Collection.class);
                callSiteArray[84].call((Object)imageRelationships, imageId);
            }
        }
        callSiteArray[85].callCurrent((GroovyObject)this, (Object)start);
        callSiteArray[86].call((Object)this.log, (Object)new GStringImpl(new Object[]{callSiteArray[87].call((Object)imageCacheData), callSiteArray[88].callGroovyObjectGetProperty((Object)this)}, new String[]{"Caching ", " items in ", ""}));
        return (CacheResult)ScriptBytecodeAdapter.castToType((Object)callSiteArray[89].callConstructor(DefaultCacheResult.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[90].callGetProperty(callSiteArray[91].callGetProperty(Namespace.class)), imageCacheData, callSiteArray[92].callGetProperty(callSiteArray[93].callGetProperty(Namespace.class)), callSiteArray[94].call((Object)namedImageCacheDataMap)})), CacheResult.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ImageCachingAgent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = ImageCachingAgent.$getCallSiteArray();
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ImageCachingAgent.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[95].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ImageCachingAgent.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[96].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[97].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ImageCachingAgent.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ImageCachingAgent.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = ImageCachingAgent.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ImageCachingAgent.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = ImageCachingAgent.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ImageCachingAgent.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        1 var0;
        ATTRIBUTES = var0 = new 1();
    }

    @Override
    @Generated
    public final Logger getLog() {
        return this.log;
    }

    @Generated
    public final Set<AgentDataType> getTypes() {
        return this.types;
    }

    @Generated
    public final AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Override
    @Generated
    public final NetflixAmazonCredentials getAccount() {
        return this.account;
    }

    @Override
    @Generated
    public final String getRegion() {
        return this.region;
    }

    @Generated
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    @Generated
    public final Registry getRegistry() {
        return this.registry;
    }

    @Generated
    public boolean getIncludePublicImages() {
        return this.includePublicImages;
    }

    @Generated
    public boolean isIncludePublicImages() {
        return this.includePublicImages;
    }

    @Generated
    public void setIncludePublicImages(boolean bl) {
        this.includePublicImages = bl;
    }

    @Generated
    public final DynamicConfigService getDynamicConfigService() {
        return this.dynamicConfigService;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getLogger";
        stringArray[1] = "getClass";
        stringArray[2] = "unmodifiableSet";
        stringArray[3] = "forType";
        stringArray[4] = "AUTHORITATIVE";
        stringArray[5] = "ns";
        stringArray[6] = "IMAGES";
        stringArray[7] = "forType";
        stringArray[8] = "AUTHORITATIVE";
        stringArray[9] = "ns";
        stringArray[10] = "NAMED_IMAGES";
        stringArray[11] = "enable";
        stringArray[12] = "WRITE_DATES_AS_TIMESTAMPS";
        stringArray[13] = "toMillis";
        stringArray[14] = "MINUTES";
        stringArray[15] = "PROVIDER_NAME";
        stringArray[16] = "name";
        stringArray[17] = "simpleName";
        stringArray[18] = "name";
        stringArray[19] = "isEnabled";
        stringArray[20] = "info";
        stringArray[21] = "agentType";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "ns";
        stringArray[24] = "IMAGES";
        stringArray[25] = "ns";
        stringArray[26] = "NAMED_IMAGES";
        stringArray[27] = "isEnabled";
        stringArray[28] = "info";
        stringArray[29] = "agentType";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "ns";
        stringArray[32] = "IMAGES";
        stringArray[33] = "ns";
        stringArray[34] = "NAMED_IMAGES";
        stringArray[35] = "info";
        stringArray[36] = "agentType";
        stringArray[37] = "getAmazonEC2";
        stringArray[38] = "<$constructor$>";
        stringArray[39] = "withFilters";
        stringArray[40] = "<$constructor$>";
        stringArray[41] = "withFilters";
        stringArray[42] = "<$constructor$>";
        stringArray[43] = "getConfig";
        stringArray[44] = "of";
        stringArray[45] = "isEmpty";
        stringArray[46] = "debug";
        stringArray[47] = "withFilters";
        stringArray[48] = "<$constructor$>";
        stringArray[49] = "images";
        stringArray[50] = "describeImages";
        stringArray[51] = "eddaEnabled";
        stringArray[52] = "lastModified";
        stringArray[53] = "findAll";
        stringArray[54] = "findAll";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "size";
        stringArray[57] = "<$constructor$>";
        stringArray[58] = "size";
        stringArray[59] = "iterator";
        stringArray[60] = "convertValue";
        stringArray[61] = "getImageKey";
        stringArray[62] = "imageId";
        stringArray[63] = "name";
        stringArray[64] = "getNamedImageKey";
        stringArray[65] = "name";
        stringArray[66] = "name";
        stringArray[67] = "add";
        stringArray[68] = "<$constructor$>";
        stringArray[69] = "ns";
        stringArray[70] = "NAMED_IMAGES";
        stringArray[71] = "get";
        stringArray[72] = "put";
        stringArray[73] = "<$constructor$>";
        stringArray[74] = "name";
        stringArray[75] = "virtualizationType";
        stringArray[76] = "architecture";
        stringArray[77] = "creationDate";
        stringArray[78] = "ns";
        stringArray[79] = "IMAGES";
        stringArray[80] = "getRelationships";
        stringArray[81] = "get";
        stringArray[82] = "ns";
        stringArray[83] = "IMAGES";
        stringArray[84] = "add";
        stringArray[85] = "recordDrift";
        stringArray[86] = "info";
        stringArray[87] = "size";
        stringArray[88] = "agentType";
        stringArray[89] = "<$constructor$>";
        stringArray[90] = "ns";
        stringArray[91] = "IMAGES";
        stringArray[92] = "ns";
        stringArray[93] = "NAMED_IMAGES";
        stringArray[94] = "values";
        stringArray[95] = "length";
        stringArray[96] = "getAt";
        stringArray[97] = "length";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[98];
        ImageCachingAgent.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ImageCachingAgent.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ImageCachingAgent.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public class 1
    extends TypeReference<Map<String, Object>>
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        /* synthetic */ 1() {
            MetaClass metaClass;
            CallSite[] callSiteArray = 1.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = 1.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ImageCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, ImageCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[1].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ImageCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(1.class, ImageCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = 1.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ImageCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, ImageCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[4].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[5].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, ImageCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(1.class, ImageCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = 1.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ImageCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = 1.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ImageCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = 1.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(1.class, ImageCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = 1.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(1.class, ImageCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != 1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "length";
            stringArray[1] = "getAt";
            stringArray[2] = "length";
            stringArray[3] = "length";
            stringArray[4] = "getAt";
            stringArray[5] = "length";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[6];
            1.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(1.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = 1.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

