/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.aws.data.Keys;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonReservationReport;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonReservationReportBuilder;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.aws.provider.view.AmazonS3DataProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToDoubleFunction;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ReservationReportCachingAgent
implements CachingAgent,
CustomScheduledAgent,
GroovyObject {
    private static final long DEFAULT_POLL_INTERVAL_MILLIS;
    private static final long DEFAULT_TIMEOUT_MILLIS;
    private final Collection<AgentDataType> types;
    private final ExecutorService reservationReportPool;
    private final ApplicationContext ctx;
    private Cache cacheView;
    private final AmazonClientProvider amazonClientProvider;
    private final AmazonS3DataProvider amazonS3DataProvider;
    private final CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;
    private final ObjectMapper objectMapper;
    private final AccountReservationDetailSerializer accountReservationDetailSerializer;
    private final MetricsSupport metricsSupport;
    private final Registry registry;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ReservationReportCachingAgent(Registry registry, AmazonClientProvider amazonClientProvider, AmazonS3DataProvider amazonS3DataProvider, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository, ObjectMapper objectMapper, ExecutorService reservationReportPool, ApplicationContext ctx) {
        Registry registry2;
        ApplicationContext applicationContext;
        ExecutorService executorService;
        AmazonS3DataProvider amazonS3DataProvider2;
        AmazonClientProvider amazonClientProvider2;
        MetaClass metaClass;
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        Object object = callSiteArray[0].call(Collections.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[1].call(callSiteArray[2].callGetProperty(AgentDataType.Authority.class), callSiteArray[3].callGetProperty(callSiteArray[4].callGetProperty(Namespace.class)))}));
        this.types = (Collection)ScriptBytecodeAdapter.castToType((Object)object, Collection.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.amazonClientProvider = amazonClientProvider2 = amazonClientProvider;
        this.amazonS3DataProvider = amazonS3DataProvider2 = amazonS3DataProvider;
        CredentialsRepository<NetflixAmazonCredentials> credentialsRepository2 = credentialsRepository;
        this.credentialsRepository = credentialsRepository2;
        Object module = callSiteArray[5].callConstructor(SimpleModule.class);
        Object object2 = callSiteArray[6].callConstructor(AccountReservationDetailSerializer.class);
        this.accountReservationDetailSerializer = (AccountReservationDetailSerializer)((Object)ScriptBytecodeAdapter.castToType((Object)object2, AccountReservationDetailSerializer.class));
        callSiteArray[7].call(module, AmazonReservationReport.AccountReservationDetail.class, (Object)this.accountReservationDetailSerializer);
        Object object3 = callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call((Object)objectMapper), callSiteArray[11].callGetProperty(SerializationFeature.class)), module);
        this.objectMapper = (ObjectMapper)ScriptBytecodeAdapter.castToType((Object)object3, ObjectMapper.class);
        this.reservationReportPool = executorService = reservationReportPool;
        this.ctx = applicationContext = ctx;
        Object object4 = callSiteArray[12].callConstructor(MetricsSupport.class, (Object)objectMapper, (Object)registry, (Object)new _closure1(this, this));
        this.metricsSupport = (MetricsSupport)ScriptBytecodeAdapter.castToType((Object)object4, MetricsSupport.class);
        this.registry = registry2 = registry;
    }

    public long getPollIntervalMillis() {
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        return DEFAULT_POLL_INTERVAL_MILLIS;
    }

    public long getTimeoutMillis() {
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        return DEFAULT_TIMEOUT_MILLIS;
    }

    public String getProviderName() {
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[13].callGetProperty(AwsProvider.class));
    }

    public String getAgentType() {
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[14].callGetProperty(ReservationReportCachingAgent.class)}, new String[]{"", ""}));
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        return this.types;
    }

    public Collection<NetflixAmazonCredentials> getAccounts() {
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        return (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].call(this.credentialsRepository), Collection.class);
    }

    public CacheResult loadData(ProviderCache providerCache) {
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        long startTime = DefaultTypeTransformation.longUnbox((Object)callSiteArray[16].call(System.class));
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].call((Object)log)) ? callSiteArray[18].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[19].callGroovyObjectGetProperty((Object)this)}, new String[]{"Describing items in ", ""})) : null;
        Reference reservations = new Reference((Object)((ConcurrentHashMap)ScriptBytecodeAdapter.castToType((Object)callSiteArray[20].callConstructor(ConcurrentHashMap.class), ConcurrentHashMap.class)));
        Reference errorsByRegion = new Reference((Object)((ConcurrentHashMap)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].callConstructor(ConcurrentHashMap.class), ConcurrentHashMap.class)));
        public final class _loadData_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference reservations;
            private /* synthetic */ Reference errorsByRegion;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _loadData_closure2(Object _outerInstance, Object _thisObject, Reference reservations, Reference errorsByRegion) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _loadData_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.reservations = reference2 = reservations;
                this.errorsByRegion = reference = errorsByRegion;
            }

            public Object doCall(NetflixAmazonCredentials credential) {
                CallSite[] callSiteArray = _loadData_closure2.$getCallSiteArray();
                Object object = callSiteArray[0].callCurrent((GroovyObject)this, this.reservations.get(), this.errorsByRegion.get(), (Object)credential);
                try {
                    return object;
                }
                catch (Exception e) {
                    Object object2 = callSiteArray[1].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[2].callGroovyObjectGetProperty((Object)this), (Object)this.errorsByRegion.get(), (Object)((Object)credential), (Object)"*", (Object)e));
                    return object2;
                }
            }

            @Generated
            public Object call(NetflixAmazonCredentials credential) {
                CallSite[] callSiteArray = _loadData_closure2.$getCallSiteArray();
                return callSiteArray[3].callCurrent((GroovyObject)this, (Object)credential);
            }

            @Generated
            public ConcurrentHashMap getReservations() {
                CallSite[] callSiteArray = _loadData_closure2.$getCallSiteArray();
                return (ConcurrentHashMap)ScriptBytecodeAdapter.castToType((Object)this.reservations.get(), ConcurrentHashMap.class);
            }

            @Generated
            public ConcurrentHashMap getErrorsByRegion() {
                CallSite[] callSiteArray = _loadData_closure2.$getCallSiteArray();
                return (ConcurrentHashMap)ScriptBytecodeAdapter.castToType((Object)this.errorsByRegion.get(), ConcurrentHashMap.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadData_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "extractReservations";
                stringArray[1] = "recordError";
                stringArray[2] = "registry";
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _loadData_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_loadData_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _loadData_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[22].call(callSiteArray[23].callGroovyObjectGetProperty((Object)this), (Object)new _loadData_closure2(this, this, reservations, errorsByRegion));
        Reference amazonReservationReport = new Reference(callSiteArray[24].callConstructor(AmazonReservationReport.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"start", callSiteArray[25].callConstructor(Date.class, (Object)startTime), "end", callSiteArray[26].callConstructor(Date.class)})));
        public final class _loadData_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference amazonReservationReport;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _loadData_closure3(Object _outerInstance, Object _thisObject, Reference amazonReservationReport) {
                Reference reference;
                CallSite[] callSiteArray = _loadData_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.amazonReservationReport = reference = amazonReservationReport;
            }

            public Object doCall(NetflixAmazonCredentials credentials) {
                CallSite[] callSiteArray = _loadData_closure3.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(this.amazonReservationReport.get()), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"accountId", callSiteArray[2].callGetProperty((Object)credentials), "name", callSiteArray[3].callGetProperty((Object)credentials), "regions", ScriptBytecodeAdapter.getPropertySpreadSafe(_loadData_closure3.class, (Object)callSiteArray[4].callGetProperty((Object)credentials), (String)"name")}));
            }

            @Generated
            public Object call(NetflixAmazonCredentials credentials) {
                CallSite[] callSiteArray = _loadData_closure3.$getCallSiteArray();
                return callSiteArray[5].callCurrent((GroovyObject)this, (Object)credentials);
            }

            @Generated
            public Object getAmazonReservationReport() {
                CallSite[] callSiteArray = _loadData_closure3.$getCallSiteArray();
                return this.amazonReservationReport.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadData_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "leftShift";
                stringArray[1] = "accounts";
                stringArray[2] = "accountId";
                stringArray[3] = "name";
                stringArray[4] = "regions";
                stringArray[5] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _loadData_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_loadData_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _loadData_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[27].call(callSiteArray[28].callGroovyObjectGetProperty((Object)this), (Object)new _loadData_closure3(this, this, amazonReservationReport));
        Object object2 = callSiteArray[29].call(callSiteArray[30].call((Object)((ConcurrentHashMap)reservations.get())), (Object)false, callSiteArray[31].callConstructor(AmazonReservationReport.DescendingOverallReservationDetailComparator.class));
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)amazonReservationReport.get(), (String)"reservations");
        Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[32].call((Object)log)) ? callSiteArray[33].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[34].call((Object)((ConcurrentHashMap)reservations.get())), callSiteArray[35].callGroovyObjectGetProperty((Object)this), callSiteArray[36].call(callSiteArray[37].call(System.class), (Object)startTime)}, new String[]{"Caching ", " items in ", " took ", "ms"})) : null;
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)errorsByRegion.get();
        ScriptBytecodeAdapter.setProperty((Object)concurrentHashMap, null, (Object)amazonReservationReport.get(), (String)"errorsByRegion");
        public final class _loadData_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference errorsByRegion;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _loadData_closure4(Object _outerInstance, Object _thisObject, Reference errorsByRegion) {
                Reference reference;
                CallSite[] callSiteArray = _loadData_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.errorsByRegion = reference = errorsByRegion;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _loadData_closure4.$getCallSiteArray();
                return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.errorsByRegion.get(), callSiteArray[1].call(it)));
            }

            @Generated
            public ConcurrentHashMap getErrorsByRegion() {
                CallSite[] callSiteArray = _loadData_closure4.$getCallSiteArray();
                return (ConcurrentHashMap)ScriptBytecodeAdapter.castToType((Object)this.errorsByRegion.get(), ConcurrentHashMap.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _loadData_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadData_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "containsKey";
                stringArray[1] = "region";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _loadData_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_loadData_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _loadData_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object object4 = callSiteArray[38].call(callSiteArray[39].callGetProperty(amazonReservationReport.get()), (Object)new _loadData_closure4(this, this, errorsByRegion));
        ScriptBytecodeAdapter.setProperty((Object)object4, null, (Object)amazonReservationReport.get(), (String)"reservations");
        boolean bl = false;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)bl, ReservationReportCachingAgent.class, (GroovyObject)this.accountReservationDetailSerializer, (String)"mergeVpcReservations");
        Object v2 = callSiteArray[40].call((Object)this.objectMapper, callSiteArray[41].call(callSiteArray[42].call((Object)this.objectMapper, AmazonReservationReport.Views.V2.class), amazonReservationReport.get()), Map.class);
        Object v3 = callSiteArray[43].call((Object)this.objectMapper, callSiteArray[44].call(callSiteArray[45].call((Object)this.objectMapper, AmazonReservationReport.Views.V3.class), callSiteArray[46].call(callSiteArray[47].callConstructor(AmazonReservationReportBuilder.V3.class), (Object)this.registry, callSiteArray[48].call((Object)this.objectMapper, v2, AmazonReservationReport.class))), Map.class);
        Object v4 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        try {
            v4 = callSiteArray[49].call((Object)this.objectMapper, callSiteArray[50].call(callSiteArray[51].call((Object)this.objectMapper, AmazonReservationReport.Views.V4.class), callSiteArray[52].call(callSiteArray[53].callConstructor(AmazonReservationReportBuilder.V4.class), (Object)this.amazonS3DataProvider, callSiteArray[54].call((Object)this.objectMapper, v3, AmazonReservationReport.class))), Map.class);
        }
        catch (Exception e) {
            callSiteArray[55].callStatic(ReservationReportCachingAgent.class, (Object)this.registry, null, null);
            callSiteArray[56].call((Object)log, (Object)"Failed to build 'v4' reservation report", (Object)e);
        }
        callSiteArray[57].call((Object)this.metricsSupport, callSiteArray[58].call((Object)this.objectMapper, v3, AmazonReservationReport.class));
        return (CacheResult)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].callConstructor(DefaultCacheResult.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{callSiteArray[60].callGetProperty(callSiteArray[61].callGetProperty(Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[62].callConstructor(MutableCacheData.class, (Object)"v2", (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"report", v2}), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0])), callSiteArray[63].callConstructor(MutableCacheData.class, (Object)"v2_5", (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"report", v3}), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0])), callSiteArray[64].callConstructor(MutableCacheData.class, (Object)"v3", (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"report", v4}), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0])), callSiteArray[65].callConstructor(MutableCacheData.class, (Object)"v4", (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"report", v4}), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]))})})), CacheResult.class);
    }

    /*
     * WARNING - void declaration
     */
    public void extractReservations(ConcurrentHashMap<String, AmazonReservationReport.OverallReservationDetail> reservations, ConcurrentHashMap<String, Collection<String>> errorsByRegion, NetflixAmazonCredentials credentials) {
        void var3_3;
        void var2_2;
        Reference reservations2 = new Reference(reservations);
        Reference errorsByRegion2 = new Reference((Object)var2_2);
        Reference credentials2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        public final class _extractReservations_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference reservations;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _extractReservations_closure5(Object _outerInstance, Object _thisObject, Reference reservations) {
                Reference reference;
                CallSite[] callSiteArray = _extractReservations_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.reservations = reference = reservations;
            }

            public Object doCall(String region, String availabilityZone, String operatingSystemType, String instanceType) {
                CallSite[] callSiteArray = _extractReservations_closure5.$getCallSiteArray();
                String key = ShortTypeHandling.castToString((Object)(ScriptBytecodeAdapter.compareEqual((Object)availabilityZone, null) ? callSiteArray[0].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{region, operatingSystemType, instanceType}), (Object)":") : callSiteArray[1].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{availabilityZone, operatingSystemType, instanceType}), (Object)":")));
                Object newOverallReservationDetail = callSiteArray[2].callConstructor(AmazonReservationReport.OverallReservationDetail.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"region", region, "availabilityZone", availabilityZone, "os", callSiteArray[3].callGetProperty(callSiteArray[4].call(AmazonReservationReport.OperatingSystemType.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)operatingSystemType, String.class))), "instanceType", instanceType}));
                Object existingOverallReservationDetail = callSiteArray[5].call(this.reservations.get(), (Object)key, newOverallReservationDetail);
                if (DefaultTypeTransformation.booleanUnbox((Object)existingOverallReservationDetail)) {
                    return existingOverallReservationDetail;
                }
                return newOverallReservationDetail;
            }

            @Generated
            public Object call(String region, String availabilityZone, String operatingSystemType, String instanceType) {
                CallSite[] callSiteArray = _extractReservations_closure5.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[6].callCurrent((GroovyObject)this, (Object)region, (Object)availabilityZone, (Object)operatingSystemType, (Object)instanceType);
                }
                return this.doCall(region, availabilityZone, operatingSystemType, instanceType);
            }

            @Generated
            public ConcurrentHashMap getReservations() {
                CallSite[] callSiteArray = _extractReservations_closure5.$getCallSiteArray();
                return (ConcurrentHashMap)ScriptBytecodeAdapter.castToType((Object)this.reservations.get(), ConcurrentHashMap.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractReservations_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "join";
                stringArray[1] = "join";
                stringArray[2] = "<$constructor$>";
                stringArray[3] = "name";
                stringArray[4] = "valueOf";
                stringArray[5] = "putIfAbsent";
                stringArray[6] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[7];
                _extractReservations_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_extractReservations_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _extractReservations_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference getReservation = new Reference((Object)new _extractReservations_closure5(this, this, reservations2));
        public final class _extractReservations_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference credentials;
            private /* synthetic */ Reference getReservation;
            private /* synthetic */ Reference errorsByRegion;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _extractReservations_closure6(Object _outerInstance, Object _thisObject, Reference credentials, Reference getReservation, Reference errorsByRegion) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _extractReservations_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.credentials = reference3 = credentials;
                this.getReservation = reference2 = getReservation;
                this.errorsByRegion = reference = errorsByRegion;
            }

            public Object doCall(AmazonCredentials.AWSRegion region) {
                Reference region2 = new Reference((Object)region);
                CallSite[] callSiteArray = _extractReservations_closure6.$getCallSiteArray();
                Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(ScriptBytecodeAdapter.getField(_extractReservations_closure6.class, ReservationReportCachingAgent.class, (String)"log"))) ? callSiteArray[1].call(ScriptBytecodeAdapter.getField(_extractReservations_closure6.class, ReservationReportCachingAgent.class, (String)"log"), (Object)new GStringImpl(new Object[]{callSiteArray[2].callGetProperty(this.credentials.get()), callSiteArray[3].callGetProperty((Object)((AmazonCredentials.AWSRegion)region2.get()))}, new String[]{"Fetching reservation report for ", ":", ""})) : null;
                long startTime = DefaultTypeTransformation.longUnbox((Object)callSiteArray[4].call(System.class));
                try {
                    Object amazonEC2 = callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this), this.credentials.get(), callSiteArray[7].callGetProperty((Object)((AmazonCredentials.AWSRegion)region2.get())));
                    Object cacheView = callSiteArray[8].callCurrent((GroovyObject)this);
                    public final class _closure7
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure7(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                            return callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), callSiteArray[2].callGetProperty(it), ReservedInstanceDetails.class);
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure7.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "convertValue";
                            stringArray[1] = "objectMapper";
                            stringArray[2] = "attributes";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[3];
                            _closure7.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure7.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure7.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Object reservedInstances = callSiteArray[9].call(callSiteArray[10].call(cacheView, callSiteArray[11].callGetProperty(callSiteArray[12].callGetProperty(Namespace.class)), callSiteArray[13].call(cacheView, callSiteArray[14].callGetProperty(callSiteArray[15].callGetProperty(Namespace.class)), callSiteArray[16].call(Keys.class, (Object)"*", callSiteArray[17].callGetProperty(this.credentials.get()), callSiteArray[18].callGetProperty((Object)((AmazonCredentials.AWSRegion)region2.get())))), callSiteArray[19].call(RelationshipCacheFilter.class)), (Object)new _closure7((Object)this, this.getThisObject()));
                    Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].call(ScriptBytecodeAdapter.getField(_extractReservations_closure6.class, ReservationReportCachingAgent.class, (String)"log"))) ? callSiteArray[21].call(ScriptBytecodeAdapter.getField(_extractReservations_closure6.class, ReservationReportCachingAgent.class, (String)"log"), (Object)new GStringImpl(new Object[]{callSiteArray[22].call(callSiteArray[23].call(System.class), (Object)startTime), callSiteArray[24].callGetProperty(this.credentials.get()), callSiteArray[25].callGetProperty((Object)((AmazonCredentials.AWSRegion)region2.get()))}, new String[]{"Took ", "ms to describe reserved instances for ", "/", ""})) : null;
                    public final class _closure8
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure8(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                            return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].callGetProperty(it), (Object)"active")) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"Heavy Utilization", "Partial Upfront", "All Upfront", "No Upfront"}), callSiteArray[3].callGetProperty(it)));
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure8.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure8.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "equalsIgnoreCase";
                            stringArray[1] = "state";
                            stringArray[2] = "contains";
                            stringArray[3] = "offeringType";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[4];
                            _closure8.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure8.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure8.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    public final class _closure9
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference getReservation;
                        private /* synthetic */ Reference region;
                        private /* synthetic */ Reference credentials;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure9(Object _outerInstance, Object _thisObject, Reference getReservation, Reference region, Reference credentials) {
                            Reference reference;
                            Reference reference2;
                            Reference reference3;
                            CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.getReservation = reference3 = getReservation;
                            this.region = reference2 = region;
                            this.credentials = reference = credentials;
                        }

                        public Object doCall(Object it) {
                            CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                            Object osType = callSiteArray[0].callCurrent((GroovyObject)this, callSiteArray[1].callGetProperty(it));
                            Object reservation = callSiteArray[2].call(this.getReservation.get(), callSiteArray[3].callGetProperty(this.region.get()), callSiteArray[4].callGetProperty(it), callSiteArray[5].callGetProperty(osType), callSiteArray[6].callGetProperty(it));
                            callSiteArray[7].call(callSiteArray[8].callGetProperty(reservation), callSiteArray[9].callGetProperty(it));
                            return callSiteArray[10].call(callSiteArray[11].callGetProperty(callSiteArray[12].call(reservation, callSiteArray[13].callGetProperty(this.credentials.get()))), callSiteArray[14].callGetProperty(it));
                        }

                        @Generated
                        public Object getGetReservation() {
                            CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                            return this.getReservation.get();
                        }

                        @Generated
                        public AmazonCredentials.AWSRegion getRegion() {
                            CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                            return (AmazonCredentials.AWSRegion)ScriptBytecodeAdapter.castToType((Object)this.region.get(), AmazonCredentials.AWSRegion.class);
                        }

                        @Generated
                        public NetflixAmazonCredentials getCredentials() {
                            CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                            return (NetflixAmazonCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), NetflixAmazonCredentials.class));
                        }

                        @Generated
                        public Object doCall() {
                            CallSite[] callSiteArray = _closure9.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure9.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "operatingSystemType";
                            stringArray[1] = "productDescription";
                            stringArray[2] = "call";
                            stringArray[3] = "name";
                            stringArray[4] = "availabilityZone";
                            stringArray[5] = "name";
                            stringArray[6] = "instanceType";
                            stringArray[7] = "addAndGet";
                            stringArray[8] = "totalReserved";
                            stringArray[9] = "instanceCount";
                            stringArray[10] = "addAndGet";
                            stringArray[11] = "reservedVpc";
                            stringArray[12] = "getAccount";
                            stringArray[13] = "name";
                            stringArray[14] = "instanceCount";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[15];
                            _closure9.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure9.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure9.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    callSiteArray[26].call(callSiteArray[27].call(reservedInstances, (Object)new _closure8((Object)this, this.getThisObject())), (Object)new _closure9((Object)this, this.getThisObject(), this.getReservation, region2, this.credentials));
                    startTime = DefaultTypeTransformation.longUnbox((Object)callSiteArray[28].call(System.class));
                    Reference fetchedInstanceCount = new Reference((Object)0);
                    Object describeInstancesRequest = callSiteArray[29].call(callSiteArray[30].callConstructor(DescribeInstancesRequest.class), (Object)500);
                    Reference allowedStates = new Reference((Object)((Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"pending", "running"}), Set.class)));
                    while (true) {
                        Object object3 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[31].call(ScriptBytecodeAdapter.getField(_extractReservations_closure6.class, ReservationReportCachingAgent.class, (String)"log"))) ? callSiteArray[32].call(ScriptBytecodeAdapter.getField(_extractReservations_closure6.class, ReservationReportCachingAgent.class, (String)"log"), (Object)new GStringImpl(new Object[]{callSiteArray[33].callGetProperty(this.credentials.get()), callSiteArray[34].callGetProperty((Object)((AmazonCredentials.AWSRegion)region2.get()))}, new String[]{"Describing instances for ", "/", ""})) : null;
                        Object result = callSiteArray[35].call(amazonEC2, describeInstancesRequest);
                        Object object4 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[36].call(ScriptBytecodeAdapter.getField(_extractReservations_closure6.class, ReservationReportCachingAgent.class, (String)"log"))) ? callSiteArray[37].call(ScriptBytecodeAdapter.getField(_extractReservations_closure6.class, ReservationReportCachingAgent.class, (String)"log"), (Object)new GStringImpl(new Object[]{callSiteArray[38].callGetProperty(this.credentials.get()), callSiteArray[39].callGetProperty((Object)((AmazonCredentials.AWSRegion)region2.get()))}, new String[]{"Described instances for ", "/", ""})) : null;
                        public final class _closure10
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference allowedStates;
                            private /* synthetic */ Reference getReservation;
                            private /* synthetic */ Reference credentials;
                            private /* synthetic */ Reference fetchedInstanceCount;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure10(Object _outerInstance, Object _thisObject, Reference allowedStates, Reference getReservation, Reference credentials, Reference fetchedInstanceCount) {
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.allowedStates = reference4 = allowedStates;
                                this.getReservation = reference3 = getReservation;
                                this.credentials = reference2 = credentials;
                                this.fetchedInstanceCount = reference = fetchedInstanceCount;
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                public final class _closure11
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference allowedStates;
                                    private /* synthetic */ Reference getReservation;
                                    private /* synthetic */ Reference credentials;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;
                                    private static /* synthetic */ SoftReference $callSiteArray;

                                    public _closure11(Object _outerInstance, Object _thisObject, Reference allowedStates, Reference getReservation, Reference credentials) {
                                        Reference reference;
                                        Reference reference2;
                                        Reference reference3;
                                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                        super(_outerInstance, _thisObject);
                                        this.allowedStates = reference3 = allowedStates;
                                        this.getReservation = reference2 = getReservation;
                                        this.credentials = reference = credentials;
                                    }

                                    public Object doCall(Object it) {
                                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(this.allowedStates.get(), callSiteArray[1].call(callSiteArray[2].callGetProperty(callSiteArray[3].callGetProperty(it)))))) {
                                            return null;
                                        }
                                        Object osTypeName = callSiteArray[4].callGetProperty(callSiteArray[5].callCurrent((GroovyObject)this, (Object)(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callGetProperty(it)) ? "Windows" : "Linux/UNIX")));
                                        Object reservation = callSiteArray[7].call(this.getReservation.get(), callSiteArray[8].call(callSiteArray[9].callGetProperty(callSiteArray[10].callGetProperty(it)), (Object)ScriptBytecodeAdapter.createRange((Object)0, (Object)-2, (boolean)true)), callSiteArray[11].callGetProperty(callSiteArray[12].callGetProperty(it)), osTypeName, callSiteArray[13].callGetProperty(it));
                                        callSiteArray[14].call(callSiteArray[15].callGetProperty(reservation));
                                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].callGetProperty(it))) {
                                            return callSiteArray[17].call(callSiteArray[18].callGetProperty(callSiteArray[19].call(reservation, callSiteArray[20].callGetProperty(this.credentials.get()))));
                                        }
                                        return callSiteArray[21].call(callSiteArray[22].callGetProperty(callSiteArray[23].call(reservation, callSiteArray[24].callGetProperty(this.credentials.get()))));
                                    }

                                    @Generated
                                    public Object getAllowedStates() {
                                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                        return this.allowedStates.get();
                                    }

                                    @Generated
                                    public Object getGetReservation() {
                                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                        return this.getReservation.get();
                                    }

                                    @Generated
                                    public NetflixAmazonCredentials getCredentials() {
                                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                        return (NetflixAmazonCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), NetflixAmazonCredentials.class));
                                    }

                                    @Generated
                                    public Object doCall() {
                                        CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                                        return this.doCall(null);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure11.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                        stringArray[0] = "contains";
                                        stringArray[1] = "toLowerCase";
                                        stringArray[2] = "name";
                                        stringArray[3] = "state";
                                        stringArray[4] = "name";
                                        stringArray[5] = "operatingSystemType";
                                        stringArray[6] = "platform";
                                        stringArray[7] = "call";
                                        stringArray[8] = "getAt";
                                        stringArray[9] = "availabilityZone";
                                        stringArray[10] = "placement";
                                        stringArray[11] = "availabilityZone";
                                        stringArray[12] = "placement";
                                        stringArray[13] = "instanceType";
                                        stringArray[14] = "incrementAndGet";
                                        stringArray[15] = "totalUsed";
                                        stringArray[16] = "vpcId";
                                        stringArray[17] = "incrementAndGet";
                                        stringArray[18] = "usedVpc";
                                        stringArray[19] = "getAccount";
                                        stringArray[20] = "name";
                                        stringArray[21] = "incrementAndGet";
                                        stringArray[22] = "used";
                                        stringArray[23] = "getAccount";
                                        stringArray[24] = "name";
                                    }

                                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                        String[] stringArray = new String[25];
                                        _closure11.$createCallSiteArray_1(stringArray);
                                        return new CallSiteArray(_closure11.class, stringArray);
                                    }

                                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                        CallSiteArray callSiteArray;
                                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                            callSiteArray = _closure11.$createCallSiteArray();
                                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                        }
                                        return callSiteArray.array;
                                    }
                                }
                                callSiteArray[0].call(callSiteArray[1].call(it), (Object)new _closure11((Object)this, this.getThisObject(), this.allowedStates, this.getReservation, this.credentials));
                                Object object = callSiteArray[2].call(this.fetchedInstanceCount.get(), callSiteArray[3].call(callSiteArray[4].call(it)));
                                this.fetchedInstanceCount.set(object);
                                return object;
                            }

                            @Generated
                            public Object getAllowedStates() {
                                CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                return this.allowedStates.get();
                            }

                            @Generated
                            public Object getGetReservation() {
                                CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                return this.getReservation.get();
                            }

                            @Generated
                            public NetflixAmazonCredentials getCredentials() {
                                CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                return (NetflixAmazonCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), NetflixAmazonCredentials.class));
                            }

                            @Generated
                            public Object getFetchedInstanceCount() {
                                CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                return this.fetchedInstanceCount.get();
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure10.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "each";
                                stringArray[1] = "getInstances";
                                stringArray[2] = "plus";
                                stringArray[3] = "size";
                                stringArray[4] = "getInstances";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[5];
                                _closure10.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure10.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure10.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        callSiteArray[40].call(callSiteArray[41].callGetProperty(result), (Object)new _closure10((Object)this, this.getThisObject(), allowedStates, this.getReservation, this.credentials, fetchedInstanceCount));
                        Object object5 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[42].call(ScriptBytecodeAdapter.getField(_extractReservations_closure6.class, ReservationReportCachingAgent.class, (String)"log"))) ? callSiteArray[43].call(ScriptBytecodeAdapter.getField(_extractReservations_closure6.class, ReservationReportCachingAgent.class, (String)"log"), (Object)new GStringImpl(new Object[]{fetchedInstanceCount.get(), callSiteArray[44].callGetProperty(this.credentials.get()), callSiteArray[45].callGetProperty((Object)((AmazonCredentials.AWSRegion)region2.get())), callSiteArray[46].callGetProperty(result)}, new String[]{"Fetched ", " instances in ", "/", " (nextToken: ", ")"})) : null;
                        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].callGetProperty(result))) {
                            callSiteArray[48].call(describeInstancesRequest, callSiteArray[49].callGetProperty(result));
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    callSiteArray[50].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)callSiteArray[51].callGroovyObjectGetProperty((Object)this), (Object)this.errorsByRegion.get(), (Object)this.credentials.get(), (Object)callSiteArray[52].callGetProperty((Object)((AmazonCredentials.AWSRegion)region2.get())), (Object)e));
                }
                return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[53].call(ScriptBytecodeAdapter.getField(_extractReservations_closure6.class, ReservationReportCachingAgent.class, (String)"log"))) ? callSiteArray[54].call(ScriptBytecodeAdapter.getField(_extractReservations_closure6.class, ReservationReportCachingAgent.class, (String)"log"), (Object)new GStringImpl(new Object[]{callSiteArray[55].call(callSiteArray[56].call(System.class), (Object)startTime), callSiteArray[57].callGetProperty(this.credentials.get()), callSiteArray[58].callGetProperty((Object)((AmazonCredentials.AWSRegion)region2.get()))}, new String[]{"Took ", "ms to describe instances for ", "/", ""})) : null;
            }

            @Generated
            public Object call(AmazonCredentials.AWSRegion region) {
                Reference region2 = new Reference((Object)region);
                CallSite[] callSiteArray = _extractReservations_closure6.$getCallSiteArray();
                return callSiteArray[59].callCurrent((GroovyObject)this, (Object)((AmazonCredentials.AWSRegion)region2.get()));
            }

            @Generated
            public NetflixAmazonCredentials getCredentials() {
                CallSite[] callSiteArray = _extractReservations_closure6.$getCallSiteArray();
                return (NetflixAmazonCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), NetflixAmazonCredentials.class));
            }

            @Generated
            public Object getGetReservation() {
                CallSite[] callSiteArray = _extractReservations_closure6.$getCallSiteArray();
                return this.getReservation.get();
            }

            @Generated
            public ConcurrentHashMap getErrorsByRegion() {
                CallSite[] callSiteArray = _extractReservations_closure6.$getCallSiteArray();
                return (ConcurrentHashMap)ScriptBytecodeAdapter.castToType((Object)this.errorsByRegion.get(), ConcurrentHashMap.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractReservations_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "isInfoEnabled";
                stringArray[1] = "info";
                stringArray[2] = "name";
                stringArray[3] = "name";
                stringArray[4] = "currentTimeMillis";
                stringArray[5] = "getAmazonEC2";
                stringArray[6] = "amazonClientProvider";
                stringArray[7] = "name";
                stringArray[8] = "getCacheView";
                stringArray[9] = "collect";
                stringArray[10] = "getAll";
                stringArray[11] = "ns";
                stringArray[12] = "RESERVED_INSTANCES";
                stringArray[13] = "filterIdentifiers";
                stringArray[14] = "ns";
                stringArray[15] = "RESERVED_INSTANCES";
                stringArray[16] = "getReservedInstancesKey";
                stringArray[17] = "name";
                stringArray[18] = "name";
                stringArray[19] = "none";
                stringArray[20] = "isDebugEnabled";
                stringArray[21] = "debug";
                stringArray[22] = "minus";
                stringArray[23] = "currentTimeMillis";
                stringArray[24] = "name";
                stringArray[25] = "name";
                stringArray[26] = "each";
                stringArray[27] = "findAll";
                stringArray[28] = "currentTimeMillis";
                stringArray[29] = "withMaxResults";
                stringArray[30] = "<$constructor$>";
                stringArray[31] = "isDebugEnabled";
                stringArray[32] = "debug";
                stringArray[33] = "name";
                stringArray[34] = "name";
                stringArray[35] = "describeInstances";
                stringArray[36] = "isDebugEnabled";
                stringArray[37] = "debug";
                stringArray[38] = "name";
                stringArray[39] = "name";
                stringArray[40] = "each";
                stringArray[41] = "reservations";
                stringArray[42] = "isDebugEnabled";
                stringArray[43] = "debug";
                stringArray[44] = "name";
                stringArray[45] = "name";
                stringArray[46] = "nextToken";
                stringArray[47] = "nextToken";
                stringArray[48] = "withNextToken";
                stringArray[49] = "nextToken";
                stringArray[50] = "recordError";
                stringArray[51] = "registry";
                stringArray[52] = "name";
                stringArray[53] = "isDebugEnabled";
                stringArray[54] = "debug";
                stringArray[55] = "minus";
                stringArray[56] = "currentTimeMillis";
                stringArray[57] = "name";
                stringArray[58] = "name";
                stringArray[59] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[60];
                _extractReservations_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_extractReservations_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _extractReservations_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[66].call(callSiteArray[67].callGetProperty((Object)((NetflixAmazonCredentials)((Object)credentials2.get()))), (Object)new _extractReservations_closure6(this, this, credentials2, getReservation, errorsByRegion2));
    }

    public static void recordError(Registry registry, ConcurrentHashMap<String, Collection<String>> errorsByRegion, NetflixAmazonCredentials credentials, String region, Exception e) {
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        String errorMessage = (String)ScriptBytecodeAdapter.asType((Object)new GStringImpl(new Object[]{callSiteArray[68].callGetProperty((Object)credentials), region, callSiteArray[69].callGetProperty((Object)e)}, new String[]{"Failed to describe instances in ", ":", ", reason: ", ""}), String.class);
        callSiteArray[70].call((Object)log, (Object)errorMessage, (Object)e);
        Object errors = callSiteArray[71].callConstructor(CopyOnWriteArrayList.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{errorMessage}));
        Object previousValue = callSiteArray[72].call(errorsByRegion, (Object)region, errors);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)previousValue, null)) {
            callSiteArray[73].call(previousValue, (Object)errorMessage);
        }
        callSiteArray[74].callStatic(ReservationReportCachingAgent.class, (Object)registry, callSiteArray[75].callGetProperty((Object)credentials), (Object)region);
    }

    public static void recordErrorMetric(Registry registry, String account, String region) {
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        Object id = callSiteArray[76].call((Object)registry, (Object)"reservedInstances.errors");
        if (DefaultTypeTransformation.booleanUnbox((Object)account)) {
            id = callSiteArray[77].call(id, (Object)"account", (Object)account);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)region)) {
            id = callSiteArray[78].call(id, (Object)"region", (Object)region);
        }
        callSiteArray[79].call(callSiteArray[80].call((Object)registry, id));
    }

    public static AmazonReservationReport.OperatingSystemType operatingSystemType(String productDescription) {
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        Object object = callSiteArray[81].call((Object)productDescription);
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[82].call((Object)"Linux/UNIX"))) {
            return (AmazonReservationReport.OperatingSystemType)ShortTypeHandling.castToEnum((Object)callSiteArray[83].callGetProperty(AmazonReservationReport.OperatingSystemType.class), AmazonReservationReport.OperatingSystemType.class);
        }
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[84].call((Object)"Linux/UNIX (Amazon VPC)"))) {
            return (AmazonReservationReport.OperatingSystemType)ShortTypeHandling.castToEnum((Object)callSiteArray[85].callGetProperty(AmazonReservationReport.OperatingSystemType.class), AmazonReservationReport.OperatingSystemType.class);
        }
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[86].call((Object)"Windows"))) {
            return (AmazonReservationReport.OperatingSystemType)ShortTypeHandling.castToEnum((Object)callSiteArray[87].callGetProperty(AmazonReservationReport.OperatingSystemType.class), AmazonReservationReport.OperatingSystemType.class);
        }
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[88].call((Object)"Windows (Amazon VPC)"))) {
            return (AmazonReservationReport.OperatingSystemType)ShortTypeHandling.castToEnum((Object)callSiteArray[89].callGetProperty(AmazonReservationReport.OperatingSystemType.class), AmazonReservationReport.OperatingSystemType.class);
        }
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[90].call((Object)"Red Hat Enterprise Linux"))) {
            return (AmazonReservationReport.OperatingSystemType)ShortTypeHandling.castToEnum((Object)callSiteArray[91].callGetProperty(AmazonReservationReport.OperatingSystemType.class), AmazonReservationReport.OperatingSystemType.class);
        }
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[92].call((Object)"Windows with SQL Server Standard"))) {
            return (AmazonReservationReport.OperatingSystemType)ShortTypeHandling.castToEnum((Object)callSiteArray[93].callGetProperty(AmazonReservationReport.OperatingSystemType.class), AmazonReservationReport.OperatingSystemType.class);
        }
        if (ScriptBytecodeAdapter.isCase((Object)object, (Object)callSiteArray[94].call((Object)"Windows BYOL (Amazon VPC)"))) {
            return (AmazonReservationReport.OperatingSystemType)ShortTypeHandling.castToEnum((Object)callSiteArray[95].callGetProperty(AmazonReservationReport.OperatingSystemType.class), AmazonReservationReport.OperatingSystemType.class);
        }
        Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[96].call((Object)log)) ? callSiteArray[97].call((Object)log, (Object)new GStringImpl(new Object[]{productDescription}, new String[]{"Unknown product description (", ")"})) : null;
        return (AmazonReservationReport.OperatingSystemType)ShortTypeHandling.castToEnum((Object)callSiteArray[98].callGetProperty(AmazonReservationReport.OperatingSystemType.class), AmazonReservationReport.OperatingSystemType.class);
    }

    private Cache getCacheView() {
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.cacheView)) {
            Object object = callSiteArray[99].call((Object)this.ctx, Cache.class);
            this.cacheView = (Cache)ScriptBytecodeAdapter.castToType((Object)object, Cache.class);
        }
        return this.cacheView;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ReservationReportCachingAgent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ReservationReportCachingAgent.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
        }
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[100].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ReservationReportCachingAgent.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[101].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[102].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ReservationReportCachingAgent.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ReservationReportCachingAgent.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ReservationReportCachingAgent.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        CallSite[] callSiteArray = ReservationReportCachingAgent.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ReservationReportCachingAgent.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = ReservationReportCachingAgent.$getCallSiteArray()[103].call(ReservationReportCachingAgent.$getCallSiteArray()[104].callGetProperty(TimeUnit.class), (Object)1);
        DEFAULT_POLL_INTERVAL_MILLIS = DefaultTypeTransformation.longUnbox((Object)object);
        Object object2 = ReservationReportCachingAgent.$getCallSiteArray()[105].call(ReservationReportCachingAgent.$getCallSiteArray()[106].callGetProperty(TimeUnit.class), (Object)5);
        DEFAULT_TIMEOUT_MILLIS = DefaultTypeTransformation.longUnbox((Object)object2);
        Object object3 = ReservationReportCachingAgent.$getCallSiteArray()[107].call(LoggerFactory.class, (Object)"com.netflix.spinnaker.clouddriver.aws.provider.agent.ReservationReportCachingAgent");
        log = (Logger)ScriptBytecodeAdapter.castToType((Object)object3, Logger.class);
    }

    @Generated
    public final Collection<AgentDataType> getTypes() {
        return this.types;
    }

    @Generated
    public final AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public final AmazonS3DataProvider getAmazonS3DataProvider() {
        return this.amazonS3DataProvider;
    }

    @Generated
    public final CredentialsRepository<NetflixAmazonCredentials> getCredentialsRepository() {
        return this.credentialsRepository;
    }

    @Generated
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public final AccountReservationDetailSerializer getAccountReservationDetailSerializer() {
        return this.accountReservationDetailSerializer;
    }

    @Generated
    public final MetricsSupport getMetricsSupport() {
        return this.metricsSupport;
    }

    @Generated
    public final Registry getRegistry() {
        return this.registry;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "unmodifiableCollection";
        stringArray[1] = "forType";
        stringArray[2] = "AUTHORITATIVE";
        stringArray[3] = "ns";
        stringArray[4] = "RESERVATION_REPORTS";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "<$constructor$>";
        stringArray[7] = "addSerializer";
        stringArray[8] = "registerModule";
        stringArray[9] = "enable";
        stringArray[10] = "copy";
        stringArray[11] = "WRITE_DATES_AS_TIMESTAMPS";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "PROVIDER_NAME";
        stringArray[14] = "simpleName";
        stringArray[15] = "getAll";
        stringArray[16] = "currentTimeMillis";
        stringArray[17] = "isInfoEnabled";
        stringArray[18] = "info";
        stringArray[19] = "agentType";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "<$constructor$>";
        stringArray[22] = "each";
        stringArray[23] = "accounts";
        stringArray[24] = "<$constructor$>";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "<$constructor$>";
        stringArray[27] = "each";
        stringArray[28] = "accounts";
        stringArray[29] = "sort";
        stringArray[30] = "values";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "isInfoEnabled";
        stringArray[33] = "info";
        stringArray[34] = "size";
        stringArray[35] = "agentType";
        stringArray[36] = "minus";
        stringArray[37] = "currentTimeMillis";
        stringArray[38] = "findAll";
        stringArray[39] = "reservations";
        stringArray[40] = "readValue";
        stringArray[41] = "writeValueAsString";
        stringArray[42] = "writerWithView";
        stringArray[43] = "readValue";
        stringArray[44] = "writeValueAsString";
        stringArray[45] = "writerWithView";
        stringArray[46] = "build";
        stringArray[47] = "<$constructor$>";
        stringArray[48] = "convertValue";
        stringArray[49] = "readValue";
        stringArray[50] = "writeValueAsString";
        stringArray[51] = "writerWithView";
        stringArray[52] = "build";
        stringArray[53] = "<$constructor$>";
        stringArray[54] = "convertValue";
        stringArray[55] = "recordErrorMetric";
        stringArray[56] = "error";
        stringArray[57] = "registerMetrics";
        stringArray[58] = "convertValue";
        stringArray[59] = "<$constructor$>";
        stringArray[60] = "ns";
        stringArray[61] = "RESERVATION_REPORTS";
        stringArray[62] = "<$constructor$>";
        stringArray[63] = "<$constructor$>";
        stringArray[64] = "<$constructor$>";
        stringArray[65] = "<$constructor$>";
        stringArray[66] = "each";
        stringArray[67] = "regions";
        stringArray[68] = "name";
        stringArray[69] = "message";
        stringArray[70] = "error";
        stringArray[71] = "<$constructor$>";
        stringArray[72] = "putIfAbsent";
        stringArray[73] = "add";
        stringArray[74] = "recordErrorMetric";
        stringArray[75] = "name";
        stringArray[76] = "createId";
        stringArray[77] = "withTag";
        stringArray[78] = "withTag";
        stringArray[79] = "increment";
        stringArray[80] = "counter";
        stringArray[81] = "toUpperCase";
        stringArray[82] = "toUpperCase";
        stringArray[83] = "LINUX";
        stringArray[84] = "toUpperCase";
        stringArray[85] = "LINUX_VPC";
        stringArray[86] = "toUpperCase";
        stringArray[87] = "WINDOWS";
        stringArray[88] = "toUpperCase";
        stringArray[89] = "WINDOWS_VPC";
        stringArray[90] = "toUpperCase";
        stringArray[91] = "RHEL";
        stringArray[92] = "toUpperCase";
        stringArray[93] = "WINDOWS_SQL_SERVER";
        stringArray[94] = "toUpperCase";
        stringArray[95] = "WINDOWS_VPC_BYOL";
        stringArray[96] = "isErrorEnabled";
        stringArray[97] = "error";
        stringArray[98] = "UNKNOWN";
        stringArray[99] = "getBean";
        stringArray[100] = "length";
        stringArray[101] = "getAt";
        stringArray[102] = "length";
        stringArray[103] = "toMillis";
        stringArray[104] = "MINUTES";
        stringArray[105] = "toMillis";
        stringArray[106] = "MINUTES";
        stringArray[107] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[108];
        ReservationReportCachingAgent.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ReservationReportCachingAgent.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ReservationReportCachingAgent.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class MutableCacheData
    implements CacheData,
    GroovyObject {
        private final String id;
        private int ttlSeconds;
        private final Map<String, Object> attributes;
        private final Map<String, Collection<String>> relationships;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public MutableCacheData(String id) {
            String string;
            MetaClass metaClass;
            Map map;
            int n;
            CallSite[] callSiteArray = MutableCacheData.$getCallSiteArray();
            this.ttlSeconds = n = -1;
            this.attributes = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            Object object = callSiteArray[0].call((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), (Object)new _closure1(this, this));
            this.relationships = (Map)ScriptBytecodeAdapter.castToType((Object)object, Map.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.id = string = id;
        }

        @JsonCreator
        public MutableCacheData(@JsonProperty(value="id") String id, @JsonProperty(value="attributes") Map<String, Object> attributes, @JsonProperty(value="relationships") Map<String, Collection<String>> relationships) {
            CallSite[] callSiteArray = MutableCacheData.$getCallSiteArray();
            this(id);
            callSiteArray[1].call(this.attributes, attributes);
            callSiteArray[2].call(this.relationships, relationships);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != MutableCacheData.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = MutableCacheData.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[4].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[5].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = MutableCacheData.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[7].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[8].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(MutableCacheData.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = MutableCacheData.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = MutableCacheData.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = MutableCacheData.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(MutableCacheData.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = MutableCacheData.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(MutableCacheData.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public final String getId() {
            return this.id;
        }

        @Generated
        public int getTtlSeconds() {
            return this.ttlSeconds;
        }

        @Generated
        public void setTtlSeconds(int n) {
            this.ttlSeconds = n;
        }

        @Generated
        public final Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @Generated
        public final Map<String, Collection<String>> getRelationships() {
            return this.relationships;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "withDefault";
            stringArray[1] = "putAll";
            stringArray[2] = "putAll";
            stringArray[3] = "length";
            stringArray[4] = "getAt";
            stringArray[5] = "length";
            stringArray[6] = "length";
            stringArray[7] = "getAt";
            stringArray[8] = "length";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[9];
            MutableCacheData.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(MutableCacheData.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = MutableCacheData.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        public final class _closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _closure1.$getCallSiteArray();
                return (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
    }

    public static class AccountReservationDetailSerializer
    extends JsonSerializer<AmazonReservationReport.AccountReservationDetail>
    implements GroovyObject {
        private ObjectMapper objectMapper;
        private boolean mergeVpcReservations;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public AccountReservationDetailSerializer() {
            MetaClass metaClass;
            CallSite[] callSiteArray = AccountReservationDetailSerializer.$getCallSiteArray();
            Object object = callSiteArray[0].callConstructor(ObjectMapper.class);
            this.objectMapper = (ObjectMapper)ScriptBytecodeAdapter.castToType((Object)object, ObjectMapper.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void serialize(AmazonReservationReport.AccountReservationDetail value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            CallSite[] callSiteArray = AccountReservationDetailSerializer.$getCallSiteArray();
            if (this.mergeVpcReservations) {
                value = (AmazonReservationReport.AccountReservationDetail)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callConstructor(AmazonReservationReport.AccountReservationDetail.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"reserved", callSiteArray[2].callConstructor(AtomicInteger.class, callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].callGroovyObjectGetProperty((Object)value)), callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)value)))), "used", callSiteArray[8].callConstructor(AtomicInteger.class, callSiteArray[9].call(callSiteArray[10].call(callSiteArray[11].callGroovyObjectGetProperty((Object)value)), callSiteArray[12].call(callSiteArray[13].callGroovyObjectGetProperty((Object)value)))), "reservedVpc", null, "usedVpc", null})), AmazonReservationReport.AccountReservationDetail.class);
            }
            callSiteArray[14].call((Object)gen, callSiteArray[15].call((Object)this.objectMapper, (Object)value, Map.class));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != AccountReservationDetailSerializer.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AccountReservationDetailSerializer.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[16].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[17].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[18].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = AccountReservationDetailSerializer.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[19].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[20].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[21].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = AccountReservationDetailSerializer.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = AccountReservationDetailSerializer.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = AccountReservationDetailSerializer.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = AccountReservationDetailSerializer.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(AccountReservationDetailSerializer.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }

        @Generated
        public void setObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        @Generated
        public boolean getMergeVpcReservations() {
            return this.mergeVpcReservations;
        }

        @Generated
        public boolean isMergeVpcReservations() {
            return this.mergeVpcReservations;
        }

        @Generated
        public void setMergeVpcReservations(boolean bl) {
            this.mergeVpcReservations = bl;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "<$constructor$>";
            stringArray[1] = "<$constructor$>";
            stringArray[2] = "<$constructor$>";
            stringArray[3] = "plus";
            stringArray[4] = "intValue";
            stringArray[5] = "reserved";
            stringArray[6] = "intValue";
            stringArray[7] = "reservedVpc";
            stringArray[8] = "<$constructor$>";
            stringArray[9] = "plus";
            stringArray[10] = "intValue";
            stringArray[11] = "used";
            stringArray[12] = "intValue";
            stringArray[13] = "usedVpc";
            stringArray[14] = "writeObject";
            stringArray[15] = "convertValue";
            stringArray[16] = "length";
            stringArray[17] = "getAt";
            stringArray[18] = "length";
            stringArray[19] = "length";
            stringArray[20] = "getAt";
            stringArray[21] = "length";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[22];
            AccountReservationDetailSerializer.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(AccountReservationDetailSerializer.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = AccountReservationDetailSerializer.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class ReservedInstanceDetails
    implements GroovyObject {
        private String state;
        private String offeringType;
        private String productDescription;
        private String availabilityZone;
        private String region;
        private String instanceType;
        private int instanceCount;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        @Generated
        public ReservedInstanceDetails() {
            MetaClass metaClass;
            CallSite[] callSiteArray = ReservedInstanceDetails.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ReservedInstanceDetails.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ReservedInstanceDetails.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[1].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ReservedInstanceDetails.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[3].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[4].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[5].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = ReservedInstanceDetails.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = ReservedInstanceDetails.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ReservedInstanceDetails.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = ReservedInstanceDetails.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ReservedInstanceDetails.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getState() {
            return this.state;
        }

        @Generated
        public void setState(String string) {
            this.state = string;
        }

        @Generated
        public String getOfferingType() {
            return this.offeringType;
        }

        @Generated
        public void setOfferingType(String string) {
            this.offeringType = string;
        }

        @Generated
        public String getProductDescription() {
            return this.productDescription;
        }

        @Generated
        public void setProductDescription(String string) {
            this.productDescription = string;
        }

        @Generated
        public String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Generated
        public void setAvailabilityZone(String string) {
            this.availabilityZone = string;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public void setRegion(String string) {
            this.region = string;
        }

        @Generated
        public String getInstanceType() {
            return this.instanceType;
        }

        @Generated
        public void setInstanceType(String string) {
            this.instanceType = string;
        }

        @Generated
        public int getInstanceCount() {
            return this.instanceCount;
        }

        @Generated
        public void setInstanceCount(int n) {
            this.instanceCount = n;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "length";
            stringArray[1] = "getAt";
            stringArray[2] = "length";
            stringArray[3] = "length";
            stringArray[4] = "getAt";
            stringArray[5] = "length";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[6];
            ReservedInstanceDetails.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(ReservedInstanceDetails.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ReservedInstanceDetails.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }

    public static class MetricsSupport
    implements GroovyObject {
        private final LoadingCache<String, AmazonReservationReport> reservationReportCache;
        private final Map<String, Id> existingMetricIds;
        private final ObjectMapper objectMapper;
        private final Registry registry;
        private final Closure<Cache> cache;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public MetricsSupport(ObjectMapper objectMapper, Registry registry, Closure<Cache> cache) {
            ObjectMapper objectMapper2;
            Registry registry2;
            MetaClass metaClass;
            CallSite[] callSiteArray = MetricsSupport.$getCallSiteArray();
            Object object = callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(CacheBuilder.class), (Object)1)), (Object)1), (Object)15, callSiteArray[6].callGetProperty(TimeUnit.class)), (Object)new 1(this));
            this.reservationReportCache = (LoadingCache)ScriptBytecodeAdapter.castToType((Object)object, LoadingCache.class);
            Object object2 = callSiteArray[7].callConstructor(ConcurrentHashMap.class);
            this.existingMetricIds = (Map)ScriptBytecodeAdapter.castToType((Object)object2, Map.class);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.registry = registry2 = registry;
            this.objectMapper = objectMapper2 = objectMapper;
            Closure<Cache> closure = cache;
            this.cache = closure;
        }

        /*
         * WARNING - void declaration
         */
        private void registerMetric(String name, Map<String, String> tags, Closure metricValueClosure) {
            void var3_3;
            Reference tags2 = new Reference(tags);
            Reference metricValueClosure2 = new Reference((Object)var3_3);
            CallSite[] callSiteArray = MetricsSupport.$getCallSiteArray();
            Object id = callSiteArray[8].call(callSiteArray[9].call((Object)this.registry, (Object)name), (Object)((Map)tags2.get()));
            Object existingId = callSiteArray[10].call(this.existingMetricIds, callSiteArray[11].call(callSiteArray[12].call((Object)name, (Object)":"), callSiteArray[13].call(callSiteArray[14].call(callSiteArray[15].call((Object)((Map)tags2.get()))), (Object)":")), id);
            if (!DefaultTypeTransformation.booleanUnbox((Object)existingId)) {
                public final class _registerMetric_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference tags;
                    private /* synthetic */ Reference metricValueClosure;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _registerMetric_closure1(Object _outerInstance, Object _thisObject, Reference tags, Reference metricValueClosure) {
                        Reference reference;
                        Reference reference2;
                        CallSite[] callSiteArray = _registerMetric_closure1.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.tags = reference2 = tags;
                        this.metricValueClosure = reference = metricValueClosure;
                    }

                    public Object doCall(LoadingCache<String, AmazonReservationReport> reservationReportCache) {
                        CallSite[] callSiteArray = _registerMetric_closure1.$getCallSiteArray();
                        public final class _closure3
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference tags;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;

                            public _closure3(Object _outerInstance, Object _thisObject, Reference tags) {
                                Reference reference;
                                CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                                super(_outerInstance, _thisObject);
                                this.tags = reference = tags;
                            }

                            public Object doCall(Object it) {
                                CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                                if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty(it), (Object)callSiteArray[1].callGetProperty(this.tags.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].callGetProperty(it), (Object)callSiteArray[3].callGetProperty(this.tags.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].callGetProperty(callSiteArray[5].callGetProperty(it)), (Object)callSiteArray[6].callGetProperty(this.tags.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[7].call(it), (Object)callSiteArray[8].callGetProperty(this.tags.get()));
                                }
                                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[9].callGetProperty(it), (Object)callSiteArray[10].callGetProperty(this.tags.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[11].callGetProperty(it), (Object)callSiteArray[12].callGetProperty(this.tags.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[13].callGetProperty(callSiteArray[14].callGetProperty(it)), (Object)callSiteArray[15].callGetProperty(this.tags.get())) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[16].call(it), (Object)callSiteArray[17].callGetProperty(this.tags.get()));
                            }

                            @Generated
                            public Map getTags() {
                                CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                                return (Map)ScriptBytecodeAdapter.castToType((Object)this.tags.get(), Map.class);
                            }

                            @Generated
                            public Object doCall() {
                                CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure3.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                stringArray[0] = "availabilityZone";
                                stringArray[1] = "availabilityZone";
                                stringArray[2] = "instanceType";
                                stringArray[3] = "instanceType";
                                stringArray[4] = "name";
                                stringArray[5] = "os";
                                stringArray[6] = "os";
                                stringArray[7] = "region";
                                stringArray[8] = "region";
                                stringArray[9] = "availabilityZone";
                                stringArray[10] = "availabilityZone";
                                stringArray[11] = "instanceType";
                                stringArray[12] = "instanceType";
                                stringArray[13] = "name";
                                stringArray[14] = "os";
                                stringArray[15] = "os";
                                stringArray[16] = "region";
                                stringArray[17] = "region";
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[18];
                                _closure3.$createCallSiteArray_1(stringArray);
                                return new CallSiteArray(_closure3.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _closure3.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }
                        }
                        Object overallReservationDetail = callSiteArray[0].call(callSiteArray[1].callGetProperty(callSiteArray[2].call(reservationReportCache, (Object)"v3")), (Object)new _closure3((Object)this, this.getThisObject(), this.tags));
                        return callSiteArray[3].call(this.metricValueClosure.get(), overallReservationDetail);
                    }

                    @Generated
                    public Object call(LoadingCache<String, AmazonReservationReport> reservationReportCache) {
                        CallSite[] callSiteArray = _registerMetric_closure1.$getCallSiteArray();
                        return callSiteArray[4].callCurrent((GroovyObject)this, reservationReportCache);
                    }

                    @Generated
                    public Map getTags() {
                        CallSite[] callSiteArray = _registerMetric_closure1.$getCallSiteArray();
                        return (Map)ScriptBytecodeAdapter.castToType((Object)this.tags.get(), Map.class);
                    }

                    @Generated
                    public Closure getMetricValueClosure() {
                        CallSite[] callSiteArray = _registerMetric_closure1.$getCallSiteArray();
                        return (Closure)ScriptBytecodeAdapter.castToType((Object)this.metricValueClosure.get(), Closure.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _registerMetric_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "find";
                        stringArray[1] = "reservations";
                        stringArray[2] = "get";
                        stringArray[3] = "call";
                        stringArray[4] = "doCall";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _registerMetric_closure1.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_registerMetric_closure1.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _registerMetric_closure1.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[16].call((Object)this.registry, id, this.reservationReportCache, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((ToDoubleFunction)ScriptBytecodeAdapter.asType((Object)((Object)new _registerMetric_closure1(this, this, tags2, metricValueClosure2)), ToDoubleFunction.class)), ToDoubleFunction.class));
            }
        }

        public void registerMetrics(AmazonReservationReport reservationReport) {
            CallSite[] callSiteArray = MetricsSupport.$getCallSiteArray();
            public final class _registerMetrics_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _registerMetrics_closure2(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _registerMetrics_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(AmazonReservationReport.OverallReservationDetail overallReservationDetail) {
                    CallSite[] callSiteArray = _registerMetrics_closure2.$getCallSiteArray();
                    Object object = callSiteArray[0].callGroovyObjectGetProperty((Object)overallReservationDetail);
                    Reference baseTags = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"availabilityZone", DefaultTypeTransformation.booleanUnbox((Object)object) ? object : "n/a", "instanceType", callSiteArray[1].callGroovyObjectGetProperty((Object)overallReservationDetail), "os", callSiteArray[2].callGetProperty(callSiteArray[3].callGroovyObjectGetProperty((Object)overallReservationDetail)), "region", callSiteArray[4].call((Object)overallReservationDetail)}));
                    public final class _closure4
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure4(Object _outerInstance, Object _thisObject) {
                            CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(AmazonReservationReport.OverallReservationDetail o) {
                            CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                            Object object = callSiteArray[0].callSafe((Object)o);
                            return (Double)ScriptBytecodeAdapter.asType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0)), Double.class);
                        }

                        @Generated
                        public Object call(AmazonReservationReport.OverallReservationDetail o) {
                            CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                            return callSiteArray[1].callCurrent((GroovyObject)this, (Object)o);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure4.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "totalSurplus";
                            stringArray[1] = "doCall";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[2];
                            _closure4.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure4.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure4.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    callSiteArray[5].callCurrent((GroovyObject)this, (Object)"reservedInstances.surplusOverall", baseTags.get(), (Object)new _closure4((Object)this, this.getThisObject()));
                    public final class _closure5
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference baseTags;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure5(Object _outerInstance, Object _thisObject, Reference baseTags) {
                            Reference reference;
                            CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.baseTags = reference = baseTags;
                        }

                        public Object doCall(String accountName, AmazonReservationReport.AccountReservationDetail reservationDetail) {
                            Reference accountName2 = new Reference((Object)accountName);
                            CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                            public final class _closure6
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference accountName;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;
                                private static /* synthetic */ SoftReference $callSiteArray;

                                public _closure6(Object _outerInstance, Object _thisObject, Reference accountName) {
                                    Reference reference;
                                    CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                                    super(_outerInstance, _thisObject);
                                    this.accountName = reference = accountName;
                                }

                                public Object doCall(AmazonReservationReport.OverallReservationDetail o) {
                                    CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                                    Object object = callSiteArray[0].callSafe(callSiteArray[1].callSafe(callSiteArray[2].callGroovyObjectGetPropertySafe((Object)o), this.accountName.get()));
                                    return (Double)ScriptBytecodeAdapter.asType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0)), Double.class);
                                }

                                @Generated
                                public Object call(AmazonReservationReport.OverallReservationDetail o) {
                                    CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                                    return callSiteArray[3].callCurrent((GroovyObject)this, (Object)o);
                                }

                                @Generated
                                public String getAccountName() {
                                    CallSite[] callSiteArray = _closure6.$getCallSiteArray();
                                    return ShortTypeHandling.castToString((Object)this.accountName.get());
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure6.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                    stringArray[0] = "surplusVpc";
                                    stringArray[1] = "get";
                                    stringArray[2] = "accounts";
                                    stringArray[3] = "doCall";
                                }

                                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                    String[] stringArray = new String[4];
                                    _closure6.$createCallSiteArray_1(stringArray);
                                    return new CallSiteArray(_closure6.class, stringArray);
                                }

                                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                    CallSiteArray callSiteArray;
                                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                        callSiteArray = _closure6.$createCallSiteArray();
                                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                    }
                                    return callSiteArray.array;
                                }
                            }
                            callSiteArray[0].callCurrent((GroovyObject)this, (Object)"reservedInstances.surplusByAccountVpc", callSiteArray[1].call(this.baseTags.get(), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"account", (String)accountName2.get()})), (Object)new _closure6((Object)this, this.getThisObject(), accountName2));
                            public final class _closure7
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference accountName;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;
                                private static /* synthetic */ SoftReference $callSiteArray;

                                public _closure7(Object _outerInstance, Object _thisObject, Reference accountName) {
                                    Reference reference;
                                    CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                                    super(_outerInstance, _thisObject);
                                    this.accountName = reference = accountName;
                                }

                                public Object doCall(AmazonReservationReport.OverallReservationDetail o) {
                                    CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                                    Object object = callSiteArray[0].callSafe(callSiteArray[1].callSafe(callSiteArray[2].callGroovyObjectGetPropertySafe((Object)o), this.accountName.get()));
                                    return (Double)ScriptBytecodeAdapter.asType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0)), Double.class);
                                }

                                @Generated
                                public Object call(AmazonReservationReport.OverallReservationDetail o) {
                                    CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                                    return callSiteArray[3].callCurrent((GroovyObject)this, (Object)o);
                                }

                                @Generated
                                public String getAccountName() {
                                    CallSite[] callSiteArray = _closure7.$getCallSiteArray();
                                    return ShortTypeHandling.castToString((Object)this.accountName.get());
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure7.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                                    stringArray[0] = "surplus";
                                    stringArray[1] = "get";
                                    stringArray[2] = "accounts";
                                    stringArray[3] = "doCall";
                                }

                                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                    String[] stringArray = new String[4];
                                    _closure7.$createCallSiteArray_1(stringArray);
                                    return new CallSiteArray(_closure7.class, stringArray);
                                }

                                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                    CallSiteArray callSiteArray;
                                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                        callSiteArray = _closure7.$createCallSiteArray();
                                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                    }
                                    return callSiteArray.array;
                                }
                            }
                            return callSiteArray[2].callCurrent((GroovyObject)this, (Object)"reservedInstances.surplusByAccountClassic", callSiteArray[3].call(this.baseTags.get(), (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"account", (String)accountName2.get()})), (Object)new _closure7((Object)this, this.getThisObject(), accountName2));
                        }

                        @Generated
                        public Object call(String accountName, AmazonReservationReport.AccountReservationDetail reservationDetail) {
                            Reference accountName2 = new Reference((Object)accountName);
                            CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                            return callSiteArray[4].callCurrent((GroovyObject)this, (Object)((String)accountName2.get()), (Object)reservationDetail);
                        }

                        @Generated
                        public Object getBaseTags() {
                            CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                            return this.baseTags.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure5.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "registerMetric";
                            stringArray[1] = "plus";
                            stringArray[2] = "registerMetric";
                            stringArray[3] = "plus";
                            stringArray[4] = "doCall";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[5];
                            _closure5.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure5.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure5.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    return callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)overallReservationDetail), (Object)new _closure5((Object)this, this.getThisObject(), baseTags));
                }

                @Generated
                public Object call(AmazonReservationReport.OverallReservationDetail overallReservationDetail) {
                    CallSite[] callSiteArray = _registerMetrics_closure2.$getCallSiteArray();
                    return callSiteArray[8].callCurrent((GroovyObject)this, (Object)overallReservationDetail);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _registerMetrics_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "availabilityZone";
                    stringArray[1] = "instanceType";
                    stringArray[2] = "name";
                    stringArray[3] = "os";
                    stringArray[4] = "region";
                    stringArray[5] = "registerMetric";
                    stringArray[6] = "each";
                    stringArray[7] = "accounts";
                    stringArray[8] = "doCall";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[9];
                    _registerMetrics_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_registerMetrics_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _registerMetrics_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[17].call(callSiteArray[18].callGroovyObjectGetProperty((Object)reservationReport), (Object)new _registerMetrics_closure2(this, this));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != MetricsSupport.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
            CallSite[] callSiteArray = MetricsSupport.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(MetricsSupport.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[19].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodOnCurrentN(MetricsSupport.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[20].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[21].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodOnCurrentN(MetricsSupport.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(MetricsSupport.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$1(String name, Object value) {
            CallSite[] callSiteArray = MetricsSupport.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, MetricsSupport.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object this$dist$get$1(String name) {
            CallSite[] callSiteArray = MetricsSupport.$getCallSiteArray();
            return ScriptBytecodeAdapter.getGroovyObjectProperty(MetricsSupport.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = MetricsSupport.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(MetricsSupport.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[22].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(MetricsSupport.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[23].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[24].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(MetricsSupport.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(MetricsSupport.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            CallSite[] callSiteArray = MetricsSupport.$getCallSiteArray();
            if (!(args instanceof Object[])) {
                return ScriptBytecodeAdapter.invokeMethodN(MetricsSupport.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            }
            if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[25].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(MetricsSupport.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[26].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                }
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[27].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                return ScriptBytecodeAdapter.invokeMethodN(MetricsSupport.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
            }
            return ScriptBytecodeAdapter.invokeMethodN(MetricsSupport.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = MetricsSupport.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            CallSite[] callSiteArray = MetricsSupport.$getCallSiteArray();
            Object object = value;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = MetricsSupport.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(MetricsSupport.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            CallSite[] callSiteArray = MetricsSupport.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(MetricsSupport.class, ReservationReportCachingAgent.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
            stringArray[0] = "build";
            stringArray[1] = "expireAfterWrite";
            stringArray[2] = "maximumSize";
            stringArray[3] = "weakKeys";
            stringArray[4] = "concurrencyLevel";
            stringArray[5] = "newBuilder";
            stringArray[6] = "SECONDS";
            stringArray[7] = "<$constructor$>";
            stringArray[8] = "withTags";
            stringArray[9] = "createId";
            stringArray[10] = "putIfAbsent";
            stringArray[11] = "plus";
            stringArray[12] = "plus";
            stringArray[13] = "join";
            stringArray[14] = "sort";
            stringArray[15] = "values";
            stringArray[16] = "gauge";
            stringArray[17] = "each";
            stringArray[18] = "reservations";
            stringArray[19] = "length";
            stringArray[20] = "getAt";
            stringArray[21] = "length";
            stringArray[22] = "length";
            stringArray[23] = "getAt";
            stringArray[24] = "length";
            stringArray[25] = "length";
            stringArray[26] = "getAt";
            stringArray[27] = "length";
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[28];
            MetricsSupport.$createCallSiteArray_1(stringArray);
            return new CallSiteArray(MetricsSupport.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = MetricsSupport.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        public class 1
        extends CacheLoader<String, AmazonReservationReport>
        implements GroovyObject {
            final /* synthetic */ MetricsSupport this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;

            /* synthetic */ 1(MetricsSupport p0) {
                MetaClass metaClass;
                MetricsSupport metricsSupport;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0 = metricsSupport = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public AmazonReservationReport load(String key) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return (AmazonReservationReport)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Map)ScriptBytecodeAdapter.asType((Object)callSiteArray[2].call(callSiteArray[3].callGetProperty(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this)), callSiteArray[7].callGetProperty(callSiteArray[8].callGetProperty(Namespace.class)), (Object)key)), (Object)"report"), Map.class)), Map.class), AmazonReservationReport.class), AmazonReservationReport.class);
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                if (!(args instanceof Object[])) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, MetricsSupport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                }
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[9].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                        return ScriptBytecodeAdapter.invokeMethodN(1.class, MetricsSupport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{callSiteArray[10].call((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (Object)0)});
                    }
                } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[11].callGetProperty((Object)((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class))), (Object)1)) {
                    return ScriptBytecodeAdapter.invokeMethodN(1.class, MetricsSupport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)args, Object[].class)), (int)0)});
                }
                return ScriptBytecodeAdapter.invokeMethodN(1.class, MetricsSupport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0.this$dist$set$1(name, value);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, MetricsSupport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, MetricsSupport.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            @Transient
            public MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "convertValue";
                stringArray[1] = "objectMapper";
                stringArray[2] = "getAt";
                stringArray[3] = "attributes";
                stringArray[4] = "get";
                stringArray[5] = "call";
                stringArray[6] = "cache";
                stringArray[7] = "ns";
                stringArray[8] = "RESERVATION_REPORTS";
                stringArray[9] = "length";
                stringArray[10] = "getAt";
                stringArray[11] = "length";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[12];
                1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure1(Object _outerInstance, Object _thisObject) {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            return callSiteArray[0].callCurrent((GroovyObject)this);
        }

        @Generated
        public Object doCall() {
            CallSite[] callSiteArray = _closure1.$getCallSiteArray();
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[1];
            stringArray[0] = "getCacheView";
            return new CallSiteArray(_closure1.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure1.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

