/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.agent;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.amazonaws.services.cloudwatch.model.StateValue;
import com.amazonaws.services.gamelift.model.DescribeScalingPoliciesRequest;
import com.netflix.spinnaker.cats.agent.RunnableAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsCleanupProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupAlarmsAgent
implements RunnableAgent,
CustomScheduledAgent,
GroovyObject {
    public static final long POLL_INTERVAL_MILLIS;
    public static final long DEFAULT_TIMEOUT_MILLIS;
    public static final Pattern ALARM_NAME_PATTERN;
    private final AmazonClientProvider amazonClientProvider;
    private final CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;
    private final long pollIntervalMillis;
    private final long timeoutMillis;
    private final int daysToLeave;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public CleanupAlarmsAgent(AmazonClientProvider amazonClientProvider, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository, int daysToLeave) {
        this(amazonClientProvider, credentialsRepository, DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("getProperty", "POLL_INTERVAL_MILLIS", 0, CleanupAlarmsAgent.class)), DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("getProperty", "DEFAULT_TIMEOUT_MILLIS", 0, CleanupAlarmsAgent.class)), daysToLeave);
    }

    public CleanupAlarmsAgent(AmazonClientProvider amazonClientProvider, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository, long pollIntervalMillis, long timeoutMills, int daysToLeave) {
        int n;
        AmazonClientProvider amazonClientProvider2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.amazonClientProvider = amazonClientProvider2 = amazonClientProvider;
        CredentialsRepository<NetflixAmazonCredentials> credentialsRepository2 = credentialsRepository;
        this.credentialsRepository = credentialsRepository2;
        long l = pollIntervalMillis;
        this.pollIntervalMillis = l;
        long l2 = timeoutMills;
        this.timeoutMillis = l2;
        this.daysToLeave = n = daysToLeave;
    }

    public String getAgentType() {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "simpleName", 0, CleanupAlarmsAgent.class)}, new String[]{"", ""}));
    }

    public String getProviderName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "PROVIDER_NAME", 0, AwsCleanupProvider.class));
    }

    public void run() {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _run_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(NetflixAmazonCredentials credentials) {
                Reference credentials2 = new Reference((Object)credentials);
                public final class _closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference credentials;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure2(Object _outerInstance, Object _thisObject, Reference credentials) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.credentials = reference = credentials;
                    }

                    public Object doCall(AmazonCredentials.AWSRegion region) {
                        Reference region2 = new Reference((Object)region);
                        IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), "Looking for alarms to delete");
                        Reference cloudWatch = new Reference((Object)IndyInterface.bootstrap("invoke", "getCloudWatch", 0, IndyInterface.bootstrap("getProperty", "amazonClientProvider", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.credentials.get()), IndyInterface.bootstrap("getProperty", "name", 0, (AmazonCredentials.AWSRegion)region2.get())));
                        Reference attachedAlarms = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAttachedAlarms", 2, this, IndyInterface.bootstrap("invoke", "getAutoScaling", 0, IndyInterface.bootstrap("getProperty", "amazonClientProvider", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.credentials.get()), IndyInterface.bootstrap("getProperty", "name", 0, (AmazonCredentials.AWSRegion)region2.get())))));
                        CallSite describeAlarmsRequest = IndyInterface.bootstrap("invoke", "withStateValue", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeAlarmsRequest.class), IndyInterface.bootstrap("getProperty", "INSUFFICIENT_DATA", 0, StateValue.class));
                        while (true) {
                            CallSite result = IndyInterface.bootstrap("invoke", "describeAlarms", 0, cloudWatch.get(), describeAlarmsRequest);
                            public final class _closure3
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference attachedAlarms;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure3(Object _outerInstance, Object _thisObject, Reference attachedAlarms) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    this.attachedAlarms = reference = attachedAlarms;
                                }

                                public Object doCall(Object it) {
                                    return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "before", 0, IndyInterface.bootstrap("getProperty", "stateUpdatedTimestamp", 0, it), IndyInterface.bootstrap("invoke", "toDate", 0, IndyInterface.bootstrap("invoke", "minusDays", 0, IndyInterface.bootstrap("invoke", "now", 0, DateTime.class), IndyInterface.bootstrap("getProperty", "daysToLeave", 12, this))))) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("cast", "()", 0, this.attachedAlarms.get()), IndyInterface.bootstrap("getProperty", "alarmName", 0, it))) == false && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "matches", 0, IndyInterface.bootstrap("invoke", "matcher", 0, IndyInterface.bootstrap("getProperty", "ALARM_NAME_PATTERN", 12, this), IndyInterface.bootstrap("getProperty", "alarmName", 0, it))));
                                }

                                @Generated
                                public Set getAttachedAlarms() {
                                    return IndyInterface.bootstrap("cast", "()", 0, this.attachedAlarms.get());
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure3.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            CallSite alarmsToDelete = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("getProperty", "metricAlarms", 0, result), new _closure3((Object)this, this.getThisObject(), attachedAlarms)));
                            if (IndyInterface.bootstrap("cast", "()", 0, alarmsToDelete) != false) {
                                public final class _closure4
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference credentials;
                                    private /* synthetic */ Reference region;
                                    private /* synthetic */ Reference cloudWatch;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure4(Object _outerInstance, Object _thisObject, Reference credentials, Reference region, Reference cloudWatch) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        Reference reference2;
                                        Reference reference3;
                                        this.credentials = reference3 = credentials;
                                        this.region = reference2 = region;
                                        this.cloudWatch = reference = cloudWatch;
                                    }

                                    public Object doCall(Object it) {
                                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, it), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.region.get()))}, new String[]{"Deleting ", " alarms in ", "/", " "}), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("getProperty", "alarmName", 0, it), ", ")}, new String[]{"(alarms: ", ")"}))) : null;
                                        IndyInterface.bootstrap("invoke", "deleteAlarms", 0, this.cloudWatch.get(), IndyInterface.bootstrap("invoke", "withAlarmNames", 0, IndyInterface.bootstrap("init", "<init>", 0, DeleteAlarmsRequest.class), IndyInterface.bootstrap("getProperty", "alarmName", 0, it)));
                                        return IndyInterface.bootstrap("invoke", "sleep", 0, Thread.class, 500);
                                    }

                                    @Generated
                                    public NetflixAmazonCredentials getCredentials() {
                                        return IndyInterface.bootstrap("cast", "()", 0, this.credentials.get());
                                    }

                                    @Generated
                                    public AmazonCredentials.AWSRegion getRegion() {
                                        return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
                                    }

                                    @Generated
                                    public Object getCloudWatch() {
                                        return this.cloudWatch.get();
                                    }

                                    @Generated
                                    public Object doCall() {
                                        return this.doCall(null);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure4.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                        return MethodHandles.lookup();
                                    }
                                }
                                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "collate", 0, alarmsToDelete, 20), new _closure4((Object)this, this.getThisObject(), this.credentials, region2, cloudWatch));
                            }
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "nextToken", 0, result)) == false) break;
                            IndyInterface.bootstrap("invoke", "withNextToken", 0, describeAlarmsRequest, IndyInterface.bootstrap("getProperty", "nextToken", 0, result));
                        }
                        return null;
                    }

                    @Generated
                    public Object call(AmazonCredentials.AWSRegion region) {
                        Reference region2 = new Reference((Object)region);
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, (AmazonCredentials.AWSRegion)region2.get());
                    }

                    @Generated
                    public NetflixAmazonCredentials getCredentials() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.credentials.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "regions", 0, (NetflixAmazonCredentials)((Object)credentials2.get())), new _closure2((Object)this, this.getThisObject(), credentials2));
            }

            @Generated
            public Object call(NetflixAmazonCredentials credentials) {
                Reference credentials2 = new Reference((Object)credentials);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, (NetflixAmazonCredentials)((Object)credentials2.get()));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "getAccounts", 2, this), new _run_closure1(this, this));
    }

    private Set<NetflixAmazonCredentials> getAccounts() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.credentialsRepository));
    }

    private static Set<String> getAttachedAlarms(AmazonAutoScaling autoScaling) {
        CallSite alarms = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        CallSite request = IndyInterface.bootstrap("init", "<init>", 0, DescribeScalingPoliciesRequest.class);
        while (true) {
            CallSite result = IndyInterface.bootstrap("invoke", "describePolicies", 0, autoScaling);
            IndyInterface.bootstrap("invoke", "addAll", 0, alarms, IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("getProperty", "alarmName", 0, IndyInterface.bootstrap("getProperty", "alarms", 0, IndyInterface.bootstrap("getProperty", "scalingPolicies", 0, result)))));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "nextToken", 0, result)) == false) break;
            IndyInterface.bootstrap("invoke", "withNextToken", 0, request, IndyInterface.bootstrap("getProperty", "nextToken", 0, result));
        }
        return alarms;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CleanupAlarmsAgent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "toMillis", 0, IndyInterface.bootstrap("getProperty", "HOURS", 0, TimeUnit.class), 24);
        POLL_INTERVAL_MILLIS = DefaultTypeTransformation.longUnbox((Object)callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "toMillis", 0, IndyInterface.bootstrap("getProperty", "MINUTES", 0, TimeUnit.class), 20);
        DEFAULT_TIMEOUT_MILLIS = DefaultTypeTransformation.longUnbox((Object)callSite2);
        CallSite callSite3 = IndyInterface.bootstrap("invoke", "compile", 0, Pattern.class, ".+-v[0-9]{3}-alarm-.+");
        ALARM_NAME_PATTERN = IndyInterface.bootstrap("cast", "()", 0, callSite3);
        CallSite callSite4 = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.agent.CleanupAlarmsAgent");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite4);
    }

    @Generated
    public final AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public final CredentialsRepository<NetflixAmazonCredentials> getCredentialsRepository() {
        return this.credentialsRepository;
    }

    @Generated
    public final long getPollIntervalMillis() {
        return this.pollIntervalMillis;
    }

    @Generated
    public final long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @Generated
    public final int getDaysToLeave() {
        return this.daysToLeave;
    }
}

