/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.controllers;

import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/applications/{application}/clusters/{account}/{clusterName}/aws/serverGroups/{serverGroupName}"})
public class AmazonClusterController
implements GroovyObject {
    @Autowired
    private CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;
    @Autowired
    private AmazonClientProvider amazonClientProvider;
    private static final int MAX_SCALING_ACTIVITIES = 500;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public AmazonClusterController() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/scalingActivities"})
    public ResponseEntity getScalingActivities(@PathVariable String account, @PathVariable String serverGroupName, @RequestParam(value="region", required=true) String region) {
        CallSite credentials = IndyInterface.bootstrap("invoke", "getOne", 0, this.credentialsRepository, account);
        if (ScriptBytecodeAdapter.compareEqual((Object)credentials, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"message", "bad credentials"}), IndyInterface.bootstrap("getProperty", "BAD_REQUEST", 0, HttpStatus.class)));
        }
        CallSite autoScaling = IndyInterface.bootstrap("invoke", "getAutoScaling", 0, this.amazonClientProvider, credentials, region);
        CallSite request = IndyInterface.bootstrap("init", "<init>", 0, DescribeScalingActivitiesRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"autoScalingGroupName", serverGroupName}));
        CallSite response = IndyInterface.bootstrap("invoke", "describeScalingActivities", 0, autoScaling, request);
        List scalingActivities = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        while (ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("invoke", "size", 0, scalingActivities), (Object)MAX_SCALING_ACTIVITIES)) {
            IndyInterface.bootstrap("invoke", "addAll", 0, scalingActivities, IndyInterface.bootstrap("getProperty", "activities", 0, response));
            if (!(DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "nextToken", 0, response)) && ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("invoke", "size", 0, scalingActivities), (Object)MAX_SCALING_ACTIVITIES))) break;
            IndyInterface.bootstrap("invoke", "describeScalingActivities", 0, autoScaling, IndyInterface.bootstrap("invoke", "withNextToken", 0, request, IndyInterface.bootstrap("getProperty", "nextToken", 0, response)));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ResponseEntity.class, scalingActivities, IndyInterface.bootstrap("getProperty", "OK", 0, HttpStatus.class)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AmazonClusterController.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public CredentialsRepository<NetflixAmazonCredentials> getCredentialsRepository() {
        return this.credentialsRepository;
    }

    @Generated
    public void setCredentialsRepository(CredentialsRepository<NetflixAmazonCredentials> credentialsRepository) {
        this.credentialsRepository = credentialsRepository;
    }

    @Generated
    public AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public void setAmazonClientProvider(AmazonClientProvider amazonClientProvider) {
        this.amazonClientProvider = amazonClientProvider;
    }

    @Generated
    public static int getMAX_SCALING_ACTIVITIES() {
        return MAX_SCALING_ACTIVITIES;
    }
}

