/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.asg;

import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.AlreadyExistsException;
import com.amazonaws.services.autoscaling.model.BlockDeviceMapping;
import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.Ebs;
import com.amazonaws.services.autoscaling.model.InstanceMonitoring;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.LaunchConfigurationBuilder;
import com.netflix.spinnaker.clouddriver.aws.deploy.userdata.LocalFileUserDataProperties;
import com.netflix.spinnaker.clouddriver.aws.deploy.userdata.UserDataProviderAggregator;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonBlockDevice;
import com.netflix.spinnaker.clouddriver.aws.services.AsgService;
import com.netflix.spinnaker.clouddriver.aws.services.SecurityGroupService;
import com.netflix.spinnaker.clouddriver.aws.userdata.UserDataInput;
import com.netflix.spinnaker.clouddriver.aws.userdata.UserDataOverride;
import com.netflix.spinnaker.clouddriver.helpers.OperationPoller;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.config.AwsConfiguration;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLaunchConfigurationBuilder
implements LaunchConfigurationBuilder,
GroovyObject {
    private final AmazonAutoScaling autoScaling;
    private final AsgService asgService;
    private final SecurityGroupService securityGroupService;
    private final UserDataProviderAggregator userDataProviderAggregator;
    private final LocalFileUserDataProperties localFileUserDataProperties;
    private final AwsConfiguration.DeployDefaults deployDefaults;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DefaultLaunchConfigurationBuilder(AmazonAutoScaling autoScaling, AsgService asgService, SecurityGroupService securityGroupService, UserDataProviderAggregator userDataProviderAggregator, LocalFileUserDataProperties localFileUserDataProperties, AwsConfiguration.DeployDefaults deployDefaults) {
        AwsConfiguration.DeployDefaults deployDefaults2;
        LocalFileUserDataProperties localFileUserDataProperties2;
        UserDataProviderAggregator userDataProviderAggregator2;
        SecurityGroupService securityGroupService2;
        AsgService asgService2;
        AmazonAutoScaling amazonAutoScaling;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.autoScaling = amazonAutoScaling = autoScaling;
        this.asgService = asgService2 = asgService;
        this.securityGroupService = securityGroupService2 = securityGroupService;
        this.userDataProviderAggregator = userDataProviderAggregator2 = userDataProviderAggregator;
        this.localFileUserDataProperties = localFileUserDataProperties2 = localFileUserDataProperties;
        this.deployDefaults = deployDefaults2 = deployDefaults;
    }

    @Override
    public LaunchConfigurationBuilder.LaunchConfigurationSettings buildSettingsFromLaunchConfiguration(AccountCredentials<?> account, String region, String launchConfigurationName) {
        CallSite lc = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getLaunchConfiguration", 0, this.asgService, launchConfigurationName));
        CallSite baseName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "launchConfigurationName", 0, lc));
        CallSite suffix = null;
        int suffixLoc = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "lastIndexOf", 0, IndyInterface.bootstrap("getProperty", "launchConfigurationName", 0, lc), "-"));
        if (suffixLoc != -1) {
            baseName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, IndyInterface.bootstrap("getProperty", "launchConfigurationName", 0, lc), false, suffixLoc));
            suffix = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, IndyInterface.bootstrap("getProperty", "launchConfigurationName", 0, lc), IndyInterface.bootstrap("invoke", "plus", 0, suffixLoc, true)));
        }
        public final class _buildSettingsFromLaunchConfiguration_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildSettingsFromLaunchConfiguration_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(BlockDeviceMapping mapping) {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ebs", 0, mapping)) != false) {
                    return IndyInterface.bootstrap("init", "<init>", 0, AmazonBlockDevice.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"deviceName", IndyInterface.bootstrap("getProperty", "deviceName", 0, mapping), "size", IndyInterface.bootstrap("getProperty", "volumeSize", 0, IndyInterface.bootstrap("getProperty", "ebs", 0, mapping)), "volumeType", IndyInterface.bootstrap("getProperty", "volumeType", 0, IndyInterface.bootstrap("getProperty", "ebs", 0, mapping)), "deleteOnTermination", IndyInterface.bootstrap("getProperty", "deleteOnTermination", 0, IndyInterface.bootstrap("getProperty", "ebs", 0, mapping)), "iops", IndyInterface.bootstrap("getProperty", "iops", 0, IndyInterface.bootstrap("getProperty", "ebs", 0, mapping)), "throughput", IndyInterface.bootstrap("getProperty", "throughput", 0, IndyInterface.bootstrap("getProperty", "ebs", 0, mapping)), "snapshotId", IndyInterface.bootstrap("getProperty", "snapshotId", 0, IndyInterface.bootstrap("getProperty", "ebs", 0, mapping)), "encrypted", IndyInterface.bootstrap("getProperty", "encrypted", 0, IndyInterface.bootstrap("getProperty", "ebs", 0, mapping))}));
                }
                return IndyInterface.bootstrap("init", "<init>", 0, AmazonBlockDevice.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"deviceName", IndyInterface.bootstrap("getProperty", "deviceName", 0, mapping), "virtualName", IndyInterface.bootstrap("getProperty", "virtualName", 0, mapping)}));
            }

            @Generated
            public Object call(BlockDeviceMapping mapping) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, mapping);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildSettingsFromLaunchConfiguration_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite blockDevices = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "blockDeviceMappings", 0, lc), new _buildSettingsFromLaunchConfiguration_closure1(this, this)));
        CallSite base64UserData = IndyInterface.bootstrap("cast", "()", 0, DefaultTypeTransformation.booleanUnbox((Object)this.localFileUserDataProperties) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "enabled", 4, this.localFileUserDataProperties)) == false ? IndyInterface.bootstrap("getProperty", "userData", 0, lc) : null);
        CallSite callSite = IndyInterface.bootstrap("getProperty", "kernelId", 0, lc);
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "ramdiskId", 0, lc);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "base64UserData", 0, IndyInterface.bootstrap("invoke", "securityGroups", 0, IndyInterface.bootstrap("invoke", "blockDevices", 0, IndyInterface.bootstrap("invoke", "instanceMonitoring", 0, IndyInterface.bootstrap("invoke", "spotMaxPrice", 0, IndyInterface.bootstrap("invoke", "ebsOptimized", 0, IndyInterface.bootstrap("invoke", "ramdiskId", 0, IndyInterface.bootstrap("invoke", "kernelId", 0, IndyInterface.bootstrap("invoke", "associatePublicIpAddress", 0, IndyInterface.bootstrap("invoke", "keyPair", 0, IndyInterface.bootstrap("invoke", "instanceType", 0, IndyInterface.bootstrap("invoke", "classicLinkVpcSecurityGroups", 0, IndyInterface.bootstrap("invoke", "classicLinkVpcId", 0, IndyInterface.bootstrap("invoke", "iamRole", 0, IndyInterface.bootstrap("invoke", "ami", 0, IndyInterface.bootstrap("invoke", "suffix", 0, IndyInterface.bootstrap("invoke", "baseName", 0, IndyInterface.bootstrap("invoke", "region", 0, IndyInterface.bootstrap("invoke", "accountType", 0, IndyInterface.bootstrap("invoke", "environment", 0, IndyInterface.bootstrap("invoke", "account", 0, IndyInterface.bootstrap("invoke", "builder", 0, LaunchConfigurationBuilder.LaunchConfigurationSettings.class), IndyInterface.bootstrap("getProperty", "name", 0, account)), IndyInterface.bootstrap("getProperty", "environment", 0, account)), IndyInterface.bootstrap("getProperty", "accountType", 0, account)), region), baseName), suffix), IndyInterface.bootstrap("getProperty", "imageId", 0, lc)), IndyInterface.bootstrap("getProperty", "iamInstanceProfile", 0, lc)), IndyInterface.bootstrap("getProperty", "classicLinkVPCId", 0, lc)), IndyInterface.bootstrap("getProperty", "classicLinkVPCSecurityGroups", 0, lc)), IndyInterface.bootstrap("getProperty", "instanceType", 0, lc)), IndyInterface.bootstrap("getProperty", "keyName", 0, lc)), IndyInterface.bootstrap("getProperty", "associatePublicIpAddress", 0, lc)), IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : null), IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : null), IndyInterface.bootstrap("getProperty", "ebsOptimized", 0, lc)), IndyInterface.bootstrap("getProperty", "spotPrice", 0, lc)), ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "instanceMonitoring", 0, lc), null) ? Boolean.valueOf(false) : IndyInterface.bootstrap("getProperty", "enabled", 0, IndyInterface.bootstrap("getProperty", "instanceMonitoring", 0, lc))), blockDevices), IndyInterface.bootstrap("getProperty", "securityGroups", 0, lc)), base64UserData)));
    }

    @Override
    public String buildLaunchConfiguration(String application, String subnetType, LaunchConfigurationBuilder.LaunchConfigurationSettings settings, Boolean legacyUdf, UserDataOverride userDataOverride) {
        settings = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "setAppSecurityGroup", 0, DefaultLaunchConfigurationBuilder.class, application, subnetType, this.deployDefaults, this.securityGroupService, settings));
        CallSite name = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createName", 0, DefaultLaunchConfigurationBuilder.class, settings));
        CallSite userData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getUserData", 2, this, name, settings, legacyUdf, userDataOverride));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createLaunchConfiguration", 2, this, name, userData, settings));
    }

    private static String createDefaultSuffix() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("init", "<init>", 0, LocalDateTime.class), "MMddYYYYHHmmss"));
    }

    public static String createName(LaunchConfigurationBuilder.LaunchConfigurationSettings settings) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createName0", 0, DefaultLaunchConfigurationBuilder.class, IndyInterface.bootstrap("getProperty", "baseName", 0, settings), IndyInterface.bootstrap("getProperty", "suffix", 0, settings)));
    }

    private static String createName0(String baseName, String suffix) {
        CallSite name = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class, baseName));
        if (IndyInterface.bootstrap("cast", "()", 0, suffix) != false) {
            IndyInterface.bootstrap("invoke", "append", 0, IndyInterface.bootstrap("invoke", "append", 0, name, "-"), suffix);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, name));
    }

    private String getUserData(String launchConfigName, LaunchConfigurationBuilder.LaunchConfigurationSettings settings, Boolean legacyUdf, UserDataOverride userDataOverride) {
        CallSite userDataRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "base64UserData", 0, IndyInterface.bootstrap("invoke", "userDataOverride", 0, IndyInterface.bootstrap("invoke", "legacyUdf", 0, IndyInterface.bootstrap("invoke", "imageId", 0, IndyInterface.bootstrap("invoke", "iamRole", 0, IndyInterface.bootstrap("invoke", "environment", 0, IndyInterface.bootstrap("invoke", "accountType", 0, IndyInterface.bootstrap("invoke", "account", 0, IndyInterface.bootstrap("invoke", "region", 0, IndyInterface.bootstrap("invoke", "launchSettingName", 0, IndyInterface.bootstrap("invoke", "asgName", 0, IndyInterface.bootstrap("invoke", "launchTemplate", 0, IndyInterface.bootstrap("invoke", "builder", 0, UserDataInput.class), false), IndyInterface.bootstrap("getProperty", "baseName", 0, settings)), launchConfigName), IndyInterface.bootstrap("getProperty", "region", 0, settings)), IndyInterface.bootstrap("getProperty", "account", 0, settings)), IndyInterface.bootstrap("getProperty", "accountType", 0, settings)), IndyInterface.bootstrap("getProperty", "environment", 0, settings)), IndyInterface.bootstrap("getProperty", "iamRole", 0, settings)), IndyInterface.bootstrap("getProperty", "ami", 0, settings)), legacyUdf), userDataOverride), IndyInterface.bootstrap("getProperty", "base64UserData", 0, settings))));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "aggregate", 0, this.userDataProviderAggregator, userDataRequest));
    }

    /*
     * WARNING - void declaration
     */
    public static LaunchConfigurationBuilder.LaunchConfigurationSettings setAppSecurityGroup(String application, String subnetType, AwsConfiguration.DeployDefaults deployDefaults, SecurityGroupService securityGroupService, LaunchConfigurationBuilder.LaunchConfigurationSettings settings) {
        void var3_3;
        void var1_1;
        Reference application2 = new Reference((Object)application);
        Reference subnetType2 = new Reference((Object)var1_1);
        Reference securityGroupService2 = new Reference((Object)var3_3);
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "suffix", 0, settings), null)) {
            settings = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "suffix", 0, IndyInterface.bootstrap("invoke", "toBuilder", 0, settings), IndyInterface.bootstrap("invoke", "createDefaultSuffix", 0, DefaultLaunchConfigurationBuilder.class))));
        }
        Reference securityGroupIds = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toSet", 0, IndyInterface.bootstrap("invoke", "resolveSecurityGroupIdsWithSubnetType", 0, (SecurityGroupService)securityGroupService2.get(), IndyInterface.bootstrap("getProperty", "securityGroups", 0, settings), (String)subnetType2.get()))));
        if (IndyInterface.bootstrap("cast", "()", 0, (Set)securityGroupIds.get()) == false || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "addAppGroupToServerGroup", 4, deployDefaults)) && ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("invoke", "size", 0, (Set)securityGroupIds.get()), (Object)IndyInterface.bootstrap("getProperty", "maxSecurityGroups", 4, deployDefaults))) {
            CallSite names = IndyInterface.bootstrap("invoke", "getSecurityGroupNamesFromIds", 0, (SecurityGroupService)securityGroupService2.get(), (Set)securityGroupIds.get());
            public final class _setAppSecurityGroup_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference application;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _setAppSecurityGroup_closure2(Object _outerInstance, Object _thisObject, Reference application) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.application = reference = application;
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("invoke", "contains", 0, it, IndyInterface.bootstrap("cast", "()", 0, this.application.get()));
                }

                @Generated
                public String getApplication() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.application.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _setAppSecurityGroup_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite existingAppGroup = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("invoke", "keySet", 0, names), new _setAppSecurityGroup_closure2(DefaultLaunchConfigurationBuilder.class, DefaultLaunchConfigurationBuilder.class, application2)));
            if (IndyInterface.bootstrap("cast", "()", 0, existingAppGroup) == false) {
                public final class _setAppSecurityGroup_closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference securityGroupService;
                    private /* synthetic */ Reference application;
                    private /* synthetic */ Reference subnetType;
                    private /* synthetic */ Reference securityGroupIds;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _setAppSecurityGroup_closure3(Object _outerInstance, Object _thisObject, Reference securityGroupService, Reference application, Reference subnetType, Reference securityGroupIds) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        this.securityGroupService = reference4 = securityGroupService;
                        this.application = reference3 = application;
                        this.subnetType = reference2 = subnetType;
                        this.securityGroupIds = reference = securityGroupIds;
                    }

                    public Object doCall(Object o) {
                        CallSite applicationSecurityGroup = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSecurityGroupForApplication", 0, IndyInterface.bootstrap("cast", "()", 0, this.securityGroupService.get()), IndyInterface.bootstrap("cast", "()", 0, this.application.get()), IndyInterface.bootstrap("cast", "()", 0, this.subnetType.get())));
                        if (IndyInterface.bootstrap("cast", "()", 0, applicationSecurityGroup) == false) {
                            applicationSecurityGroup = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createSecurityGroup", 0, IndyInterface.bootstrap("cast", "()", 0, this.securityGroupService.get()), IndyInterface.bootstrap("cast", "()", 0, this.application.get()), IndyInterface.bootstrap("cast", "()", 0, this.subnetType.get())));
                        }
                        return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.securityGroupIds.get()), applicationSecurityGroup);
                    }

                    @Generated
                    public SecurityGroupService getSecurityGroupService() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.securityGroupService.get());
                    }

                    @Generated
                    public String getApplication() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.application.get());
                    }

                    @Generated
                    public String getSubnetType() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.subnetType.get());
                    }

                    @Generated
                    public Set getSecurityGroupIds() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.securityGroupIds.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _setAppSecurityGroup_closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "retryWithBackoff", 0, OperationPoller.class, new _setAppSecurityGroup_closure3(DefaultLaunchConfigurationBuilder.class, DefaultLaunchConfigurationBuilder.class, securityGroupService2, application2, subnetType2, securityGroupIds), 500, 3);
            }
        }
        settings = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "securityGroups", 0, IndyInterface.bootstrap("invoke", "toBuilder", 0, settings), IndyInterface.bootstrap("invoke", "toList", 0, (Set)securityGroupIds.get()))));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "classicLinkVpcSecurityGroups", 0, settings)) != false) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "classicLinkVpcId", 0, settings)) == false) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "Can't provide classic link security groups without classiclink vpc Id"));
            }
            CallSite classicLinkIds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveSecurityGroupIdsInVpc", 0, (SecurityGroupService)securityGroupService2.get(), IndyInterface.bootstrap("getProperty", "classicLinkVpcSecurityGroups", 0, settings), IndyInterface.bootstrap("getProperty", "classicLinkVpcId", 0, settings)));
            settings = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "classicLinkVpcSecurityGroups", 0, IndyInterface.bootstrap("invoke", "toBuilder", 0, settings), classicLinkIds)));
        }
        IndyInterface.bootstrap("invoke", "info", 0, log, "Configured resolved security groups {} for application {}.", (Set)securityGroupIds.get(), (String)application2.get());
        return settings;
    }

    private String createLaunchConfiguration(String name, String userData, LaunchConfigurationBuilder.LaunchConfigurationSettings settings) {
        CallSite callSite;
        Reference name2 = new Reference((Object)name);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "withKernelId", 0, IndyInterface.bootstrap("invoke", "withAssociatePublicIpAddress", 0, IndyInterface.bootstrap("invoke", "withKeyName", 0, IndyInterface.bootstrap("invoke", "withSecurityGroups", 0, IndyInterface.bootstrap("invoke", "withInstanceType", 0, IndyInterface.bootstrap("invoke", "withUserData", 0, IndyInterface.bootstrap("invoke", "withLaunchConfigurationName", 0, IndyInterface.bootstrap("invoke", "withIamInstanceProfile", 0, IndyInterface.bootstrap("invoke", "withImageId", 0, IndyInterface.bootstrap("init", "<init>", 0, CreateLaunchConfigurationRequest.class), IndyInterface.bootstrap("getProperty", "ami", 0, settings)), IndyInterface.bootstrap("getProperty", "iamRole", 0, settings)), (String)name2.get()), userData), IndyInterface.bootstrap("getProperty", "instanceType", 0, settings)), IndyInterface.bootstrap("getProperty", "securityGroups", 0, settings)), IndyInterface.bootstrap("getProperty", "keyPair", 0, settings)), IndyInterface.bootstrap("getProperty", "associatePublicIpAddress", 0, settings)), IndyInterface.bootstrap("cast", "()", 0, callSite = IndyInterface.bootstrap("getProperty", "kernelId", 0, settings)) != false ? callSite : null);
        CallSite callSite3 = IndyInterface.bootstrap("getProperty", "ramdiskId", 0, settings);
        Reference request = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withInstanceMonitoring", 0, IndyInterface.bootstrap("invoke", "withClassicLinkVPCSecurityGroups", 0, IndyInterface.bootstrap("invoke", "withClassicLinkVPCId", 0, IndyInterface.bootstrap("invoke", "withSpotPrice", 0, IndyInterface.bootstrap("invoke", "withEbsOptimized", 0, IndyInterface.bootstrap("invoke", "withRamdiskId", 0, callSite2, IndyInterface.bootstrap("cast", "()", 0, callSite3) != false ? callSite3 : null), IndyInterface.bootstrap("getProperty", "ebsOptimized", 0, settings)), IndyInterface.bootstrap("getProperty", "spotMaxPrice", 0, settings)), IndyInterface.bootstrap("getProperty", "classicLinkVpcId", 0, settings)), IndyInterface.bootstrap("getProperty", "classicLinkVpcSecurityGroups", 0, settings)), IndyInterface.bootstrap("init", "<init>", 0, InstanceMonitoring.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"enabled", IndyInterface.bootstrap("getProperty", "instanceMonitoring", 0, settings)})))));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "blockDevices", 0, settings)) != false) {
            List mappings = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            Object blockDevice = null;
            CallSite callSite4 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("getProperty", "blockDevices", 0, settings)));
            if (callSite4 != null) {
                while (callSite4.hasNext()) {
                    blockDevice = callSite4.next();
                    CallSite mapping = IndyInterface.bootstrap("init", "<init>", 0, BlockDeviceMapping.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"deviceName", IndyInterface.bootstrap("getProperty", "deviceName", 0, blockDevice)}));
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "virtualName", 0, blockDevice)) != false) {
                        IndyInterface.bootstrap("invoke", "withVirtualName", 0, mapping, IndyInterface.bootstrap("getProperty", "virtualName", 0, blockDevice));
                    } else {
                        Reference ebs = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, Ebs.class));
                        public final class _createLaunchConfiguration_closure4
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference ebs;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _createLaunchConfiguration_closure4(Object _outerInstance, Object _thisObject, Reference ebs) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.ebs = reference = ebs;
                            }

                            public Object doCall(Object it) {
                                IndyInterface.bootstrap("invoke", "withVolumeSize", 0, this.ebs.get(), IndyInterface.bootstrap("getProperty", "size", 12, this));
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "deleteOnTermination", 12, this), null)) {
                                    IndyInterface.bootstrap("invoke", "withDeleteOnTermination", 0, this.ebs.get(), IndyInterface.bootstrap("getProperty", "deleteOnTermination", 12, this));
                                }
                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "volumeType", 12, this)) != false) {
                                    IndyInterface.bootstrap("invoke", "withVolumeType", 0, this.ebs.get(), IndyInterface.bootstrap("getProperty", "volumeType", 12, this));
                                }
                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "iops", 12, this)) != false) {
                                    IndyInterface.bootstrap("invoke", "withIops", 0, this.ebs.get(), IndyInterface.bootstrap("getProperty", "iops", 12, this));
                                }
                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "throughput", 12, this)) != false) {
                                    IndyInterface.bootstrap("invoke", "withThroughput", 0, this.ebs.get(), IndyInterface.bootstrap("getProperty", "throughput", 12, this));
                                }
                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "snapshotId", 12, this)) != false) {
                                    IndyInterface.bootstrap("invoke", "withSnapshotId", 0, this.ebs.get(), IndyInterface.bootstrap("getProperty", "snapshotId", 12, this));
                                }
                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "encrypted", 12, this)) != false) {
                                    return IndyInterface.bootstrap("invoke", "withEncrypted", 0, this.ebs.get(), IndyInterface.bootstrap("getProperty", "encrypted", 12, this));
                                }
                                return null;
                            }

                            @Generated
                            public Object getEbs() {
                                return this.ebs.get();
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _createLaunchConfiguration_closure4.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        IndyInterface.bootstrap("invoke", "with", 0, blockDevice, new _createLaunchConfiguration_closure4(this, this, ebs));
                        IndyInterface.bootstrap("invoke", "withEbs", 0, mapping, ebs.get());
                    }
                    IndyInterface.bootstrap("invoke", "leftShift", 0, mappings, mapping);
                }
            }
            IndyInterface.bootstrap("invoke", "withBlockDeviceMappings", 0, (CreateLaunchConfigurationRequest)request.get(), mappings);
        }
        try {
            public final class _createLaunchConfiguration_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference request;
                private /* synthetic */ Reference name;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _createLaunchConfiguration_closure5(Object _outerInstance, Object _thisObject, Reference request, Reference name) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.request = reference2 = request;
                    this.name = reference = name;
                }

                public Object doCall(Object o) {
                    CallSite debugRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "clone", 0, IndyInterface.bootstrap("cast", "()", 0, this.request.get())));
                    IndyInterface.bootstrap("invoke", "setUserData", 0, debugRequest, null);
                    CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "debug", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.name.get()), debugRequest}, new String[]{"Creating launch configuration (", "): ", ""})) : null;
                    return IndyInterface.bootstrap("invoke", "createLaunchConfiguration", 0, IndyInterface.bootstrap("getProperty", "autoScaling", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.request.get()));
                }

                @Generated
                public CreateLaunchConfigurationRequest getRequest() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.request.get());
                }

                @Generated
                public String getName() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.name.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _createLaunchConfiguration_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "retryWithBackoff", 0, OperationPoller.class, new _createLaunchConfiguration_closure5(this, this, request, name2), 1500, 3);
        }
        catch (AlreadyExistsException e) {
            CallSite callSite5 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "debug", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"Launch configuration already exists, continuing... (", ")"})) : null;
        }
        return (String)name2.get();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DefaultLaunchConfigurationBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.deploy.asg.DefaultLaunchConfigurationBuilder");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public final AmazonAutoScaling getAutoScaling() {
        return this.autoScaling;
    }

    @Generated
    public final AsgService getAsgService() {
        return this.asgService;
    }

    @Generated
    public final SecurityGroupService getSecurityGroupService() {
        return this.securityGroupService;
    }

    @Generated
    public final UserDataProviderAggregator getUserDataProviderAggregator() {
        return this.userDataProviderAggregator;
    }

    @Generated
    public final LocalFileUserDataProperties getLocalFileUserDataProperties() {
        return this.localFileUserDataProperties;
    }

    @Generated
    public final AwsConfiguration.DeployDefaults getDeployDefaults() {
        return this.deployDefaults;
    }
}

