/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.handlers;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.aws.AmazonCloudProvider;
import com.netflix.spinnaker.clouddriver.aws.deploy.AmiIdResolver;
import com.netflix.spinnaker.clouddriver.aws.deploy.InstanceTypeUtils;
import com.netflix.spinnaker.clouddriver.aws.deploy.ResolvedAmiResult;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AsgConfigHelper;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AutoScalingWorker;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.LaunchTemplateRollOutConfig;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.BasicAmazonDeployDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.LoadBalancerLookupHelper;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.TargetGroupLookupHelper;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.UpsertAmazonLoadBalancerResult;
import com.netflix.spinnaker.clouddriver.aws.deploy.scalingpolicy.ScalingPolicyCopier;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonAsgLifecycleHook;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonBlockDevice;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.services.RegionScopedProviderFactory;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.deploy.DeployDescription;
import com.netflix.spinnaker.clouddriver.deploy.DeployHandler;
import com.netflix.spinnaker.clouddriver.deploy.DeploymentResult;
import com.netflix.spinnaker.clouddriver.orchestration.events.CreateServerGroupEvent;
import com.netflix.spinnaker.config.AwsConfiguration;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAmazonDeployHandler
implements DeployHandler<BasicAmazonDeployDescription>,
GroovyObject {
    private static final String BASE_PHASE = "DEPLOY";
    private static final String SUBNET_ID_OVERRIDE_TAG = "SPINNAKER_SUBNET_ID_OVERRIDE";
    private final RegionScopedProviderFactory regionScopedProviderFactory;
    private final CredentialsRepository<NetflixAmazonCredentials> accountCredentialsRepository;
    private final AwsConfiguration.AmazonServerGroupProvider amazonServerGroupProvider;
    private final AwsConfiguration.DeployDefaults deployDefaults;
    private final ScalingPolicyCopier scalingPolicyCopier;
    private final InstanceTypeUtils.BlockDeviceConfig blockDeviceConfig;
    private final LaunchTemplateRollOutConfig launchTemplateRollOutConfig;
    private List<CreateServerGroupEvent> deployEvents;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public BasicAmazonDeployHandler(RegionScopedProviderFactory regionScopedProviderFactory, CredentialsRepository<NetflixAmazonCredentials> accountCredentialsRepository, AwsConfiguration.AmazonServerGroupProvider amazonServerGroupProvider, AwsConfiguration.DeployDefaults deployDefaults, ScalingPolicyCopier scalingPolicyCopier, InstanceTypeUtils.BlockDeviceConfig blockDeviceConfig, LaunchTemplateRollOutConfig launchTemplateRollOutConfig) {
        LaunchTemplateRollOutConfig launchTemplateRollOutConfig2;
        InstanceTypeUtils.BlockDeviceConfig blockDeviceConfig2;
        ScalingPolicyCopier scalingPolicyCopier2;
        AwsConfiguration.DeployDefaults deployDefaults2;
        AwsConfiguration.AmazonServerGroupProvider amazonServerGroupProvider2;
        RegionScopedProviderFactory regionScopedProviderFactory2;
        MetaClass metaClass;
        List list;
        this.deployEvents = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.regionScopedProviderFactory = regionScopedProviderFactory2 = regionScopedProviderFactory;
        CredentialsRepository<NetflixAmazonCredentials> credentialsRepository = accountCredentialsRepository;
        this.accountCredentialsRepository = credentialsRepository;
        this.amazonServerGroupProvider = amazonServerGroupProvider2 = amazonServerGroupProvider;
        this.deployDefaults = deployDefaults2 = deployDefaults;
        this.scalingPolicyCopier = scalingPolicyCopier2 = scalingPolicyCopier;
        this.blockDeviceConfig = blockDeviceConfig2 = blockDeviceConfig;
        this.launchTemplateRollOutConfig = launchTemplateRollOutConfig2 = launchTemplateRollOutConfig;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public boolean handles(DeployDescription description) {
        return description instanceof BasicAmazonDeployDescription;
    }

    public DeploymentResult handle(BasicAmazonDeployDescription description, List priorOutputs) {
        Reference description2 = new Reference((Object)description);
        CallSite deploymentResult = IndyInterface.bootstrap("init", "<init>", 0, DeploymentResult.class);
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "availabilityZones", 4, (BasicAmazonDeployDescription)description2.get())}, new String[]{"Preparing deployment to ", "..."}));
        CallSite entry = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("getProperty", "availabilityZones", 4, (BasicAmazonDeployDescription)description2.get())));
        if (callSite != null) {
            while (callSite.hasNext()) {
                CallSite callSite2;
                CallSite callSite3;
                entry = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                Reference region = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "key", 0, entry)));
                CallSite sourceRegionScopedProvider = IndyInterface.bootstrap("invoke", "buildSourceRegionScopedProvider", 2, this, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "source", 4, (BasicAmazonDeployDescription)description2.get()));
                description2.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "copySourceAttributes", 2, this, sourceRegionScopedProvider, IndyInterface.bootstrap("getProperty", "asgName", 0, IndyInterface.bootstrap("getProperty", "source", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "useSourceCapacity", 0, IndyInterface.bootstrap("getProperty", "source", 4, (BasicAmazonDeployDescription)description2.get())), (BasicAmazonDeployDescription)description2.get())));
                CallSite availabilityZones = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "value", 0, entry));
                CallSite subnetType = IndyInterface.bootstrap("getProperty", "subnetType", 4, (BasicAmazonDeployDescription)description2.get());
                public final class _handle_closure1
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handle_closure1(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return it instanceof UpsertAmazonLoadBalancerResult;
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _handle_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite suppliedLoadBalancers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 1, IndyInterface.bootstrap("getProperty", "loadBalancers", 1, IndyInterface.bootstrap("invoke", "findAll", 0, priorOutputs, new _handle_closure1(this, this))), (String)region.get()));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "loadBalancers", 4, (BasicAmazonDeployDescription)description2.get())) == false) {
                    List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)list, BasicAmazonDeployHandler.class, (GroovyObject)((BasicAmazonDeployDescription)description2.get()), (String)"loadBalancers");
                }
                IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("getProperty", "loadBalancers", 4, (BasicAmazonDeployDescription)description2.get()), IndyInterface.bootstrap("cast", "()", 0, callSite3 = IndyInterface.bootstrap("getProperty", "name", 1, suppliedLoadBalancers)) != false ? callSite3 : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                CallSite regionScopedProvider = IndyInterface.bootstrap("invoke", "forRegion", 0, this.regionScopedProviderFactory, IndyInterface.bootstrap("getProperty", "credentials", 4, (BasicAmazonDeployDescription)description2.get()), (String)region.get());
                CallSite loadBalancers = IndyInterface.bootstrap("invoke", "getLoadBalancersByName", 0, IndyInterface.bootstrap("invoke", "loadBalancerLookupHelper", 2, this), regionScopedProvider, IndyInterface.bootstrap("getProperty", "loadBalancers", 4, (BasicAmazonDeployDescription)description2.get()));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "unknownLoadBalancers", 0, loadBalancers)) != false) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "unknownLoadBalancers", 0, loadBalancers)}, new String[]{"Unable to find classic load balancers named ", ""})));
                }
                CallSite targetGroups = IndyInterface.bootstrap("invoke", "getTargetGroupsByName", 0, IndyInterface.bootstrap("invoke", "targetGroupLookupHelper", 2, this), regionScopedProvider, IndyInterface.bootstrap("getProperty", "targetGroups", 4, (BasicAmazonDeployDescription)description2.get()));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "unknownTargetGroups", 0, targetGroups)) != false) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "unknownTargetGroups", 0, targetGroups)}, new String[]{"Unable to find target groups named ", ""})));
                }
                CallSite amazonEC2 = IndyInterface.bootstrap("getProperty", "amazonEC2", 0, regionScopedProvider);
                CallSite classicLinkVpcId = null;
                CallSite classicLinkVpcSecurityGroups = null;
                if (IndyInterface.bootstrap("cast", "()", 0, subnetType) == false) {
                    CallSite result = IndyInterface.bootstrap("invoke", "describeVpcClassicLink", 0, amazonEC2);
                    public final class _handle_closure2
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _handle_closure2(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("getProperty", "classicLinkEnabled", 0, it);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _handle_closure2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    classicLinkVpcId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "vpcId", 1, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("getProperty", "vpcs", 0, result), new _handle_closure2(this, this))));
                    if (IndyInterface.bootstrap("cast", "()", 0, classicLinkVpcId) != false) {
                        CallSite classicLinkGroupNames = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                        CallSite callSite4 = IndyInterface.bootstrap("getProperty", "classicLinkVpcSecurityGroups", 4, (BasicAmazonDeployDescription)description2.get());
                        IndyInterface.bootstrap("invoke", "addAll", 0, classicLinkGroupNames, IndyInterface.bootstrap("cast", "()", 0, callSite4) != false ? callSite4 : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "classicLinkSecurityGroupName", 4, this.deployDefaults)) != false) {
                            IndyInterface.bootstrap("invoke", "addAll", 0, classicLinkGroupNames, IndyInterface.bootstrap("getProperty", "classicLinkSecurityGroupName", 4, this.deployDefaults));
                        }
                        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "classicLinkVpcId", 4, (BasicAmazonDeployDescription)description2.get())) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "classicLinkVpcSecurityGroups", 4, (BasicAmazonDeployDescription)description2.get()))) {
                            public final class _handle_closure3
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _handle_closure3(Object _outerInstance, Object _thisObject) {
                                    super(_outerInstance, _thisObject);
                                }

                                public Object doCall(Object it) {
                                    return IndyInterface.bootstrap("invoke", "matches", 0, it, ScriptBytecodeAdapter.bitwiseNegate((Object)"sg-[0-9a-f]+"));
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _handle_closure3.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            CallSite callSite5 = IndyInterface.bootstrap("invoke", "findAll", 0, classicLinkGroupNames, new _handle_closure3(this, this));
                            Reference groupIds = new Reference(IndyInterface.bootstrap("cast", "()", 0, callSite5) != false ? callSite5 : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                            IndyInterface.bootstrap("invoke", "removeAll", 0, classicLinkGroupNames, groupIds.get());
                            if (IndyInterface.bootstrap("cast", "()", 0, groupIds.get()) != false) {
                                CallSite describeSG = IndyInterface.bootstrap("invoke", "withGroupIds", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeSecurityGroupsRequest.class), groupIds.get());
                                CallSite callSite6 = sourceRegionScopedProvider;
                                CallSite provider = IndyInterface.bootstrap("cast", "()", 0, callSite6) != false ? callSite6 : regionScopedProvider;
                                public final class _handle_closure4
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference description;
                                    private /* synthetic */ Reference groupIds;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _handle_closure4(Object _outerInstance, Object _thisObject, Reference description, Reference groupIds) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        Reference reference2;
                                        this.description = reference2 = description;
                                        this.groupIds = reference = groupIds;
                                    }

                                    public Object doCall(Object it) {
                                        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "vpcId", 0, it), (Object)IndyInterface.bootstrap("getProperty", "classicLinkVpcId", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get()))) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, this.groupIds.get(), IndyInterface.bootstrap("getProperty", "groupId", 0, it)))) {
                                            return IndyInterface.bootstrap("getProperty", "groupName", 0, it);
                                        }
                                        return null;
                                    }

                                    @Generated
                                    public BasicAmazonDeployDescription getDescription() {
                                        return IndyInterface.bootstrap("cast", "()", 0, this.description.get());
                                    }

                                    @Generated
                                    public Object getGroupIds() {
                                        return this.groupIds.get();
                                    }

                                    @Generated
                                    public Object doCall() {
                                        return this.doCall(null);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _handle_closure4.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                        return MethodHandles.lookup();
                                    }
                                }
                                CallSite callSite7 = IndyInterface.bootstrap("invoke", "findResults", 0, IndyInterface.bootstrap("getProperty", "securityGroups", 0, IndyInterface.bootstrap("invoke", "describeSecurityGroups", 0, IndyInterface.bootstrap("getProperty", "amazonEC2", 0, provider), describeSG)), new _handle_closure4(this, this, description2, groupIds));
                                CallSite resolvedNames = IndyInterface.bootstrap("cast", "()", 0, callSite7) != false ? callSite7 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, resolvedNames), (Object)IndyInterface.bootstrap("invoke", "size", 0, groupIds.get()))) {
                                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{groupIds.get(), resolvedNames}, new String[]{"failed to look up classic link security groups, had ", " found ", ""})));
                                }
                                IndyInterface.bootstrap("invoke", "addAll", 0, classicLinkGroupNames, resolvedNames);
                            }
                        }
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "addAppGroupsToClassicLink", 4, this.deployDefaults)) != false) {
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "source", 4, (BasicAmazonDeployDescription)description2.get())) != false) {
                                CallSite srcName = IndyInterface.bootstrap("invoke", "parseName", 0, Names.class, IndyInterface.bootstrap("getProperty", "asgName", 0, IndyInterface.bootstrap("getProperty", "source", 4, (BasicAmazonDeployDescription)description2.get())));
                                boolean mismatch = false;
                                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "app", 0, srcName), (Object)IndyInterface.bootstrap("getProperty", "application", 4, (BasicAmazonDeployDescription)description2.get()))) {
                                    IndyInterface.bootstrap("invoke", "remove", 0, classicLinkGroupNames, IndyInterface.bootstrap("getProperty", "app", 0, srcName));
                                    mismatch = true;
                                }
                                if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "stack", 0, srcName)) && (mismatch || ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "stack", 0, srcName), (Object)IndyInterface.bootstrap("getProperty", "stack", 4, (BasicAmazonDeployDescription)description2.get())))) {
                                    IndyInterface.bootstrap("invoke", "remove", 0, classicLinkGroupNames, IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "app", 0, srcName), IndyInterface.bootstrap("getProperty", "stack", 0, srcName)}, new String[]{"", "-", ""})));
                                    mismatch = true;
                                }
                                if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "detail", 0, srcName)) && (mismatch || ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "detail", 0, srcName), (Object)IndyInterface.bootstrap("getProperty", "freeFormDetails", 4, (BasicAmazonDeployDescription)description2.get())))) {
                                    CallSite callSite8;
                                    IndyInterface.bootstrap("invoke", "remove", 0, classicLinkGroupNames, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "app", 0, srcName), IndyInterface.bootstrap("cast", "()", 0, callSite8 = IndyInterface.bootstrap("getProperty", "stack", 0, srcName)) != false ? callSite8 : "", IndyInterface.bootstrap("getProperty", "detail", 0, srcName)}, new String[]{"", "-", "-", ""}));
                                }
                            }
                            List groupNamesToLookUp = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, classicLinkGroupNames, IndyInterface.bootstrap("getProperty", "application", 4, (BasicAmazonDeployDescription)description2.get()))) == false) {
                                IndyInterface.bootstrap("invoke", "add", 0, groupNamesToLookUp, IndyInterface.bootstrap("getProperty", "application", 4, (BasicAmazonDeployDescription)description2.get()));
                            }
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "stack", 4, (BasicAmazonDeployDescription)description2.get())) != false) {
                                CallSite stackGroup = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "application", 4, (BasicAmazonDeployDescription)description2.get()), IndyInterface.bootstrap("getProperty", "stack", 4, (BasicAmazonDeployDescription)description2.get())}, new String[]{"", "-", ""}));
                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, classicLinkGroupNames, stackGroup)) == false) {
                                    IndyInterface.bootstrap("invoke", "add", 0, groupNamesToLookUp, stackGroup);
                                }
                            }
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "freeFormDetails", 4, (BasicAmazonDeployDescription)description2.get())) != false) {
                                CallSite callSite9;
                                CallSite clusterGroup = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "application", 4, (BasicAmazonDeployDescription)description2.get()), IndyInterface.bootstrap("cast", "()", 0, callSite9 = IndyInterface.bootstrap("getProperty", "stack", 4, (BasicAmazonDeployDescription)description2.get())) != false ? callSite9 : "", IndyInterface.bootstrap("getProperty", "freeFormDetails", 4, (BasicAmazonDeployDescription)description2.get())}, new String[]{"", "-", "-", ""}));
                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, classicLinkGroupNames, clusterGroup)) == false) {
                                    IndyInterface.bootstrap("invoke", "add", 0, groupNamesToLookUp, clusterGroup);
                                }
                            }
                            if (DefaultTypeTransformation.booleanUnbox((Object)groupNamesToLookUp) && ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("invoke", "size", 0, classicLinkGroupNames), (Object)IndyInterface.bootstrap("getProperty", "maxClassicLinkSecurityGroups", 4, this.deployDefaults))) {
                                CallSite appGroups = IndyInterface.bootstrap("invoke", "getSecurityGroupIds", 0, IndyInterface.bootstrap("getProperty", "securityGroupService", 0, regionScopedProvider), groupNamesToLookUp, classicLinkVpcId, false);
                                CallSite name = null;
                                CallSite callSite10 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, groupNamesToLookUp));
                                if (callSite10 != null) {
                                    while (callSite10.hasNext()) {
                                        name = IndyInterface.bootstrap("cast", "()", 0, callSite10.next());
                                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, appGroups, name)) == false) continue;
                                        if (ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("invoke", "size", 0, classicLinkGroupNames), (Object)IndyInterface.bootstrap("getProperty", "maxClassicLinkSecurityGroups", 4, this.deployDefaults))) {
                                            IndyInterface.bootstrap("invoke", "add", 0, classicLinkGroupNames, name);
                                            continue;
                                        }
                                        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{name, IndyInterface.bootstrap("getProperty", "maxClassicLinkSecurityGroups", 4, this.deployDefaults)}, new String[]{"Not adding ", " to classicLinkVpcSecurityGroups, already have ", " groups"}));
                                    }
                                }
                            }
                        }
                        classicLinkVpcSecurityGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toList", 0, classicLinkGroupNames));
                        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{classicLinkGroupNames}, new String[]{"Attaching ", " as classicLinkVpcSecurityGroups"}));
                    }
                }
                public final class _handle_closure5
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference region;
                    private /* synthetic */ Reference description;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handle_closure5(Object _outerInstance, Object _thisObject, Reference region, Reference description) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.region = reference2 = region;
                        this.description = reference = description;
                    }

                    public Object doCall(Object it) {
                        return it instanceof ResolvedAmiResult && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "region", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.region.get())) && (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "amiName", 0, it), (Object)IndyInterface.bootstrap("getProperty", "amiName", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get()))) || ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "amiId", 0, it), (Object)IndyInterface.bootstrap("getProperty", "amiName", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get()))));
                    }

                    @Generated
                    public String getRegion() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
                    }

                    @Generated
                    public BasicAmazonDeployDescription getDescription() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.description.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _handle_closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite ami = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite2 = IndyInterface.bootstrap("invoke", "find", 0, priorOutputs, new _handle_closure5(this, this, region, description2))) != false ? callSite2 : IndyInterface.bootstrap("invoke", "resolveAmiIdFromAllSources", 0, AmiIdResolver.class, amazonEC2, (String)region.get(), IndyInterface.bootstrap("getProperty", "amiName", 4, (BasicAmazonDeployDescription)description2.get()), IndyInterface.bootstrap("getProperty", "accountId", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, (BasicAmazonDeployDescription)description2.get()))));
                if (IndyInterface.bootstrap("cast", "()", 0, ami) == false) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "amiName", 4, (BasicAmazonDeployDescription)description2.get()), (String)region.get()}, new String[]{"unable to resolve AMI imageId from ", " in ", ""})));
                }
                IndyInterface.bootstrap("invoke", "validateCompatibilityWithAmi", 0, InstanceTypeUtils.class, amazonEC2, ami, IndyInterface.bootstrap("invoke", "getAllInstanceTypes", 0, (BasicAmazonDeployDescription)description2.get()));
                CallSite account = IndyInterface.bootstrap("invoke", "getOne", 0, this.accountCredentialsRepository, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, (BasicAmazonDeployDescription)description2.get())));
                if (ScriptBytecodeAdapter.compareEqual((Object)account, null)) {
                    throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, (BasicAmazonDeployDescription)description2.get()))}, new String[]{"Account with name ", " could not be found."})));
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "useAmiBlockDeviceMappings", 4, (BasicAmazonDeployDescription)description2.get())) != false) {
                    CallSite callSite11 = IndyInterface.bootstrap("invoke", "convertBlockDevices", 0, AsgConfigHelper.class, IndyInterface.bootstrap("getProperty", "blockDeviceMappings", 4, ami));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite11, BasicAmazonDeployHandler.class, (GroovyObject)((BasicAmazonDeployDescription)description2.get()), (String)"blockDevices");
                } else if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "blockDevices", 4, (BasicAmazonDeployDescription)description2.get()), null)) {
                    CallSite callSite12 = IndyInterface.bootstrap("invoke", "getBlockDevicesForInstanceType", 0, this.blockDeviceConfig, IndyInterface.bootstrap("getProperty", "instanceType", 4, (BasicAmazonDeployDescription)description2.get()));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite12, BasicAmazonDeployHandler.class, (GroovyObject)((BasicAmazonDeployDescription)description2.get()), (String)"blockDevices");
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "spotPrice", 4, (BasicAmazonDeployDescription)description2.get()), (Object)"")) {
                    Object var45_45 = null;
                    ScriptBytecodeAdapter.setGroovyObjectProperty(var45_45, BasicAmazonDeployHandler.class, (GroovyObject)((BasicAmazonDeployDescription)description2.get()), (String)"spotPrice");
                }
                Object[] objectArray = new Object[6];
                objectArray[0] = "min";
                CallSite callSite13 = IndyInterface.bootstrap("getProperty", "min", 0, IndyInterface.bootstrap("getProperty", "capacity", 4, (BasicAmazonDeployDescription)description2.get()));
                objectArray[1] = IndyInterface.bootstrap("cast", "()", 0, callSite13) != false ? callSite13 : Integer.valueOf(0);
                objectArray[2] = "max";
                CallSite callSite14 = IndyInterface.bootstrap("getProperty", "max", 0, IndyInterface.bootstrap("getProperty", "capacity", 4, (BasicAmazonDeployDescription)description2.get()));
                objectArray[3] = IndyInterface.bootstrap("cast", "()", 0, callSite14) != false ? callSite14 : Integer.valueOf(0);
                objectArray[4] = "desired";
                CallSite callSite15 = IndyInterface.bootstrap("getProperty", "desired", 0, IndyInterface.bootstrap("getProperty", "capacity", 4, (BasicAmazonDeployDescription)description2.get()));
                objectArray[5] = IndyInterface.bootstrap("cast", "()", 0, callSite15) != false ? callSite15 : Integer.valueOf(0);
                CallSite capacity = IndyInterface.bootstrap("init", "<init>", 0, DeploymentResult.Deployment.Capacity.class, ScriptBytecodeAdapter.createMap((Object[])objectArray));
                CallSite autoScalingWorker = IndyInterface.bootstrap("init", "<init>", 0, AutoScalingWorker.class, regionScopedProvider, this.launchTemplateRollOutConfig);
                CallSite callSite16 = IndyInterface.bootstrap("getProperty", "keyPair", 4, (BasicAmazonDeployDescription)description2.get());
                CallSite asgConfig = IndyInterface.bootstrap("invoke", "build", 0, IndyInterface.bootstrap("invoke", "capacityRebalance", 0, IndyInterface.bootstrap("invoke", "launchTemplateOverridesForInstanceType", 0, IndyInterface.bootstrap("invoke", "spotInstancePools", 0, IndyInterface.bootstrap("invoke", "spotAllocationStrategy", 0, IndyInterface.bootstrap("invoke", "onDemandPercentageAboveBaseCapacity", 0, IndyInterface.bootstrap("invoke", "onDemandBaseCapacity", 0, IndyInterface.bootstrap("invoke", "onDemandAllocationStrategy", 0, IndyInterface.bootstrap("invoke", "licenseSpecifications", 0, IndyInterface.bootstrap("invoke", "placement", 0, IndyInterface.bootstrap("invoke", "unlimitedCpuCredits", 0, IndyInterface.bootstrap("invoke", "associateIPv6Address", 0, IndyInterface.bootstrap("invoke", "enableEnclave", 0, IndyInterface.bootstrap("invoke", "requireIMDSv2", 0, IndyInterface.bootstrap("invoke", "setLaunchTemplate", 0, IndyInterface.bootstrap("invoke", "lifecycleHooks", 0, IndyInterface.bootstrap("invoke", "blockDeviceTags", 0, IndyInterface.bootstrap("invoke", "tags", 0, IndyInterface.bootstrap("invoke", "userDataOverride", 0, IndyInterface.bootstrap("invoke", "legacyUdf", 0, IndyInterface.bootstrap("invoke", "base64UserData", 0, IndyInterface.bootstrap("invoke", "ebsOptimized", 0, IndyInterface.bootstrap("invoke", "instanceMonitoring", 0, IndyInterface.bootstrap("invoke", "ramdiskId", 0, IndyInterface.bootstrap("invoke", "kernelId", 0, IndyInterface.bootstrap("invoke", "suspendedProcesses", 0, IndyInterface.bootstrap("invoke", "spotMaxPrice", 0, IndyInterface.bootstrap("invoke", "terminationPolicies", 0, IndyInterface.bootstrap("invoke", "healthCheckType", 0, IndyInterface.bootstrap("invoke", "healthCheckGracePeriod", 0, IndyInterface.bootstrap("invoke", "enabledMetrics", 0, IndyInterface.bootstrap("invoke", "cooldown", 0, IndyInterface.bootstrap("invoke", "targetGroupArns", 0, IndyInterface.bootstrap("invoke", "classicLoadBalancers", 0, IndyInterface.bootstrap("invoke", "subnetIds", 0, IndyInterface.bootstrap("invoke", "subnetType", 0, IndyInterface.bootstrap("invoke", "availabilityZones", 0, IndyInterface.bootstrap("invoke", "instanceType", 0, IndyInterface.bootstrap("invoke", "blockDevices", 0, IndyInterface.bootstrap("invoke", "associatePublicIpAddress", 0, IndyInterface.bootstrap("invoke", "startDisabled", 0, IndyInterface.bootstrap("invoke", "ignoreSequence", 0, IndyInterface.bootstrap("invoke", "sequence", 0, IndyInterface.bootstrap("invoke", "keyPair", 0, IndyInterface.bootstrap("invoke", "iamRole", 0, IndyInterface.bootstrap("invoke", "securityGroups", 0, IndyInterface.bootstrap("invoke", "desiredInstances", 0, IndyInterface.bootstrap("invoke", "maxInstances", 0, IndyInterface.bootstrap("invoke", "minInstances", 0, IndyInterface.bootstrap("invoke", "classicLinkVpcSecurityGroups", 0, IndyInterface.bootstrap("invoke", "classicLinkVpcId", 0, IndyInterface.bootstrap("invoke", "ami", 0, IndyInterface.bootstrap("invoke", "freeFormDetails", 0, IndyInterface.bootstrap("invoke", "stack", 0, IndyInterface.bootstrap("invoke", "credentials", 0, IndyInterface.bootstrap("invoke", "region", 0, IndyInterface.bootstrap("invoke", "application", 0, IndyInterface.bootstrap("invoke", "builder", 0, AutoScalingWorker.AsgConfiguration.class), IndyInterface.bootstrap("getProperty", "application", 4, (BasicAmazonDeployDescription)description2.get())), (String)region.get()), IndyInterface.bootstrap("getProperty", "credentials", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "stack", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "freeFormDetails", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "amiId", 4, ami)), classicLinkVpcId), classicLinkVpcSecurityGroups), IndyInterface.bootstrap("getProperty", "min", 0, capacity)), IndyInterface.bootstrap("getProperty", "max", 0, capacity)), IndyInterface.bootstrap("getProperty", "desired", 0, capacity)), IndyInterface.bootstrap("getProperty", "securityGroups", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("invoke", "iamRole", 0, BasicAmazonDeployHandler.class, (BasicAmazonDeployDescription)description2.get(), this.deployDefaults)), IndyInterface.bootstrap("cast", "()", 0, callSite16) != false ? callSite16 : IndyInterface.bootstrap("getProperty", "defaultKeyPair", 1, account)), IndyInterface.bootstrap("getProperty", "sequence", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "ignoreSequence", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "startDisabled", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "associatePublicIpAddress", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "blockDevices", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "instanceType", 4, (BasicAmazonDeployDescription)description2.get())), availabilityZones), subnetType), IndyInterface.bootstrap("getProperty", "subnetIds", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "classicLoadBalancers", 0, loadBalancers)), IndyInterface.bootstrap("getProperty", "targetGroupARNs", 0, targetGroups)), IndyInterface.bootstrap("getProperty", "cooldown", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "enabledMetrics", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "healthCheckGracePeriod", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "healthCheckType", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "terminationPolicies", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "spotPrice", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "suspendedProcesses", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "kernelId", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "ramdiskId", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "instanceMonitoring", 4, (BasicAmazonDeployDescription)description2.get())), ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "ebsOptimized", 4, (BasicAmazonDeployDescription)description2.get()), null) ? IndyInterface.bootstrap("invoke", "getDefaultEbsOptimizedFlag", 0, InstanceTypeUtils.class, IndyInterface.bootstrap("getProperty", "instanceType", 4, (BasicAmazonDeployDescription)description2.get())) : IndyInterface.bootstrap("getProperty", "ebsOptimized", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("invoke", "trim", 1, IndyInterface.bootstrap("getProperty", "base64UserData", 4, (BasicAmazonDeployDescription)description2.get()))), IndyInterface.bootstrap("getProperty", "legacyUdf", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "userDataOverride", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "tags", 0, IndyInterface.bootstrap("invoke", "applyAppStackDetailTags", 0, BasicAmazonDeployHandler.class, this.deployDefaults, (BasicAmazonDeployDescription)description2.get()))), IndyInterface.bootstrap("getProperty", "blockDeviceTags", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("invoke", "getLifecycleHooks", 0, BasicAmazonDeployHandler.class, account, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "setLaunchTemplate", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "requireIMDSv2", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "enableEnclave", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "associateIPv6Address", 4, (BasicAmazonDeployDescription)description2.get())), ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "unlimitedCpuCredits", 4, (BasicAmazonDeployDescription)description2.get()), null) ? IndyInterface.bootstrap("getProperty", "unlimitedCpuCredits", 4, (BasicAmazonDeployDescription)description2.get()) : IndyInterface.bootstrap("invoke", "getDefaultUnlimitedCpuCredits", 0, BasicAmazonDeployHandler.class, IndyInterface.bootstrap("invoke", "getAllowedInstanceTypes", 0, (BasicAmazonDeployDescription)description2.get()))), IndyInterface.bootstrap("getProperty", "placement", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "licenseSpecifications", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "onDemandAllocationStrategy", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "onDemandBaseCapacity", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "onDemandPercentageAboveBaseCapacity", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "spotAllocationStrategy", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "spotInstancePools", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "launchTemplateOverridesForInstanceType", 4, (BasicAmazonDeployDescription)description2.get())), IndyInterface.bootstrap("getProperty", "capacityRebalance", 4, (BasicAmazonDeployDescription)description2.get())));
                CallSite asgName = IndyInterface.bootstrap("invoke", "deploy", 0, autoScalingWorker, asgConfig);
                IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "serverGroupNames", 0, deploymentResult), IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{(String)region.get(), asgName}, new String[]{"", ":", ""})));
                CallSite callSite17 = asgName;
                IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "serverGroupNameByRegion", 0, deploymentResult), (String)region.get(), callSite17);
                if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "copySourceScalingPoliciesAndActions", 4, (BasicAmazonDeployDescription)description2.get())) && DefaultTypeTransformation.booleanUnbox((Object)sourceRegionScopedProvider)) {
                    IndyInterface.bootstrap("invoke", "copyScalingPoliciesAndScheduledActions", 2, this, IndyInterface.bootstrap("getProperty", "task", 12, this), sourceRegionScopedProvider, IndyInterface.bootstrap("getProperty", "amazonCredentials", 0, sourceRegionScopedProvider), IndyInterface.bootstrap("getProperty", "credentials", 4, (BasicAmazonDeployDescription)description2.get()), IndyInterface.bootstrap("getProperty", "asgName", 0, IndyInterface.bootstrap("getProperty", "source", 4, (BasicAmazonDeployDescription)description2.get())), asgName, IndyInterface.bootstrap("getProperty", "region", 0, IndyInterface.bootstrap("getProperty", "source", 4, (BasicAmazonDeployDescription)description2.get())), (String)region.get());
                }
                IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "events", 4, (BasicAmazonDeployDescription)description2.get()), IndyInterface.bootstrap("init", "<init>", 0, CreateServerGroupEvent.class, IndyInterface.bootstrap("getProperty", "ID", 0, AmazonCloudProvider.class), IndyInterface.bootstrap("getProperty", "accountId", 0, account), (String)region.get(), asgName));
                IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "deployments", 0, deploymentResult), IndyInterface.bootstrap("init", "<init>", 0, DeploymentResult.Deployment.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"cloudProvider", "aws", "account", IndyInterface.bootstrap("invoke", "getAccount", 0, (BasicAmazonDeployDescription)description2.get()), "location", (String)region.get(), "serverGroupName", asgName, "capacity", capacity})));
            }
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "deployments", 0, deploymentResult)}, new String[]{"Created the following deployments: ", ""}));
        return IndyInterface.bootstrap("cast", "()", 0, deploymentResult);
    }

    @VisibleForTesting
    LoadBalancerLookupHelper loadBalancerLookupHelper() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, LoadBalancerLookupHelper.class));
    }

    @VisibleForTesting
    TargetGroupLookupHelper targetGroupLookupHelper() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, TargetGroupLookupHelper.class));
    }

    @VisibleForTesting
    BasicAmazonDeployDescription copySourceAttributes(RegionScopedProviderFactory.RegionScopedProvider sourceRegionScopedProvider, String sourceAsgName, Boolean useSourceCapacity, BasicAmazonDeployDescription description) {
        Boolean copySourceSubnetIdOverrides = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "copySourceSubnetIdOverrides", 4, description)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "subnetIds", 4, description)) == false;
        if (DefaultTypeTransformation.booleanUnbox((Object)copySourceSubnetIdOverrides) && DefaultTypeTransformation.booleanUnbox((Object)sourceRegionScopedProvider) && DefaultTypeTransformation.booleanUnbox((Object)sourceAsgName)) {
            CallSite serverGroup = IndyInterface.bootstrap("invoke", "getServerGroup", 0, this.amazonServerGroupProvider, IndyInterface.bootstrap("getProperty", "name", 1, IndyInterface.bootstrap("getProperty", "amazonCredentials", 4, sourceRegionScopedProvider)), IndyInterface.bootstrap("getProperty", "region", 4, sourceRegionScopedProvider), sourceAsgName);
            if (IndyInterface.bootstrap("cast", "()", 0, serverGroup) != false) {
                public final class _copySourceAttributes_closure6
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _copySourceAttributes_closure6(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)IndyInterface.bootstrap("getProperty", "SUBNET_ID_OVERRIDE_TAG", 0, BasicAmazonDeployHandler.class));
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _copySourceAttributes_closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite subnetIdTag = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "value", 1, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("getProperty", "tags", 0, IndyInterface.bootstrap("getProperty", "asg", 0, serverGroup)), new _copySourceAttributes_closure6(this, this))));
                if (IndyInterface.bootstrap("cast", "()", 0, subnetIdTag) != false) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "split", 0, subnetIdTag, ",");
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, BasicAmazonDeployHandler.class, (GroovyObject)description, (String)"subnetIds");
                }
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "subnetIds", 4, description)) != false) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("getProperty", "subnetIds", 4, description), ",");
            IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "tags", 4, description), SUBNET_ID_OVERRIDE_TAG, callSite);
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "cleanTags", 0, BasicAmazonDeployHandler.class, IndyInterface.bootstrap("getProperty", "tags", 4, description));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, BasicAmazonDeployHandler.class, (GroovyObject)description, (String)"tags");
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "cleanTags", 0, BasicAmazonDeployHandler.class, IndyInterface.bootstrap("getProperty", "blockDeviceTags", 4, description));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, BasicAmazonDeployHandler.class, (GroovyObject)description, (String)"blockDeviceTags");
        if (!(DefaultTypeTransformation.booleanUnbox((Object)useSourceCapacity) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "copySourceCustomBlockDeviceMappings", 4, description)))) {
            return description;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, sourceRegionScopedProvider) == false) {
            if (IndyInterface.bootstrap("cast", "()", 0, useSourceCapacity) != false) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "useSourceCapacity requested, but no source available"));
            }
            return description;
        }
        description = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "clone", 0, description));
        CallSite sourceAutoScaling = IndyInterface.bootstrap("getProperty", "autoScaling", 4, sourceRegionScopedProvider);
        CallSite ancestorAsgs = IndyInterface.bootstrap("getProperty", "autoScalingGroups", 0, IndyInterface.bootstrap("invoke", "describeAutoScalingGroups", 0, sourceAutoScaling, IndyInterface.bootstrap("init", "<init>", 0, DescribeAutoScalingGroupsRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"autoScalingGroupNames", ScriptBytecodeAdapter.createList((Object[])new Object[]{sourceAsgName})}))));
        CallSite sourceAsg = IndyInterface.bootstrap("invoke", "getAt", 0, ancestorAsgs, false);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "launchConfigurationName", 1, sourceAsg)) == false && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "launchTemplate", 1, sourceAsg), null) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "mixedInstancesPolicy", 1, sourceAsg), null)) {
            if (IndyInterface.bootstrap("cast", "()", 0, useSourceCapacity) != false) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, "useSourceCapacity requested, but no source ASG found"));
            }
            return description;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, useSourceCapacity) != false) {
            CallSite callSite3 = IndyInterface.bootstrap("getProperty", "minSize", 0, sourceAsg);
            ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)IndyInterface.bootstrap("getProperty", "capacity", 4, description), (String)"min");
            CallSite callSite4 = IndyInterface.bootstrap("getProperty", "maxSize", 0, sourceAsg);
            ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)IndyInterface.bootstrap("getProperty", "capacity", 4, description), (String)"max");
            CallSite callSite5 = IndyInterface.bootstrap("getProperty", "desiredCapacity", 0, sourceAsg);
            ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)IndyInterface.bootstrap("getProperty", "capacity", 4, description), (String)"desired");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "copySourceCustomBlockDeviceMappings", 4, description)) == false) {
            return description;
        }
        CallSite callSite6 = IndyInterface.bootstrap("invoke", "buildBlockDeviceMappingsFromSourceAsg", 2, this, sourceRegionScopedProvider, sourceAsg, description);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite6, BasicAmazonDeployHandler.class, (GroovyObject)description, (String)"blockDevices");
        return description;
    }

    @VisibleForTesting
    void copyScalingPoliciesAndScheduledActions(Task task, RegionScopedProviderFactory.RegionScopedProvider sourceRegionScopedProvider, NetflixAmazonCredentials sourceCredentials, NetflixAmazonCredentials targetCredentials, String sourceAsgName, String targetAsgName, String sourceRegion, String targetRegion) {
        if (IndyInterface.bootstrap("cast", "()", 0, sourceRegionScopedProvider) == false) {
            return;
        }
        CallSite asgReferenceCopier = IndyInterface.bootstrap("invoke", "getAsgReferenceCopier", 0, sourceRegionScopedProvider, targetCredentials, targetRegion);
        IndyInterface.bootstrap("invoke", "copyScalingPolicies", 0, this.scalingPolicyCopier, task, sourceAsgName, targetAsgName, sourceCredentials, targetCredentials, sourceRegion, targetRegion);
        IndyInterface.bootstrap("invoke", "copyScheduledActionsForAsg", 0, asgReferenceCopier, task, sourceAsgName, targetAsgName);
    }

    @VisibleForTesting
    static List<AmazonAsgLifecycleHook> getLifecycleHooks(NetflixAmazonCredentials credentials, BasicAmazonDeployDescription description) {
        CallSite callSite = IndyInterface.bootstrap("getProperty", "lifecycleHooks", 4, description);
        CallSite lifecycleHooks = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "includeAccountLifecycleHooks", 4, description)) && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 1, IndyInterface.bootstrap("getProperty", "lifecycleHooks", 0, credentials)), (Object)0)) {
            public final class _getLifecycleHooks_closure7
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getLifecycleHooks_closure7(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("init", "<init>", 0, AmazonAsgLifecycleHook.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"roleARN", IndyInterface.bootstrap("getProperty", "roleARN", 0, it), "notificationTargetARN", IndyInterface.bootstrap("getProperty", "notificationTargetARN", 0, it), "lifecycleTransition", IndyInterface.bootstrap("invoke", "valueOfName", 0, AmazonAsgLifecycleHook.Transition.class, IndyInterface.bootstrap("getProperty", "lifecycleTransition", 0, it)), "heartbeatTimeout", IndyInterface.bootstrap("getProperty", "heartbeatTimeout", 0, it), "defaultResult", IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "defaultResult", 0, it)) != false ? IndyInterface.bootstrap("invoke", "valueOf", 0, AmazonAsgLifecycleHook.DefaultResult.class, IndyInterface.bootstrap("getProperty", "defaultResult", 0, it)) : null}));
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getLifecycleHooks_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "addAll", 0, lifecycleHooks, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "lifecycleHooks", 0, credentials), new _getLifecycleHooks_closure7(BasicAmazonDeployHandler.class, BasicAmazonDeployHandler.class)));
        }
        return lifecycleHooks;
    }

    @VisibleForTesting
    public static Boolean getDefaultUnlimitedCpuCredits(Set<String> instanceTypes) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isBurstingSupportedByAllTypes", 0, InstanceTypeUtils.class, instanceTypes)) != false ? Boolean.valueOf(false) : null);
    }

    public static String iamRole(BasicAmazonDeployDescription description, AwsConfiguration.DeployDefaults deployDefaults) {
        CallSite callSite = IndyInterface.bootstrap("getProperty", "iamRole", 4, description);
        CallSite iamRole = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : IndyInterface.bootstrap("getProperty", "iamRole", 4, deployDefaults);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "application", 4, description)) != false ? IndyInterface.bootstrap("invoke", "replaceAll", 0, iamRole, IndyInterface.bootstrap("invoke", "quote", 0, Pattern.class, "{{application}}"), IndyInterface.bootstrap("getProperty", "application", 4, description)) : iamRole);
    }

    @VisibleForTesting
    static Map<String, String> cleanTags(Map<String, String> tags) {
        public final class _cleanTags_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _cleanTags_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "startsWith", 0, IndyInterface.bootstrap("getProperty", "key", 0, it), "aws:")) == false;
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _cleanTags_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, tags) != false ? IndyInterface.bootstrap("invoke", "findAll", 0, tags, new _cleanTags_closure8(BasicAmazonDeployHandler.class, BasicAmazonDeployHandler.class)) : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @VisibleForTesting
    static BasicAmazonDeployDescription applyAppStackDetailTags(AwsConfiguration.DeployDefaults deployDefaults, BasicAmazonDeployDescription description) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "addAppStackDetailTags", 4, deployDefaults)) == false) {
            return description;
        }
        description = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "clone", 0, description));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "application", 4, description)) != false) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "application", 4, description);
            IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "tags", 4, description), "spinnaker:application", callSite);
        } else {
            IndyInterface.bootstrap("invoke", "remove", 0, IndyInterface.bootstrap("getProperty", "tags", 4, description), "spinnaker:application");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "stack", 4, description)) != false) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "stack", 4, description);
            IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "tags", 4, description), "spinnaker:stack", callSite);
        } else {
            IndyInterface.bootstrap("invoke", "remove", 0, IndyInterface.bootstrap("getProperty", "tags", 4, description), "spinnaker:stack");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "freeFormDetails", 4, description)) != false) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "freeFormDetails", 4, description);
            IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "tags", 4, description), "spinnaker:details", callSite);
        } else {
            IndyInterface.bootstrap("invoke", "remove", 0, IndyInterface.bootstrap("getProperty", "tags", 4, description), "spinnaker:details");
        }
        return description;
    }

    private RegionScopedProviderFactory.RegionScopedProvider buildSourceRegionScopedProvider(Task task, BasicAmazonDeployDescription.Source source) {
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "account", 4, source)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "region", 4, source)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "asgName", 4, source))) {
            CallSite sourceRegion = IndyInterface.bootstrap("getProperty", "region", 4, source);
            CallSite sourceAsgCredentials = IndyInterface.bootstrap("invoke", "getOne", 0, this.accountCredentialsRepository, IndyInterface.bootstrap("getProperty", "account", 4, source));
            CallSite regionScopedProvider = IndyInterface.bootstrap("invoke", "forRegion", 0, this.regionScopedProviderFactory, sourceAsgCredentials, sourceRegion);
            CallSite sourceAsgs = IndyInterface.bootstrap("invoke", "describeAutoScalingGroups", 0, IndyInterface.bootstrap("getProperty", "autoScaling", 0, regionScopedProvider), IndyInterface.bootstrap("init", "<init>", 0, DescribeAutoScalingGroupsRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"autoScalingGroupNames", ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "asgName", 4, source)})})));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "autoScalingGroups", 0, sourceAsgs)) == false) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, task, BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "account", 4, source), IndyInterface.bootstrap("getProperty", "region", 4, source), IndyInterface.bootstrap("getProperty", "asgName", 4, source)}, new String[]{"Unable to locate source asg (", ":", ":", ")"}));
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }
            return IndyInterface.bootstrap("cast", "()", 0, regionScopedProvider);
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public List<AmazonBlockDevice> buildBlockDeviceMappingsFromSourceAsg(RegionScopedProviderFactory.RegionScopedProvider sourceAsgRegionScopedProvider, AutoScalingGroup sourceAsg, BasicAmazonDeployDescription newAsgDescription) {
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "blockDevices", 4, newAsgDescription), null)) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "blockDevices", 4, newAsgDescription));
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getInstanceType", 0, newAsgDescription), (Object)IndyInterface.bootstrap("invoke", "getTopLevelInstanceTypeForAsg", 0, AsgConfigHelper.class, sourceAsg, sourceAsgRegionScopedProvider))) {
            public final class _buildBlockDeviceMappingsFromSourceAsg_closure9
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _buildBlockDeviceMappingsFromSourceAsg_closure9(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"deviceName", IndyInterface.bootstrap("getProperty", "deviceName", 0, it), "virtualName", IndyInterface.bootstrap("getProperty", "virtualName", 0, it), "size", IndyInterface.bootstrap("getProperty", "size", 0, it)});
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildBlockDeviceMappingsFromSourceAsg_closure9.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            public final class _buildBlockDeviceMappingsFromSourceAsg_closure10
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _buildBlockDeviceMappingsFromSourceAsg_closure10(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("getProperty", "deviceName", 0, it);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildBlockDeviceMappingsFromSourceAsg_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite blockDevicesForSourceAsg = IndyInterface.bootstrap("invoke", "sort", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "getBlockDeviceMappingForAsg", 0, AsgConfigHelper.class, sourceAsg, sourceAsgRegionScopedProvider), new _buildBlockDeviceMappingsFromSourceAsg_closure9(this, this)), new _buildBlockDeviceMappingsFromSourceAsg_closure10(this, this));
            public final class _buildBlockDeviceMappingsFromSourceAsg_closure11
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _buildBlockDeviceMappingsFromSourceAsg_closure11(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"deviceName", IndyInterface.bootstrap("getProperty", "deviceName", 0, it), "virtualName", IndyInterface.bootstrap("getProperty", "virtualName", 0, it), "size", IndyInterface.bootstrap("getProperty", "size", 0, it)});
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildBlockDeviceMappingsFromSourceAsg_closure11.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            public final class _buildBlockDeviceMappingsFromSourceAsg_closure12
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _buildBlockDeviceMappingsFromSourceAsg_closure12(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("getProperty", "deviceName", 0, it);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildBlockDeviceMappingsFromSourceAsg_closure12.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite defaultBlockDevicesForSourceInsType = IndyInterface.bootstrap("invoke", "sort", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "getBlockDevicesForInstanceType", 0, this.blockDeviceConfig, IndyInterface.bootstrap("invoke", "getTopLevelInstanceTypeForAsg", 0, AsgConfigHelper.class, sourceAsg, sourceAsgRegionScopedProvider)), new _buildBlockDeviceMappingsFromSourceAsg_closure11(this, this)), new _buildBlockDeviceMappingsFromSourceAsg_closure12(this, this));
            boolean isDefaultMappingUsedInSourceAsg = ScriptBytecodeAdapter.compareEqual((Object)blockDevicesForSourceAsg, (Object)defaultBlockDevicesForSourceInsType);
            if (isDefaultMappingUsedInSourceAsg) {
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getBlockDevicesForInstanceType", 0, this.blockDeviceConfig, IndyInterface.bootstrap("invoke", "getInstanceType", 0, newAsgDescription)));
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getBlockDeviceMappingForAsg", 0, AsgConfigHelper.class, sourceAsg, sourceAsgRegionScopedProvider));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != BasicAmazonDeployHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.deploy.handlers.BasicAmazonDeployHandler");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }
}

