/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.handlers;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import com.amazonaws.services.elasticloadbalancing.model.ListenerDescription;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerDescription;
import com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerUpsertHandler
implements GroovyObject {
    private static final String BASE_PHASE = "UPSERT_ELB";
    private static Closure notLegacyListener;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public LoadBalancerUpsertHandler() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    /*
     * WARNING - void declaration
     */
    public static void updateLoadBalancer(AmazonElasticLoadBalancing loadBalancing, LoadBalancerDescription loadBalancer, List<Listener> listeners, Collection<String> securityGroups) {
        void var2_2;
        void var1_1;
        Reference loadBalancing2 = new Reference((Object)loadBalancing);
        Reference loadBalancer2 = new Reference((Object)var1_1);
        Reference listeners2 = new Reference((Object)var2_2);
        Reference amazonErrors = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        Reference loadBalancerName = new Reference((Object)IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, (LoadBalancerDescription)loadBalancer2.get()));
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "getVPCId", 0, (LoadBalancerDescription)loadBalancer2.get())) && IndyInterface.bootstrap("cast", "()", 0, securityGroups) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{loadBalancerName.get()}, new String[]{"Load balancer ", " must have at least one security group"})));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, securityGroups) != false) {
            IndyInterface.bootstrap("invoke", "applySecurityGroupsToLoadBalancer", 0, (AmazonElasticLoadBalancing)loadBalancing2.get(), IndyInterface.bootstrap("init", "<init>", 0, ApplySecurityGroupsToLoadBalancerRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancerName", loadBalancerName.get(), "securityGroups", securityGroups})));
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 8, LoadBalancerUpsertHandler.class), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName.get()}, new String[]{"Security groups updated on ", "."}));
        if (IndyInterface.bootstrap("cast", "()", 0, (List)listeners2.get()) != false) {
            listeners2.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, (List)listeners2.get(), notLegacyListener)));
            CallSite existingListeners = IndyInterface.bootstrap("invoke", "findAll", 0, ScriptBytecodeAdapter.getPropertySpreadSafe(LoadBalancerUpsertHandler.class, (Object)IndyInterface.bootstrap("getProperty", "listenerDescriptions", 0, (LoadBalancerDescription)loadBalancer2.get()), (String)"listener"), notLegacyListener);
            public final class _updateLoadBalancer_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference listeners;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _updateLoadBalancer_closure1(Object _outerInstance, Object _thisObject, Reference listeners) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.listeners = reference = listeners;
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("cast", "()", 0, this.listeners.get()), it)) == false;
                }

                @Generated
                public List getListeners() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.listeners.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Reference listenersToRemove = new Reference((Object)IndyInterface.bootstrap("invoke", "findAll", 0, existingListeners, new _updateLoadBalancer_closure1(LoadBalancerUpsertHandler.class, LoadBalancerUpsertHandler.class, listeners2)));
            IndyInterface.bootstrap("invoke", "removeAll", 0, (List)listeners2.get(), listenersToRemove.get());
            IndyInterface.bootstrap("invoke", "removeAll", 0, (List)listeners2.get(), existingListeners);
            public final class _updateLoadBalancer_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference listenersToRemove;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _updateLoadBalancer_closure2(Object _outerInstance, Object _thisObject, Reference listenersToRemove) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.listenersToRemove = reference = listenersToRemove;
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "listener", 0, it), (Object)this.listenersToRemove.get());
                }

                @Generated
                public Object getListenersToRemove() {
                    return this.listenersToRemove.get();
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite listenerDescriptionsToRemove = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("getProperty", "listenerDescriptions", 0, (LoadBalancerDescription)loadBalancer2.get()), new _updateLoadBalancer_closure2(LoadBalancerUpsertHandler.class, LoadBalancerUpsertHandler.class, listenersToRemove)));
            public final class _updateLoadBalancer_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancing;
                private /* synthetic */ Reference loadBalancerName;
                private /* synthetic */ Reference amazonErrors;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _updateLoadBalancer_closure3(Object _outerInstance, Object _thisObject, Reference loadBalancing, Reference loadBalancerName, Reference amazonErrors) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.loadBalancing = reference3 = loadBalancing;
                    this.loadBalancerName = reference2 = loadBalancerName;
                    this.amazonErrors = reference = amazonErrors;
                }

                public Object doCall(ListenerDescription listenerDescription, boolean isRollback) {
                    try {
                        IndyInterface.bootstrap("invoke", "createLoadBalancerListeners", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()), IndyInterface.bootstrap("init", "<init>", 0, CreateLoadBalancerListenersRequest.class, this.loadBalancerName.get(), ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "listener", 0, listenerDescription)})));
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("getProperty", "policyNames", 0, listenerDescription))) == false) {
                            IndyInterface.bootstrap("invoke", "ensureSetLoadBalancerListenerPolicies", 2, this, this.loadBalancerName.get(), listenerDescription, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()));
                        }
                        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{isRollback ? "rolled back on" : "added to", this.loadBalancerName.get()}, new String[]{"Listener ", " ", " "}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerPort", 0, IndyInterface.bootstrap("getProperty", "listener", 0, listenerDescription)), IndyInterface.bootstrap("getProperty", "protocol", 0, IndyInterface.bootstrap("getProperty", "listener", 0, listenerDescription)), IndyInterface.bootstrap("getProperty", "instancePort", 0, IndyInterface.bootstrap("getProperty", "listener", 0, listenerDescription))}, new String[]{"(", ":", ":", ")."})));
                    }
                    catch (AmazonServiceException e) {
                        CallSite exceptionMessage = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{isRollback ? "roll back" : "add", this.loadBalancerName.get()}, new String[]{"Failed to ", " listener to ", " "}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerPort", 0, IndyInterface.bootstrap("getProperty", "listener", 0, listenerDescription)), IndyInterface.bootstrap("getProperty", "protocol", 0, IndyInterface.bootstrap("getProperty", "listener", 0, listenerDescription)), IndyInterface.bootstrap("getProperty", "instancePort", 0, IndyInterface.bootstrap("getProperty", "listener", 0, listenerDescription))}, new String[]{"(", ":", ":", ") "})), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "errorMessage", 0, e)}, new String[]{"- reason: ", "."}));
                        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), exceptionMessage);
                        IndyInterface.bootstrap("invoke", "leftShift", 0, this.amazonErrors.get(), exceptionMessage);
                        Boolean bl = false;
                        return bl;
                    }
                    return true;
                }

                @Generated
                public Object call(ListenerDescription listenerDescription, boolean isRollback) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, listenerDescription, isRollback);
                }

                @Generated
                public AmazonElasticLoadBalancing getLoadBalancing() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get());
                }

                @Generated
                public Object getLoadBalancerName() {
                    return this.loadBalancerName.get();
                }

                @Generated
                public Object getAmazonErrors() {
                    return this.amazonErrors.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Reference createListener = new Reference((Object)new _updateLoadBalancer_closure3(LoadBalancerUpsertHandler.class, LoadBalancerUpsertHandler.class, loadBalancing2, loadBalancerName, amazonErrors));
            Reference rollback = new Reference((Object)false);
            public final class _updateLoadBalancer_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancing;
                private /* synthetic */ Reference loadBalancerName;
                private /* synthetic */ Reference amazonErrors;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _updateLoadBalancer_closure4(Object _outerInstance, Object _thisObject, Reference loadBalancing, Reference loadBalancerName, Reference amazonErrors) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.loadBalancing = reference3 = loadBalancing;
                    this.loadBalancerName = reference2 = loadBalancerName;
                    this.amazonErrors = reference = amazonErrors;
                }

                public Object doCall(Object it) {
                    IndyInterface.bootstrap("invoke", "deleteLoadBalancerListeners", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()), IndyInterface.bootstrap("init", "<init>", 0, DeleteLoadBalancerListenersRequest.class, this.loadBalancerName.get(), ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerPort", 0, IndyInterface.bootstrap("getProperty", "listener", 0, it))})));
                    CallSite callSite = IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{this.loadBalancerName.get(), IndyInterface.bootstrap("getProperty", "loadBalancerPort", 0, IndyInterface.bootstrap("getProperty", "listener", 0, it)), IndyInterface.bootstrap("getProperty", "protocol", 0, IndyInterface.bootstrap("getProperty", "listener", 0, it)), IndyInterface.bootstrap("getProperty", "instancePort", 0, IndyInterface.bootstrap("getProperty", "listener", 0, it))}, new String[]{"Listener removed from ", " (", ":", ":", ")."}));
                    try {
                        return callSite;
                    }
                    catch (AmazonServiceException e) {
                        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{it, IndyInterface.bootstrap("getProperty", "errorMessage", 0, e)}, new String[]{"Failed to remove listener ", ": ", "."}));
                        CallSite callSite2 = IndyInterface.bootstrap("invoke", "leftShift", 0, this.amazonErrors.get(), IndyInterface.bootstrap("getProperty", "errorMessage", 0, e));
                        return callSite2;
                    }
                }

                @Generated
                public AmazonElasticLoadBalancing getLoadBalancing() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get());
                }

                @Generated
                public Object getLoadBalancerName() {
                    return this.loadBalancerName.get();
                }

                @Generated
                public Object getAmazonErrors() {
                    return this.amazonErrors.get();
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, listenerDescriptionsToRemove, new _updateLoadBalancer_closure4(LoadBalancerUpsertHandler.class, LoadBalancerUpsertHandler.class, loadBalancing2, loadBalancerName, amazonErrors));
            public final class _updateLoadBalancer_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancer;
                private /* synthetic */ Reference createListener;
                private /* synthetic */ Reference rollback;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _updateLoadBalancer_closure5(Object _outerInstance, Object _thisObject, Reference loadBalancer, Reference createListener, Reference rollback) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    this.loadBalancer = reference3 = loadBalancer;
                    this.createListener = reference2 = createListener;
                    this.rollback = reference = rollback;
                }

                public Object doCall(Object listener) {
                    Reference listener2 = new Reference(listener);
                    public final class _closure8
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference listener;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure8(Object _outerInstance, Object _thisObject, Reference listener) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.listener = reference = listener;
                        }

                        public Object doCall(Object it) {
                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "loadBalancerPort", 0, IndyInterface.bootstrap("getProperty", "listener", 0, it)), (Object)IndyInterface.bootstrap("getProperty", "loadBalancerPort", 0, this.listener.get())) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "protocol", 0, IndyInterface.bootstrap("getProperty", "listener", 0, it)), (Object)IndyInterface.bootstrap("getProperty", "protocol", 0, this.listener.get()));
                        }

                        @Generated
                        public Object getListener() {
                            return this.listener.get();
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure8.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite policyNames = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "policyNames", 1, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("getProperty", "listenerDescriptions", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get())), new _closure8((Object)this, this.getThisObject(), listener2))));
                    CallSite description = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ListenerDescription.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"listener", listener2.get(), "policyNames", policyNames})));
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "call", 0, this.createListener.get(), description, false)) == false) {
                        boolean bl = true;
                        this.rollback.set((Object)bl);
                        return bl;
                    }
                    return null;
                }

                @Generated
                public LoadBalancerDescription getLoadBalancer() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get());
                }

                @Generated
                public Object getCreateListener() {
                    return this.createListener.get();
                }

                @Generated
                public Boolean getRollback() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.rollback.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, (List)listeners2.get(), new _updateLoadBalancer_closure5(LoadBalancerUpsertHandler.class, LoadBalancerUpsertHandler.class, loadBalancer2, createListener, rollback));
            if (DefaultTypeTransformation.booleanUnbox((Object)amazonErrors.get()) || DefaultTypeTransformation.booleanUnbox((Object)((Boolean)rollback.get()))) {
                public final class _updateLoadBalancer_closure6
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference createListener;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _updateLoadBalancer_closure6(Object _outerInstance, Object _thisObject, Reference createListener) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.createListener = reference = createListener;
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("invoke", "call", 0, this.createListener.get(), it, true);
                    }

                    @Generated
                    public Object getCreateListener() {
                        return this.createListener.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, listenerDescriptionsToRemove, new _updateLoadBalancer_closure6(LoadBalancerUpsertHandler.class, LoadBalancerUpsertHandler.class, createListener));
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, amazonErrors.get()) != false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AtomicOperationException.class, "Failed to apply all load balancer updates", amazonErrors.get()));
        }
    }

    public static String createLoadBalancer(AmazonElasticLoadBalancing loadBalancing, String loadBalancerName, boolean isInternal, Collection<String> availabilityZones, Collection<String> subnetIds, Collection<Listener> listeners, Collection<String> securityGroups) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createLoadBalancer", 0, LoadBalancerUpsertHandler.class, loadBalancing, loadBalancerName, isInternal, availabilityZones, subnetIds, listeners, securityGroups, null));
    }

    public static String createLoadBalancer(AmazonElasticLoadBalancing loadBalancing, String loadBalancerName, boolean isInternal, Collection<String> availabilityZones, Collection<String> subnetIds, Collection<Listener> listeners, Collection<String> securityGroups, LoadBalancerAttributes sourceAttributes) {
        CallSite request = IndyInterface.bootstrap("init", "<init>", 0, CreateLoadBalancerRequest.class, loadBalancerName);
        if (IndyInterface.bootstrap("cast", "()", 0, subnetIds) != false) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 8, LoadBalancerUpsertHandler.class), BASE_PHASE, new GStringImpl(new Object[]{subnetIds}, new String[]{"Subnets: [", "]"}));
            IndyInterface.bootstrap("invoke", "withSubnets", 0, request, subnetIds);
            if (isInternal) {
                String string = "internal";
                ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"scheme");
            }
            IndyInterface.bootstrap("invoke", "withSecurityGroups", 0, request, securityGroups);
        } else {
            IndyInterface.bootstrap("invoke", "withAvailabilityZones", 0, request, availabilityZones);
        }
        IndyInterface.bootstrap("invoke", "withListeners", 0, request, listeners);
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 8, LoadBalancerUpsertHandler.class), BASE_PHASE, "Creating load balancer.");
        CallSite result = IndyInterface.bootstrap("invoke", "createLoadBalancer", 0, loadBalancing, request);
        if (IndyInterface.bootstrap("cast", "()", 0, sourceAttributes) != false) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 8, LoadBalancerUpsertHandler.class), BASE_PHASE, "Configuring load balancer attributes.");
            IndyInterface.bootstrap("invoke", "modifyLoadBalancerAttributes", 0, loadBalancing, IndyInterface.bootstrap("invoke", "withLoadBalancerName", 0, IndyInterface.bootstrap("invoke", "withLoadBalancerAttributes", 0, IndyInterface.bootstrap("init", "<init>", 0, ModifyLoadBalancerAttributesRequest.class), sourceAttributes), loadBalancerName));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "DNSName", 0, result));
    }

    private static void ensureSetLoadBalancerListenerPolicies(String loadBalancerName, ListenerDescription listenerDescription, AmazonElasticLoadBalancing loadBalancing) {
        CallSite policyRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withLoadBalancerPort", 0, IndyInterface.bootstrap("invoke", "withLoadBalancerName", 0, IndyInterface.bootstrap("init", "<init>", 0, SetLoadBalancerPoliciesOfListenerRequest.class), loadBalancerName), IndyInterface.bootstrap("getProperty", "loadBalancerPort", 0, IndyInterface.bootstrap("getProperty", "listener", 0, listenerDescription))));
        try {
            IndyInterface.bootstrap("invoke", "setLoadBalancerPoliciesOfListener", 0, loadBalancing, IndyInterface.bootstrap("invoke", "withPolicyNames", 0, policyRequest, IndyInterface.bootstrap("getProperty", "policyNames", 0, listenerDescription)));
        }
        catch (AmazonServiceException e) {
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isErrorEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "error", 0, log, new GStringImpl(new Object[]{loadBalancerName, IndyInterface.bootstrap("getProperty", "errorMessage", 0, e)}, new String[]{"Failed to set listener policies on loadbalancer ", ": ", ""})) : null;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != LoadBalancerUpsertHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        public final class __clinit__closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Listener listener) {
                return ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "instancePort", 0, listener), (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "loadBalancerPort", 0, listener), (Object)0) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "protocol", 0, listener));
            }

            @Generated
            public Object call(Listener listener) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, listener);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        __clinit__closure7 __clinit__closure72 = new __clinit__closure7(LoadBalancerUpsertHandler.class, LoadBalancerUpsertHandler.class);
        notLegacyListener = __clinit__closure72;
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.deploy.handlers.LoadBalancerUpsertHandler");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }
}

