/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.handlers;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancingv2.model.Action;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateListenerRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateRuleRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DeleteListenerRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DeleteRuleRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.HttpRequestMethodConditionConfig;
import com.amazonaws.services.elasticloadbalancingv2.model.Listener;
import com.amazonaws.services.elasticloadbalancingv2.model.ListenerNotFoundException;
import com.amazonaws.services.elasticloadbalancingv2.model.LoadBalancer;
import com.amazonaws.services.elasticloadbalancingv2.model.LoadBalancerAttribute;
import com.amazonaws.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum;
import com.amazonaws.services.elasticloadbalancingv2.model.Matcher;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyListenerRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.ProtocolEnum;
import com.amazonaws.services.elasticloadbalancingv2.model.ResourceInUseException;
import com.amazonaws.services.elasticloadbalancingv2.model.Rule;
import com.amazonaws.services.elasticloadbalancingv2.model.RuleCondition;
import com.amazonaws.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetGroup;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetGroupAttribute;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetTypeEnum;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertAmazonLoadBalancerV2Description;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationException;
import com.netflix.spinnaker.config.AwsConfiguration;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerV2UpsertHandler
implements GroovyObject {
    private static final String BASE_PHASE = "UPSERT_ELB_V2";
    private static final String ATTRIBUTE_IDLE_TIMEOUT = "idle_timeout.timeout_seconds";
    private static final String ATTRIBUTE_DELETION_PROTECTION = "deletion_protection.enabled";
    private static final String ATTRIBUTE_LOAD_BALANCING_CROSS_ZONE = "load_balancing.cross_zone.enabled";
    private static final String DEREGISTRATION_DELAY = "300";
    private static final Boolean STICKINESS_ENABLED;
    private static final String STICKINESS_TYPE = "lb_cookie";
    private static final String STICKINESS_DURATION = "86400";
    private static final Boolean PROXY_PROTOCOL_V2;
    private static final Boolean CONNECTION_TERMINATION;
    private static final Boolean MULTI_VALUE_HEADERS_ENABLED;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public LoadBalancerV2UpsertHandler() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public static String createTargetGroupAttributes(AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer, TargetGroup targetGroup, UpsertAmazonLoadBalancerV2Description.Attributes attributes, AwsConfiguration.DeployDefaults deployDefaults) {
        List targetGroupAttributes = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, "Creating target group attributes for targetGroup {}", IndyInterface.bootstrap("getProperty", "targetGroupName", 0, targetGroup)) : null;
        if (IndyInterface.bootstrap("cast", "()", 0, attributes) != false) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "Lambda", 0, TargetTypeEnum.class)), IndyInterface.bootstrap("invoke", "getTargetType", 0, targetGroup))) != false) {
                CallSite callSite2 = IndyInterface.bootstrap("getProperty", "multiValueHeadersEnabled", 0, attributes);
                Object multiValueHeaderAttribute = IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : MULTI_VALUE_HEADERS_ENABLED;
                IndyInterface.bootstrap("invoke", "add", 0, targetGroupAttributes, IndyInterface.bootstrap("init", "<init>", 0, TargetGroupAttribute.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "lambda.multi_value_headers.enabled", "value", multiValueHeaderAttribute})));
            } else {
                CallSite deregistrationDelay = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findResult", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "deregistrationDelay", 0, attributes), IndyInterface.bootstrap("getProperty", "deregistrationDelayDefault", 1, IndyInterface.bootstrap("getProperty", "loadBalancing", 5, deployDefaults))}), IndyInterface.bootstrap("getProperty", "IDENTITY", 0, Closure.class)));
                CallSite callSite3 = IndyInterface.bootstrap("invoke", "toString", 1, deregistrationDelay);
                Object deregistrationDealyAttribute = IndyInterface.bootstrap("cast", "()", 0, callSite3) != false ? callSite3 : DEREGISTRATION_DELAY;
                IndyInterface.bootstrap("invoke", "add", 0, targetGroupAttributes, IndyInterface.bootstrap("init", "<init>", 0, TargetGroupAttribute.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "deregistration_delay.timeout_seconds", "value", deregistrationDealyAttribute})));
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, loadBalancer), (Object)"application")) {
                CallSite callSite4 = IndyInterface.bootstrap("invoke", "toString", 1, IndyInterface.bootstrap("getProperty", "stickinessEnabled", 0, attributes));
                Object stickinessEnabledAttribute = IndyInterface.bootstrap("cast", "()", 0, callSite4) != false ? callSite4 : STICKINESS_ENABLED;
                IndyInterface.bootstrap("invoke", "add", 0, targetGroupAttributes, IndyInterface.bootstrap("init", "<init>", 0, TargetGroupAttribute.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "stickiness.enabled", "value", stickinessEnabledAttribute})));
                CallSite callSite5 = IndyInterface.bootstrap("getProperty", "stickinessType", 0, attributes);
                Object stickinessTypeAttribute = IndyInterface.bootstrap("cast", "()", 0, callSite5) != false ? callSite5 : STICKINESS_TYPE;
                IndyInterface.bootstrap("invoke", "add", 0, targetGroupAttributes, IndyInterface.bootstrap("init", "<init>", 0, TargetGroupAttribute.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "stickiness.type", "value", stickinessTypeAttribute})));
                CallSite callSite6 = IndyInterface.bootstrap("invoke", "toString", 1, IndyInterface.bootstrap("getProperty", "stickinessDuration", 0, attributes));
                Object stickinessDurationAttribute = IndyInterface.bootstrap("cast", "()", 0, callSite6) != false ? callSite6 : STICKINESS_DURATION;
                IndyInterface.bootstrap("invoke", "add", 0, targetGroupAttributes, IndyInterface.bootstrap("init", "<init>", 0, TargetGroupAttribute.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "stickiness.lb_cookie.duration_seconds", "value", stickinessDurationAttribute})));
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, loadBalancer), (Object)"network")) {
                CallSite callSite7 = IndyInterface.bootstrap("getProperty", "proxyProtocolV2", 0, attributes);
                Object proxyProtocolV2Attribute = IndyInterface.bootstrap("cast", "()", 0, callSite7) != false ? callSite7 : PROXY_PROTOCOL_V2;
                IndyInterface.bootstrap("invoke", "add", 0, targetGroupAttributes, IndyInterface.bootstrap("init", "<init>", 0, TargetGroupAttribute.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "proxy_protocol_v2.enabled", "value", proxyProtocolV2Attribute})));
                CallSite callSite8 = IndyInterface.bootstrap("getProperty", "deregistrationDelayConnectionTermination", 0, attributes);
                Object enableConnectionTermination = IndyInterface.bootstrap("cast", "()", 0, callSite8) != false ? callSite8 : CONNECTION_TERMINATION;
                IndyInterface.bootstrap("invoke", "add", 0, targetGroupAttributes, IndyInterface.bootstrap("init", "<init>", 0, TargetGroupAttribute.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "deregistration_delay.connection_termination.enabled", "value", enableConnectionTermination})));
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "updateTargetGroupAttributes", 0, LoadBalancerV2UpsertHandler.class, loadBalancing, targetGroup, targetGroupAttributes));
    }

    private static String modifyTargetGroupAttributes(AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer, TargetGroup targetGroup, UpsertAmazonLoadBalancerV2Description.Attributes attributes, AwsConfiguration.DeployDefaults deployDefaults) {
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, "Update target group attributes for targetGroup {}", IndyInterface.bootstrap("getProperty", "targetGroupName", 0, targetGroup)) : null;
        List targetGroupAttributes = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (IndyInterface.bootstrap("cast", "()", 0, attributes) != false) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "Lambda", 0, TargetTypeEnum.class)), IndyInterface.bootstrap("invoke", "getTargetType", 0, targetGroup))) != false) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "multiValueHeadersEnabled", 0, attributes), null)) {
                    IndyInterface.bootstrap("invoke", "add", 0, targetGroupAttributes, IndyInterface.bootstrap("init", "<init>", 0, TargetGroupAttribute.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "lambda.multi_value_headers.enabled", "value", IndyInterface.bootstrap("getProperty", "multiValueHeadersEnabled", 0, attributes)})));
                }
            } else {
                CallSite deregistrationDelay = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findResult", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "deregistrationDelay", 0, attributes), IndyInterface.bootstrap("getProperty", "deregistrationDelayDefault", 1, IndyInterface.bootstrap("getProperty", "loadBalancing", 5, deployDefaults))}), IndyInterface.bootstrap("getProperty", "IDENTITY", 0, Closure.class)));
                if (ScriptBytecodeAdapter.compareNotEqual((Object)deregistrationDelay, null)) {
                    IndyInterface.bootstrap("invoke", "add", 0, targetGroupAttributes, IndyInterface.bootstrap("init", "<init>", 0, TargetGroupAttribute.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "deregistration_delay.timeout_seconds", "value", IndyInterface.bootstrap("invoke", "toString", 0, deregistrationDelay)})));
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, loadBalancer), (Object)"application")) {
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "stickinessEnabled", 0, attributes), null)) {
                        IndyInterface.bootstrap("invoke", "add", 0, targetGroupAttributes, IndyInterface.bootstrap("init", "<init>", 0, TargetGroupAttribute.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "stickiness.enabled", "value", IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "stickinessEnabled", 0, attributes))})));
                    }
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "stickinessType", 0, attributes), null)) {
                        IndyInterface.bootstrap("invoke", "add", 0, targetGroupAttributes, IndyInterface.bootstrap("init", "<init>", 0, TargetGroupAttribute.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "stickiness.type", "value", IndyInterface.bootstrap("getProperty", "stickinessType", 0, attributes)})));
                    }
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "stickinessDuration", 0, attributes), null)) {
                        IndyInterface.bootstrap("invoke", "add", 0, targetGroupAttributes, IndyInterface.bootstrap("init", "<init>", 0, TargetGroupAttribute.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "stickiness.lb_cookie.duration_seconds", "value", IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "stickinessDuration", 0, attributes))})));
                    }
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, loadBalancer), (Object)"network")) {
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "proxyProtocolV2", 0, attributes), null)) {
                        IndyInterface.bootstrap("invoke", "add", 0, targetGroupAttributes, IndyInterface.bootstrap("init", "<init>", 0, TargetGroupAttribute.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "proxy_protocol_v2.enabled", "value", IndyInterface.bootstrap("getProperty", "proxyProtocolV2", 0, attributes)})));
                    }
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "deregistrationDelayConnectionTermination", 0, attributes), null)) {
                        IndyInterface.bootstrap("invoke", "add", 0, targetGroupAttributes, IndyInterface.bootstrap("init", "<init>", 0, TargetGroupAttribute.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"key", "deregistration_delay.connection_termination.enabled", "value", IndyInterface.bootstrap("getProperty", "deregistrationDelayConnectionTermination", 0, attributes)})));
                    }
                }
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "updateTargetGroupAttributes", 0, LoadBalancerV2UpsertHandler.class, loadBalancing, targetGroup, targetGroupAttributes));
    }

    public static String updateTargetGroupAttributes(AmazonElasticLoadBalancing loadBalancing, TargetGroup targetGroup, List<TargetGroupAttribute> targetGroupAttributes) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, targetGroupAttributes)) == false) {
            try {
                IndyInterface.bootstrap("invoke", "modifyTargetGroupAttributes", 0, loadBalancing, IndyInterface.bootstrap("invoke", "withAttributes", 0, IndyInterface.bootstrap("invoke", "withTargetGroupArn", 0, IndyInterface.bootstrap("init", "<init>", 0, ModifyTargetGroupAttributesRequest.class), IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, targetGroup)), targetGroupAttributes));
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 8, LoadBalancerV2UpsertHandler.class), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "targetGroupName", 0, targetGroup)}, new String[]{"Modified target group ", " attributes."}));
            }
            catch (AmazonServiceException e) {
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "handleError", 0, LoadBalancerV2UpsertHandler.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "targetGroupName", 0, targetGroup), IndyInterface.bootstrap("invoke", "toString", 0, e)}, new String[]{"Failed to modify attributes for target group ", " - reason: ", "."}), e));
                return callSite;
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    /*
     * WARNING - void declaration
     */
    public static List<TargetGroup> createTargetGroups(List<UpsertAmazonLoadBalancerV2Description.TargetGroup> targetGroupsToCreate, AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer, List<String> amazonErrors, AwsConfiguration.DeployDefaults deployDefaults) {
        void var3_3;
        void var2_2;
        Reference loadBalancing2 = new Reference((Object)loadBalancing);
        Reference loadBalancer2 = new Reference((Object)var2_2);
        Reference amazonErrors2 = new Reference((Object)var3_3);
        Reference deployDefaults2 = new Reference((Object)deployDefaults);
        Reference loadBalancerName = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, (LoadBalancer)loadBalancer2.get())));
        Reference createdTargetGroups = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class)));
        public final class _createTargetGroups_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference loadBalancerName;
            private /* synthetic */ Reference loadBalancer;
            private /* synthetic */ Reference loadBalancing;
            private /* synthetic */ Reference amazonErrors;
            private /* synthetic */ Reference createdTargetGroups;
            private /* synthetic */ Reference deployDefaults;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createTargetGroups_closure1(Object _outerInstance, Object _thisObject, Reference loadBalancerName, Reference loadBalancer, Reference loadBalancing, Reference amazonErrors, Reference createdTargetGroups, Reference deployDefaults) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                this.loadBalancerName = reference6 = loadBalancerName;
                this.loadBalancer = reference5 = loadBalancer;
                this.loadBalancing = reference4 = loadBalancing;
                this.amazonErrors = reference3 = amazonErrors;
                this.createdTargetGroups = reference2 = createdTargetGroups;
                this.deployDefaults = reference = deployDefaults;
            }

            public Object doCall(Object targetGroup) {
                CallSite createdTargetGroup = null;
                try {
                    CallSite status = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get()), IndyInterface.bootstrap("getProperty", "name", 0, targetGroup), IndyInterface.bootstrap("getProperty", "port", 0, targetGroup), IndyInterface.bootstrap("getProperty", "protocol", 0, targetGroup)}, new String[]{"Target group created in ", " (", ":", ":", ")."}));
                    CallSite createTargetGroupRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, CreateTargetGroupRequest.class));
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "Lambda", 0, TargetTypeEnum.class)), IndyInterface.bootstrap("getProperty", "targetType", 0, targetGroup))) != false) {
                        IndyInterface.bootstrap("invoke", "withHealthCheckPath", 0, IndyInterface.bootstrap("invoke", "withMatcher", 0, IndyInterface.bootstrap("invoke", "withTargetType", 0, IndyInterface.bootstrap("invoke", "withUnhealthyThresholdCount", 0, IndyInterface.bootstrap("invoke", "withHealthyThresholdCount", 0, IndyInterface.bootstrap("invoke", "withHealthCheckTimeoutSeconds", 0, IndyInterface.bootstrap("invoke", "withHealthCheckIntervalSeconds", 0, IndyInterface.bootstrap("invoke", "withName", 0, createTargetGroupRequest, IndyInterface.bootstrap("getProperty", "name", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "healthCheckInterval", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "healthCheckTimeout", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "healthyThreshold", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "unhealthyThreshold", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "targetType", 0, targetGroup)), IndyInterface.bootstrap("invoke", "withHttpCode", 0, IndyInterface.bootstrap("init", "<init>", 0, Matcher.class), IndyInterface.bootstrap("getProperty", "healthCheckMatcher", 0, targetGroup))), IndyInterface.bootstrap("getProperty", "healthCheckPath", 0, targetGroup));
                        status = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get()), IndyInterface.bootstrap("getProperty", "name", 0, targetGroup)}, new String[]{"Lambda Target group created in ", " (", ")."}));
                    } else {
                        IndyInterface.bootstrap("invoke", "withTargetType", 0, IndyInterface.bootstrap("invoke", "withUnhealthyThresholdCount", 0, IndyInterface.bootstrap("invoke", "withHealthyThresholdCount", 0, IndyInterface.bootstrap("invoke", "withHealthCheckProtocol", 0, IndyInterface.bootstrap("invoke", "withHealthCheckPort", 0, IndyInterface.bootstrap("invoke", "withHealthCheckIntervalSeconds", 0, IndyInterface.bootstrap("invoke", "withVpcId", 0, IndyInterface.bootstrap("invoke", "withName", 0, IndyInterface.bootstrap("invoke", "withPort", 0, IndyInterface.bootstrap("invoke", "withProtocol", 0, createTargetGroupRequest, IndyInterface.bootstrap("getProperty", "protocol", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "port", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "name", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "vpcId", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get()))), IndyInterface.bootstrap("getProperty", "healthCheckInterval", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "healthCheckPort", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "healthCheckProtocol", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "healthyThreshold", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "unhealthyThreshold", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "targetType", 0, targetGroup));
                        if (ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "healthCheckProtocol", 0, targetGroup), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "HTTP", 0, ProtocolEnum.class), IndyInterface.bootstrap("getProperty", "HTTPS", 0, ProtocolEnum.class)}))) {
                            IndyInterface.bootstrap("invoke", "withHealthCheckPath", 0, createTargetGroupRequest, IndyInterface.bootstrap("getProperty", "healthCheckPath", 0, targetGroup));
                            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "protocol", 0, targetGroup), (Object)IndyInterface.bootstrap("getProperty", "TCP", 0, ProtocolEnum.class))) {
                                IndyInterface.bootstrap("invoke", "withUnhealthyThresholdCount", 0, createTargetGroupRequest, IndyInterface.bootstrap("invoke", "getHealthyThresholdCount", 0, createTargetGroupRequest));
                            } else {
                                IndyInterface.bootstrap("invoke", "withHealthCheckTimeoutSeconds", 0, IndyInterface.bootstrap("invoke", "withMatcher", 0, createTargetGroupRequest, IndyInterface.bootstrap("invoke", "withHttpCode", 0, IndyInterface.bootstrap("init", "<init>", 0, Matcher.class), IndyInterface.bootstrap("getProperty", "healthCheckMatcher", 0, targetGroup))), IndyInterface.bootstrap("getProperty", "healthCheckTimeout", 0, targetGroup));
                            }
                        }
                    }
                    CallSite createTargetGroupResult = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createTargetGroup", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()), createTargetGroupRequest));
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), status);
                    createdTargetGroup = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "getTargetGroups", 0, createTargetGroupResult), false));
                }
                catch (AmazonServiceException e) {
                    IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.amazonErrors.get()), IndyInterface.bootstrap("invoke", "handleError", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, targetGroup), IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get()), IndyInterface.bootstrap("invoke", "toString", 0, e)}, new String[]{"Failed to create target group ", " for ", " - reason: ", "."}), e));
                }
                if (ScriptBytecodeAdapter.compareNotEqual(createdTargetGroup, null)) {
                    IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.createdTargetGroups.get()), createdTargetGroup);
                    CallSite exceptionMessage = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createTargetGroupAttributes", 2, this, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()), IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get()), createdTargetGroup, IndyInterface.bootstrap("getProperty", "attributes", 0, targetGroup), IndyInterface.bootstrap("cast", "()", 0, this.deployDefaults.get())));
                    if (IndyInterface.bootstrap("cast", "()", 0, exceptionMessage) != false) {
                        return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.amazonErrors.get()), exceptionMessage);
                    }
                }
                return null;
            }

            @Generated
            public String getLoadBalancerName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerName.get());
            }

            @Generated
            public LoadBalancer getLoadBalancer() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get());
            }

            @Generated
            public AmazonElasticLoadBalancing getLoadBalancing() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get());
            }

            @Generated
            public List getAmazonErrors() {
                return IndyInterface.bootstrap("cast", "()", 0, this.amazonErrors.get());
            }

            @Generated
            public List getCreatedTargetGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.createdTargetGroups.get());
            }

            @Generated
            public AwsConfiguration.DeployDefaults getDeployDefaults() {
                return IndyInterface.bootstrap("cast", "()", 0, this.deployDefaults.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createTargetGroups_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, targetGroupsToCreate, new _createTargetGroups_closure1(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, loadBalancerName, loadBalancer2, loadBalancing2, amazonErrors2, createdTargetGroups, deployDefaults2));
        return (List)createdTargetGroups.get();
    }

    /*
     * WARNING - void declaration
     */
    public static List<TargetGroup> removeTargetGroups(List<TargetGroup> targetGroupsToRemove, AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer, List<String> amazonErrors) {
        void var3_3;
        void var2_2;
        Reference loadBalancing2 = new Reference((Object)loadBalancing);
        Reference loadBalancer2 = new Reference((Object)var2_2);
        Reference amazonErrors2 = new Reference((Object)var3_3);
        Reference removedTargetGroups = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class)));
        public final class _removeTargetGroups_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference loadBalancing;
            private /* synthetic */ Reference removedTargetGroups;
            private /* synthetic */ Reference loadBalancer;
            private /* synthetic */ Reference amazonErrors;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _removeTargetGroups_closure2(Object _outerInstance, Object _thisObject, Reference loadBalancing, Reference removedTargetGroups, Reference loadBalancer, Reference amazonErrors) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.loadBalancing = reference4 = loadBalancing;
                this.removedTargetGroups = reference3 = removedTargetGroups;
                this.loadBalancer = reference2 = loadBalancer;
                this.amazonErrors = reference = amazonErrors;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "deleteTargetGroup", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()), IndyInterface.bootstrap("invoke", "withTargetGroupArn", 0, IndyInterface.bootstrap("init", "<init>", 0, DeleteTargetGroupRequest.class), IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, it)));
                IndyInterface.bootstrap("invoke", "push", 0, IndyInterface.bootstrap("cast", "()", 0, this.removedTargetGroups.get()), it);
                CallSite callSite = IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get())), IndyInterface.bootstrap("getProperty", "targetGroupName", 0, it), IndyInterface.bootstrap("getProperty", "port", 0, it), IndyInterface.bootstrap("getProperty", "protocol", 0, it)}, new String[]{"Target group removed from ", " (", ":", ":", ")."}));
                try {
                    return callSite;
                }
                catch (ResourceInUseException e) {
                    CallSite callSite2 = IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.amazonErrors.get()), IndyInterface.bootstrap("invoke", "handleError", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "targetGroupName", 0, it), IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get())), IndyInterface.bootstrap("invoke", "toString", 0, e)}, new String[]{"Failed to delete target group ", " from ", " - reason: ", "."}), e));
                    return callSite2;
                }
            }

            @Generated
            public AmazonElasticLoadBalancing getLoadBalancing() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get());
            }

            @Generated
            public List getRemovedTargetGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.removedTargetGroups.get());
            }

            @Generated
            public LoadBalancer getLoadBalancer() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get());
            }

            @Generated
            public List getAmazonErrors() {
                return IndyInterface.bootstrap("cast", "()", 0, this.amazonErrors.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeTargetGroups_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, targetGroupsToRemove, new _removeTargetGroups_closure2(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, loadBalancing2, removedTargetGroups, loadBalancer2, amazonErrors2));
        return (List)removedTargetGroups.get();
    }

    /*
     * WARNING - void declaration
     */
    public static void updateTargetGroups(List<TargetGroup> targetGroupsToUpdate, List<UpsertAmazonLoadBalancerV2Description.TargetGroup> updatedTargetGroups, AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer, List<String> amazonErrors) {
        void var3_3;
        void var2_2;
        Reference updatedTargetGroups2 = new Reference(updatedTargetGroups);
        Reference loadBalancing2 = new Reference((Object)var2_2);
        Reference loadBalancer2 = new Reference((Object)var3_3);
        Reference amazonErrors2 = new Reference(amazonErrors);
        public final class _updateTargetGroups_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference updatedTargetGroups;
            private /* synthetic */ Reference loadBalancing;
            private /* synthetic */ Reference loadBalancer;
            private /* synthetic */ Reference amazonErrors;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateTargetGroups_closure3(Object _outerInstance, Object _thisObject, Reference updatedTargetGroups, Reference loadBalancing, Reference loadBalancer, Reference amazonErrors) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.updatedTargetGroups = reference4 = updatedTargetGroups;
                this.loadBalancing = reference3 = loadBalancing;
                this.loadBalancer = reference2 = loadBalancer;
                this.amazonErrors = reference = amazonErrors;
            }

            public Object doCall(Object awsTargetGroup) {
                Reference awsTargetGroup2 = new Reference(awsTargetGroup);
                public final class _closure23
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference awsTargetGroup;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure23(Object _outerInstance, Object _thisObject, Reference awsTargetGroup) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.awsTargetGroup = reference = awsTargetGroup;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)IndyInterface.bootstrap("invoke", "getTargetGroupName", 0, this.awsTargetGroup.get()));
                    }

                    @Generated
                    public Object getAwsTargetGroup() {
                        return this.awsTargetGroup.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure23.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite targetGroup = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("cast", "()", 0, this.updatedTargetGroups.get()), new _closure23((Object)this, this.getThisObject(), awsTargetGroup2)));
                CallSite modifyTargetGroupRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withUnhealthyThresholdCount", 0, IndyInterface.bootstrap("invoke", "withHealthyThresholdCount", 0, IndyInterface.bootstrap("invoke", "withHealthCheckProtocol", 0, IndyInterface.bootstrap("invoke", "withHealthCheckPort", 0, IndyInterface.bootstrap("invoke", "withHealthCheckIntervalSeconds", 0, IndyInterface.bootstrap("invoke", "withTargetGroupArn", 0, IndyInterface.bootstrap("init", "<init>", 0, ModifyTargetGroupRequest.class), IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, awsTargetGroup2.get())), IndyInterface.bootstrap("getProperty", "healthCheckInterval", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "healthCheckPort", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "healthCheckProtocol", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "healthyThreshold", 0, targetGroup)), IndyInterface.bootstrap("getProperty", "unhealthyThreshold", 0, targetGroup)));
                if (ScriptBytecodeAdapter.isCase((Object)IndyInterface.bootstrap("getProperty", "healthCheckProtocol", 0, targetGroup), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "HTTP", 0, ProtocolEnum.class), IndyInterface.bootstrap("getProperty", "HTTPS", 0, ProtocolEnum.class)}))) {
                    IndyInterface.bootstrap("invoke", "withHealthCheckPath", 0, modifyTargetGroupRequest, IndyInterface.bootstrap("getProperty", "healthCheckPath", 0, targetGroup));
                    if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "protocol", 0, targetGroup), (Object)IndyInterface.bootstrap("getProperty", "TCP", 0, ProtocolEnum.class))) {
                        IndyInterface.bootstrap("invoke", "withUnhealthyThresholdCount", 0, modifyTargetGroupRequest, IndyInterface.bootstrap("invoke", "getHealthyThresholdCount", 0, modifyTargetGroupRequest));
                    } else {
                        IndyInterface.bootstrap("invoke", "withHealthCheckTimeoutSeconds", 0, IndyInterface.bootstrap("invoke", "withMatcher", 0, modifyTargetGroupRequest, IndyInterface.bootstrap("invoke", "withHttpCode", 0, IndyInterface.bootstrap("init", "<init>", 0, Matcher.class), IndyInterface.bootstrap("getProperty", "healthCheckMatcher", 0, targetGroup))), IndyInterface.bootstrap("getProperty", "healthCheckTimeout", 0, targetGroup));
                    }
                }
                IndyInterface.bootstrap("invoke", "modifyTargetGroup", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()), modifyTargetGroupRequest);
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get())), IndyInterface.bootstrap("getProperty", "targetGroupName", 0, awsTargetGroup2.get()), IndyInterface.bootstrap("getProperty", "port", 0, awsTargetGroup2.get()), IndyInterface.bootstrap("getProperty", "protocol", 0, awsTargetGroup2.get())}, new String[]{"Target group updated in ", " (", ":", ":", ")."}));
                CallSite exceptionMessage = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "modifyTargetGroupAttributes", 2, this, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()), IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get()), awsTargetGroup2.get(), IndyInterface.bootstrap("getProperty", "attributes", 0, targetGroup), null));
                if (IndyInterface.bootstrap("cast", "()", 0, exceptionMessage) != false) {
                    return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.amazonErrors.get()), exceptionMessage);
                }
                return null;
            }

            @Generated
            public List getUpdatedTargetGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.updatedTargetGroups.get());
            }

            @Generated
            public AmazonElasticLoadBalancing getLoadBalancing() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get());
            }

            @Generated
            public LoadBalancer getLoadBalancer() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get());
            }

            @Generated
            public List getAmazonErrors() {
                return IndyInterface.bootstrap("cast", "()", 0, this.amazonErrors.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateTargetGroups_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, targetGroupsToUpdate, new _updateTargetGroups_closure3(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, updatedTargetGroups2, loadBalancing2, loadBalancer2, amazonErrors2));
    }

    public static boolean createListener(UpsertAmazonLoadBalancerV2Description.Listener listener, List<Action> defaultActions, List<Rule> rules, AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer, List<String> amazonErrors) {
        Reference loadBalancing2 = new Reference((Object)loadBalancing);
        CallSite result = null;
        try {
            result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createListener", 0, (AmazonElasticLoadBalancing)loadBalancing2.get(), IndyInterface.bootstrap("invoke", "withDefaultActions", 0, IndyInterface.bootstrap("invoke", "withSslPolicy", 0, IndyInterface.bootstrap("invoke", "withCertificates", 0, IndyInterface.bootstrap("invoke", "withProtocol", 0, IndyInterface.bootstrap("invoke", "withPort", 0, IndyInterface.bootstrap("invoke", "withLoadBalancerArn", 0, IndyInterface.bootstrap("init", "<init>", 0, CreateListenerRequest.class), IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, loadBalancer)), IndyInterface.bootstrap("getProperty", "port", 0, listener)), IndyInterface.bootstrap("getProperty", "protocol", 0, listener)), IndyInterface.bootstrap("getProperty", "certificates", 0, listener)), IndyInterface.bootstrap("getProperty", "sslPolicy", 0, listener)), defaultActions)));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 8, LoadBalancerV2UpsertHandler.class), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, loadBalancer), IndyInterface.bootstrap("getProperty", "port", 0, listener), IndyInterface.bootstrap("getProperty", "protocol", 0, listener)}, new String[]{"Listener added to ", " (", ":", ")."}));
        }
        catch (AmazonServiceException e) {
            IndyInterface.bootstrap("invoke", "leftShift", 0, amazonErrors, IndyInterface.bootstrap("invoke", "handleError", 0, LoadBalancerV2UpsertHandler.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, loadBalancer), IndyInterface.bootstrap("getProperty", "port", 0, listener), IndyInterface.bootstrap("getProperty", "protocol", 0, listener), IndyInterface.bootstrap("invoke", "toString", 0, e)}, new String[]{"Failed to add listener to ", " (", ":", ") - reason: ", "."}), e));
            boolean bl = false;
            return bl;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)result, null) && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("getProperty", "listeners", 0, result)), (Object)0)) {
            Reference listenerArn = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "listenerArn", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "listeners", 0, result), false))));
            try {
                public final class _createListener_closure4
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference loadBalancing;
                    private /* synthetic */ Reference listenerArn;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _createListener_closure4(Object _outerInstance, Object _thisObject, Reference loadBalancing, Reference listenerArn) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.loadBalancing = reference2 = loadBalancing;
                        this.listenerArn = reference = listenerArn;
                    }

                    public Object doCall(Object rule) {
                        return IndyInterface.bootstrap("invoke", "createRule", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()), IndyInterface.bootstrap("init", "<init>", 0, CreateRuleRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"listenerArn", IndyInterface.bootstrap("cast", "()", 0, this.listenerArn.get()), "conditions", IndyInterface.bootstrap("getProperty", "conditions", 0, rule), "actions", IndyInterface.bootstrap("getProperty", "actions", 0, rule), "priority", IndyInterface.bootstrap("invoke", "valueOf", 0, Integer.class, IndyInterface.bootstrap("getProperty", "priority", 0, rule))})));
                    }

                    @Generated
                    public AmazonElasticLoadBalancing getLoadBalancing() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get());
                    }

                    @Generated
                    public String getListenerArn() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.listenerArn.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _createListener_closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, rules, new _createListener_closure4(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, loadBalancing2, listenerArn));
            }
            catch (AmazonServiceException e) {
                IndyInterface.bootstrap("invoke", "leftShift", 0, amazonErrors, IndyInterface.bootstrap("invoke", "handleError", 0, LoadBalancerV2UpsertHandler.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, loadBalancer), IndyInterface.bootstrap("getProperty", "port", 0, listener), IndyInterface.bootstrap("getProperty", "protocol", 0, listener), IndyInterface.bootstrap("invoke", "toString", 0, e)}, new String[]{"Failed to add rule to listener ", " (", ":", ") reason: ", "."}), e));
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static boolean containsAllRules(List<Rule> aRules, List<Rule> bRules) {
        Reference bRules2 = new Reference(bRules);
        public final class _containsAllRules_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference bRules;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _containsAllRules_closure5(Object _outerInstance, Object _thisObject, Reference bRules) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.bRules = reference = bRules;
            }

            public Object doCall(Object aRule) {
                Reference aRule2 = new Reference(aRule);
                public final class _closure24
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference aRule;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure24(Object _outerInstance, Object _thisObject, Reference aRule) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.aRule = reference = aRule;
                    }

                    public Object doCall(Object bRule) {
                        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsAll", 0, IndyInterface.bootstrap("getProperty", "actions", 0, bRule), IndyInterface.bootstrap("getProperty", "actions", 0, this.aRule.get()))) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsAll", 0, IndyInterface.bootstrap("getProperty", "actions", 0, this.aRule.get()), IndyInterface.bootstrap("getProperty", "actions", 0, bRule))) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsAll", 0, IndyInterface.bootstrap("getProperty", "conditions", 0, bRule), IndyInterface.bootstrap("getProperty", "conditions", 0, this.aRule.get()))) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsAll", 0, IndyInterface.bootstrap("getProperty", "conditions", 0, this.aRule.get()), IndyInterface.bootstrap("getProperty", "conditions", 0, bRule))) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "priority", 0, bRule), (Object)IndyInterface.bootstrap("getProperty", "priority", 0, this.aRule.get()));
                    }

                    @Generated
                    public Object getaRule() {
                        return this.aRule.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure24.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                boolean foundMatchingRule = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "any", 0, IndyInterface.bootstrap("cast", "()", 0, this.bRules.get()), new _closure24((Object)this, this.getThisObject(), aRule2)));
                return !foundMatchingRule;
            }

            @Generated
            public List getbRules() {
                return IndyInterface.bootstrap("cast", "()", 0, this.bRules.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _containsAllRules_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "any", 0, aRules, new _containsAllRules_closure5(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, bRules2))) == false;
    }

    /*
     * WARNING - void declaration
     */
    public static void updateListener(String listenerArn, UpsertAmazonLoadBalancerV2Description.Listener listener, List<Action> defaultActions, List<Rule> existingRules, List<Rule> newRules, AmazonElasticLoadBalancing loadBalancing, List<String> amazonErrors) {
        void var1_1;
        Reference listenerArn2 = new Reference((Object)listenerArn);
        Reference listener2 = new Reference((Object)var1_1);
        Reference loadBalancing2 = new Reference((Object)loadBalancing);
        Reference amazonErrors2 = new Reference(amazonErrors);
        try {
            IndyInterface.bootstrap("invoke", "modifyListener", 0, (AmazonElasticLoadBalancing)loadBalancing2.get(), IndyInterface.bootstrap("invoke", "withDefaultActions", 0, IndyInterface.bootstrap("invoke", "withSslPolicy", 0, IndyInterface.bootstrap("invoke", "withCertificates", 0, IndyInterface.bootstrap("invoke", "withProtocol", 0, IndyInterface.bootstrap("invoke", "withListenerArn", 0, IndyInterface.bootstrap("init", "<init>", 0, ModifyListenerRequest.class), (String)listenerArn2.get()), IndyInterface.bootstrap("getProperty", "protocol", 0, (UpsertAmazonLoadBalancerV2Description.Listener)listener2.get())), IndyInterface.bootstrap("getProperty", "certificates", 0, (UpsertAmazonLoadBalancerV2Description.Listener)listener2.get())), IndyInterface.bootstrap("getProperty", "sslPolicy", 0, (UpsertAmazonLoadBalancerV2Description.Listener)listener2.get())), defaultActions));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 8, LoadBalancerV2UpsertHandler.class), BASE_PHASE, new GStringImpl(new Object[]{(String)listenerArn2.get(), IndyInterface.bootstrap("getProperty", "port", 0, (UpsertAmazonLoadBalancerV2Description.Listener)listener2.get()), IndyInterface.bootstrap("getProperty", "protocol", 0, (UpsertAmazonLoadBalancerV2Description.Listener)listener2.get())}, new String[]{"Listener ", " updated (", ":", ")."}));
        }
        catch (AmazonServiceException e) {
            IndyInterface.bootstrap("invoke", "leftShift", 0, (List)amazonErrors2.get(), IndyInterface.bootstrap("invoke", "handleError", 0, LoadBalancerV2UpsertHandler.class, new GStringImpl(new Object[]{(String)listenerArn2.get(), IndyInterface.bootstrap("getProperty", "port", 0, (UpsertAmazonLoadBalancerV2Description.Listener)listener2.get()), IndyInterface.bootstrap("getProperty", "protocol", 0, (UpsertAmazonLoadBalancerV2Description.Listener)listener2.get()), IndyInterface.bootstrap("invoke", "toString", 0, e)}, new String[]{"Failed to modify listener ", " (", ":", ") - reason: ", "."}), e));
        }
        boolean rulesSame = ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, existingRules), (Object)IndyInterface.bootstrap("invoke", "size", 0, newRules)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsAllRules", 0, LoadBalancerV2UpsertHandler.class, existingRules, newRules)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsAllRules", 0, LoadBalancerV2UpsertHandler.class, newRules, existingRules));
        if (!rulesSame) {
            public final class _updateListener_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancing;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _updateListener_closure6(Object _outerInstance, Object _thisObject, Reference loadBalancing) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.loadBalancing = reference = loadBalancing;
                }

                public Object doCall(Object rule) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "deleteRule", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()), IndyInterface.bootstrap("init", "<init>", 0, DeleteRuleRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ruleArn", IndyInterface.bootstrap("getProperty", "ruleArn", 0, rule)})));
                    try {
                        return callSite;
                    }
                    catch (AmazonServiceException ignore) {
                        Object var4_4 = null;
                        return var4_4;
                    }
                }

                @Generated
                public AmazonElasticLoadBalancing getLoadBalancing() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateListener_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, existingRules, new _updateListener_closure6(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, loadBalancing2));
            public final class _updateListener_closure7
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancing;
                private /* synthetic */ Reference listenerArn;
                private /* synthetic */ Reference amazonErrors;
                private /* synthetic */ Reference listener;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _updateListener_closure7(Object _outerInstance, Object _thisObject, Reference loadBalancing, Reference listenerArn, Reference amazonErrors, Reference listener) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    this.loadBalancing = reference4 = loadBalancing;
                    this.listenerArn = reference3 = listenerArn;
                    this.amazonErrors = reference2 = amazonErrors;
                    this.listener = reference = listener;
                }

                public Object doCall(Object rule) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "createRule", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()), IndyInterface.bootstrap("init", "<init>", 0, CreateRuleRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"listenerArn", IndyInterface.bootstrap("cast", "()", 0, this.listenerArn.get()), "conditions", IndyInterface.bootstrap("getProperty", "conditions", 0, rule), "actions", IndyInterface.bootstrap("getProperty", "actions", 0, rule), "priority", IndyInterface.bootstrap("invoke", "valueOf", 0, Integer.class, IndyInterface.bootstrap("getProperty", "priority", 0, rule))})));
                    try {
                        return callSite;
                    }
                    catch (AmazonServiceException e) {
                        CallSite callSite2 = IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.amazonErrors.get()), IndyInterface.bootstrap("invoke", "handleError", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.listenerArn.get()), IndyInterface.bootstrap("getProperty", "port", 0, IndyInterface.bootstrap("cast", "()", 0, this.listener.get())), IndyInterface.bootstrap("getProperty", "protocol", 0, IndyInterface.bootstrap("cast", "()", 0, this.listener.get())), IndyInterface.bootstrap("invoke", "toString", 0, e)}, new String[]{"Failed to add rule to listener ", " (", ":", ") reason: ", "."}), e));
                        return callSite2;
                    }
                }

                @Generated
                public AmazonElasticLoadBalancing getLoadBalancing() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get());
                }

                @Generated
                public String getListenerArn() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.listenerArn.get());
                }

                @Generated
                public List getAmazonErrors() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.amazonErrors.get());
                }

                @Generated
                public UpsertAmazonLoadBalancerV2Description.Listener getListener() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.listener.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateListener_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, newRules, new _updateListener_closure7(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, loadBalancing2, listenerArn2, amazonErrors2, listener2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void removeListeners(List<Listener> listenersToRemove, List<Listener> existingListeners, AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer) {
        void var3_3;
        void var2_2;
        Reference existingListeners2 = new Reference(existingListeners);
        Reference loadBalancing2 = new Reference((Object)var2_2);
        Reference loadBalancer2 = new Reference((Object)var3_3);
        public final class _removeListeners_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference loadBalancing;
            private /* synthetic */ Reference loadBalancer;
            private /* synthetic */ Reference existingListeners;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _removeListeners_closure8(Object _outerInstance, Object _thisObject, Reference loadBalancing, Reference loadBalancer, Reference existingListeners) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.loadBalancing = reference3 = loadBalancing;
                this.loadBalancer = reference2 = loadBalancer;
                this.existingListeners = reference = existingListeners;
            }

            public Object doCall(Object it) {
                IndyInterface.bootstrap("invoke", "deleteListener", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()), IndyInterface.bootstrap("invoke", "withListenerArn", 0, IndyInterface.bootstrap("init", "<init>", 0, DeleteListenerRequest.class), IndyInterface.bootstrap("getProperty", "listenerArn", 0, it)));
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get())), IndyInterface.bootstrap("getProperty", "port", 0, it), IndyInterface.bootstrap("getProperty", "protocol", 0, it)}, new String[]{"Listener removed from ", " (", ":", ")."}));
                CallSite callSite = IndyInterface.bootstrap("invoke", "remove", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingListeners.get()), it);
                try {
                    return callSite;
                }
                catch (ListenerNotFoundException e) {
                    CallSite callSite2 = IndyInterface.bootstrap("invoke", "handleError", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "listenerArn", 0, it), IndyInterface.bootstrap("invoke", "toString", 0, e)}, new String[]{"Failed to delete listener ", ". Listener could not be found. ", ""}), e);
                    return callSite2;
                }
            }

            @Generated
            public AmazonElasticLoadBalancing getLoadBalancing() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get());
            }

            @Generated
            public LoadBalancer getLoadBalancer() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get());
            }

            @Generated
            public List getExistingListeners() {
                return IndyInterface.bootstrap("cast", "()", 0, this.existingListeners.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeListeners_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, listenersToRemove, new _removeListeners_closure8(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, loadBalancing2, loadBalancer2, existingListeners2));
    }

    /*
     * WARNING - void declaration
     */
    public static List<Action> getAmazonActionsFromDescription(List<UpsertAmazonLoadBalancerV2Description.Action> actions, List<TargetGroup> existingTargetGroups, List<String> amazonErrors) {
        void var2_2;
        Reference existingTargetGroups2 = new Reference(existingTargetGroups);
        Reference amazonErrors2 = new Reference((Object)var2_2);
        Reference awsActions = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _getAmazonActionsFromDescription_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference existingTargetGroups;
            private /* synthetic */ Reference awsActions;
            private /* synthetic */ Reference amazonErrors;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAmazonActionsFromDescription_closure9(Object _outerInstance, Object _thisObject, Reference existingTargetGroups, Reference awsActions, Reference amazonErrors) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.existingTargetGroups = reference3 = existingTargetGroups;
                this.awsActions = reference2 = awsActions;
                this.amazonErrors = reference = amazonErrors;
            }

            public Object doCall(Object action, Object index) {
                Reference action2 = new Reference(action);
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, action2.get()), (Object)"forward")) {
                    public final class _closure25
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference action;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure25(Object _outerInstance, Object _thisObject, Reference action) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.action = reference = action;
                        }

                        public Object doCall(Object it) {
                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "targetGroupName", 0, it), (Object)IndyInterface.bootstrap("getProperty", "targetGroupName", 0, this.action.get()));
                        }

                        @Generated
                        public Object getAction() {
                            return this.action.get();
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure25.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite targetGroup = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingTargetGroups.get()), new _closure25((Object)this, this.getThisObject(), action2)));
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)targetGroup, null)) {
                        CallSite awsAction = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withOrder", 0, IndyInterface.bootstrap("invoke", "withTargetGroupArn", 0, IndyInterface.bootstrap("invoke", "withType", 0, IndyInterface.bootstrap("init", "<init>", 0, Action.class), IndyInterface.bootstrap("getProperty", "type", 0, action2.get())), IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, targetGroup)), IndyInterface.bootstrap("invoke", "plus", 0, index, true)));
                        return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.awsActions.get()), awsAction);
                    }
                    CallSite exceptionMessage = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "targetGroupName", 0, action2.get())}, new String[]{"Target group name ", " not found when trying to create action"}));
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), exceptionMessage);
                    return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("cast", "()", 0, this.amazonErrors.get()), exceptionMessage);
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, action2.get()), (Object)"authenticate-oidc")) {
                    CallSite awsAction = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withOrder", 0, IndyInterface.bootstrap("invoke", "withAuthenticateOidcConfig", 0, IndyInterface.bootstrap("invoke", "withType", 0, IndyInterface.bootstrap("init", "<init>", 0, Action.class), IndyInterface.bootstrap("getProperty", "type", 0, action2.get())), IndyInterface.bootstrap("getProperty", "authenticateOidcActionConfig", 0, action2.get())), IndyInterface.bootstrap("invoke", "plus", 0, index, true)));
                    return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.awsActions.get()), awsAction);
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, action2.get()), (Object)"redirect")) {
                    CallSite awsAction = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withOrder", 0, IndyInterface.bootstrap("invoke", "withRedirectConfig", 0, IndyInterface.bootstrap("invoke", "withType", 0, IndyInterface.bootstrap("init", "<init>", 0, Action.class), IndyInterface.bootstrap("getProperty", "type", 0, action2.get())), IndyInterface.bootstrap("getProperty", "redirectActionConfig", 0, action2.get())), IndyInterface.bootstrap("invoke", "plus", 0, index, true)));
                    return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.awsActions.get()), awsAction);
                }
                return null;
            }

            @Generated
            public Object call(Object action, Object index) {
                Reference action2 = new Reference(action);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, action2.get(), index);
            }

            @Generated
            public List getExistingTargetGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.existingTargetGroups.get());
            }

            @Generated
            public List getAwsActions() {
                return IndyInterface.bootstrap("cast", "()", 0, this.awsActions.get());
            }

            @Generated
            public List getAmazonErrors() {
                return IndyInterface.bootstrap("cast", "()", 0, this.amazonErrors.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAmazonActionsFromDescription_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "eachWithIndex", 0, actions, new _getAmazonActionsFromDescription_closure9(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, existingTargetGroups2, awsActions, amazonErrors2));
        return (List)awsActions.get();
    }

    /*
     * WARNING - void declaration
     */
    public static void updateLoadBalancer(AmazonElasticLoadBalancing loadBalancing, LoadBalancer loadBalancer, Collection<String> securityGroups, List<UpsertAmazonLoadBalancerV2Description.TargetGroup> targetGroups, List<UpsertAmazonLoadBalancerV2Description.Listener> listeners, AwsConfiguration.DeployDefaults deployDefaults, Integer idleTimeout, Boolean deletionProtection, Boolean loadBalancingCrossZone, String ipAddressType) {
        void var3_3;
        void var1_1;
        Reference loadBalancing2 = new Reference((Object)loadBalancing);
        Reference loadBalancer2 = new Reference((Object)var1_1);
        Reference targetGroups2 = new Reference((Object)var3_3);
        Reference listeners2 = new Reference(listeners);
        Reference amazonErrors = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        CallSite loadBalancerName = IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, (LoadBalancer)loadBalancer2.get());
        CallSite loadBalancerArn = IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, (LoadBalancer)loadBalancer2.get());
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getType", 0, (LoadBalancer)loadBalancer2.get()), (Object)"application")) {
            if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "vpcId", 0, (LoadBalancer)loadBalancer2.get())) && IndyInterface.bootstrap("cast", "()", 0, securityGroups) == false) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{loadBalancerName}, new String[]{"Load balancer ", " must have at least one security group"})));
            }
            if (IndyInterface.bootstrap("cast", "()", 0, securityGroups) != false) {
                IndyInterface.bootstrap("invoke", "setSecurityGroups", 0, (AmazonElasticLoadBalancing)loadBalancing2.get(), IndyInterface.bootstrap("init", "<init>", 0, SetSecurityGroupsRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancerArn", loadBalancerArn, "securityGroups", securityGroups})));
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 8, LoadBalancerV2UpsertHandler.class), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName}, new String[]{"Security groups updated on ", "."}));
            }
        }
        CallSite currentIpAddressType = IndyInterface.bootstrap("getProperty", "ipAddressType", 0, (LoadBalancer)loadBalancer2.get());
        if (DefaultTypeTransformation.booleanUnbox((Object)ipAddressType) && ScriptBytecodeAdapter.compareNotEqual((Object)ipAddressType, (Object)currentIpAddressType) && (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, (LoadBalancer)loadBalancer2.get()), (Object)"application") || ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, (LoadBalancer)loadBalancer2.get()), (Object)"network"))) {
            String newIpAddressType = ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "scheme", 0, (LoadBalancer)loadBalancer2.get()), (Object)"internal") ? "ipv4" : ipAddressType;
            IndyInterface.bootstrap("invoke", "setIpAddressType", 0, (AmazonElasticLoadBalancing)loadBalancing2.get(), IndyInterface.bootstrap("init", "<init>", 0, SetIpAddressTypeRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancerArn", loadBalancerArn, "ipAddressType", newIpAddressType})));
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 8, LoadBalancerV2UpsertHandler.class), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName}, new String[]{"IP Address type updated ", "."}));
        }
        CallSite currentAttributes = IndyInterface.bootstrap("getProperty", "attributes", 0, IndyInterface.bootstrap("invoke", "describeLoadBalancerAttributes", 0, (AmazonElasticLoadBalancing)loadBalancing2.get(), IndyInterface.bootstrap("invoke", "withLoadBalancerArn", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeLoadBalancerAttributesRequest.class), loadBalancerArn)));
        List attributes = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, (LoadBalancer)loadBalancer2.get()), (Object)"application")) {
            public final class _updateLoadBalancer_closure10
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _updateLoadBalancer_closure10(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)IndyInterface.bootstrap("getProperty", "ATTRIBUTE_IDLE_TIMEOUT", 12, this));
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite currentIdleTimeout = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getValue", 1, IndyInterface.bootstrap("invoke", "find", 0, currentAttributes, new _updateLoadBalancer_closure10(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class))));
            CallSite newIdleTimeout = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "findResult", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{idleTimeout, IndyInterface.bootstrap("getProperty", "idleTimeout", 0, IndyInterface.bootstrap("getProperty", "loadBalancing", 4, deployDefaults))}), IndyInterface.bootstrap("getProperty", "IDENTITY", 0, Closure.class))));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)currentIdleTimeout, (Object)newIdleTimeout)) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 8, LoadBalancerV2UpsertHandler.class), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, newIdleTimeout}, new String[]{"Setting idle timeout on ", " to ", "."}));
                IndyInterface.bootstrap("invoke", "add", 0, attributes, IndyInterface.bootstrap("invoke", "withValue", 0, IndyInterface.bootstrap("invoke", "withKey", 0, IndyInterface.bootstrap("init", "<init>", 0, LoadBalancerAttribute.class), ATTRIBUTE_IDLE_TIMEOUT), newIdleTimeout));
            }
        }
        public final class _updateLoadBalancer_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateLoadBalancer_closure11(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)IndyInterface.bootstrap("getProperty", "ATTRIBUTE_DELETION_PROTECTION", 12, this));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite currentDeletionProtections = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getValue", 1, IndyInterface.bootstrap("invoke", "find", 0, currentAttributes, new _updateLoadBalancer_closure11(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class))));
        CallSite newDeletionProtection = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "findResult", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{deletionProtection, IndyInterface.bootstrap("getProperty", "deletionProtection", 0, IndyInterface.bootstrap("getProperty", "loadBalancing", 4, deployDefaults))}), IndyInterface.bootstrap("getProperty", "FALSE", 0, Boolean.class), IndyInterface.bootstrap("getProperty", "IDENTITY", 0, Closure.class))));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)currentDeletionProtections, (Object)newDeletionProtection)) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 8, LoadBalancerV2UpsertHandler.class), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, newDeletionProtection}, new String[]{"Setting deletion protection on ", " to ", "."}));
            IndyInterface.bootstrap("invoke", "add", 0, attributes, IndyInterface.bootstrap("invoke", "withValue", 0, IndyInterface.bootstrap("invoke", "withKey", 0, IndyInterface.bootstrap("init", "<init>", 0, LoadBalancerAttribute.class), ATTRIBUTE_DELETION_PROTECTION), newDeletionProtection));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "type", 0, (LoadBalancer)loadBalancer2.get()), (Object)"network") && ScriptBytecodeAdapter.compareNotEqual((Object)loadBalancingCrossZone, null)) {
            public final class _updateLoadBalancer_closure12
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _updateLoadBalancer_closure12(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)IndyInterface.bootstrap("getProperty", "ATTRIBUTE_LOAD_BALANCING_CROSS_ZONE", 12, this));
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure12.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite currentLoadBalancingCrossZone = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getValue", 1, IndyInterface.bootstrap("invoke", "find", 0, currentAttributes, new _updateLoadBalancer_closure12(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class))));
            CallSite newLoadBalancingCrossZone = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "findResult", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{loadBalancingCrossZone, IndyInterface.bootstrap("getProperty", "crossZoneBalancingDefault", 0, IndyInterface.bootstrap("getProperty", "loadBalancing", 4, deployDefaults))}), IndyInterface.bootstrap("getProperty", "TRUE", 0, Boolean.class), IndyInterface.bootstrap("getProperty", "IDENTITY", 0, Closure.class))));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)currentLoadBalancingCrossZone, (Object)newLoadBalancingCrossZone)) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 8, LoadBalancerV2UpsertHandler.class), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, newLoadBalancingCrossZone}, new String[]{"Setting Cross-Zone Load Balancing on ", " to ", "."}));
                IndyInterface.bootstrap("invoke", "add", 0, attributes, IndyInterface.bootstrap("invoke", "withValue", 0, IndyInterface.bootstrap("invoke", "withKey", 0, IndyInterface.bootstrap("init", "<init>", 0, LoadBalancerAttribute.class), ATTRIBUTE_LOAD_BALANCING_CROSS_ZONE), newLoadBalancingCrossZone));
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, attributes)) == false) {
            IndyInterface.bootstrap("invoke", "modifyLoadBalancerAttributes", 0, (AmazonElasticLoadBalancing)loadBalancing2.get(), IndyInterface.bootstrap("invoke", "withAttributes", 0, IndyInterface.bootstrap("invoke", "withLoadBalancerArn", 0, IndyInterface.bootstrap("init", "<init>", 0, ModifyLoadBalancerAttributesRequest.class), loadBalancerArn), attributes));
        }
        Reference existingTargetGroups = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        existingTargetGroups.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "targetGroups", 1, IndyInterface.bootstrap("invoke", "describeTargetGroups", 0, (AmazonElasticLoadBalancing)loadBalancing2.get(), IndyInterface.bootstrap("invoke", "withLoadBalancerArn", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeTargetGroupsRequest.class), IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, (LoadBalancer)loadBalancer2.get()))))));
        Reference existingListeners = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "listeners", 1, IndyInterface.bootstrap("invoke", "describeListeners", 0, (AmazonElasticLoadBalancing)loadBalancing2.get(), IndyInterface.bootstrap("invoke", "withLoadBalancerArn", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeListenersRequest.class), loadBalancerArn)))));
        public final class _updateLoadBalancer_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference loadBalancing;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateLoadBalancer_closure13(Object _outerInstance, Object _thisObject, Reference loadBalancing) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.loadBalancing = reference = loadBalancing;
            }

            public Object doCall(Object listener) {
                CallSite rules = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "rules", 1, IndyInterface.bootstrap("invoke", "describeRules", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()), IndyInterface.bootstrap("init", "<init>", 0, DescribeRulesRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"listenerArn", IndyInterface.bootstrap("getProperty", "listenerArn", 0, listener)})))));
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{listener, rules});
            }

            @Generated
            public AmazonElasticLoadBalancing getLoadBalancing() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference existingListenerToRules = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, (List)existingListeners.get(), new _updateLoadBalancer_closure13(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, loadBalancing2))));
        public final class _updateLoadBalancer_closure14
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference targetGroups;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateLoadBalancer_closure14(Object _outerInstance, Object _thisObject, Reference targetGroups) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.targetGroups = reference = targetGroups;
            }

            public Object doCall(Object awsTargetGroup) {
                Reference awsTargetGroup2 = new Reference(awsTargetGroup);
                public final class _closure26
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference awsTargetGroup;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure26(Object _outerInstance, Object _thisObject, Reference awsTargetGroup) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.awsTargetGroup = reference = awsTargetGroup;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)IndyInterface.bootstrap("getProperty", "targetGroupName", 0, this.awsTargetGroup.get())) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "port", 0, it), (Object)IndyInterface.bootstrap("getProperty", "port", 0, this.awsTargetGroup.get())) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "protocol", 0, it)), (Object)IndyInterface.bootstrap("getProperty", "protocol", 0, this.awsTargetGroup.get()));
                    }

                    @Generated
                    public Object getAwsTargetGroup() {
                        return this.awsTargetGroup.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure26.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("cast", "()", 0, this.targetGroups.get()), new _closure26((Object)this, this.getThisObject(), awsTargetGroup2)), null);
            }

            @Generated
            public List getTargetGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.targetGroups.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite targetGroupsSplit = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, (List)existingTargetGroups.get(), new _updateLoadBalancer_closure14(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, targetGroups2)));
        CallSite targetGroupsToRemove = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, targetGroupsSplit, false));
        CallSite targetGroupsToUpdate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, targetGroupsSplit, true));
        public final class _updateLoadBalancer_closure15
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateLoadBalancer_closure15(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference targetGroupArnsToRemove = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, targetGroupsToRemove, new _updateLoadBalancer_closure15(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class))));
        public final class _updateLoadBalancer_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference existingTargetGroups;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateLoadBalancer_closure16(Object _outerInstance, Object _thisObject, Reference existingTargetGroups) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.existingTargetGroups = reference = existingTargetGroups;
            }

            public Object doCall(Object targetGroup) {
                Reference targetGroup2 = new Reference(targetGroup);
                public final class _closure27
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference targetGroup;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure27(Object _outerInstance, Object _thisObject, Reference targetGroup) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.targetGroup = reference = targetGroup;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, this.targetGroup.get()), (Object)IndyInterface.bootstrap("getProperty", "targetGroupName", 0, it)) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "port", 0, this.targetGroup.get()), (Object)IndyInterface.bootstrap("getProperty", "port", 0, it)) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "protocol", 0, this.targetGroup.get())), (Object)IndyInterface.bootstrap("getProperty", "protocol", 0, it));
                    }

                    @Generated
                    public Object getTargetGroup() {
                        return this.targetGroup.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure27.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingTargetGroups.get()), new _closure27((Object)this, this.getThisObject(), targetGroup2)), null);
            }

            @Generated
            public List getExistingTargetGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.existingTargetGroups.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite targetGroupsToCreate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, (List)targetGroups2.get(), new _updateLoadBalancer_closure16(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, existingTargetGroups)));
        public final class _updateLoadBalancer_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference existingListenerToRules;
            private /* synthetic */ Reference targetGroupArnsToRemove;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateLoadBalancer_closure17(Object _outerInstance, Object _thisObject, Reference existingListenerToRules, Reference targetGroupArnsToRemove) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.existingListenerToRules = reference2 = existingListenerToRules;
                this.targetGroupArnsToRemove = reference = targetGroupArnsToRemove;
            }

            public Object doCall(Object listener) {
                public final class _closure28
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference targetGroupArnsToRemove;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure28(Object _outerInstance, Object _thisObject, Reference targetGroupArnsToRemove) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.targetGroupArnsToRemove = reference = targetGroupArnsToRemove;
                    }

                    public Object doCall(Object rule) {
                        public final class _closure29
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference targetGroupArnsToRemove;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure29(Object _outerInstance, Object _thisObject, Reference targetGroupArnsToRemove) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.targetGroupArnsToRemove = reference = targetGroupArnsToRemove;
                            }

                            public Object doCall(Object it) {
                                return IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("cast", "()", 0, this.targetGroupArnsToRemove.get()), IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, it));
                            }

                            @Generated
                            public List getTargetGroupArnsToRemove() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.targetGroupArnsToRemove.get());
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure29.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "any", 0, IndyInterface.bootstrap("getProperty", "actions", 0, rule), new _closure29((Object)this, this.getThisObject(), this.targetGroupArnsToRemove));
                    }

                    @Generated
                    public List getTargetGroupArnsToRemove() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.targetGroupArnsToRemove.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure28.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "any", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingListenerToRules.get()), listener), new _closure28((Object)this, this.getThisObject(), this.targetGroupArnsToRemove));
            }

            @Generated
            public Map getExistingListenerToRules() {
                return IndyInterface.bootstrap("cast", "()", 0, this.existingListenerToRules.get());
            }

            @Generated
            public List getTargetGroupArnsToRemove() {
                return IndyInterface.bootstrap("cast", "()", 0, this.targetGroupArnsToRemove.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite listenersToRemove = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, (List)existingListeners.get(), new _updateLoadBalancer_closure17(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, existingListenerToRules, targetGroupArnsToRemove)));
        IndyInterface.bootstrap("invoke", "removeListeners", 0, LoadBalancerV2UpsertHandler.class, listenersToRemove, (List)existingListeners.get(), (AmazonElasticLoadBalancing)loadBalancing2.get(), (LoadBalancer)loadBalancer2.get());
        CallSite removedTargetGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "removeTargetGroups", 0, LoadBalancerV2UpsertHandler.class, targetGroupsToRemove, (AmazonElasticLoadBalancing)loadBalancing2.get(), (LoadBalancer)loadBalancer2.get(), amazonErrors.get()));
        IndyInterface.bootstrap("invoke", "removeAll", 0, (List)existingTargetGroups.get(), removedTargetGroups);
        CallSite createdTargetGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createTargetGroups", 0, LoadBalancerV2UpsertHandler.class, targetGroupsToCreate, (AmazonElasticLoadBalancing)loadBalancing2.get(), (LoadBalancer)loadBalancer2.get(), amazonErrors.get(), deployDefaults));
        IndyInterface.bootstrap("invoke", "addAll", 0, (List)existingTargetGroups.get(), createdTargetGroups);
        IndyInterface.bootstrap("invoke", "updateTargetGroups", 0, LoadBalancerV2UpsertHandler.class, targetGroupsToUpdate, (List)targetGroups2.get(), (AmazonElasticLoadBalancing)loadBalancing2.get(), (LoadBalancer)loadBalancer2.get(), amazonErrors.get());
        Reference listenerToDefaultActions = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class)));
        Reference listenerToRules = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class)));
        public final class _updateLoadBalancer_closure18
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference existingTargetGroups;
            private /* synthetic */ Reference amazonErrors;
            private /* synthetic */ Reference listenerToDefaultActions;
            private /* synthetic */ Reference listenerToRules;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateLoadBalancer_closure18(Object _outerInstance, Object _thisObject, Reference existingTargetGroups, Reference amazonErrors, Reference listenerToDefaultActions, Reference listenerToRules) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.existingTargetGroups = reference4 = existingTargetGroups;
                this.amazonErrors = reference3 = amazonErrors;
                this.listenerToDefaultActions = reference2 = listenerToDefaultActions;
                this.listenerToRules = reference = listenerToRules;
            }

            public Object doCall(Object listener) {
                CallSite defaultActions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAmazonActionsFromDescription", 2, this, IndyInterface.bootstrap("getProperty", "defaultActions", 0, listener), IndyInterface.bootstrap("cast", "()", 0, this.existingTargetGroups.get()), this.amazonErrors.get()));
                IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("cast", "()", 0, this.listenerToDefaultActions.get()), listener, defaultActions);
                Reference rules = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                public final class _closure30
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference existingTargetGroups;
                    private /* synthetic */ Reference amazonErrors;
                    private /* synthetic */ Reference rules;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure30(Object _outerInstance, Object _thisObject, Reference existingTargetGroups, Reference amazonErrors, Reference rules) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.existingTargetGroups = reference3 = existingTargetGroups;
                        this.amazonErrors = reference2 = amazonErrors;
                        this.rules = reference = rules;
                    }

                    public Object doCall(Object rule) {
                        CallSite actions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAmazonActionsFromDescription", 2, this, IndyInterface.bootstrap("getProperty", "actions", 0, rule), IndyInterface.bootstrap("cast", "()", 0, this.existingTargetGroups.get()), this.amazonErrors.get()));
                        public final class _closure31
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure31(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object condition) {
                                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "field", 0, condition), (Object)"http-request-method")) {
                                    CallSite httpRequestMethodConditionConfig = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withValues", 0, IndyInterface.bootstrap("init", "<init>", 0, HttpRequestMethodConditionConfig.class), IndyInterface.bootstrap("getProperty", "values", 0, condition)));
                                    return IndyInterface.bootstrap("invoke", "withHttpRequestMethodConfig", 0, IndyInterface.bootstrap("invoke", "withField", 0, IndyInterface.bootstrap("init", "<init>", 0, RuleCondition.class), IndyInterface.bootstrap("getProperty", "field", 0, condition)), httpRequestMethodConditionConfig);
                                }
                                return IndyInterface.bootstrap("invoke", "withValues", 0, IndyInterface.bootstrap("invoke", "withField", 0, IndyInterface.bootstrap("init", "<init>", 0, RuleCondition.class), IndyInterface.bootstrap("getProperty", "field", 0, condition)), IndyInterface.bootstrap("getProperty", "values", 0, condition));
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure31.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        CallSite conditions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "conditions", 0, rule), new _closure31((Object)this, this.getThisObject())));
                        return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.rules.get()), IndyInterface.bootstrap("invoke", "withPriority", 0, IndyInterface.bootstrap("invoke", "withConditions", 0, IndyInterface.bootstrap("invoke", "withActions", 0, IndyInterface.bootstrap("init", "<init>", 0, Rule.class), actions), conditions), IndyInterface.bootstrap("getProperty", "priority", 0, rule)));
                    }

                    @Generated
                    public List getExistingTargetGroups() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.existingTargetGroups.get());
                    }

                    @Generated
                    public Object getAmazonErrors() {
                        return this.amazonErrors.get();
                    }

                    @Generated
                    public List getRules() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.rules.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure30.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "rules", 0, listener), new _closure30((Object)this, this.getThisObject(), this.existingTargetGroups, this.amazonErrors, rules));
                return IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("cast", "()", 0, this.listenerToRules.get()), listener, (List)rules.get());
            }

            @Generated
            public List getExistingTargetGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.existingTargetGroups.get());
            }

            @Generated
            public Object getAmazonErrors() {
                return this.amazonErrors.get();
            }

            @Generated
            public Map getListenerToDefaultActions() {
                return IndyInterface.bootstrap("cast", "()", 0, this.listenerToDefaultActions.get());
            }

            @Generated
            public Map getListenerToRules() {
                return IndyInterface.bootstrap("cast", "()", 0, this.listenerToRules.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, (List)listeners2.get(), new _updateLoadBalancer_closure18(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, existingTargetGroups, amazonErrors, listenerToDefaultActions, listenerToRules));
        public final class _updateLoadBalancer_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference listeners;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateLoadBalancer_closure19(Object _outerInstance, Object _thisObject, Reference listeners) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.listeners = reference = listeners;
            }

            public Object doCall(Object awsListener) {
                Reference awsListener2 = new Reference(awsListener);
                public final class _closure32
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference awsListener;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure32(Object _outerInstance, Object _thisObject, Reference awsListener) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.awsListener = reference = awsListener;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "port", 0, it), (Object)IndyInterface.bootstrap("getProperty", "port", 0, this.awsListener.get()));
                    }

                    @Generated
                    public Object getAwsListener() {
                        return this.awsListener.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure32.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("cast", "()", 0, this.listeners.get()), new _closure32((Object)this, this.getThisObject(), awsListener2)), null);
            }

            @Generated
            public List getListeners() {
                return IndyInterface.bootstrap("cast", "()", 0, this.listeners.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite listenersSplit = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "split", 0, (List)existingListeners.get(), new _updateLoadBalancer_closure19(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, listeners2)));
        listenersToRemove = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, listenersSplit, false));
        CallSite listenersToUpdate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, listenersSplit, true));
        public final class _updateLoadBalancer_closure20
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference existingListeners;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateLoadBalancer_closure20(Object _outerInstance, Object _thisObject, Reference existingListeners) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.existingListeners = reference = existingListeners;
            }

            public Object doCall(Object listener) {
                Reference listener2 = new Reference(listener);
                public final class _closure33
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference listener;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure33(Object _outerInstance, Object _thisObject, Reference listener) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.listener = reference = listener;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "port", 0, it), (Object)IndyInterface.bootstrap("getProperty", "port", 0, this.listener.get()));
                    }

                    @Generated
                    public Object getListener() {
                        return this.listener.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure33.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingListeners.get()), new _closure33((Object)this, this.getThisObject(), listener2)), null);
            }

            @Generated
            public List getExistingListeners() {
                return IndyInterface.bootstrap("cast", "()", 0, this.existingListeners.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite listenersToCreate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, (List)listeners2.get(), new _updateLoadBalancer_closure20(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, existingListeners)));
        public final class _updateLoadBalancer_closure21
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference listenerToDefaultActions;
            private /* synthetic */ Reference listenerToRules;
            private /* synthetic */ Reference loadBalancing;
            private /* synthetic */ Reference loadBalancer;
            private /* synthetic */ Reference amazonErrors;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateLoadBalancer_closure21(Object _outerInstance, Object _thisObject, Reference listenerToDefaultActions, Reference listenerToRules, Reference loadBalancing, Reference loadBalancer, Reference amazonErrors) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                this.listenerToDefaultActions = reference5 = listenerToDefaultActions;
                this.listenerToRules = reference4 = listenerToRules;
                this.loadBalancing = reference3 = loadBalancing;
                this.loadBalancer = reference2 = loadBalancer;
                this.amazonErrors = reference = amazonErrors;
            }

            public Object doCall(UpsertAmazonLoadBalancerV2Description.Listener listener) {
                return IndyInterface.bootstrap("invoke", "createListener", 2, this, listener, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.listenerToDefaultActions.get()), listener), IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.listenerToRules.get()), listener), IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()), IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get()), this.amazonErrors.get());
            }

            @Generated
            public Object call(UpsertAmazonLoadBalancerV2Description.Listener listener) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, listener);
            }

            @Generated
            public Map getListenerToDefaultActions() {
                return IndyInterface.bootstrap("cast", "()", 0, this.listenerToDefaultActions.get());
            }

            @Generated
            public Map getListenerToRules() {
                return IndyInterface.bootstrap("cast", "()", 0, this.listenerToRules.get());
            }

            @Generated
            public AmazonElasticLoadBalancing getLoadBalancing() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get());
            }

            @Generated
            public LoadBalancer getLoadBalancer() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get());
            }

            @Generated
            public Object getAmazonErrors() {
                return this.amazonErrors.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, listenersToCreate, new _updateLoadBalancer_closure21(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, listenerToDefaultActions, listenerToRules, loadBalancing2, loadBalancer2, amazonErrors));
        public final class _updateLoadBalancer_closure22
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference listeners;
            private /* synthetic */ Reference listenerToDefaultActions;
            private /* synthetic */ Reference existingListenerToRules;
            private /* synthetic */ Reference listenerToRules;
            private /* synthetic */ Reference loadBalancing;
            private /* synthetic */ Reference amazonErrors;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateLoadBalancer_closure22(Object _outerInstance, Object _thisObject, Reference listeners, Reference listenerToDefaultActions, Reference existingListenerToRules, Reference listenerToRules, Reference loadBalancing, Reference amazonErrors) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                this.listeners = reference6 = listeners;
                this.listenerToDefaultActions = reference5 = listenerToDefaultActions;
                this.existingListenerToRules = reference4 = existingListenerToRules;
                this.listenerToRules = reference3 = listenerToRules;
                this.loadBalancing = reference2 = loadBalancing;
                this.amazonErrors = reference = amazonErrors;
            }

            public Object doCall(Object listener) {
                Reference listener2 = new Reference(listener);
                public final class _closure34
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference listener;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure34(Object _outerInstance, Object _thisObject, Reference listener) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.listener = reference = listener;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "port", 0, it), (Object)IndyInterface.bootstrap("getProperty", "port", 0, this.listener.get()));
                    }

                    @Generated
                    public Object getListener() {
                        return this.listener.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure34.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite updatedListener = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("cast", "()", 0, this.listeners.get()), new _closure34((Object)this, this.getThisObject(), listener2)));
                public final class _closure35
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure35(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "isDefault", 0, it)) == false;
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure35.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "updateListener", 2, this, IndyInterface.bootstrap("getProperty", "listenerArn", 0, listener2.get()), updatedListener, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.listenerToDefaultActions.get()), updatedListener), IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.existingListenerToRules.get()), listener2.get()), new _closure35((Object)this, this.getThisObject())), IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.listenerToRules.get()), updatedListener), IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()), this.amazonErrors.get());
            }

            @Generated
            public List getListeners() {
                return IndyInterface.bootstrap("cast", "()", 0, this.listeners.get());
            }

            @Generated
            public Map getListenerToDefaultActions() {
                return IndyInterface.bootstrap("cast", "()", 0, this.listenerToDefaultActions.get());
            }

            @Generated
            public Map getExistingListenerToRules() {
                return IndyInterface.bootstrap("cast", "()", 0, this.existingListenerToRules.get());
            }

            @Generated
            public Map getListenerToRules() {
                return IndyInterface.bootstrap("cast", "()", 0, this.listenerToRules.get());
            }

            @Generated
            public AmazonElasticLoadBalancing getLoadBalancing() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get());
            }

            @Generated
            public Object getAmazonErrors() {
                return this.amazonErrors.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateLoadBalancer_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, listenersToUpdate, new _updateLoadBalancer_closure22(LoadBalancerV2UpsertHandler.class, LoadBalancerV2UpsertHandler.class, listeners2, listenerToDefaultActions, existingListenerToRules, listenerToRules, loadBalancing2, amazonErrors));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, amazonErrors.get()), (Object)0)) {
            IndyInterface.bootstrap("invoke", "removeListeners", 0, LoadBalancerV2UpsertHandler.class, listenersToRemove, (List)existingListeners.get(), (AmazonElasticLoadBalancing)loadBalancing2.get(), (LoadBalancer)loadBalancer2.get());
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)amazonErrors.get()) && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, amazonErrors.get()), (Object)0)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AtomicOperationException.class, "Failed to apply all load balancer updates", amazonErrors.get()));
        }
    }

    public static LoadBalancer createLoadBalancer(AmazonElasticLoadBalancing loadBalancing, String loadBalancerName, boolean isInternal, Collection<String> subnetIds, Collection<String> securityGroups, List<UpsertAmazonLoadBalancerV2Description.TargetGroup> targetGroups, List<UpsertAmazonLoadBalancerV2Description.Listener> listeners, AwsConfiguration.DeployDefaults deployDefaults, String type, Integer idleTimeout, boolean deletionProtection, boolean loadBalancingCrossZone, String ipAddressType) {
        CallSite request = IndyInterface.bootstrap("invoke", "withName", 0, IndyInterface.bootstrap("init", "<init>", 0, CreateLoadBalancerRequest.class), loadBalancerName);
        if (DefaultTypeTransformation.booleanUnbox((Object)ipAddressType) && (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)"application") || ScriptBytecodeAdapter.compareEqual((Object)type, (Object)"network"))) {
            String addressType = isInternal ? "ipv4" : ipAddressType;
            IndyInterface.bootstrap("invoke", "withIpAddressType", 0, request, addressType);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, subnetIds) != false) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 8, LoadBalancerV2UpsertHandler.class), BASE_PHASE, new GStringImpl(new Object[]{subnetIds}, new String[]{"Subnets: [", "]"}));
            IndyInterface.bootstrap("invoke", "withSubnets", 0, request, subnetIds);
            if (isInternal) {
                String string = "internal";
                ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)request, (String)"scheme");
            }
            if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)"application")) {
                IndyInterface.bootstrap("invoke", "withSecurityGroups", 0, request, securityGroups);
            }
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)type, (Object)"network")) {
            IndyInterface.bootstrap("invoke", "setType", 0, request, IndyInterface.bootstrap("getProperty", "Network", 0, LoadBalancerTypeEnum.class));
        } else {
            IndyInterface.bootstrap("invoke", "setType", 0, request, IndyInterface.bootstrap("getProperty", "Application", 0, LoadBalancerTypeEnum.class));
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 8, LoadBalancerV2UpsertHandler.class), BASE_PHASE, "Creating load balancer.");
        CallSite result = null;
        try {
            result = IndyInterface.bootstrap("invoke", "createLoadBalancer", 0, loadBalancing, request);
        }
        catch (AmazonServiceException e) {
            IndyInterface.bootstrap("invoke", "error", 0, log, "Failed to create load balancer", e);
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AtomicOperationException.class, "Failed to create load balancer.", ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "toString", 0, e)})));
        }
        CallSite createdLoadBalancer = null;
        CallSite loadBalancers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getLoadBalancers", 0, result));
        if (ScriptBytecodeAdapter.compareNotEqual((Object)loadBalancers, null) && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, loadBalancers), (Object)0)) {
            createdLoadBalancer = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, loadBalancers, false));
            IndyInterface.bootstrap("invoke", "updateLoadBalancer", 0, LoadBalancerV2UpsertHandler.class, loadBalancing, createdLoadBalancer, securityGroups, targetGroups, listeners, deployDefaults, idleTimeout, deletionProtection, loadBalancingCrossZone, ipAddressType);
        }
        return createdLoadBalancer;
    }

    private static String handleError(String message, Exception e) {
        IndyInterface.bootstrap("invoke", "error", 0, log, message, e);
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 8, LoadBalancerV2UpsertHandler.class), BASE_PHASE, message);
        return message;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != LoadBalancerV2UpsertHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        boolean bl = false;
        MULTI_VALUE_HEADERS_ENABLED = bl;
        boolean bl2 = false;
        CONNECTION_TERMINATION = bl2;
        boolean bl3 = false;
        PROXY_PROTOCOL_V2 = bl3;
        boolean bl4 = false;
        STICKINESS_ENABLED = bl4;
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.deploy.handlers.LoadBalancerV2UpsertHandler");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }
}

