/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.Instance;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.InstanceLoadBalancerRegistrationDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.RegistrationAction;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.LoadBalancerLookupHelper;
import com.netflix.spinnaker.clouddriver.aws.services.RegionScopedProviderFactory;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractInstanceLoadBalancerRegistrationAtomicOperation
implements AtomicOperation<Void>,
GroovyObject {
    private InstanceLoadBalancerRegistrationDescription description;
    @Autowired
    private RegionScopedProviderFactory regionScopedProviderFactory;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AbstractInstanceLoadBalancerRegistrationAtomicOperation(InstanceLoadBalancerRegistrationDescription description) {
        InstanceLoadBalancerRegistrationDescription instanceLoadBalancerRegistrationDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = instanceLoadBalancerRegistrationDescription = description;
    }

    public abstract RegistrationAction getRegistrationAction();

    public abstract String getPhaseName();

    public Void operate(List priorOutputs) {
        CallSite performingAction = IndyInterface.bootstrap("invoke", "actionVerb", 0, IndyInterface.bootstrap("invoke", "getRegistrationAction", 2, this));
        CallSite task = IndyInterface.bootstrap("invoke", "getTask", 2, this);
        CallSite asg = null;
        IndyInterface.bootstrap("invoke", "updateStatus", 0, task, IndyInterface.bootstrap("getProperty", "phaseName", 12, this), new GStringImpl(new Object[]{performingAction, IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("getProperty", "instanceIds", 4, this.description), ", ")}, new String[]{"Initializing ", " of Instances (", ") in Load Balancer Operation..."}));
        CallSite regionScopedProvider = IndyInterface.bootstrap("invoke", "forRegion", 0, this.regionScopedProviderFactory, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), IndyInterface.bootstrap("getProperty", "region", 4, this.description));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "asgName", 4, this.description)) != false) {
            CallSite asgService = IndyInterface.bootstrap("getProperty", "asgService", 0, regionScopedProvider);
            asg = IndyInterface.bootstrap("invoke", "getAutoScalingGroup", 0, asgService, IndyInterface.bootstrap("getProperty", "asgName", 4, this.description));
        }
        CallSite instances = IndyInterface.bootstrap("invoke", "getInstanceIds", 2, this, asg);
        CallSite loadBalancers = IndyInterface.bootstrap("cast", "()", 0, asg) != false ? IndyInterface.bootstrap("invoke", "getLoadBalancersFromAsg", 0, IndyInterface.bootstrap("invoke", "lookupHelper", 2, this), asg) : IndyInterface.bootstrap("invoke", "getLoadBalancersByName", 0, IndyInterface.bootstrap("invoke", "lookupHelper", 2, this), regionScopedProvider, IndyInterface.bootstrap("getProperty", "loadBalancerNames", 4, this.description));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "unknownLoadBalancers", 0, loadBalancers)) != false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "unknownLoadBalancers", 0, loadBalancers)}, new String[]{"loadbalancers not found: ", ""})));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "classicLoadBalancers", 0, loadBalancers)) == false) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, task, IndyInterface.bootstrap("getProperty", "phaseName", 12, this), new GStringImpl(new Object[]{performingAction, IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("getProperty", "instanceIds", 4, this.description), ", ")}, new String[]{"", " instances not required for Instances ", ", no load balancers are found"}));
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        IndyInterface.bootstrap("invoke", "operateOnInstances", 2, this, regionScopedProvider, loadBalancers, instances, performingAction);
        IndyInterface.bootstrap("invoke", "updateStatus", 0, task, IndyInterface.bootstrap("getProperty", "phaseName", 12, this), new GStringImpl(new Object[]{performingAction}, new String[]{"", " completed."}));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private Collection<String> getInstanceIds(AutoScalingGroup asg) {
        if (IndyInterface.bootstrap("cast", "()", 0, asg) != false) {
            Reference asgInstanceIds = new Reference((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.getPropertySpreadSafe(AbstractInstanceLoadBalancerRegistrationAtomicOperation.class, (Object)IndyInterface.bootstrap("getProperty", "instances", 0, asg), (String)"instanceId"), Set.class))));
            public final class _getInstanceIds_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference asgInstanceIds;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getInstanceIds_closure1(Object _outerInstance, Object _thisObject, Reference asgInstanceIds) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.asgInstanceIds = reference = asgInstanceIds;
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("invoke", "contains", 0, this.asgInstanceIds.get(), it);
                }

                @Generated
                public Object getAsgInstanceIds() {
                    return this.asgInstanceIds.get();
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getInstanceIds_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("getProperty", "instanceIds", 4, this.description), new _getInstanceIds_closure1(this, this, asgInstanceIds)));
        }
        CallSite callSite = IndyInterface.bootstrap("getProperty", "instanceIds", 4, this.description);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
    }

    private void operateOnInstances(RegionScopedProviderFactory.RegionScopedProvider regionScopedProvider, LoadBalancerLookupHelper.LoadBalancerLookupResult loadBalancers, Collection<String> instanceIds, String performingAction) {
        Reference instanceIds2 = new Reference(instanceIds);
        Reference performingAction2 = new Reference((Object)performingAction);
        Reference task = new Reference((Object)IndyInterface.bootstrap("invoke", "getTask", 2, this));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "classicLoadBalancers", 4, loadBalancers)) != false) {
            public final class _operateOnInstances_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operateOnInstances_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("init", "<init>", 0, Instance.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instanceId", it}));
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operateOnInstances_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Reference instances = new Reference((Object)IndyInterface.bootstrap("invoke", "collect", 0, (Collection)instanceIds2.get(), new _operateOnInstances_closure2(this, this)));
            Reference amazonELB = new Reference((Object)IndyInterface.bootstrap("invoke", "getAmazonElasticLoadBalancing", 0, regionScopedProvider));
            public final class _operateOnInstances_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference task;
                private /* synthetic */ Reference performingAction;
                private /* synthetic */ Reference instanceIds;
                private /* synthetic */ Reference amazonELB;
                private /* synthetic */ Reference instances;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _operateOnInstances_closure3(Object _outerInstance, Object _thisObject, Reference task, Reference performingAction, Reference instanceIds, Reference amazonELB, Reference instances) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    this.task = reference5 = task;
                    this.performingAction = reference4 = performingAction;
                    this.instanceIds = reference3 = instanceIds;
                    this.amazonELB = reference2 = amazonELB;
                    this.instances = reference = instances;
                }

                public Object doCall(Object it) {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, this.task.get(), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.performingAction.get()), IndyInterface.bootstrap("cast", "()", 0, this.instanceIds.get()), it}, new String[]{"", " instances (", ") in ", "."}));
                    if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getRegistrationAction", 2, this), (Object)IndyInterface.bootstrap("getProperty", "REGISTER", 0, RegistrationAction.class))) {
                        IndyInterface.bootstrap("invoke", "registerInstancesWithLoadBalancer", 0, this.amazonELB.get(), IndyInterface.bootstrap("init", "<init>", 0, RegisterInstancesWithLoadBalancerRequest.class, it, this.instances.get()));
                    } else {
                        IndyInterface.bootstrap("invoke", "deregisterInstancesFromLoadBalancer", 0, this.amazonELB.get(), IndyInterface.bootstrap("init", "<init>", 0, DeregisterInstancesFromLoadBalancerRequest.class, it, this.instances.get()));
                    }
                    return IndyInterface.bootstrap("invoke", "updateStatus", 0, this.task.get(), IndyInterface.bootstrap("getProperty", "phaseName", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("cast", "()", 0, this.performingAction.get())), IndyInterface.bootstrap("invoke", "join", 0, ScriptBytecodeAdapter.getPropertySpreadSafe(_operateOnInstances_closure3.class, (Object)this.instances.get(), (String)"instanceId"), ", "), it}, new String[]{"Finished ", " instances (", ") in ", "."}));
                }

                @Generated
                public Object getTask() {
                    return this.task.get();
                }

                @Generated
                public String getPerformingAction() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.performingAction.get());
                }

                @Generated
                public Collection getInstanceIds() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.instanceIds.get());
                }

                @Generated
                public Object getAmazonELB() {
                    return this.amazonELB.get();
                }

                @Generated
                public Object getInstances() {
                    return this.instances.get();
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _operateOnInstances_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "classicLoadBalancers", 4, loadBalancers), new _operateOnInstances_closure3(this, this, task, performingAction2, instanceIds2, amazonELB, instances));
        }
    }

    @VisibleForTesting
    LoadBalancerLookupHelper lookupHelper() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, LoadBalancerLookupHelper.class));
    }

    private Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractInstanceLoadBalancerRegistrationAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public InstanceLoadBalancerRegistrationDescription getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(InstanceLoadBalancerRegistrationDescription instanceLoadBalancerRegistrationDescription) {
        this.description = instanceLoadBalancerRegistrationDescription;
    }

    @Generated
    public RegionScopedProviderFactory getRegionScopedProviderFactory() {
        return this.regionScopedProviderFactory;
    }

    @Generated
    public void setRegionScopedProviderFactory(RegionScopedProviderFactory regionScopedProviderFactory) {
        this.regionScopedProviderFactory = regionScopedProviderFactory;
    }
}

