/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DeleteLaunchTemplateRequest;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.DeleteAmazonLaunchTemplateDescription;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.core.RetrySupport;
import java.time.Duration;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteLaunchTemplateAtomicOperation
implements AtomicOperation<Void> {
    private static final String BASE_PHASE = "DELETE_LAUNCH_TEMPLATE";
    private final DeleteAmazonLaunchTemplateDescription description;
    @Autowired
    private AmazonClientProvider amazonClientProvider;
    @Autowired
    private RetrySupport retrySupport;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public DeleteLaunchTemplateAtomicOperation(DeleteAmazonLaunchTemplateDescription description) {
        this.description = description;
    }

    public Void operate(List priorOutputs) {
        DeleteLaunchTemplateAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Initializing Delete Launch Template operation for %s", this.description));
        AmazonEC2 ec2 = this.amazonClientProvider.getAmazonEC2(this.description.getCredentials(), this.description.getRegion());
        this.retrySupport.retry(() -> this.deleteLaunchTemplate(this.description.getLaunchTemplateId(), ec2), 3, Duration.ofSeconds(3L), false);
        DeleteLaunchTemplateAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Launch Template %s in %s", this.description.getLaunchTemplateId(), this.description.getRegion()));
        return null;
    }

    private Boolean deleteLaunchTemplate(String launchTemplateId, AmazonEC2 ec2) {
        try {
            ec2.deleteLaunchTemplate(new DeleteLaunchTemplateRequest().withLaunchTemplateId(launchTemplateId));
            return true;
        }
        catch (Exception e) {
            if (e.getMessage().toLowerCase().contains("does not exist")) {
                return true;
            }
            throw e;
        }
    }
}

