/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.shield.model.CreateProtectionRequest;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertAmazonLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertAmazonLoadBalancerV2Description;
import com.netflix.spinnaker.clouddriver.aws.deploy.handlers.LoadBalancerV2UpsertHandler;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.IngressLoadBalancerBuilder;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.UpsertAmazonLoadBalancerV2Result;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.securitygroup.SecurityGroupLookupFactory;
import com.netflix.spinnaker.clouddriver.aws.model.SubnetTarget;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.services.RegionScopedProviderFactory;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.config.AwsConfiguration;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UpsertAmazonLoadBalancerV2AtomicOperation
implements AtomicOperation<UpsertAmazonLoadBalancerV2Result>,
GroovyObject {
    private static final String BASE_PHASE = "CREATE_ELB_V2";
    @Autowired
    private AmazonClientProvider amazonClientProvider;
    @Autowired
    private RegionScopedProviderFactory regionScopedProviderFactory;
    @Autowired
    private SecurityGroupLookupFactory securityGroupLookupFactory;
    @Autowired
    private IngressLoadBalancerBuilder ingressLoadBalancerBuilder;
    @Autowired
    private AwsConfiguration.DeployDefaults deployDefaults;
    private final UpsertAmazonLoadBalancerV2Description description;
    private ObjectMapper objectMapper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public UpsertAmazonLoadBalancerV2AtomicOperation(UpsertAmazonLoadBalancerDescription description) {
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, ObjectMapper.class);
        this.objectMapper = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, description);
        this.description = callSite2;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public UpsertAmazonLoadBalancerV2Result operate(List priorOutputs) {
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Initializing load balancer creation...");
        CallSite operationResult = IndyInterface.bootstrap("init", "<init>", 0, UpsertAmazonLoadBalancerV2Result.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancers", ScriptBytecodeAdapter.createMap((Object[])new Object[0])}));
        CallSite entry = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("getProperty", "availabilityZones", 4, this.description)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                entry = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                CallSite region = IndyInterface.bootstrap("getProperty", "key", 0, entry);
                CallSite availabilityZones = IndyInterface.bootstrap("getProperty", "value", 0, entry);
                CallSite regionScopedProvider = IndyInterface.bootstrap("invoke", "forRegion", 0, this.regionScopedProviderFactory, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), region);
                CallSite callSite2 = IndyInterface.bootstrap("getProperty", "name", 4, this.description);
                CallSite loadBalancerName = IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : IndyInterface.bootstrap("invoke", "toString", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "clusterName", 4, this.description)}, new String[]{"", "-frontend"}));
                boolean isInternal = DefaultTypeTransformation.booleanUnbox((Object)(ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getIsInternal", 0, this.description), null) ? IndyInterface.bootstrap("invoke", "getIsInternal", 0, this.description) : IndyInterface.bootstrap("invoke", "contains", 1, IndyInterface.bootstrap("getProperty", "subnetType", 4, this.description), "internal")));
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{region, availabilityZones, loadBalancerName}, new String[]{"Beginning deployment to ", " in ", " for ", ""}));
                CallSite loadBalancing = IndyInterface.bootstrap("invoke", "getAmazonElasticLoadBalancingV2", 0, this.amazonClientProvider, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), region, true);
                public final class _operate_closure1
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _operate_closure1(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("getProperty", "value", 0, it);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite securityGroups = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "getSecurityGroupIds", 0, IndyInterface.bootstrap("getProperty", "securityGroupService", 0, regionScopedProvider), IndyInterface.bootstrap("getProperty", "securityGroups", 4, this.description), IndyInterface.bootstrap("getProperty", "vpcId", 4, this.description)), new _operate_closure1(this, this));
                CallSite loadBalancer = null;
                try {
                    CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "describeLoadBalancers", 0, loadBalancing, IndyInterface.bootstrap("init", "<init>", 0, DescribeLoadBalancersRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"names", ScriptBytecodeAdapter.createList((Object[])new Object[]{loadBalancerName})}))));
                    loadBalancer = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("getProperty", "loadBalancers", 0, result)), (Object)0) ? IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "loadBalancers", 0, result), false) : null);
                }
                catch (AmazonServiceException ignore) {
                }
                CallSite dnsName = null;
                if (ScriptBytecodeAdapter.compareEqual(loadBalancer, null)) {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, IndyInterface.bootstrap("getProperty", "loadBalancerType", 4, this.description), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), region}, new String[]{"Creating ", " of type ", " in ", ":", "..."}));
                    Object subnetIds = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "subnetType", 4, this.description)) != false) {
                        subnetIds = IndyInterface.bootstrap("invoke", "getSubnetIdsForZones", 0, IndyInterface.bootstrap("getProperty", "subnetAnalyzer", 0, regionScopedProvider), availabilityZones, IndyInterface.bootstrap("getProperty", "subnetType", 4, this.description), IndyInterface.bootstrap("getProperty", "ELB", 0, SubnetTarget.class), true);
                    }
                    IndyInterface.bootstrap("invoke", "handleSecurityGroupIngress", 2, this, region, securityGroups);
                    loadBalancer = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "createLoadBalancer", 0, LoadBalancerV2UpsertHandler.class, loadBalancing, loadBalancerName, isInternal, subnetIds, securityGroups, IndyInterface.bootstrap("getProperty", "targetGroups", 4, this.description), IndyInterface.bootstrap("getProperty", "listeners", 4, this.description), this.deployDefaults, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "loadBalancerType", 4, this.description)), IndyInterface.bootstrap("getProperty", "idleTimeout", 4, this.description), IndyInterface.bootstrap("getProperty", "deletionProtection", 4, this.description), !(IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "loadBalancingCrossZone", 4, this.description)) == false), IndyInterface.bootstrap("getProperty", "ipAddressType", 4, this.description)));
                    dnsName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "DNSName", 0, loadBalancer));
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "isInternal", 4, this.description)) == false && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "shieldEnabled", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description))) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "shieldProtectionEnabled", 4, this.description))) {
                        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"Configuring AWS Shield for ", " in ", "..."}));
                        try {
                            CallSite shieldClient = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAmazonShield", 0, this.amazonClientProvider, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), region));
                            IndyInterface.bootstrap("invoke", "createProtection", 0, shieldClient, IndyInterface.bootstrap("invoke", "withResourceArn", 0, IndyInterface.bootstrap("invoke", "withName", 0, IndyInterface.bootstrap("init", "<init>", 0, CreateProtectionRequest.class), loadBalancerName), IndyInterface.bootstrap("invoke", "getLoadBalancerArn", 0, loadBalancer)));
                            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"AWS Shield configured for ", " in ", "."}));
                        }
                        catch (Exception e) {
                            CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isErrorEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "error", 0, log, new GStringImpl(new Object[]{loadBalancerName}, new String[]{"Failed to enable AWS Shield protection on ", ""}), e) : null;
                            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"Failed to configure AWS Shield for ", " in ", "."}));
                        }
                    }
                } else {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, region}, new String[]{"Found existing load balancer named ", " in ", "... Using that."}));
                    dnsName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "DNSName", 0, loadBalancer));
                    IndyInterface.bootstrap("invoke", "updateLoadBalancer", 0, LoadBalancerV2UpsertHandler.class, loadBalancing, loadBalancer, securityGroups, IndyInterface.bootstrap("getProperty", "targetGroups", 4, this.description), IndyInterface.bootstrap("getProperty", "listeners", 4, this.description), this.deployDefaults, IndyInterface.bootstrap("getProperty", "idleTimeout", 4, this.description), IndyInterface.bootstrap("getProperty", "deletionProtection", 4, this.description), IndyInterface.bootstrap("getProperty", "loadBalancingCrossZone", 4, this.description), IndyInterface.bootstrap("getProperty", "ipAddressType", 4, this.description));
                }
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{loadBalancerName, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), region}, new String[]{"Done deploying ", " to ", " in ", "."}));
                CallSite callSite4 = IndyInterface.bootstrap("init", "<init>", 0, UpsertAmazonLoadBalancerV2Result.LoadBalancer.class, loadBalancerName, dnsName);
                IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "loadBalancers", 0, operationResult), region, callSite4);
            }
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, "Done deploying load balancers.");
        return IndyInterface.bootstrap("cast", "()", 0, operationResult);
    }

    private void handleSecurityGroupIngress(String region, Collection<String> securityGroups) {
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "createLoadBalancerIngressPermissions", 4, this.deployDefaults)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "addAppGroupToServerGroup", 4, this.deployDefaults))) {
            CallSite application = null;
            try {
                CallSite callSite = IndyInterface.bootstrap("invoke", "getApp", 0, IndyInterface.bootstrap("invoke", "parseName", 0, Names.class, IndyInterface.bootstrap("getProperty", "name", 4, this.description)));
                application = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : IndyInterface.bootstrap("invoke", "getApp", 0, IndyInterface.bootstrap("invoke", "parseName", 0, Names.class, IndyInterface.bootstrap("getProperty", "clusterName", 4, this.description))));
                Reference ports = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0])));
                public final class _handleSecurityGroupIngress_closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference ports;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handleSecurityGroupIngress_closure2(Object _outerInstance, Object _thisObject, Reference ports) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.ports = reference = ports;
                    }

                    public Object doCall(Object tg) {
                        IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.ports.get()), IndyInterface.bootstrap("getProperty", "port", 0, tg));
                        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "healthCheckPort", 0, tg)) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "healthCheckPort", 0, tg), (Object)"traffic-port")) {
                            return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.ports.get()), IndyInterface.bootstrap("invoke", "parseInt", 0, Integer.class, IndyInterface.bootstrap("getProperty", "healthCheckPort", 0, tg), 10));
                        }
                        return null;
                    }

                    @Generated
                    public Set getPorts() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.ports.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _handleSecurityGroupIngress_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "targetGroups", 4, this.description), new _handleSecurityGroupIngress_closure2(this, this, ports));
                Reference ingressLoadBalancerResult = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "ingressApplicationLoadBalancerGroup", 0, this.ingressLoadBalancerBuilder, application, region, IndyInterface.bootstrap("getProperty", "account", 4, this.description), IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), IndyInterface.bootstrap("getProperty", "vpcId", 4, this.description), (Set)ports.get(), this.securityGroupLookupFactory)));
                public final class _handleSecurityGroupIngress_closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference ingressLoadBalancerResult;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _handleSecurityGroupIngress_closure3(Object _outerInstance, Object _thisObject, Reference ingressLoadBalancerResult) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.ingressLoadBalancerResult = reference = ingressLoadBalancerResult;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)it, (Object)IndyInterface.bootstrap("getProperty", "groupId", 0, IndyInterface.bootstrap("cast", "()", 0, this.ingressLoadBalancerResult.get())));
                    }

                    @Generated
                    public IngressLoadBalancerBuilder.IngressLoadBalancerGroupResult getIngressLoadBalancerResult() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.ingressLoadBalancerResult.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _handleSecurityGroupIngress_closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "any", 0, securityGroups, new _handleSecurityGroupIngress_closure3(this, this, ingressLoadBalancerResult))) == false) {
                    IndyInterface.bootstrap("invoke", "add", 0, securityGroups, IndyInterface.bootstrap("getProperty", "groupId", 0, (IngressLoadBalancerBuilder.IngressLoadBalancerGroupResult)ingressLoadBalancerResult.get()));
                }
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{(IngressLoadBalancerBuilder.IngressLoadBalancerGroupResult)ingressLoadBalancerResult.get()}, new String[]{"Authorized app ELB Security Group ", ""}));
            }
            catch (Exception e) {
                IndyInterface.bootstrap("invoke", "error", 0, log, "Failed to authorize app LB security group {}-elb on application security group", application, e);
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{application}, new String[]{"Failed to authorize app ELB security group ", "-elb on application security group"}));
            }
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UpsertAmazonLoadBalancerV2AtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.deploy.ops.loadbalancer.UpsertAmazonLoadBalancerV2AtomicOperation");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public void setAmazonClientProvider(AmazonClientProvider amazonClientProvider) {
        this.amazonClientProvider = amazonClientProvider;
    }

    @Generated
    public RegionScopedProviderFactory getRegionScopedProviderFactory() {
        return this.regionScopedProviderFactory;
    }

    @Generated
    public void setRegionScopedProviderFactory(RegionScopedProviderFactory regionScopedProviderFactory) {
        this.regionScopedProviderFactory = regionScopedProviderFactory;
    }

    @Generated
    public SecurityGroupLookupFactory getSecurityGroupLookupFactory() {
        return this.securityGroupLookupFactory;
    }

    @Generated
    public void setSecurityGroupLookupFactory(SecurityGroupLookupFactory securityGroupLookupFactory) {
        this.securityGroupLookupFactory = securityGroupLookupFactory;
    }

    @Generated
    public IngressLoadBalancerBuilder getIngressLoadBalancerBuilder() {
        return this.ingressLoadBalancerBuilder;
    }

    @Generated
    public void setIngressLoadBalancerBuilder(IngressLoadBalancerBuilder ingressLoadBalancerBuilder) {
        this.ingressLoadBalancerBuilder = ingressLoadBalancerBuilder;
    }

    @Generated
    public AwsConfiguration.DeployDefaults getDeployDefaults() {
        return this.deployDefaults;
    }

    @Generated
    public void setDeployDefaults(AwsConfiguration.DeployDefaults deployDefaults) {
        this.deployDefaults = deployDefaults;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

