/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops.securitygroup;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DeleteTagsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeTagsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.UpsertSecurityGroupDescription;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.exceptions.IntegrationException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityGroupLookupFactory
implements GroovyObject {
    private final AmazonClientProvider amazonClientProvider;
    private final CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public SecurityGroupLookupFactory(AmazonClientProvider amazonClientProvider, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository) {
        AmazonClientProvider amazonClientProvider2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.amazonClientProvider = amazonClientProvider2 = amazonClientProvider;
        CredentialsRepository<NetflixAmazonCredentials> credentialsRepository2 = credentialsRepository;
        this.credentialsRepository = credentialsRepository2;
    }

    public SecurityGroupLookup getInstance(String region) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstance", 2, this, region, true));
    }

    public SecurityGroupLookup getInstance(String region, boolean skipEdda) {
        CallSite allNetflixAmazonCredentials = IndyInterface.bootstrap("invoke", "getAll", 0, this.credentialsRepository);
        CallSite accounts = IndyInterface.bootstrap("invoke", "copyOf", 0, ImmutableSet.class, allNetflixAmazonCredentials);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, SecurityGroupLookup.class, this.amazonClientProvider, region, accounts, skipEdda));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SecurityGroupLookupFactory.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(SecurityGroupLookupFactory.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(SecurityGroupLookupFactory.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(SecurityGroupLookupFactory.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, SecurityGroupLookupFactory.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(SecurityGroupLookupFactory.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static class SecurityGroupLookup
    implements GroovyObject {
        private final Logger log;
        private final RetrySupport retrySupport;
        private final AmazonClientProvider amazonClientProvider;
        private final String region;
        private final ImmutableSet<NetflixAmazonCredentials> accounts;
        private final boolean skipEdda;
        private Map<String, List<SecurityGroup>> eddaCachedSecurityGroups;
        private final Map<String, SecurityGroup> securityGroupByName;
        private final Map<String, SecurityGroup> securityGroupById;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public SecurityGroupLookup(AmazonClientProvider amazonClientProvider, String region, ImmutableSet<NetflixAmazonCredentials> accounts) {
            boolean bl;
            String string;
            AmazonClientProvider amazonClientProvider2;
            MetaClass metaClass;
            Map map;
            Map map2;
            Map map3;
            CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, IndyInterface.bootstrap("invoke", "getClass", 2, this));
            this.log = IndyInterface.bootstrap("cast", "()", 0, callSite);
            CallSite callSite2 = IndyInterface.bootstrap("init", "<init>", 0, RetrySupport.class);
            this.retrySupport = IndyInterface.bootstrap("cast", "()", 0, callSite2);
            this.eddaCachedSecurityGroups = map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.securityGroupByName = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.securityGroupById = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.amazonClientProvider = amazonClientProvider2 = amazonClientProvider;
            this.region = string = region;
            ImmutableSet<NetflixAmazonCredentials> immutableSet = accounts;
            this.accounts = immutableSet;
            this.skipEdda = bl = true;
        }

        public SecurityGroupLookup(AmazonClientProvider amazonClientProvider, String region, ImmutableSet<NetflixAmazonCredentials> accounts, boolean skipEdda) {
            boolean bl;
            String string;
            AmazonClientProvider amazonClientProvider2;
            MetaClass metaClass;
            Map map;
            Map map2;
            Map map3;
            CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, IndyInterface.bootstrap("invoke", "getClass", 2, this));
            this.log = IndyInterface.bootstrap("cast", "()", 0, callSite);
            CallSite callSite2 = IndyInterface.bootstrap("init", "<init>", 0, RetrySupport.class);
            this.retrySupport = IndyInterface.bootstrap("cast", "()", 0, callSite2);
            this.eddaCachedSecurityGroups = map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.securityGroupByName = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.securityGroupById = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.amazonClientProvider = amazonClientProvider2 = amazonClientProvider;
            this.region = string = region;
            ImmutableSet<NetflixAmazonCredentials> immutableSet = accounts;
            this.accounts = immutableSet;
            this.skipEdda = bl = skipEdda;
        }

        public NetflixAmazonCredentials getCredentialsForName(String accountName) {
            Reference accountName2 = new Reference((Object)accountName);
            public final class _getCredentialsForName_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference accountName;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getCredentialsForName_closure1(Object _outerInstance, Object _thisObject, Reference accountName) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.accountName = reference = accountName;
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.accountName.get()));
                }

                @Generated
                public String getAccountName() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.accountName.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getCredentialsForName_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, this.accounts, new _getCredentialsForName_closure1(this, this, accountName2)));
        }

        public NetflixAmazonCredentials getCredentialsForId(String accountId) {
            Reference accountId2 = new Reference((Object)accountId);
            public final class _getCredentialsForId_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference accountId;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getCredentialsForId_closure2(Object _outerInstance, Object _thisObject, Reference accountId) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.accountId = reference = accountId;
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "accountId", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.accountId.get()));
                }

                @Generated
                public String getAccountId() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.accountId.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getCredentialsForId_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, this.accounts, new _getCredentialsForId_closure2(this, this, accountId2)));
        }

        public String getAccountIdForName(String accountName) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "accountId", 1, IndyInterface.bootstrap("invoke", "getCredentialsForName", 2, this, accountName));
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : accountName);
        }

        public String getAccountNameForId(String accountId) {
            Reference accountId2 = new Reference((Object)accountId);
            public final class _getAccountNameForId_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference accountId;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getAccountNameForId_closure3(Object _outerInstance, Object _thisObject, Reference accountId) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.accountId = reference = accountId;
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "accountId", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.accountId.get()));
                }

                @Generated
                public String getAccountId() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.accountId.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAccountNameForId_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite callSite = IndyInterface.bootstrap("getProperty", "name", 1, IndyInterface.bootstrap("invoke", "find", 0, this.accounts, new _getAccountNameForId_closure3(this, this, accountId2)));
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : (String)accountId2.get());
        }

        public boolean accountIdExists(String accountId) {
            Reference accountId2 = new Reference((Object)accountId);
            public final class _accountIdExists_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference accountId;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _accountIdExists_closure4(Object _outerInstance, Object _thisObject, Reference accountId) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.accountId = reference = accountId;
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "accountId", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.accountId.get()));
                }

                @Generated
                public String getAccountId() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.accountId.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _accountIdExists_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "any", 0, this.accounts, new _accountIdExists_closure4(this, this, accountId2)));
        }

        public SecurityGroupUpdater createSecurityGroup(UpsertSecurityGroupDescription description) {
            Reference description2 = new Reference((Object)description);
            CallSite credentials = IndyInterface.bootstrap("invoke", "getCredentialsForName", 2, this, IndyInterface.bootstrap("getProperty", "account", 4, (UpsertSecurityGroupDescription)description2.get()));
            CallSite request = IndyInterface.bootstrap("init", "<init>", 0, CreateSecurityGroupRequest.class, IndyInterface.bootstrap("getProperty", "name", 4, (UpsertSecurityGroupDescription)description2.get()), IndyInterface.bootstrap("getProperty", "description", 4, (UpsertSecurityGroupDescription)description2.get()));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "vpcId", 4, (UpsertSecurityGroupDescription)description2.get())) != false) {
                IndyInterface.bootstrap("invoke", "withVpcId", 0, request, IndyInterface.bootstrap("getProperty", "vpcId", 4, (UpsertSecurityGroupDescription)description2.get()));
            }
            Reference amazonEC2 = new Reference((Object)IndyInterface.bootstrap("invoke", "getAmazonEC2", 0, this.amazonClientProvider, credentials, this.region, true));
            Reference result = new Reference((Object)IndyInterface.bootstrap("invoke", "createSecurityGroup", 0, amazonEC2.get(), request));
            CallSite newSecurityGroup = IndyInterface.bootstrap("init", "<init>", 0, SecurityGroup.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ownerId", IndyInterface.bootstrap("getProperty", "accountId", 0, credentials), "groupId", IndyInterface.bootstrap("getProperty", "groupId", 0, result.get()), "groupName", IndyInterface.bootstrap("getProperty", "name", 4, (UpsertSecurityGroupDescription)description2.get()), "description", IndyInterface.bootstrap("getProperty", "description", 4, (UpsertSecurityGroupDescription)description2.get()), "vpcId", IndyInterface.bootstrap("getProperty", "vpcId", 4, (UpsertSecurityGroupDescription)description2.get())}));
            IndyInterface.bootstrap("invoke", "put", 0, this.securityGroupById, IndyInterface.bootstrap("getProperty", "groupId", 0, result.get()), newSecurityGroup);
            IndyInterface.bootstrap("invoke", "put", 0, this.securityGroupByName, IndyInterface.bootstrap("getProperty", "name", 4, (UpsertSecurityGroupDescription)description2.get()), newSecurityGroup);
            try {
                public final class _createSecurityGroup_closure5
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference description;
                    private /* synthetic */ Reference result;
                    private /* synthetic */ Reference amazonEC2;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _createSecurityGroup_closure5(Object _outerInstance, Object _thisObject, Reference description, Reference result, Reference amazonEC2) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.description = reference3 = description;
                        this.result = reference2 = result;
                        this.amazonEC2 = reference = amazonEC2;
                    }

                    public Object doCall(Object it) {
                        CallSite createTagRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, CreateTagsRequest.class));
                        Reference tags = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashSet.class)));
                        IndyInterface.bootstrap("invoke", "add", 0, (Collection)tags.get(), IndyInterface.bootstrap("init", "<init>", 0, Tag.class, "Name", IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get()))));
                        public final class _closure8
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference tags;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure8(Object _outerInstance, Object _thisObject, Reference tags) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.tags = reference = tags;
                            }

                            public Object doCall(Object entry) {
                                return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.tags.get()), IndyInterface.bootstrap("init", "<init>", 0, Tag.class, IndyInterface.bootstrap("getProperty", "key", 0, entry), IndyInterface.bootstrap("getProperty", "value", 0, entry)));
                            }

                            @Generated
                            public Collection getTags() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.tags.get());
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure8.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "tags", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get())), new _closure8((Object)this, this.getThisObject(), tags));
                        IndyInterface.bootstrap("invoke", "withTags", 0, IndyInterface.bootstrap("invoke", "withResources", 0, createTagRequest, IndyInterface.bootstrap("getProperty", "groupId", 0, this.result.get())), (Collection)tags.get());
                        try {
                            IndyInterface.bootstrap("invoke", "createTags", 0, this.amazonEC2.get(), createTagRequest);
                        }
                        catch (Exception e) {
                            IndyInterface.bootstrap("invoke", "warn", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get())), IndyInterface.bootstrap("invoke", "getMessage", 0, e)}, new String[]{"Unable to tag newly created security group '", "', reason: ", ""}));
                            throw (Throwable)e;
                        }
                        IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get()))}, new String[]{"Succesfully tagged newly created security group '", "'"}));
                        try {
                            CallSite describeSecurityGroupsRequest = IndyInterface.bootstrap("invoke", "withFilters", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeSecurityGroupsRequest.class), IndyInterface.bootstrap("init", "<init>", 0, Filter.class, "group-name", ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get()))})));
                            CallSite securityGroups = IndyInterface.bootstrap("getProperty", "securityGroups", 0, IndyInterface.bootstrap("invoke", "describeSecurityGroups", 0, this.amazonEC2.get(), describeSecurityGroupsRequest));
                            if (IndyInterface.bootstrap("cast", "()", 0, securityGroups) == false) {
                                throw (Throwable)((Object)IndyInterface.bootstrap("invoke", "setRetryable", 0, IndyInterface.bootstrap("init", "<init>", 0, IntegrationException.class, "Not Found!"), true));
                            }
                        }
                        catch (Exception e) {
                            IndyInterface.bootstrap("invoke", "warn", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get())), IndyInterface.bootstrap("invoke", "getMessage", 0, e)}, new String[]{"Unable to describe newly created security group '", "', reason: ", ""}));
                            throw (Throwable)e;
                        }
                        return IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get()))}, new String[]{"Succesfully described newly created security group '", "'"}));
                    }

                    @Generated
                    public UpsertSecurityGroupDescription getDescription() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.description.get());
                    }

                    @Generated
                    public Object getResult() {
                        return this.result.get();
                    }

                    @Generated
                    public Object getAmazonEC2() {
                        return this.amazonEC2.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _createSecurityGroup_closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "retry", 0, this.retrySupport, new _createSecurityGroup_closure5(this, this, description2, result, amazonEC2), 15, 3000, false);
            }
            catch (Exception e) {
                IndyInterface.bootstrap("invoke", "error", 0, this.log, "Unable to tag or describe newly created security group (groupName: {}, groupId: {}, accountId: {})", IndyInterface.bootstrap("getProperty", "name", 4, (UpsertSecurityGroupDescription)description2.get()), IndyInterface.bootstrap("getProperty", "groupId", 0, result.get()), IndyInterface.bootstrap("getProperty", "accountId", 0, credentials), e);
            }
            if (!this.skipEdda) {
                IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getEddaSecurityGroups", 2, this, amazonEC2.get(), IndyInterface.bootstrap("getProperty", "account", 4, (UpsertSecurityGroupDescription)description2.get()), this.region), newSecurityGroup);
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, SecurityGroupUpdater.class, newSecurityGroup, amazonEC2.get()));
        }

        /*
         * WARNING - void declaration
         */
        public Optional<SecurityGroupUpdater> getSecurityGroupByName(String accountName, String name, String vpcId) {
            void var3_3;
            Reference name2 = new Reference((Object)name);
            Reference vpcId2 = new Reference((Object)var3_3);
            CallSite credentials = IndyInterface.bootstrap("invoke", "getCredentialsForName", 2, this, accountName);
            if (IndyInterface.bootstrap("cast", "()", 0, credentials) == false) {
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "empty", 0, Optional.class));
            }
            CallSite amazonEC2 = IndyInterface.bootstrap("invoke", "getAmazonEC2", 0, this.amazonClientProvider, credentials, this.region, this.skipEdda);
            CallSite cachedSecurityGroupKey = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "toLowerCase", 0, (String)name2.get()), "."), (String)vpcId2.get());
            CallSite cachedSecurityGroup = IndyInterface.bootstrap("invoke", "get", 0, this.securityGroupByName, cachedSecurityGroupKey);
            if (IndyInterface.bootstrap("cast", "()", 0, cachedSecurityGroup) != false) {
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "of", 0, Optional.class, IndyInterface.bootstrap("init", "<init>", 0, SecurityGroupUpdater.class, cachedSecurityGroup, amazonEC2)));
            }
            CallSite securityGroups = null;
            if (this.skipEdda) {
                CallSite describeSecurityGroupsRequest = IndyInterface.bootstrap("invoke", "withFilters", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeSecurityGroupsRequest.class), IndyInterface.bootstrap("init", "<init>", 0, Filter.class, "group-name", ScriptBytecodeAdapter.createList((Object[])new Object[]{(String)name2.get()})));
                securityGroups = IndyInterface.bootstrap("getProperty", "securityGroups", 0, IndyInterface.bootstrap("invoke", "describeSecurityGroups", 0, amazonEC2, describeSecurityGroupsRequest));
            } else {
                securityGroups = IndyInterface.bootstrap("invoke", "getEddaSecurityGroups", 2, this, amazonEC2, accountName, this.region);
            }
            public final class _getSecurityGroupByName_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference name;
                private /* synthetic */ Reference vpcId;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getSecurityGroupByName_closure6(Object _outerInstance, Object _thisObject, Reference name, Reference vpcId) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.name = reference2 = name;
                    this.vpcId = reference = vpcId;
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "groupName", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.name.get())) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "vpcId", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.vpcId.get()));
                }

                @Generated
                public String getName() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.name.get());
                }

                @Generated
                public String getVpcId() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.vpcId.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getSecurityGroupByName_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite securityGroup = IndyInterface.bootstrap("invoke", "find", 0, securityGroups, new _getSecurityGroupByName_closure6(this, this, name2, vpcId2));
            if (IndyInterface.bootstrap("cast", "()", 0, securityGroup) != false) {
                CallSite callSite = securityGroup;
                IndyInterface.bootstrap("invoke", "putAt", 0, this.securityGroupByName, cachedSecurityGroupKey, callSite);
                CallSite callSite2 = securityGroup;
                IndyInterface.bootstrap("invoke", "putAt", 0, this.securityGroupById, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "groupId", 0, securityGroup), "."), (String)vpcId2.get()), callSite2);
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "of", 0, Optional.class, IndyInterface.bootstrap("init", "<init>", 0, SecurityGroupUpdater.class, securityGroup, amazonEC2)));
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "empty", 0, Optional.class));
        }

        private List<SecurityGroup> getEddaSecurityGroups(AmazonEC2 amazonEC2, String accountName, String region) {
            CallSite cacheKey = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, accountName, ":"), region);
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, this.eddaCachedSecurityGroups, cacheKey)) == false) {
                CallSite callSite = IndyInterface.bootstrap("getProperty", "securityGroups", 0, IndyInterface.bootstrap("invoke", "describeSecurityGroups", 0, amazonEC2));
                IndyInterface.bootstrap("invoke", "putAt", 0, this.eddaCachedSecurityGroups, cacheKey, callSite);
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, this.eddaCachedSecurityGroups, cacheKey));
        }

        /*
         * WARNING - void declaration
         */
        public Optional<SecurityGroupUpdater> getSecurityGroupById(String accountName, String groupId, String vpcId) {
            void var3_3;
            Reference groupId2 = new Reference((Object)groupId);
            Reference vpcId2 = new Reference((Object)var3_3);
            CallSite credentials = IndyInterface.bootstrap("invoke", "getCredentialsForName", 2, this, accountName);
            if (IndyInterface.bootstrap("cast", "()", 0, credentials) == false) {
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "empty", 0, Optional.class));
            }
            CallSite amazonEC2 = IndyInterface.bootstrap("invoke", "getAmazonEC2", 0, this.amazonClientProvider, credentials, this.region, this.skipEdda);
            CallSite cachedSecurityGroupKey = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "toLowerCase", 0, (String)groupId2.get()), "."), (String)vpcId2.get());
            CallSite cachedSecurityGroup = IndyInterface.bootstrap("invoke", "get", 0, this.securityGroupById, cachedSecurityGroupKey);
            if (IndyInterface.bootstrap("cast", "()", 0, cachedSecurityGroup) != false) {
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "of", 0, Optional.class, IndyInterface.bootstrap("init", "<init>", 0, SecurityGroupUpdater.class, cachedSecurityGroup, amazonEC2)));
            }
            Object securityGroups = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            if (this.skipEdda) {
                CallSite describeSecurityGroupsRequest = IndyInterface.bootstrap("invoke", "withGroupIds", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeSecurityGroupsRequest.class), (String)groupId2.get());
                try {
                    securityGroups = IndyInterface.bootstrap("getProperty", "securityGroups", 0, IndyInterface.bootstrap("invoke", "describeSecurityGroups", 0, amazonEC2, describeSecurityGroupsRequest));
                }
                catch (Exception ignored) {
                }
            } else {
                securityGroups = IndyInterface.bootstrap("invoke", "getEddaSecurityGroups", 2, this, amazonEC2, accountName, this.region);
            }
            public final class _getSecurityGroupById_closure7
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference groupId;
                private /* synthetic */ Reference vpcId;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getSecurityGroupById_closure7(Object _outerInstance, Object _thisObject, Reference groupId, Reference vpcId) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.groupId = reference2 = groupId;
                    this.vpcId = reference = vpcId;
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "groupId", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.groupId.get())) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "vpcId", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.vpcId.get()));
                }

                @Generated
                public String getGroupId() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.groupId.get());
                }

                @Generated
                public String getVpcId() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.vpcId.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getSecurityGroupById_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite securityGroup = IndyInterface.bootstrap("invoke", "find", 0, securityGroups, new _getSecurityGroupById_closure7(this, this, groupId2, vpcId2));
            if (IndyInterface.bootstrap("cast", "()", 0, securityGroup) != false) {
                CallSite callSite = securityGroup;
                IndyInterface.bootstrap("invoke", "putAt", 0, this.securityGroupById, cachedSecurityGroupKey, callSite);
                CallSite callSite2 = securityGroup;
                IndyInterface.bootstrap("invoke", "putAt", 0, this.securityGroupByName, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "groupName", 0, securityGroup)), "."), (String)vpcId2.get()), callSite2);
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "of", 0, Optional.class, IndyInterface.bootstrap("init", "<init>", 0, SecurityGroupUpdater.class, securityGroup, amazonEC2)));
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "empty", 0, Optional.class));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != SecurityGroupLookup.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(SecurityGroupLookup.class, SecurityGroupLookupFactory.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(SecurityGroupLookup.class, SecurityGroupLookupFactory.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(SecurityGroupLookup.class, SecurityGroupLookupFactory.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(SecurityGroupLookup.class, SecurityGroupLookupFactory.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(SecurityGroupLookup.class, SecurityGroupLookupFactory.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(SecurityGroupLookup.class, SecurityGroupLookupFactory.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), SecurityGroupLookup.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SecurityGroupLookupFactory.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SecurityGroupLookupFactory.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), SecurityGroupLookup.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(SecurityGroupLookup.class, SecurityGroupLookupFactory.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(SecurityGroupLookup.class, SecurityGroupLookupFactory.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), SecurityGroupLookup.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public Map<String, List<SecurityGroup>> getEddaCachedSecurityGroups() {
            return this.eddaCachedSecurityGroups;
        }

        @Generated
        public void setEddaCachedSecurityGroups(Map<String, List<SecurityGroup>> map) {
            this.eddaCachedSecurityGroups = map;
        }
    }

    public static class SecurityGroupUpdater
    implements GroovyObject {
        private final SecurityGroup securityGroup;
        private final AmazonEC2 amazonEC2;
        private final Logger log;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public SecurityGroupUpdater(SecurityGroup securityGroup, AmazonEC2 amazonEC2) {
            AmazonEC2 amazonEC22;
            SecurityGroup securityGroup2;
            MetaClass metaClass;
            CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, IndyInterface.bootstrap("invoke", "getClass", 2, this));
            this.log = IndyInterface.bootstrap("cast", "()", 0, callSite);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.securityGroup = securityGroup2 = securityGroup;
            this.amazonEC2 = amazonEC22 = amazonEC2;
        }

        public SecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        public void updateIngress(List<IpPermission> ipPermissionsToUpdate) {
            IndyInterface.bootstrap("invoke", "updateSecurityGroupRuleDescriptionsIngress", 0, this.amazonEC2, IndyInterface.bootstrap("init", "<init>", 0, UpdateSecurityGroupRuleDescriptionsIngressRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", IndyInterface.bootstrap("getProperty", "groupId", 0, this.securityGroup), "ipPermissions", ipPermissionsToUpdate})));
        }

        public void addIngress(List<IpPermission> ipPermissionsToAdd) {
            IndyInterface.bootstrap("invoke", "authorizeSecurityGroupIngress", 0, this.amazonEC2, IndyInterface.bootstrap("init", "<init>", 0, AuthorizeSecurityGroupIngressRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", IndyInterface.bootstrap("getProperty", "groupId", 0, this.securityGroup), "ipPermissions", ipPermissionsToAdd})));
            IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("getProperty", "ipPermissions", 0, this.securityGroup), ipPermissionsToAdd);
        }

        public void removeIngress(List<IpPermission> ipPermissionsToRemove) {
            IndyInterface.bootstrap("invoke", "revokeSecurityGroupIngress", 0, this.amazonEC2, IndyInterface.bootstrap("init", "<init>", 0, RevokeSecurityGroupIngressRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"groupId", IndyInterface.bootstrap("getProperty", "groupId", 0, this.securityGroup), "ipPermissions", ipPermissionsToRemove})));
            IndyInterface.bootstrap("invoke", "removeAll", 0, IndyInterface.bootstrap("getProperty", "ipPermissions", 0, this.securityGroup), ipPermissionsToRemove);
        }

        public void updateTags(UpsertSecurityGroupDescription description, DynamicConfigService dynamicConfigService) {
            Reference description2 = new Reference((Object)description);
            CallSite groupId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "groupId", 0, this.securityGroup));
            try {
                CallSite describeTagsRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withFilters", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeTagsRequest.class), IndyInterface.bootstrap("init", "<init>", 0, Filter.class, "resource-id", ScriptBytecodeAdapter.createList((Object[])new Object[]{groupId}))));
                CallSite tagsResult = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "describeTags", 0, this.amazonEC2, describeTagsRequest));
                CallSite currentTags = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTags", 0, tagsResult));
                Reference oldTags = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashSet.class)));
                Reference additionalTags = new Reference((Object)IndyInterface.bootstrap("invoke", "getConfig", 0, dynamicConfigService, String.class, "aws.features.security-group.additional-tags", ""));
                public final class _updateTags_closure1
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference description;
                    private /* synthetic */ Reference additionalTags;
                    private /* synthetic */ Reference oldTags;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _updateTags_closure1(Object _outerInstance, Object _thisObject, Reference description, Reference additionalTags, Reference oldTags) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.description = reference3 = description;
                        this.additionalTags = reference2 = additionalTags;
                        this.oldTags = reference = oldTags;
                    }

                    public Object doCall(Object it) {
                        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "equals", 0, IndyInterface.bootstrap("getProperty", "key", 0, it), "Name")) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 1, IndyInterface.bootstrap("invoke", "keySet", 1, IndyInterface.bootstrap("getProperty", "tags", 4, IndyInterface.bootstrap("cast", "()", 0, this.description.get()))), IndyInterface.bootstrap("getProperty", "key", 0, it))) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, this.additionalTags.get(), IndyInterface.bootstrap("getProperty", "key", 0, it)))) {
                            return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.oldTags.get()), IndyInterface.bootstrap("init", "<init>", 0, Tag.class, IndyInterface.bootstrap("getProperty", "key", 0, it), IndyInterface.bootstrap("getProperty", "value", 0, it)));
                        }
                        return null;
                    }

                    @Generated
                    public UpsertSecurityGroupDescription getDescription() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.description.get());
                    }

                    @Generated
                    public Object getAdditionalTags() {
                        return this.additionalTags.get();
                    }

                    @Generated
                    public Collection getOldTags() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.oldTags.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _updateTags_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, currentTags, new _updateTags_closure1(this, this, description2, additionalTags, oldTags));
                CallSite deleteTagsRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withTags", 0, IndyInterface.bootstrap("invoke", "withResources", 0, IndyInterface.bootstrap("init", "<init>", 0, DeleteTagsRequest.class), groupId), (Collection)oldTags.get()));
                IndyInterface.bootstrap("invoke", "deleteTags", 0, this.amazonEC2, deleteTagsRequest);
                CallSite createTagRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, CreateTagsRequest.class));
                Reference tags = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashSet.class)));
                IndyInterface.bootstrap("invoke", "add", 0, (Collection)tags.get(), IndyInterface.bootstrap("init", "<init>", 0, Tag.class, "Name", IndyInterface.bootstrap("getProperty", "name", 4, (UpsertSecurityGroupDescription)description2.get())));
                public final class _updateTags_closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference tags;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _updateTags_closure2(Object _outerInstance, Object _thisObject, Reference tags) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.tags = reference = tags;
                    }

                    public Object doCall(Object entry) {
                        return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.tags.get()), IndyInterface.bootstrap("init", "<init>", 0, Tag.class, IndyInterface.bootstrap("getProperty", "key", 0, entry), IndyInterface.bootstrap("getProperty", "value", 0, entry)));
                    }

                    @Generated
                    public Collection getTags() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.tags.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _updateTags_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "tags", 4, (UpsertSecurityGroupDescription)description2.get()), new _updateTags_closure2(this, this, tags));
                IndyInterface.bootstrap("invoke", "withTags", 0, IndyInterface.bootstrap("invoke", "withResources", 0, createTagRequest, groupId), (Collection)tags.get());
                IndyInterface.bootstrap("invoke", "createTags", 0, this.amazonEC2, createTagRequest);
            }
            catch (Exception e) {
                IndyInterface.bootstrap("invoke", "error", 0, this.log, "Unable to update tags for security group (groupName: {}, groupId: {})", IndyInterface.bootstrap("getProperty", "name", 4, (UpsertSecurityGroupDescription)description2.get()), groupId, e);
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != SecurityGroupUpdater.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(SecurityGroupUpdater.class, SecurityGroupLookupFactory.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(SecurityGroupUpdater.class, SecurityGroupLookupFactory.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(SecurityGroupUpdater.class, SecurityGroupLookupFactory.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(SecurityGroupUpdater.class, SecurityGroupLookupFactory.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(SecurityGroupUpdater.class, SecurityGroupLookupFactory.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(SecurityGroupUpdater.class, SecurityGroupLookupFactory.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), SecurityGroupUpdater.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SecurityGroupLookupFactory.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, SecurityGroupLookupFactory.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), SecurityGroupUpdater.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(SecurityGroupUpdater.class, SecurityGroupLookupFactory.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(SecurityGroupUpdater.class, SecurityGroupLookupFactory.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), SecurityGroupUpdater.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }
}

