/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.validators;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.spinnaker.clouddriver.aws.AmazonOperation;
import com.netflix.spinnaker.clouddriver.aws.deploy.InstanceTypeUtils;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.AbstractAmazonCredentialsDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.BasicAmazonDeployDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.validators.AmazonDescriptionValidationSupport;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonBlockDevice;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="basicAmazonDeployDescriptionValidator")
@AmazonOperation(value="createServerGroup")
public class BasicAmazonDeployDescriptionValidator
extends AmazonDescriptionValidationSupport<BasicAmazonDeployDescription> {
    @Autowired
    private CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public BasicAmazonDeployDescriptionValidator() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public void validate(List priorDescriptions, BasicAmazonDeployDescription description, ValidationErrors errors) {
        CallSite credentials = null;
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, description)) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "credentials", "basicAmazonDeployDescription.credentials.empty");
        } else {
            credentials = IndyInterface.bootstrap("invoke", "getOne", 0, this.credentialsRepository, IndyInterface.bootstrap("getProperty", "name", 1, IndyInterface.bootstrap("getProperty", "credentials", 5, description)));
            if (ScriptBytecodeAdapter.compareEqual((Object)credentials, null)) {
                IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "credentials", "basicAmazonDeployDescription.credentials.invalid");
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "application", 4, description)) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "application", "basicAmazonDeployDescription.application.empty");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "amiName", 4, description)) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "amiName", "basicAmazonDeployDescription.amiName.empty");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "instanceType", 4, description)) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "instanceType", "basicAmazonDeployDescription.instanceType.empty");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "availabilityZones", 4, description)) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "availabilityZones", "basicAmazonDeployDescription.availabilityZones.empty");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "associatePublicIpAddress", 4, description)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "subnetType", 4, description)) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "associatePublicIpAddress", "basicAmazonDeployDescription.associatePublicIpAddress.subnetType.not.supplied");
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "flatten", 1, IndyInterface.bootstrap("invoke", "values", 0, IndyInterface.bootstrap("getProperty", "availabilityZones", 4, description)))) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "subnetType", 4, description)) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "availabilityZones", "basicAmazonDeployDescription.availabilityZones.or.subnetType.not.supplied");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)credentials) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsAll", 0, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "regions", 0, IndyInterface.bootstrap("cast", "()", 0, credentials))), IndyInterface.bootstrap("invoke", "keySet", 0, IndyInterface.bootstrap("getProperty", "availabilityZones", 4, description)))) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "availabilityZones", "basicAmazonDeployDescription.region.not.configured", ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "keySet", 0, IndyInterface.bootstrap("getProperty", "availabilityZones", 4, description)), String[].class)), String[].class), "Region not configured");
        }
        CallSite device = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("getProperty", "blockDevices", 4, description)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                device = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                IndyInterface.bootstrap("invoke", "validate", 0, BlockDeviceRules.class, device, errors);
            }
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "useSourceCapacity", 1, IndyInterface.bootstrap("getProperty", "source", 4, description))) == false) {
            IndyInterface.bootstrap("invoke", "validateCapacity", 0, BasicAmazonDeployDescriptionValidator.class, description, errors);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "unlimitedCpuCredits", 4, description), null) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isBurstingSupportedByAllTypes", 0, InstanceTypeUtils.class, IndyInterface.bootstrap("invoke", "getAllInstanceTypes", 0, description))) == false) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "unlimitedCpuCredits", "basicAmazonDeployDescription.bursting.not.supported.by.instanceType");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "spotInstancePools", 4, description)) && ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("getProperty", "spotInstancePools", 4, description), (Object)0) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "spotAllocationStrategy", 4, description), (Object)"lowest-price")) {
            IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "spotInstancePools", "basicAmazonDeployDescription.spotInstancePools.not.supported.for.spotAllocationStrategy");
        }
        CallSite warnings = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getWarnings", 2, this, description));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, warnings)) == false) {
            IndyInterface.bootstrap("invoke", "warn", 0, log, warnings);
        }
    }

    @VisibleForTesting
    private String getWarnings(BasicAmazonDeployDescription description) {
        List warnings = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "setLaunchTemplate", 4, description)) == false) {
            CallSite ltFeaturesEnabled = IndyInterface.bootstrap("invoke", "getLtFeaturesEnabled", 2, this, description);
            if (IndyInterface.bootstrap("cast", "()", 0, ltFeaturesEnabled) != false) {
                IndyInterface.bootstrap("invoke", "add", 0, warnings, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{ltFeaturesEnabled}, new String[]{"WARNING: The following fields ", " work as expected only with AWS EC2 Launch Template, "}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "account", 4, description)}, new String[]{"but 'setLaunchTemplate' is set to false in request with account: ", ", "})), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "application", 4, description), IndyInterface.bootstrap("getProperty", "stack", 4, description)}, new String[]{"application: ", ", stack: ", ")"})));
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "join", 0, warnings, "\n"));
    }

    private List<String> getLtFeaturesEnabled(BasicAmazonDeployDescription descToValidate) {
        Reference descToValidate2 = new Reference((Object)descToValidate);
        CallSite allLtFeatures = IndyInterface.bootstrap("invoke", "getLaunchTemplateOnlyFieldNames", 0, BasicAmazonDeployDescription.class);
        Reference descWithDefaults = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, BasicAmazonDeployDescription.class));
        Reference ltFeaturesEnabled = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _getLtFeaturesEnabled_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference descToValidate;
            private /* synthetic */ Reference descWithDefaults;
            private /* synthetic */ Reference ltFeaturesEnabled;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getLtFeaturesEnabled_closure1(Object _outerInstance, Object _thisObject, Reference descToValidate, Reference descWithDefaults, Reference ltFeaturesEnabled) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.descToValidate = reference3 = descToValidate;
                this.descWithDefaults = reference2 = descWithDefaults;
                this.ltFeaturesEnabled = reference = ltFeaturesEnabled;
            }

            public Object doCall(Object it) {
                if (ScriptBytecodeAdapter.compareNotEqual((Object)ScriptBytecodeAdapter.getGroovyObjectProperty(_getLtFeaturesEnabled_closure1.class, (GroovyObject)IndyInterface.bootstrap("cast", "()", 0, this.descToValidate.get()), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{it}, new String[]{"", ""})))), (Object)ScriptBytecodeAdapter.getProperty(_getLtFeaturesEnabled_closure1.class, (Object)this.descWithDefaults.get(), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{it}, new String[]{"", ""})))))) {
                    return IndyInterface.bootstrap("invoke", "add", 0, this.ltFeaturesEnabled.get(), it);
                }
                return null;
            }

            @Generated
            public BasicAmazonDeployDescription getDescToValidate() {
                return IndyInterface.bootstrap("cast", "()", 0, this.descToValidate.get());
            }

            @Generated
            public Object getDescWithDefaults() {
                return this.descWithDefaults.get();
            }

            @Generated
            public Object getLtFeaturesEnabled() {
                return this.ltFeaturesEnabled.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getLtFeaturesEnabled_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, allLtFeatures, new _getLtFeaturesEnabled_closure1((Object)this, (Object)this, descToValidate2, descWithDefaults, ltFeaturesEnabled));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "sort", 0, ltFeaturesEnabled.get()));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != BasicAmazonDeployDescriptionValidator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(BasicAmazonDeployDescriptionValidator.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(BasicAmazonDeployDescriptionValidator.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(BasicAmazonDeployDescriptionValidator.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, BasicAmazonDeployDescriptionValidator.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(BasicAmazonDeployDescriptionValidator.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.deploy.validators.BasicAmazonDeployDescriptionValidator");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public CredentialsRepository<NetflixAmazonCredentials> getCredentialsRepository() {
        return this.credentialsRepository;
    }

    @Generated
    public void setCredentialsRepository(CredentialsRepository<NetflixAmazonCredentials> credentialsRepository) {
        this.credentialsRepository = credentialsRepository;
    }

    public /* synthetic */ void super$3$validate(List list, AbstractAmazonCredentialsDescription abstractAmazonCredentialsDescription, ValidationErrors validationErrors) {
        super.validate(list, abstractAmazonCredentialsDescription, validationErrors);
    }

    public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public static final class BlockDeviceRules
    extends Enum<BlockDeviceRules>
    implements GroovyObject {
        public static final /* enum */ BlockDeviceRules deviceNameNotNull;
        public static final /* enum */ BlockDeviceRules ephemeralConfigWrong;
        public static final /* enum */ BlockDeviceRules ebsConfigWrong;
        private final Closure<Void> validationRule;
        public static final BlockDeviceRules MIN_VALUE;
        public static final BlockDeviceRules MAX_VALUE;
        private static final /* synthetic */ BlockDeviceRules[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        private BlockDeviceRules(@ClosureParams(value=SimpleType.class, options={"AmazonBlockDevice", "org.springframework.validation.Errors"}) String validationRule, int n, Closure<Void> object) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            object = validationRule;
            this.validationRule = object;
        }

        public void validateDevice(AmazonBlockDevice device, ValidationErrors errors) {
            ScriptBytecodeAdapter.invokeClosure(this.validationRule, (Object[])new Object[]{device, errors});
        }

        public static void validate(AmazonBlockDevice device, ValidationErrors errors) {
            Object rule = null;
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "values", 0, BlockDeviceRules.class)));
            if (callSite != null) {
                while (callSite.hasNext()) {
                    rule = callSite.next();
                    IndyInterface.bootstrap("invoke", "validateDevice", 0, rule, device, errors);
                }
            }
        }

        @Generated
        public static final BlockDeviceRules[] values() {
            return IndyInterface.bootstrap("cast", "()", 0, $VALUES.clone());
        }

        @Generated
        public BlockDeviceRules next() {
            Object ordinal = IndyInterface.bootstrap("invoke", "next", 0, IndyInterface.bootstrap("invoke", "ordinal", 2, this));
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)IndyInterface.bootstrap("invoke", "size", 0, $VALUES))) {
                ordinal = 0;
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, $VALUES, ordinal));
        }

        @Generated
        public BlockDeviceRules previous() {
            CallSite ordinal = IndyInterface.bootstrap("invoke", "previous", 0, IndyInterface.bootstrap("invoke", "ordinal", 2, this));
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                ordinal = IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "size", 0, $VALUES), Integer.valueOf(1));
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, $VALUES, ordinal));
        }

        @Generated
        public static BlockDeviceRules valueOf(String name) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "valueOf", 0, BlockDeviceRules.class, BlockDeviceRules.class, name));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Generated
        public static final /* synthetic */ BlockDeviceRules $INIT(Object ... para) {
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, BlockDeviceRules.class)) {
                case 1159348642: {
                    return new BlockDeviceRules((String)((Object)IndyInterface.bootstrap("cast", "()", 0, objectArray[0])), DefaultTypeTransformation.intUnbox((Object)objectArray[1]), (Closure)IndyInterface.bootstrap("cast", "()", 0, objectArray[2]));
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
        }

        static {
            BlockDeviceRules blockDeviceRules;
            BlockDeviceRules blockDeviceRules2;
            public final class __clinit__closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public __clinit__closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(AmazonBlockDevice device, ValidationErrors errors) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "deviceName", 4, device)) == false) {
                        return IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "blockDevices", "basicAmazonDeployDescription.block.device.not.named", ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), String[].class)), String[].class), "Device name is required for block device");
                    }
                    return null;
                }

                @Generated
                public Object call(AmazonBlockDevice device, ValidationErrors errors) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, device, errors);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __clinit__closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite callSite = IndyInterface.bootstrap("invoke", "$INIT", 0, BlockDeviceRules.class, "deviceNameNotNull", Integer.valueOf(0), new __clinit__closure1(BlockDeviceRules.class, BasicAmazonDeployDescriptionValidator.class));
            deviceNameNotNull = IndyInterface.bootstrap("cast", "()", 0, callSite);
            public final class __clinit__closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public __clinit__closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(AmazonBlockDevice device, ValidationErrors errors) {
                    if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "virtualName", 4, device)) && (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "deleteOnTermination", 4, device), null) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "iops", 4, device)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "size", 4, device)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "snapshotId", 4, device)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "volumeType", 4, device)))) {
                        return IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "blockDevices", "basicAmazonDeployDescription.block.device.ephemeral.config", ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "virtualName", 4, device)}), String[].class)), String[].class), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "deviceName", 4, device)}, new String[]{"Ephemeral block device ", " with EBS configuration parameters"}));
                    }
                    return null;
                }

                @Generated
                public Object call(AmazonBlockDevice device, ValidationErrors errors) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, device, errors);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __clinit__closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "$INIT", 0, BlockDeviceRules.class, "ephemeralConfigWrong", Integer.valueOf(1), new __clinit__closure2(BlockDeviceRules.class, BasicAmazonDeployDescriptionValidator.class));
            ephemeralConfigWrong = IndyInterface.bootstrap("cast", "()", 0, callSite2);
            public final class __clinit__closure3
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public __clinit__closure3(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(AmazonBlockDevice device, ValidationErrors errors) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "virtualName", 4, device)) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "size", 4, device)) == false) {
                        return IndyInterface.bootstrap("invoke", "rejectValue", 0, errors, "blockDevices", "basicAmazonDeployDescription.block.device.ebs.config", ScriptBytecodeAdapter.createPojoWrapper((Object)((String[])IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "deviceName", 4, device)}), String[].class)), String[].class), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "deviceName", 4, device)}, new String[]{"EBS device ", " missing required value size"}));
                    }
                    return null;
                }

                @Generated
                public Object call(AmazonBlockDevice device, ValidationErrors errors) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, device, errors);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != __clinit__closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite callSite3 = IndyInterface.bootstrap("invoke", "$INIT", 0, BlockDeviceRules.class, "ebsConfigWrong", Integer.valueOf(2), new __clinit__closure3(BlockDeviceRules.class, BasicAmazonDeployDescriptionValidator.class));
            ebsConfigWrong = IndyInterface.bootstrap("cast", "()", 0, callSite3);
            MIN_VALUE = blockDeviceRules2 = deviceNameNotNull;
            MAX_VALUE = blockDeviceRules = ebsConfigWrong;
            BlockDeviceRules[] blockDeviceRulesArray = new BlockDeviceRules[]{deviceNameNotNull, ephemeralConfigWrong, ebsConfigWrong};
            $VALUES = blockDeviceRulesArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != BlockDeviceRules.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }
}

