/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.lifecycle;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.Activity;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest;
import com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesResult;
import com.amazonaws.services.autoscaling.model.ScalingActivityStatusCode;
import com.netflix.spinnaker.cats.agent.RunnableAgent;
import com.netflix.spinnaker.clouddriver.aws.lifecycle.LaunchFailureNotificationAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;
import com.netflix.spinnaker.clouddriver.model.EntityTags;
import com.netflix.spinnaker.clouddriver.tags.EntityTagger;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchFailureNotificationCleanupAgent
implements RunnableAgent,
CustomScheduledAgent {
    private static final Logger log = LoggerFactory.getLogger(LaunchFailureNotificationAgent.class);
    private static final String TAG_NAME = "spinnaker_ui_alert:autoscaling:ec2_instance_launch_error";
    private static final int MAX_RESULTS = 10000;
    private final AmazonClientProvider amazonClientProvider;
    private final CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;
    private final EntityTagger serverGroupTagger;

    LaunchFailureNotificationCleanupAgent(AmazonClientProvider amazonClientProvider, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository, EntityTagger serverGroupTagger) {
        this.amazonClientProvider = amazonClientProvider;
        this.credentialsRepository = credentialsRepository;
        this.serverGroupTagger = serverGroupTagger;
    }

    public String getAgentType() {
        return LaunchFailureNotificationCleanupAgent.class.getSimpleName();
    }

    public String getProviderName() {
        return AwsProvider.PROVIDER_NAME;
    }

    public long getPollIntervalMillis() {
        return TimeUnit.MINUTES.toMillis(5L);
    }

    public long getTimeoutMillis() {
        return -1L;
    }

    public void run() {
        Collection taggedEntities = this.serverGroupTagger.taggedEntities("aws", null, "servergroup", TAG_NAME, 10000);
        taggedEntities.forEach(entityTags -> {
            EntityTags.EntityRef entityRef = entityTags.getEntityRef();
            Optional<NetflixAmazonCredentials> credentials = Optional.ofNullable((NetflixAmazonCredentials)this.credentialsRepository.getOne(entityRef.getAccount())).map(NetflixAmazonCredentials.class::cast);
            if (!credentials.isPresent()) {
                log.warn("No account configuration for {}. Unable to determine if '{}' has launch failures", (Object)entityRef.getAccount(), (Object)entityTags.getId());
                return;
            }
            AmazonAutoScaling amazonAutoScaling = this.amazonClientProvider.getAutoScaling(credentials.get(), entityRef.getRegion());
            try {
                if (this.hasLaunchFailures(amazonAutoScaling, (EntityTags)entityTags)) {
                    return;
                }
                this.serverGroupTagger.delete("aws", entityRef.getAccountId(), entityRef.getRegion(), "servergroup", entityRef.getEntityId(), TAG_NAME);
            }
            catch (Exception e) {
                log.error("Unable to determine if '{}' has launch failures", (Object)entityTags.getId(), (Object)e);
            }
        });
    }

    protected boolean hasLaunchFailures(AmazonAutoScaling amazonAutoScaling, EntityTags entityTags) {
        EntityTags.EntityRef entityRef = entityTags.getEntityRef();
        try {
            DescribeScalingActivitiesResult describeScalingActivitiesResult = amazonAutoScaling.describeScalingActivities(new DescribeScalingActivitiesRequest().withAutoScalingGroupName(entityRef.getEntityId()));
            List activities = describeScalingActivitiesResult.getActivities();
            return !activities.isEmpty() && !((Activity)activities.get(0)).getStatusCode().equals(ScalingActivityStatusCode.Successful.toString());
        }
        catch (Exception e) {
            AmazonServiceException amazonServiceException = LaunchFailureNotificationCleanupAgent.amazonServiceException(e);
            if (amazonServiceException != null && amazonServiceException.getErrorMessage().toLowerCase().contains("name not found")) {
                return false;
            }
            throw e;
        }
    }

    private static AmazonServiceException amazonServiceException(Exception e) {
        if (e instanceof AmazonServiceException) {
            return (AmazonServiceException)e;
        }
        if (!(e instanceof UndeclaredThrowableException)) {
            return null;
        }
        UndeclaredThrowableException ute = (UndeclaredThrowableException)e;
        if (!(ute.getUndeclaredThrowable() instanceof InvocationTargetException)) {
            return null;
        }
        InvocationTargetException ite = (InvocationTargetException)ute.getUndeclaredThrowable();
        if (!(ite.getTargetException() instanceof AmazonServiceException)) {
            return null;
        }
        return (AmazonServiceException)ite.getTargetException();
    }
}

