/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.model;

import com.amazonaws.services.ec2.model.Subnet;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.netflix.spinnaker.clouddriver.aws.model.SubnetData;
import com.netflix.spinnaker.clouddriver.aws.model.SubnetTarget;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.ToString;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.FormatHelper;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.util.HashCodeHelper;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

@ToString
@EqualsAndHashCode
public class SubnetAnalyzer
implements GroovyObject {
    private final Collection<SubnetData> allSubnets;
    private final String defaultVpcId;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    private SubnetAnalyzer(Collection<SubnetData> allSubnets, String defaultVpcId) {
        String string;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.defaultVpcId = string = defaultVpcId;
        CallSite callSite = IndyInterface.bootstrap("invoke", "copyOf", 0, ImmutableSet.class, allSubnets);
        this.allSubnets = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    private SubnetAnalyzer(Collection<SubnetData> allSubnets) {
        this(allSubnets, null);
    }

    public static SubnetAnalyzer from(Collection<Subnet> subnets, String defaultVpcId) {
        public final class _from_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _from_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "from", 0, SubnetData.class, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _from_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, SubnetAnalyzer.class, IndyInterface.bootstrap("invoke", "collect", 0, subnets, new _from_closure1(SubnetAnalyzer.class, SubnetAnalyzer.class)), defaultVpcId));
    }

    public List<String> getSubnetIdsForZones(Collection<String> zones, String purpose, SubnetTarget target, Integer maxSubnetsPerZone) {
        Reference purpose2 = new Reference((Object)purpose);
        Reference maxSubnetsPerZone2 = new Reference((Object)maxSubnetsPerZone);
        IndyInterface.bootstrap("invoke", "checkNotNull", 0, Preconditions.class, (String)purpose2.get());
        if (IndyInterface.bootstrap("cast", "()", 0, zones) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "emptyList", 0, Collections.class));
        }
        CallSite zonesToSubnets = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asMap", 0, IndyInterface.bootstrap("invoke", "mapZonesToTargetSubnets", 2, this, target)));
        public final class _getSubnetIdsForZones_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference purpose;
            private /* synthetic */ Reference maxSubnetsPerZone;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getSubnetIdsForZones_closure2(Object _outerInstance, Object _thisObject, Reference purpose, Reference maxSubnetsPerZone) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.purpose = reference2 = purpose;
                this.maxSubnetsPerZone = reference = maxSubnetsPerZone;
            }

            public Object doCall(Object z, Object c) {
                public final class _closure7
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference purpose;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure7(Object _outerInstance, Object _thisObject, Reference purpose) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.purpose = reference = purpose;
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "purpose", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.purpose.get())) ? it : null;
                    }

                    @Generated
                    public String getPurpose() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.purpose.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure7.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite filtered = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findResults", 0, c, new _closure7((Object)this, this.getThisObject(), this.purpose)));
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.maxSubnetsPerZone.get()), null)) {
                    public final class _closure8
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure8(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return ScriptBytecodeAdapter.unaryMinus((Object)IndyInterface.bootstrap("getProperty", "availableIpAddressCount", 0, it));
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure8.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "sort", 0, filtered, new _closure8((Object)this, this.getThisObject()));
                    filtered = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "take", 0, filtered, IndyInterface.bootstrap("cast", "()", 0, this.maxSubnetsPerZone.get())));
                }
                public final class _closure9
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure9(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("getProperty", "subnetId", 0, it);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure9.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "collect", 0, filtered, new _closure9((Object)this, this.getThisObject()));
            }

            @Generated
            public Object call(Object z, Object c) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, z, c);
            }

            @Generated
            public String getPurpose() {
                return IndyInterface.bootstrap("cast", "()", 0, this.purpose.get());
            }

            @Generated
            public Integer getMaxSubnetsPerZone() {
                return IndyInterface.bootstrap("cast", "()", 0, this.maxSubnetsPerZone.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getSubnetIdsForZones_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("invoke", "findResults", 0, IndyInterface.bootstrap("invoke", "subMap", 0, zonesToSubnets, zones), new _getSubnetIdsForZones_closure2(this, this, purpose2, maxSubnetsPerZone2))));
    }

    private Multimap<String, SubnetData> mapZonesToTargetSubnets(SubnetTarget target) {
        Reference target2 = new Reference((Object)target);
        public final class _mapZonesToTargetSubnets_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference target;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _mapZonesToTargetSubnets_closure3(Object _outerInstance, Object _thisObject, Reference target) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.target = reference = target;
            }

            public Object doCall(Object it) {
                return (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "target", 0, it)) == false || ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "target", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.target.get()))) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "purpose", 0, it));
            }

            @Generated
            public SubnetTarget getTarget() {
                return IndyInterface.bootstrap("cast", "()", 0, this.target.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mapZonesToTargetSubnets_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite targetSubnetsWithPurpose = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, this.allSubnets, new _mapZonesToTargetSubnets_closure3(this, this, target2)));
        public final class _mapZonesToTargetSubnets_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _mapZonesToTargetSubnets_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "availabilityZone", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mapZonesToTargetSubnets_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "index", 0, Multimaps.class, targetSubnetsWithPurpose, ScriptBytecodeAdapter.createPojoWrapper((Object)((Function)IndyInterface.bootstrap("invoke", "asType", 0, new _mapZonesToTargetSubnets_closure4(this, this), Function.class)), Function.class)));
    }

    public String getVpcIdForSubnetPurpose(String subnetPurpose) {
        String string;
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "mapPurposeToVpcId", 2, this), IndyInterface.bootstrap("cast", "()", 0, string = subnetPurpose) != false ? string : null));
    }

    public Map<String, String> mapPurposeToVpcId() {
        public final class _mapPurposeToVpcId_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _mapPurposeToVpcId_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "purpose", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mapPurposeToVpcId_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite subnetsGroupedByPurpose = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "groupBy", 0, this.allSubnets, new _mapPurposeToVpcId_closure5(this, this)));
        public final class _mapPurposeToVpcId_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _mapPurposeToVpcId_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Map purposeToVpcId, Map.Entry entry) {
                CallSite purpose = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "key", 0, entry));
                if (IndyInterface.bootstrap("cast", "()", 0, purpose) == false) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "defaultVpcId", 12, this)) != false) {
                        CallSite callSite = IndyInterface.bootstrap("getProperty", "defaultVpcId", 12, this);
                        IndyInterface.bootstrap("invoke", "putAt", 0, purposeToVpcId, null, callSite);
                    }
                    return purposeToVpcId;
                }
                List subnets = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "value", 0, entry), List.class));
                CallSite distinctVpcIds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "unique", 0, ScriptBytecodeAdapter.getPropertySpreadSafe(_mapPurposeToVpcId_closure6.class, (Object)subnets, (String)"vpcId")));
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, distinctVpcIds), (Object)1)) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "next", 0, IndyInterface.bootstrap("invoke", "iterator", 0, distinctVpcIds));
                    IndyInterface.bootstrap("invoke", "putAt", 0, purposeToVpcId, purpose, callSite);
                }
                return purposeToVpcId;
            }

            @Generated
            public Object call(Map purposeToVpcId, Map.Entry entry) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, purposeToVpcId, entry);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mapPurposeToVpcId_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return (Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "inject", 0, subnetsGroupedByPurpose, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), new _mapPurposeToVpcId_closure6(this, this)), Map.class));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SubnetAnalyzer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public String toString() {
        CallSite _result = IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class);
        Boolean $toStringFirst = Boolean.TRUE;
        IndyInterface.bootstrap("invoke", "append", 0, _result, "com.netflix.spinnaker.clouddriver.aws.model.SubnetAnalyzer(");
        if (IndyInterface.bootstrap("cast", "()", 0, $toStringFirst) != false) {
            $toStringFirst = Boolean.FALSE;
        } else {
            IndyInterface.bootstrap("invoke", "append", 0, _result, ", ");
        }
        IndyInterface.bootstrap("invoke", "append", 0, _result, IndyInterface.bootstrap("invoke", "toString", 0, FormatHelper.class, IndyInterface.bootstrap("invoke", "getAllSubnets", 2, this)));
        if (IndyInterface.bootstrap("cast", "()", 0, $toStringFirst) != false) {
            $toStringFirst = Boolean.FALSE;
        } else {
            IndyInterface.bootstrap("invoke", "append", 0, _result, ", ");
        }
        IndyInterface.bootstrap("invoke", "append", 0, _result, IndyInterface.bootstrap("invoke", "toString", 0, FormatHelper.class, IndyInterface.bootstrap("invoke", "getDefaultVpcId", 2, this)));
        IndyInterface.bootstrap("invoke", "append", 0, _result, ")");
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, _result));
    }

    @Generated
    public int hashCode() {
        CallSite _result = IndyInterface.bootstrap("invoke", "initHash", 0, HashCodeHelper.class);
        if (ScriptBytecodeAdapter.compareNotIdentical((Object)IndyInterface.bootstrap("invoke", "getAllSubnets", 2, this), (Object)this)) {
            _result = IndyInterface.bootstrap("invoke", "updateHash", 0, HashCodeHelper.class, _result, IndyInterface.bootstrap("invoke", "getAllSubnets", 2, this));
        }
        if (ScriptBytecodeAdapter.compareNotIdentical((Object)IndyInterface.bootstrap("invoke", "getDefaultVpcId", 2, this), (Object)this)) {
            _result = IndyInterface.bootstrap("invoke", "updateHash", 0, HashCodeHelper.class, _result, IndyInterface.bootstrap("invoke", "getDefaultVpcId", 2, this));
        }
        return DefaultTypeTransformation.intUnbox((Object)_result);
    }

    @Generated
    public boolean canEqual(Object other) {
        return other instanceof SubnetAnalyzer;
    }

    @Generated
    public boolean equals(Object other) {
        if (ScriptBytecodeAdapter.compareEqual(null, (Object)other)) {
            return false;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "is", 2, this, other)) != false) {
            return true;
        }
        if (!(other instanceof SubnetAnalyzer)) {
            return false;
        }
        SubnetAnalyzer otherTyped = (SubnetAnalyzer)other;
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "canEqual", 0, otherTyped, this)) == false) {
            return false;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getAllSubnets", 2, this), (Object)IndyInterface.bootstrap("invoke", "getAllSubnets", 0, otherTyped))) {
            return false;
        }
        return !(!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getDefaultVpcId", 2, this), (Object)IndyInterface.bootstrap("invoke", "getDefaultVpcId", 0, otherTyped)));
    }

    @Generated
    public static SubnetAnalyzer from(Collection<Subnet> subnets) {
        return SubnetAnalyzer.from(subnets, null);
    }

    @Generated
    public List<String> getSubnetIdsForZones(Collection<String> zones, String purpose, SubnetTarget target) {
        Reference purpose2 = new Reference((Object)purpose);
        return this.getSubnetIdsForZones(zones, (String)purpose2.get(), target, null);
    }

    @Generated
    public List<String> getSubnetIdsForZones(Collection<String> zones, String purpose) {
        Reference purpose2 = new Reference((Object)purpose);
        return this.getSubnetIdsForZones(zones, (String)purpose2.get(), null, null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public final Collection<SubnetData> getAllSubnets() {
        return this.allSubnets;
    }

    @Generated
    public final String getDefaultVpcId() {
        return this.defaultVpcId;
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }
}

