/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import com.amazonaws.services.elasticloadbalancingv2.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTagsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.Listener;
import com.amazonaws.services.elasticloadbalancingv2.model.ListenerNotFoundException;
import com.amazonaws.services.elasticloadbalancingv2.model.LoadBalancer;
import com.amazonaws.services.elasticloadbalancingv2.model.LoadBalancerAttribute;
import com.amazonaws.services.elasticloadbalancingv2.model.LoadBalancerNotFoundException;
import com.amazonaws.services.elasticloadbalancingv2.model.Rule;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetGroup;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetGroupAttribute;
import com.amazonaws.services.elasticloadbalancingv2.model.TargetHealthDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.aws.AmazonCloudProvider;
import com.netflix.spinnaker.clouddriver.aws.data.ArnUtils;
import com.netflix.spinnaker.clouddriver.aws.data.Keys;
import com.netflix.spinnaker.clouddriver.aws.edda.EddaApi;
import com.netflix.spinnaker.clouddriver.aws.model.InstanceTargetGroupState;
import com.netflix.spinnaker.clouddriver.aws.model.InstanceTargetGroups;
import com.netflix.spinnaker.clouddriver.aws.model.edda.EddaRule;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AbstractAmazonLoadBalancerCachingAgent;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonCachingAgentFilter;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.CacheHelpers;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.EddaTimeoutConfig;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.cache.OnDemandAgent;
import com.netflix.spinnaker.clouddriver.core.provider.agent.HealthProvidingCachingAgent;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class AmazonApplicationLoadBalancerCachingAgent
extends AbstractAmazonLoadBalancerCachingAgent
implements HealthProvidingCachingAgent {
    private final EddaApi eddaApi;
    private final EddaTimeoutConfig eddaTimeoutConfig;
    private static final Collection<AgentDataType> types;
    private static final String HEALTH_ID = "aws-load-balancer-v2-target-group-instance-health";
    private static final int DESCRIBE_TAG_LIMIT = 20;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AmazonApplicationLoadBalancerCachingAgent(AmazonCloudProvider amazonCloudProvider, AmazonClientProvider amazonClientProvider, NetflixAmazonCredentials account, String region, EddaApi eddaApi, ObjectMapper objectMapper, Registry registry, EddaTimeoutConfig eddaTimeoutConfig, AmazonCachingAgentFilter amazonCachingAgentFilter) {
        super(amazonCloudProvider, amazonClientProvider, account, region, objectMapper, registry, amazonCachingAgentFilter);
        EddaTimeoutConfig eddaTimeoutConfig2;
        EddaApi eddaApi2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.eddaApi = eddaApi2 = eddaApi;
        this.eddaTimeoutConfig = eddaTimeoutConfig2 = eddaTimeoutConfig;
    }

    public String getHealthId() {
        return HEALTH_ID;
    }

    public Optional<Map<String, String>> getCacheKeyPatterns() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "of", 0, Optional.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "getLoadBalancerKey", 0, Keys.class, "*", IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this), "vpc-????????", "*")})));
    }

    @Override
    public Collection<AgentDataType> getProvidedDataTypes() {
        return types;
    }

    /*
     * WARNING - void declaration
     */
    public OnDemandAgent.OnDemandResult handle(ProviderCache providerCache, Map<String, ? extends Object> data) {
        void var2_2;
        Reference providerCache2 = new Reference((Object)providerCache);
        Reference data2 = new Reference((Object)var2_2);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, (Map)data2.get(), "loadBalancerName")) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, (Map)data2.get(), "loadBalancerType")) == false || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equals", 0, IndyInterface.bootstrap("getProperty", "loadBalancerType", 0, (Map)data2.get()), "application")) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, (Map)data2.get(), "account")) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, (Map)data2.get(), "region")) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), (Object)IndyInterface.bootstrap("getProperty", "account", 0, (Map)data2.get()))) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "region", 12, this), (Object)IndyInterface.bootstrap("getProperty", "region", 0, (Map)data2.get()))) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Reference loadBalancing = new Reference((Object)IndyInterface.bootstrap("invoke", "getAmazonElasticLoadBalancingV2", 0, IndyInterface.bootstrap("getProperty", "amazonClientProvider", 12, this), IndyInterface.bootstrap("getProperty", "account", 12, this), IndyInterface.bootstrap("getProperty", "region", 12, this), true));
        public final class _handle_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference loadBalancing;
            private /* synthetic */ Reference data;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _handle_closure1(Object _outerInstance, Object _thisObject, Reference loadBalancing, Reference data) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.loadBalancing = reference2 = loadBalancing;
                this.data = reference = data;
            }

            public Object doCall(Object it) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "loadBalancers", 0, IndyInterface.bootstrap("invoke", "describeLoadBalancers", 0, this.loadBalancing.get(), IndyInterface.bootstrap("invoke", "withNames", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeLoadBalancersRequest.class), ScriptBytecodeAdapter.createList((Object[])new Object[]{(String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, IndyInterface.bootstrap("cast", "()", 0, this.data.get())), String.class))})))), false);
                try {
                    return callSite;
                }
                catch (LoadBalancerNotFoundException ignored) {
                    Object var4_4 = null;
                    return var4_4;
                }
            }

            @Generated
            public Object getLoadBalancing() {
                return this.loadBalancing.get();
            }

            @Generated
            public Map getData() {
                return IndyInterface.bootstrap("cast", "()", 0, this.data.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handle_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference loadBalancer = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "readData", 0, IndyInterface.bootstrap("getProperty", "metricsSupport", 12, this), new _handle_closure1(this, this, loadBalancing, data2))));
        public final class _handle_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference loadBalancing;
            private /* synthetic */ Reference loadBalancer;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _handle_closure2(Object _outerInstance, Object _thisObject, Reference loadBalancing, Reference loadBalancer) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.loadBalancing = reference2 = loadBalancing;
                this.loadBalancer = reference = loadBalancer;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "targetGroups", 0, IndyInterface.bootstrap("invoke", "describeTargetGroups", 0, this.loadBalancing.get(), IndyInterface.bootstrap("invoke", "withLoadBalancerArn", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeTargetGroupsRequest.class), IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get())))));
            }

            @Generated
            public Object getLoadBalancing() {
                return this.loadBalancing.get();
            }

            @Generated
            public LoadBalancer getLoadBalancer() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handle_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference targetGroups = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "readData", 0, IndyInterface.bootstrap("getProperty", "metricsSupport", 12, this), new _handle_closure2(this, this, loadBalancing, loadBalancer))));
        Reference targetGroupAssociations = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildTargetGroupAssociations", 2, this, loadBalancing.get(), (List)targetGroups.get(), false)));
        Reference listenerAssociations = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildListenerAssociations", 2, this, loadBalancing.get(), ScriptBytecodeAdapter.createList((Object[])new Object[]{(LoadBalancer)loadBalancer.get()}), false)));
        Reference loadBalancerAttributes = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildLoadBalancerAttributes", 2, this, loadBalancing.get(), ScriptBytecodeAdapter.createList((Object[])new Object[]{(LoadBalancer)loadBalancer.get()}), false)));
        public final class _handle_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference providerCache;
            private /* synthetic */ Reference loadBalancer;
            private /* synthetic */ Reference loadBalancerAttributes;
            private /* synthetic */ Reference targetGroups;
            private /* synthetic */ Reference targetGroupAssociations;
            private /* synthetic */ Reference listenerAssociations;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _handle_closure3(Object _outerInstance, Object _thisObject, Reference providerCache, Reference loadBalancer, Reference loadBalancerAttributes, Reference targetGroups, Reference targetGroupAssociations, Reference listenerAssociations) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                Reference reference6;
                this.providerCache = reference6 = providerCache;
                this.loadBalancer = reference5 = loadBalancer;
                this.loadBalancerAttributes = reference4 = loadBalancerAttributes;
                this.targetGroups = reference3 = targetGroups;
                this.targetGroupAssociations = reference2 = targetGroupAssociations;
                this.listenerAssociations = reference = listenerAssociations;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "buildCacheResult", 2, this, IndyInterface.bootstrap("cast", "()", 0, this.providerCache.get()), ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get())}), IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerAttributes.get()), IndyInterface.bootstrap("cast", "()", 0, this.targetGroups.get()), IndyInterface.bootstrap("cast", "()", 0, this.targetGroupAssociations.get()), IndyInterface.bootstrap("cast", "()", 0, this.listenerAssociations.get()), ScriptBytecodeAdapter.createMap((Object[])new Object[0]), IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class), ScriptBytecodeAdapter.createList((Object[])new Object[0]));
            }

            @Generated
            public ProviderCache getProviderCache() {
                return IndyInterface.bootstrap("cast", "()", 0, this.providerCache.get());
            }

            @Generated
            public LoadBalancer getLoadBalancer() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get());
            }

            @Generated
            public Map getLoadBalancerAttributes() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerAttributes.get());
            }

            @Generated
            public List getTargetGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.targetGroups.get());
            }

            @Generated
            public TargetGroupAssociations getTargetGroupAssociations() {
                return IndyInterface.bootstrap("cast", "()", 0, this.targetGroupAssociations.get());
            }

            @Generated
            public ListenerAssociations getListenerAssociations() {
                return IndyInterface.bootstrap("cast", "()", 0, this.listenerAssociations.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handle_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference cacheResult = new Reference((Object)IndyInterface.bootstrap("invoke", "transformData", 0, IndyInterface.bootstrap("getProperty", "metricsSupport", 12, this), new _handle_closure3(this, this, providerCache2, loadBalancer, loadBalancerAttributes, targetGroups, targetGroupAssociations, listenerAssociations)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("invoke", "values", 0, IndyInterface.bootstrap("getProperty", "cacheResults", 0, cacheResult.get()))))) != false) {
            IndyInterface.bootstrap("invoke", "evictDeletedItems", 0, (ProviderCache)providerCache2.get(), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "getLoadBalancerKey", 0, Keys.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, (Map)data2.get()), String.class))), String.class), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "vpcId", 0, (Map)data2.get()), String.class))), String.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "loadBalancerType", 0, (Map)data2.get()), String.class))), String.class))}));
        } else {
            public final class _handle_closure4
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference data;
                private /* synthetic */ Reference loadBalancer;
                private /* synthetic */ Reference cacheResult;
                private /* synthetic */ Reference providerCache;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _handle_closure4(Object _outerInstance, Object _thisObject, Reference data, Reference loadBalancer, Reference cacheResult, Reference providerCache) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    this.data = reference4 = data;
                    this.loadBalancer = reference3 = loadBalancer;
                    this.cacheResult = reference2 = cacheResult;
                    this.providerCache = reference = providerCache;
                }

                public Object doCall(Object it) {
                    CallSite cacheData = IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheData.class, IndyInterface.bootstrap("invoke", "getLoadBalancerKey", 0, Keys.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, IndyInterface.bootstrap("cast", "()", 0, this.data.get())), String.class))), String.class), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this), IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get())) != false ? IndyInterface.bootstrap("invoke", "getVpcId", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get())) : null, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "loadBalancerType", 0, IndyInterface.bootstrap("cast", "()", 0, this.data.get())), String.class))), String.class)), IndyInterface.bootstrap("invoke", "multiply", 0, 10, 60), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"cacheTime", IndyInterface.bootstrap("init", "<init>", 0, Date.class), "cacheResults", IndyInterface.bootstrap("invoke", "writeValueAsString", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), IndyInterface.bootstrap("getProperty", "cacheResults", 0, this.cacheResult.get()))}), ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                    return IndyInterface.bootstrap("invoke", "putCacheData", 0, IndyInterface.bootstrap("cast", "()", 0, this.providerCache.get()), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class)), cacheData);
                }

                @Generated
                public Map getData() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.data.get());
                }

                @Generated
                public LoadBalancer getLoadBalancer() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancer.get());
                }

                @Generated
                public Object getCacheResult() {
                    return this.cacheResult.get();
                }

                @Generated
                public ProviderCache getProviderCache() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.providerCache.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _handle_closure4.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "onDemandStore", 0, IndyInterface.bootstrap("getProperty", "metricsSupport", 12, this), new _handle_closure4(this, this, data2, loadBalancer, cacheResult, providerCache2));
        }
        Map evictions = IndyInterface.bootstrap("cast", "()", 0, (LoadBalancer)loadBalancer.get()) != false ? ScriptBytecodeAdapter.createMap((Object[])new Object[0]) : ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "getLoadBalancerKey", 0, Keys.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, (Map)data2.get()), String.class))), String.class), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "vpcId", 0, (Map)data2.get()), String.class))), String.class), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "loadBalancerType", 0, (Map)data2.get()), String.class))), String.class))})});
        IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{(Map)data2.get(), evictions}, new String[]{"onDemand cache refresh (data: ", ", evictions: ", ")"}));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, OnDemandAgent.OnDemandResult.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sourceAgentType", IndyInterface.bootstrap("invoke", "getAgentType", 2, this), "cacheResult", cacheResult.get(), "evictions", evictions})));
    }

    public TargetGroupAssociations buildTargetGroupAssociations(AmazonElasticLoadBalancing loadBalancing, List<TargetGroup> allTargetGroups, boolean useEdda) {
        CallSite targetGroupArnToHealths = null;
        CallSite targetGroupArnToAttributes = null;
        if (useEdda) {
            CallSite targetGroupAttributesList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "targetGroupAttributes", 0, this.eddaApi));
            CallSite targetGroupHealthList = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "targetGroupHealth", 0, this.eddaApi));
            public final class _buildTargetGroupAssociations_closure5
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _buildTargetGroupAssociations_closure5(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, it), IndyInterface.bootstrap("getProperty", "attributes", 0, it)});
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildTargetGroupAssociations_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            targetGroupArnToAttributes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, targetGroupAttributesList, new _buildTargetGroupAssociations_closure5(this, this)));
            public final class _buildTargetGroupAssociations_closure6
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _buildTargetGroupAssociations_closure6(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, it), IndyInterface.bootstrap("getProperty", "health", 0, it)});
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildTargetGroupAssociations_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            targetGroupArnToHealths = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, targetGroupHealthList, new _buildTargetGroupAssociations_closure6(this, this)));
        } else {
            targetGroupArnToHealths = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
            targetGroupArnToAttributes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
            CallSite targetGroup = null;
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, allTargetGroups));
            if (callSite != null) {
                while (callSite.hasNext()) {
                    targetGroup = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                    CallSite targetHealthDescriptions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "targetHealthDescriptions", 0, IndyInterface.bootstrap("invoke", "describeTargetHealth", 0, loadBalancing, IndyInterface.bootstrap("invoke", "withTargetGroupArn", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeTargetHealthRequest.class), IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, targetGroup)))));
                    IndyInterface.bootstrap("invoke", "put", 0, targetGroupArnToHealths, IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, targetGroup), targetHealthDescriptions);
                    CallSite targetGroupAttributes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, IndyInterface.bootstrap("invoke", "describeTargetGroupAttributes", 0, loadBalancing, IndyInterface.bootstrap("invoke", "withTargetGroupArn", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeTargetGroupAttributesRequest.class), IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, targetGroup)))));
                    IndyInterface.bootstrap("invoke", "put", 0, targetGroupArnToAttributes, IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, targetGroup), targetGroupAttributes);
                }
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"targetGroupArnToAttributes", targetGroupArnToAttributes, "targetGroupArnToHealths", targetGroupArnToHealths}));
    }

    public Map<String, List<LoadBalancerAttribute>> buildLoadBalancerAttributes(AmazonElasticLoadBalancing loadBalancing, List<LoadBalancer> allLoadBalancers, boolean useEdda) {
        CallSite loadBalancerArnToAttributes = null;
        if (useEdda) {
            public final class _buildLoadBalancerAttributes_closure7
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _buildLoadBalancerAttributes_closure7(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, it), IndyInterface.bootstrap("getProperty", "attributes", 0, it)});
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildLoadBalancerAttributes_closure7.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            loadBalancerArnToAttributes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "applicationLoadBalancerAttributes", 0, this.eddaApi), new _buildLoadBalancerAttributes_closure7(this, this)));
        } else {
            loadBalancerArnToAttributes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
            CallSite loadBalancer = null;
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, allLoadBalancers));
            if (callSite != null) {
                while (callSite.hasNext()) {
                    loadBalancer = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                    IndyInterface.bootstrap("invoke", "put", 0, loadBalancerArnToAttributes, IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, loadBalancer), IndyInterface.bootstrap("getProperty", "attributes", 0, IndyInterface.bootstrap("invoke", "describeLoadBalancerAttributes", 0, loadBalancing, IndyInterface.bootstrap("invoke", "withLoadBalancerArn", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeLoadBalancerAttributesRequest.class), IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, loadBalancer)))));
                }
            }
        }
        return loadBalancerArnToAttributes;
    }

    public ListenerAssociations buildListenerAssociations(AmazonElasticLoadBalancing loadBalancing, List<LoadBalancer> allLoadBalancers, boolean useEdda) {
        public final class _buildListenerAssociations_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildListenerAssociations_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, it), ScriptBytecodeAdapter.createList((Object[])new Object[0])});
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildListenerAssociations_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite loadBalancerArnToListeners = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, allLoadBalancers, new _buildListenerAssociations_closure8(this, this)));
        public final class _buildListenerAssociations_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildListenerAssociations_closure9(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildListenerAssociations_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference listenerToRules = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withDefault", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), new _buildListenerAssociations_closure9(this, this))));
        if (useEdda) {
            public final class _buildListenerAssociations_closure10
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _buildListenerAssociations_closure10(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Listener listener) {
                    return IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, listener);
                }

                @Generated
                public Object call(Listener listener) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, listener);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildListenerAssociations_closure10.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "putAll", 0, loadBalancerArnToListeners, IndyInterface.bootstrap("invoke", "groupBy", 0, IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("invoke", "allListeners", 0, this.eddaApi)), new _buildListenerAssociations_closure10(this, this)));
            public final class _buildListenerAssociations_closure11
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _buildListenerAssociations_closure11(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "listenerArn", 0, it), it});
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildListenerAssociations_closure11.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            Reference listenerByListenerArn = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("invoke", "values", 0, loadBalancerArnToListeners)), new _buildListenerAssociations_closure11(this, this))));
            public final class _buildListenerAssociations_closure12
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference listenerByListenerArn;
                private /* synthetic */ Reference listenerToRules;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _buildListenerAssociations_closure12(Object _outerInstance, Object _thisObject, Reference listenerByListenerArn, Reference listenerToRules) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.listenerByListenerArn = reference2 = listenerByListenerArn;
                    this.listenerToRules = reference = listenerToRules;
                }

                public Object doCall(EddaRule eddaRule) {
                    CallSite listener = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.listenerByListenerArn.get()), IndyInterface.bootstrap("getProperty", "listenerArn", 0, eddaRule));
                    if (IndyInterface.bootstrap("cast", "()", 0, listener) != false) {
                        return IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.listenerToRules.get()), listener), IndyInterface.bootstrap("getProperty", "rules", 0, eddaRule));
                    }
                    return null;
                }

                @Generated
                public Object call(EddaRule eddaRule) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, eddaRule);
                }

                @Generated
                public Map getListenerByListenerArn() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.listenerByListenerArn.get());
                }

                @Generated
                public Map getListenerToRules() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.listenerToRules.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildListenerAssociations_closure12.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("invoke", "allRules", 0, this.eddaApi)), new _buildListenerAssociations_closure12(this, this, listenerByListenerArn, listenerToRules));
        } else {
            CallSite lb = null;
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, allLoadBalancers));
            if (callSite != null) {
                while (callSite.hasNext()) {
                    lb = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                    CallSite listenerData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
                    CallSite describeListenersRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeListenersRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancerArn", IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, lb)})));
                    while (true) {
                        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "describeListeners", 0, loadBalancing, describeListenersRequest));
                        IndyInterface.bootstrap("invoke", "addAll", 0, listenerData, IndyInterface.bootstrap("getProperty", "listeners", 0, result));
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "nextMarker", 0, result)) == false) break;
                        IndyInterface.bootstrap("invoke", "withMarker", 0, describeListenersRequest, IndyInterface.bootstrap("getProperty", "nextMarker", 0, result));
                    }
                    IndyInterface.bootstrap("invoke", "put", 0, loadBalancerArnToListeners, IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, lb), listenerData);
                    Object listener = null;
                    CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, listenerData));
                    if (callSite2 == null) continue;
                    while (callSite2.hasNext()) {
                        listener = callSite2.next();
                        try {
                            CallSite describeRulesRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeRulesRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"listenerArn", IndyInterface.bootstrap("getProperty", "listenerArn", 0, listener)})));
                            CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "describeRules", 0, loadBalancing, describeRulesRequest));
                            IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("invoke", "get", 0, (Map)listenerToRules.get(), listener), IndyInterface.bootstrap("getProperty", "rules", 0, result));
                        }
                        catch (ListenerNotFoundException ignore) {
                        }
                    }
                }
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"loadBalancerArnToListeners", loadBalancerArnToListeners, "listenerToRules", (Map)listenerToRules.get()}));
    }

    @Override
    public CacheResult loadDataInternal(ProviderCache providerCache) {
        Reference loadBalancing = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAmazonElasticLoadBalancingV2", 0, IndyInterface.bootstrap("getProperty", "amazonClientProvider", 12, this), IndyInterface.bootstrap("getProperty", "account", 12, this), IndyInterface.bootstrap("getProperty", "region", 12, this))));
        boolean useEdda = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "eddaEnabled", 0, IndyInterface.bootstrap("getProperty", "account", 12, this))) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "albEnabled", 0, this.eddaTimeoutConfig));
        Reference start = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, useEdda ? null : IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class)));
        Object allLoadBalancers = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        CallSite describeLoadBalancerRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeLoadBalancersRequest.class));
        while (true) {
            CallSite resp = IndyInterface.bootstrap("invoke", "describeLoadBalancers", 0, (AmazonElasticLoadBalancing)loadBalancing.get(), describeLoadBalancerRequest);
            if (useEdda) {
                CallSite callSite = IndyInterface.bootstrap("getProperty", "lastModified", 0, IndyInterface.bootstrap("getProperty", "amazonClientProvider", 12, this));
                start.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : Integer.valueOf(0)));
            }
            IndyInterface.bootstrap("invoke", "addAll", 0, allLoadBalancers, IndyInterface.bootstrap("getProperty", "loadBalancers", 0, resp));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "nextMarker", 0, resp)) == false) break;
            IndyInterface.bootstrap("invoke", "withMarker", 0, describeLoadBalancerRequest, IndyInterface.bootstrap("getProperty", "nextMarker", 0, resp));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTagFilter", 0, IndyInterface.bootstrap("getProperty", "amazonCachingAgentFilter", 12, this))) != false) {
            CallSite loadBalancerPartitions = IndyInterface.bootstrap("invoke", "collate", 0, ScriptBytecodeAdapter.getPropertySpreadSafe(AmazonApplicationLoadBalancerCachingAgent.class, (Object)allLoadBalancers, (String)"loadBalancerArn"), DESCRIBE_TAG_LIMIT);
            Reference loadBalancerTags = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
            public final class _loadDataInternal_closure13
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancing;
                private /* synthetic */ Reference loadBalancerTags;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _loadDataInternal_closure13(Object _outerInstance, Object _thisObject, Reference loadBalancing, Reference loadBalancerTags) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.loadBalancing = reference2 = loadBalancing;
                    this.loadBalancerTags = reference = loadBalancerTags;
                }

                public Object doCall(Object loadBalancerPartition) {
                    CallSite tagsRequest = IndyInterface.bootstrap("invoke", "withResourceArns", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeTagsRequest.class), loadBalancerPartition);
                    CallSite tagsResponse = IndyInterface.bootstrap("invoke", "describeTags", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get()), tagsRequest);
                    public final class _closure35
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure35(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            public final class _closure36
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure36(Object _outerInstance, Object _thisObject) {
                                    super(_outerInstance, _thisObject);
                                }

                                public Object doCall(Object it) {
                                    return IndyInterface.bootstrap("init", "<init>", 0, AmazonCachingAgentFilter.ResourceTag.class, IndyInterface.bootstrap("getProperty", "key", 0, it), IndyInterface.bootstrap("getProperty", "value", 0, it));
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure36.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "resourceArn", 0, it), IndyInterface.bootstrap("invoke", "collect", 1, IndyInterface.bootstrap("getProperty", "tags", 0, it), new _closure36((Object)this, this.getThisObject()))});
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure35.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "putAll", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerTags.get()), IndyInterface.bootstrap("invoke", "collectEntries", 1, IndyInterface.bootstrap("getProperty", "tagDescriptions", 0, tagsResponse), new _closure35((Object)this, this.getThisObject())));
                }

                @Generated
                public AmazonElasticLoadBalancing getLoadBalancing() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancing.get());
                }

                @Generated
                public Map getLoadBalancerTags() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerTags.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadDataInternal_closure13.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, loadBalancerPartitions, new _loadDataInternal_closure13(this, this, loadBalancing, loadBalancerTags));
            public final class _loadDataInternal_closure14
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference loadBalancerTags;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _loadDataInternal_closure14(Object _outerInstance, Object _thisObject, Reference loadBalancerTags) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.loadBalancerTags = reference = loadBalancerTags;
                }

                public Object doCall(Object lb) {
                    return IndyInterface.bootstrap("invoke", "shouldRetainResource", 0, IndyInterface.bootstrap("getProperty", "amazonCachingAgentFilter", 12, this), IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerTags.get()), IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, lb)));
                }

                @Generated
                public Map getLoadBalancerTags() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerTags.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadDataInternal_closure14.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            allLoadBalancers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, allLoadBalancers, new _loadDataInternal_closure14(this, this, loadBalancerTags)));
        }
        CallSite loadBalancerAttributes = IndyInterface.bootstrap("invoke", "buildLoadBalancerAttributes", 2, this, (AmazonElasticLoadBalancing)loadBalancing.get(), allLoadBalancers, useEdda);
        List allTargetGroups = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        CallSite describeTargetGroupsRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeTargetGroupsRequest.class));
        Reference allLoadBalancerArns = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashSet.class, ScriptBytecodeAdapter.getPropertySpreadSafe(AmazonApplicationLoadBalancerCachingAgent.class, (Object)allLoadBalancers, (String)"loadBalancerArn"))));
        while (true) {
            CallSite resp = IndyInterface.bootstrap("invoke", "describeTargetGroups", 0, (AmazonElasticLoadBalancing)loadBalancing.get(), describeTargetGroupsRequest);
            CallSite targetGroups = IndyInterface.bootstrap("getProperty", "targetGroups", 0, resp);
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasTagFilter", 0, IndyInterface.bootstrap("getProperty", "amazonCachingAgentFilter", 12, this))) != false) {
                public final class _loadDataInternal_closure15
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference allLoadBalancerArns;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _loadDataInternal_closure15(Object _outerInstance, Object _thisObject, Reference allLoadBalancerArns) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.allLoadBalancerArns = reference = allLoadBalancerArns;
                    }

                    public Object doCall(Object tg) {
                        public final class _closure37
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference allLoadBalancerArns;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure37(Object _outerInstance, Object _thisObject, Reference allLoadBalancerArns) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.allLoadBalancerArns = reference = allLoadBalancerArns;
                            }

                            public Object doCall(Object tgLB) {
                                return IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("cast", "()", 0, this.allLoadBalancerArns.get()), tgLB);
                            }

                            @Generated
                            public HashSet getAllLoadBalancerArns() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.allLoadBalancerArns.get());
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure37.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "find", 1, IndyInterface.bootstrap("getProperty", "loadBalancerArns", 0, tg), new _closure37((Object)this, this.getThisObject(), this.allLoadBalancerArns)), null);
                    }

                    @Generated
                    public HashSet getAllLoadBalancerArns() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.allLoadBalancerArns.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _loadDataInternal_closure15.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "retainAll", 1, targetGroups, new _loadDataInternal_closure15(this, this, allLoadBalancerArns));
            }
            IndyInterface.bootstrap("invoke", "addAll", 0, allTargetGroups, targetGroups);
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "nextMarker", 0, resp)) == false) break;
            IndyInterface.bootstrap("invoke", "withMarker", 0, describeTargetGroupsRequest, IndyInterface.bootstrap("getProperty", "nextMarker", 0, resp));
        }
        CallSite targetGroupAssociations = IndyInterface.bootstrap("invoke", "buildTargetGroupAssociations", 2, this, (AmazonElasticLoadBalancing)loadBalancing.get(), allTargetGroups, useEdda);
        CallSite listenerAssociations = IndyInterface.bootstrap("invoke", "buildListenerAssociations", 2, this, (AmazonElasticLoadBalancing)loadBalancing.get(), allLoadBalancers, useEdda);
        if (IndyInterface.bootstrap("cast", "()", 0, (Long)start.get()) == false) {
            if (useEdda && DefaultTypeTransformation.booleanUnbox((Object)allTargetGroups)) {
                IndyInterface.bootstrap("invoke", "warn", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"", " did not receive lastModified value in response metadata"}));
            }
            start.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class)));
        }
        Reference evictableOnDemandCacheDatas = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        Reference usableOnDemandCacheDatas = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _loadDataInternal_closure16
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadDataInternal_closure16(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getLoadBalancerKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, it), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this), IndyInterface.bootstrap("invoke", "getVpcId", 0, it), IndyInterface.bootstrap("invoke", "getType", 0, it));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadDataInternal_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference loadBalancerKeys = new Reference((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "collect", 0, allLoadBalancers, new _loadDataInternal_closure16(this, this)), Set.class))));
        public final class _loadDataInternal_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference loadBalancerKeys;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadDataInternal_closure17(Object _outerInstance, Object _thisObject, Reference loadBalancerKeys) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.loadBalancerKeys = reference = loadBalancerKeys;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "contains", 0, this.loadBalancerKeys.get(), it);
            }

            @Generated
            public Object getLoadBalancerKeys() {
                return this.loadBalancerKeys.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadDataInternal_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite pendingOnDemandRequestKeys = IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, providerCache, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "getLoadBalancerKey", 0, Keys.class, "*", IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this), "*", "*")), new _loadDataInternal_closure17(this, this, loadBalancerKeys));
        CallSite pendingOnDemandRequestsForLoadBalancers = IndyInterface.bootstrap("invoke", "getAll", 0, providerCache, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class)), pendingOnDemandRequestKeys);
        public final class _loadDataInternal_closure18
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference start;
            private /* synthetic */ Reference evictableOnDemandCacheDatas;
            private /* synthetic */ Reference usableOnDemandCacheDatas;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadDataInternal_closure18(Object _outerInstance, Object _thisObject, Reference start, Reference evictableOnDemandCacheDatas, Reference usableOnDemandCacheDatas) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.start = reference3 = start;
                this.evictableOnDemandCacheDatas = reference2 = evictableOnDemandCacheDatas;
                this.usableOnDemandCacheDatas = reference = usableOnDemandCacheDatas;
            }

            public Object doCall(Object it) {
                if (ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("getProperty", "cacheTime", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it)), (Object)IndyInterface.bootstrap("cast", "()", 0, this.start.get()))) {
                    return IndyInterface.bootstrap("invoke", "leftShift", 0, this.evictableOnDemandCacheDatas.get(), it);
                }
                return IndyInterface.bootstrap("invoke", "leftShift", 0, this.usableOnDemandCacheDatas.get(), it);
            }

            @Generated
            public Long getStart() {
                return IndyInterface.bootstrap("cast", "()", 0, this.start.get());
            }

            @Generated
            public Object getEvictableOnDemandCacheDatas() {
                return this.evictableOnDemandCacheDatas.get();
            }

            @Generated
            public Object getUsableOnDemandCacheDatas() {
                return this.usableOnDemandCacheDatas.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadDataInternal_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, pendingOnDemandRequestsForLoadBalancers, new _loadDataInternal_closure18(this, this, start, evictableOnDemandCacheDatas, usableOnDemandCacheDatas));
        public final class _loadDataInternal_closure19
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _loadDataInternal_closure19(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, it), it});
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _loadDataInternal_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildCacheResult", 2, this, providerCache, allLoadBalancers, loadBalancerAttributes, allTargetGroups, targetGroupAssociations, listenerAssociations, IndyInterface.bootstrap("invoke", "collectEntries", 0, usableOnDemandCacheDatas.get(), new _loadDataInternal_closure19(this, this)), (Long)start.get(), evictableOnDemandCacheDatas.get()));
    }

    @Override
    public Collection<Map<String, Object>> pendingOnDemandRequests(ProviderCache providerCache) {
        CallSite keys = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, providerCache, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "getLoadBalancerKey", 0, Keys.class, "*", "*", "*", "*", "*")));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, keys)) != false) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        }
        public final class _pendingOnDemandRequests_closure20
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _pendingOnDemandRequests_closure20(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite details = IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, it));
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", IndyInterface.bootstrap("getProperty", "id", 0, it), "details", details, "cacheTime", IndyInterface.bootstrap("getProperty", "cacheTime", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it)), "cacheExpiry", IndyInterface.bootstrap("getProperty", "cacheExpiry", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it)), "processedTime", IndyInterface.bootstrap("getProperty", "processedTime", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it))});
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _pendingOnDemandRequests_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "getAll", 0, providerCache, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class)), keys, IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class)), new _pendingOnDemandRequests_closure20(this, this)));
    }

    private CacheResult buildCacheResult(ProviderCache providerCache, Collection<LoadBalancer> allLoadBalancers, Map<String, List> loadBalancerAttributes, Collection<TargetGroup> allTargetGroups, TargetGroupAssociations targetGroupAssociations, ListenerAssociations listenerAssociations, Map<String, CacheData> onDemandCacheDataByLb, long start, Collection<CacheData> evictableOnDemandCacheDatas) {
        Reference start2 = new Reference((Object)start);
        CallSite loadBalancers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "cache", 0, CacheHelpers.class));
        CallSite targetGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "cache", 0, CacheHelpers.class));
        public final class _buildCacheResult_closure21
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildCacheResult_closure21(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "targetGroupName", 0, it), IndyInterface.bootstrap("getProperty", "targetType", 0, it)});
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildCacheResult_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite targetGroupNameToType = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, allTargetGroups, new _buildCacheResult_closure21(this, this)));
        CallSite lb = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, allLoadBalancers));
        if (callSite != null) {
            while (callSite.hasNext()) {
                lb = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                CallSite loadBalancerKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getLoadBalancerKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "loadBalancerName", 0, lb), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this), IndyInterface.bootstrap("getProperty", "vpcId", 0, lb), IndyInterface.bootstrap("getProperty", "type", 0, lb)));
                CallSite onDemandCacheData = IndyInterface.bootstrap("cast", "()", 0, onDemandCacheDataByLb) != false ? IndyInterface.bootstrap("invoke", "getAt", 0, onDemandCacheDataByLb, loadBalancerKey) : null;
                if (IndyInterface.bootstrap("cast", "()", 0, onDemandCacheData) != false) {
                    IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, onDemandCacheData)}, new String[]{"Using onDemand cache value (", ")"}));
                    CallSite cacheResults = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "readValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "cacheResults", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, onDemandCacheData)), String.class))), String.class), new GroovyObject(this){
                        final /* synthetic */ AmazonApplicationLoadBalancerCachingAgent this$0;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private transient /* synthetic */ MetaClass metaClass;
                        {
                            MetaClass metaClass;
                            AmazonApplicationLoadBalancerCachingAgent amazonApplicationLoadBalancerCachingAgent;
                            this.this$0 = amazonApplicationLoadBalancerCachingAgent = p0;
                            this.metaClass = metaClass = this.$getStaticMetaClass();
                        }

                        public /* synthetic */ Object methodMissing(String name, Object args) {
                            try {
                                return this.this$0.this$dist$invoke$2(name, args);
                            }
                            catch (MissingMethodException notFound) {
                                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound)));
                            }
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                            if (!(args instanceof Object[] == false)) ** GOTO lbl8
                            var2_2 = ScriptBytecodeAdapter.invokeMethodN(1.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
                            return var2_2;
lbl8:
                            // 1 sources

                            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
                            var3_3 = ScriptBytecodeAdapter.invokeMethodN(1.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
                            return var3_3;
lbl14:
                            // 1 sources

                            var4_4 = ScriptBytecodeAdapter.invokeMethodN(1.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
                            try {
                                return var4_4;
                            }
                            catch (MissingMethodException notFound) {
                                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
                            }
                        }

                        public /* synthetic */ void propertyMissing(String name, Object value) {
                            try {
                                this.this$0.this$dist$set$2(name, value);
                                return;
                            }
                            catch (MissingPropertyException notFound) {
                                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                            }
                        }

                        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
                            try {
                                Object object = value;
                                ScriptBytecodeAdapter.setProperty((Object)object, null, AmazonApplicationLoadBalancerCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                            }
                            catch (MissingPropertyException notFound) {
                                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                            }
                        }

                        public /* synthetic */ Object propertyMissing(String name) {
                            try {
                                return this.this$0.this$dist$get$2(name);
                            }
                            catch (MissingPropertyException notFound) {
                                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                            }
                        }

                        public static /* synthetic */ Object $static_propertyMissing(String name) {
                            Object object = ScriptBytecodeAdapter.getProperty(1.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
                            try {
                                return object;
                            }
                            catch (MissingPropertyException notFound) {
                                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
                            }
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != 1.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        @Generated
                        @Internal
                        @Transient
                        public MetaClass getMetaClass() {
                            MetaClass metaClass = this.metaClass;
                            if (metaClass != null) {
                                return metaClass;
                            }
                            this.metaClass = this.$getStaticMetaClass();
                            return this.metaClass;
                        }

                        @Generated
                        @Internal
                        public void setMetaClass(MetaClass metaClass) {
                            this.metaClass = metaClass;
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }));
                    IndyInterface.bootstrap("invoke", "cache", 0, CacheHelpers.class, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, "loadBalancers"), loadBalancers);
                    IndyInterface.bootstrap("invoke", "cache", 0, CacheHelpers.class, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, "targetGroups"), targetGroups);
                    continue;
                }
                Reference lbAttributes = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), lb, IndyInterface.bootstrap("getProperty", "ATTRIBUTES", 12, this))));
                CallSite callSite2 = IndyInterface.bootstrap("getProperty", "type", 0, (Map)lbAttributes.get());
                ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)((Map)lbAttributes.get()), (String)"loadBalancerType");
                IndyInterface.bootstrap("invoke", "remove", 0, (Map)lbAttributes.get(), "type");
                Reference availabilityZones = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class)));
                Reference subnets = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class)));
                public final class _buildCacheResult_closure22
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference availabilityZones;
                    private /* synthetic */ Reference subnets;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _buildCacheResult_closure22(Object _outerInstance, Object _thisObject, Reference availabilityZones, Reference subnets) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.availabilityZones = reference2 = availabilityZones;
                        this.subnets = reference = subnets;
                    }

                    public Object doCall(Object az) {
                        IndyInterface.bootstrap("invoke", "push", 0, IndyInterface.bootstrap("cast", "()", 0, this.availabilityZones.get()), IndyInterface.bootstrap("getProperty", "zoneName", 0, az));
                        return IndyInterface.bootstrap("invoke", "push", 0, IndyInterface.bootstrap("cast", "()", 0, this.subnets.get()), IndyInterface.bootstrap("getProperty", "subnetId", 0, az));
                    }

                    @Generated
                    public List getAvailabilityZones() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.availabilityZones.get());
                    }

                    @Generated
                    public List getSubnets() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.subnets.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildCacheResult_closure22.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "availabilityZones", 0, (Map)lbAttributes.get())), new _buildCacheResult_closure22(this, this, availabilityZones, subnets));
                List list = (List)subnets.get();
                ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)((Map)lbAttributes.get()), (String)"subnets");
                List list2 = (List)availabilityZones.get();
                ScriptBytecodeAdapter.setProperty((Object)list2, null, (Object)((Map)lbAttributes.get()), (String)"availabilityZones");
                List listeners = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                Reference allTargetGroupKeys = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0])));
                CallSite vpcId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "vpcId", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, loadBalancerKey)));
                CallSite listenerData = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "loadBalancerArnToListeners", 4, listenerAssociations), IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, lb));
                CallSite listener = null;
                CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, listenerData));
                if (callSite3 != null) {
                    while (callSite3.hasNext()) {
                        listener = IndyInterface.bootstrap("cast", "()", 0, callSite3.next());
                        CallSite listenerAttributes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), listener, IndyInterface.bootstrap("getProperty", "ATTRIBUTES", 12, this)));
                        CallSite callSite4 = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "extractLoadBalancerName", 0, ArnUtils.class, ScriptBytecodeAdapter.createPojoWrapper((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, listenerAttributes)), String.class)));
                        ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)listenerAttributes, (String)"loadBalancerName");
                        IndyInterface.bootstrap("invoke", "remove", 0, listenerAttributes, "loadBalancerArn");
                        CallSite action = null;
                        CallSite callSite5 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "defaultActions", 0, listenerAttributes))));
                        if (callSite5 != null) {
                            while (callSite5.hasNext()) {
                                action = IndyInterface.bootstrap("cast", "()", 0, callSite5.next());
                                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, action)) == false) continue;
                                CallSite targetGroupName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "extractTargetGroupName", 0, ArnUtils.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, action), String.class))), String.class))));
                                CallSite callSite6 = targetGroupName;
                                ScriptBytecodeAdapter.setProperty((Object)callSite6, null, (Object)action, (String)"targetGroupName");
                                IndyInterface.bootstrap("invoke", "remove", 0, action, "targetGroupArn");
                                CallSite type = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, targetGroupNameToType, targetGroupName));
                                IndyInterface.bootstrap("invoke", "add", 0, (Set)allTargetGroupKeys.get(), IndyInterface.bootstrap("invoke", "getTargetGroupKey", 0, Keys.class, targetGroupName, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this), type, vpcId));
                            }
                        }
                        CallSite rules = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
                        CallSite rule = null;
                        CallSite callSite7 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "listenerToRules", 4, listenerAssociations), listener)));
                        if (callSite7 != null) {
                            while (callSite7.hasNext()) {
                                rule = IndyInterface.bootstrap("cast", "()", 0, callSite7.next());
                                CallSite ruleAttributes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), rule, IndyInterface.bootstrap("getProperty", "ATTRIBUTES", 12, this)));
                                CallSite action2 = null;
                                CallSite callSite8 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "actions", 0, ruleAttributes))));
                                if (callSite8 != null) {
                                    while (callSite8.hasNext()) {
                                        action2 = IndyInterface.bootstrap("cast", "()", 0, callSite8.next());
                                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, action2)) == false) continue;
                                        CallSite targetGroupName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "extractTargetGroupName", 0, ArnUtils.class, IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, action2))));
                                        CallSite callSite9 = targetGroupName;
                                        ScriptBytecodeAdapter.setProperty((Object)callSite9, null, (Object)action2, (String)"targetGroupName");
                                        IndyInterface.bootstrap("invoke", "remove", 0, action2, "targetGroupArn");
                                        CallSite type = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, targetGroupNameToType, targetGroupName));
                                        IndyInterface.bootstrap("invoke", "add", 0, (Set)allTargetGroupKeys.get(), IndyInterface.bootstrap("invoke", "getTargetGroupKey", 0, Keys.class, targetGroupName, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this), type, vpcId));
                                    }
                                }
                                IndyInterface.bootstrap("invoke", "push", 0, rules, ruleAttributes);
                            }
                        }
                        CallSite callSite10 = rules;
                        ScriptBytecodeAdapter.setProperty((Object)callSite10, null, (Object)listenerAttributes, (String)"rules");
                        IndyInterface.bootstrap("invoke", "push", 0, listeners, listenerAttributes);
                    }
                }
                List list3 = listeners;
                ScriptBytecodeAdapter.setProperty((Object)list3, null, (Object)((Map)lbAttributes.get()), (String)"listeners");
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, loadBalancerAttributes, IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, lb))) != false) {
                    CallSite callSite11 = IndyInterface.bootstrap("invoke", "get", 0, loadBalancerAttributes, IndyInterface.bootstrap("getProperty", "loadBalancerArn", 0, lb));
                    ScriptBytecodeAdapter.setProperty((Object)callSite11, null, (Object)((Map)lbAttributes.get()), (String)"attributes");
                    public final class _buildCacheResult_closure23
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _buildCacheResult_closure23(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)"deletion_protection.enabled");
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _buildCacheResult_closure23.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite deletionProtectionAttribute = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 1, IndyInterface.bootstrap("getProperty", "attributes", 0, (Map)lbAttributes.get()), new _buildCacheResult_closure23(this, this)));
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)deletionProtectionAttribute, null)) {
                        CallSite callSite12 = IndyInterface.bootstrap("invoke", "parseBoolean", 0, Boolean.class, IndyInterface.bootstrap("invoke", "getValue", 0, deletionProtectionAttribute));
                        ScriptBytecodeAdapter.setProperty((Object)callSite12, null, (Object)((Map)lbAttributes.get()), (String)"deletionProtection");
                    }
                    public final class _buildCacheResult_closure24
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _buildCacheResult_closure24(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)"load_balancing.cross_zone.enabled");
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _buildCacheResult_closure24.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite loadBalancingCrossZoneAttribute = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 1, IndyInterface.bootstrap("getProperty", "attributes", 0, (Map)lbAttributes.get()), new _buildCacheResult_closure24(this, this)));
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)loadBalancingCrossZoneAttribute, null)) {
                        CallSite callSite13 = IndyInterface.bootstrap("invoke", "parseBoolean", 0, Boolean.class, IndyInterface.bootstrap("invoke", "getValue", 0, loadBalancingCrossZoneAttribute));
                        ScriptBytecodeAdapter.setProperty((Object)callSite13, null, (Object)((Map)lbAttributes.get()), (String)"loadBalancingCrossZone");
                    }
                    public final class _buildCacheResult_closure25
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _buildCacheResult_closure25(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)"idle_timeout.timeout_seconds");
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _buildCacheResult_closure25.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite idleTimeoutAttribute = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 1, IndyInterface.bootstrap("getProperty", "attributes", 0, (Map)lbAttributes.get()), new _buildCacheResult_closure25(this, this)));
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)idleTimeoutAttribute, null)) {
                        CallSite callSite14 = IndyInterface.bootstrap("invoke", "parseInt", 0, Integer.class, IndyInterface.bootstrap("invoke", "getValue", 0, idleTimeoutAttribute));
                        ScriptBytecodeAdapter.setProperty((Object)callSite14, null, (Object)((Map)lbAttributes.get()), (String)"idleTimeout");
                    }
                }
                public final class _buildCacheResult_closure26
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference lbAttributes;
                    private /* synthetic */ Reference allTargetGroupKeys;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _buildCacheResult_closure26(Object _outerInstance, Object _thisObject, Reference lbAttributes, Reference allTargetGroupKeys) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.lbAttributes = reference2 = lbAttributes;
                        this.allTargetGroupKeys = reference = allTargetGroupKeys;
                    }

                    public Object doCall(Object it) {
                        IndyInterface.bootstrap("invoke", "putAll", 0, IndyInterface.bootstrap("getProperty", "attributes", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.lbAttributes.get()));
                        return IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TARGET_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("cast", "()", 0, this.allTargetGroupKeys.get()));
                    }

                    @Generated
                    public Map getLbAttributes() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.lbAttributes.get());
                    }

                    @Generated
                    public Set getAllTargetGroupKeys() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.allTargetGroupKeys.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildCacheResult_closure26.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "with", 0, IndyInterface.bootstrap("invoke", "getAt", 0, loadBalancers, loadBalancerKey), new _buildCacheResult_closure26(this, this, lbAttributes, allTargetGroupKeys));
            }
        }
        List instanceTargetGroupStates = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Reference targetGroup = new Reference(null);
        CallSite callSite15 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, allTargetGroups));
        if (callSite15 != null) {
            while (callSite15.hasNext()) {
                targetGroup.set((Object)IndyInterface.bootstrap("cast", "()", 0, callSite15.next()));
                Reference targetGroupId = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTargetGroupKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "targetGroupName", 0, (TargetGroup)targetGroup.get()), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this), IndyInterface.bootstrap("getProperty", "targetType", 0, (TargetGroup)targetGroup.get()), IndyInterface.bootstrap("getProperty", "vpcId", 0, (TargetGroup)targetGroup.get()))));
                public final class _buildCacheResult_closure27
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference targetGroup;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _buildCacheResult_closure27(Object _outerInstance, Object _thisObject, Reference targetGroup) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.targetGroup = reference = targetGroup;
                    }

                    public Object doCall(Object it) {
                        CallSite lbName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "extractLoadBalancerName", 0, ArnUtils.class, it)));
                        CallSite lbType = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractLoadBalancerType", 0, ArnUtils.class, it));
                        return IndyInterface.bootstrap("invoke", "getLoadBalancerKey", 0, Keys.class, lbName, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this), IndyInterface.bootstrap("getProperty", "vpcId", 0, IndyInterface.bootstrap("cast", "()", 0, this.targetGroup.get())), lbType);
                    }

                    @Generated
                    public TargetGroup getTargetGroup() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.targetGroup.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildCacheResult_closure27.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Reference loadBalancerIds = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "loadBalancerArns", 0, (TargetGroup)targetGroup.get()), new _buildCacheResult_closure27(this, this, targetGroup))));
                CallSite instanceIds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
                CallSite targetHealthDescriptions = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "targetGroupArnToHealths", 4, targetGroupAssociations), IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, (TargetGroup)targetGroup.get())));
                CallSite targetHealthDescription = null;
                CallSite callSite16 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, targetHealthDescriptions));
                if (callSite16 != null) {
                    while (callSite16.hasNext()) {
                        targetHealthDescription = IndyInterface.bootstrap("cast", "()", 0, callSite16.next());
                        IndyInterface.bootstrap("invoke", "leftShift", 0, instanceTargetGroupStates, IndyInterface.bootstrap("init", "<init>", 0, InstanceTargetGroupState.class, IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("getProperty", "target", 0, targetHealthDescription)), IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "extractTargetGroupName", 0, ArnUtils.class, IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, (TargetGroup)targetGroup.get()))), IndyInterface.bootstrap("getProperty", "state", 0, IndyInterface.bootstrap("getProperty", "targetHealth", 0, targetHealthDescription)), IndyInterface.bootstrap("getProperty", "reason", 0, IndyInterface.bootstrap("getProperty", "targetHealth", 0, targetHealthDescription)), IndyInterface.bootstrap("getProperty", "description", 0, IndyInterface.bootstrap("getProperty", "targetHealth", 0, targetHealthDescription))));
                        IndyInterface.bootstrap("invoke", "leftShift", 0, instanceIds, IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("getProperty", "target", 0, targetHealthDescription)));
                    }
                }
                public final class _buildCacheResult_closure28
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _buildCacheResult_closure28(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "key", 0, it), IndyInterface.bootstrap("getProperty", "value", 0, it)});
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildCacheResult_closure28.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite tgAttributes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 1, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "targetGroupArnToAttributes", 4, targetGroupAssociations), IndyInterface.bootstrap("getProperty", "targetGroupArn", 0, (TargetGroup)targetGroup.get())), new _buildCacheResult_closure28(this, this)));
                Reference tgCacheAttributes = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), (TargetGroup)targetGroup.get(), IndyInterface.bootstrap("getProperty", "ATTRIBUTES", 12, this))));
                IndyInterface.bootstrap("invoke", "put", 0, (Map)tgCacheAttributes.get(), "instances", instanceIds);
                IndyInterface.bootstrap("invoke", "put", 0, (Map)tgCacheAttributes.get(), "attributes", tgAttributes);
                public final class _buildCacheResult_closure29
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _buildCacheResult_closure29(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(String lbArn) {
                        return IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "extractLoadBalancerName", 0, ArnUtils.class, lbArn));
                    }

                    @Generated
                    public Object call(String lbArn) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, lbArn);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildCacheResult_closure29.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite17 = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "loadBalancerArns", 0, (Map)tgCacheAttributes.get()), new _buildCacheResult_closure29(this, this));
                ScriptBytecodeAdapter.setProperty((Object)callSite17, null, (Object)((Map)tgCacheAttributes.get()), (String)"loadBalancerNames");
                IndyInterface.bootstrap("invoke", "remove", 0, (Map)tgCacheAttributes.get(), "loadBalancerArns");
                public final class _buildCacheResult_closure30
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference tgCacheAttributes;
                    private /* synthetic */ Reference loadBalancerIds;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _buildCacheResult_closure30(Object _outerInstance, Object _thisObject, Reference tgCacheAttributes, Reference loadBalancerIds) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.tgCacheAttributes = reference2 = tgCacheAttributes;
                        this.loadBalancerIds = reference = loadBalancerIds;
                    }

                    public Object doCall(Object it) {
                        IndyInterface.bootstrap("invoke", "putAll", 0, IndyInterface.bootstrap("getProperty", "attributes", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.tgCacheAttributes.get()));
                        return IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class))), IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerIds.get()));
                    }

                    @Generated
                    public Map getTgCacheAttributes() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.tgCacheAttributes.get());
                    }

                    @Generated
                    public Collection getLoadBalancerIds() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancerIds.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _buildCacheResult_closure30.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "with", 0, IndyInterface.bootstrap("invoke", "getAt", 0, targetGroups, (String)targetGroupId.get()), new _buildCacheResult_closure30(this, this, tgCacheAttributes, loadBalancerIds));
                CallSite loadBalancerId = null;
                CallSite callSite18 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, (Collection)loadBalancerIds.get()));
                if (callSite18 == null) continue;
                while (callSite18.hasNext()) {
                    loadBalancerId = IndyInterface.bootstrap("cast", "()", 0, callSite18.next());
                    public final class _buildCacheResult_closure31
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference targetGroupId;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _buildCacheResult_closure31(Object _outerInstance, Object _thisObject, Reference targetGroupId) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.targetGroupId = reference = targetGroupId;
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 12, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TARGET_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("cast", "()", 0, this.targetGroupId.get()));
                        }

                        @Generated
                        public String getTargetGroupId() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.targetGroupId.get());
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _buildCacheResult_closure31.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "with", 0, IndyInterface.bootstrap("invoke", "getAt", 0, loadBalancers, loadBalancerId), new _buildCacheResult_closure31(this, this, targetGroupId));
                }
            }
        }
        CallSite itgs = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fromInstanceTargetGroupStates", 0, InstanceTargetGroups.class, instanceTargetGroupStates));
        List tgHealths = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        List instanceRels = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        public final class _buildCacheResult_closure32
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildCacheResult_closure32(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getInstanceKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "instanceId", 0, it), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildCacheResult_closure32.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite instanceIds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, itgs, new _buildCacheResult_closure32(this, this)));
        public final class _buildCacheResult_closure33
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildCacheResult_closure33(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, it), it});
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildCacheResult_closure33.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite instances = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "getAll", 0, providerCache, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class)), instanceIds, IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class)), new _buildCacheResult_closure33(this, this)));
        CallSite itg = null;
        CallSite callSite19 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, itgs));
        if (callSite19 != null) {
            while (callSite19.hasNext()) {
                itg = IndyInterface.bootstrap("cast", "()", 0, callSite19.next());
                CallSite instanceId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstanceKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "instanceId", 4, itg), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this)));
                CallSite healthId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstanceHealthKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "instanceId", 4, itg), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this), IndyInterface.bootstrap("getProperty", "healthId", 12, this)));
                CallSite attributes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), itg, IndyInterface.bootstrap("getProperty", "ATTRIBUTES", 12, this)));
                Map relationships = ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[]{instanceId})});
                if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, instances, instanceId), null)) {
                    CallSite application = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, IndyInterface.bootstrap("invoke", "getAt", 0, instances, instanceId)), "application"));
                    if (ScriptBytecodeAdapter.compareNotEqual((Object)application, null)) {
                        IndyInterface.bootstrap("invoke", "put", 0, attributes, "application", application);
                    }
                }
                IndyInterface.bootstrap("invoke", "add", 0, tgHealths, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheData.class, healthId, attributes, relationships));
                IndyInterface.bootstrap("invoke", "add", 0, instanceRels, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheData.class, instanceId, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "HEALTH", 0, Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[]{healthId})})));
            }
        }
        IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, loadBalancers), IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Caching ", " load balancers in ", ""}));
        if (IndyInterface.bootstrap("cast", "()", 0, evictableOnDemandCacheDatas) != false) {
            public final class _buildCacheResult_closure34
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference start;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _buildCacheResult_closure34(Object _outerInstance, Object _thisObject, Reference start) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.start = reference = start;
                }

                public Object doCall(Object it) {
                    return new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, it), IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("cast", "()", 0, this.start.get()), ScriptBytecodeAdapter.createPojoWrapper((Object)DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("getProperty", "cacheTime", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it))), Long.TYPE))}, new String[]{"", "/", "ms"});
                }

                @Generated
                public long getStart() {
                    return (Long)((Object)IndyInterface.bootstrap("cast", "()", 0, this.start.get()));
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _buildCacheResult_closure34.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, IndyInterface.bootstrap("invoke", "collect", 0, evictableOnDemandCacheDatas, new _buildCacheResult_closure34(this, this, start2)), ", ")}, new String[]{"Evicting onDemand cache keys (", ")"}));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheResult.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "values", 0, loadBalancers), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TARGET_GROUPS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "values", 0, targetGroups), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "HEALTH", 0, Namespace.class)), tgHealths, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class)), instanceRels}), ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Namespace.class)), ScriptBytecodeAdapter.getPropertySpreadSafe(AmazonApplicationLoadBalancerCachingAgent.class, evictableOnDemandCacheDatas, (String)"id")})));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AmazonApplicationLoadBalancerCachingAgent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AmazonApplicationLoadBalancerCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AmazonApplicationLoadBalancerCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AmazonApplicationLoadBalancerCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AmazonApplicationLoadBalancerCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AmazonApplicationLoadBalancerCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "unmodifiableCollection", 0, Collections.class, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "AUTHORITATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class))), IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "AUTHORITATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TARGET_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "AUTHORITATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "HEALTH", 0, Namespace.class))), IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "INFORMATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class)))}));
        types = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public final EddaApi getEddaApi() {
        return this.eddaApi;
    }

    @Generated
    public final EddaTimeoutConfig getEddaTimeoutConfig() {
        return this.eddaTimeoutConfig;
    }

    @Generated
    public static Collection<AgentDataType> getTypes() {
        return types;
    }

    public /* synthetic */ Collection super$2$getProvidedDataTypes() {
        return super.getProvidedDataTypes();
    }

    public /* synthetic */ Optional super$1$getCacheKeyPatterns() {
        return super.getCacheKeyPatterns();
    }

    public /* synthetic */ Collection super$2$pendingOnDemandRequests(ProviderCache providerCache) {
        return super.pendingOnDemandRequests(providerCache);
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public static class TargetGroupAssociations
    implements GroovyObject {
        private Map<String, List<TargetHealthDescription>> targetGroupArnToHealths;
        private Map<String, List<TargetGroupAttribute>> targetGroupArnToAttributes;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public TargetGroupAssociations() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != TargetGroupAssociations.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(TargetGroupAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(TargetGroupAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(TargetGroupAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(TargetGroupAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(TargetGroupAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(TargetGroupAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), TargetGroupAssociations.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AmazonApplicationLoadBalancerCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AmazonApplicationLoadBalancerCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), TargetGroupAssociations.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(TargetGroupAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(TargetGroupAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), TargetGroupAssociations.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public Map<String, List<TargetHealthDescription>> getTargetGroupArnToHealths() {
            return this.targetGroupArnToHealths;
        }

        @Generated
        public void setTargetGroupArnToHealths(Map<String, List<TargetHealthDescription>> map) {
            this.targetGroupArnToHealths = map;
        }

        @Generated
        public Map<String, List<TargetGroupAttribute>> getTargetGroupArnToAttributes() {
            return this.targetGroupArnToAttributes;
        }

        @Generated
        public void setTargetGroupArnToAttributes(Map<String, List<TargetGroupAttribute>> map) {
            this.targetGroupArnToAttributes = map;
        }
    }

    public static class ListenerAssociations
    implements GroovyObject {
        private Map<String, List<Listener>> loadBalancerArnToListeners;
        private Map<Listener, List<Rule>> listenerToRules;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public ListenerAssociations() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ListenerAssociations.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(ListenerAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(ListenerAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(ListenerAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(ListenerAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(ListenerAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(ListenerAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), ListenerAssociations.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AmazonApplicationLoadBalancerCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AmazonApplicationLoadBalancerCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), ListenerAssociations.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(ListenerAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(ListenerAssociations.class, AmazonApplicationLoadBalancerCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), ListenerAssociations.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public Map<String, List<Listener>> getLoadBalancerArnToListeners() {
            return this.loadBalancerArnToListeners;
        }

        @Generated
        public void setLoadBalancerArnToListeners(Map<String, List<Listener>> map) {
            this.loadBalancerArnToListeners = map;
        }

        @Generated
        public Map<Listener, List<Rule>> getListenerToRules() {
            return this.listenerToRules;
        }

        @Generated
        public void setListenerToRules(Map<Listener, List<Rule>> map) {
            this.listenerToRules = map;
        }
    }
}

