/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import com.amazonaws.services.identitymanagement.model.AmazonIdentityManagementException;
import com.amazonaws.services.identitymanagement.model.ListServerCertificatesRequest;
import com.amazonaws.services.identitymanagement.model.ServerCertificateMetadata;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.aws.cache.Keys;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsInfrastructureProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonCertificateCachingAgent
implements CachingAgent,
AccountAware,
GroovyObject {
    private final AmazonClientProvider amazonClientProvider;
    private final NetflixAmazonCredentials account;
    private final String region;
    private final ObjectMapper objectMapper;
    private final Registry registry;
    private final Id securityTokenExceptionGauge;
    private Instant lastFailure;
    private static final Set<AgentDataType> types;
    private static final Duration RETRY_DELAY;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AmazonCertificateCachingAgent(AmazonClientProvider amazonClientProvider, NetflixAmazonCredentials account, String region, ObjectMapper objectMapper, Registry registry) {
        Registry registry2;
        ObjectMapper objectMapper2;
        String string;
        NetflixAmazonCredentials netflixAmazonCredentials;
        AmazonClientProvider amazonClientProvider2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.amazonClientProvider = amazonClientProvider2 = amazonClientProvider;
        this.account = netflixAmazonCredentials = account;
        this.region = string = region;
        this.objectMapper = objectMapper2 = objectMapper;
        this.registry = registry2 = registry;
        CallSite callSite = IndyInterface.bootstrap("invoke", "createId", 0, registry, "aws.certificateCache.errors", "account", IndyInterface.bootstrap("getProperty", "name", 0, account), "account_id", IndyInterface.bootstrap("getProperty", "accountId", 0, account), "region", region);
        this.securityTokenExceptionGauge = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    public String getProviderName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "PROVIDER_NAME", 0, AwsInfrastructureProvider.class));
    }

    public String getAgentType() {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region, IndyInterface.bootstrap("getProperty", "simpleName", 0, AmazonCertificateCachingAgent.class)}, new String[]{"", "/", "/", ""}));
    }

    public String getAccountName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 0, this.account));
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return types;
    }

    public CacheResult loadData(ProviderCache providerCache) {
        if (IndyInterface.bootstrap("cast", "()", 0, this.lastFailure) == false || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isBefore", 0, this.lastFailure, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "now", 0, Instant.class), RETRY_DELAY)))) {
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Describing items in ", ""})) : null;
            CallSite iam = IndyInterface.bootstrap("invoke", "getAmazonIdentityManagement", 0, this.amazonClientProvider, this.account, this.region);
            List iamCertificates = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            CallSite listServerCertificatesRequest = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ListServerCertificatesRequest.class));
            while (true) {
                CallSite resp = IndyInterface.bootstrap("invoke", "listServerCertificates", 0, iam, listServerCertificatesRequest);
                IndyInterface.bootstrap("invoke", "set", 0, IndyInterface.bootstrap("invoke", "gauge", 0, this.registry, IndyInterface.bootstrap("invoke", "withTag", 0, this.securityTokenExceptionGauge, "operation", "ListServerCertificates")), false);
                IndyInterface.bootstrap("invoke", "addAll", 0, iamCertificates, IndyInterface.bootstrap("getProperty", "serverCertificateMetadataList", 0, resp));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "marker", 0, resp)) == false) break;
                IndyInterface.bootstrap("invoke", "withMarker", 0, listServerCertificatesRequest, IndyInterface.bootstrap("getProperty", "marker", 0, resp));
                continue;
                break;
            }
            try {
            }
            catch (AmazonIdentityManagementException e) {
                CallSite callSite2 = IndyInterface.bootstrap("invoke", "now", 0, Instant.class);
                this.lastFailure = IndyInterface.bootstrap("cast", "()", 0, callSite2);
                CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "warn", 0, log, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, this.account)}, new String[]{"An error occured when querying for \"ListServerCertificates\" in AWS account ", " "}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "accountId", 0, this.account), this.region, IndyInterface.bootstrap("invoke", "toMinutes", 0, RETRY_DELAY)}, new String[]{"(", ") in region ", ". Will not retry in the next ", " minutes. "})), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"Details:\n", ""}))) : null;
                IndyInterface.bootstrap("invoke", "set", 0, IndyInterface.bootstrap("invoke", "gauge", 0, this.registry, IndyInterface.bootstrap("invoke", "withTag", 0, this.securityTokenExceptionGauge, "operation", "ListServerCertificates")), true);
            }
            public final class _loadData_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _loadData_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(ServerCertificateMetadata cert) {
                    CallSite attributes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), cert, IndyInterface.bootstrap("getProperty", "ATTRIBUTES", 0, AwsInfrastructureProvider.class)));
                    return IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheData.class, IndyInterface.bootstrap("invoke", "getCertificateKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "serverCertificateId", 0, cert), IndyInterface.bootstrap("getProperty", "region", 12, this), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), "iam"), attributes, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
                }

                @Generated
                public Object call(ServerCertificateMetadata cert) {
                    return IndyInterface.bootstrap("invoke", "doCall", 2, this, cert);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadData_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite data = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, iamCertificates, new _loadData_closure1(this, this)));
            CallSite callSite4 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, data), IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Caching ", " items in ", ""})) : null;
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheResult.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CERTIFICATES", 0, Keys.Namespace.class)), data})));
        }
        return null;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AmazonCertificateCachingAgent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "unmodifiableSet", 0, Collections.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "AUTHORITATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CERTIFICATES", 0, Keys.Namespace.class)))}), Set.class))), Set.class));
        types = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "ofMinutes", 0, Duration.class, 10);
        RETRY_DELAY = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        CallSite callSite3 = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonCertificateCachingAgent");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite3);
    }

    @Generated
    public final AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public final NetflixAmazonCredentials getAccount() {
        return this.account;
    }

    @Generated
    public final String getRegion() {
        return this.region;
    }

    @Generated
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public final Registry getRegistry() {
        return this.registry;
    }

    @Generated
    public final Id getSecurityTokenExceptionGauge() {
        return this.securityTokenExceptionGauge;
    }

    @Generated
    public static Set<AgentDataType> getTypes() {
        return types;
    }
}

