/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerNotFoundException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.aws.data.Keys;
import com.netflix.spinnaker.clouddriver.aws.model.edda.InstanceLoadBalancers;
import com.netflix.spinnaker.clouddriver.aws.model.edda.LoadBalancerInstance;
import com.netflix.spinnaker.clouddriver.aws.model.edda.LoadBalancerInstanceState;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.core.provider.agent.HealthProvidingCachingAgent;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class AmazonLoadBalancerInstanceStateCachingAgent
implements CachingAgent,
HealthProvidingCachingAgent,
AccountAware,
GroovyObject {
    private static final String healthId = "aws-load-balancer-instance-health";
    private static final String STILL_REGISTERING_DESCRIPTION = "Instance registration is still in progress.";
    private final AmazonClientProvider amazonClientProvider;
    private final NetflixAmazonCredentials account;
    private final String region;
    private final ObjectMapper objectMapper;
    private final ApplicationContext ctx;
    private Cache cacheView;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AmazonLoadBalancerInstanceStateCachingAgent(AmazonClientProvider amazonClientProvider, NetflixAmazonCredentials account, String region, ObjectMapper objectMapper, ApplicationContext ctx) {
        ApplicationContext applicationContext;
        String string;
        NetflixAmazonCredentials netflixAmazonCredentials;
        AmazonClientProvider amazonClientProvider2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.amazonClientProvider = amazonClientProvider2 = amazonClientProvider;
        this.account = netflixAmazonCredentials = account;
        this.region = string = region;
        CallSite callSite = IndyInterface.bootstrap("invoke", "enable", 0, objectMapper, IndyInterface.bootstrap("getProperty", "WRITE_DATES_AS_TIMESTAMPS", 0, SerializationFeature.class));
        this.objectMapper = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.ctx = applicationContext = ctx;
    }

    public String getHealthId() {
        return healthId;
    }

    public String getProviderName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "PROVIDER_NAME", 0, AwsProvider.class));
    }

    public String getAgentType() {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region, IndyInterface.bootstrap("getProperty", "simpleName", 0, AmazonLoadBalancerInstanceStateCachingAgent.class)}, new String[]{"", "/", "/", ""}));
    }

    public String getAccountName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 0, this.account));
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "types", 12, this));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CacheResult loadData(ProviderCache providerCache) {
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Describing items in ", ""})) : null;
        CallSite loadBalancing = IndyInterface.bootstrap("invoke", "getAmazonElasticLoadBalancing", 0, this.amazonClientProvider, this.account, this.region);
        CallSite allVpcsGlob = IndyInterface.bootstrap("invoke", "getLoadBalancerKey", 0, Keys.class, "*", IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region, "*", null);
        CallSite nonVpcGlob = IndyInterface.bootstrap("invoke", "getLoadBalancerKey", 0, Keys.class, "*", IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region, null, null);
        CallSite loadBalancerKeys = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, IndyInterface.bootstrap("invoke", "getCacheView", 2, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class)), allVpcsGlob), IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, IndyInterface.bootstrap("invoke", "getCacheView", 2, this), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class)), nonVpcGlob));
        CallSite lbHealths = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class));
        CallSite instanceRels = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
        Object loadBalancerKey = null;
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, loadBalancerKeys));
        if (callSite2 != null) {
            while (callSite2.hasNext()) {
                CallSite lbName;
                loadBalancerKey = callSite2.next();
                try {
                    CallSite idObj = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, loadBalancerKey));
                    lbName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "loadBalancer", 0, idObj));
                    if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "loadBalancerType", 0, idObj)) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "loadBalancerType", 0, idObj), (Object)"classic")) {
                        continue;
                    }
                }
                catch (LoadBalancerNotFoundException e) {
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                {
                    CallSite loadBalancerInstances = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
                    CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "describeInstanceHealth", 0, loadBalancing, IndyInterface.bootstrap("init", "<init>", 0, DescribeInstanceHealthRequest.class, lbName)));
                    Object instanceState = null;
                    CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("getProperty", "instanceStates", 0, result)));
                    if (callSite3 != null) {
                        while (callSite3.hasNext()) {
                            CallSite callSite4;
                            instanceState = callSite3.next();
                            CallSite loadBalancerInstance = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, LoadBalancerInstance.class, IndyInterface.bootstrap("getProperty", "instanceId", 0, instanceState), IndyInterface.bootstrap("getProperty", "state", 0, instanceState), IndyInterface.bootstrap("getProperty", "reasonCode", 0, instanceState), IndyInterface.bootstrap("getProperty", "description", 0, instanceState)));
                            IndyInterface.bootstrap("invoke", "leftShift", 0, loadBalancerInstances, loadBalancerInstance);
                            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "description", 0, instanceState), (Object)STILL_REGISTERING_DESCRIPTION)) continue;
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false) {
                                callSite4 = IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "instanceId", 0, instanceState), lbName}, new String[]{"Instance '", "' is still registering with load balancer '", "'"}));
                                continue;
                            }
                            callSite4 = null;
                        }
                    }
                    CallSite loadBalancerInstanceState = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, LoadBalancerInstanceState.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", lbName, "instances", loadBalancerInstances})));
                    CallSite ilbs = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fromLoadBalancerInstanceState", 0, InstanceLoadBalancers.class, ScriptBytecodeAdapter.createList((Object[])new Object[]{loadBalancerInstanceState})));
                    public final class _loadData_closure1
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _loadData_closure1(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("invoke", "getInstanceKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "instanceId", 0, it), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this));
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _loadData_closure1.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite instanceIds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, ilbs, new _loadData_closure1(this, this)));
                    public final class _loadData_closure2
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _loadData_closure2(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, it), it});
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _loadData_closure2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite instances = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "getAll", 0, providerCache, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class)), instanceIds, IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class)), new _loadData_closure2(this, this)));
                    CallSite ilb = null;
                    CallSite callSite5 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, ilbs));
                    if (callSite5 == null) continue;
                    while (callSite5.hasNext()) {
                        ilb = IndyInterface.bootstrap("cast", "()", 0, callSite5.next());
                        CallSite instanceId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstanceKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "instanceId", 4, ilb), IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region));
                        CallSite healthId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstanceHealthKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "instanceId", 4, ilb), IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region, AmazonLoadBalancerInstanceStateCachingAgent.healthId));
                        CallSite attributes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, ilb, IndyInterface.bootstrap("getProperty", "ATTRIBUTES", 12, this)));
                        Map relationships = ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[]{instanceId})});
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, instances, instanceId), null)) {
                            CallSite application = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, IndyInterface.bootstrap("invoke", "getAt", 0, instances, instanceId)), "application"));
                            if (ScriptBytecodeAdapter.compareNotEqual((Object)application, null)) {
                                IndyInterface.bootstrap("invoke", "put", 0, attributes, "application", application);
                            }
                        }
                        CallSite lbHealth = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheData.class, healthId, attributes, relationships));
                        CallSite previousLbHealth = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "put", 0, lbHealths, healthId, lbHealth));
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)previousLbHealth, null)) {
                            CallSite callSite6;
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, log)) != false) {
                                callSite6 = IndyInterface.bootstrap("invoke", "debug", 0, log, "replaced instance health information for {}: was {}, is now {}", instanceId, IndyInterface.bootstrap("getProperty", "attributes", 0, previousLbHealth), attributes);
                                continue;
                            }
                            callSite6 = null;
                            continue;
                        }
                        IndyInterface.bootstrap("invoke", "add", 0, instanceRels, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheData.class, instanceId, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "HEALTH", 0, Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[]{healthId})})));
                    }
                }
            }
        }
        CallSite callSite7 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, lbHealths), IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Caching ", " items in ", ""})) : null;
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheResult.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "HEALTH", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "values", 0, lbHealths), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class)), instanceRels})));
    }

    private Cache getCacheView() {
        if (IndyInterface.bootstrap("cast", "()", 0, this.cacheView) == false) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "getBean", 0, this.ctx, Cache.class);
            this.cacheView = IndyInterface.bootstrap("cast", "()", 0, callSite);
        }
        return this.cacheView;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AmazonLoadBalancerInstanceStateCachingAgent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonLoadBalancerInstanceStateCachingAgent");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public final AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public final NetflixAmazonCredentials getAccount() {
        return this.account;
    }

    @Generated
    public final String getRegion() {
        return this.region;
    }

    @Generated
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public final ApplicationContext getCtx() {
        return this.ctx;
    }
}

