/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.aws.AmazonCloudProvider;
import com.netflix.spinnaker.clouddriver.aws.cache.Keys;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsInfrastructureProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.EddaTimeoutConfig;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.cache.OnDemandAgent;
import com.netflix.spinnaker.clouddriver.cache.OnDemandMetricsSupport;
import com.netflix.spinnaker.clouddriver.cache.OnDemandType;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonSecurityGroupCachingAgent
implements CachingAgent,
OnDemandAgent,
AccountAware,
GroovyObject {
    private final AmazonClientProvider amazonClientProvider;
    private final NetflixAmazonCredentials account;
    private final String region;
    private final ObjectMapper objectMapper;
    private final Registry registry;
    private final EddaTimeoutConfig eddaTimeoutConfig;
    private final OnDemandMetricsSupport metricsSupport;
    private final String lastModifiedKey;
    private static final Set<AgentDataType> types;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public AmazonSecurityGroupCachingAgent(AmazonClientProvider amazonClientProvider, NetflixAmazonCredentials account, String region, ObjectMapper objectMapper, Registry registry, EddaTimeoutConfig eddaTimeoutConfig) {
        EddaTimeoutConfig eddaTimeoutConfig2;
        Registry registry2;
        ObjectMapper objectMapper2;
        String string;
        NetflixAmazonCredentials netflixAmazonCredentials;
        AmazonClientProvider amazonClientProvider2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.amazonClientProvider = amazonClientProvider2 = amazonClientProvider;
        this.account = netflixAmazonCredentials = account;
        this.region = string = region;
        this.objectMapper = objectMapper2 = objectMapper;
        this.registry = registry2 = registry;
        this.eddaTimeoutConfig = eddaTimeoutConfig2 = eddaTimeoutConfig;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, OnDemandMetricsSupport.class, registry, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "ID", 0, AmazonCloudProvider.class), IndyInterface.bootstrap("getProperty", "SecurityGroup", 0, OnDemandType.class)}, new String[]{"", ":", ""}));
        this.metricsSupport = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "LAST_MODIFIED", "LAST_MODIFIED", region, IndyInterface.bootstrap("getProperty", "name", 0, account), null);
        this.lastModifiedKey = IndyInterface.bootstrap("cast", "()", 0, callSite2);
    }

    public String getProviderName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "PROVIDER_NAME", 0, AwsInfrastructureProvider.class));
    }

    public String getAgentType() {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region, IndyInterface.bootstrap("getProperty", "simpleName", 0, AmazonSecurityGroupCachingAgent.class)}, new String[]{"", "/", "/", ""}));
    }

    public String getAccountName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 0, this.account));
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return types;
    }

    public String getOnDemandAgentType() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAgentType", 2, this));
    }

    public OnDemandAgent.OnDemandResult handle(ProviderCache providerCache, Map<String, ? extends Object> data) {
        Reference providerCache2 = new Reference((Object)providerCache);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "name", 0, this.account), (Object)IndyInterface.bootstrap("getProperty", "account", 0, data))) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.region, (Object)IndyInterface.bootstrap("getProperty", "region", 0, data))) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Reference startTime = new Reference(null);
        public final class _handle_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference startTime;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _handle_closure1(Object _outerInstance, Object _thisObject, Reference startTime) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.startTime = reference = startTime;
            }

            public Object doCall(Object it) {
                CallSite ec2 = IndyInterface.bootstrap("invoke", "getAmazonEC2", 0, IndyInterface.bootstrap("getProperty", "amazonClientProvider", 12, this), IndyInterface.bootstrap("getProperty", "account", 12, this), IndyInterface.bootstrap("getProperty", "region", 12, this), true);
                if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "eddaEnabled", 0, IndyInterface.bootstrap("getProperty", "account", 12, this))) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "disabledRegions", 0, IndyInterface.bootstrap("getProperty", "eddaTimeoutConfig", 12, this)), IndyInterface.bootstrap("getProperty", "region", 12, this))) == false) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class);
                    this.startTime.set((Object)IndyInterface.bootstrap("cast", "()", 0, callSite));
                }
                return IndyInterface.bootstrap("invoke", "getSecurityGroups", 2, this, ec2);
            }

            @Generated
            public Long getStartTime() {
                return IndyInterface.bootstrap("cast", "()", 0, this.startTime.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handle_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference securityGroups = new Reference((Object)IndyInterface.bootstrap("invoke", "readData", 0, this.metricsSupport, new _handle_closure1(this, this, startTime)));
        public final class _handle_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference providerCache;
            private /* synthetic */ Reference securityGroups;
            private /* synthetic */ Reference startTime;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _handle_closure2(Object _outerInstance, Object _thisObject, Reference providerCache, Reference securityGroups, Reference startTime) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.providerCache = reference3 = providerCache;
                this.securityGroups = reference2 = securityGroups;
                this.startTime = reference = startTime;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "buildCacheResult", 2, this, IndyInterface.bootstrap("cast", "()", 0, this.providerCache.get()), this.securityGroups.get(), ScriptBytecodeAdapter.createMap((Object[])new Object[0]), IndyInterface.bootstrap("cast", "()", 0, this.startTime.get()));
            }

            @Generated
            public ProviderCache getProviderCache() {
                return IndyInterface.bootstrap("cast", "()", 0, this.providerCache.get());
            }

            @Generated
            public Object getSecurityGroups() {
                return this.securityGroups.get();
            }

            @Generated
            public Long getStartTime() {
                return IndyInterface.bootstrap("cast", "()", 0, this.startTime.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handle_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "transformData", 0, this.metricsSupport, new _handle_closure2(this, this, providerCache2, securityGroups, startTime)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, OnDemandAgent.OnDemandResult.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"sourceAgentType", IndyInterface.bootstrap("invoke", "getAgentType", 2, this), "authoritativeTypes", ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class))}), "cacheResult", result})));
    }

    public boolean handles(OnDemandType type, String cloudProvider) {
        return ScriptBytecodeAdapter.compareEqual((Object)type, (Object)IndyInterface.bootstrap("getProperty", "SecurityGroup", 0, OnDemandType.class)) && ScriptBytecodeAdapter.compareEqual((Object)cloudProvider, (Object)IndyInterface.bootstrap("getProperty", "ID", 0, AmazonCloudProvider.class));
    }

    public CacheResult loadData(ProviderCache providerCache) {
        CallSite ec2 = IndyInterface.bootstrap("invoke", "getAmazonEC2", 0, this.amazonClientProvider, this.account, this.region);
        CallSite securityGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSecurityGroups", 2, this, ec2));
        Map evictions = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "eddaEnabled", 0, this.account)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "disabledRegions", 0, this.eddaTimeoutConfig), this.region)) == false) {
            CallSite startTime = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "lastModified", 0, this.amazonClientProvider));
            if (IndyInterface.bootstrap("cast", "()", 0, startTime) != false) {
                CallSite lastModifiedRecord = IndyInterface.bootstrap("invoke", "get", 0, providerCache, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Keys.Namespace.class)), this.lastModifiedKey);
                if (IndyInterface.bootstrap("cast", "()", 0, lastModifiedRecord) != false) {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "toString", 1, IndyInterface.bootstrap("getProperty", "lastModified", 1, IndyInterface.bootstrap("getProperty", "attributes", 0, lastModifiedRecord)));
                    long lastModifiedTime = DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("invoke", "parseLong", 0, Long.class, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : "0"));
                    if (ScriptBytecodeAdapter.compareGreaterThan((Object)lastModifiedTime, (Object)startTime)) {
                        CallSite sgIds = IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, providerCache, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", "*", this.region, IndyInterface.bootstrap("getProperty", "name", 0, this.account), "*"));
                        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheResult.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("invoke", "getAll", 0, providerCache, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), sgIds)})));
                    }
                }
            } else if (IndyInterface.bootstrap("cast", "()", 0, securityGroups) != false) {
                CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isWarnEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "warn", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"", " did not receive lastModified value in response metadata"})) : null;
            }
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{this.lastModifiedKey});
            IndyInterface.bootstrap("invoke", "putAt", 0, evictions, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Keys.Namespace.class)), list);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "buildCacheResult", 2, this, providerCache, securityGroups, evictions, null));
    }

    public Optional<Map<String, String>> getCacheKeyPatterns() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "of", 0, Optional.class, IndyInterface.bootstrap("invoke", "singletonMap", 0, Collections.class, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", "*", this.region, IndyInterface.bootstrap("getProperty", "name", 0, this.account), "*"))));
    }

    public Collection<Map<String, Object>> pendingOnDemandRequests(ProviderCache providerCache) {
        return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
    }

    private List<SecurityGroup> getSecurityGroups(AmazonEC2 amazonEC2) {
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Describing items in ", ""})) : null;
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "securityGroups", 0, IndyInterface.bootstrap("invoke", "describeSecurityGroups", 0, amazonEC2)));
    }

    private CacheResult buildCacheResult(ProviderCache providerCache, List<SecurityGroup> securityGroups, Map<String, List<String>> evictions, Long lastModified) {
        public final class _buildCacheResult_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildCacheResult_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(SecurityGroup securityGroup) {
                CallSite attributes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, IndyInterface.bootstrap("getProperty", "objectMapper", 12, this), securityGroup, IndyInterface.bootstrap("getProperty", "ATTRIBUTES", 0, AwsInfrastructureProvider.class)));
                return IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheData.class, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "groupName", 0, securityGroup), IndyInterface.bootstrap("getProperty", "groupId", 0, securityGroup), IndyInterface.bootstrap("getProperty", "region", 12, this), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "account", 12, this)), IndyInterface.bootstrap("getProperty", "vpcId", 0, securityGroup)), attributes, ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
            }

            @Generated
            public Object call(SecurityGroup securityGroup) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, securityGroup);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildCacheResult_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite data = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, securityGroups, new _buildCacheResult_closure3(this, this)));
        Map cacheData = ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), data});
        if (IndyInterface.bootstrap("cast", "()", 0, lastModified) != false) {
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheData.class, this.lastModifiedKey, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"lastModified", IndyInterface.bootstrap("invoke", "toString", 0, Long.class, lastModified)}), ScriptBytecodeAdapter.createMap((Object[])new Object[0]))});
            IndyInterface.bootstrap("invoke", "putAt", 0, cacheData, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "ON_DEMAND", 0, Keys.Namespace.class)), list);
        }
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "info", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, data), IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Caching ", " items in ", ""})) : null;
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheResult.class, cacheData, evictions));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AmazonSecurityGroupCachingAgent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "unmodifiableSet", 0, Collections.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "AUTHORITATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)))}), Set.class))), Set.class));
        types = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.provider.agent.AmazonSecurityGroupCachingAgent");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite2);
    }

    @Generated
    public final AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public final NetflixAmazonCredentials getAccount() {
        return this.account;
    }

    @Generated
    public final String getRegion() {
        return this.region;
    }

    @Generated
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public final Registry getRegistry() {
        return this.registry;
    }

    @Generated
    public final EddaTimeoutConfig getEddaTimeoutConfig() {
        return this.eddaTimeoutConfig;
    }

    @Generated
    public final OnDemandMetricsSupport getMetricsSupport() {
        return this.metricsSupport;
    }

    @Generated
    public final String getLastModifiedKey() {
        return this.lastModifiedKey;
    }

    @Generated
    public static Set<AgentDataType> getTypes() {
        return types;
    }

    public /* synthetic */ Optional super$1$getCacheKeyPatterns() {
        return super.getCacheKeyPatterns();
    }
}

