/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.agent;

import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.aws.data.Keys;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.aws.provider.agent.DriftMetric;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCachingAgent
implements CachingAgent,
AccountAware,
DriftMetric,
CustomScheduledAgent,
GroovyObject {
    private final Logger log;
    private static final TypeReference<Map<String, Object>> ATTRIBUTES;
    private final Set<AgentDataType> types;
    private final AmazonClientProvider amazonClientProvider;
    private final NetflixAmazonCredentials account;
    private final String region;
    private final ObjectMapper objectMapper;
    private final Registry registry;
    private boolean includePublicImages;
    private final long pollIntervalMillis;
    private final DynamicConfigService dynamicConfigService;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ImageCachingAgent(AmazonClientProvider amazonClientProvider, NetflixAmazonCredentials account, String region, ObjectMapper objectMapper, Registry registry, boolean includePublicImages, DynamicConfigService dynamicConfigService) {
        DynamicConfigService dynamicConfigService2;
        boolean bl;
        Registry registry2;
        String string;
        NetflixAmazonCredentials netflixAmazonCredentials;
        AmazonClientProvider amazonClientProvider2;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, IndyInterface.bootstrap("invoke", "getClass", 2, this));
        this.log = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "unmodifiableSet", 0, Collections.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "AUTHORITATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class))), IndyInterface.bootstrap("invoke", "forType", 0, IndyInterface.bootstrap("getProperty", "AUTHORITATIVE", 0, AgentDataType.Authority.class), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "NAMED_IMAGES", 0, Namespace.class)))}), Set.class))), Set.class));
        this.types = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.amazonClientProvider = amazonClientProvider2 = amazonClientProvider;
        this.account = netflixAmazonCredentials = account;
        this.region = string = region;
        CallSite callSite3 = IndyInterface.bootstrap("invoke", "enable", 0, objectMapper, IndyInterface.bootstrap("getProperty", "WRITE_DATES_AS_TIMESTAMPS", 0, SerializationFeature.class));
        this.objectMapper = IndyInterface.bootstrap("cast", "()", 0, callSite3);
        this.registry = registry2 = registry;
        this.includePublicImages = bl = includePublicImages;
        this.dynamicConfigService = dynamicConfigService2 = dynamicConfigService;
        if (includePublicImages) {
            CallSite callSite4 = IndyInterface.bootstrap("invoke", "toMillis", 0, IndyInterface.bootstrap("getProperty", "MINUTES", 0, TimeUnit.class), 60);
            this.pollIntervalMillis = DefaultTypeTransformation.longUnbox((Object)callSite4);
        } else {
            int n = -1;
            this.pollIntervalMillis = n;
        }
    }

    public long getPollIntervalMillis() {
        return this.pollIntervalMillis;
    }

    public long getTimeoutMillis() {
        return -1;
    }

    public String getProviderName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "PROVIDER_NAME", 0, AwsProvider.class));
    }

    @Override
    public String getAgentType() {
        String scope = "public";
        if (!this.includePublicImages) {
            scope = "private";
        }
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region, IndyInterface.bootstrap("getProperty", "simpleName", 0, ImageCachingAgent.class), scope}, new String[]{"", "/", "/", "/", ""}));
    }

    public String getAccountName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 0, this.account));
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return this.types;
    }

    public CacheResult loadData(ProviderCache providerCache) {
        if (this.includePublicImages && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEnabled", 0, this.dynamicConfigService, "aws.defaults.public-images", true)) == false) {
            IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"short-circuiting with empty result set for public images in ", ""}));
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheResult.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[0]), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "NAMED_IMAGES", 0, Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[0])})));
        }
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Describing items in ", ""}));
        CallSite amazonEC2 = IndyInterface.bootstrap("invoke", "getAmazonEC2", 0, this.amazonClientProvider, this.account, this.region, this.includePublicImages);
        CallSite request = IndyInterface.bootstrap("init", "<init>", 0, DescribeImagesRequest.class);
        if (this.includePublicImages) {
            IndyInterface.bootstrap("invoke", "withFilters", 0, request, IndyInterface.bootstrap("init", "<init>", 0, Filter.class, "is-public", ScriptBytecodeAdapter.createList((Object[])new Object[]{"true"})));
        } else {
            IndyInterface.bootstrap("invoke", "withFilters", 0, request, IndyInterface.bootstrap("init", "<init>", 0, Filter.class, "is-public", ScriptBytecodeAdapter.createList((Object[])new Object[]{"false"})));
        }
        CallSite imageStates = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getConfig", 0, this.dynamicConfigService, List.class, "aws.defaults.image-states", IndyInterface.bootstrap("invoke", "of", 0, List.class)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, imageStates)) == false) {
            IndyInterface.bootstrap("invoke", "debug", 0, this.log, new GStringImpl(new Object[]{imageStates}, new String[]{"using image state filter '", "'"}));
            IndyInterface.bootstrap("invoke", "withFilters", 0, request, IndyInterface.bootstrap("init", "<init>", 0, Filter.class, "state", imageStates));
        }
        CallSite images = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "images", 0, IndyInterface.bootstrap("invoke", "describeImages", 0, amazonEC2, request)));
        CallSite start = null;
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "eddaEnabled", 0, this.account)) != false) {
            CallSite callSite = IndyInterface.bootstrap("getProperty", "lastModified", 0, this.amazonClientProvider);
            start = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : Integer.valueOf(0));
            public final class _loadData_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _loadData_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("invoke", "isPublic", 0, it);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadData_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            public final class _loadData_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _loadData_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isPublic", 0, it)) == false;
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadData_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            images = this.includePublicImages ? IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, images, new _loadData_closure1(this, this))) : IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, images, new _loadData_closure2(this, this)));
        }
        CallSite imageCacheData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class, IndyInterface.bootstrap("invoke", "size", 0, images)));
        CallSite namedImageCacheDataMap = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HashMap.class, IndyInterface.bootstrap("invoke", "size", 0, images)));
        CallSite image = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, images));
        if (callSite != null) {
            while (callSite.hasNext()) {
                image = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                CallSite attributes = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, image, ATTRIBUTES));
                CallSite imageId = IndyInterface.bootstrap("invoke", "getImageKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "imageId", 0, image), IndyInterface.bootstrap("getProperty", "name", 0, this.account), this.region);
                CallSite namedImageId = IndyInterface.bootstrap("invoke", "getNamedImageKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "name", 0, this.account), IndyInterface.bootstrap("getProperty", "name", 0, image));
                IndyInterface.bootstrap("invoke", "add", 0, imageCacheData, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheData.class, imageId, attributes, ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "NAMED_IMAGES", 0, Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[]{namedImageId})})));
                CallSite namedImageCacheData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, namedImageCacheDataMap, namedImageId));
                if (ScriptBytecodeAdapter.compareEqual((Object)namedImageCacheData, null)) {
                    IndyInterface.bootstrap("invoke", "put", 0, namedImageCacheDataMap, namedImageId, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheData.class, namedImageId, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "name", 0, image), "virtualizationType", IndyInterface.bootstrap("getProperty", "virtualizationType", 0, image), "architecture", IndyInterface.bootstrap("getProperty", "architecture", 0, image), "creationDate", IndyInterface.bootstrap("getProperty", "creationDate", 0, image)}), ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)), ScriptBytecodeAdapter.createList((Object[])new Object[]{imageId})})));
                    continue;
                }
                CallSite relationships = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getRelationships", 0, namedImageCacheData));
                CallSite imageRelationships = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, relationships, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class))));
                IndyInterface.bootstrap("invoke", "add", 0, imageRelationships, imageId);
            }
        }
        IndyInterface.bootstrap("invoke", "recordDrift", 2, this, start);
        IndyInterface.bootstrap("invoke", "info", 0, this.log, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "size", 0, imageCacheData), IndyInterface.bootstrap("getProperty", "agentType", 12, this)}, new String[]{"Caching ", " items in ", ""}));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DefaultCacheResult.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)), imageCacheData, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "NAMED_IMAGES", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "values", 0, namedImageCacheDataMap)})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ImageCachingAgent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ImageCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ImageCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ImageCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ImageCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ImageCachingAgent.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        1 var0;
        ATTRIBUTES = var0 = new 1();
    }

    @Override
    @Generated
    public final Logger getLog() {
        return this.log;
    }

    @Generated
    public final Set<AgentDataType> getTypes() {
        return this.types;
    }

    @Generated
    public final AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Override
    @Generated
    public final NetflixAmazonCredentials getAccount() {
        return this.account;
    }

    @Override
    @Generated
    public final String getRegion() {
        return this.region;
    }

    @Generated
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    @Generated
    public final Registry getRegistry() {
        return this.registry;
    }

    @Generated
    public boolean getIncludePublicImages() {
        return this.includePublicImages;
    }

    @Generated
    public boolean isIncludePublicImages() {
        return this.includePublicImages;
    }

    @Generated
    public void setIncludePublicImages(boolean bl) {
        this.includePublicImages = bl;
    }

    @Generated
    public final DynamicConfigService getDynamicConfigService() {
        return this.dynamicConfigService;
    }

    public class 1
    extends TypeReference<Map<String, Object>>
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        /* synthetic */ 1() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(1.class, ImageCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(1.class, ImageCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(1.class, ImageCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(1.class, ImageCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(1.class, ImageCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(1.class, ImageCachingAgent.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ImageCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, ImageCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(1.class, ImageCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(1.class, ImageCachingAgent.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), 1.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != 1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }
}

