/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.view;

import com.amazonaws.services.autoscaling.model.LifecycleState;
import com.netflix.frigga.ami.AppVersion;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.aws.AmazonCloudProvider;
import com.netflix.spinnaker.clouddriver.aws.data.Keys;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonCluster;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonInstance;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonLoadBalancer;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonServerGroup;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonTargetGroup;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsProvider;
import com.netflix.spinnaker.clouddriver.core.provider.agent.ExternalHealthProvider;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import com.netflix.spinnaker.clouddriver.model.ClusterProvider;
import com.netflix.spinnaker.clouddriver.model.ServerGroupProvider;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AmazonClusterProvider
implements ClusterProvider<AmazonCluster>,
ServerGroupProvider,
GroovyObject {
    private final AmazonCloudProvider amazonCloudProvider;
    private final Cache cacheView;
    private final AwsProvider awsProvider;
    @Autowired(required=false)
    private List<ExternalHealthProvider> externalHealthProviders;
    @Value(value="${default.build.host:http://builds.netflix.com/}")
    private String defaultBuildHost;
    @Value(value="${sql.cache.enabled:false}")
    private Boolean sqlEnabled;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Autowired
    public AmazonClusterProvider(AmazonCloudProvider amazonCloudProvider, Cache cacheView, AwsProvider awsProvider) {
        AwsProvider awsProvider2;
        Cache cache;
        AmazonCloudProvider amazonCloudProvider2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.amazonCloudProvider = amazonCloudProvider2 = amazonCloudProvider;
        this.cacheView = cache = cacheView;
        this.awsProvider = awsProvider2 = awsProvider;
    }

    public Map<String, Set<AmazonCluster>> getClusters() {
        CallSite clusterData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Namespace.class))));
        CallSite clusters = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateClusters", 2, this, clusterData, false));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "mapResponse", 0, AmazonClusterProvider.class, clusters));
    }

    public Map<String, Set<AmazonCluster>> getClusterSummaries(String applicationName) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getClusters0", 2, this, applicationName, false));
    }

    public Map<String, Set<AmazonCluster>> getClusterDetails(String applicationName) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getClusters0", 2, this, applicationName, true));
    }

    public AmazonServerGroup getServerGroup(String account, String region, String name, boolean includeDetails) {
        CallSite serverGroupKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, name, account, region));
        CallSite serverGroupData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)), serverGroupKey));
        if (ScriptBytecodeAdapter.compareEqual((Object)serverGroupData, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        CallSite asg = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, serverGroupData), "asg");
        Map serverGroupById = ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, serverGroupData), IndyInterface.bootstrap("init", "<init>", 0, AmazonServerGroup.class, IndyInterface.bootstrap("getProperty", "attributes", 0, serverGroupData))});
        CallSite serverGroup = IndyInterface.bootstrap("invoke", "first", 0, IndyInterface.bootstrap("invoke", "values", 0, serverGroupById));
        CallSite imageId = null;
        CallSite ltSpec = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getLaunchTemplateSpecification", 0, serverGroup));
        if (IndyInterface.bootstrap("cast", "()", 0, ltSpec) != false) {
            CallSite launchTemplateName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, ltSpec, "launchTemplateName"));
            CallSite launchTemplateKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getLaunchTemplateKey", 0, Keys.class, launchTemplateName, account, region));
            CallSite launchTemplate = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_TEMPLATES", 0, Namespace.class)), launchTemplateKey));
            IndyInterface.bootstrap("invoke", "updateServerGroupLaunchSettings", 0, AmazonClusterProvider.class, serverGroupById, ScriptBytecodeAdapter.createList((Object[])new Object[]{launchTemplate}));
            CallSite launchTemplateData = IndyInterface.bootstrap("invoke", "get", 1, (Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("getProperty", "attributes", 1, launchTemplate), "latestVersion"), Map.class)), "launchTemplateData");
            imageId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 1, (Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, launchTemplateData, Map.class)), "imageId"));
        } else {
            CallSite launchConfigKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getLaunchConfigKey", 0, Keys.class, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "attributes", 1, serverGroupData), "launchConfigName"), String.class))), String.class), account, region));
            CallSite launchConfigs = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_CONFIGS", 0, Namespace.class)), launchConfigKey));
            IndyInterface.bootstrap("invoke", "updateServerGroupLaunchSettings", 0, AmazonClusterProvider.class, serverGroupById, ScriptBytecodeAdapter.createList((Object[])new Object[]{launchConfigs}));
            imageId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("getProperty", "attributes", 1, launchConfigs), "imageId"));
        }
        CallSite imageConfigs = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, imageId) != false ? IndyInterface.bootstrap("invoke", "get", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "getImageKey", 0, Keys.class, imageId, account, region)) : null);
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, imageConfigs) != false ? IndyInterface.bootstrap("getProperty", "attributes", 0, imageConfigs) : null;
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)serverGroup, (String)"image");
        CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, imageConfigs) != false ? IndyInterface.bootstrap("invoke", "getBuildInfoFromImage", 2, this, imageConfigs) : null;
        ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)serverGroup, (String)"buildInfo");
        String string = account;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)serverGroup, (String)"accountName");
        if (includeDetails) {
            Reference asgInstances = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAsgInstanceKeys", 0, AmazonClusterProvider.class, asg, account, region)));
            public final class _getServerGroup_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference asgInstances;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getServerGroup_closure1(Object _outerInstance, Object _thisObject, Reference asgInstances) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.asgInstances = reference = asgInstances;
                }

                public Object doCall(Object rel) {
                    return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.asgInstances.get()), null) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("cast", "()", 0, this.asgInstances.get()), rel));
                }

                @Generated
                public Set getAsgInstances() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.asgInstances.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getServerGroup_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            _getServerGroup_closure1 instanceFilter = new _getServerGroup_closure1(this, this, asgInstances);
            CallSite callSite3 = IndyInterface.bootstrap("invoke", "values", 0, IndyInterface.bootstrap("invoke", "translateInstances", 2, this, IndyInterface.bootstrap("invoke", "resolveRelationshipData", 2, this, serverGroupData, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class)), instanceFilter, IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class))));
            ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)serverGroup, (String)"instances");
        } else {
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)serverGroup, (String)"instances");
        }
        return IndyInterface.bootstrap("cast", "()", 0, serverGroup);
    }

    public AmazonServerGroup getServerGroup(String account, String region, String name) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getServerGroup", 2, this, account, region, name, true));
    }

    public String getCloudProviderId() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "id", 4, this.amazonCloudProvider));
    }

    public boolean supportsMinimalClusters() {
        return true;
    }

    private static Map<String, Set<AmazonCluster>> mapResponse(Collection<AmazonCluster> clusters) {
        public final class _mapResponse_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _mapResponse_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "accountName", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mapResponse_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _mapResponse_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _mapResponse_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object k, Object v) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{k, IndyInterface.bootstrap("init", "<init>", 0, HashSet.class, v)});
            }

            @Generated
            public Object call(Object k, Object v) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, k, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mapResponse_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "groupBy", 0, clusters, new _mapResponse_closure2(AmazonClusterProvider.class, AmazonClusterProvider.class)), new _mapResponse_closure3(AmazonClusterProvider.class, AmazonClusterProvider.class)));
    }

    /*
     * WARNING - void declaration
     */
    private static Set<String> getAsgInstanceKeys(Map asg, String account, String region) {
        void var2_2;
        Reference account2 = new Reference((Object)account);
        Reference region2 = new Reference((Object)var2_2);
        public final class _getAsgInstanceKeys_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference account;
            private /* synthetic */ Reference region;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAsgInstanceKeys_closure4(Object _outerInstance, Object _thisObject, Reference account, Reference region) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.account = reference2 = account;
                this.region = reference = region;
            }

            public Object doCall(Set instances, Map instance) {
                IndyInterface.bootstrap("invoke", "add", 0, instances, IndyInterface.bootstrap("invoke", "getInstanceKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "instanceId", 0, instance), IndyInterface.bootstrap("cast", "()", 0, this.account.get()), IndyInterface.bootstrap("cast", "()", 0, this.region.get())));
                return instances;
            }

            @Generated
            public Object call(Set instances, Map instance) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, instances, instance);
            }

            @Generated
            public String getAccount() {
                return IndyInterface.bootstrap("cast", "()", 0, this.account.get());
            }

            @Generated
            public String getRegion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAsgInstanceKeys_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "inject", 1, IndyInterface.bootstrap("getProperty", "instances", 1, asg), IndyInterface.bootstrap("init", "<init>", 0, HashSet.class), new _getAsgInstanceKeys_closure4(AmazonClusterProvider.class, AmazonClusterProvider.class, account2, region2));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
    }

    private static Map<String, AmazonLoadBalancer> translateLoadBalancers(Collection<CacheData> loadBalancerData) {
        public final class _translateLoadBalancers_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateLoadBalancers_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object loadBalancerEntry) {
                CallSite lbKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, loadBalancerEntry)));
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, loadBalancerEntry), IndyInterface.bootstrap("init", "<init>", 0, AmazonLoadBalancer.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "loadBalancer", 0, lbKey), "account", IndyInterface.bootstrap("getProperty", "account", 0, lbKey), "region", IndyInterface.bootstrap("getProperty", "region", 0, lbKey)}))});
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateLoadBalancers_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, loadBalancerData, new _translateLoadBalancers_closure5(AmazonClusterProvider.class, AmazonClusterProvider.class)));
    }

    private static Map<String, AmazonTargetGroup> translateTargetGroups(Collection<CacheData> targetGroupData) {
        public final class _translateTargetGroups_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateTargetGroups_closure6(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object targetGroupEntry) {
                CallSite tgKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, targetGroupEntry)));
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, targetGroupEntry), IndyInterface.bootstrap("init", "<init>", 0, AmazonTargetGroup.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "loadBalancer", 0, tgKey), "account", IndyInterface.bootstrap("getProperty", "account", 0, tgKey), "region", IndyInterface.bootstrap("getProperty", "region", 0, tgKey)}))});
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateTargetGroups_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, targetGroupData, new _translateTargetGroups_closure6(AmazonClusterProvider.class, AmazonClusterProvider.class)));
    }

    private Collection<AmazonCluster> allClustersByApplication(String application) {
        List toFetch = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Namespace.class)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_CONFIGS", 0, Namespace.class)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_TEMPLATES", 0, Namespace.class))});
        Map filters = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        CallSite callSite = IndyInterface.bootstrap("invoke", "include", 0, RelationshipCacheFilter.class, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_CONFIGS", 0, Namespace.class)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_TEMPLATES", 0, Namespace.class)));
        IndyInterface.bootstrap("invoke", "putAt", 0, filters, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)), callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "include", 0, RelationshipCacheFilter.class, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)));
        IndyInterface.bootstrap("invoke", "putAt", 0, filters, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_CONFIGS", 0, Namespace.class)), callSite2);
        CallSite callSite3 = IndyInterface.bootstrap("invoke", "include", 0, RelationshipCacheFilter.class, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)));
        IndyInterface.bootstrap("invoke", "putAt", 0, filters, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_TEMPLATES", 0, Namespace.class)), callSite3);
        CallSite callSite4 = IndyInterface.bootstrap("invoke", "include", 0, RelationshipCacheFilter.class, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)));
        IndyInterface.bootstrap("invoke", "putAt", 0, filters, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class)), callSite4);
        CallSite cacheResults = IndyInterface.bootstrap("invoke", "getAllByApplication", 0, this.cacheView, toFetch, application, filters);
        CallSite allLoadBalancers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveRelationshipDataForCollection", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class)));
        CallSite allTargetGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveRelationshipDataForCollection", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TARGET_GROUPS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class)));
        List allImages = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        IndyInterface.bootstrap("invoke", "addAll", 0, allImages, IndyInterface.bootstrap("invoke", "resolveRelationshipDataForCollection", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_CONFIGS", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class)));
        IndyInterface.bootstrap("invoke", "addAll", 0, allImages, IndyInterface.bootstrap("invoke", "resolveRelationshipDataForCollection", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_TEMPLATES", 0, Namespace.class))), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class)));
        Reference loadBalancers = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateLoadBalancers", 0, AmazonClusterProvider.class, allLoadBalancers)));
        Reference targetGroups = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateTargetGroups", 0, AmazonClusterProvider.class, allTargetGroups)));
        Reference serverGroups = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateServerGroups", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class))), IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class))), IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_CONFIGS", 0, Namespace.class))), IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_TEMPLATES", 0, Namespace.class))), allImages)));
        public final class _allClustersByApplication_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroups;
            private /* synthetic */ Reference loadBalancers;
            private /* synthetic */ Reference targetGroups;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _allClustersByApplication_closure7(Object _outerInstance, Object _thisObject, Reference serverGroups, Reference loadBalancers, Reference targetGroups) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.serverGroups = reference3 = serverGroups;
                this.loadBalancers = reference2 = loadBalancers;
                this.targetGroups = reference = targetGroups;
            }

            public Object doCall(Object clusterData) {
                CallSite clusterKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, clusterData)));
                CallSite cluster = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AmazonCluster.class));
                CallSite callSite = IndyInterface.bootstrap("getProperty", "account", 0, clusterKey);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, _allClustersByApplication_closure7.class, (GroovyObject)cluster, (String)"accountName");
                CallSite callSite2 = IndyInterface.bootstrap("getProperty", "cluster", 0, clusterKey);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, _allClustersByApplication_closure7.class, (GroovyObject)cluster, (String)"name");
                public final class _closure35
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference serverGroups;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure35(Object _outerInstance, Object _thisObject, Reference serverGroups) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.serverGroups = reference = serverGroups;
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get()), it);
                    }

                    @Generated
                    public Map getServerGroups() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure35.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite3 = IndyInterface.bootstrap("invoke", "findResults", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, clusterData), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class))), new _closure35((Object)this, this.getThisObject(), this.serverGroups));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite3, _allClustersByApplication_closure7.class, (GroovyObject)cluster, (String)"serverGroups");
                public final class _closure36
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference loadBalancers;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure36(Object _outerInstance, Object _thisObject, Reference loadBalancers) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.loadBalancers = reference = loadBalancers;
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancers.get()), it);
                    }

                    @Generated
                    public Map getLoadBalancers() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancers.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure36.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite4 = IndyInterface.bootstrap("invoke", "findResults", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, clusterData), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class))), new _closure36((Object)this, this.getThisObject(), this.loadBalancers));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite4, _allClustersByApplication_closure7.class, (GroovyObject)cluster, (String)"loadBalancers");
                public final class _closure37
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference targetGroups;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure37(Object _outerInstance, Object _thisObject, Reference targetGroups) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.targetGroups = reference = targetGroups;
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.targetGroups.get()), it);
                    }

                    @Generated
                    public Map getTargetGroups() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.targetGroups.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure37.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite5 = IndyInterface.bootstrap("invoke", "findResults", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, clusterData), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TARGET_GROUPS", 0, Namespace.class))), new _closure37((Object)this, this.getThisObject(), this.targetGroups));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite5, _allClustersByApplication_closure7.class, (GroovyObject)cluster, (String)"targetGroups");
                return cluster;
            }

            @Generated
            public Map getServerGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get());
            }

            @Generated
            public Map getLoadBalancers() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancers.get());
            }

            @Generated
            public Map getTargetGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.targetGroups.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _allClustersByApplication_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite clusters = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "getAt", 0, cacheResults, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Namespace.class))), new _allClustersByApplication_closure7(this, this, serverGroups, loadBalancers, targetGroups)));
        return clusters;
    }

    private Collection<AmazonCluster> translateClusters(Collection<CacheData> clusterData, boolean includeDetails) {
        Reference includeDetails2 = new Reference((Object)includeDetails);
        Reference loadBalancers = new Reference(null);
        Map cfr_ignored_0 = (Map)loadBalancers.get();
        Reference targetGroups = new Reference(null);
        Map cfr_ignored_1 = (Map)targetGroups.get();
        Reference serverGroups = new Reference(null);
        Map cfr_ignored_2 = (Map)serverGroups.get();
        if (DefaultTypeTransformation.booleanUnbox((Object)includeDetails2.get())) {
            CallSite allLoadBalancers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveRelationshipDataForCollection", 2, this, clusterData, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class))));
            CallSite allTargetGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveRelationshipDataForCollection", 2, this, clusterData, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TARGET_GROUPS", 0, Namespace.class))));
            CallSite allServerGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveRelationshipDataForCollection", 2, this, clusterData, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "include", 0, RelationshipCacheFilter.class, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_CONFIGS", 0, Namespace.class)), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_TEMPLATES", 0, Namespace.class)))));
            loadBalancers.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateLoadBalancers", 0, AmazonClusterProvider.class, allLoadBalancers)));
            targetGroups.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateTargetGroups", 0, AmazonClusterProvider.class, allTargetGroups)));
            serverGroups.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateServerGroups", 2, this, allServerGroups, false)));
        } else {
            CallSite allServerGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveRelationshipDataForCollection", 2, this, clusterData, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class)));
            serverGroups.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateServerGroups", 2, this, allServerGroups, true)));
        }
        public final class _translateClusters_closure8
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroups;
            private /* synthetic */ Reference includeDetails;
            private /* synthetic */ Reference loadBalancers;
            private /* synthetic */ Reference targetGroups;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateClusters_closure8(Object _outerInstance, Object _thisObject, Reference serverGroups, Reference includeDetails, Reference loadBalancers, Reference targetGroups) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.serverGroups = reference4 = serverGroups;
                this.includeDetails = reference3 = includeDetails;
                this.loadBalancers = reference2 = loadBalancers;
                this.targetGroups = reference = targetGroups;
            }

            public Object doCall(CacheData clusterDataEntry) {
                CallSite clusterKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, clusterDataEntry)));
                CallSite cluster = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AmazonCluster.class));
                CallSite callSite = IndyInterface.bootstrap("getProperty", "account", 0, clusterKey);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, _translateClusters_closure8.class, (GroovyObject)cluster, (String)"accountName");
                CallSite callSite2 = IndyInterface.bootstrap("getProperty", "cluster", 0, clusterKey);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, _translateClusters_closure8.class, (GroovyObject)cluster, (String)"name");
                public final class _closure38
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference serverGroups;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure38(Object _outerInstance, Object _thisObject, Reference serverGroups) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.serverGroups = reference = serverGroups;
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get()), it);
                    }

                    @Generated
                    public Map getServerGroups() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure38.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite3 = IndyInterface.bootstrap("invoke", "findResults", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, clusterDataEntry), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class))), new _closure38((Object)this, this.getThisObject(), this.serverGroups));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite3, _translateClusters_closure8.class, (GroovyObject)cluster, (String)"serverGroups");
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.includeDetails.get())) != false) {
                    public final class _closure39
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference loadBalancers;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure39(Object _outerInstance, Object _thisObject, Reference loadBalancers) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.loadBalancers = reference = loadBalancers;
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.loadBalancers.get()), it);
                        }

                        @Generated
                        public Map getLoadBalancers() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancers.get());
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure39.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite callSite4 = IndyInterface.bootstrap("invoke", "findResults", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, clusterDataEntry), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class))), new _closure39((Object)this, this.getThisObject(), this.loadBalancers));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite4, _translateClusters_closure8.class, (GroovyObject)cluster, (String)"loadBalancers");
                    public final class _closure40
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference targetGroups;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure40(Object _outerInstance, Object _thisObject, Reference targetGroups) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.targetGroups = reference = targetGroups;
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.targetGroups.get()), it);
                        }

                        @Generated
                        public Map getTargetGroups() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.targetGroups.get());
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure40.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite callSite5 = IndyInterface.bootstrap("invoke", "findResults", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, clusterDataEntry), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TARGET_GROUPS", 0, Namespace.class))), new _closure40((Object)this, this.getThisObject(), this.targetGroups));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite5, _translateClusters_closure8.class, (GroovyObject)cluster, (String)"targetGroups");
                } else {
                    public final class _closure41
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure41(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object loadBalancerKey) {
                            CallSite parts = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, loadBalancerKey));
                            return IndyInterface.bootstrap("init", "<init>", 0, AmazonLoadBalancer.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "loadBalancer", 0, parts), "account", IndyInterface.bootstrap("getProperty", "account", 0, parts), "region", IndyInterface.bootstrap("getProperty", "region", 0, parts)}));
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure41.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite callSite6 = IndyInterface.bootstrap("invoke", "collect", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, clusterDataEntry), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LOAD_BALANCERS", 0, Namespace.class))), new _closure41((Object)this, this.getThisObject()));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite6, _translateClusters_closure8.class, (GroovyObject)cluster, (String)"loadBalancers");
                    public final class _closure42
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure42(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object targetGroupKey) {
                            CallSite parts = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, targetGroupKey));
                            return IndyInterface.bootstrap("init", "<init>", 0, AmazonTargetGroup.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "loadBalancer", 0, parts), "account", IndyInterface.bootstrap("getProperty", "account", 0, parts), "region", IndyInterface.bootstrap("getProperty", "region", 0, parts)}));
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure42.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite callSite7 = IndyInterface.bootstrap("invoke", "collect", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, clusterDataEntry), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "TARGET_GROUPS", 0, Namespace.class))), new _closure42((Object)this, this.getThisObject()));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite7, _translateClusters_closure8.class, (GroovyObject)cluster, (String)"targetGroups");
                }
                return cluster;
            }

            @Generated
            public Object call(CacheData clusterDataEntry) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, clusterDataEntry);
            }

            @Generated
            public Map getServerGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get());
            }

            @Generated
            public boolean getIncludeDetails() {
                return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("cast", "()", 0, this.includeDetails.get()));
            }

            @Generated
            public Map getLoadBalancers() {
                return IndyInterface.bootstrap("cast", "()", 0, this.loadBalancers.get());
            }

            @Generated
            public Map getTargetGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.targetGroups.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateClusters_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite clusters = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, clusterData, new _translateClusters_closure8(this, this, serverGroups, includeDetails2, loadBalancers, targetGroups)));
        return clusters;
    }

    private Map<String, Set<AmazonCluster>> getClusters0(String applicationName, boolean includeDetails) {
        CallSite clusters = null;
        if (includeDetails && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "supportsGetAllByApplication", 0, this.cacheView))) {
            clusters = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "allClustersByApplication", 2, this, applicationName));
        } else {
            CallSite clusterKeys = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "getClusterKey", 0, Keys.class, "*", applicationName, "*")));
            CallSite clusterData = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Namespace.class)), clusterKeys));
            clusters = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateClusters", 2, this, clusterData, includeDetails));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, clusters) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "mapResponse", 0, AmazonClusterProvider.class, clusters));
    }

    private Map<String, AmazonServerGroup> translateServerGroups(Collection<CacheData> serverGroupData, Collection<CacheData> instanceData, Collection<CacheData> launchConfigData, Collection<CacheData> launchTemplateData, Collection<CacheData> imageData) {
        Reference instances = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateInstances", 2, this, instanceData)));
        public final class _translateServerGroups_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instances;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateServerGroups_closure9(Object _outerInstance, Object _thisObject, Reference instances) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.instances = reference = instances;
            }

            public Object doCall(Object sg) {
                CallSite parsed = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, sg)));
                CallSite serverGroup = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AmazonServerGroup.class, IndyInterface.bootstrap("getProperty", "attributes", 0, sg)));
                CallSite asgInstanceSet = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAsgInstanceKeys", 2, this, IndyInterface.bootstrap("getProperty", "asg", 4, serverGroup), IndyInterface.bootstrap("getProperty", "account", 0, parsed), IndyInterface.bootstrap("getProperty", "region", 0, parsed)));
                public final class _closure43
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference instances;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure43(Object _outerInstance, Object _thisObject, Reference instances) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.instances = reference = instances;
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("invoke", "containsKey", 0, IndyInterface.bootstrap("cast", "()", 0, this.instances.get()), it);
                    }

                    @Generated
                    public Map getInstances() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.instances.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure43.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _closure44
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference instances;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure44(Object _outerInstance, Object _thisObject, Reference instances) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.instances = reference = instances;
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.instances.get()), it);
                    }

                    @Generated
                    public Map getInstances() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.instances.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure44.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "findAll", 0, asgInstanceSet, new _closure43((Object)this, this.getThisObject(), this.instances)), new _closure44((Object)this, this.getThisObject(), this.instances));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, _translateServerGroups_closure9.class, (GroovyObject)serverGroup, (String)"instances");
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, sg), serverGroup});
            }

            @Generated
            public Map getInstances() {
                return IndyInterface.bootstrap("cast", "()", 0, this.instances.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite serverGroups = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 1, serverGroupData, new _translateServerGroups_closure9(this, this, instances)));
        IndyInterface.bootstrap("invoke", "updateServerGroupLaunchSettings", 0, AmazonClusterProvider.class, serverGroups, launchTemplateData);
        IndyInterface.bootstrap("invoke", "updateServerGroupLaunchSettings", 0, AmazonClusterProvider.class, serverGroups, launchConfigData);
        IndyInterface.bootstrap("invoke", "updateServerGroupBuildInfo", 2, this, serverGroups, launchTemplateData, imageData);
        IndyInterface.bootstrap("invoke", "updateServerGroupBuildInfo", 2, this, serverGroups, launchConfigData, imageData);
        return serverGroups;
    }

    private Map<String, AmazonServerGroup> translateServerGroups(Collection<CacheData> serverGroupData, boolean includePartialInstances) {
        Reference includePartialInstances2 = new Reference((Object)includePartialInstances);
        CallSite allInstances = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "resolveRelationshipDataForCollection", 2, this, serverGroupData, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class)));
        Reference instances = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "translateInstances", 2, this, allInstances)));
        public final class _translateServerGroups_closure10
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instances;
            private /* synthetic */ Reference includePartialInstances;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateServerGroups_closure10(Object _outerInstance, Object _thisObject, Reference instances, Reference includePartialInstances) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.instances = reference2 = instances;
                this.includePartialInstances = reference = includePartialInstances;
            }

            public Object doCall(Object serverGroupEntry) {
                CallSite serverGroupKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, serverGroupEntry)));
                CallSite serverGroup = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AmazonServerGroup.class, IndyInterface.bootstrap("getProperty", "attributes", 0, serverGroupEntry)));
                CallSite asg = IndyInterface.bootstrap("getProperty", "asg", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, serverGroupEntry));
                Reference asgInstanceSet = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAsgInstanceKeys", 2, this, asg, IndyInterface.bootstrap("getProperty", "account", 0, serverGroupKey), IndyInterface.bootstrap("getProperty", "region", 0, serverGroupKey))));
                public final class _closure45
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference asgInstanceSet;
                    private /* synthetic */ Reference instances;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure45(Object _outerInstance, Object _thisObject, Reference asgInstanceSet, Reference instances) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.asgInstanceSet = reference2 = asgInstanceSet;
                        this.instances = reference = instances;
                    }

                    public Object doCall(Object it) {
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("cast", "()", 0, this.asgInstanceSet.get()), null) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("cast", "()", 0, this.asgInstanceSet.get()), it)) == false) {
                            return null;
                        }
                        return IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.instances.get()), it);
                    }

                    @Generated
                    public Set getAsgInstanceSet() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.asgInstanceSet.get());
                    }

                    @Generated
                    public Map getInstances() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.instances.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure45.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite = IndyInterface.bootstrap("invoke", "findResults", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, serverGroupEntry), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "INSTANCES", 0, Namespace.class))), new _closure45((Object)this, this.getThisObject(), asgInstanceSet, this.instances));
                CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, _translateServerGroups_closure10.class, (GroovyObject)serverGroup, (String)"instances");
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.includePartialInstances.get())) != false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "instances", 4, serverGroup)) == false && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "instances", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, serverGroupEntry)))) {
                    Reference validStates = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "name", 0, IndyInterface.bootstrap("getProperty", "InService", 0, LifecycleState.class))}));
                    public final class _closure46
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference validStates;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure46(Object _outerInstance, Object _thisObject, Reference validStates) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.validStates = reference = validStates;
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("invoke", "contains", 0, this.validStates.get(), IndyInterface.bootstrap("getProperty", "lifecycleState", 0, it));
                        }

                        @Generated
                        public Object getValidStates() {
                            return this.validStates.get();
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure46.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    public final class _closure47
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure47(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("init", "<init>", 0, AmazonInstance.class, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("cast", "()", 0, it), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "instanceId", 0, it)})));
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure47.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite callSite3 = IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "findAll", 0, (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "instances", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, serverGroupEntry)), List.class)), new _closure46((Object)this, this.getThisObject(), validStates)), new _closure47((Object)this, this.getThisObject()));
                    ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite3, _translateServerGroups_closure10.class, (GroovyObject)serverGroup, (String)"instances");
                }
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, serverGroupEntry), serverGroup});
            }

            @Generated
            public Map getInstances() {
                return IndyInterface.bootstrap("cast", "()", 0, this.instances.get());
            }

            @Generated
            public boolean getIncludePartialInstances() {
                return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("cast", "()", 0, this.includePartialInstances.get()));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference serverGroups = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, serverGroupData, new _translateServerGroups_closure10(this, this, instances, includePartialInstances2))));
        public final class _translateServerGroups_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateServerGroups_closure11(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, it), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_CONFIGS", 0, Namespace.class)));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _translateServerGroups_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateServerGroups_closure12(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("invoke", "first", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, it), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_CONFIGS", 0, Namespace.class)))), IndyInterface.bootstrap("getProperty", "id", 0, it)});
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference launchConfigurations = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "findAll", 0, serverGroupData, new _translateServerGroups_closure11(this, this)), new _translateServerGroups_closure12(this, this))));
        public final class _translateServerGroups_closure13
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateServerGroups_closure13(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, it), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_TEMPLATES", 0, Namespace.class)));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _translateServerGroups_closure14
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateServerGroups_closure14(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("invoke", "first", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, it), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_TEMPLATES", 0, Namespace.class)))), IndyInterface.bootstrap("getProperty", "id", 0, it)});
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference templates = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "findAll", 0, serverGroupData, new _translateServerGroups_closure13(this, this)), new _translateServerGroups_closure14(this, this))));
        CallSite launchConfigs = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_CONFIGS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "keySet", 0, (Map)launchConfigurations.get())));
        Reference allImages = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        public final class _translateServerGroups_closure15
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference launchConfigurations;
            private /* synthetic */ Reference serverGroups;
            private /* synthetic */ Reference allImages;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateServerGroups_closure15(Object _outerInstance, Object _thisObject, Reference launchConfigurations, Reference serverGroups, Reference allImages) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.launchConfigurations = reference3 = launchConfigurations;
                this.serverGroups = reference2 = serverGroups;
                this.allImages = reference = allImages;
            }

            public Object doCall(Object launchConfig) {
                CallSite serverGroupId = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.launchConfigurations.get()), IndyInterface.bootstrap("getProperty", "id", 0, launchConfig));
                CallSite imageId = IndyInterface.bootstrap("invoke", "first", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, launchConfig), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class))));
                CallSite callSite = IndyInterface.bootstrap("getProperty", "attributes", 0, launchConfig);
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get()), serverGroupId), (String)"launchConfig");
                if (IndyInterface.bootstrap("cast", "()", 0, imageId) != false) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, IndyInterface.bootstrap("cast", "()", 0, this.allImages.get()), imageId)) == false) {
                        IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("cast", "()", 0, this.allImages.get()), imageId, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                    }
                    return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.allImages.get()), imageId), serverGroupId);
                }
                return null;
            }

            @Generated
            public Map getLaunchConfigurations() {
                return IndyInterface.bootstrap("cast", "()", 0, this.launchConfigurations.get());
            }

            @Generated
            public Map getServerGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get());
            }

            @Generated
            public Map getAllImages() {
                return IndyInterface.bootstrap("cast", "()", 0, this.allImages.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, launchConfigs, new _translateServerGroups_closure15(this, this, launchConfigurations, serverGroups, allImages));
        CallSite launchTemplates = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "LAUNCH_TEMPLATES", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "keySet", 0, (Map)templates.get())));
        public final class _translateServerGroups_closure16
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference templates;
            private /* synthetic */ Reference serverGroups;
            private /* synthetic */ Reference allImages;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateServerGroups_closure16(Object _outerInstance, Object _thisObject, Reference templates, Reference serverGroups, Reference allImages) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.templates = reference3 = templates;
                this.serverGroups = reference2 = serverGroups;
                this.allImages = reference = allImages;
            }

            public Object doCall(Object launchTemplate) {
                CallSite serverGroupId = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.templates.get()), IndyInterface.bootstrap("getProperty", "id", 0, launchTemplate));
                IndyInterface.bootstrap("invoke", "populateServerGroupWithLtOrMip", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get()), serverGroupId), launchTemplate);
                CallSite imageId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "first", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, launchTemplate), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)))));
                if (IndyInterface.bootstrap("cast", "()", 0, imageId) != false) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, IndyInterface.bootstrap("cast", "()", 0, this.allImages.get()), imageId)) == false) {
                        IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("cast", "()", 0, this.allImages.get()), imageId, ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                    }
                    return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.allImages.get()), imageId), serverGroupId);
                }
                return null;
            }

            @Generated
            public Map getTemplates() {
                return IndyInterface.bootstrap("cast", "()", 0, this.templates.get());
            }

            @Generated
            public Map getServerGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get());
            }

            @Generated
            public Map getAllImages() {
                return IndyInterface.bootstrap("cast", "()", 0, this.allImages.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, launchTemplates, new _translateServerGroups_closure16(this, this, templates, serverGroups, allImages));
        CallSite images = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "keySet", 0, (Map)allImages.get())));
        public final class _translateServerGroups_closure17
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference allImages;
            private /* synthetic */ Reference serverGroups;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateServerGroups_closure17(Object _outerInstance, Object _thisObject, Reference allImages, Reference serverGroups) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.allImages = reference2 = allImages;
                this.serverGroups = reference = serverGroups;
            }

            public Object doCall(Object image) {
                Reference image2 = new Reference(image);
                CallSite serverGroupIds = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.allImages.get()), IndyInterface.bootstrap("getProperty", "id", 0, image2.get()));
                public final class _closure48
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference serverGroups;
                    private /* synthetic */ Reference image;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure48(Object _outerInstance, Object _thisObject, Reference serverGroups, Reference image) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.serverGroups = reference2 = serverGroups;
                        this.image = reference = image;
                    }

                    public Object doCall(Object serverGroupId) {
                        CallSite serverGroup = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get()), serverGroupId);
                        CallSite callSite = IndyInterface.bootstrap("getProperty", "attributes", 0, this.image.get());
                        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)serverGroup, (String)"image");
                        CallSite callSite2 = IndyInterface.bootstrap("invoke", "getBuildInfoFromImage", 2, this, this.image.get());
                        ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)serverGroup, (String)"buildInfo");
                        return callSite2;
                    }

                    @Generated
                    public Map getServerGroups() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get());
                    }

                    @Generated
                    public Object getImage() {
                        return this.image.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure48.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "each", 0, serverGroupIds, new _closure48((Object)this, this.getThisObject(), this.serverGroups, image2));
            }

            @Generated
            public Map getAllImages() {
                return IndyInterface.bootstrap("cast", "()", 0, this.allImages.get());
            }

            @Generated
            public Map getServerGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateServerGroups_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, images, new _translateServerGroups_closure17(this, this, allImages, serverGroups));
        return (Map)serverGroups.get();
    }

    private Map<String, AmazonInstance> translateInstances(Collection<CacheData> instanceData) {
        public final class _translateInstances_closure18
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _translateInstances_closure18(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object instanceEntry) {
                CallSite instance = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AmazonInstance.class, IndyInterface.bootstrap("getProperty", "attributes", 0, instanceEntry)));
                CallSite callSite = IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "instanceId", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, instanceEntry)));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, _translateInstances_closure18.class, (GroovyObject)instance, (String)"name");
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, instanceEntry), instance});
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _translateInstances_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "collectEntries", 1, instanceData, new _translateInstances_closure18(this, this));
        CallSite instances = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        IndyInterface.bootstrap("invoke", "addHealthToInstances", 2, this, instanceData, instances);
        return instances;
    }

    private void addHealthToInstances(Collection<CacheData> instanceData, Map<String, AmazonInstance> instances) {
        Reference instances2 = new Reference(instances);
        Reference healthKeysToInstance = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
        public final class _addHealthToInstances_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference healthKeysToInstance;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addHealthToInstances_closure19(Object _outerInstance, Object _thisObject, Reference healthKeysToInstance) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.healthKeysToInstance = reference = healthKeysToInstance;
            }

            public Object doCall(Object instanceEntry) {
                Reference instanceEntry2 = new Reference(instanceEntry);
                Reference instanceKey = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, instanceEntry2.get()))));
                public final class _closure49
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference instanceKey;
                    private /* synthetic */ Reference healthKeysToInstance;
                    private /* synthetic */ Reference instanceEntry;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure49(Object _outerInstance, Object _thisObject, Reference instanceKey, Reference healthKeysToInstance, Reference instanceEntry) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.instanceKey = reference3 = instanceKey;
                        this.healthKeysToInstance = reference2 = healthKeysToInstance;
                        this.instanceEntry = reference = instanceEntry;
                    }

                    public Object doCall(Object it) {
                        CallSite key = IndyInterface.bootstrap("invoke", "getInstanceHealthKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "instanceId", 0, IndyInterface.bootstrap("cast", "()", 0, this.instanceKey.get())), IndyInterface.bootstrap("getProperty", "account", 0, IndyInterface.bootstrap("cast", "()", 0, this.instanceKey.get())), IndyInterface.bootstrap("getProperty", "region", 0, IndyInterface.bootstrap("cast", "()", 0, this.instanceKey.get())), IndyInterface.bootstrap("getProperty", "healthId", 0, it));
                        return IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("cast", "()", 0, this.healthKeysToInstance.get()), key, IndyInterface.bootstrap("getProperty", "id", 0, this.instanceEntry.get()));
                    }

                    @Generated
                    public Map getInstanceKey() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.instanceKey.get());
                    }

                    @Generated
                    public Map getHealthKeysToInstance() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.healthKeysToInstance.get());
                    }

                    @Generated
                    public Object getInstanceEntry() {
                        return this.instanceEntry.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure49.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "healthAgents", 4, IndyInterface.bootstrap("getProperty", "awsProvider", 12, this)), new _closure49((Object)this, this.getThisObject(), instanceKey, this.healthKeysToInstance, instanceEntry2));
                public final class _closure50
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference instanceKey;
                    private /* synthetic */ Reference healthKeysToInstance;
                    private /* synthetic */ Reference instanceEntry;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure50(Object _outerInstance, Object _thisObject, Reference instanceKey, Reference healthKeysToInstance, Reference instanceEntry) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.instanceKey = reference3 = instanceKey;
                        this.healthKeysToInstance = reference2 = healthKeysToInstance;
                        this.instanceEntry = reference = instanceEntry;
                    }

                    public Object doCall(Object externalHealthProvider) {
                        public final class _closure51
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference instanceKey;
                            private /* synthetic */ Reference healthKeysToInstance;
                            private /* synthetic */ Reference instanceEntry;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure51(Object _outerInstance, Object _thisObject, Reference instanceKey, Reference healthKeysToInstance, Reference instanceEntry) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                this.instanceKey = reference3 = instanceKey;
                                this.healthKeysToInstance = reference2 = healthKeysToInstance;
                                this.instanceEntry = reference = instanceEntry;
                            }

                            public Object doCall(Object externalHealthAgent) {
                                CallSite key = IndyInterface.bootstrap("invoke", "getInstanceHealthKey", 0, Keys.class, IndyInterface.bootstrap("getProperty", "instanceId", 0, IndyInterface.bootstrap("cast", "()", 0, this.instanceKey.get())), IndyInterface.bootstrap("getProperty", "account", 0, IndyInterface.bootstrap("cast", "()", 0, this.instanceKey.get())), IndyInterface.bootstrap("getProperty", "region", 0, IndyInterface.bootstrap("cast", "()", 0, this.instanceKey.get())), IndyInterface.bootstrap("getProperty", "healthId", 0, externalHealthAgent));
                                return IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("cast", "()", 0, this.healthKeysToInstance.get()), key, IndyInterface.bootstrap("getProperty", "id", 0, this.instanceEntry.get()));
                            }

                            @Generated
                            public Map getInstanceKey() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.instanceKey.get());
                            }

                            @Generated
                            public Map getHealthKeysToInstance() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.healthKeysToInstance.get());
                            }

                            @Generated
                            public Object getInstanceEntry() {
                                return this.instanceEntry.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure51.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "agents", 0, externalHealthProvider), new _closure51((Object)this, this.getThisObject(), this.instanceKey, this.healthKeysToInstance, this.instanceEntry));
                    }

                    @Generated
                    public Map getInstanceKey() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.instanceKey.get());
                    }

                    @Generated
                    public Map getHealthKeysToInstance() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.healthKeysToInstance.get());
                    }

                    @Generated
                    public Object getInstanceEntry() {
                        return this.instanceEntry.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure50.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "externalHealthProviders", 12, this), new _closure50((Object)this, this.getThisObject(), instanceKey, this.healthKeysToInstance, instanceEntry2));
            }

            @Generated
            public Map getHealthKeysToInstance() {
                return IndyInterface.bootstrap("cast", "()", 0, this.healthKeysToInstance.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addHealthToInstances_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, instanceData, new _addHealthToInstances_closure19(this, this, healthKeysToInstance));
        CallSite healths = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "HEALTH", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "keySet", 0, (Map)healthKeysToInstance.get()), IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class)));
        public final class _addHealthToInstances_closure20
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference healthKeysToInstance;
            private /* synthetic */ Reference instances;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addHealthToInstances_closure20(Object _outerInstance, Object _thisObject, Reference healthKeysToInstance, Reference instances) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.healthKeysToInstance = reference2 = healthKeysToInstance;
                this.instances = reference = instances;
            }

            public Object doCall(Object healthEntry) {
                CallSite instanceId = IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.healthKeysToInstance.get()), IndyInterface.bootstrap("getProperty", "id", 0, healthEntry));
                return IndyInterface.bootstrap("invoke", "leftShift", 0, IndyInterface.bootstrap("getProperty", "health", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.instances.get()), instanceId)), IndyInterface.bootstrap("getProperty", "attributes", 0, healthEntry));
            }

            @Generated
            public Map getHealthKeysToInstance() {
                return IndyInterface.bootstrap("cast", "()", 0, this.healthKeysToInstance.get());
            }

            @Generated
            public Map getInstances() {
                return IndyInterface.bootstrap("cast", "()", 0, this.instances.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addHealthToInstances_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, healths, new _addHealthToInstances_closure20(this, this, healthKeysToInstance, instances2));
        public final class _addHealthToInstances_closure21
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addHealthToInstances_closure21(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object instance) {
                public final class _closure52
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure52(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "state", 0, it), (Object)"Up");
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure52.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                public final class _closure53
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure53(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "state", 0, it), (Object)"Up") || ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "state", 0, it), (Object)"Unknown");
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure53.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                boolean bl = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "any", 0, IndyInterface.bootstrap("getProperty", "health", 0, instance), new _closure52((Object)this, this.getThisObject()))) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "every", 0, IndyInterface.bootstrap("getProperty", "health", 0, instance), new _closure53((Object)this, this.getThisObject())));
                ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)instance, (String)"isHealthy");
                return bl;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addHealthToInstances_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "values", 0, (Map)instances2.get()), new _addHealthToInstances_closure21(this, this));
    }

    private Collection<CacheData> resolveRelationshipDataForCollection(Collection<CacheData> sources, String relationship, CacheFilter cacheFilter) {
        Reference relationship2 = new Reference((Object)relationship);
        public final class _resolveRelationshipDataForCollection_closure22
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference relationship;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _resolveRelationshipDataForCollection_closure22(Object _outerInstance, Object _thisObject, Reference relationship) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.relationship = reference = relationship;
            }

            public Object doCall(Object it) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, it), IndyInterface.bootstrap("cast", "()", 0, this.relationship.get()));
                return IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            }

            @Generated
            public String getRelationship() {
                return IndyInterface.bootstrap("cast", "()", 0, this.relationship.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resolveRelationshipDataForCollection_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "flatten", 1, IndyInterface.bootstrap("invoke", "findResults", 1, sources, new _resolveRelationshipDataForCollection_closure22(this, this, relationship2)));
        CallSite relationships = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, relationships) != false ? IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, (String)relationship2.get(), relationships, cacheFilter) : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
    }

    private Collection<CacheData> resolveRelationshipData(CacheData source, String relationship, Closure<Boolean> relFilter, CacheFilter cacheFilter) {
        CallSite filteredRelationships = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, source), relationship), relFilter));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, filteredRelationships) != false ? IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, relationship, filteredRelationships, cacheFilter) : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
    }

    private Map getBuildInfoFromImage(CacheData image) {
        Map buildInfo = null;
        public final class _getBuildInfoFromImage_closure23
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getBuildInfoFromImage_closure23(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)"appversion");
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getBuildInfoFromImage_closure23.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite appVersionTag = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "value", 1, IndyInterface.bootstrap("invoke", "find", 1, IndyInterface.bootstrap("getProperty", "tags", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, image)), new _getBuildInfoFromImage_closure23(this, this))));
        if (IndyInterface.bootstrap("cast", "()", 0, appVersionTag) != false) {
            CallSite appVersion = IndyInterface.bootstrap("invoke", "parseName", 0, AppVersion.class, appVersionTag);
            if (IndyInterface.bootstrap("cast", "()", 0, appVersion) != false) {
                CallSite callSite;
                CallSite callSite2;
                buildInfo = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"package_name", IndyInterface.bootstrap("getProperty", "packageName", 0, appVersion), "version", IndyInterface.bootstrap("getProperty", "version", 0, appVersion), "commit", IndyInterface.bootstrap("getProperty", "commit", 0, appVersion)});
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "buildJobName", 0, appVersion)) != false) {
                    Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "buildJobName", 0, appVersion), "number", IndyInterface.bootstrap("getProperty", "buildNumber", 0, appVersion)});
                    ScriptBytecodeAdapter.setProperty((Object)map, null, (Object)buildInfo, (String)"jenkins");
                }
                public final class _getBuildInfoFromImage_closure24
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _getBuildInfoFromImage_closure24(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)"build_host");
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getBuildInfoFromImage_closure24.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Object buildHost = IndyInterface.bootstrap("cast", "()", 0, callSite2 = IndyInterface.bootstrap("getProperty", "value", 1, IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("getProperty", "tags", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, image)), new _getBuildInfoFromImage_closure24(this, this)))) != false ? callSite2 : this.defaultBuildHost;
                if (DefaultTypeTransformation.booleanUnbox((Object)buildHost) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsKey", 0, buildInfo, "jenkins"))) {
                    Object object = buildHost;
                    ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "jenkins", 0, buildInfo)), (String)"host");
                }
                public final class _getBuildInfoFromImage_closure25
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _getBuildInfoFromImage_closure25(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)"build_info_url");
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _getBuildInfoFromImage_closure25.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite buildInfoUrl = IndyInterface.bootstrap("cast", "()", 0, callSite = IndyInterface.bootstrap("getProperty", "value", 1, IndyInterface.bootstrap("invoke", "find", 1, IndyInterface.bootstrap("getProperty", "tags", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, image)), new _getBuildInfoFromImage_closure25(this, this)))) != false ? callSite : null;
                if (IndyInterface.bootstrap("cast", "()", 0, buildInfoUrl) != false) {
                    CallSite callSite3 = buildInfoUrl;
                    ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)buildInfo, (String)"buildInfoUrl");
                }
            }
        }
        return buildInfo;
    }

    public Set<AmazonCluster> getClusters(String applicationName, String account) {
        CallSite clusterKeys = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "getClusterKey", 0, Keys.class, "*", applicationName, account)));
        CallSite clusters = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Namespace.class)), clusterKeys));
        return (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "translateClusters", 2, this, clusters, true), Set.class));
    }

    public AmazonCluster getCluster(String application, String account, String name, boolean includeDetails) {
        CallSite cluster = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "CLUSTERS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "getClusterKey", 0, Keys.class, name, application, account)));
        if (ScriptBytecodeAdapter.compareEqual((Object)cluster, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "translateClusters", 2, this, ScriptBytecodeAdapter.createList((Object[])new Object[]{cluster}), includeDetails), false));
    }

    public AmazonCluster getCluster(String application, String account, String name) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getCluster", 2, this, application, account, name, true));
    }

    public Collection<String> getServerGroupIdentifiers(String account, String region) {
        account = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "orElse", 0, IndyInterface.bootstrap("invoke", "ofNullable", 0, Optional.class, account), "*"));
        region = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "orElse", 0, IndyInterface.bootstrap("invoke", "ofNullable", 0, Optional.class, region), "*"));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, "*", "*", account, region)));
    }

    public String buildServerGroupIdentifier(String account, String region, String serverGroupName) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getServerGroupKey", 0, Keys.class, serverGroupName, account, region));
    }

    private static Map<String, Object> getLaunchTemplateForVersion(CacheData launchTemplate, String version) {
        Reference version2 = new Reference((Object)version);
        if (IndyInterface.bootstrap("cast", "()", 0, launchTemplate) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        CallSite launchTemplateAttrs = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, launchTemplate));
        List versions = (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, launchTemplateAttrs, "versions"), List.class));
        if (ScriptBytecodeAdapter.compareEqual((Object)((String)version2.get()), (Object)"$Latest")) {
            return (Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, launchTemplateAttrs, "latestVersion"), Map.class));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((String)version2.get()), (Object)"$Default")) {
            public final class _getLaunchTemplateForVersion_closure26
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getLaunchTemplateForVersion_closure26(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, it, "defaultVersion"), Boolean.class));
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getLaunchTemplateForVersion_closure26.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, versions, new _getLaunchTemplateForVersion_closure26(AmazonClusterProvider.class, AmazonClusterProvider.class)));
        }
        public final class _getLaunchTemplateForVersion_closure27
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference version;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getLaunchTemplateForVersion_closure27(Object _outerInstance, Object _thisObject, Reference version) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.version = reference = version;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, it, "versionNumber"), (Object)IndyInterface.bootstrap("invoke", "toInteger", 0, IndyInterface.bootstrap("cast", "()", 0, this.version.get())));
            }

            @Generated
            public String getVersion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.version.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getLaunchTemplateForVersion_closure27.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 0, versions, new _getLaunchTemplateForVersion_closure27(AmazonClusterProvider.class, AmazonClusterProvider.class, version2)));
    }

    private static void updateServerGroupLaunchSettings(Map<String, AmazonServerGroup> serverGroups, Collection<CacheData> launchData) {
        Reference serverGroups2 = new Reference(serverGroups);
        Reference ld = new Reference(null);
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, launchData));
        if (callSite != null) {
            while (callSite.hasNext()) {
                ld.set(callSite.next());
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 1, IndyInterface.bootstrap("getProperty", "relationships", 1, ld.get()), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)))) == false) continue;
                public final class _updateServerGroupLaunchSettings_closure28
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference serverGroups;
                    private /* synthetic */ Reference ld;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _updateServerGroupLaunchSettings_closure28(Object _outerInstance, Object _thisObject, Reference serverGroups, Reference ld) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.serverGroups = reference2 = serverGroups;
                        this.ld = reference = ld;
                    }

                    public Object doCall(Object it) {
                        CallSite serverGroup = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get()), it);
                        if (ScriptBytecodeAdapter.compareNotEqual((Object)serverGroup, null)) {
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getLaunchTemplateSpecification", 0, serverGroup)) != false) {
                                return IndyInterface.bootstrap("invoke", "populateServerGroupWithLtOrMip", 2, this, serverGroup, this.ld.get());
                            }
                            CallSite callSite = IndyInterface.bootstrap("getProperty", "attributes", 0, this.ld.get());
                            ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)serverGroup, (String)"launchConfig");
                            return callSite;
                        }
                        return null;
                    }

                    @Generated
                    public Map getServerGroups() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get());
                    }

                    @Generated
                    public Object getLd() {
                        return this.ld.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _updateServerGroupLaunchSettings_closure28.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, ld.get()), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class))), new _updateServerGroupLaunchSettings_closure28(AmazonClusterProvider.class, AmazonClusterProvider.class, serverGroups2, ld));
            }
        }
    }

    private static void populateServerGroupWithLtOrMip(AmazonServerGroup serverGroup, CacheData launchData) {
        Reference serverGroup2 = new Reference((Object)serverGroup);
        CallSite ltSpec = IndyInterface.bootstrap("invoke", "getLaunchTemplateSpecification", 0, (AmazonServerGroup)serverGroup2.get());
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isDebugEnabled", 0, log)) != false ? IndyInterface.bootstrap("invoke", "debug", 0, log, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 4, (AmazonServerGroup)serverGroup2.get()), ltSpec}, new String[]{"Attempting to populate server group ", " with launch template ", "."})) : null;
        Reference ec2Lt = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getLaunchTemplateForVersion", 0, AmazonClusterProvider.class, launchData, ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "getAt", 0, ltSpec, "version"), String.class))), String.class))));
        if (IndyInterface.bootstrap("cast", "()", 0, (Map)ec2Lt.get()) == false) {
            return;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "launchTemplate", 1, IndyInterface.bootstrap("getProperty", "asg", 4, (AmazonServerGroup)serverGroup2.get()))) != false) {
            Map map = (Map)ec2Lt.get();
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)map, AmazonClusterProvider.class, (GroovyObject)((AmazonServerGroup)serverGroup2.get()), (String)"launchTemplate");
        } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "mixedInstancesPolicy", 1, IndyInterface.bootstrap("getProperty", "asg", 4, (AmazonServerGroup)serverGroup2.get()))) != false) {
            CallSite mip = IndyInterface.bootstrap("getProperty", "mixedInstancesPolicy", 0, IndyInterface.bootstrap("getProperty", "asg", 4, (AmazonServerGroup)serverGroup2.get()));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAt", 0, mip, "launchTemplate"), "overrides")) == false) {
                public final class _populateServerGroupWithLtOrMip_closure29
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference ec2Lt;
                    private /* synthetic */ Reference serverGroup;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _populateServerGroupWithLtOrMip_closure29(Object _outerInstance, Object _thisObject, Reference ec2Lt, Reference serverGroup) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.ec2Lt = reference2 = ec2Lt;
                        this.serverGroup = reference = serverGroup;
                    }

                    public Object doCall(Object it) {
                        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.ec2Lt.get()), "launchTemplateData"), "instanceType")});
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)list, _populateServerGroupWithLtOrMip_closure29.class, (GroovyObject)this, (String)"allowedInstanceTypes");
                        CallSite callSite = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "mixedInstancesPolicy", 0, IndyInterface.bootstrap("getProperty", "asg", 4, IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get()))), "instancesDistribution");
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, _populateServerGroupWithLtOrMip_closure29.class, (GroovyObject)this, (String)"instancesDistribution");
                        List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.ec2Lt.get())});
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)list2, _populateServerGroupWithLtOrMip_closure29.class, (GroovyObject)this, (String)"launchTemplates");
                        return list2;
                    }

                    @Generated
                    public Map getEc2Lt() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.ec2Lt.get());
                    }

                    @Generated
                    public AmazonServerGroup getServerGroup() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _populateServerGroupWithLtOrMip_closure29.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite2 = IndyInterface.bootstrap("invoke", "tap", 0, IndyInterface.bootstrap("init", "<init>", 0, AmazonServerGroup.MixedInstancesPolicySettings.class), new _populateServerGroupWithLtOrMip_closure29(AmazonClusterProvider.class, AmazonClusterProvider.class, ec2Lt, serverGroup2));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, AmazonClusterProvider.class, (GroovyObject)((AmazonServerGroup)serverGroup2.get()), (String)"mixedInstancesPolicy");
            } else {
                Reference overrides = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAt", 0, mip, "launchTemplate"), "overrides")));
                Reference types = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                public final class _populateServerGroupWithLtOrMip_closure30
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference types;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _populateServerGroupWithLtOrMip_closure30(Object _outerInstance, Object _thisObject, Reference types) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.types = reference = types;
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("invoke", "add", 0, this.types.get(), IndyInterface.bootstrap("invoke", "getAt", 0, it, "instanceType"));
                    }

                    @Generated
                    public Object getTypes() {
                        return this.types.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _populateServerGroupWithLtOrMip_closure30.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, overrides.get(), new _populateServerGroupWithLtOrMip_closure30(AmazonClusterProvider.class, AmazonClusterProvider.class, types));
                public final class _populateServerGroupWithLtOrMip_closure31
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _populateServerGroupWithLtOrMip_closure31(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "key", 0, it), (Object)"instanceType");
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _populateServerGroupWithLtOrMip_closure31.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite ec2LtDataMinusType = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("getProperty", "launchTemplateData", 1, (Map)ec2Lt.get()), new _populateServerGroupWithLtOrMip_closure31(AmazonClusterProvider.class, AmazonClusterProvider.class)));
                IndyInterface.bootstrap("invoke", "replace", 1, (Map)ec2Lt.get(), "launchTemplateData", ec2LtDataMinusType);
                public final class _populateServerGroupWithLtOrMip_closure32
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference types;
                    private /* synthetic */ Reference serverGroup;
                    private /* synthetic */ Reference ec2Lt;
                    private /* synthetic */ Reference overrides;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _populateServerGroupWithLtOrMip_closure32(Object _outerInstance, Object _thisObject, Reference types, Reference serverGroup, Reference ec2Lt, Reference overrides) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        Reference reference4;
                        this.types = reference4 = types;
                        this.serverGroup = reference3 = serverGroup;
                        this.ec2Lt = reference2 = ec2Lt;
                        this.overrides = reference = overrides;
                    }

                    public Object doCall(Object it) {
                        CallSite callSite = IndyInterface.bootstrap("invoke", "sort", 0, this.types.get());
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, _populateServerGroupWithLtOrMip_closure32.class, (GroovyObject)this, (String)"allowedInstanceTypes");
                        CallSite callSite2 = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "mixedInstancesPolicy", 0, IndyInterface.bootstrap("getProperty", "asg", 4, IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get()))), "instancesDistribution");
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite2, _populateServerGroupWithLtOrMip_closure32.class, (GroovyObject)this, (String)"instancesDistribution");
                        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("cast", "()", 0, this.ec2Lt.get())});
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)list, _populateServerGroupWithLtOrMip_closure32.class, (GroovyObject)this, (String)"launchTemplates");
                        Object object = this.overrides.get();
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _populateServerGroupWithLtOrMip_closure32.class, (GroovyObject)this, (String)"launchTemplateOverridesForInstanceType");
                        return object;
                    }

                    @Generated
                    public Object getTypes() {
                        return this.types.get();
                    }

                    @Generated
                    public AmazonServerGroup getServerGroup() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.serverGroup.get());
                    }

                    @Generated
                    public Map getEc2Lt() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.ec2Lt.get());
                    }

                    @Generated
                    public Object getOverrides() {
                        return this.overrides.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _populateServerGroupWithLtOrMip_closure32.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite3 = IndyInterface.bootstrap("invoke", "tap", 0, IndyInterface.bootstrap("init", "<init>", 0, AmazonServerGroup.MixedInstancesPolicySettings.class), new _populateServerGroupWithLtOrMip_closure32(AmazonClusterProvider.class, AmazonClusterProvider.class, types, serverGroup2, ec2Lt, overrides));
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite3, AmazonClusterProvider.class, (GroovyObject)((AmazonServerGroup)serverGroup2.get()), (String)"mixedInstancesPolicy");
            }
        }
    }

    private void updateServerGroupBuildInfo(Map<String, AmazonServerGroup> serverGroups, Collection<CacheData> launchData, Collection<CacheData> imageData) {
        Reference serverGroups2 = new Reference(serverGroups);
        public final class _updateServerGroupBuildInfo_closure33
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateServerGroupBuildInfo_closure33(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object image) {
                return ScriptBytecodeAdapter.createMap((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "id", 0, image), image});
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateServerGroupBuildInfo_closure33.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference images = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 1, imageData, new _updateServerGroupBuildInfo_closure33(this, this))));
        public final class _updateServerGroupBuildInfo_closure34
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference serverGroups;
            private /* synthetic */ Reference images;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _updateServerGroupBuildInfo_closure34(Object _outerInstance, Object _thisObject, Reference serverGroups, Reference images) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.serverGroups = reference2 = serverGroups;
                this.images = reference = images;
            }

            public Object doCall(Object ld) {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 1, IndyInterface.bootstrap("getProperty", "relationships", 1, ld), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)))) != false) {
                    CallSite serverGroup = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get()), IndyInterface.bootstrap("invoke", "first", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, ld), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SERVER_GROUPS", 0, Namespace.class)))));
                    CallSite imageId = IndyInterface.bootstrap("invoke", "first", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, ld), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class))));
                    if (DefaultTypeTransformation.booleanUnbox((Object)serverGroup) && DefaultTypeTransformation.booleanUnbox((Object)imageId) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsKey", 0, IndyInterface.bootstrap("cast", "()", 0, this.images.get()), imageId))) {
                        CallSite callSite = IndyInterface.bootstrap("getProperty", "attributes", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.images.get()), imageId));
                        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)serverGroup, (String)"image");
                        CallSite callSite2 = IndyInterface.bootstrap("invoke", "getBuildInfoFromImage", 2, this, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.images.get()), imageId));
                        ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)serverGroup, (String)"buildInfo");
                        return callSite2;
                    }
                }
                return null;
            }

            @Generated
            public Map getServerGroups() {
                return IndyInterface.bootstrap("cast", "()", 0, this.serverGroups.get());
            }

            @Generated
            public Map getImages() {
                return IndyInterface.bootstrap("cast", "()", 0, this.images.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _updateServerGroupBuildInfo_closure34.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, launchData, new _updateServerGroupBuildInfo_closure34(this, this, serverGroups2, images));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AmazonClusterProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    private Collection<CacheData> resolveRelationshipDataForCollection(Collection<CacheData> sources, String relationship) {
        Reference relationship2 = new Reference((Object)relationship);
        return this.resolveRelationshipDataForCollection(sources, (String)relationship2.get(), null);
    }

    @Generated
    private Collection<CacheData> resolveRelationshipData(CacheData source, String relationship, Closure<Boolean> relFilter) {
        return this.resolveRelationshipData(source, relationship, relFilter, null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.provider.view.AmazonClusterProvider");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public List<ExternalHealthProvider> getExternalHealthProviders() {
        return this.externalHealthProviders;
    }

    @Generated
    public void setExternalHealthProviders(List<ExternalHealthProvider> list) {
        this.externalHealthProviders = list;
    }

    @Generated
    public String getDefaultBuildHost() {
        return this.defaultBuildHost;
    }

    @Generated
    public void setDefaultBuildHost(String string) {
        this.defaultBuildHost = string;
    }

    @Generated
    public Boolean getSqlEnabled() {
        return this.sqlEnabled;
    }

    @Generated
    public void setSqlEnabled(Boolean bl) {
        this.sqlEnabled = bl;
    }
}

