/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.provider.view;

import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.aws.AmazonCloudProvider;
import com.netflix.spinnaker.clouddriver.aws.cache.Keys;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonSecurityGroup;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.model.AddressableRange;
import com.netflix.spinnaker.clouddriver.model.SecurityGroupProvider;
import com.netflix.spinnaker.clouddriver.model.securitygroups.IpRangeRule;
import com.netflix.spinnaker.clouddriver.model.securitygroups.Rule;
import com.netflix.spinnaker.clouddriver.model.securitygroups.SecurityGroupRule;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.EqualsAndHashCode;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.ToString;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.FormatHelper;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.util.HashCodeHelper;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class AmazonSecurityGroupProvider
implements SecurityGroupProvider<AmazonSecurityGroup>,
GroovyObject {
    private final String cloudProvider;
    private final CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;
    private final Cache cacheView;
    private final ObjectMapper objectMapper;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Autowired
    public AmazonSecurityGroupProvider(CredentialsRepository<NetflixAmazonCredentials> credentialsRepository, Cache cacheView, @Qualifier(value="amazonObjectMapper") ObjectMapper objectMapper) {
        ObjectMapper objectMapper2;
        Cache cache;
        MetaClass metaClass;
        CallSite callSite = IndyInterface.bootstrap("getProperty", "ID", 0, AmazonCloudProvider.class);
        this.cloudProvider = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        CredentialsRepository<NetflixAmazonCredentials> credentialsRepository2 = credentialsRepository;
        this.credentialsRepository = credentialsRepository2;
        this.cacheView = cache = cacheView;
        this.objectMapper = objectMapper2 = objectMapper;
    }

    public Collection<AmazonSecurityGroup> getAll(boolean includeRules) {
        if (!includeRules) {
            CallSite identifiers = IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", "*", "*", "*", "*"));
            public final class _getAll_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _getAll_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite parts = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, it));
                    return IndyInterface.bootstrap("init", "<init>", 0, AmazonSecurityGroup.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", IndyInterface.bootstrap("getProperty", "id", 0, parts), "name", IndyInterface.bootstrap("getProperty", "name", 0, parts), "vpcId", IndyInterface.bootstrap("getProperty", "vpcId", 0, parts), "accountName", IndyInterface.bootstrap("getProperty", "account", 0, parts), "region", IndyInterface.bootstrap("getProperty", "region", 0, parts), "cloudProvider", IndyInterface.bootstrap("getProperty", "ID", 0, AmazonCloudProvider.class)}));
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAll_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, identifiers, new _getAll_closure1(this, this)));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", "*", "*", "*", "*"), includeRules));
    }

    public Collection<AmazonSecurityGroup> getAllByRegion(boolean includeRules, String region) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", "*", region, "*", "*"), includeRules));
    }

    public Collection<AmazonSecurityGroup> getAllByAccount(boolean includeRules, String account) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", "*", "*", account, "*"), includeRules));
    }

    public Collection<AmazonSecurityGroup> getAllByAccountAndName(boolean includeRules, String account, String name) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, name, "*", "*", account, "*"), includeRules));
    }

    public Collection<AmazonSecurityGroup> getAllByAccountAndRegion(boolean includeRules, String account, String region) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", "*", region, account, "*"), includeRules));
    }

    public AmazonSecurityGroup get(String account, String region, String name, String vpcId) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, name, "*", region, account, vpcId), true), false));
    }

    public AmazonSecurityGroup get(boolean includeRules, String account, String region, String name, String vpcId) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, name, "*", region, account, vpcId), includeRules), false));
    }

    public String getNameById(String account, String region, String securityGroupId, String vpcId) {
        CallSite key = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getCacheIdentifier", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", securityGroupId, region, account, vpcId)));
        if (IndyInterface.bootstrap("cast", "()", 0, key) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, key)));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public String getIdByName(String account, String region, String name, String vpcId) {
        CallSite key = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getCacheIdentifier", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, name, "*", region, account, vpcId)));
        if (IndyInterface.bootstrap("cast", "()", 0, key) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "id", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, key)));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public String getCacheIdentifier(String pattern) {
        CallSite ids = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), pattern));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, ids)) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "toArray", 0, ids), false));
    }

    public AmazonSecurityGroup getById(String account, String region, String securityGroupId, String vpcId) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", securityGroupId, region, account, vpcId), true), false));
    }

    public AmazonSecurityGroup getById(boolean includeRules, String account, String region, String securityGroupId, String vpcId) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAllMatchingKeyPattern", 2, this, IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", securityGroupId, region, account, vpcId), includeRules), false));
    }

    public Collection<AmazonSecurityGroup> getAllMatchingKeyPattern(String pattern, boolean includeRules) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "loadResults", 2, this, includeRules, IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), pattern)));
    }

    public Collection<AmazonSecurityGroup> loadResults(boolean includeRules, Collection<String> identifiers) {
        CallSite transform = IndyInterface.bootstrap("invoke", "curry", 0, ScriptBytecodeAdapter.getMethodPointer((Object)this, (String)"fromCacheData"), includeRules);
        CallSite data = IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), identifiers, IndyInterface.bootstrap("invoke", "none", 0, RelationshipCacheFilter.class));
        CallSite transformed = IndyInterface.bootstrap("invoke", "collect", 0, data, transform);
        return IndyInterface.bootstrap("cast", "()", 0, transformed);
    }

    public AmazonSecurityGroup fromCacheData(boolean includeRules, CacheData cacheData) {
        CallSite parts = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, cacheData)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertToAmazonSecurityGroup", 2, this, includeRules, IndyInterface.bootstrap("getProperty", "attributes", 0, cacheData), IndyInterface.bootstrap("getProperty", "account", 0, parts), IndyInterface.bootstrap("getProperty", "region", 0, parts)));
    }

    /*
     * WARNING - void declaration
     */
    private AmazonSecurityGroup convertToAmazonSecurityGroup(boolean includeRules, Map<String, Object> securityGroup, String account, String region) {
        void var3_3;
        Reference securityGroup2 = new Reference(securityGroup);
        Reference account2 = new Reference((Object)var3_3);
        Reference region2 = new Reference((Object)region);
        List inboundRules = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        if (includeRules) {
            CallSite amznSecurityGroup = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "convertValue", 0, this.objectMapper, (Map)securityGroup2.get(), SecurityGroup.class));
            Reference rules = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
            Reference ipRangeRules = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
            public final class _convertToAmazonSecurityGroup_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference ipRangeRules;
                private /* synthetic */ Reference rules;
                private /* synthetic */ Reference account;
                private /* synthetic */ Reference region;
                private /* synthetic */ Reference securityGroup;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _convertToAmazonSecurityGroup_closure2(Object _outerInstance, Object _thisObject, Reference ipRangeRules, Reference rules, Reference account, Reference region, Reference securityGroup) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    Reference reference5;
                    this.ipRangeRules = reference5 = ipRangeRules;
                    this.rules = reference4 = rules;
                    this.account = reference3 = account;
                    this.region = reference2 = region;
                    this.securityGroup = reference = securityGroup;
                }

                public Object doCall(Object permission) {
                    IndyInterface.bootstrap("invoke", "addIpRangeRules", 2, this, permission, IndyInterface.bootstrap("cast", "()", 0, this.ipRangeRules.get()));
                    return IndyInterface.bootstrap("invoke", "addSecurityGroupRules", 2, this, permission, IndyInterface.bootstrap("cast", "()", 0, this.rules.get()), IndyInterface.bootstrap("cast", "()", 0, this.account.get()), IndyInterface.bootstrap("cast", "()", 0, this.region.get()), IndyInterface.bootstrap("getProperty", "vpcId", 0, IndyInterface.bootstrap("cast", "()", 0, this.securityGroup.get())));
                }

                @Generated
                public Map getIpRangeRules() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.ipRangeRules.get());
                }

                @Generated
                public Map getRules() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.rules.get());
                }

                @Generated
                public String getAccount() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.account.get());
                }

                @Generated
                public String getRegion() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
                }

                @Generated
                public Map getSecurityGroup() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.securityGroup.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _convertToAmazonSecurityGroup_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "ipPermissions", 0, amznSecurityGroup), new _convertToAmazonSecurityGroup_closure2(this, this, ipRangeRules, rules, account2, region2, securityGroup2));
            IndyInterface.bootstrap("invoke", "addAll", 0, inboundRules, IndyInterface.bootstrap("invoke", "buildSecurityGroupRules", 2, this, (Map)rules.get()));
            IndyInterface.bootstrap("invoke", "addAll", 0, inboundRules, IndyInterface.bootstrap("invoke", "buildIpRangeRules", 2, this, (Map)ipRangeRules.get()));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AmazonSecurityGroup.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", IndyInterface.bootstrap("getProperty", "groupId", 0, (Map)securityGroup2.get()), "name", IndyInterface.bootstrap("getProperty", "groupName", 0, (Map)securityGroup2.get()), "vpcId", IndyInterface.bootstrap("getProperty", "vpcId", 0, (Map)securityGroup2.get()), "description", IndyInterface.bootstrap("getProperty", "description", 0, (Map)securityGroup2.get()), "accountName", (String)account2.get(), "region", (String)region2.get(), "inboundRules", inboundRules, "tags", IndyInterface.bootstrap("getProperty", "tags", 0, (Map)securityGroup2.get())})));
    }

    private List<IpRangeRule> buildIpRangeRules(LinkedHashMap<String, Map> ipRangeRules) {
        public final class _buildIpRangeRules_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildIpRangeRules_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object rule) {
                return IndyInterface.bootstrap("init", "<init>", 0, IpRangeRule.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"range", IndyInterface.bootstrap("getProperty", "range", 0, rule), "protocol", IndyInterface.bootstrap("getProperty", "protocol", 0, rule), "portRanges", IndyInterface.bootstrap("getProperty", "portRanges", 0, rule), "description", IndyInterface.bootstrap("getProperty", "description", 0, rule)}));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildIpRangeRules_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite rangeRules = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "sort", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "values", 0, ipRangeRules), new _buildIpRangeRules_closure3(this, this))));
        return rangeRules;
    }

    private List<SecurityGroupRule> buildSecurityGroupRules(LinkedHashMap<GroupAndProtocol, Map> rules) {
        public final class _buildSecurityGroupRules_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildSecurityGroupRules_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object rule) {
                return IndyInterface.bootstrap("init", "<init>", 0, SecurityGroupRule.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"securityGroup", IndyInterface.bootstrap("getProperty", "securityGroup", 0, rule), "portRanges", IndyInterface.bootstrap("getProperty", "portRanges", 0, rule), "protocol", IndyInterface.bootstrap("getProperty", "protocol", 0, rule)}));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildSecurityGroupRules_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite securityGroupRules = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "sort", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "values", 0, rules), new _buildSecurityGroupRules_closure4(this, this))));
        return securityGroupRules;
    }

    private Map<String, String> getIngressGroupNameAndVpcId(UserIdGroupPair sg, String baseAccount, String ingressAccount, String region, String vpcId) {
        CallSite ingressGroupName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "groupName", 0, sg));
        Object ingressGroupVpcId = vpcId;
        if (IndyInterface.bootstrap("cast", "()", 0, ingressGroupName) == false || ScriptBytecodeAdapter.compareNotEqual((Object)baseAccount, (Object)ingressAccount)) {
            String string;
            String string2 = vpcId;
            String vpcPattern = IndyInterface.bootstrap("cast", "()", 0, string2) != false ? string2 : "*";
            if (ScriptBytecodeAdapter.compareNotEqual((Object)baseAccount, (Object)ingressAccount)) {
                vpcPattern = "*";
            }
            CallSite keyPattern = IndyInterface.bootstrap("invoke", "getSecurityGroupKey", 0, Keys.class, "*", IndyInterface.bootstrap("getProperty", "groupId", 0, sg), region, IndyInterface.bootstrap("cast", "()", 0, string = ingressAccount) != false ? string : "*", vpcPattern);
            CallSite matches = IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "SECURITY_GROUPS", 0, Keys.Namespace.class)), keyPattern);
            if (IndyInterface.bootstrap("cast", "()", 0, matches) != false) {
                CallSite parts = IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("invoke", "getAt", 0, matches, false));
                ingressGroupName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 0, parts));
                ingressGroupVpcId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "vpcId", 0, parts));
            }
        }
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", ingressGroupName, "vpcId", ingressGroupVpcId});
    }

    /*
     * WARNING - void declaration
     */
    private void addSecurityGroupRules(IpPermission permission, Map<GroupAndProtocol, Map> rules, String account, String region, String vpcId) {
        void var3_3;
        void var2_2;
        Reference permission2 = new Reference((Object)permission);
        Reference rules2 = new Reference((Object)var2_2);
        Reference account2 = new Reference((Object)var3_3);
        Reference region2 = new Reference((Object)region);
        Reference vpcId2 = new Reference((Object)vpcId);
        public final class _addSecurityGroupRules_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference permission;
            private /* synthetic */ Reference rules;
            private /* synthetic */ Reference account;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference vpcId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addSecurityGroupRules_closure5(Object _outerInstance, Object _thisObject, Reference permission, Reference rules, Reference account, Reference region, Reference vpcId) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                Reference reference5;
                this.permission = reference5 = permission;
                this.rules = reference4 = rules;
                this.account = reference3 = account;
                this.region = reference2 = region;
                this.vpcId = reference = vpcId;
            }

            public Object doCall(Object sg) {
                Reference sg2 = new Reference(sg);
                CallSite groupAndProtocol = IndyInterface.bootstrap("init", "<init>", 0, GroupAndProtocol.class, IndyInterface.bootstrap("getProperty", "groupId", 0, sg2.get()), IndyInterface.bootstrap("getProperty", "ipProtocol", 0, IndyInterface.bootstrap("cast", "()", 0, this.permission.get())));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, IndyInterface.bootstrap("cast", "()", 0, this.rules.get()), groupAndProtocol)) == false) {
                    CallSite callSite;
                    public final class _closure8
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference sg;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure8(Object _outerInstance, Object _thisObject, Reference sg) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.sg = reference = sg;
                        }

                        public Object doCall(Object it) {
                            return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "accountId", 0, it), (Object)IndyInterface.bootstrap("getProperty", "userId", 0, this.sg.get()));
                        }

                        @Generated
                        public Object getSg() {
                            return this.sg.get();
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure8.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite ingressAccount = IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("invoke", "getAll", 0, IndyInterface.bootstrap("getProperty", "credentialsRepository", 12, this)), new _closure8((Object)this, this.getThisObject(), sg2));
                    CallSite ingressGroupSummary = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getIngressGroupNameAndVpcId", 2, this, sg2.get(), IndyInterface.bootstrap("cast", "()", 0, this.account.get()), IndyInterface.bootstrap("getProperty", "name", 1, ingressAccount), IndyInterface.bootstrap("cast", "()", 0, this.region.get()), IndyInterface.bootstrap("cast", "()", 0, this.vpcId.get())));
                    IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("cast", "()", 0, this.rules.get()), groupAndProtocol, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"protocol", IndyInterface.bootstrap("getProperty", "ipProtocol", 0, IndyInterface.bootstrap("cast", "()", 0, this.permission.get())), "securityGroup", IndyInterface.bootstrap("init", "<init>", 0, AmazonSecurityGroup.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", IndyInterface.bootstrap("getProperty", "groupId", 0, sg2.get()), "name", IndyInterface.bootstrap("getProperty", "name", 0, ingressGroupSummary), "accountId", IndyInterface.bootstrap("getProperty", "userId", 0, sg2.get()), "accountName", IndyInterface.bootstrap("getProperty", "name", 1, ingressAccount), "region", IndyInterface.bootstrap("cast", "()", 0, this.region.get()), "vpcId", IndyInterface.bootstrap("cast", "()", 0, callSite = IndyInterface.bootstrap("getProperty", "vpcId", 0, sg2.get())) != false ? callSite : IndyInterface.bootstrap("getProperty", "vpcId", 0, ingressGroupSummary)})), "portRanges", (SortedSet)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), SortedSet.class))}));
                }
                CallSite callSite = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "portRanges", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.rules.get()), groupAndProtocol)), IndyInterface.bootstrap("init", "<init>", 0, Rule.PortRange.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"startPort", IndyInterface.bootstrap("getProperty", "fromPort", 0, IndyInterface.bootstrap("cast", "()", 0, this.permission.get())), "endPort", IndyInterface.bootstrap("getProperty", "toPort", 0, IndyInterface.bootstrap("cast", "()", 0, this.permission.get()))})));
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.rules.get()), groupAndProtocol), (String)"portRanges");
                return callSite;
            }

            @Generated
            public IpPermission getPermission() {
                return IndyInterface.bootstrap("cast", "()", 0, this.permission.get());
            }

            @Generated
            public Map getRules() {
                return IndyInterface.bootstrap("cast", "()", 0, this.rules.get());
            }

            @Generated
            public String getAccount() {
                return IndyInterface.bootstrap("cast", "()", 0, this.account.get());
            }

            @Generated
            public String getRegion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
            }

            @Generated
            public String getVpcId() {
                return IndyInterface.bootstrap("cast", "()", 0, this.vpcId.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addSecurityGroupRules_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "userIdGroupPairs", 0, (IpPermission)permission2.get()), new _addSecurityGroupRules_closure5(this, this, permission2, rules2, account2, region2, vpcId2));
    }

    /*
     * WARNING - void declaration
     */
    private void addIpRangeRules(IpPermission permission, Map<String, Map> rules) {
        void var2_2;
        Reference permission2 = new Reference((Object)permission);
        Reference rules2 = new Reference((Object)var2_2);
        public final class _addIpRangeRules_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference permission;
            private /* synthetic */ Reference rules;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addIpRangeRules_closure6(Object _outerInstance, Object _thisObject, Reference permission, Reference rules) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.permission = reference2 = permission;
                this.rules = reference = rules;
            }

            public Object doCall(Object ipRange) {
                CallSite key = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{ipRange, IndyInterface.bootstrap("getProperty", "ipProtocol", 0, IndyInterface.bootstrap("cast", "()", 0, this.permission.get()))}, new String[]{"", ":", ""}));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, IndyInterface.bootstrap("cast", "()", 0, this.rules.get()), key)) == false) {
                    CallSite rangeParts = IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("getProperty", "cidrIpv6", 0, ipRange), "/");
                    IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("cast", "()", 0, this.rules.get()), key, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"range", IndyInterface.bootstrap("init", "<init>", 0, AddressableRange.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ip", IndyInterface.bootstrap("invoke", "getAt", 0, rangeParts, false), "cidr", new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, rangeParts, true)}, new String[]{"/", ""})})), "protocol", IndyInterface.bootstrap("getProperty", "ipProtocol", 0, IndyInterface.bootstrap("cast", "()", 0, this.permission.get())), "portRanges", (SortedSet)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), SortedSet.class)), "description", IndyInterface.bootstrap("getProperty", "description", 0, ipRange)}));
                }
                CallSite callSite = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "portRanges", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.rules.get()), key)), IndyInterface.bootstrap("init", "<init>", 0, Rule.PortRange.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"startPort", IndyInterface.bootstrap("getProperty", "fromPort", 0, IndyInterface.bootstrap("cast", "()", 0, this.permission.get())), "endPort", IndyInterface.bootstrap("getProperty", "toPort", 0, IndyInterface.bootstrap("cast", "()", 0, this.permission.get()))})));
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.rules.get()), key), (String)"portRanges");
                return callSite;
            }

            @Generated
            public IpPermission getPermission() {
                return IndyInterface.bootstrap("cast", "()", 0, this.permission.get());
            }

            @Generated
            public Map getRules() {
                return IndyInterface.bootstrap("cast", "()", 0, this.rules.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addIpRangeRules_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "ipv6Ranges", 0, (IpPermission)permission2.get()), new _addIpRangeRules_closure6(this, this, permission2, rules2));
        public final class _addIpRangeRules_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference permission;
            private /* synthetic */ Reference rules;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addIpRangeRules_closure7(Object _outerInstance, Object _thisObject, Reference permission, Reference rules) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.permission = reference2 = permission;
                this.rules = reference = rules;
            }

            public Object doCall(Object ipRange) {
                CallSite key = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{ipRange, IndyInterface.bootstrap("getProperty", "ipProtocol", 0, IndyInterface.bootstrap("cast", "()", 0, this.permission.get()))}, new String[]{"", ":", ""}));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, IndyInterface.bootstrap("cast", "()", 0, this.rules.get()), key)) == false) {
                    CallSite rangeParts = IndyInterface.bootstrap("invoke", "split", 0, IndyInterface.bootstrap("getProperty", "cidrIp", 0, ipRange), "/");
                    IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("cast", "()", 0, this.rules.get()), key, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"range", IndyInterface.bootstrap("init", "<init>", 0, AddressableRange.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ip", IndyInterface.bootstrap("invoke", "getAt", 0, rangeParts, false), "cidr", new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, rangeParts, true)}, new String[]{"/", ""})})), "protocol", IndyInterface.bootstrap("getProperty", "ipProtocol", 0, IndyInterface.bootstrap("cast", "()", 0, this.permission.get())), "portRanges", (SortedSet)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), SortedSet.class)), "description", IndyInterface.bootstrap("getProperty", "description", 0, ipRange)}));
                }
                CallSite callSite = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("getProperty", "portRanges", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.rules.get()), key)), IndyInterface.bootstrap("init", "<init>", 0, Rule.PortRange.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"startPort", IndyInterface.bootstrap("getProperty", "fromPort", 0, IndyInterface.bootstrap("cast", "()", 0, this.permission.get())), "endPort", IndyInterface.bootstrap("getProperty", "toPort", 0, IndyInterface.bootstrap("cast", "()", 0, this.permission.get()))})));
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("cast", "()", 0, this.rules.get()), key), (String)"portRanges");
                return callSite;
            }

            @Generated
            public IpPermission getPermission() {
                return IndyInterface.bootstrap("cast", "()", 0, this.permission.get());
            }

            @Generated
            public Map getRules() {
                return IndyInterface.bootstrap("cast", "()", 0, this.rules.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addIpRangeRules_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "ipv4Ranges", 0, (IpPermission)permission2.get()), new _addIpRangeRules_closure7(this, this, permission2, rules2));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AmazonSecurityGroupProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AmazonSecurityGroupProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AmazonSecurityGroupProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AmazonSecurityGroupProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AmazonSecurityGroupProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AmazonSecurityGroupProvider.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public final String getCloudProvider() {
        return this.cloudProvider;
    }

    @Generated
    public final CredentialsRepository<NetflixAmazonCredentials> getCredentialsRepository() {
        return this.credentialsRepository;
    }

    @Generated
    public final Cache getCacheView() {
        return this.cacheView;
    }

    @Generated
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @ToString
    @EqualsAndHashCode
    public static class GroupAndProtocol
    implements GroovyObject {
        private String groupId;
        private String protocol;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public GroupAndProtocol(String groupId, String protocol) {
            String string;
            String string2;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.groupId = string2 = groupId;
            this.protocol = string = protocol;
        }

        @Generated
        public GroupAndProtocol(String groupId) {
            this(groupId, null);
        }

        @Generated
        public GroupAndProtocol() {
            this(null, null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != GroupAndProtocol.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        @Generated
        public String toString() {
            CallSite _result = IndyInterface.bootstrap("init", "<init>", 0, StringBuilder.class);
            Boolean $toStringFirst = Boolean.TRUE;
            IndyInterface.bootstrap("invoke", "append", 0, _result, "com.netflix.spinnaker.clouddriver.aws.provider.view.AmazonSecurityGroupProvider$GroupAndProtocol(");
            if (IndyInterface.bootstrap("cast", "()", 0, $toStringFirst) != false) {
                $toStringFirst = Boolean.FALSE;
            } else {
                IndyInterface.bootstrap("invoke", "append", 0, _result, ", ");
            }
            IndyInterface.bootstrap("invoke", "append", 0, _result, IndyInterface.bootstrap("invoke", "toString", 0, FormatHelper.class, IndyInterface.bootstrap("invoke", "getGroupId", 2, this)));
            if (IndyInterface.bootstrap("cast", "()", 0, $toStringFirst) != false) {
                $toStringFirst = Boolean.FALSE;
            } else {
                IndyInterface.bootstrap("invoke", "append", 0, _result, ", ");
            }
            IndyInterface.bootstrap("invoke", "append", 0, _result, IndyInterface.bootstrap("invoke", "toString", 0, FormatHelper.class, IndyInterface.bootstrap("invoke", "getProtocol", 2, this)));
            IndyInterface.bootstrap("invoke", "append", 0, _result, ")");
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toString", 0, _result));
        }

        @Generated
        public int hashCode() {
            CallSite _result = IndyInterface.bootstrap("invoke", "initHash", 0, HashCodeHelper.class);
            if (ScriptBytecodeAdapter.compareNotIdentical((Object)IndyInterface.bootstrap("invoke", "getGroupId", 2, this), (Object)this)) {
                _result = IndyInterface.bootstrap("invoke", "updateHash", 0, HashCodeHelper.class, _result, IndyInterface.bootstrap("invoke", "getGroupId", 2, this));
            }
            if (ScriptBytecodeAdapter.compareNotIdentical((Object)IndyInterface.bootstrap("invoke", "getProtocol", 2, this), (Object)this)) {
                _result = IndyInterface.bootstrap("invoke", "updateHash", 0, HashCodeHelper.class, _result, IndyInterface.bootstrap("invoke", "getProtocol", 2, this));
            }
            return DefaultTypeTransformation.intUnbox((Object)_result);
        }

        @Generated
        public boolean canEqual(Object other) {
            return other instanceof GroupAndProtocol;
        }

        @Generated
        public boolean equals(Object other) {
            if (ScriptBytecodeAdapter.compareEqual(null, (Object)other)) {
                return false;
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "is", 2, this, other)) != false) {
                return true;
            }
            if (!(other instanceof GroupAndProtocol)) {
                return false;
            }
            GroupAndProtocol otherTyped = (GroupAndProtocol)other;
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "canEqual", 0, otherTyped, this)) == false) {
                return false;
            }
            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getGroupId", 2, this), (Object)IndyInterface.bootstrap("invoke", "getGroupId", 0, otherTyped))) {
                return false;
            }
            return !(!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getProtocol", 2, this), (Object)IndyInterface.bootstrap("invoke", "getProtocol", 0, otherTyped)));
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GroupAndProtocol.class, AmazonSecurityGroupProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GroupAndProtocol.class, AmazonSecurityGroupProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(GroupAndProtocol.class, AmazonSecurityGroupProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(GroupAndProtocol.class, AmazonSecurityGroupProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(GroupAndProtocol.class, AmazonSecurityGroupProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(GroupAndProtocol.class, AmazonSecurityGroupProvider.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), GroupAndProtocol.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AmazonSecurityGroupProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AmazonSecurityGroupProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), GroupAndProtocol.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GroupAndProtocol.class, AmazonSecurityGroupProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(GroupAndProtocol.class, AmazonSecurityGroupProvider.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), GroupAndProtocol.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public void setGroupId(String string) {
            this.groupId = string;
        }

        @Generated
        public String getProtocol() {
            return this.protocol;
        }

        @Generated
        public void setProtocol(String string) {
            this.protocol = string;
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }
    }
}

