/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security.config;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.util.CollectionUtils;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.netflix.spinnaker.clouddriver.aws.security.AWSAccountInfoLookup;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.DefaultAWSAccountInfoLookup;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.config.AccountsConfiguration;
import com.netflix.spinnaker.clouddriver.aws.security.config.CredentialsConfig;
import com.netflix.spinnaker.credentials.definition.CredentialsParser;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonCredentialsParser<U extends AccountsConfiguration.Account, V extends NetflixAmazonCredentials>
implements CredentialsParser<U, V> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AmazonCredentialsParser.class);
    private final AWSCredentialsProvider credentialsProvider;
    private final AWSAccountInfoLookup awsAccountInfoLookup;
    private final Map<String, String> templateValues;
    private final CredentialTranslator<V> credentialTranslator;
    private final ObjectMapper objectMapper;
    private final CredentialsConfig credentialsConfig;
    private final AccountsConfiguration accountsConfig;
    private final ConcurrentMap<String, CredentialsConfig.Region> regionCache;
    private List<String> defaultRegionNames;
    private static final String DEFAULT_REGIONS_PROCESSED_KEY = "default_regions_processed";

    public AmazonCredentialsParser(AWSCredentialsProvider credentialsProvider, AmazonClientProvider amazonClientProvider, Class<V> credentialsType, CredentialsConfig credentialsConfig, AccountsConfiguration accountsConfig) {
        this(credentialsProvider, new DefaultAWSAccountInfoLookup(credentialsProvider, amazonClientProvider), credentialsType, credentialsConfig, accountsConfig);
    }

    public AmazonCredentialsParser(AWSCredentialsProvider credentialsProvider, AWSAccountInfoLookup awsAccountInfoLookup, Class<V> credentialsType, CredentialsConfig credentialsConfig, AccountsConfiguration accountsConfig) {
        this.credentialsProvider = Objects.requireNonNull(credentialsProvider, "credentialsProvider");
        this.awsAccountInfoLookup = awsAccountInfoLookup;
        this.templateValues = Collections.emptyMap();
        this.objectMapper = new ObjectMapper();
        this.credentialTranslator = AmazonCredentialsParser.findTranslator(credentialsType, this.objectMapper);
        this.credentialsConfig = credentialsConfig;
        this.accountsConfig = accountsConfig;
        this.regionCache = Maps.newConcurrentMap();
        this.defaultRegionNames = new ArrayList<String>();
        if (!CollectionUtils.isNullOrEmpty(credentialsConfig.getDefaultRegions())) {
            this.defaultRegionNames = credentialsConfig.getDefaultRegions().stream().map(CredentialsConfig.Region::getName).collect(Collectors.toList());
        }
    }

    private List<CredentialsConfig.Region> initRegions(List<CredentialsConfig.Region> toInit) {
        this.initializeRegionsCacheWithDefaultRegions();
        if (CollectionUtils.isNullOrEmpty(toInit)) {
            return this.getRegionsFromCache(this.defaultRegionNames);
        }
        Map toInitByName = toInit.stream().collect(Collectors.toMap(CredentialsConfig.Region::getName, Function.identity()));
        List<Object> result = new ArrayList<CredentialsConfig.Region>(toInit.size());
        ArrayList<String> toLookup = new ArrayList<String>();
        for (CredentialsConfig.Region region : toInit) {
            if (CollectionUtils.isNullOrEmpty(region.getAvailabilityZones())) {
                CredentialsConfig.Region fromCache = (CredentialsConfig.Region)this.regionCache.get(region.getName());
                if (fromCache != null) {
                    result.add(fromCache);
                    continue;
                }
                toLookup.add(region.getName());
                continue;
            }
            result.add(region);
        }
        if (!toLookup.isEmpty()) {
            List<CredentialsConfig.Region> resolved = this.getRegionsFromCache(toLookup);
            for (CredentialsConfig.Region region : resolved) {
                CredentialsConfig.Region src = AmazonCredentialsParser.find(toInit, region.getName());
                if (src == null) continue;
                region.setPreferredZones(src.getPreferredZones());
            }
            result.addAll(resolved);
        }
        result = result.stream().map(CredentialsConfig.Region::copyOf).collect(Collectors.toList());
        for (CredentialsConfig.Region region : result) {
            CredentialsConfig.Region toInitRegion = (CredentialsConfig.Region)toInitByName.get(region.getName());
            if (toInitRegion == null || toInitRegion.getDeprecated() == null) continue;
            region.setDeprecated(toInitRegion.getDeprecated());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRegionsCacheWithDefaultRegions() {
        AmazonCredentialsParser amazonCredentialsParser = this;
        synchronized (amazonCredentialsParser) {
            if (!this.regionCache.containsKey(DEFAULT_REGIONS_PROCESSED_KEY)) {
                if (this.defaultRegionNames.isEmpty()) {
                    log.info("No default regions specified in the configuration. Retrieving all the regions");
                    AmazonCredentialsParser.toRegion(this.awsAccountInfoLookup.listRegions(new String[0])).forEach(region -> {
                        log.info("adding region: {} to regions cache", (Object)region.getName());
                        this.regionCache.putIfAbsent(region.getName(), (CredentialsConfig.Region)region);
                    });
                } else {
                    ArrayList<String> toLookup = new ArrayList<String>();
                    for (CredentialsConfig.Region region2 : this.credentialsConfig.getDefaultRegions()) {
                        log.info("Found default region: {} in the configuration", (Object)region2.getName());
                        if (region2.getAvailabilityZones() != null && !region2.getAvailabilityZones().isEmpty()) {
                            log.info("Adding default region: {} to the regions cache", (Object)region2.getName());
                            this.regionCache.put(region2.getName(), region2);
                            continue;
                        }
                        toLookup.add(region2.getName());
                    }
                    if (!toLookup.isEmpty()) {
                        log.info("Fetching default regions: {}", toLookup);
                        List<AmazonCredentials.AWSRegion> newRegions = this.awsAccountInfoLookup.listRegions(toLookup);
                        AmazonCredentialsParser.toRegion(newRegions).forEach(region -> {
                            log.info("adding default region: {} to the regions cache", (Object)region.getName());
                            CredentialsConfig.Region fromDefault = AmazonCredentialsParser.find(this.credentialsConfig.getDefaultRegions(), region.getName());
                            if (fromDefault != null) {
                                region.setPreferredZones(fromDefault.getPreferredZones());
                                region.setDeprecated(fromDefault.getDeprecated());
                            }
                            this.regionCache.put(region.getName(), (CredentialsConfig.Region)region);
                        });
                    }
                }
                this.regionCache.put(DEFAULT_REGIONS_PROCESSED_KEY, new CredentialsConfig.Region());
            }
        }
    }

    private static CredentialsConfig.Region find(List<CredentialsConfig.Region> src, String name) {
        if (src != null) {
            for (CredentialsConfig.Region r : src) {
                if (!r.getName().equals(name)) continue;
                return r;
            }
        }
        return null;
    }

    private List<CredentialsConfig.Region> getRegionsFromCache(List<String> regionNames) {
        if (regionNames.isEmpty()) {
            return this.regionCache.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(DEFAULT_REGIONS_PROCESSED_KEY)).map(Map.Entry::getValue).collect(Collectors.toList());
        }
        ArrayList<String> cacheMisses = new ArrayList<String>();
        for (String region2 : regionNames) {
            if (this.regionCache.containsKey(region2)) continue;
            cacheMisses.add(region2);
        }
        if (!cacheMisses.isEmpty()) {
            log.info("Regions: {} do not exist in the regions cache", cacheMisses);
            List<AmazonCredentials.AWSRegion> newRegions = this.awsAccountInfoLookup.listRegions(cacheMisses);
            AmazonCredentialsParser.toRegion(newRegions).forEach(region -> {
                log.info("adding region: {} to regions cache", (Object)region.getName());
                this.regionCache.putIfAbsent(region.getName(), (CredentialsConfig.Region)region);
            });
        }
        return regionNames.stream().map(this.regionCache::get).collect(Collectors.toList());
    }

    private static List<CredentialsConfig.Region> toRegion(List<AmazonCredentials.AWSRegion> src) {
        ArrayList<CredentialsConfig.Region> result = new ArrayList<CredentialsConfig.Region>(src.size());
        for (AmazonCredentials.AWSRegion r : src) {
            CredentialsConfig.Region region = new CredentialsConfig.Region();
            region.setName(r.getName());
            region.setAvailabilityZones(new ArrayList<String>(r.getAvailabilityZones()));
            region.setPreferredZones(new ArrayList<String>(r.getPreferredZones()));
            result.add(region);
        }
        return result;
    }

    public List<V> load(CredentialsConfig source) throws Throwable {
        CredentialsConfig config = (CredentialsConfig)this.objectMapper.convertValue((Object)source, CredentialsConfig.class);
        if (this.accountsConfig.getAccounts() == null || this.accountsConfig.getAccounts().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<V> initializedAccounts = new ArrayList<V>(this.accountsConfig.getAccounts().size());
        for (AccountsConfiguration.Account account : this.accountsConfig.getAccounts()) {
            initializedAccounts.add(this.parseAccount(config, account));
        }
        return initializedAccounts.stream().filter(AmazonCredentials::isEnabled).collect(Collectors.toList());
    }

    @Nullable
    public V parse(@NotNull U account) {
        try {
            log.info("Parsing aws account: {}", (Object)((AccountsConfiguration.Account)account).getName());
            V a = this.parseAccount(this.credentialsConfig, (AccountsConfiguration.Account)account);
            if (((AmazonCredentials)((Object)a)).isEnabled()) {
                log.info("AWS account: {} is enabled", (Object)((AccountsConfiguration.Account)account).getName());
                return a;
            }
            log.info("AWS account: {} is disabled", (Object)((AccountsConfiguration.Account)account).getName());
        }
        catch (Throwable t) {
            log.warn("Failed to parse aws account: {}. Error: ", (Object)((AccountsConfiguration.Account)account).getName(), (Object)t);
        }
        return null;
    }

    private V parseAccount(CredentialsConfig config, AccountsConfiguration.Account account) throws Throwable {
        if (account.getAccountId() == null) {
            if (!this.credentialTranslator.resolveAccountId()) {
                throw new IllegalArgumentException("accountId is required and not resolvable for this credentials type");
            }
            account.setAccountId(this.awsAccountInfoLookup.findAccountId());
        }
        if (account.getEnvironment() == null) {
            account.setEnvironment(account.getName());
        }
        if (account.getAccountType() == null) {
            account.setAccountType(account.getName());
        }
        log.info("Setting regions for aws account: {}", (Object)account.getName());
        account.setRegions(this.initRegions(account.getRegions()));
        account.setDefaultSecurityGroups(account.getDefaultSecurityGroups() != null ? account.getDefaultSecurityGroups() : config.getDefaultSecurityGroups());
        account.setLifecycleHooks(account.getLifecycleHooks() != null ? account.getLifecycleHooks() : config.getDefaultLifecycleHooks());
        account.setEnabled(Optional.ofNullable(account.getEnabled()).orElse(true));
        HashMap<String, String> templateContext = new HashMap<String, String>(this.templateValues);
        templateContext.put("name", account.getName());
        templateContext.put("accountId", account.getAccountId());
        templateContext.put("environment", account.getEnvironment());
        templateContext.put("accountType", account.getAccountType());
        account.setDefaultKeyPair(AmazonCredentialsParser.templateFirstNonNull(templateContext, account.getDefaultKeyPair(), config.getDefaultKeyPairTemplate()));
        account.setEdda(AmazonCredentialsParser.templateFirstNonNull(templateContext, account.getEdda(), config.getDefaultEddaTemplate()));
        account.setFront50(AmazonCredentialsParser.templateFirstNonNull(templateContext, account.getFront50(), config.getDefaultFront50Template()));
        account.setDiscovery(AmazonCredentialsParser.templateFirstNonNull(templateContext, account.getDiscovery(), config.getDefaultDiscoveryTemplate()));
        account.setAssumeRole(AmazonCredentialsParser.templateFirstNonNull(templateContext, account.getAssumeRole(), config.getDefaultAssumeRole()));
        account.setSessionName(AmazonCredentialsParser.templateFirstNonNull(templateContext, account.getSessionName(), config.getDefaultSessionName()));
        account.setBastionHost(AmazonCredentialsParser.templateFirstNonNull(templateContext, account.getBastionHost(), config.getDefaultBastionHostTemplate()));
        if (account.getLifecycleHooks() != null) {
            for (CredentialsConfig.LifecycleHook lifecycleHook : account.getLifecycleHooks()) {
                lifecycleHook.setRoleARN(AmazonCredentialsParser.templateFirstNonNull(templateContext, lifecycleHook.getRoleARN(), config.getDefaultLifecycleHookRoleARNTemplate()));
                lifecycleHook.setNotificationTargetARN(AmazonCredentialsParser.templateFirstNonNull(templateContext, lifecycleHook.getNotificationTargetARN(), config.getDefaultLifecycleHookNotificationTargetARNTemplate()));
            }
        }
        return (V)((Object)((NetflixAmazonCredentials)((Object)this.credentialTranslator.translate(this.credentialsProvider, account))));
    }

    private static String templateFirstNonNull(Map<String, String> substitutions, String ... values) {
        for (String value : values) {
            if (value == null) continue;
            return StringTemplater.render(value, substitutions);
        }
        return null;
    }

    static <T extends AmazonCredentials> CredentialTranslator<T> findTranslator(Class<T> credentialsType, ObjectMapper objectMapper) {
        return new CopyConstructorTranslator<T>(objectMapper, credentialsType);
    }

    static interface CredentialTranslator<T extends AmazonCredentials> {
        public Class<T> getCredentialType();

        public boolean resolveAccountId();

        public T translate(AWSCredentialsProvider var1, AccountsConfiguration.Account var2) throws Throwable;
    }

    static class StringTemplater {
        StringTemplater() {
        }

        public static String render(String template, Map<String, String> substitutions) {
            String base = template;
            int iterations = 0;
            boolean changed = true;
            while (changed && iterations < 10) {
                ++iterations;
                String previous = base;
                for (Map.Entry<String, String> substitution : substitutions.entrySet()) {
                    base = base.replaceAll(Pattern.quote("{{" + substitution.getKey() + "}}"), substitution.getValue());
                }
                changed = !previous.equals(base);
            }
            if (changed) {
                throw new RuntimeException("too many levels of templatery");
            }
            return base;
        }
    }

    static class CopyConstructorTranslator<T extends AmazonCredentials>
    implements CredentialTranslator<T> {
        private final ObjectMapper objectMapper;
        private final Class<T> credentialType;
        private final Constructor<T> copyConstructor;

        public CopyConstructorTranslator(ObjectMapper objectMapper, Class<T> credentialType) {
            this.objectMapper = objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            this.credentialType = credentialType;
            try {
                this.copyConstructor = credentialType.getConstructor(credentialType, AWSCredentialsProvider.class);
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalArgumentException("Class " + credentialType + " must supply a constructor with " + credentialType + ", " + AWSCredentialsProvider.class + " args.");
            }
        }

        @Override
        public Class<T> getCredentialType() {
            return this.credentialType;
        }

        @Override
        public boolean resolveAccountId() {
            try {
                this.credentialType.getMethod("getAssumeRole", new Class[0]);
                return false;
            }
            catch (NoSuchMethodException nsme) {
                return true;
            }
        }

        @Override
        public T translate(AWSCredentialsProvider credentialsProvider, AccountsConfiguration.Account account) throws Throwable {
            AmazonCredentials immutableInstance = (AmazonCredentials)((Object)this.objectMapper.convertValue((Object)account, this.credentialType));
            try {
                return (T)((Object)((AmazonCredentials)((Object)this.copyConstructor.newInstance(new Object[]{immutableInstance, credentialsProvider}))));
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
    }
}

