/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security.sdkclient;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.retry.RetryPolicy;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.RateLimiter;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.aws.security.AWSProxy;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixSTSAssumeRoleSessionCredentialsProvider;
import com.netflix.spinnaker.clouddriver.aws.security.sdkclient.LoadingCacheMetrics;
import com.netflix.spinnaker.clouddriver.aws.security.sdkclient.RateLimiterSupplier;
import com.netflix.spinnaker.clouddriver.aws.security.sdkclient.RateLimitingRequestHandler;
import com.netflix.spinnaker.clouddriver.aws.security.sdkclient.SpinnakerAwsRegionProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.springframework.util.ReflectionUtils;

public class AwsSdkClientSupplier {
    private final Registry registry;
    private final LoadingCache<AmazonClientKey<?>, ?> awsSdkClients;
    private final RateLimiterSupplier rateLimiterSupplier;

    public AwsSdkClientSupplier(RateLimiterSupplier rateLimiterSupplier, Registry registry, RetryPolicy retryPolicy, List<RequestHandler2> requestHandlers, AWSProxy proxy, boolean useGzip) {
        this.rateLimiterSupplier = Objects.requireNonNull(rateLimiterSupplier);
        this.registry = Objects.requireNonNull(registry);
        this.awsSdkClients = CacheBuilder.newBuilder().recordStats().expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new SdkClientCacheLoader(retryPolicy, requestHandlers, proxy, useGzip));
        LoadingCacheMetrics.instrument("awsSdkClientSupplier", registry, this.awsSdkClients);
    }

    public <T> T getClient(Class<? extends AwsClientBuilder<?, T>> impl, Class<T> iface, String account, AWSCredentialsProvider awsCredentialsProvider, String region) {
        return this.getClient(impl, iface, account, awsCredentialsProvider, region, null);
    }

    public <T> T getClient(Class<? extends AwsClientBuilder<?, T>> impl, Class<T> iface, String account, AWSCredentialsProvider awsCredentialsProvider, String region, ClientConfiguration clientConfig) {
        RequestHandler2 handler = this.getRateLimiterHandler(iface, account, region);
        AmazonClientKey key = new AmazonClientKey(impl, awsCredentialsProvider, region, handler, clientConfig);
        try {
            return iface.cast(this.awsSdkClients.get(key));
        }
        catch (ExecutionException executionException) {
            if (executionException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)executionException.getCause();
            }
            throw new RuntimeException("Failed creating amazon client", executionException.getCause());
        }
    }

    private RequestHandler2 getRateLimiterHandler(Class<?> sdkInterface, String account, String region) {
        RateLimiter limiter = this.rateLimiterSupplier.getRateLimiter(sdkInterface, account, region);
        Counter rateLimitCounter = this.registry.counter("amazonClientProvider.rateLimitDelayMillis", new String[]{"clientType", sdkInterface.getSimpleName(), "account", account, "region", region == null ? "UNSPECIFIED" : region});
        return new RateLimitingRequestHandler(rateLimitCounter, limiter);
    }

    private static class SdkClientCacheLoader
    extends CacheLoader<AmazonClientKey<?>, Object> {
        private final RetryPolicy retryPolicy;
        private final List<RequestHandler2> requestHandlers;
        private final AWSProxy proxy;
        private final boolean useGzip;

        public SdkClientCacheLoader(RetryPolicy retryPolicy, List<RequestHandler2> requestHandlers, AWSProxy proxy, boolean useGzip) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy);
            this.requestHandlers = requestHandlers == null ? Collections.emptyList() : ImmutableList.copyOf(requestHandlers);
            this.proxy = proxy;
            this.useGzip = useGzip;
        }

        public Object load(AmazonClientKey<?> key) throws Exception {
            Method m = key.implClass.getDeclaredMethod("standard", new Class[0]);
            AwsClientBuilder builder = key.implClass.cast(m.invoke(null, new Object[0]));
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            if (key.getClientConfiguration() != null) {
                ReflectionUtils.shallowCopyFieldState((Object)key.getClientConfiguration(), (Object)clientConfiguration);
            }
            clientConfiguration.setRetryPolicy(this.getRetryPolicy(key));
            clientConfiguration.setUseGzip(this.useGzip);
            clientConfiguration.setUserAgentSuffix("spinnaker");
            if (this.proxy != null && this.proxy.isProxyConfigMode()) {
                this.proxy.apply(clientConfiguration);
            }
            builder.withCredentials(key.awsCredentialsProvider).withClientConfiguration(clientConfiguration);
            this.getRequestHandlers(key).ifPresent(arg_0 -> builder.withRequestHandlers(arg_0));
            builder.withRegion(key.getRegion().orElseGet(() -> new SpinnakerAwsRegionProvider().getRegion()));
            return builder.build();
        }

        private Optional<RequestHandler2[]> getRequestHandlers(AmazonClientKey<?> key) {
            ArrayList<RequestHandler2> handlers = new ArrayList<RequestHandler2>(this.requestHandlers.size() + 1);
            key.getRequestHandler().ifPresent(handlers::add);
            handlers.addAll(this.requestHandlers);
            if (handlers.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(handlers.toArray(new RequestHandler2[handlers.size()]));
        }

        private RetryPolicy getRetryPolicy(AmazonClientKey<?> key) {
            if (!(key.getAwsCredentialsProvider() instanceof NetflixSTSAssumeRoleSessionCredentialsProvider)) {
                return this.retryPolicy;
            }
            RetryPolicy.RetryCondition delegatingRetryCondition = (originalRequest, exception, retriesAttempted) -> {
                NetflixSTSAssumeRoleSessionCredentialsProvider stsCredentialsProvider = (NetflixSTSAssumeRoleSessionCredentialsProvider)key.getAwsCredentialsProvider();
                if (exception instanceof AmazonServiceException) {
                    ((AmazonServiceException)((Object)((Object)((Object)exception)))).getHttpHeaders().put("targetAccountId", stsCredentialsProvider.getAccountId());
                }
                return this.retryPolicy.getRetryCondition().shouldRetry(originalRequest, exception, retriesAttempted);
            };
            return new RetryPolicy(delegatingRetryCondition, this.retryPolicy.getBackoffStrategy(), this.retryPolicy.getMaxErrorRetry(), this.retryPolicy.isMaxErrorRetryInClientConfigHonored());
        }
    }

    private static class AmazonClientKey<T> {
        private final Class<? extends AwsClientBuilder<?, T>> implClass;
        private final AWSCredentialsProvider awsCredentialsProvider;
        private final Region region;
        private final RequestHandler2 requestHandler;
        private final ClientConfiguration clientConfiguration;

        public AmazonClientKey(Class<? extends AwsClientBuilder<?, T>> implClass, AWSCredentialsProvider awsCredentialsProvider, String region, RequestHandler2 requestHandler, ClientConfiguration configuration) {
            this.implClass = Objects.requireNonNull(implClass);
            this.awsCredentialsProvider = Objects.requireNonNull(awsCredentialsProvider);
            this.region = region == null ? null : RegionUtils.getRegion((String)region);
            this.requestHandler = requestHandler;
            this.clientConfiguration = configuration;
        }

        public Class<? extends AwsClientBuilder<?, T>> getImplClass() {
            return this.implClass;
        }

        public AWSCredentialsProvider getAwsCredentialsProvider() {
            return this.awsCredentialsProvider;
        }

        public Optional<String> getRegion() {
            return Optional.ofNullable(this.region).map(Region::getName);
        }

        public ClientConfiguration getClientConfiguration() {
            return this.clientConfiguration;
        }

        public Optional<RequestHandler2> getRequestHandler() {
            return Optional.ofNullable(this.requestHandler);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AmazonClientKey that = (AmazonClientKey)o;
            if (!this.implClass.equals(that.implClass)) {
                return false;
            }
            if (!this.awsCredentialsProvider.equals(that.awsCredentialsProvider)) {
                return false;
            }
            if (this.region != that.region) {
                return false;
            }
            return Objects.equals(this.requestHandler, that.requestHandler);
        }

        public int hashCode() {
            int result = this.implClass.hashCode();
            result = 31 * result + this.awsCredentialsProvider.hashCode();
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.requestHandler != null ? this.requestHandler.hashCode() : 0);
            return result;
        }
    }
}

