/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.security.sdkclient;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.aws.security.EddaTemplater;
import com.netflix.spinnaker.clouddriver.aws.security.EddaTimeoutConfig;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.sdkclient.AmazonClientInvocationHandler;
import com.netflix.spinnaker.clouddriver.aws.security.sdkclient.AwsSdkClientSupplier;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.HttpClient;

public class ProxyHandlerBuilder {
    private final AwsSdkClientSupplier awsSdkClientSupplier;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;
    private final EddaTemplater eddaTemplater;
    private final EddaTimeoutConfig eddaTimeoutConfig;
    private final Registry registry;

    public ProxyHandlerBuilder(AwsSdkClientSupplier awsSdkClientSupplier, HttpClient httpClient, ObjectMapper objectMapper, EddaTemplater eddaTemplater, EddaTimeoutConfig eddaTimeoutConfig, Registry registry) {
        this.awsSdkClientSupplier = Objects.requireNonNull(awsSdkClientSupplier);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.eddaTemplater = Objects.requireNonNull(eddaTemplater);
        this.eddaTimeoutConfig = eddaTimeoutConfig;
        this.registry = Objects.requireNonNull(registry);
    }

    public <T extends AwsClientBuilder<T, U>, U> U getProxyHandler(Class<U> interfaceKlazz, Class<T> impl, NetflixAmazonCredentials amazonCredentials, String region) {
        return this.getProxyHandler(interfaceKlazz, impl, amazonCredentials, region, false);
    }

    public <T extends AwsClientBuilder<T, U>, U> U getProxyHandler(Class<U> interfaceKlazz, Class<T> impl, NetflixAmazonCredentials amazonCredentials, String region, boolean skipEdda) {
        return this.getProxyHandler(interfaceKlazz, impl, amazonCredentials, region, skipEdda, null);
    }

    public <T extends AwsClientBuilder<T, U>, U> U getProxyHandler(Class<U> interfaceKlazz, Class<T> impl, NetflixAmazonCredentials amazonCredentials, String region, ClientConfiguration clientConfig) {
        return this.getProxyHandler(interfaceKlazz, impl, amazonCredentials, region, false, clientConfig);
    }

    public <T extends AwsClientBuilder<T, U>, U> U getProxyHandler(Class<U> interfaceKlazz, Class<T> impl, NetflixAmazonCredentials amazonCredentials, String region, boolean skipEdda, ClientConfiguration clientConfiguration) {
        Objects.requireNonNull(amazonCredentials, "Credentials cannot be null");
        try {
            U delegate = this.awsSdkClientSupplier.getClient(impl, interfaceKlazz, amazonCredentials.getName(), amazonCredentials.getCredentialsProvider(), region, clientConfiguration);
            if (skipEdda || !amazonCredentials.getEddaEnabled() || this.eddaTimeoutConfig.getDisabledRegions().contains(region)) {
                return delegate;
            }
            return interfaceKlazz.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{interfaceKlazz}, (InvocationHandler)this.getInvocationHandler(delegate, interfaceKlazz.getSimpleName(), region, amazonCredentials)));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Instantiation of client implementation failed!", e);
        }
    }

    protected AmazonClientInvocationHandler getInvocationHandler(Object client, String serviceName, String region, NetflixAmazonCredentials amazonCredentials) {
        ImmutableMap baseTags = ImmutableMap.of((Object)"account", (Object)amazonCredentials.getName(), (Object)"region", (Object)region, (Object)"serviceName", (Object)serviceName);
        return new AmazonClientInvocationHandler(client, serviceName, this.eddaTemplater.getUrl(amazonCredentials.getEdda(), region), this.httpClient, this.objectMapper, this.eddaTimeoutConfig, this.registry, (Map<String, String>)baseTags);
    }
}

