/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.agent;

import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.netflix.spinnaker.cats.agent.RunnableAgent;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.DetachInstancesAtomicOperation;
import com.netflix.spinnaker.clouddriver.aws.provider.AwsCleanupProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.cache.CustomScheduledAgent;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupDetachedInstancesAgent
implements RunnableAgent,
CustomScheduledAgent,
GroovyObject {
    public static final long DEFAULT_POLL_INTERVAL_MILLIS;
    public static final long DEFAULT_TIMEOUT_MILLIS;
    private final AmazonClientProvider amazonClientProvider;
    private final CredentialsRepository<NetflixAmazonCredentials> accountCredentialsRepository;
    private final long pollIntervalMillis;
    private final long timeoutMillis;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public CleanupDetachedInstancesAgent(AmazonClientProvider amazonClientProvider, CredentialsRepository<NetflixAmazonCredentials> accountCredentialsRepository) {
        this(amazonClientProvider, accountCredentialsRepository, DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("getProperty", "DEFAULT_POLL_INTERVAL_MILLIS", 0, CleanupDetachedInstancesAgent.class)), DefaultTypeTransformation.longUnbox((Object)IndyInterface.bootstrap("getProperty", "DEFAULT_TIMEOUT_MILLIS", 0, CleanupDetachedInstancesAgent.class)));
    }

    public CleanupDetachedInstancesAgent(AmazonClientProvider amazonClientProvider, CredentialsRepository<NetflixAmazonCredentials> accountCredentialsRepository, long pollIntervalMillis, long timeoutMills) {
        AmazonClientProvider amazonClientProvider2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.amazonClientProvider = amazonClientProvider2 = amazonClientProvider;
        CredentialsRepository<NetflixAmazonCredentials> credentialsRepository = accountCredentialsRepository;
        this.accountCredentialsRepository = credentialsRepository;
        long l = pollIntervalMillis;
        this.pollIntervalMillis = l;
        long l2 = timeoutMills;
        this.timeoutMillis = l2;
    }

    public String getAgentType() {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "simpleName", 0, CleanupDetachedInstancesAgent.class)}, new String[]{"", ""}));
    }

    public String getProviderName() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "PROVIDER_NAME", 0, AwsCleanupProvider.class));
    }

    public void run() {
        public final class _run_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _run_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(NetflixAmazonCredentials credentials) {
                Reference credentials2 = new Reference((Object)credentials);
                public final class _closure4
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference credentials;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure4(Object _outerInstance, Object _thisObject, Reference credentials) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.credentials = reference = credentials;
                    }

                    public Object doCall(AmazonCredentials.AWSRegion region) {
                        Reference region2 = new Reference((Object)region);
                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), IndyInterface.bootstrap("getProperty", "name", 0, (AmazonCredentials.AWSRegion)region2.get())}, new String[]{"Looking for instances pending termination in ", ":", ""})) : null;
                        Reference amazonEC2 = new Reference((Object)IndyInterface.bootstrap("invoke", "getAmazonEC2", 0, IndyInterface.bootstrap("getProperty", "amazonClientProvider", 12, this), IndyInterface.bootstrap("cast", "()", 0, this.credentials.get()), IndyInterface.bootstrap("getProperty", "name", 0, (AmazonCredentials.AWSRegion)region2.get()), true));
                        CallSite describeInstancesRequest = IndyInterface.bootstrap("invoke", "withFilters", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeInstancesRequest.class), IndyInterface.bootstrap("init", "<init>", 0, Filter.class, "tag-key", ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "TAG_PENDING_TERMINATION", 0, DetachInstancesAtomicOperation.class)})));
                        while (true) {
                            CallSite result = IndyInterface.bootstrap("invoke", "describeInstances", 0, amazonEC2.get(), describeInstancesRequest);
                            Reference instanceIdsToTerminate = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                            public final class _closure5
                            extends Closure
                            implements GeneratedClosure {
                                private /* synthetic */ Reference instanceIdsToTerminate;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure5(Object _outerInstance, Object _thisObject, Reference instanceIdsToTerminate) {
                                    super(_outerInstance, _thisObject);
                                    Reference reference;
                                    this.instanceIdsToTerminate = reference = instanceIdsToTerminate;
                                }

                                public Object doCall(Object it) {
                                    public final class _closure7
                                    extends Closure
                                    implements GeneratedClosure {
                                        private static /* synthetic */ ClassInfo $staticClassInfo;
                                        public static transient /* synthetic */ boolean __$stMC;

                                        public _closure7(Object _outerInstance, Object _thisObject) {
                                            super(_outerInstance, _thisObject);
                                        }

                                        public Object doCall(Object it) {
                                            return IndyInterface.bootstrap("invoke", "shouldTerminate", 2, this, it);
                                        }

                                        @Generated
                                        public Object doCall() {
                                            return this.doCall(null);
                                        }

                                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                            if (((Object)((Object)this)).getClass() != _closure7.class) {
                                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                            }
                                            ClassInfo classInfo = $staticClassInfo;
                                            if (classInfo == null) {
                                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                            }
                                            return classInfo.getMetaClass();
                                        }

                                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                            return MethodHandles.lookup();
                                        }
                                    }
                                    return IndyInterface.bootstrap("invoke", "addAll", 0, this.instanceIdsToTerminate.get(), ScriptBytecodeAdapter.getPropertySpreadSafe(_closure5.class, (Object)IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "getInstances", 0, it), new _closure7((Object)this, this.getThisObject())), (String)"instanceId"));
                                }

                                @Generated
                                public Object getInstanceIdsToTerminate() {
                                    return this.instanceIdsToTerminate.get();
                                }

                                @Generated
                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure5.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                    return MethodHandles.lookup();
                                }
                            }
                            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "reservations", 0, result), new _closure5((Object)this, this.getThisObject(), instanceIdsToTerminate));
                            if (IndyInterface.bootstrap("cast", "()", 0, instanceIdsToTerminate.get()) != false) {
                                public final class _closure6
                                extends Closure
                                implements GeneratedClosure {
                                    private /* synthetic */ Reference credentials;
                                    private /* synthetic */ Reference region;
                                    private /* synthetic */ Reference amazonEC2;
                                    private static /* synthetic */ ClassInfo $staticClassInfo;
                                    public static transient /* synthetic */ boolean __$stMC;

                                    public _closure6(Object _outerInstance, Object _thisObject, Reference credentials, Reference region, Reference amazonEC2) {
                                        super(_outerInstance, _thisObject);
                                        Reference reference;
                                        Reference reference2;
                                        Reference reference3;
                                        this.credentials = reference3 = credentials;
                                        this.region = reference2 = region;
                                        this.amazonEC2 = reference = amazonEC2;
                                    }

                                    public Object doCall(Object it) {
                                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isInfoEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "info", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.region.get())), IndyInterface.bootstrap("invoke", "join", 0, it, ",")}, new String[]{"Terminating instances in ", "/", " (instanceIds: ", ")"})) : null;
                                        IndyInterface.bootstrap("invoke", "terminateInstances", 0, this.amazonEC2.get(), IndyInterface.bootstrap("invoke", "withInstanceIds", 0, IndyInterface.bootstrap("init", "<init>", 0, TerminateInstancesRequest.class), it));
                                        return IndyInterface.bootstrap("invoke", "sleep", 0, Thread.class, 500);
                                    }

                                    @Generated
                                    public NetflixAmazonCredentials getCredentials() {
                                        return IndyInterface.bootstrap("cast", "()", 0, this.credentials.get());
                                    }

                                    @Generated
                                    public AmazonCredentials.AWSRegion getRegion() {
                                        return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
                                    }

                                    @Generated
                                    public Object getAmazonEC2() {
                                        return this.amazonEC2.get();
                                    }

                                    @Generated
                                    public Object doCall() {
                                        return this.doCall(null);
                                    }

                                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                        if (((Object)((Object)this)).getClass() != _closure6.class) {
                                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                        }
                                        ClassInfo classInfo = $staticClassInfo;
                                        if (classInfo == null) {
                                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                        }
                                        return classInfo.getMetaClass();
                                    }

                                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                        return MethodHandles.lookup();
                                    }
                                }
                                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "collate", 0, instanceIdsToTerminate.get(), 20), new _closure6((Object)this, this.getThisObject(), this.credentials, region2, amazonEC2));
                            }
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "nextToken", 0, result)) == false) break;
                            IndyInterface.bootstrap("invoke", "withNextToken", 0, describeInstancesRequest, IndyInterface.bootstrap("getProperty", "nextToken", 0, result));
                        }
                        Object var7_7 = null;
                        try {
                            return var7_7;
                        }
                        catch (Exception e) {
                            CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isErrorEnabled", 0, IndyInterface.bootstrap("getProperty", "log", 12, this))) != false ? IndyInterface.bootstrap("invoke", "error", 0, IndyInterface.bootstrap("getProperty", "log", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("cast", "()", 0, this.credentials.get())), IndyInterface.bootstrap("getProperty", "name", 0, (AmazonCredentials.AWSRegion)region2.get()), IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"Error occurred while processing instances pending termination for ", "/", ": ", ""}), e) : null;
                            return callSite2;
                        }
                    }

                    @Generated
                    public Object call(AmazonCredentials.AWSRegion region) {
                        Reference region2 = new Reference((Object)region);
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, (AmazonCredentials.AWSRegion)region2.get());
                    }

                    @Generated
                    public NetflixAmazonCredentials getCredentials() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.credentials.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "regions", 0, (NetflixAmazonCredentials)((Object)credentials2.get())), new _closure4((Object)this, this.getThisObject(), credentials2));
            }

            @Generated
            public Object call(NetflixAmazonCredentials credentials) {
                Reference credentials2 = new Reference((Object)credentials);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, (NetflixAmazonCredentials)((Object)credentials2.get()));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _run_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "getAccounts", 2, this), new _run_closure1(this, this));
    }

    private Set<NetflixAmazonCredentials> getAccounts() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.accountCredentialsRepository));
    }

    public static boolean shouldTerminate(Instance instance) {
        CallSite tags = IndyInterface.bootstrap("getProperty", "tags", 0, instance);
        public final class _shouldTerminate_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _shouldTerminate_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, IndyInterface.bootstrap("getProperty", "key", 0, it), "aws:autoscaling:groupName");
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _shouldTerminate_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite isInASG = IndyInterface.bootstrap("invoke", "find", 0, tags, new _shouldTerminate_closure2(CleanupDetachedInstancesAgent.class, CleanupDetachedInstancesAgent.class));
        public final class _shouldTerminate_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _shouldTerminate_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 0, IndyInterface.bootstrap("getProperty", "key", 0, it), IndyInterface.bootstrap("getProperty", "TAG_PENDING_TERMINATION", 0, DetachInstancesAtomicOperation.class));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _shouldTerminate_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite isPendingTermination = IndyInterface.bootstrap("invoke", "find", 0, tags, new _shouldTerminate_closure3(CleanupDetachedInstancesAgent.class, CleanupDetachedInstancesAgent.class));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 1, IndyInterface.bootstrap("getProperty", "name", 1, IndyInterface.bootstrap("getProperty", "state", 0, instance)), "terminated")) == false && IndyInterface.bootstrap("cast", "()", 0, isInASG) == false && DefaultTypeTransformation.booleanUnbox((Object)isPendingTermination);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CleanupDetachedInstancesAgent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("invoke", "toMillis", 0, IndyInterface.bootstrap("getProperty", "MINUTES", 0, TimeUnit.class), 10);
        DEFAULT_POLL_INTERVAL_MILLIS = DefaultTypeTransformation.longUnbox((Object)callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "toMillis", 0, IndyInterface.bootstrap("getProperty", "MINUTES", 0, TimeUnit.class), 20);
        DEFAULT_TIMEOUT_MILLIS = DefaultTypeTransformation.longUnbox((Object)callSite2);
        CallSite callSite3 = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.agent.CleanupDetachedInstancesAgent");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite3);
    }

    @Generated
    public final AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public final CredentialsRepository<NetflixAmazonCredentials> getAccountCredentialsRepository() {
        return this.accountCredentialsRepository;
    }

    @Generated
    public final long getPollIntervalMillis() {
        return this.pollIntervalMillis;
    }

    @Generated
    public final long getTimeoutMillis() {
        return this.timeoutMillis;
    }
}

