/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.controllers;

import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.aws.data.Keys;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import com.netflix.spinnaker.kork.web.exceptions.InvalidRequestException;
import com.netflix.spinnaker.kork.web.exceptions.NotFoundException;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/aws/images"})
public class AmazonNamedImageLookupController
implements GroovyObject {
    private static final int MAX_SEARCH_RESULTS = 1000;
    private static final int MIN_NAME_FILTER = 3;
    private static final String EXCEPTION_REASON = "Minimum of 3 characters required to filter namedImages";
    private static final Object AMI_GLOB_PATTERN;
    private final Cache cacheView;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Autowired
    public AmazonNamedImageLookupController(Cache cacheView) {
        Cache cache;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.cacheView = cache = cacheView;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{account}/{region}/{imageId:.+}"})
    public List<NamedImage> getByAmiId(@PathVariable String account, @PathVariable String region, @PathVariable String imageId) {
        CallSite cd = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)), IndyInterface.bootstrap("invoke", "getImageKey", 0, Keys.class, imageId, account, region)));
        if (ScriptBytecodeAdapter.compareEqual((Object)cd, null)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, NotFoundException.class, new GStringImpl(new Object[]{imageId, account, region}, new String[]{"", " not found in ", "/", ""})));
        }
        CallSite namedImageKeys = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, cd), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "NAMED_IMAGES", 0, Namespace.class))));
        if (IndyInterface.bootstrap("cast", "()", 0, namedImageKeys) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, NotFoundException.class, new GStringImpl(new Object[]{imageId, account, region}, new String[]{"Name not found on image ", " in ", "/", ""})));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "render", 2, this, null, ScriptBytecodeAdapter.createList((Object[])new Object[]{cd}), null, region));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/find"})
    public List<NamedImage> list(LookupOptions lookupOptions, HttpServletRequest request) {
        CallSite callSite;
        IndyInterface.bootstrap("invoke", "validateLookupOptions", 2, this, lookupOptions);
        CallSite glob = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "trim", 1, IndyInterface.bootstrap("getProperty", "q", 4, lookupOptions)));
        Boolean isAmi = ScriptBytecodeAdapter.matchRegex((Object)glob, (Object)AMI_GLOB_PATTERN);
        if (IndyInterface.bootstrap("cast", "()", 0, isAmi) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, glob, "*")) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, glob, "?")) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, glob, "[")) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, glob, "\\")) == false) {
            glob = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{glob}, new String[]{"*", "*"}));
        }
        CallSite namedImageSearch = IndyInterface.bootstrap("invoke", "getNamedImageKey", 0, Keys.class, IndyInterface.bootstrap("cast", "()", 0, callSite = IndyInterface.bootstrap("getProperty", "account", 4, lookupOptions)) != false ? callSite : "*", glob);
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "account", 4, lookupOptions);
        CallSite callSite3 = IndyInterface.bootstrap("getProperty", "region", 4, lookupOptions);
        CallSite imageSearch = IndyInterface.bootstrap("invoke", "getImageKey", 0, Keys.class, glob, IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : "*", IndyInterface.bootstrap("cast", "()", 0, callSite3) != false ? callSite3 : "*");
        CallSite namedImageIdentifiers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, isAmi) == false ? IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "NAMED_IMAGES", 0, Namespace.class)), namedImageSearch) : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        CallSite imageIdentifiers = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, namedImageIdentifiers)) != false ? IndyInterface.bootstrap("invoke", "filterIdentifiers", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)), imageSearch) : ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        CallSite matchesByName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "NAMED_IMAGES", 0, Namespace.class)), namedImageIdentifiers, IndyInterface.bootstrap("invoke", "include", 0, RelationshipCacheFilter.class, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)))));
        CallSite matchesByImageId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)), imageIdentifiers));
        CallSite allFilteredImages = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "filter", 0, AmazonNamedImageLookupController.class, IndyInterface.bootstrap("invoke", "render", 2, this, matchesByName, matchesByImageId, IndyInterface.bootstrap("getProperty", "q", 4, lookupOptions), IndyInterface.bootstrap("getProperty", "region", 4, lookupOptions)), IndyInterface.bootstrap("invoke", "extractTagFilters", 0, AmazonNamedImageLookupController.class, request)));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "subList", 0, allFilteredImages, false, IndyInterface.bootstrap("invoke", "min", 0, Math.class, MAX_SEARCH_RESULTS, IndyInterface.bootstrap("invoke", "size", 0, allFilteredImages))));
    }

    private List<NamedImage> render(Collection<CacheData> namedImages, Collection<CacheData> images, String requestedName, String requiredRegion) {
        Reference requestedName2 = new Reference((Object)requestedName);
        Reference requiredRegion2 = new Reference((Object)requiredRegion);
        public final class _render_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _render_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("init", "<init>", 0, NamedImage.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"imageName", it}));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _render_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Reference byImageName = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "withDefault", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), new _render_closure1(this, this))));
        public final class _render_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _render_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, it), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)));
                public final class _closure10
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure10(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return it;
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure10.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ScriptBytecodeAdapter.createList((Object[])new Object[0]), new _closure10((Object)this, this.getThisObject()));
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _render_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _render_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference byImageName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _render_closure3(Object _outerInstance, Object _thisObject, Reference byImageName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.byImageName = reference = byImageName;
            }

            public Object doCall(Object it) {
                public final class _closure11
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure11(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "key", 0, it)), IndyInterface.bootstrap("getProperty", "value", 0, it)});
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure11.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                CallSite callSite = IndyInterface.bootstrap("invoke", "collectEntries", 1, (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "tags", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it)), List.class)), new _closure11((Object)this, this.getThisObject()));
                IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "tagsByImageId", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.byImageName.get()), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it)), String.class))), String.class))), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "imageId", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, it)), String.class))), String.class), callSite);
                return callSite;
            }

            @Generated
            public Map getByImageName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.byImageName.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _render_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "getAll", 0, this.cacheView, IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)), ScriptBytecodeAdapter.createPojoWrapper((Object)((Collection)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("invoke", "collect", 0, namedImages, new _render_closure2(this, this))), Collection.class))), Collection.class)), new _render_closure3(this, this, byImageName));
        CallSite data = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, namedImages));
        if (callSite != null) {
            while (callSite.hasNext()) {
                data = IndyInterface.bootstrap("cast", "()", 0, callSite.next());
                CallSite keyParts = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, data)));
                CallSite thisImage = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, (Map)byImageName.get(), IndyInterface.bootstrap("getProperty", "imageName", 0, keyParts)));
                IndyInterface.bootstrap("invoke", "putAll", 0, IndyInterface.bootstrap("getProperty", "attributes", 4, thisImage), IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, data), ScriptBytecodeAdapter.createMap((Object[])new Object[]{"name", IndyInterface.bootstrap("getProperty", "imageName", 0, keyParts)})));
                IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "accounts", 4, thisImage), IndyInterface.bootstrap("getProperty", "account", 0, keyParts));
                CallSite callSite2 = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, data), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "IMAGES", 0, Namespace.class)));
                CallSite imageKey = null;
                CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("cast", "()", 0, callSite2) != false ? callSite2 : ScriptBytecodeAdapter.createList((Object[])new Object[0])));
                if (callSite3 == null) continue;
                while (callSite3.hasNext()) {
                    imageKey = IndyInterface.bootstrap("cast", "()", 0, callSite3.next());
                    CallSite imageParts = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, imageKey));
                    IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "amis", 4, thisImage), IndyInterface.bootstrap("getProperty", "region", 0, imageParts)), IndyInterface.bootstrap("getProperty", "imageId", 0, imageParts));
                }
            }
        }
        CallSite data2 = null;
        CallSite callSite4 = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, images));
        if (callSite4 != null) {
            while (callSite4.hasNext()) {
                data2 = IndyInterface.bootstrap("cast", "()", 0, callSite4.next());
                CallSite amiKeyParts = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("getProperty", "id", 0, data2)));
                CallSite namedImageKeyParts = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, Keys.class, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "relationships", 0, data2), IndyInterface.bootstrap("getProperty", "ns", 0, IndyInterface.bootstrap("getProperty", "NAMED_IMAGES", 0, Namespace.class))), false)));
                CallSite thisImage = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, (Map)byImageName.get(), IndyInterface.bootstrap("getProperty", "imageName", 0, namedImageKeyParts)));
                CallSite callSite5 = IndyInterface.bootstrap("getProperty", "virtualizationType", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, data2));
                ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 4, thisImage), (String)"virtualizationType");
                CallSite callSite6 = IndyInterface.bootstrap("getProperty", "architecture", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, data2));
                ScriptBytecodeAdapter.setProperty((Object)callSite6, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 4, thisImage), (String)"architecture");
                CallSite callSite7 = IndyInterface.bootstrap("getProperty", "creationDate", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, data2));
                ScriptBytecodeAdapter.setProperty((Object)callSite7, null, (Object)IndyInterface.bootstrap("getProperty", "attributes", 4, thisImage), (String)"creationDate");
                IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("getProperty", "accounts", 4, thisImage), IndyInterface.bootstrap("getProperty", "account", 0, namedImageKeyParts));
                IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "amis", 4, thisImage), IndyInterface.bootstrap("getProperty", "region", 0, amiKeyParts)), IndyInterface.bootstrap("getProperty", "imageId", 0, amiKeyParts));
                public final class _render_closure4
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _render_closure4(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "key", 0, it)), IndyInterface.bootstrap("getProperty", "value", 0, it)});
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _render_closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "putAll", 0, IndyInterface.bootstrap("getProperty", "tags", 4, thisImage), IndyInterface.bootstrap("invoke", "collectEntries", 1, (List)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "tags", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, data2)), List.class)), new _render_closure4(this, this)));
                CallSite callSite8 = IndyInterface.bootstrap("getProperty", "tags", 4, thisImage);
                IndyInterface.bootstrap("invoke", "putAt", 0, IndyInterface.bootstrap("getProperty", "tagsByImageId", 4, thisImage), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("getProperty", "imageId", 0, IndyInterface.bootstrap("getProperty", "attributes", 0, data2)), String.class))), String.class), callSite8);
            }
        }
        public final class _render_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference requiredRegion;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _render_closure5(Object _outerInstance, Object _thisObject, Reference requiredRegion) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.requiredRegion = reference = requiredRegion;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.requiredRegion.get())) != false ? IndyInterface.bootstrap("invoke", "containsKey", 0, IndyInterface.bootstrap("getProperty", "amis", 0, it), IndyInterface.bootstrap("cast", "()", 0, this.requiredRegion.get())) : Boolean.valueOf(true);
            }

            @Generated
            public String getRequiredRegion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.requiredRegion.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _render_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite results = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "values", 0, (Map)byImageName.get()), new _render_closure5(this, this, requiredRegion2)));
        public final class _render_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference requestedName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _render_closure6(Object _outerInstance, Object _thisObject, Reference requestedName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.requestedName = reference = requestedName;
            }

            public Object doCall(Object a, Object b) {
                int a1 = 0;
                int b1 = 0;
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.requestedName.get())) != false) {
                    a1 = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, IndyInterface.bootstrap("getProperty", "imageName", 0, a), IndyInterface.bootstrap("cast", "()", 0, this.requestedName.get())));
                    b1 = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, IndyInterface.bootstrap("getProperty", "imageName", 0, b), IndyInterface.bootstrap("cast", "()", 0, this.requestedName.get())));
                } else {
                    a1 = 0;
                    b1 = 0;
                }
                if (a1 == b1) {
                    return ScriptBytecodeAdapter.compareTo((Object)IndyInterface.bootstrap("getProperty", "imageName", 0, a), (Object)IndyInterface.bootstrap("getProperty", "imageName", 0, b));
                }
                return ScriptBytecodeAdapter.compareTo((Object)a1, (Object)b1);
            }

            @Generated
            public Object call(Object a, Object b) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, a, b);
            }

            @Generated
            public String getRequestedName() {
                return IndyInterface.bootstrap("cast", "()", 0, this.requestedName.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _render_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "sort", 0, results, new _render_closure6(this, this, requestedName2)));
    }

    private static List<NamedImage> filter(List<NamedImage> namedImages, Map<String, String> tagFilters) {
        Reference tagFilters2 = new Reference(tagFilters);
        if (IndyInterface.bootstrap("cast", "()", 0, (Map)tagFilters2.get()) == false) {
            return namedImages;
        }
        public final class _filter_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference tagFilters;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _filter_closure7(Object _outerInstance, Object _thisObject, Reference tagFilters) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.tagFilters = reference = tagFilters;
            }

            public Object doCall(NamedImage namedImage) {
                Reference namedImage2 = new Reference((Object)namedImage);
                Reference invalidImageIds = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
                public final class _closure12
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference tagFilters;
                    private /* synthetic */ Reference invalidImageIds;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure12(Object _outerInstance, Object _thisObject, Reference tagFilters, Reference invalidImageIds) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.tagFilters = reference2 = tagFilters;
                        this.invalidImageIds = reference = invalidImageIds;
                    }

                    public Object doCall(String imageId, Map<String, String> tags) {
                        Reference tags2 = new Reference(tags);
                        public final class _closure14
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference tags;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure14(Object _outerInstance, Object _thisObject, Reference tags) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.tags = reference = tags;
                            }

                            public Object doCall(Object it) {
                                return IndyInterface.bootstrap("invoke", "equalsIgnoreCase", 1, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, this.tags.get()), IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "key", 0, it))), IndyInterface.bootstrap("getProperty", "value", 0, it));
                            }

                            @Generated
                            public Map getTags() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.tags.get());
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure14.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        CallSite matches = IndyInterface.bootstrap("invoke", "every", 0, IndyInterface.bootstrap("cast", "()", 0, this.tagFilters.get()), new _closure14((Object)this, this.getThisObject(), tags2));
                        if (IndyInterface.bootstrap("cast", "()", 0, matches) == false) {
                            return IndyInterface.bootstrap("invoke", "leftShift", 0, this.invalidImageIds.get(), imageId);
                        }
                        return null;
                    }

                    @Generated
                    public Object call(String imageId, Map<String, String> tags) {
                        Reference tags2 = new Reference(tags);
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, imageId, (Map)tags2.get());
                    }

                    @Generated
                    public Map getTagFilters() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.tagFilters.get());
                    }

                    @Generated
                    public Object getInvalidImageIds() {
                        return this.invalidImageIds.get();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure12.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "tagsByImageId", 4, (NamedImage)namedImage2.get()), new _closure12((Object)this, this.getThisObject(), this.tagFilters, invalidImageIds));
                public final class _closure13
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference namedImage;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure13(Object _outerInstance, Object _thisObject, Reference namedImage) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.namedImage = reference = namedImage;
                    }

                    public Object doCall(String imageId) {
                        Reference imageId2 = new Reference((Object)imageId);
                        public final class _closure15
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference imageId;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure15(Object _outerInstance, Object _thisObject, Reference imageId) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.imageId = reference = imageId;
                            }

                            public Object doCall(String region, Collection<String> imageIds) {
                                return IndyInterface.bootstrap("invoke", "removeAll", 0, imageIds, IndyInterface.bootstrap("cast", "()", 0, this.imageId.get()));
                            }

                            @Generated
                            public Object call(String region, Collection<String> imageIds) {
                                return IndyInterface.bootstrap("invoke", "doCall", 2, this, region, imageIds);
                            }

                            @Generated
                            public String getImageId() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.imageId.get());
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure15.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "amis", 4, IndyInterface.bootstrap("cast", "()", 0, this.namedImage.get())), new _closure15((Object)this, this.getThisObject(), imageId2));
                        public final class _closure16
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure16(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Object doCall(Object it) {
                                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("getProperty", "value", 0, it))) == false;
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure16.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        CallSite callSite = IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("getProperty", "amis", 4, IndyInterface.bootstrap("cast", "()", 0, this.namedImage.get())), new _closure16((Object)this, this.getThisObject()));
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)callSite, _closure13.class, (GroovyObject)IndyInterface.bootstrap("cast", "()", 0, this.namedImage.get()), (String)"amis");
                        return IndyInterface.bootstrap("invoke", "remove", 0, IndyInterface.bootstrap("getProperty", "tagsByImageId", 4, IndyInterface.bootstrap("cast", "()", 0, this.namedImage.get())), (String)imageId2.get());
                    }

                    @Generated
                    public Object call(String imageId) {
                        Reference imageId2 = new Reference((Object)imageId);
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, (String)imageId2.get());
                    }

                    @Generated
                    public NamedImage getNamedImage() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.namedImage.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure13.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, invalidImageIds.get(), new _closure13((Object)this, this.getThisObject(), namedImage2));
                return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "tagsByImageId", 4, (NamedImage)namedImage2.get())) == false || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("invoke", "values", 0, IndyInterface.bootstrap("getProperty", "amis", 4, (NamedImage)namedImage2.get()))))) ? null : (NamedImage)namedImage2.get();
            }

            @Generated
            public Object call(NamedImage namedImage) {
                Reference namedImage2 = new Reference((Object)namedImage);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, (NamedImage)namedImage2.get());
            }

            @Generated
            public Map getTagFilters() {
                return IndyInterface.bootstrap("cast", "()", 0, this.tagFilters.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _filter_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findResults", 0, namedImages, new _filter_closure7(AmazonNamedImageLookupController.class, AmazonNamedImageLookupController.class, tagFilters2)));
    }

    public void validateLookupOptions(LookupOptions lookupOptions) {
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "q", 4, lookupOptions), null) || ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("invoke", "length", 0, IndyInterface.bootstrap("getProperty", "q", 4, lookupOptions)), (Object)MIN_NAME_FILTER)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidRequestException.class, EXCEPTION_REASON));
        }
        CallSite glob = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "trim", 1, IndyInterface.bootstrap("getProperty", "q", 4, lookupOptions)));
        Boolean isAmi = ScriptBytecodeAdapter.matchRegex((Object)glob, (Object)AMI_GLOB_PATTERN);
        if (ScriptBytecodeAdapter.compareEqual((Object)glob, (Object)"ami") || IndyInterface.bootstrap("cast", "()", 0, isAmi) == false && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "startsWith", 0, glob, "ami-"))) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, InvalidRequestException.class, "Searches by AMI id must be an exact match (ami-xxxxxxxx)"));
        }
    }

    private static Map<String, String> extractTagFilters(HttpServletRequest httpServletRequest) {
        Reference httpServletRequest2 = new Reference((Object)httpServletRequest);
        public final class _extractTagFilters_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractTagFilters_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "startsWith", 0, IndyInterface.bootstrap("invoke", "toLowerCase", 0, it), "tag:");
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractTagFilters_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _extractTagFilters_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference httpServletRequest;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _extractTagFilters_closure9(Object _outerInstance, Object _thisObject, Reference httpServletRequest) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.httpServletRequest = reference = httpServletRequest;
            }

            public Object doCall(String tagParameter) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("invoke", "replaceAll", 0, tagParameter, "tag:", "")), IndyInterface.bootstrap("invoke", "getParameter", 0, IndyInterface.bootstrap("cast", "()", 0, this.httpServletRequest.get()), tagParameter)});
            }

            @Generated
            public Object call(String tagParameter) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, tagParameter);
            }

            @Generated
            public HttpServletRequest getHttpServletRequest() {
                return IndyInterface.bootstrap("cast", "()", 0, this.httpServletRequest.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _extractTagFilters_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return (Map)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "getParameterNames", 0, (HttpServletRequest)httpServletRequest2.get()), new _extractTagFilters_closure8(AmazonNamedImageLookupController.class, AmazonNamedImageLookupController.class)), new _extractTagFilters_closure9(AmazonNamedImageLookupController.class, AmazonNamedImageLookupController.class, httpServletRequest2)), Map.class));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AmazonNamedImageLookupController.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AmazonNamedImageLookupController.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AmazonNamedImageLookupController.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AmazonNamedImageLookupController.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AmazonNamedImageLookupController.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AmazonNamedImageLookupController.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    private List<NamedImage> render(Collection<CacheData> namedImages, Collection<CacheData> images, String requestedName) {
        Reference requestedName2 = new Reference((Object)requestedName);
        return this.render(namedImages, images, (String)requestedName2.get(), null);
    }

    @Generated
    private List<NamedImage> render(Collection<CacheData> namedImages, Collection<CacheData> images) {
        return this.render(namedImages, images, null, null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        String string = "^ami-([a-f0-9]{8}|[a-f0-9]{17})$";
        AMI_GLOB_PATTERN = string;
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.controllers.AmazonNamedImageLookupController");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    private static class NamedImage
    implements GroovyObject {
        private String imageName;
        private Map<String, Object> attributes;
        private Map<String, Map<String, String>> tagsByImageId;
        private Set<String> accounts;
        private Map<String, Collection<String>> amis;
        @Deprecated
        private Map<String, String> tags;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public NamedImage() {
            MetaClass metaClass;
            Map map;
            Map map2;
            Map map3;
            this.attributes = map3 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.tagsByImageId = map2 = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.accounts = IndyInterface.bootstrap("cast", "()", 0, list);
            CallSite callSite = IndyInterface.bootstrap("invoke", "withDefault", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), new _closure1(this, this));
            this.amis = IndyInterface.bootstrap("cast", "()", 0, callSite);
            this.tags = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != NamedImage.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(NamedImage.class, AmazonNamedImageLookupController.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(NamedImage.class, AmazonNamedImageLookupController.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(NamedImage.class, AmazonNamedImageLookupController.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(NamedImage.class, AmazonNamedImageLookupController.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(NamedImage.class, AmazonNamedImageLookupController.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(NamedImage.class, AmazonNamedImageLookupController.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), NamedImage.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AmazonNamedImageLookupController.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AmazonNamedImageLookupController.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), NamedImage.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(NamedImage.class, AmazonNamedImageLookupController.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(NamedImage.class, AmazonNamedImageLookupController.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), NamedImage.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getImageName() {
            return this.imageName;
        }

        @Generated
        public void setImageName(String string) {
            this.imageName = string;
        }

        @Generated
        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @Generated
        public void setAttributes(Map<String, Object> map) {
            this.attributes = map;
        }

        @Generated
        public Map<String, Map<String, String>> getTagsByImageId() {
            return this.tagsByImageId;
        }

        @Generated
        public void setTagsByImageId(Map<String, Map<String, String>> map) {
            this.tagsByImageId = map;
        }

        @Generated
        public Set<String> getAccounts() {
            return this.accounts;
        }

        @Generated
        public void setAccounts(Set<String> set) {
            this.accounts = set;
        }

        @Generated
        public Map<String, Collection<String>> getAmis() {
            return this.amis;
        }

        @Generated
        public void setAmis(Map<String, Collection<String>> map) {
            this.amis = map;
        }

        @Generated
        public Map<String, String> getTags() {
            return this.tags;
        }

        @Generated
        public void setTags(Map<String, String> map) {
            this.tags = map;
        }

        public final class _closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("init", "<init>", 0, HashSet.class);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
    }

    public static class LookupOptions
    implements GroovyObject {
        private String q;
        private String account;
        private String region;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        public LookupOptions() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != LookupOptions.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        /*
         * Unable to fully structure code
         */
        public /* synthetic */ Object methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(LookupOptions.class, AmazonNamedImageLookupController.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var3_3;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var4_4 = ScriptBytecodeAdapter.invokeMethodN(LookupOptions.class, AmazonNamedImageLookupController.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var4_4;
lbl14:
            // 1 sources

            var5_5 = ScriptBytecodeAdapter.invokeMethodN(LookupOptions.class, AmazonNamedImageLookupController.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var5_5;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(LookupOptions.class, AmazonNamedImageLookupController.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(LookupOptions.class, AmazonNamedImageLookupController.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(LookupOptions.class, AmazonNamedImageLookupController.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), LookupOptions.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AmazonNamedImageLookupController.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, AmazonNamedImageLookupController.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), LookupOptions.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(LookupOptions.class, AmazonNamedImageLookupController.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(LookupOptions.class, AmazonNamedImageLookupController.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), LookupOptions.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getQ() {
            return this.q;
        }

        @Generated
        public void setQ(String string) {
            this.q = string;
        }

        @Generated
        public String getAccount() {
            return this.account;
        }

        @Generated
        public void setAccount(String string) {
            this.account = string;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public void setRegion(String string) {
            this.region = string;
        }
    }
}

