/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.data;

import com.amazonaws.services.elasticloadbalancingv2.model.TargetTypeEnum;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.aws.AmazonCloudProvider;
import com.netflix.spinnaker.clouddriver.cache.KeyParser;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.stereotype.Component;

@Component(value="AmazonKeys")
public class Keys
implements KeyParser,
GroovyObject {
    private static final Map<String, String> NAMESPACE_MAPPING;
    private static final Set<String> PARSEABLE_FIELDS;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public Keys() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public String getNameMapping(String cache) {
        return IndyInterface.bootstrap("cast", "()", 0, NAMESPACE_MAPPING.get(cache));
    }

    public String getCloudProvider() {
        return AmazonCloudProvider.ID;
    }

    public Map<String, String> parseKey(String key) {
        return Keys.parse(key);
    }

    public Boolean canParseType(String type) {
        Reference type2 = new Reference((Object)type);
        public final class _canParseType_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference type;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _canParseType_closure1(Object _outerInstance, Object _thisObject, Reference type) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.type = reference = type;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "ns", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.type.get()));
            }

            @Generated
            public String getType() {
                return IndyInterface.bootstrap("cast", "()", 0, this.type.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _canParseType_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "any", 0, IndyInterface.bootstrap("invoke", "values", 0, Namespace.class), new _canParseType_closure1(this, this, type2)));
    }

    public Boolean canParseField(String field) {
        return PARSEABLE_FIELDS.contains(field);
    }

    public static Map<String, String> parse(String key) {
        Object[] parts = key.split(":");
        if (parts.length < 2) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        CallSite result = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"provider", BytecodeInterface8.objectArrayGet((Object[])parts, (int)0), "type", BytecodeInterface8.objectArrayGet((Object[])parts, (int)1)}));
        if (ScriptBytecodeAdapter.compareNotEqual(result.get("provider"), (Object)AmazonCloudProvider.ID)) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        Object v = result.get("type");
        if (ScriptBytecodeAdapter.isCase(v, (Object)Namespace.IMAGES.getNs())) {
            DefaultGroovyMethods.leftShift((Map)((Object)result), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"account", BytecodeInterface8.objectArrayGet((Object[])parts, (int)2), "region", BytecodeInterface8.objectArrayGet((Object[])parts, (int)3), "imageId", BytecodeInterface8.objectArrayGet((Object[])parts, (int)4)}));
        } else if (ScriptBytecodeAdapter.isCase(v, (Object)Namespace.NAMED_IMAGES.getNs())) {
            DefaultGroovyMethods.leftShift((Map)((Object)result), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"account", BytecodeInterface8.objectArrayGet((Object[])parts, (int)2), "imageName", BytecodeInterface8.objectArrayGet((Object[])parts, (int)3)}));
        } else if (ScriptBytecodeAdapter.isCase(v, (Object)Namespace.SERVER_GROUPS.getNs())) {
            Integer n;
            Names names = Names.parseName((String)((Object)IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])parts, (int)5))));
            DefaultGroovyMethods.leftShift((Map)((Object)result), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"application", names.getApp().toLowerCase(), "cluster", BytecodeInterface8.objectArrayGet((Object[])parts, (int)2), "account", BytecodeInterface8.objectArrayGet((Object[])parts, (int)3), "region", BytecodeInterface8.objectArrayGet((Object[])parts, (int)4), "serverGroup", BytecodeInterface8.objectArrayGet((Object[])parts, (int)5), "stack", names.getStack(), "detail", names.getDetail(), "sequence", (n = names.getSequence()) != null ? n.toString() : null}));
        } else if (ScriptBytecodeAdapter.isCase(v, (Object)Namespace.INSTANCES.getNs())) {
            DefaultGroovyMethods.leftShift((Map)((Object)result), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"account", BytecodeInterface8.objectArrayGet((Object[])parts, (int)2), "region", BytecodeInterface8.objectArrayGet((Object[])parts, (int)3), "instanceId", BytecodeInterface8.objectArrayGet((Object[])parts, (int)4)}));
        } else if (ScriptBytecodeAdapter.isCase(v, (Object)Namespace.LAUNCH_CONFIGS.getNs())) {
            String string;
            Names names = Names.parseName((String)((Object)IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])parts, (int)4))));
            DefaultGroovyMethods.leftShift((Map)((Object)result), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"account", BytecodeInterface8.objectArrayGet((Object[])parts, (int)2), "region", BytecodeInterface8.objectArrayGet((Object[])parts, (int)3), "launchConfig", BytecodeInterface8.objectArrayGet((Object[])parts, (int)4), "application", (string = names.getApp()) != null ? string.toLowerCase() : null, "stack", names.getStack()}));
        } else if (ScriptBytecodeAdapter.isCase(v, (Object)Namespace.LOAD_BALANCERS.getNs())) {
            CallSite callSite;
            Names names = Names.parseName((String)((Object)IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])parts, (int)4))));
            if (parts.length > 5) {
                Object object = BytecodeInterface8.objectArrayGet((Object[])parts, (int)5);
                CallSite callSite2 = IndyInterface.bootstrap("cast", "()", 0, object);
                callSite = IndyInterface.bootstrap("cast", "()", 0, object) != false ? callSite2 : null;
            } else {
                callSite = null;
            }
            CallSite vpcId = IndyInterface.bootstrap("cast", "()", 0, callSite);
            String loadBalancerType = DefaultTypeTransformation.booleanUnbox((Object)vpcId) && parts.length > 6 ? IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])parts, (int)6)) : "classic";
            Object[] objectArray = new Object[16];
            objectArray[0] = "account";
            objectArray[1] = BytecodeInterface8.objectArrayGet((Object[])parts, (int)2);
            objectArray[2] = "region";
            objectArray[3] = BytecodeInterface8.objectArrayGet((Object[])parts, (int)3);
            objectArray[4] = "loadBalancer";
            objectArray[5] = BytecodeInterface8.objectArrayGet((Object[])parts, (int)4);
            objectArray[6] = "vpcId";
            objectArray[7] = vpcId;
            objectArray[8] = "application";
            String string = names.getApp();
            objectArray[9] = string != null ? string.toLowerCase() : null;
            objectArray[10] = "stack";
            objectArray[11] = names.getStack();
            objectArray[12] = "detail";
            objectArray[13] = names.getDetail();
            objectArray[14] = "loadBalancerType";
            objectArray[15] = loadBalancerType;
            DefaultGroovyMethods.leftShift((Map)((Object)result), (Map)ScriptBytecodeAdapter.createMap((Object[])objectArray));
        } else if (ScriptBytecodeAdapter.isCase(v, (Object)Namespace.TARGET_GROUPS.getNs())) {
            CallSite callSite;
            Names names = Names.parseName((String)((Object)IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])parts, (int)4))));
            if (parts.length > 6) {
                Object object = BytecodeInterface8.objectArrayGet((Object[])parts, (int)6);
                CallSite callSite3 = IndyInterface.bootstrap("cast", "()", 0, object);
                callSite = IndyInterface.bootstrap("cast", "()", 0, object) != false ? callSite3 : null;
            } else {
                callSite = null;
            }
            CallSite vpcId = IndyInterface.bootstrap("cast", "()", 0, callSite);
            Object[] objectArray = new Object[16];
            objectArray[0] = "account";
            objectArray[1] = BytecodeInterface8.objectArrayGet((Object[])parts, (int)2);
            objectArray[2] = "region";
            objectArray[3] = BytecodeInterface8.objectArrayGet((Object[])parts, (int)3);
            objectArray[4] = "targetGroup";
            objectArray[5] = BytecodeInterface8.objectArrayGet((Object[])parts, (int)4);
            objectArray[6] = "vpcId";
            objectArray[7] = vpcId;
            objectArray[8] = "application";
            String string = names.getApp();
            objectArray[9] = string != null ? string.toLowerCase() : null;
            objectArray[10] = "stack";
            objectArray[11] = names.getStack();
            objectArray[12] = "detail";
            objectArray[13] = names.getDetail();
            objectArray[14] = "targetType";
            objectArray[15] = BytecodeInterface8.objectArrayGet((Object[])parts, (int)5);
            DefaultGroovyMethods.leftShift((Map)((Object)result), (Map)ScriptBytecodeAdapter.createMap((Object[])objectArray));
        } else if (ScriptBytecodeAdapter.isCase(v, (Object)Namespace.CLUSTERS.getNs())) {
            Names names = Names.parseName((String)((Object)IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])parts, (int)4))));
            DefaultGroovyMethods.leftShift((Map)((Object)result), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"application", ((String)BytecodeInterface8.objectArrayGet((Object[])parts, (int)2)).toLowerCase(), "account", BytecodeInterface8.objectArrayGet((Object[])parts, (int)3), "cluster", BytecodeInterface8.objectArrayGet((Object[])parts, (int)4), "stack", names.getStack(), "detail", names.getDetail()}));
        } else if (ScriptBytecodeAdapter.isCase(v, (Object)Namespace.APPLICATIONS.getNs())) {
            DefaultGroovyMethods.leftShift((Map)((Object)result), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"application", ((String)BytecodeInterface8.objectArrayGet((Object[])parts, (int)2)).toLowerCase()}));
        } else if (ScriptBytecodeAdapter.isCase(v, (Object)Namespace.HEALTH.getNs())) {
            DefaultGroovyMethods.leftShift((Map)((Object)result), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"instanceId", BytecodeInterface8.objectArrayGet((Object[])parts, (int)2), "account", BytecodeInterface8.objectArrayGet((Object[])parts, (int)3), "region", BytecodeInterface8.objectArrayGet((Object[])parts, (int)4), "provider", BytecodeInterface8.objectArrayGet((Object[])parts, (int)5)}));
        } else if (ScriptBytecodeAdapter.isCase(v, (Object)Namespace.STACKS.getNs())) {
            DefaultGroovyMethods.leftShift((Map)((Object)result), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"stackId", BytecodeInterface8.objectArrayGet((Object[])parts, (int)2), "account", BytecodeInterface8.objectArrayGet((Object[])parts, (int)3), "region", BytecodeInterface8.objectArrayGet((Object[])parts, (int)4)}));
        } else if (ScriptBytecodeAdapter.isCase(v, (Object)Namespace.LAUNCH_TEMPLATES.getNs())) {
            String string;
            Names names = Names.parseName((String)((Object)IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])parts, (int)4))));
            DefaultGroovyMethods.leftShift((Map)((Object)result), (Map)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"account", BytecodeInterface8.objectArrayGet((Object[])parts, (int)2), "region", BytecodeInterface8.objectArrayGet((Object[])parts, (int)3), "launchTemplateName", BytecodeInterface8.objectArrayGet((Object[])parts, (int)4), "application", (string = names.getApp()) != null ? string.toLowerCase() : null, "stack", names.getStack()}));
        } else {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        return result;
    }

    public static String getImageKey(String imageId, String account, String region) {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{AmazonCloudProvider.ID, Namespace.IMAGES, account, region, imageId}, new String[]{"", ":", ":", ":", ":", ""}));
    }

    public static String getNamedImageKey(String account, String imageName) {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{AmazonCloudProvider.ID, Namespace.NAMED_IMAGES, account, imageName}, new String[]{"", ":", ":", ":", ""}));
    }

    public static String getServerGroupKey(String autoScalingGroupName, String account, String region) {
        Names names = Names.parseName((String)autoScalingGroupName);
        return Keys.getServerGroupKey(names.getCluster(), names.getGroup(), account, region);
    }

    public static String getServerGroupKey(String cluster, String autoScalingGroupName, String account, String region) {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{AmazonCloudProvider.ID, Namespace.SERVER_GROUPS, cluster, account, region, autoScalingGroupName}, new String[]{"", ":", ":", ":", ":", ":", ""}));
    }

    public static String getInstanceKey(String instanceId, String account, String region) {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{AmazonCloudProvider.ID, Namespace.INSTANCES, account, region, instanceId}, new String[]{"", ":", ":", ":", ":", ""}));
    }

    public static String getLaunchConfigKey(String launchConfigName, String account, String region) {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{AmazonCloudProvider.ID, Namespace.LAUNCH_CONFIGS, account, region, launchConfigName}, new String[]{"", ":", ":", ":", ":", ""}));
    }

    public static String getLoadBalancerKey(String loadBalancerName, String account, String region, String vpcId, String loadBalancerType) {
        Object key = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{AmazonCloudProvider.ID, Namespace.LOAD_BALANCERS, account, region, loadBalancerName}, new String[]{"", ":", ":", ":", ":", ""}));
        String string = vpcId;
        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) != false) {
            key = StringGroovyMethods.plus((String)key, (CharSequence)new GStringImpl(new Object[]{vpcId}, new String[]{":", ""}));
            if (DefaultTypeTransformation.booleanUnbox((Object)loadBalancerType) && ScriptBytecodeAdapter.compareNotEqual((Object)loadBalancerType, (Object)"classic")) {
                key = StringGroovyMethods.plus((String)key, (CharSequence)new GStringImpl(new Object[]{loadBalancerType}, new String[]{":", ""}));
            }
        }
        return key;
    }

    public static String getTargetGroupKey(String targetGroupName, String account, String region, String targetGroupType, String vpcId) {
        if (TargetTypeEnum.Lambda.toString().equalsIgnoreCase(targetGroupType)) {
            return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{AmazonCloudProvider.ID, Namespace.TARGET_GROUPS, account, region, targetGroupName, targetGroupType}, new String[]{"", ":", ":", ":", ":", ":", ""}));
        }
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{AmazonCloudProvider.ID, Namespace.TARGET_GROUPS, account, region, targetGroupName, targetGroupType, vpcId}, new String[]{"", ":", ":", ":", ":", ":", ":", ""}));
    }

    public static String getClusterKey(String clusterName, String application, String account) {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{AmazonCloudProvider.ID, Namespace.CLUSTERS, application.toLowerCase(), account, clusterName}, new String[]{"", ":", ":", ":", ":", ""}));
    }

    public static String getApplicationKey(String application) {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{AmazonCloudProvider.ID, Namespace.APPLICATIONS, application.toLowerCase()}, new String[]{"", ":", ":", ""}));
    }

    public static String getInstanceHealthKey(String instanceId, String account, String region, String provider) {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{AmazonCloudProvider.ID, Namespace.HEALTH, instanceId, account, region, provider}, new String[]{"", ":", ":", ":", ":", ":", ""}));
    }

    public static String getReservedInstancesKey(String reservedInstancesId, String account, String region) {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{AmazonCloudProvider.ID, Namespace.RESERVED_INSTANCES, account, region, reservedInstancesId}, new String[]{"", ":", ":", ":", ":", ""}));
    }

    public static String getCloudFormationKey(String stackId, String accountName, String region) {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{AmazonCloudProvider.ID, Namespace.STACKS, accountName, region, stackId}, new String[]{"", ":", ":", ":", ":", ""}));
    }

    public static String getLaunchTemplateKey(String launchTemplateName, String account, String region) {
        return IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{AmazonCloudProvider.ID, Namespace.LAUNCH_TEMPLATES, account, region, launchTemplateName}, new String[]{"", ":", ":", ":", ":", ""}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Keys.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        ImmutableSet immutableSet;
        ImmutableMap immutableMap;
        NAMESPACE_MAPPING = immutableMap = ImmutableMap.builder().put((Object)Namespace.SERVER_GROUPS.getNs(), (Object)"serverGroup").put((Object)Namespace.INSTANCES.getNs(), (Object)"instanceId").put((Object)Namespace.LOAD_BALANCERS.getNs(), (Object)"loadBalancer").put((Object)Namespace.TARGET_GROUPS.getNs(), (Object)"targetGroup").put((Object)Namespace.CLUSTERS.getNs(), (Object)"cluster").put((Object)Namespace.APPLICATIONS.getNs(), (Object)"application").put((Object)Namespace.STACKS.getNs(), (Object)"stacks").build();
        PARSEABLE_FIELDS = immutableSet = ImmutableSet.builder().addAll((Iterable)Namespace.SERVER_GROUPS.getFields()).addAll((Iterable)Namespace.LOAD_BALANCERS.getFields()).build();
    }

    public /* synthetic */ String super$1$getNameMapping(String string) {
        return super.getNameMapping(string);
    }
}

