/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.asg;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.Ebs;
import com.amazonaws.services.autoscaling.model.LaunchConfiguration;
import com.amazonaws.services.autoscaling.model.LaunchTemplateOverrides;
import com.amazonaws.services.autoscaling.model.LaunchTemplateSpecification;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.CreditSpecification;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.LaunchTemplateBlockDeviceMapping;
import com.amazonaws.services.ec2.model.LaunchTemplateEbsBlockDevice;
import com.amazonaws.services.ec2.model.LaunchTemplateVersion;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AutoScalingWorker;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.BasicAmazonDeployDescription;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonBlockDevice;
import com.netflix.spinnaker.clouddriver.aws.services.RegionScopedProviderFactory;
import com.netflix.spinnaker.clouddriver.aws.services.SecurityGroupService;
import com.netflix.spinnaker.clouddriver.helpers.OperationPoller;
import com.netflix.spinnaker.config.AwsConfiguration;
import com.netflix.spinnaker.kork.annotations.VisibleForTesting;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsgConfigHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsgConfigHelper.class);
    private static final AtomicReference<Clock> CLOCK_REF = new AtomicReference<Clock>(Clock.systemDefaultZone());
    private static final DateTimeFormatter SUFFIX_DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendValue(ChronoField.YEAR).appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();

    public static String createName(String baseName, String suffix) {
        StringBuilder name = new StringBuilder(baseName);
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            name.append('-').append(suffix);
        } else {
            name.append('-').append(AsgConfigHelper.createDefaultSuffix());
        }
        return name.toString();
    }

    public static AutoScalingWorker.AsgConfiguration setAppSecurityGroups(AutoScalingWorker.AsgConfiguration asgConfig, SecurityGroupService securityGroupService, AwsConfiguration.DeployDefaults deployDefaults) {
        List<String> securityGroupIds = securityGroupService.resolveSecurityGroupIdsWithSubnetType(asgConfig.getSecurityGroups(), asgConfig.getSubnetType());
        if (securityGroupIds == null || securityGroupIds.isEmpty() || deployDefaults.isAddAppGroupToServerGroup() && securityGroupIds.size() < deployDefaults.getMaxSecurityGroups()) {
            String existingAppGroup;
            Map<String, String> names = securityGroupService.getSecurityGroupNamesFromIds(securityGroupIds);
            String string = existingAppGroup = names != null && !names.isEmpty() ? (String)names.keySet().stream().filter(it -> it.contains(asgConfig.getApplication())).findFirst().orElse(null) : null;
            if (StringUtils.isEmpty(existingAppGroup)) {
                String applicationSecurityGroupId = (String)OperationPoller.retryWithBackoff(o -> AsgConfigHelper.createSecurityGroupForApp(securityGroupService, asgConfig.getApplication(), asgConfig.getSubnetType()), (long)500L, (int)3);
                securityGroupIds.add(applicationSecurityGroupId);
            }
        }
        asgConfig.setSecurityGroups(securityGroupIds.stream().distinct().collect(Collectors.toList()));
        if (asgConfig.getClassicLinkVpcSecurityGroups() != null && !asgConfig.getClassicLinkVpcSecurityGroups().isEmpty()) {
            if (StringUtils.isEmpty((CharSequence)asgConfig.getClassicLinkVpcId())) {
                throw new IllegalStateException("Can't provide classic link security groups without classiclink vpc Id");
            }
            List<String> classicLinkIds = securityGroupService.resolveSecurityGroupIdsInVpc(asgConfig.getClassicLinkVpcSecurityGroups(), asgConfig.getClassicLinkVpcId());
            asgConfig.setClassicLinkVpcSecurityGroups(classicLinkIds);
        }
        log.info("Configured resolved security groups {} for application {}.", securityGroupIds, (Object)asgConfig.getApplication());
        return asgConfig;
    }

    public static List<AmazonBlockDevice> getBlockDeviceMappingForAsg(AutoScalingGroup asg, RegionScopedProviderFactory.RegionScopedProvider asgRegionScopedProvider) {
        if (asg.getLaunchConfigurationName() != null) {
            LaunchConfiguration lc = asgRegionScopedProvider.getAsgService().getLaunchConfiguration(asg.getLaunchConfigurationName());
            if (lc == null) {
                throw new IllegalStateException("Launch configuration " + asg.getLaunchConfigurationName() + " was requested but was not found for ASG with launch configuration " + asg.getAutoScalingGroupName());
            }
            return AsgConfigHelper.transformBlockDeviceMapping(lc.getBlockDeviceMappings());
        }
        if (asg.getLaunchTemplate() != null) {
            LaunchTemplateVersion ltVersion = asgRegionScopedProvider.getLaunchTemplateService().getLaunchTemplateVersion(asg.getLaunchTemplate()).orElseThrow(() -> new IllegalStateException("Launch template " + String.valueOf(asg.getLaunchTemplate()) + " was requested but was not found for ASG with launch template " + asg.getAutoScalingGroupName()));
            return AsgConfigHelper.transformLaunchTemplateBlockDeviceMapping(ltVersion.getLaunchTemplateData().getBlockDeviceMappings());
        }
        if (asg.getMixedInstancesPolicy() != null) {
            LaunchTemplateSpecification ltSpec = asg.getMixedInstancesPolicy().getLaunchTemplate().getLaunchTemplateSpecification();
            LaunchTemplateVersion ltVersion = asgRegionScopedProvider.getLaunchTemplateService().getLaunchTemplateVersion(ltSpec).orElseThrow(() -> new IllegalStateException("Launch template " + String.valueOf(ltSpec) + " was requested but was not found for ASG with mixed instances policy " + asg.getAutoScalingGroupName()));
            return AsgConfigHelper.transformLaunchTemplateBlockDeviceMapping(ltVersion.getLaunchTemplateData().getBlockDeviceMappings());
        }
        throw new IllegalStateException(String.format("An AWS ASG %s is expected to have a launch configuration or launch template or mixed instances policy", asg.getAutoScalingGroupName()));
    }

    public static Set<String> getAllowedInstanceTypesForAsg(AutoScalingGroup asg, RegionScopedProviderFactory.RegionScopedProvider asgRegionScopedProvider) {
        if (asg.getMixedInstancesPolicy() != null && asg.getMixedInstancesPolicy().getLaunchTemplate().getOverrides() != null) {
            return asg.getMixedInstancesPolicy().getLaunchTemplate().getOverrides().stream().map(override -> override.getInstanceType()).collect(Collectors.toSet());
        }
        return Collections.singleton(AsgConfigHelper.getTopLevelInstanceTypeForAsg(asg, asgRegionScopedProvider));
    }

    public static String getTopLevelInstanceTypeForAsg(AutoScalingGroup asg, RegionScopedProviderFactory.RegionScopedProvider asgRegionScopedProvider) {
        if (asg.getLaunchConfigurationName() != null) {
            LaunchConfiguration lc = asgRegionScopedProvider.getAsgService().getLaunchConfiguration(asg.getLaunchConfigurationName());
            if (lc == null) {
                throw new IllegalStateException(String.format("Launch configuration %s was requested but was not found for ASG with launch configuration %s.", asg.getLaunchConfigurationName(), asg.getAutoScalingGroupName()));
            }
            return lc.getInstanceType();
        }
        if (asg.getLaunchTemplate() != null) {
            LaunchTemplateVersion ltVersion = asgRegionScopedProvider.getLaunchTemplateService().getLaunchTemplateVersion(asg.getLaunchTemplate()).orElseThrow(() -> new IllegalStateException(String.format("Launch template %s was requested but was not found for ASG with launch template %s.", asg.getLaunchTemplate(), asg.getAutoScalingGroupName())));
            return ltVersion.getLaunchTemplateData().getInstanceType();
        }
        if (asg.getMixedInstancesPolicy() != null) {
            LaunchTemplateSpecification ltSpec = asg.getMixedInstancesPolicy().getLaunchTemplate().getLaunchTemplateSpecification();
            LaunchTemplateVersion ltVersion = asgRegionScopedProvider.getLaunchTemplateService().getLaunchTemplateVersion(ltSpec).orElseThrow(() -> new IllegalStateException(String.format("Launch template %s was requested but was not found for ASG with mixed instances policy %s.", ltSpec, asg.getAutoScalingGroupName())));
            return ltVersion.getLaunchTemplateData().getInstanceType();
        }
        throw new IllegalStateException("An AWS ASG is expected to include a launch configuration or launch template or mixed instances policy but neither was found in ASG " + String.valueOf(asg));
    }

    private static String createSecurityGroupForApp(SecurityGroupService securityGroupService, String application, String subnetType) {
        String applicationSecurityGroupId = securityGroupService.getSecurityGroupForApplication(application, subnetType);
        if (StringUtils.isEmpty((CharSequence)applicationSecurityGroupId)) {
            log.debug("Creating security group for application {}", (Object)application);
            applicationSecurityGroupId = securityGroupService.createSecurityGroup(application, subnetType);
        }
        return applicationSecurityGroupId;
    }

    @VisibleForTesting
    static void setClock(Clock clock) {
        CLOCK_REF.setOpaque(clock);
    }

    @VisibleForTesting
    static String createDefaultSuffix() {
        return LocalDateTime.now(CLOCK_REF.getOpaque()).format(SUFFIX_DATE_FORMATTER);
    }

    protected static List<AmazonBlockDevice> transformBlockDeviceMapping(List<com.amazonaws.services.autoscaling.model.BlockDeviceMapping> blockDeviceMappings) {
        return blockDeviceMappings.stream().map(bdm -> {
            AmazonBlockDevice amzBd = new AmazonBlockDevice.Builder().deviceName(bdm.getDeviceName()).virtualName(bdm.getVirtualName()).build();
            if (bdm.getEbs() != null) {
                Ebs ebs = bdm.getEbs();
                amzBd.setIops(ebs.getIops());
                amzBd.setThroughput(ebs.getThroughput());
                amzBd.setDeleteOnTermination(ebs.getDeleteOnTermination());
                amzBd.setSize(ebs.getVolumeSize());
                amzBd.setVolumeType(ebs.getVolumeType());
                amzBd.setSnapshotId(ebs.getSnapshotId());
                if (ebs.getSnapshotId() == null) {
                    amzBd.setEncrypted(ebs.getEncrypted());
                }
            }
            return amzBd;
        }).collect(Collectors.toUnmodifiableList());
    }

    protected static List<AmazonBlockDevice> convertBlockDevices(List<BlockDeviceMapping> blockDeviceMappings) {
        return blockDeviceMappings.stream().map(bdm -> {
            AmazonBlockDevice amzBd = new AmazonBlockDevice.Builder().deviceName(bdm.getDeviceName()).virtualName(bdm.getVirtualName()).build();
            if (bdm.getEbs() != null) {
                EbsBlockDevice ebs = bdm.getEbs();
                amzBd.setIops(ebs.getIops());
                amzBd.setDeleteOnTermination(ebs.getDeleteOnTermination());
                amzBd.setSize(ebs.getVolumeSize());
                amzBd.setVolumeType(ebs.getVolumeType());
                amzBd.setSnapshotId(ebs.getSnapshotId());
                if (ebs.getKmsKeyId() != null) {
                    amzBd.setKmsKeyId(ebs.getKmsKeyId());
                }
                if (ebs.getSnapshotId() == null) {
                    amzBd.setEncrypted(ebs.getEncrypted());
                }
            }
            return amzBd;
        }).collect(Collectors.toList());
    }

    public static List<AmazonBlockDevice> transformLaunchTemplateBlockDeviceMapping(List<LaunchTemplateBlockDeviceMapping> launchTemplateBlockDeviceMappings) {
        return launchTemplateBlockDeviceMappings.stream().map(ltBdm -> {
            AmazonBlockDevice amzBd = new AmazonBlockDevice.Builder().deviceName(ltBdm.getDeviceName()).virtualName(ltBdm.getVirtualName()).build();
            if (ltBdm.getEbs() != null) {
                LaunchTemplateEbsBlockDevice ebs = ltBdm.getEbs();
                amzBd.setIops(ebs.getIops());
                amzBd.setThroughput(ebs.getThroughput());
                amzBd.setDeleteOnTermination(ebs.getDeleteOnTermination());
                amzBd.setSize(ebs.getVolumeSize());
                amzBd.setVolumeType(ebs.getVolumeType());
                amzBd.setSnapshotId(ebs.getSnapshotId());
                if (ebs.getSnapshotId() == null) {
                    amzBd.setEncrypted(ebs.getEncrypted());
                }
            }
            return amzBd;
        }).collect(Collectors.toUnmodifiableList());
    }

    public static Boolean getUnlimitedCpuCreditsFromAncestorLt(CreditSpecification sourceAsgCreditSpec, boolean isBurstingSupportedByAllTypesRequested) {
        if (sourceAsgCreditSpec == null) {
            return null;
        }
        return isBurstingSupportedByAllTypesRequested ? Boolean.valueOf(sourceAsgCreditSpec.getCpuCredits().equals("unlimited")) : null;
    }

    public static List<LaunchTemplateOverrides> getLaunchTemplateOverrides(List<BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType> overridesInReq) {
        if (overridesInReq == null || overridesInReq.isEmpty()) {
            return null;
        }
        overridesInReq.sort(Comparator.comparing(BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType::getPriority, Comparator.nullsLast(Comparator.naturalOrder())));
        List ltOverrides = overridesInReq.stream().map(o -> new LaunchTemplateOverrides().withInstanceType(o.getInstanceType()).withWeightedCapacity(o.getWeightedCapacity())).collect(Collectors.toCollection(ArrayList::new));
        return ltOverrides;
    }

    public static List<BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType> getDescriptionOverrides(List<LaunchTemplateOverrides> ltOverrides) {
        if (ltOverrides == null || ltOverrides.isEmpty()) {
            return null;
        }
        AtomicInteger priority = new AtomicInteger(1);
        List<BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType> descOverrides = ltOverrides.stream().map(ltOv -> new BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType.Builder().instanceType(ltOv.getInstanceType()).weightedCapacity(ltOv.getWeightedCapacity()).priority(priority.getAndIncrement()).build()).collect(Collectors.toList());
        return descOverrides;
    }
}

