/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.asg;

import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AWSServerGroupNameResolver;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.LaunchTemplateRollOutConfig;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.asgbuilders.AsgBuilder;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.BasicAmazonDeployDescription;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonAsgLifecycleHook;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonBlockDevice;
import com.netflix.spinnaker.clouddriver.aws.model.AutoScalingProcessType;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.services.RegionScopedProviderFactory;
import com.netflix.spinnaker.clouddriver.aws.userdata.UserDataOverride;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoScalingWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoScalingWorker.class);
    private static final String AWS_PHASE = "AWS_DEPLOY";
    private RegionScopedProviderFactory.RegionScopedProvider regionScopedProvider;
    private LaunchTemplateRollOutConfig launchTemplateRollOutConfig;

    AutoScalingWorker(RegionScopedProviderFactory.RegionScopedProvider regionScopedProvider, LaunchTemplateRollOutConfig launchTemplateRollOutConfig) {
        this.regionScopedProvider = regionScopedProvider;
        this.launchTemplateRollOutConfig = launchTemplateRollOutConfig;
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public String deploy(AsgConfiguration asgConfig) {
        AsgBuilder asgBuilder;
        AutoScalingWorker.getTask().updateStatus(AWS_PHASE, "Beginning Amazon deployment.");
        if (asgConfig.startDisabled != null && asgConfig.startDisabled.booleanValue()) {
            asgConfig.suspendedProcesses.addAll(AutoScalingProcessType.getDisableProcesses().stream().map(Enum::name).collect(Collectors.toList()));
        }
        AutoScalingWorker.getTask().updateStatus(AWS_PHASE, "Beginning ASG deployment.");
        AWSServerGroupNameResolver awsServerGroupNameResolver = this.regionScopedProvider.getAWSServerGroupNameResolver();
        String asgName = asgConfig.sequence != null ? AWSServerGroupNameResolver.generateServerGroupName((String)asgConfig.application, (String)asgConfig.stack, (String)asgConfig.freeFormDetails, (Integer)asgConfig.sequence, (Boolean)false) : awsServerGroupNameResolver.resolveNextServerGroupName(asgConfig.application, asgConfig.stack, asgConfig.freeFormDetails, asgConfig.ignoreSequence);
        if (this.shouldSetLaunchTemplate(asgConfig)) {
            if (asgConfig.getAssociateIPv6Address() == null) {
                String asgConfigEnv = asgConfig.getCredentials().getEnvironment();
                Boolean autoEnableIPv6 = this.launchTemplateRollOutConfig.isIpv6EnabledForEnv(asgConfigEnv);
                asgConfig.setAssociateIPv6Address(autoEnableIPv6);
            }
            asgBuilder = asgConfig.shouldUseMixedInstancesPolicy() ? this.regionScopedProvider.getAsgBuilderForMixedInstancesPolicy() : this.regionScopedProvider.getAsgBuilderForLaunchTemplate();
        } else {
            asgBuilder = this.regionScopedProvider.getAsgBuilderForLaunchConfiguration();
        }
        return asgBuilder.build(AutoScalingWorker.getTask(), AWS_PHASE, asgName, asgConfig);
    }

    private boolean shouldSetLaunchTemplate(AsgConfiguration asgConfig) {
        if (asgConfig.setLaunchTemplate == null || !asgConfig.setLaunchTemplate.booleanValue()) {
            return false;
        }
        return this.launchTemplateRollOutConfig.shouldUseLaunchTemplateForReq(asgConfig.application, asgConfig.credentials, asgConfig.region);
    }

    public static class AsgConfiguration {
        private String application;
        private String region;
        private NetflixAmazonCredentials credentials;
        private String stack;
        private String freeFormDetails;
        private String ami;
        private String classicLinkVpcId;
        private List<String> classicLinkVpcSecurityGroups;
        private String instanceType;
        private String iamRole;
        private String keyPair;
        private String base64UserData;
        private Boolean legacyUdf;
        private UserDataOverride userDataOverride;
        private Integer sequence;
        private Boolean ignoreSequence;
        private Boolean startDisabled;
        private Boolean associatePublicIpAddress;
        private String subnetType;
        private List<String> subnetIds;
        private Integer cooldown;
        private Collection<String> enabledMetrics;
        private Integer healthCheckGracePeriod;
        private String healthCheckType;
        private String spotMaxPrice;
        private Set<String> suspendedProcesses;
        private Collection<String> terminationPolicies;
        private String kernelId;
        private String ramdiskId;
        private Boolean instanceMonitoring;
        private Boolean ebsOptimized;
        private Collection<String> classicLoadBalancers;
        private Collection<String> targetGroupArns;
        private List<String> securityGroups;
        private List<String> availabilityZones;
        private List<AmazonBlockDevice> blockDevices;
        private Map<String, String> tags;
        private Map<String, String> blockDeviceTags;
        private List<AmazonAsgLifecycleHook> lifecycleHooks;
        private Boolean capacityRebalance;
        private int minInstances;
        private int maxInstances;
        private int desiredInstances;
        private Boolean setLaunchTemplate;
        private Boolean requireIMDSv2;
        private Boolean associateIPv6Address;
        private Boolean unlimitedCpuCredits;
        private BasicAmazonDeployDescription.LaunchTemplatePlacement placement;
        private List<BasicAmazonDeployDescription.LaunchTemplateLicenseSpecification> licenseSpecifications;
        private Boolean enableEnclave;
        private String onDemandAllocationStrategy;
        private Integer onDemandBaseCapacity;
        private Integer onDemandPercentageAboveBaseCapacity;
        private String spotAllocationStrategy;
        private Integer spotInstancePools;
        private List<BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType> launchTemplateOverridesForInstanceType;

        private AsgConfiguration() {
        }

        public boolean shouldUseMixedInstancesPolicy() {
            for (String fieldName : BasicAmazonDeployDescription.getMixedInstancesPolicyFieldNames()) {
                try {
                    if (this.getClass().getDeclaredField(fieldName).get(this) == null) continue;
                    return true;
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
            return false;
        }

        @Generated
        public static AsgConfigurationBuilder builder() {
            return new AsgConfigurationBuilder();
        }

        @Generated
        public String getApplication() {
            return this.application;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public NetflixAmazonCredentials getCredentials() {
            return this.credentials;
        }

        @Generated
        public String getStack() {
            return this.stack;
        }

        @Generated
        public String getFreeFormDetails() {
            return this.freeFormDetails;
        }

        @Generated
        public String getAmi() {
            return this.ami;
        }

        @Generated
        public String getClassicLinkVpcId() {
            return this.classicLinkVpcId;
        }

        @Generated
        public List<String> getClassicLinkVpcSecurityGroups() {
            return this.classicLinkVpcSecurityGroups;
        }

        @Generated
        public String getInstanceType() {
            return this.instanceType;
        }

        @Generated
        public String getIamRole() {
            return this.iamRole;
        }

        @Generated
        public String getKeyPair() {
            return this.keyPair;
        }

        @Generated
        public String getBase64UserData() {
            return this.base64UserData;
        }

        @Generated
        public Boolean getLegacyUdf() {
            return this.legacyUdf;
        }

        @Generated
        public UserDataOverride getUserDataOverride() {
            return this.userDataOverride;
        }

        @Generated
        public Integer getSequence() {
            return this.sequence;
        }

        @Generated
        public Boolean getIgnoreSequence() {
            return this.ignoreSequence;
        }

        @Generated
        public Boolean getStartDisabled() {
            return this.startDisabled;
        }

        @Generated
        public Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Generated
        public String getSubnetType() {
            return this.subnetType;
        }

        @Generated
        public List<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Generated
        public Integer getCooldown() {
            return this.cooldown;
        }

        @Generated
        public Collection<String> getEnabledMetrics() {
            return this.enabledMetrics;
        }

        @Generated
        public Integer getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Generated
        public String getHealthCheckType() {
            return this.healthCheckType;
        }

        @Generated
        public String getSpotMaxPrice() {
            return this.spotMaxPrice;
        }

        @Generated
        public Set<String> getSuspendedProcesses() {
            return this.suspendedProcesses;
        }

        @Generated
        public Collection<String> getTerminationPolicies() {
            return this.terminationPolicies;
        }

        @Generated
        public String getKernelId() {
            return this.kernelId;
        }

        @Generated
        public String getRamdiskId() {
            return this.ramdiskId;
        }

        @Generated
        public Boolean getInstanceMonitoring() {
            return this.instanceMonitoring;
        }

        @Generated
        public Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Generated
        public Collection<String> getClassicLoadBalancers() {
            return this.classicLoadBalancers;
        }

        @Generated
        public Collection<String> getTargetGroupArns() {
            return this.targetGroupArns;
        }

        @Generated
        public List<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Generated
        public List<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Generated
        public List<AmazonBlockDevice> getBlockDevices() {
            return this.blockDevices;
        }

        @Generated
        public Map<String, String> getTags() {
            return this.tags;
        }

        @Generated
        public Map<String, String> getBlockDeviceTags() {
            return this.blockDeviceTags;
        }

        @Generated
        public List<AmazonAsgLifecycleHook> getLifecycleHooks() {
            return this.lifecycleHooks;
        }

        @Generated
        public Boolean getCapacityRebalance() {
            return this.capacityRebalance;
        }

        @Generated
        public int getMinInstances() {
            return this.minInstances;
        }

        @Generated
        public int getMaxInstances() {
            return this.maxInstances;
        }

        @Generated
        public int getDesiredInstances() {
            return this.desiredInstances;
        }

        @Generated
        public Boolean getSetLaunchTemplate() {
            return this.setLaunchTemplate;
        }

        @Generated
        public Boolean getRequireIMDSv2() {
            return this.requireIMDSv2;
        }

        @Generated
        public Boolean getAssociateIPv6Address() {
            return this.associateIPv6Address;
        }

        @Generated
        public Boolean getUnlimitedCpuCredits() {
            return this.unlimitedCpuCredits;
        }

        @Generated
        public BasicAmazonDeployDescription.LaunchTemplatePlacement getPlacement() {
            return this.placement;
        }

        @Generated
        public List<BasicAmazonDeployDescription.LaunchTemplateLicenseSpecification> getLicenseSpecifications() {
            return this.licenseSpecifications;
        }

        @Generated
        public Boolean getEnableEnclave() {
            return this.enableEnclave;
        }

        @Generated
        public String getOnDemandAllocationStrategy() {
            return this.onDemandAllocationStrategy;
        }

        @Generated
        public Integer getOnDemandBaseCapacity() {
            return this.onDemandBaseCapacity;
        }

        @Generated
        public Integer getOnDemandPercentageAboveBaseCapacity() {
            return this.onDemandPercentageAboveBaseCapacity;
        }

        @Generated
        public String getSpotAllocationStrategy() {
            return this.spotAllocationStrategy;
        }

        @Generated
        public Integer getSpotInstancePools() {
            return this.spotInstancePools;
        }

        @Generated
        public List<BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType> getLaunchTemplateOverridesForInstanceType() {
            return this.launchTemplateOverridesForInstanceType;
        }

        @Generated
        public AsgConfiguration setApplication(String application) {
            this.application = application;
            return this;
        }

        @Generated
        public AsgConfiguration setRegion(String region) {
            this.region = region;
            return this;
        }

        @Generated
        public AsgConfiguration setCredentials(NetflixAmazonCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Generated
        public AsgConfiguration setStack(String stack) {
            this.stack = stack;
            return this;
        }

        @Generated
        public AsgConfiguration setFreeFormDetails(String freeFormDetails) {
            this.freeFormDetails = freeFormDetails;
            return this;
        }

        @Generated
        public AsgConfiguration setAmi(String ami) {
            this.ami = ami;
            return this;
        }

        @Generated
        public AsgConfiguration setClassicLinkVpcId(String classicLinkVpcId) {
            this.classicLinkVpcId = classicLinkVpcId;
            return this;
        }

        @Generated
        public AsgConfiguration setClassicLinkVpcSecurityGroups(List<String> classicLinkVpcSecurityGroups) {
            this.classicLinkVpcSecurityGroups = classicLinkVpcSecurityGroups;
            return this;
        }

        @Generated
        public AsgConfiguration setInstanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Generated
        public AsgConfiguration setIamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        @Generated
        public AsgConfiguration setKeyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        @Generated
        public AsgConfiguration setBase64UserData(String base64UserData) {
            this.base64UserData = base64UserData;
            return this;
        }

        @Generated
        public AsgConfiguration setLegacyUdf(Boolean legacyUdf) {
            this.legacyUdf = legacyUdf;
            return this;
        }

        @Generated
        public AsgConfiguration setUserDataOverride(UserDataOverride userDataOverride) {
            this.userDataOverride = userDataOverride;
            return this;
        }

        @Generated
        public AsgConfiguration setSequence(Integer sequence) {
            this.sequence = sequence;
            return this;
        }

        @Generated
        public AsgConfiguration setIgnoreSequence(Boolean ignoreSequence) {
            this.ignoreSequence = ignoreSequence;
            return this;
        }

        @Generated
        public AsgConfiguration setStartDisabled(Boolean startDisabled) {
            this.startDisabled = startDisabled;
            return this;
        }

        @Generated
        public AsgConfiguration setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        @Generated
        public AsgConfiguration setSubnetType(String subnetType) {
            this.subnetType = subnetType;
            return this;
        }

        @Generated
        public AsgConfiguration setSubnetIds(List<String> subnetIds) {
            this.subnetIds = subnetIds;
            return this;
        }

        @Generated
        public AsgConfiguration setCooldown(Integer cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        @Generated
        public AsgConfiguration setEnabledMetrics(Collection<String> enabledMetrics) {
            this.enabledMetrics = enabledMetrics;
            return this;
        }

        @Generated
        public AsgConfiguration setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        @Generated
        public AsgConfiguration setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        @Generated
        public AsgConfiguration setSpotMaxPrice(String spotMaxPrice) {
            this.spotMaxPrice = spotMaxPrice;
            return this;
        }

        @Generated
        public AsgConfiguration setSuspendedProcesses(Set<String> suspendedProcesses) {
            this.suspendedProcesses = suspendedProcesses;
            return this;
        }

        @Generated
        public AsgConfiguration setTerminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = terminationPolicies;
            return this;
        }

        @Generated
        public AsgConfiguration setKernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        @Generated
        public AsgConfiguration setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        @Generated
        public AsgConfiguration setInstanceMonitoring(Boolean instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        @Generated
        public AsgConfiguration setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        @Generated
        public AsgConfiguration setClassicLoadBalancers(Collection<String> classicLoadBalancers) {
            this.classicLoadBalancers = classicLoadBalancers;
            return this;
        }

        @Generated
        public AsgConfiguration setTargetGroupArns(Collection<String> targetGroupArns) {
            this.targetGroupArns = targetGroupArns;
            return this;
        }

        @Generated
        public AsgConfiguration setSecurityGroups(List<String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        @Generated
        public AsgConfiguration setAvailabilityZones(List<String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        @Generated
        public AsgConfiguration setBlockDevices(List<AmazonBlockDevice> blockDevices) {
            this.blockDevices = blockDevices;
            return this;
        }

        @Generated
        public AsgConfiguration setTags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        @Generated
        public AsgConfiguration setBlockDeviceTags(Map<String, String> blockDeviceTags) {
            this.blockDeviceTags = blockDeviceTags;
            return this;
        }

        @Generated
        public AsgConfiguration setLifecycleHooks(List<AmazonAsgLifecycleHook> lifecycleHooks) {
            this.lifecycleHooks = lifecycleHooks;
            return this;
        }

        @Generated
        public AsgConfiguration setCapacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
            return this;
        }

        @Generated
        public AsgConfiguration setMinInstances(int minInstances) {
            this.minInstances = minInstances;
            return this;
        }

        @Generated
        public AsgConfiguration setMaxInstances(int maxInstances) {
            this.maxInstances = maxInstances;
            return this;
        }

        @Generated
        public AsgConfiguration setDesiredInstances(int desiredInstances) {
            this.desiredInstances = desiredInstances;
            return this;
        }

        @Generated
        public AsgConfiguration setSetLaunchTemplate(Boolean setLaunchTemplate) {
            this.setLaunchTemplate = setLaunchTemplate;
            return this;
        }

        @Generated
        public AsgConfiguration setRequireIMDSv2(Boolean requireIMDSv2) {
            this.requireIMDSv2 = requireIMDSv2;
            return this;
        }

        @Generated
        public AsgConfiguration setAssociateIPv6Address(Boolean associateIPv6Address) {
            this.associateIPv6Address = associateIPv6Address;
            return this;
        }

        @Generated
        public AsgConfiguration setUnlimitedCpuCredits(Boolean unlimitedCpuCredits) {
            this.unlimitedCpuCredits = unlimitedCpuCredits;
            return this;
        }

        @Generated
        public AsgConfiguration setPlacement(BasicAmazonDeployDescription.LaunchTemplatePlacement placement) {
            this.placement = placement;
            return this;
        }

        @Generated
        public AsgConfiguration setLicenseSpecifications(List<BasicAmazonDeployDescription.LaunchTemplateLicenseSpecification> licenseSpecifications) {
            this.licenseSpecifications = licenseSpecifications;
            return this;
        }

        @Generated
        public AsgConfiguration setEnableEnclave(Boolean enableEnclave) {
            this.enableEnclave = enableEnclave;
            return this;
        }

        @Generated
        public AsgConfiguration setOnDemandAllocationStrategy(String onDemandAllocationStrategy) {
            this.onDemandAllocationStrategy = onDemandAllocationStrategy;
            return this;
        }

        @Generated
        public AsgConfiguration setOnDemandBaseCapacity(Integer onDemandBaseCapacity) {
            this.onDemandBaseCapacity = onDemandBaseCapacity;
            return this;
        }

        @Generated
        public AsgConfiguration setOnDemandPercentageAboveBaseCapacity(Integer onDemandPercentageAboveBaseCapacity) {
            this.onDemandPercentageAboveBaseCapacity = onDemandPercentageAboveBaseCapacity;
            return this;
        }

        @Generated
        public AsgConfiguration setSpotAllocationStrategy(String spotAllocationStrategy) {
            this.spotAllocationStrategy = spotAllocationStrategy;
            return this;
        }

        @Generated
        public AsgConfiguration setSpotInstancePools(Integer spotInstancePools) {
            this.spotInstancePools = spotInstancePools;
            return this;
        }

        @Generated
        public AsgConfiguration setLaunchTemplateOverridesForInstanceType(List<BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType> launchTemplateOverridesForInstanceType) {
            this.launchTemplateOverridesForInstanceType = launchTemplateOverridesForInstanceType;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsgConfiguration)) {
                return false;
            }
            AsgConfiguration other = (AsgConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMinInstances() != other.getMinInstances()) {
                return false;
            }
            if (this.getMaxInstances() != other.getMaxInstances()) {
                return false;
            }
            if (this.getDesiredInstances() != other.getDesiredInstances()) {
                return false;
            }
            Boolean this$legacyUdf = this.getLegacyUdf();
            Boolean other$legacyUdf = other.getLegacyUdf();
            if (this$legacyUdf == null ? other$legacyUdf != null : !((Object)this$legacyUdf).equals(other$legacyUdf)) {
                return false;
            }
            Integer this$sequence = this.getSequence();
            Integer other$sequence = other.getSequence();
            if (this$sequence == null ? other$sequence != null : !((Object)this$sequence).equals(other$sequence)) {
                return false;
            }
            Boolean this$ignoreSequence = this.getIgnoreSequence();
            Boolean other$ignoreSequence = other.getIgnoreSequence();
            if (this$ignoreSequence == null ? other$ignoreSequence != null : !((Object)this$ignoreSequence).equals(other$ignoreSequence)) {
                return false;
            }
            Boolean this$startDisabled = this.getStartDisabled();
            Boolean other$startDisabled = other.getStartDisabled();
            if (this$startDisabled == null ? other$startDisabled != null : !((Object)this$startDisabled).equals(other$startDisabled)) {
                return false;
            }
            Boolean this$associatePublicIpAddress = this.getAssociatePublicIpAddress();
            Boolean other$associatePublicIpAddress = other.getAssociatePublicIpAddress();
            if (this$associatePublicIpAddress == null ? other$associatePublicIpAddress != null : !((Object)this$associatePublicIpAddress).equals(other$associatePublicIpAddress)) {
                return false;
            }
            Integer this$cooldown = this.getCooldown();
            Integer other$cooldown = other.getCooldown();
            if (this$cooldown == null ? other$cooldown != null : !((Object)this$cooldown).equals(other$cooldown)) {
                return false;
            }
            Integer this$healthCheckGracePeriod = this.getHealthCheckGracePeriod();
            Integer other$healthCheckGracePeriod = other.getHealthCheckGracePeriod();
            if (this$healthCheckGracePeriod == null ? other$healthCheckGracePeriod != null : !((Object)this$healthCheckGracePeriod).equals(other$healthCheckGracePeriod)) {
                return false;
            }
            Boolean this$instanceMonitoring = this.getInstanceMonitoring();
            Boolean other$instanceMonitoring = other.getInstanceMonitoring();
            if (this$instanceMonitoring == null ? other$instanceMonitoring != null : !((Object)this$instanceMonitoring).equals(other$instanceMonitoring)) {
                return false;
            }
            Boolean this$ebsOptimized = this.getEbsOptimized();
            Boolean other$ebsOptimized = other.getEbsOptimized();
            if (this$ebsOptimized == null ? other$ebsOptimized != null : !((Object)this$ebsOptimized).equals(other$ebsOptimized)) {
                return false;
            }
            Boolean this$capacityRebalance = this.getCapacityRebalance();
            Boolean other$capacityRebalance = other.getCapacityRebalance();
            if (this$capacityRebalance == null ? other$capacityRebalance != null : !((Object)this$capacityRebalance).equals(other$capacityRebalance)) {
                return false;
            }
            Boolean this$setLaunchTemplate = this.getSetLaunchTemplate();
            Boolean other$setLaunchTemplate = other.getSetLaunchTemplate();
            if (this$setLaunchTemplate == null ? other$setLaunchTemplate != null : !((Object)this$setLaunchTemplate).equals(other$setLaunchTemplate)) {
                return false;
            }
            Boolean this$requireIMDSv2 = this.getRequireIMDSv2();
            Boolean other$requireIMDSv2 = other.getRequireIMDSv2();
            if (this$requireIMDSv2 == null ? other$requireIMDSv2 != null : !((Object)this$requireIMDSv2).equals(other$requireIMDSv2)) {
                return false;
            }
            Boolean this$associateIPv6Address = this.getAssociateIPv6Address();
            Boolean other$associateIPv6Address = other.getAssociateIPv6Address();
            if (this$associateIPv6Address == null ? other$associateIPv6Address != null : !((Object)this$associateIPv6Address).equals(other$associateIPv6Address)) {
                return false;
            }
            Boolean this$unlimitedCpuCredits = this.getUnlimitedCpuCredits();
            Boolean other$unlimitedCpuCredits = other.getUnlimitedCpuCredits();
            if (this$unlimitedCpuCredits == null ? other$unlimitedCpuCredits != null : !((Object)this$unlimitedCpuCredits).equals(other$unlimitedCpuCredits)) {
                return false;
            }
            Boolean this$enableEnclave = this.getEnableEnclave();
            Boolean other$enableEnclave = other.getEnableEnclave();
            if (this$enableEnclave == null ? other$enableEnclave != null : !((Object)this$enableEnclave).equals(other$enableEnclave)) {
                return false;
            }
            Integer this$onDemandBaseCapacity = this.getOnDemandBaseCapacity();
            Integer other$onDemandBaseCapacity = other.getOnDemandBaseCapacity();
            if (this$onDemandBaseCapacity == null ? other$onDemandBaseCapacity != null : !((Object)this$onDemandBaseCapacity).equals(other$onDemandBaseCapacity)) {
                return false;
            }
            Integer this$onDemandPercentageAboveBaseCapacity = this.getOnDemandPercentageAboveBaseCapacity();
            Integer other$onDemandPercentageAboveBaseCapacity = other.getOnDemandPercentageAboveBaseCapacity();
            if (this$onDemandPercentageAboveBaseCapacity == null ? other$onDemandPercentageAboveBaseCapacity != null : !((Object)this$onDemandPercentageAboveBaseCapacity).equals(other$onDemandPercentageAboveBaseCapacity)) {
                return false;
            }
            Integer this$spotInstancePools = this.getSpotInstancePools();
            Integer other$spotInstancePools = other.getSpotInstancePools();
            if (this$spotInstancePools == null ? other$spotInstancePools != null : !((Object)this$spotInstancePools).equals(other$spotInstancePools)) {
                return false;
            }
            String this$application = this.getApplication();
            String other$application = other.getApplication();
            if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            NetflixAmazonCredentials this$credentials = this.getCredentials();
            NetflixAmazonCredentials other$credentials = other.getCredentials();
            if (this$credentials == null ? other$credentials != null : !((Object)((Object)this$credentials)).equals((Object)other$credentials)) {
                return false;
            }
            String this$stack = this.getStack();
            String other$stack = other.getStack();
            if (this$stack == null ? other$stack != null : !this$stack.equals(other$stack)) {
                return false;
            }
            String this$freeFormDetails = this.getFreeFormDetails();
            String other$freeFormDetails = other.getFreeFormDetails();
            if (this$freeFormDetails == null ? other$freeFormDetails != null : !this$freeFormDetails.equals(other$freeFormDetails)) {
                return false;
            }
            String this$ami = this.getAmi();
            String other$ami = other.getAmi();
            if (this$ami == null ? other$ami != null : !this$ami.equals(other$ami)) {
                return false;
            }
            String this$classicLinkVpcId = this.getClassicLinkVpcId();
            String other$classicLinkVpcId = other.getClassicLinkVpcId();
            if (this$classicLinkVpcId == null ? other$classicLinkVpcId != null : !this$classicLinkVpcId.equals(other$classicLinkVpcId)) {
                return false;
            }
            List<String> this$classicLinkVpcSecurityGroups = this.getClassicLinkVpcSecurityGroups();
            List<String> other$classicLinkVpcSecurityGroups = other.getClassicLinkVpcSecurityGroups();
            if (this$classicLinkVpcSecurityGroups == null ? other$classicLinkVpcSecurityGroups != null : !((Object)this$classicLinkVpcSecurityGroups).equals(other$classicLinkVpcSecurityGroups)) {
                return false;
            }
            String this$instanceType = this.getInstanceType();
            String other$instanceType = other.getInstanceType();
            if (this$instanceType == null ? other$instanceType != null : !this$instanceType.equals(other$instanceType)) {
                return false;
            }
            String this$iamRole = this.getIamRole();
            String other$iamRole = other.getIamRole();
            if (this$iamRole == null ? other$iamRole != null : !this$iamRole.equals(other$iamRole)) {
                return false;
            }
            String this$keyPair = this.getKeyPair();
            String other$keyPair = other.getKeyPair();
            if (this$keyPair == null ? other$keyPair != null : !this$keyPair.equals(other$keyPair)) {
                return false;
            }
            String this$base64UserData = this.getBase64UserData();
            String other$base64UserData = other.getBase64UserData();
            if (this$base64UserData == null ? other$base64UserData != null : !this$base64UserData.equals(other$base64UserData)) {
                return false;
            }
            UserDataOverride this$userDataOverride = this.getUserDataOverride();
            UserDataOverride other$userDataOverride = other.getUserDataOverride();
            if (this$userDataOverride == null ? other$userDataOverride != null : !this$userDataOverride.equals(other$userDataOverride)) {
                return false;
            }
            String this$subnetType = this.getSubnetType();
            String other$subnetType = other.getSubnetType();
            if (this$subnetType == null ? other$subnetType != null : !this$subnetType.equals(other$subnetType)) {
                return false;
            }
            List<String> this$subnetIds = this.getSubnetIds();
            List<String> other$subnetIds = other.getSubnetIds();
            if (this$subnetIds == null ? other$subnetIds != null : !((Object)this$subnetIds).equals(other$subnetIds)) {
                return false;
            }
            Collection<String> this$enabledMetrics = this.getEnabledMetrics();
            Collection<String> other$enabledMetrics = other.getEnabledMetrics();
            if (this$enabledMetrics == null ? other$enabledMetrics != null : !((Object)this$enabledMetrics).equals(other$enabledMetrics)) {
                return false;
            }
            String this$healthCheckType = this.getHealthCheckType();
            String other$healthCheckType = other.getHealthCheckType();
            if (this$healthCheckType == null ? other$healthCheckType != null : !this$healthCheckType.equals(other$healthCheckType)) {
                return false;
            }
            String this$spotMaxPrice = this.getSpotMaxPrice();
            String other$spotMaxPrice = other.getSpotMaxPrice();
            if (this$spotMaxPrice == null ? other$spotMaxPrice != null : !this$spotMaxPrice.equals(other$spotMaxPrice)) {
                return false;
            }
            Set<String> this$suspendedProcesses = this.getSuspendedProcesses();
            Set<String> other$suspendedProcesses = other.getSuspendedProcesses();
            if (this$suspendedProcesses == null ? other$suspendedProcesses != null : !((Object)this$suspendedProcesses).equals(other$suspendedProcesses)) {
                return false;
            }
            Collection<String> this$terminationPolicies = this.getTerminationPolicies();
            Collection<String> other$terminationPolicies = other.getTerminationPolicies();
            if (this$terminationPolicies == null ? other$terminationPolicies != null : !((Object)this$terminationPolicies).equals(other$terminationPolicies)) {
                return false;
            }
            String this$kernelId = this.getKernelId();
            String other$kernelId = other.getKernelId();
            if (this$kernelId == null ? other$kernelId != null : !this$kernelId.equals(other$kernelId)) {
                return false;
            }
            String this$ramdiskId = this.getRamdiskId();
            String other$ramdiskId = other.getRamdiskId();
            if (this$ramdiskId == null ? other$ramdiskId != null : !this$ramdiskId.equals(other$ramdiskId)) {
                return false;
            }
            Collection<String> this$classicLoadBalancers = this.getClassicLoadBalancers();
            Collection<String> other$classicLoadBalancers = other.getClassicLoadBalancers();
            if (this$classicLoadBalancers == null ? other$classicLoadBalancers != null : !((Object)this$classicLoadBalancers).equals(other$classicLoadBalancers)) {
                return false;
            }
            Collection<String> this$targetGroupArns = this.getTargetGroupArns();
            Collection<String> other$targetGroupArns = other.getTargetGroupArns();
            if (this$targetGroupArns == null ? other$targetGroupArns != null : !((Object)this$targetGroupArns).equals(other$targetGroupArns)) {
                return false;
            }
            List<String> this$securityGroups = this.getSecurityGroups();
            List<String> other$securityGroups = other.getSecurityGroups();
            if (this$securityGroups == null ? other$securityGroups != null : !((Object)this$securityGroups).equals(other$securityGroups)) {
                return false;
            }
            List<String> this$availabilityZones = this.getAvailabilityZones();
            List<String> other$availabilityZones = other.getAvailabilityZones();
            if (this$availabilityZones == null ? other$availabilityZones != null : !((Object)this$availabilityZones).equals(other$availabilityZones)) {
                return false;
            }
            List<AmazonBlockDevice> this$blockDevices = this.getBlockDevices();
            List<AmazonBlockDevice> other$blockDevices = other.getBlockDevices();
            if (this$blockDevices == null ? other$blockDevices != null : !((Object)this$blockDevices).equals(other$blockDevices)) {
                return false;
            }
            Map<String, String> this$tags = this.getTags();
            Map<String, String> other$tags = other.getTags();
            if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
                return false;
            }
            Map<String, String> this$blockDeviceTags = this.getBlockDeviceTags();
            Map<String, String> other$blockDeviceTags = other.getBlockDeviceTags();
            if (this$blockDeviceTags == null ? other$blockDeviceTags != null : !((Object)this$blockDeviceTags).equals(other$blockDeviceTags)) {
                return false;
            }
            List<AmazonAsgLifecycleHook> this$lifecycleHooks = this.getLifecycleHooks();
            List<AmazonAsgLifecycleHook> other$lifecycleHooks = other.getLifecycleHooks();
            if (this$lifecycleHooks == null ? other$lifecycleHooks != null : !((Object)this$lifecycleHooks).equals(other$lifecycleHooks)) {
                return false;
            }
            BasicAmazonDeployDescription.LaunchTemplatePlacement this$placement = this.getPlacement();
            BasicAmazonDeployDescription.LaunchTemplatePlacement other$placement = other.getPlacement();
            if (this$placement == null ? other$placement != null : !((Object)this$placement).equals(other$placement)) {
                return false;
            }
            List<BasicAmazonDeployDescription.LaunchTemplateLicenseSpecification> this$licenseSpecifications = this.getLicenseSpecifications();
            List<BasicAmazonDeployDescription.LaunchTemplateLicenseSpecification> other$licenseSpecifications = other.getLicenseSpecifications();
            if (this$licenseSpecifications == null ? other$licenseSpecifications != null : !((Object)this$licenseSpecifications).equals(other$licenseSpecifications)) {
                return false;
            }
            String this$onDemandAllocationStrategy = this.getOnDemandAllocationStrategy();
            String other$onDemandAllocationStrategy = other.getOnDemandAllocationStrategy();
            if (this$onDemandAllocationStrategy == null ? other$onDemandAllocationStrategy != null : !this$onDemandAllocationStrategy.equals(other$onDemandAllocationStrategy)) {
                return false;
            }
            String this$spotAllocationStrategy = this.getSpotAllocationStrategy();
            String other$spotAllocationStrategy = other.getSpotAllocationStrategy();
            if (this$spotAllocationStrategy == null ? other$spotAllocationStrategy != null : !this$spotAllocationStrategy.equals(other$spotAllocationStrategy)) {
                return false;
            }
            List<BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType> this$launchTemplateOverridesForInstanceType = this.getLaunchTemplateOverridesForInstanceType();
            List<BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType> other$launchTemplateOverridesForInstanceType = other.getLaunchTemplateOverridesForInstanceType();
            return !(this$launchTemplateOverridesForInstanceType == null ? other$launchTemplateOverridesForInstanceType != null : !((Object)this$launchTemplateOverridesForInstanceType).equals(other$launchTemplateOverridesForInstanceType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AsgConfiguration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMinInstances();
            result = result * 59 + this.getMaxInstances();
            result = result * 59 + this.getDesiredInstances();
            Boolean $legacyUdf = this.getLegacyUdf();
            result = result * 59 + ($legacyUdf == null ? 43 : ((Object)$legacyUdf).hashCode());
            Integer $sequence = this.getSequence();
            result = result * 59 + ($sequence == null ? 43 : ((Object)$sequence).hashCode());
            Boolean $ignoreSequence = this.getIgnoreSequence();
            result = result * 59 + ($ignoreSequence == null ? 43 : ((Object)$ignoreSequence).hashCode());
            Boolean $startDisabled = this.getStartDisabled();
            result = result * 59 + ($startDisabled == null ? 43 : ((Object)$startDisabled).hashCode());
            Boolean $associatePublicIpAddress = this.getAssociatePublicIpAddress();
            result = result * 59 + ($associatePublicIpAddress == null ? 43 : ((Object)$associatePublicIpAddress).hashCode());
            Integer $cooldown = this.getCooldown();
            result = result * 59 + ($cooldown == null ? 43 : ((Object)$cooldown).hashCode());
            Integer $healthCheckGracePeriod = this.getHealthCheckGracePeriod();
            result = result * 59 + ($healthCheckGracePeriod == null ? 43 : ((Object)$healthCheckGracePeriod).hashCode());
            Boolean $instanceMonitoring = this.getInstanceMonitoring();
            result = result * 59 + ($instanceMonitoring == null ? 43 : ((Object)$instanceMonitoring).hashCode());
            Boolean $ebsOptimized = this.getEbsOptimized();
            result = result * 59 + ($ebsOptimized == null ? 43 : ((Object)$ebsOptimized).hashCode());
            Boolean $capacityRebalance = this.getCapacityRebalance();
            result = result * 59 + ($capacityRebalance == null ? 43 : ((Object)$capacityRebalance).hashCode());
            Boolean $setLaunchTemplate = this.getSetLaunchTemplate();
            result = result * 59 + ($setLaunchTemplate == null ? 43 : ((Object)$setLaunchTemplate).hashCode());
            Boolean $requireIMDSv2 = this.getRequireIMDSv2();
            result = result * 59 + ($requireIMDSv2 == null ? 43 : ((Object)$requireIMDSv2).hashCode());
            Boolean $associateIPv6Address = this.getAssociateIPv6Address();
            result = result * 59 + ($associateIPv6Address == null ? 43 : ((Object)$associateIPv6Address).hashCode());
            Boolean $unlimitedCpuCredits = this.getUnlimitedCpuCredits();
            result = result * 59 + ($unlimitedCpuCredits == null ? 43 : ((Object)$unlimitedCpuCredits).hashCode());
            Boolean $enableEnclave = this.getEnableEnclave();
            result = result * 59 + ($enableEnclave == null ? 43 : ((Object)$enableEnclave).hashCode());
            Integer $onDemandBaseCapacity = this.getOnDemandBaseCapacity();
            result = result * 59 + ($onDemandBaseCapacity == null ? 43 : ((Object)$onDemandBaseCapacity).hashCode());
            Integer $onDemandPercentageAboveBaseCapacity = this.getOnDemandPercentageAboveBaseCapacity();
            result = result * 59 + ($onDemandPercentageAboveBaseCapacity == null ? 43 : ((Object)$onDemandPercentageAboveBaseCapacity).hashCode());
            Integer $spotInstancePools = this.getSpotInstancePools();
            result = result * 59 + ($spotInstancePools == null ? 43 : ((Object)$spotInstancePools).hashCode());
            String $application = this.getApplication();
            result = result * 59 + ($application == null ? 43 : $application.hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            NetflixAmazonCredentials $credentials = this.getCredentials();
            result = result * 59 + ($credentials == null ? 43 : ((Object)((Object)$credentials)).hashCode());
            String $stack = this.getStack();
            result = result * 59 + ($stack == null ? 43 : $stack.hashCode());
            String $freeFormDetails = this.getFreeFormDetails();
            result = result * 59 + ($freeFormDetails == null ? 43 : $freeFormDetails.hashCode());
            String $ami = this.getAmi();
            result = result * 59 + ($ami == null ? 43 : $ami.hashCode());
            String $classicLinkVpcId = this.getClassicLinkVpcId();
            result = result * 59 + ($classicLinkVpcId == null ? 43 : $classicLinkVpcId.hashCode());
            List<String> $classicLinkVpcSecurityGroups = this.getClassicLinkVpcSecurityGroups();
            result = result * 59 + ($classicLinkVpcSecurityGroups == null ? 43 : ((Object)$classicLinkVpcSecurityGroups).hashCode());
            String $instanceType = this.getInstanceType();
            result = result * 59 + ($instanceType == null ? 43 : $instanceType.hashCode());
            String $iamRole = this.getIamRole();
            result = result * 59 + ($iamRole == null ? 43 : $iamRole.hashCode());
            String $keyPair = this.getKeyPair();
            result = result * 59 + ($keyPair == null ? 43 : $keyPair.hashCode());
            String $base64UserData = this.getBase64UserData();
            result = result * 59 + ($base64UserData == null ? 43 : $base64UserData.hashCode());
            UserDataOverride $userDataOverride = this.getUserDataOverride();
            result = result * 59 + ($userDataOverride == null ? 43 : $userDataOverride.hashCode());
            String $subnetType = this.getSubnetType();
            result = result * 59 + ($subnetType == null ? 43 : $subnetType.hashCode());
            List<String> $subnetIds = this.getSubnetIds();
            result = result * 59 + ($subnetIds == null ? 43 : ((Object)$subnetIds).hashCode());
            Collection<String> $enabledMetrics = this.getEnabledMetrics();
            result = result * 59 + ($enabledMetrics == null ? 43 : ((Object)$enabledMetrics).hashCode());
            String $healthCheckType = this.getHealthCheckType();
            result = result * 59 + ($healthCheckType == null ? 43 : $healthCheckType.hashCode());
            String $spotMaxPrice = this.getSpotMaxPrice();
            result = result * 59 + ($spotMaxPrice == null ? 43 : $spotMaxPrice.hashCode());
            Set<String> $suspendedProcesses = this.getSuspendedProcesses();
            result = result * 59 + ($suspendedProcesses == null ? 43 : ((Object)$suspendedProcesses).hashCode());
            Collection<String> $terminationPolicies = this.getTerminationPolicies();
            result = result * 59 + ($terminationPolicies == null ? 43 : ((Object)$terminationPolicies).hashCode());
            String $kernelId = this.getKernelId();
            result = result * 59 + ($kernelId == null ? 43 : $kernelId.hashCode());
            String $ramdiskId = this.getRamdiskId();
            result = result * 59 + ($ramdiskId == null ? 43 : $ramdiskId.hashCode());
            Collection<String> $classicLoadBalancers = this.getClassicLoadBalancers();
            result = result * 59 + ($classicLoadBalancers == null ? 43 : ((Object)$classicLoadBalancers).hashCode());
            Collection<String> $targetGroupArns = this.getTargetGroupArns();
            result = result * 59 + ($targetGroupArns == null ? 43 : ((Object)$targetGroupArns).hashCode());
            List<String> $securityGroups = this.getSecurityGroups();
            result = result * 59 + ($securityGroups == null ? 43 : ((Object)$securityGroups).hashCode());
            List<String> $availabilityZones = this.getAvailabilityZones();
            result = result * 59 + ($availabilityZones == null ? 43 : ((Object)$availabilityZones).hashCode());
            List<AmazonBlockDevice> $blockDevices = this.getBlockDevices();
            result = result * 59 + ($blockDevices == null ? 43 : ((Object)$blockDevices).hashCode());
            Map<String, String> $tags = this.getTags();
            result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
            Map<String, String> $blockDeviceTags = this.getBlockDeviceTags();
            result = result * 59 + ($blockDeviceTags == null ? 43 : ((Object)$blockDeviceTags).hashCode());
            List<AmazonAsgLifecycleHook> $lifecycleHooks = this.getLifecycleHooks();
            result = result * 59 + ($lifecycleHooks == null ? 43 : ((Object)$lifecycleHooks).hashCode());
            BasicAmazonDeployDescription.LaunchTemplatePlacement $placement = this.getPlacement();
            result = result * 59 + ($placement == null ? 43 : ((Object)$placement).hashCode());
            List<BasicAmazonDeployDescription.LaunchTemplateLicenseSpecification> $licenseSpecifications = this.getLicenseSpecifications();
            result = result * 59 + ($licenseSpecifications == null ? 43 : ((Object)$licenseSpecifications).hashCode());
            String $onDemandAllocationStrategy = this.getOnDemandAllocationStrategy();
            result = result * 59 + ($onDemandAllocationStrategy == null ? 43 : $onDemandAllocationStrategy.hashCode());
            String $spotAllocationStrategy = this.getSpotAllocationStrategy();
            result = result * 59 + ($spotAllocationStrategy == null ? 43 : $spotAllocationStrategy.hashCode());
            List<BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType> $launchTemplateOverridesForInstanceType = this.getLaunchTemplateOverridesForInstanceType();
            result = result * 59 + ($launchTemplateOverridesForInstanceType == null ? 43 : ((Object)$launchTemplateOverridesForInstanceType).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AutoScalingWorker.AsgConfiguration(application=" + this.getApplication() + ", region=" + this.getRegion() + ", credentials=" + String.valueOf((Object)this.getCredentials()) + ", stack=" + this.getStack() + ", freeFormDetails=" + this.getFreeFormDetails() + ", ami=" + this.getAmi() + ", classicLinkVpcId=" + this.getClassicLinkVpcId() + ", classicLinkVpcSecurityGroups=" + String.valueOf(this.getClassicLinkVpcSecurityGroups()) + ", instanceType=" + this.getInstanceType() + ", iamRole=" + this.getIamRole() + ", keyPair=" + this.getKeyPair() + ", base64UserData=" + this.getBase64UserData() + ", legacyUdf=" + this.getLegacyUdf() + ", userDataOverride=" + String.valueOf(this.getUserDataOverride()) + ", sequence=" + this.getSequence() + ", ignoreSequence=" + this.getIgnoreSequence() + ", startDisabled=" + this.getStartDisabled() + ", associatePublicIpAddress=" + this.getAssociatePublicIpAddress() + ", subnetType=" + this.getSubnetType() + ", subnetIds=" + String.valueOf(this.getSubnetIds()) + ", cooldown=" + this.getCooldown() + ", enabledMetrics=" + String.valueOf(this.getEnabledMetrics()) + ", healthCheckGracePeriod=" + this.getHealthCheckGracePeriod() + ", healthCheckType=" + this.getHealthCheckType() + ", spotMaxPrice=" + this.getSpotMaxPrice() + ", suspendedProcesses=" + String.valueOf(this.getSuspendedProcesses()) + ", terminationPolicies=" + String.valueOf(this.getTerminationPolicies()) + ", kernelId=" + this.getKernelId() + ", ramdiskId=" + this.getRamdiskId() + ", instanceMonitoring=" + this.getInstanceMonitoring() + ", ebsOptimized=" + this.getEbsOptimized() + ", classicLoadBalancers=" + String.valueOf(this.getClassicLoadBalancers()) + ", targetGroupArns=" + String.valueOf(this.getTargetGroupArns()) + ", securityGroups=" + String.valueOf(this.getSecurityGroups()) + ", availabilityZones=" + String.valueOf(this.getAvailabilityZones()) + ", blockDevices=" + String.valueOf(this.getBlockDevices()) + ", tags=" + String.valueOf(this.getTags()) + ", blockDeviceTags=" + String.valueOf(this.getBlockDeviceTags()) + ", lifecycleHooks=" + String.valueOf(this.getLifecycleHooks()) + ", capacityRebalance=" + this.getCapacityRebalance() + ", minInstances=" + this.getMinInstances() + ", maxInstances=" + this.getMaxInstances() + ", desiredInstances=" + this.getDesiredInstances() + ", setLaunchTemplate=" + this.getSetLaunchTemplate() + ", requireIMDSv2=" + this.getRequireIMDSv2() + ", associateIPv6Address=" + this.getAssociateIPv6Address() + ", unlimitedCpuCredits=" + this.getUnlimitedCpuCredits() + ", placement=" + String.valueOf(this.getPlacement()) + ", licenseSpecifications=" + String.valueOf(this.getLicenseSpecifications()) + ", enableEnclave=" + this.getEnableEnclave() + ", onDemandAllocationStrategy=" + this.getOnDemandAllocationStrategy() + ", onDemandBaseCapacity=" + this.getOnDemandBaseCapacity() + ", onDemandPercentageAboveBaseCapacity=" + this.getOnDemandPercentageAboveBaseCapacity() + ", spotAllocationStrategy=" + this.getSpotAllocationStrategy() + ", spotInstancePools=" + this.getSpotInstancePools() + ", launchTemplateOverridesForInstanceType=" + String.valueOf(this.getLaunchTemplateOverridesForInstanceType()) + ")";
        }

        @Generated
        public AsgConfiguration(String application, String region, NetflixAmazonCredentials credentials, String stack, String freeFormDetails, String ami, String classicLinkVpcId, List<String> classicLinkVpcSecurityGroups, String instanceType, String iamRole, String keyPair, String base64UserData, Boolean legacyUdf, UserDataOverride userDataOverride, Integer sequence, Boolean ignoreSequence, Boolean startDisabled, Boolean associatePublicIpAddress, String subnetType, List<String> subnetIds, Integer cooldown, Collection<String> enabledMetrics, Integer healthCheckGracePeriod, String healthCheckType, String spotMaxPrice, Set<String> suspendedProcesses, Collection<String> terminationPolicies, String kernelId, String ramdiskId, Boolean instanceMonitoring, Boolean ebsOptimized, Collection<String> classicLoadBalancers, Collection<String> targetGroupArns, List<String> securityGroups, List<String> availabilityZones, List<AmazonBlockDevice> blockDevices, Map<String, String> tags, Map<String, String> blockDeviceTags, List<AmazonAsgLifecycleHook> lifecycleHooks, Boolean capacityRebalance, int minInstances, int maxInstances, int desiredInstances, Boolean setLaunchTemplate, Boolean requireIMDSv2, Boolean associateIPv6Address, Boolean unlimitedCpuCredits, BasicAmazonDeployDescription.LaunchTemplatePlacement placement, List<BasicAmazonDeployDescription.LaunchTemplateLicenseSpecification> licenseSpecifications, Boolean enableEnclave, String onDemandAllocationStrategy, Integer onDemandBaseCapacity, Integer onDemandPercentageAboveBaseCapacity, String spotAllocationStrategy, Integer spotInstancePools, List<BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType> launchTemplateOverridesForInstanceType) {
            this.application = application;
            this.region = region;
            this.credentials = credentials;
            this.stack = stack;
            this.freeFormDetails = freeFormDetails;
            this.ami = ami;
            this.classicLinkVpcId = classicLinkVpcId;
            this.classicLinkVpcSecurityGroups = classicLinkVpcSecurityGroups;
            this.instanceType = instanceType;
            this.iamRole = iamRole;
            this.keyPair = keyPair;
            this.base64UserData = base64UserData;
            this.legacyUdf = legacyUdf;
            this.userDataOverride = userDataOverride;
            this.sequence = sequence;
            this.ignoreSequence = ignoreSequence;
            this.startDisabled = startDisabled;
            this.associatePublicIpAddress = associatePublicIpAddress;
            this.subnetType = subnetType;
            this.subnetIds = subnetIds;
            this.cooldown = cooldown;
            this.enabledMetrics = enabledMetrics;
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            this.healthCheckType = healthCheckType;
            this.spotMaxPrice = spotMaxPrice;
            this.suspendedProcesses = suspendedProcesses;
            this.terminationPolicies = terminationPolicies;
            this.kernelId = kernelId;
            this.ramdiskId = ramdiskId;
            this.instanceMonitoring = instanceMonitoring;
            this.ebsOptimized = ebsOptimized;
            this.classicLoadBalancers = classicLoadBalancers;
            this.targetGroupArns = targetGroupArns;
            this.securityGroups = securityGroups;
            this.availabilityZones = availabilityZones;
            this.blockDevices = blockDevices;
            this.tags = tags;
            this.blockDeviceTags = blockDeviceTags;
            this.lifecycleHooks = lifecycleHooks;
            this.capacityRebalance = capacityRebalance;
            this.minInstances = minInstances;
            this.maxInstances = maxInstances;
            this.desiredInstances = desiredInstances;
            this.setLaunchTemplate = setLaunchTemplate;
            this.requireIMDSv2 = requireIMDSv2;
            this.associateIPv6Address = associateIPv6Address;
            this.unlimitedCpuCredits = unlimitedCpuCredits;
            this.placement = placement;
            this.licenseSpecifications = licenseSpecifications;
            this.enableEnclave = enableEnclave;
            this.onDemandAllocationStrategy = onDemandAllocationStrategy;
            this.onDemandBaseCapacity = onDemandBaseCapacity;
            this.onDemandPercentageAboveBaseCapacity = onDemandPercentageAboveBaseCapacity;
            this.spotAllocationStrategy = spotAllocationStrategy;
            this.spotInstancePools = spotInstancePools;
            this.launchTemplateOverridesForInstanceType = launchTemplateOverridesForInstanceType;
        }

        @Generated
        public static class AsgConfigurationBuilder {
            @Generated
            private String application;
            @Generated
            private String region;
            @Generated
            private NetflixAmazonCredentials credentials;
            @Generated
            private String stack;
            @Generated
            private String freeFormDetails;
            @Generated
            private String ami;
            @Generated
            private String classicLinkVpcId;
            @Generated
            private List<String> classicLinkVpcSecurityGroups;
            @Generated
            private String instanceType;
            @Generated
            private String iamRole;
            @Generated
            private String keyPair;
            @Generated
            private String base64UserData;
            @Generated
            private Boolean legacyUdf;
            @Generated
            private UserDataOverride userDataOverride;
            @Generated
            private Integer sequence;
            @Generated
            private Boolean ignoreSequence;
            @Generated
            private Boolean startDisabled;
            @Generated
            private Boolean associatePublicIpAddress;
            @Generated
            private String subnetType;
            @Generated
            private List<String> subnetIds;
            @Generated
            private Integer cooldown;
            @Generated
            private Collection<String> enabledMetrics;
            @Generated
            private Integer healthCheckGracePeriod;
            @Generated
            private String healthCheckType;
            @Generated
            private String spotMaxPrice;
            @Generated
            private Set<String> suspendedProcesses;
            @Generated
            private Collection<String> terminationPolicies;
            @Generated
            private String kernelId;
            @Generated
            private String ramdiskId;
            @Generated
            private Boolean instanceMonitoring;
            @Generated
            private Boolean ebsOptimized;
            @Generated
            private Collection<String> classicLoadBalancers;
            @Generated
            private Collection<String> targetGroupArns;
            @Generated
            private List<String> securityGroups;
            @Generated
            private List<String> availabilityZones;
            @Generated
            private List<AmazonBlockDevice> blockDevices;
            @Generated
            private Map<String, String> tags;
            @Generated
            private Map<String, String> blockDeviceTags;
            @Generated
            private List<AmazonAsgLifecycleHook> lifecycleHooks;
            @Generated
            private Boolean capacityRebalance;
            @Generated
            private int minInstances;
            @Generated
            private int maxInstances;
            @Generated
            private int desiredInstances;
            @Generated
            private Boolean setLaunchTemplate;
            @Generated
            private Boolean requireIMDSv2;
            @Generated
            private Boolean associateIPv6Address;
            @Generated
            private Boolean unlimitedCpuCredits;
            @Generated
            private BasicAmazonDeployDescription.LaunchTemplatePlacement placement;
            @Generated
            private List<BasicAmazonDeployDescription.LaunchTemplateLicenseSpecification> licenseSpecifications;
            @Generated
            private Boolean enableEnclave;
            @Generated
            private String onDemandAllocationStrategy;
            @Generated
            private Integer onDemandBaseCapacity;
            @Generated
            private Integer onDemandPercentageAboveBaseCapacity;
            @Generated
            private String spotAllocationStrategy;
            @Generated
            private Integer spotInstancePools;
            @Generated
            private List<BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType> launchTemplateOverridesForInstanceType;

            @Generated
            AsgConfigurationBuilder() {
            }

            @Generated
            public AsgConfigurationBuilder application(String application) {
                this.application = application;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder region(String region) {
                this.region = region;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder credentials(NetflixAmazonCredentials credentials) {
                this.credentials = credentials;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder stack(String stack) {
                this.stack = stack;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder freeFormDetails(String freeFormDetails) {
                this.freeFormDetails = freeFormDetails;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder ami(String ami) {
                this.ami = ami;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder classicLinkVpcId(String classicLinkVpcId) {
                this.classicLinkVpcId = classicLinkVpcId;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder classicLinkVpcSecurityGroups(List<String> classicLinkVpcSecurityGroups) {
                this.classicLinkVpcSecurityGroups = classicLinkVpcSecurityGroups;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder iamRole(String iamRole) {
                this.iamRole = iamRole;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder keyPair(String keyPair) {
                this.keyPair = keyPair;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder base64UserData(String base64UserData) {
                this.base64UserData = base64UserData;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder legacyUdf(Boolean legacyUdf) {
                this.legacyUdf = legacyUdf;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder userDataOverride(UserDataOverride userDataOverride) {
                this.userDataOverride = userDataOverride;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder sequence(Integer sequence) {
                this.sequence = sequence;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder ignoreSequence(Boolean ignoreSequence) {
                this.ignoreSequence = ignoreSequence;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder startDisabled(Boolean startDisabled) {
                this.startDisabled = startDisabled;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder associatePublicIpAddress(Boolean associatePublicIpAddress) {
                this.associatePublicIpAddress = associatePublicIpAddress;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder subnetType(String subnetType) {
                this.subnetType = subnetType;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder cooldown(Integer cooldown) {
                this.cooldown = cooldown;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder enabledMetrics(Collection<String> enabledMetrics) {
                this.enabledMetrics = enabledMetrics;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
                this.healthCheckGracePeriod = healthCheckGracePeriod;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder healthCheckType(String healthCheckType) {
                this.healthCheckType = healthCheckType;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder spotMaxPrice(String spotMaxPrice) {
                this.spotMaxPrice = spotMaxPrice;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder suspendedProcesses(Set<String> suspendedProcesses) {
                this.suspendedProcesses = suspendedProcesses;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder terminationPolicies(Collection<String> terminationPolicies) {
                this.terminationPolicies = terminationPolicies;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder kernelId(String kernelId) {
                this.kernelId = kernelId;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder ramdiskId(String ramdiskId) {
                this.ramdiskId = ramdiskId;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder instanceMonitoring(Boolean instanceMonitoring) {
                this.instanceMonitoring = instanceMonitoring;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder ebsOptimized(Boolean ebsOptimized) {
                this.ebsOptimized = ebsOptimized;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder classicLoadBalancers(Collection<String> classicLoadBalancers) {
                this.classicLoadBalancers = classicLoadBalancers;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder targetGroupArns(Collection<String> targetGroupArns) {
                this.targetGroupArns = targetGroupArns;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder securityGroups(List<String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder availabilityZones(List<String> availabilityZones) {
                this.availabilityZones = availabilityZones;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder blockDevices(List<AmazonBlockDevice> blockDevices) {
                this.blockDevices = blockDevices;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder tags(Map<String, String> tags) {
                this.tags = tags;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder blockDeviceTags(Map<String, String> blockDeviceTags) {
                this.blockDeviceTags = blockDeviceTags;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder lifecycleHooks(List<AmazonAsgLifecycleHook> lifecycleHooks) {
                this.lifecycleHooks = lifecycleHooks;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder capacityRebalance(Boolean capacityRebalance) {
                this.capacityRebalance = capacityRebalance;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder minInstances(int minInstances) {
                this.minInstances = minInstances;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder maxInstances(int maxInstances) {
                this.maxInstances = maxInstances;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder desiredInstances(int desiredInstances) {
                this.desiredInstances = desiredInstances;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder setLaunchTemplate(Boolean setLaunchTemplate) {
                this.setLaunchTemplate = setLaunchTemplate;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder requireIMDSv2(Boolean requireIMDSv2) {
                this.requireIMDSv2 = requireIMDSv2;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder associateIPv6Address(Boolean associateIPv6Address) {
                this.associateIPv6Address = associateIPv6Address;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder unlimitedCpuCredits(Boolean unlimitedCpuCredits) {
                this.unlimitedCpuCredits = unlimitedCpuCredits;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder placement(BasicAmazonDeployDescription.LaunchTemplatePlacement placement) {
                this.placement = placement;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder licenseSpecifications(List<BasicAmazonDeployDescription.LaunchTemplateLicenseSpecification> licenseSpecifications) {
                this.licenseSpecifications = licenseSpecifications;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder enableEnclave(Boolean enableEnclave) {
                this.enableEnclave = enableEnclave;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder onDemandAllocationStrategy(String onDemandAllocationStrategy) {
                this.onDemandAllocationStrategy = onDemandAllocationStrategy;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder onDemandBaseCapacity(Integer onDemandBaseCapacity) {
                this.onDemandBaseCapacity = onDemandBaseCapacity;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder onDemandPercentageAboveBaseCapacity(Integer onDemandPercentageAboveBaseCapacity) {
                this.onDemandPercentageAboveBaseCapacity = onDemandPercentageAboveBaseCapacity;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder spotAllocationStrategy(String spotAllocationStrategy) {
                this.spotAllocationStrategy = spotAllocationStrategy;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder spotInstancePools(Integer spotInstancePools) {
                this.spotInstancePools = spotInstancePools;
                return this;
            }

            @Generated
            public AsgConfigurationBuilder launchTemplateOverridesForInstanceType(List<BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType> launchTemplateOverridesForInstanceType) {
                this.launchTemplateOverridesForInstanceType = launchTemplateOverridesForInstanceType;
                return this;
            }

            @Generated
            public AsgConfiguration build() {
                return new AsgConfiguration(this.application, this.region, this.credentials, this.stack, this.freeFormDetails, this.ami, this.classicLinkVpcId, this.classicLinkVpcSecurityGroups, this.instanceType, this.iamRole, this.keyPair, this.base64UserData, this.legacyUdf, this.userDataOverride, this.sequence, this.ignoreSequence, this.startDisabled, this.associatePublicIpAddress, this.subnetType, this.subnetIds, this.cooldown, this.enabledMetrics, this.healthCheckGracePeriod, this.healthCheckType, this.spotMaxPrice, this.suspendedProcesses, this.terminationPolicies, this.kernelId, this.ramdiskId, this.instanceMonitoring, this.ebsOptimized, this.classicLoadBalancers, this.targetGroupArns, this.securityGroups, this.availabilityZones, this.blockDevices, this.tags, this.blockDeviceTags, this.lifecycleHooks, this.capacityRebalance, this.minInstances, this.maxInstances, this.desiredInstances, this.setLaunchTemplate, this.requireIMDSv2, this.associateIPv6Address, this.unlimitedCpuCredits, this.placement, this.licenseSpecifications, this.enableEnclave, this.onDemandAllocationStrategy, this.onDemandBaseCapacity, this.onDemandPercentageAboveBaseCapacity, this.spotAllocationStrategy, this.spotInstancePools, this.launchTemplateOverridesForInstanceType);
            }

            @Generated
            public String toString() {
                return "AutoScalingWorker.AsgConfiguration.AsgConfigurationBuilder(application=" + this.application + ", region=" + this.region + ", credentials=" + String.valueOf((Object)this.credentials) + ", stack=" + this.stack + ", freeFormDetails=" + this.freeFormDetails + ", ami=" + this.ami + ", classicLinkVpcId=" + this.classicLinkVpcId + ", classicLinkVpcSecurityGroups=" + String.valueOf(this.classicLinkVpcSecurityGroups) + ", instanceType=" + this.instanceType + ", iamRole=" + this.iamRole + ", keyPair=" + this.keyPair + ", base64UserData=" + this.base64UserData + ", legacyUdf=" + this.legacyUdf + ", userDataOverride=" + String.valueOf(this.userDataOverride) + ", sequence=" + this.sequence + ", ignoreSequence=" + this.ignoreSequence + ", startDisabled=" + this.startDisabled + ", associatePublicIpAddress=" + this.associatePublicIpAddress + ", subnetType=" + this.subnetType + ", subnetIds=" + String.valueOf(this.subnetIds) + ", cooldown=" + this.cooldown + ", enabledMetrics=" + String.valueOf(this.enabledMetrics) + ", healthCheckGracePeriod=" + this.healthCheckGracePeriod + ", healthCheckType=" + this.healthCheckType + ", spotMaxPrice=" + this.spotMaxPrice + ", suspendedProcesses=" + String.valueOf(this.suspendedProcesses) + ", terminationPolicies=" + String.valueOf(this.terminationPolicies) + ", kernelId=" + this.kernelId + ", ramdiskId=" + this.ramdiskId + ", instanceMonitoring=" + this.instanceMonitoring + ", ebsOptimized=" + this.ebsOptimized + ", classicLoadBalancers=" + String.valueOf(this.classicLoadBalancers) + ", targetGroupArns=" + String.valueOf(this.targetGroupArns) + ", securityGroups=" + String.valueOf(this.securityGroups) + ", availabilityZones=" + String.valueOf(this.availabilityZones) + ", blockDevices=" + String.valueOf(this.blockDevices) + ", tags=" + String.valueOf(this.tags) + ", blockDeviceTags=" + String.valueOf(this.blockDeviceTags) + ", lifecycleHooks=" + String.valueOf(this.lifecycleHooks) + ", capacityRebalance=" + this.capacityRebalance + ", minInstances=" + this.minInstances + ", maxInstances=" + this.maxInstances + ", desiredInstances=" + this.desiredInstances + ", setLaunchTemplate=" + this.setLaunchTemplate + ", requireIMDSv2=" + this.requireIMDSv2 + ", associateIPv6Address=" + this.associateIPv6Address + ", unlimitedCpuCredits=" + this.unlimitedCpuCredits + ", placement=" + String.valueOf(this.placement) + ", licenseSpecifications=" + String.valueOf(this.licenseSpecifications) + ", enableEnclave=" + this.enableEnclave + ", onDemandAllocationStrategy=" + this.onDemandAllocationStrategy + ", onDemandBaseCapacity=" + this.onDemandBaseCapacity + ", onDemandPercentageAboveBaseCapacity=" + this.onDemandPercentageAboveBaseCapacity + ", spotAllocationStrategy=" + this.spotAllocationStrategy + ", spotInstancePools=" + this.spotInstancePools + ", launchTemplateOverridesForInstanceType=" + String.valueOf(this.launchTemplateOverridesForInstanceType) + ")";
            }
        }
    }
}

