/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.description;

import com.amazonaws.util.CollectionUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableSet;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.AbstractAmazonCredentialsDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.BasicAmazonDeployDescription;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonBlockDevice;
import com.netflix.spinnaker.clouddriver.aws.userdata.UserDataOverride;
import com.netflix.spinnaker.clouddriver.security.resources.ServerGroupsNameable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ModifyServerGroupLaunchTemplateDescription
extends AbstractAmazonCredentialsDescription
implements ServerGroupsNameable {
    String region;
    String asgName;
    String amiName;
    String instanceType;
    String subnetType;
    String iamRole;
    String keyPair;
    Boolean associatePublicIpAddress;
    String spotPrice;
    String ramdiskId;
    Boolean instanceMonitoring;
    Boolean ebsOptimized;
    String classicLinkVpcId;
    List<String> classicLinkVpcSecurityGroups;
    Boolean legacyUdf;
    String base64UserData;
    UserDataOverride userDataOverride = new UserDataOverride();
    List<AmazonBlockDevice> blockDevices;
    List<String> securityGroups;
    Boolean securityGroupsAppendOnly;
    boolean copySourceCustomBlockDeviceMappings = true;
    private Boolean requireIMDV2;
    private String kernelId;
    private String imageId;
    private Boolean associateIPv6Address;
    private Boolean unlimitedCpuCredits;
    private Boolean enableEnclave;
    private String onDemandAllocationStrategy;
    private Integer onDemandBaseCapacity;
    private Integer onDemandPercentageAboveBaseCapacity;
    private String spotAllocationStrategy;
    private Integer spotInstancePools;
    private List<BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType> launchTemplateOverridesForInstanceType;

    @JsonIgnore
    public Collection<String> getServerGroupNames() {
        return Collections.singletonList(this.asgName);
    }

    public static Set<String> getMetadataFieldNames() {
        return ImmutableSet.of((Object)"account", (Object)"region", (Object)"asgName", (Object)"credentials", (Object)"securityGroupsAppendOnly", (Object)"copySourceCustomBlockDeviceMappings", (Object[])new String[0]);
    }

    public static Set<String> getMixedInstancesPolicyOnlyFieldNames() {
        return ImmutableSet.of((Object)"onDemandAllocationStrategy", (Object)"onDemandBaseCapacity", (Object)"onDemandPercentageAboveBaseCapacity", (Object)"spotAllocationStrategy", (Object)"spotInstancePools", (Object)"launchTemplateOverridesForInstanceType", (Object[])new String[0]);
    }

    public static Set<String> getMixedInstancesPolicyFieldNames() {
        return ImmutableSet.of((Object)"onDemandAllocationStrategy", (Object)"onDemandBaseCapacity", (Object)"onDemandPercentageAboveBaseCapacity", (Object)"spotAllocationStrategy", (Object)"spotInstancePools", (Object)"spotPrice", (Object[])new String[]{"launchTemplateOverridesForInstanceType"});
    }

    public Set<String> getAllInstanceTypes() {
        HashSet<String> instanceTypes = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)this.getInstanceType())) {
            instanceTypes.add(this.getInstanceType());
        }
        if (!CollectionUtils.isNullOrEmpty(this.launchTemplateOverridesForInstanceType)) {
            this.launchTemplateOverridesForInstanceType.forEach(override -> instanceTypes.add(override.getInstanceType()));
        }
        return instanceTypes;
    }

    public String toString() {
        return ("ModifyServerGroupLaunchTemplateDescription{" + ("region=" + this.region) + (", asgName=" + this.asgName) + (", amiName=" + this.amiName) + (", instanceType=" + this.instanceType) + (", subnetType=" + this.subnetType) + (", iamRole=" + this.iamRole) + (", keyPair=" + this.keyPair) + (", associatePublicIpAddress=" + this.associatePublicIpAddress) + (", spotPrice=" + this.spotPrice) + (", ramdiskId=" + this.ramdiskId) + (", instanceMonitoring=" + this.instanceMonitoring) + (", ebsOptimized=" + this.ebsOptimized) + (", classicLinkVpcId=" + this.classicLinkVpcId) + (", classicLinkVpcSecurityGroups=" + String.valueOf(this.classicLinkVpcSecurityGroups)) + (", legacyUdf=" + this.legacyUdf) + (", base64UserData=" + this.base64UserData) + (", userDataOverride=" + String.valueOf(this.userDataOverride)) + (", blockDevices=" + String.valueOf(this.blockDevices)) + (", securityGroups=" + String.valueOf(this.securityGroups)) + (", securityGroupsAppendOnly=" + this.securityGroupsAppendOnly) + (", copySourceCustomBlockDeviceMappings=" + this.copySourceCustomBlockDeviceMappings) + (", requireIMDV2=" + this.requireIMDV2) + (", kernelId=" + this.kernelId) + (", imageId=" + this.imageId) + (", associateIPv6Address=" + this.associateIPv6Address) + (", unlimitedCpuCredits=" + this.unlimitedCpuCredits) + (", onDemandAllocationStrategy=" + this.onDemandAllocationStrategy) + (", onDemandBaseCapacity=" + this.onDemandBaseCapacity) + (", onDemandPercentageAboveBaseCapacity=" + this.onDemandPercentageAboveBaseCapacity) + (", spotAllocationStrategy=" + this.spotAllocationStrategy) + (", spotInstancePools=" + this.spotInstancePools) + (", launchTemplateOverridesForInstanceType=" + String.valueOf(this.launchTemplateOverridesForInstanceType)) + "}").replaceAll(",\\s[a-zA-Z0-9]+=null", "");
    }

    @Generated
    public String getRegion() {
        return this.region;
    }

    @Generated
    public String getAsgName() {
        return this.asgName;
    }

    @Generated
    public String getAmiName() {
        return this.amiName;
    }

    @Generated
    public String getInstanceType() {
        return this.instanceType;
    }

    @Generated
    public String getSubnetType() {
        return this.subnetType;
    }

    @Generated
    public String getIamRole() {
        return this.iamRole;
    }

    @Generated
    public String getKeyPair() {
        return this.keyPair;
    }

    @Generated
    public Boolean getAssociatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    @Generated
    public String getSpotPrice() {
        return this.spotPrice;
    }

    @Generated
    public String getRamdiskId() {
        return this.ramdiskId;
    }

    @Generated
    public Boolean getInstanceMonitoring() {
        return this.instanceMonitoring;
    }

    @Generated
    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    @Generated
    public String getClassicLinkVpcId() {
        return this.classicLinkVpcId;
    }

    @Generated
    public List<String> getClassicLinkVpcSecurityGroups() {
        return this.classicLinkVpcSecurityGroups;
    }

    @Generated
    public Boolean getLegacyUdf() {
        return this.legacyUdf;
    }

    @Generated
    public String getBase64UserData() {
        return this.base64UserData;
    }

    @Generated
    public UserDataOverride getUserDataOverride() {
        return this.userDataOverride;
    }

    @Generated
    public List<AmazonBlockDevice> getBlockDevices() {
        return this.blockDevices;
    }

    @Generated
    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    @Generated
    public Boolean getSecurityGroupsAppendOnly() {
        return this.securityGroupsAppendOnly;
    }

    @Generated
    public boolean isCopySourceCustomBlockDeviceMappings() {
        return this.copySourceCustomBlockDeviceMappings;
    }

    @Generated
    public Boolean getRequireIMDV2() {
        return this.requireIMDV2;
    }

    @Generated
    public String getKernelId() {
        return this.kernelId;
    }

    @Generated
    public String getImageId() {
        return this.imageId;
    }

    @Generated
    public Boolean getAssociateIPv6Address() {
        return this.associateIPv6Address;
    }

    @Generated
    public Boolean getUnlimitedCpuCredits() {
        return this.unlimitedCpuCredits;
    }

    @Generated
    public Boolean getEnableEnclave() {
        return this.enableEnclave;
    }

    @Generated
    public String getOnDemandAllocationStrategy() {
        return this.onDemandAllocationStrategy;
    }

    @Generated
    public Integer getOnDemandBaseCapacity() {
        return this.onDemandBaseCapacity;
    }

    @Generated
    public Integer getOnDemandPercentageAboveBaseCapacity() {
        return this.onDemandPercentageAboveBaseCapacity;
    }

    @Generated
    public String getSpotAllocationStrategy() {
        return this.spotAllocationStrategy;
    }

    @Generated
    public Integer getSpotInstancePools() {
        return this.spotInstancePools;
    }

    @Generated
    public List<BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType> getLaunchTemplateOverridesForInstanceType() {
        return this.launchTemplateOverridesForInstanceType;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setRegion(String region) {
        this.region = region;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setAsgName(String asgName) {
        this.asgName = asgName;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setAmiName(String amiName) {
        this.amiName = amiName;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setSubnetType(String subnetType) {
        this.subnetType = subnetType;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setIamRole(String iamRole) {
        this.iamRole = iamRole;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setKeyPair(String keyPair) {
        this.keyPair = keyPair;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
        this.associatePublicIpAddress = associatePublicIpAddress;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setSpotPrice(String spotPrice) {
        this.spotPrice = spotPrice;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setInstanceMonitoring(Boolean instanceMonitoring) {
        this.instanceMonitoring = instanceMonitoring;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setClassicLinkVpcId(String classicLinkVpcId) {
        this.classicLinkVpcId = classicLinkVpcId;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setClassicLinkVpcSecurityGroups(List<String> classicLinkVpcSecurityGroups) {
        this.classicLinkVpcSecurityGroups = classicLinkVpcSecurityGroups;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setLegacyUdf(Boolean legacyUdf) {
        this.legacyUdf = legacyUdf;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setBase64UserData(String base64UserData) {
        this.base64UserData = base64UserData;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setUserDataOverride(UserDataOverride userDataOverride) {
        this.userDataOverride = userDataOverride;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setBlockDevices(List<AmazonBlockDevice> blockDevices) {
        this.blockDevices = blockDevices;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setSecurityGroups(List<String> securityGroups) {
        this.securityGroups = securityGroups;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setSecurityGroupsAppendOnly(Boolean securityGroupsAppendOnly) {
        this.securityGroupsAppendOnly = securityGroupsAppendOnly;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setCopySourceCustomBlockDeviceMappings(boolean copySourceCustomBlockDeviceMappings) {
        this.copySourceCustomBlockDeviceMappings = copySourceCustomBlockDeviceMappings;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setRequireIMDV2(Boolean requireIMDV2) {
        this.requireIMDV2 = requireIMDV2;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setKernelId(String kernelId) {
        this.kernelId = kernelId;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setAssociateIPv6Address(Boolean associateIPv6Address) {
        this.associateIPv6Address = associateIPv6Address;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setUnlimitedCpuCredits(Boolean unlimitedCpuCredits) {
        this.unlimitedCpuCredits = unlimitedCpuCredits;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setEnableEnclave(Boolean enableEnclave) {
        this.enableEnclave = enableEnclave;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setOnDemandAllocationStrategy(String onDemandAllocationStrategy) {
        this.onDemandAllocationStrategy = onDemandAllocationStrategy;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setOnDemandBaseCapacity(Integer onDemandBaseCapacity) {
        this.onDemandBaseCapacity = onDemandBaseCapacity;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setOnDemandPercentageAboveBaseCapacity(Integer onDemandPercentageAboveBaseCapacity) {
        this.onDemandPercentageAboveBaseCapacity = onDemandPercentageAboveBaseCapacity;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setSpotAllocationStrategy(String spotAllocationStrategy) {
        this.spotAllocationStrategy = spotAllocationStrategy;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setSpotInstancePools(Integer spotInstancePools) {
        this.spotInstancePools = spotInstancePools;
        return this;
    }

    @Generated
    public ModifyServerGroupLaunchTemplateDescription setLaunchTemplateOverridesForInstanceType(List<BasicAmazonDeployDescription.LaunchTemplateOverridesForInstanceType> launchTemplateOverridesForInstanceType) {
        this.launchTemplateOverridesForInstanceType = launchTemplateOverridesForInstanceType;
        return this;
    }
}

