/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.model.AmazonAutoScalingException;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AmazonEC2Exception;
import com.amazonaws.services.ec2.model.DeleteLaunchTemplateRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.netflix.spinnaker.clouddriver.aws.AmazonCloudProvider;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.DestroyAsgDescription;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.events.DeleteServerGroupEvent;
import com.netflix.spinnaker.clouddriver.orchestration.events.OperationEvent;
import com.netflix.spinnaker.kork.core.RetrySupport;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class DestroyAsgAtomicOperation
implements AtomicOperation<Void>,
GroovyObject {
    protected static final Object MAX_SIMULTANEOUS_TERMINATIONS;
    private static final String BASE_PHASE = "DESTROY_ASG";
    @Autowired
    private AmazonClientProvider amazonClientProvider;
    private final DestroyAsgDescription description;
    private final Collection<DeleteServerGroupEvent> events;
    private final RetrySupport retrySupport;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DestroyAsgAtomicOperation(DestroyAsgDescription description) {
        DestroyAsgDescription destroyAsgDescription;
        MetaClass metaClass;
        List list;
        this.events = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, RetrySupport.class);
        this.retrySupport = IndyInterface.bootstrap("cast", "()", 0, callSite);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = destroyAsgDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public Void operate(List priorOutputs) {
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "toString", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite descriptor = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "asgs", 4, this.description), new _operate_closure1(this, this)));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{descriptor}, new String[]{"Initializing ASG Destroy operation for ", "..."}));
        Object asg = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("getProperty", "asgs", 4, this.description)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                asg = callSite.next();
                IndyInterface.bootstrap("invoke", "deleteAsg", 2, this, IndyInterface.bootstrap("getProperty", "serverGroupName", 0, asg), IndyInterface.bootstrap("getProperty", "region", 0, asg));
                IndyInterface.bootstrap("invoke", "leftShift", 0, this.events, IndyInterface.bootstrap("init", "<init>", 0, DeleteServerGroupEvent.class, IndyInterface.bootstrap("getProperty", "ID", 0, AmazonCloudProvider.class), IndyInterface.bootstrap("getProperty", "accountId", 0, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description)), IndyInterface.bootstrap("getProperty", "region", 0, asg), IndyInterface.bootstrap("getProperty", "serverGroupName", 0, asg)));
            }
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{descriptor}, new String[]{"Finished Destroy ASG operation for ", "."}));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    public Collection<OperationEvent> getEvents() {
        return this.events;
    }

    private void deleteAsg(String asgName, String region) {
        CallSite credentials = IndyInterface.bootstrap("getProperty", "credentials", 4, this.description);
        CallSite autoScaling = IndyInterface.bootstrap("invoke", "getAutoScaling", 0, this.amazonClientProvider, credentials, region, true);
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{asgName, region}, new String[]{"Looking up instance ids for ", " in ", "..."}));
        CallSite result = IndyInterface.bootstrap("invoke", "describeAutoScalingGroups", 0, autoScaling, IndyInterface.bootstrap("init", "<init>", 0, DescribeAutoScalingGroupsRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"autoScalingGroupNames", ScriptBytecodeAdapter.createList((Object[])new Object[]{asgName})})));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "autoScalingGroups", 0, result)) == false) {
            return;
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("getProperty", "autoScalingGroups", 0, result)), (Object)1)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{credentials, region, asgName}, new String[]{"There should only be one ASG in ", ":", " named ", ""})));
        }
        CallSite autoScalingGroup = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "autoScalingGroups", 0, result), false));
        CallSite instanceIds = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "instanceId", 0, IndyInterface.bootstrap("getProperty", "instances", 0, autoScalingGroup)));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{asgName, region}, new String[]{"Force deleting ", " in ", "."}));
        IndyInterface.bootstrap("invoke", "deleteAutoScalingGroup", 0, autoScaling, IndyInterface.bootstrap("init", "<init>", 0, DeleteAutoScalingGroupRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"autoScalingGroupName", asgName, "forceDelete", true})));
        CallSite ec2 = IndyInterface.bootstrap("invoke", "getAmazonEC2", 0, this.amazonClientProvider, credentials, region, true);
        IndyInterface.bootstrap("invoke", "deleteLaunchSetting", 2, this, autoScalingGroup, autoScaling, ec2, region);
        int i = 0;
        while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)IndyInterface.bootstrap("invoke", "size", 0, instanceIds))) {
            int end = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "min", 0, Math.class, IndyInterface.bootstrap("invoke", "size", 0, instanceIds), IndyInterface.bootstrap("invoke", "plus", 0, i, MAX_SIMULTANEOUS_TERMINATIONS)));
            try {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "minus", 0, end, i)}, new String[]{"Issuing terminate instances request for ", " instances."}));
                IndyInterface.bootstrap("invoke", "terminateInstances", 0, ec2, IndyInterface.bootstrap("invoke", "withInstanceIds", 0, IndyInterface.bootstrap("init", "<init>", 0, TerminateInstancesRequest.class), IndyInterface.bootstrap("invoke", "subList", 0, instanceIds, i, end)));
            }
            catch (AmazonClientException e) {
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), BASE_PHASE, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"Unable to terminate instances, reason: '", "'"}));
            }
            i = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "plus", 0, i, MAX_SIMULTANEOUS_TERMINATIONS));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void deleteLaunchSetting(AutoScalingGroup autoScalingGroup, AmazonAutoScaling autoScaling, AmazonEC2 amazonEC2, String region) {
        void var3_3;
        void var2_2;
        Reference autoScalingGroup2 = new Reference((Object)autoScalingGroup);
        Reference autoScaling2 = new Reference((Object)var2_2);
        Reference amazonEC22 = new Reference((Object)var3_3);
        Reference region2 = new Reference((Object)region);
        public final class _deleteLaunchSetting_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference autoScalingGroup;
            private /* synthetic */ Reference region;
            private /* synthetic */ Reference autoScaling;
            private /* synthetic */ Reference amazonEC2;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _deleteLaunchSetting_closure2(Object _outerInstance, Object _thisObject, Reference autoScalingGroup, Reference region, Reference autoScaling, Reference amazonEC2) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.autoScalingGroup = reference4 = autoScalingGroup;
                this.region = reference3 = region;
                this.autoScaling = reference2 = autoScaling;
                this.amazonEC2 = reference = amazonEC2;
            }

            public Object doCall(Object it) {
                block14: {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "launchConfigurationName", 0, IndyInterface.bootstrap("cast", "()", 0, this.autoScalingGroup.get()))) != false) {
                        CallSite lcName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "launchConfigurationName", 0, IndyInterface.bootstrap("cast", "()", 0, this.autoScalingGroup.get())));
                        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("invoke", "getTask", 2, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{lcName, IndyInterface.bootstrap("cast", "()", 0, this.region.get())}, new String[]{"Deleting launch config ", " in ", "."}));
                        CallSite callSite = IndyInterface.bootstrap("invoke", "deleteLaunchConfiguration", 0, IndyInterface.bootstrap("cast", "()", 0, this.autoScaling.get()), IndyInterface.bootstrap("init", "<init>", 0, DeleteLaunchConfigurationRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"launchConfigurationName", lcName})));
                        try {
                            return callSite;
                        }
                        catch (AmazonAutoScalingException e) {
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "message", 0, e)), "launch configuration name not found")) == false) {
                                throw (Throwable)e;
                            }
                            break block14;
                        }
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "launchTemplate", 0, IndyInterface.bootstrap("cast", "()", 0, this.autoScalingGroup.get()))) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "mixedInstancesPolicy", 0, IndyInterface.bootstrap("cast", "()", 0, this.autoScalingGroup.get())))) {
                        CallSite launchTemplateId = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "launchTemplate", 0, IndyInterface.bootstrap("cast", "()", 0, this.autoScalingGroup.get()))) != false ? IndyInterface.bootstrap("getProperty", "launchTemplateId", 0, IndyInterface.bootstrap("getProperty", "launchTemplate", 0, IndyInterface.bootstrap("cast", "()", 0, this.autoScalingGroup.get()))) : IndyInterface.bootstrap("getProperty", "launchTemplateId", 0, IndyInterface.bootstrap("getProperty", "launchTemplateSpecification", 1, IndyInterface.bootstrap("getProperty", "launchTemplate", 1, IndyInterface.bootstrap("getProperty", "mixedInstancesPolicy", 0, IndyInterface.bootstrap("cast", "()", 0, this.autoScalingGroup.get()))))));
                        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("invoke", "getTask", 2, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{launchTemplateId, IndyInterface.bootstrap("cast", "()", 0, this.region.get())}, new String[]{"Deleting launch template ", " in ", "."}));
                        CallSite callSite = IndyInterface.bootstrap("invoke", "deleteLaunchTemplate", 0, IndyInterface.bootstrap("cast", "()", 0, this.amazonEC2.get()), IndyInterface.bootstrap("init", "<init>", 0, DeleteLaunchTemplateRequest.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"launchTemplateId", launchTemplateId})));
                        try {
                            return callSite;
                        }
                        catch (AmazonEC2Exception e) {
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "message", 0, e)), "does not exist")) == false) {
                                throw (Throwable)e;
                            }
                        }
                    }
                }
                return null;
            }

            @Generated
            public AutoScalingGroup getAutoScalingGroup() {
                return IndyInterface.bootstrap("cast", "()", 0, this.autoScalingGroup.get());
            }

            @Generated
            public String getRegion() {
                return IndyInterface.bootstrap("cast", "()", 0, this.region.get());
            }

            @Generated
            public AmazonAutoScaling getAutoScaling() {
                return IndyInterface.bootstrap("cast", "()", 0, this.autoScaling.get());
            }

            @Generated
            public AmazonEC2 getAmazonEC2() {
                return IndyInterface.bootstrap("cast", "()", 0, this.amazonEC2.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _deleteLaunchSetting_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "retry", 0, this.retrySupport, new _deleteLaunchSetting_closure2(this, this, autoScalingGroup2, region2, autoScaling2, amazonEC22), 5, IndyInterface.bootstrap("invoke", "ofSeconds", 0, Duration.class, true), true);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DestroyAsgAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        int n = 100;
        MAX_SIMULTANEOUS_TERMINATIONS = n;
    }

    @Generated
    public AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public void setAmazonClientProvider(AmazonClientProvider amazonClientProvider) {
        this.amazonClientProvider = amazonClientProvider;
    }

    public /* synthetic */ Collection super$1$getEvents() {
        return super.getEvents();
    }
}

