/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DetachInstancesRequest;
import com.amazonaws.services.autoscaling.model.LifecycleState;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.DetachInstancesDescription;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DetachInstancesAtomicOperation
implements AtomicOperation<Void>,
GroovyObject {
    private static final int MAX_DETACH = 20;
    private static final Set<String> ALLOWED_LIFECYCLE_STATES;
    private static final String BASE_PHASE = "DETACH_INSTANCES";
    private static final String TAG_DETACHED = "spinnaker:Detached";
    public static final String TAG_PENDING_TERMINATION = "spinnaker:PendingTermination";
    private final DetachInstancesDescription description;
    @Autowired
    private AmazonClientProvider amazonClientProvider;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public DetachInstancesAtomicOperation(DetachInstancesDescription description) {
        DetachInstancesDescription detachInstancesDescription;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = detachInstancesDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public Void operate(List priorOutputs) {
        Reference amazonAutoScaling = new Reference((Object)IndyInterface.bootstrap("invoke", "getAutoScaling", 0, this.amazonClientProvider, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), IndyInterface.bootstrap("getProperty", "region", 4, this.description), true));
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference amazonAutoScaling;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure1(Object _outerInstance, Object _thisObject, Reference amazonAutoScaling) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.amazonAutoScaling = reference = amazonAutoScaling;
            }

            public Object doCall(AutoScalingGroup autoScalingGroup) {
                Reference autoScalingGroup2 = new Reference((Object)autoScalingGroup);
                CallSite validInstanceIds = IndyInterface.bootstrap("invoke", "intersect", 0, IndyInterface.bootstrap("getProperty", "instanceIds", 4, IndyInterface.bootstrap("getProperty", "description", 12, this)), ScriptBytecodeAdapter.getPropertySpreadSafe(_operate_closure1.class, (Object)IndyInterface.bootstrap("getProperty", "instances", 0, (AutoScalingGroup)autoScalingGroup2.get()), (String)"instanceId"));
                if (IndyInterface.bootstrap("cast", "()", 0, validInstanceIds) == false) {
                    return null;
                }
                public final class _closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference autoScalingGroup;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure2(Object _outerInstance, Object _thisObject, Reference autoScalingGroup) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.autoScalingGroup = reference = autoScalingGroup;
                    }

                    public Object doCall(String instanceId) {
                        Reference instanceId2 = new Reference((Object)instanceId);
                        public final class _closure4
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference instanceId;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure4(Object _outerInstance, Object _thisObject, Reference instanceId) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.instanceId = reference = instanceId;
                            }

                            public Object doCall(Object it) {
                                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "instanceId", 0, it), (Object)IndyInterface.bootstrap("cast", "()", 0, this.instanceId.get()));
                            }

                            @Generated
                            public String getInstanceId() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.instanceId.get());
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure4.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        CallSite instance = IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("getProperty", "instances", 0, IndyInterface.bootstrap("cast", "()", 0, this.autoScalingGroup.get())), new _closure4((Object)this, this.getThisObject(), instanceId2));
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "ALLOWED_LIFECYCLE_STATES", 12, this), IndyInterface.bootstrap("getProperty", "lifecycleState", 0, instance))) != false) {
                            return true;
                        }
                        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{(String)instanceId2.get(), IndyInterface.bootstrap("getProperty", "lifecycleState", 0, instance), IndyInterface.bootstrap("getProperty", "asgName", 4, IndyInterface.bootstrap("getProperty", "description", 12, this))}, new String[]{"Unable to detach instance ", " (lifecycleState: ", ", asgName: ", ")"}));
                        return false;
                    }

                    @Generated
                    public Object call(String instanceId) {
                        Reference instanceId2 = new Reference((Object)instanceId);
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, (String)instanceId2.get());
                    }

                    @Generated
                    public AutoScalingGroup getAutoScalingGroup() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.autoScalingGroup.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                validInstanceIds = IndyInterface.bootstrap("invoke", "findAll", 0, validInstanceIds, new _closure2((Object)this, this.getThisObject(), autoScalingGroup2));
                int newMin = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("getProperty", "desiredCapacity", 0, (AutoScalingGroup)autoScalingGroup2.get()), IndyInterface.bootstrap("invoke", "size", 0, validInstanceIds)));
                if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "decrementDesiredCapacity", 4, IndyInterface.bootstrap("getProperty", "description", 12, this))) && ScriptBytecodeAdapter.compareLessThan((Object)newMin, (Object)IndyInterface.bootstrap("getProperty", "minSize", 0, (AutoScalingGroup)autoScalingGroup2.get()))) {
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "adjustMinIfNecessary", 4, IndyInterface.bootstrap("getProperty", "description", 12, this))) != false) {
                        if (newMin < 0) {
                            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), "Cannot adjust min size below 0");
                        } else {
                            IndyInterface.bootstrap("invoke", "updateAutoScalingGroup", 0, this.amazonAutoScaling.get(), IndyInterface.bootstrap("invoke", "withMinSize", 0, IndyInterface.bootstrap("invoke", "withAutoScalingGroupName", 0, IndyInterface.bootstrap("init", "<init>", 0, UpdateAutoScalingGroupRequest.class), IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, (AutoScalingGroup)autoScalingGroup2.get())), newMin));
                        }
                    } else {
                        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), "Cannot decrement ASG below minSize - set adjustMinIfNecessary to resize down minSize before detaching instances");
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "minSize", 0, (AutoScalingGroup)autoScalingGroup2.get()), IndyInterface.bootstrap("getProperty", "maxSize", 0, (AutoScalingGroup)autoScalingGroup2.get()), IndyInterface.bootstrap("getProperty", "desiredCapacity", 0, (AutoScalingGroup)autoScalingGroup2.get())}, new String[]{"Invalid ASG capacity for detachInstances (min: ", ", max: ", ", desired: ", ")"})));
                    }
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, validInstanceIds)) != false) {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), "No detachable instances");
                    return null;
                }
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, validInstanceIds, ", ")}, new String[]{"Tagging instances (", ")."}));
                List tags = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("init", "<init>", 0, Tag.class, IndyInterface.bootstrap("getProperty", "TAG_DETACHED", 12, this), IndyInterface.bootstrap("getProperty", "asgName", 4, IndyInterface.bootstrap("getProperty", "description", 12, this)))});
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "terminateDetachedInstances", 4, IndyInterface.bootstrap("getProperty", "description", 12, this))) != false) {
                    IndyInterface.bootstrap("invoke", "leftShift", 0, tags, IndyInterface.bootstrap("init", "<init>", 0, Tag.class, IndyInterface.bootstrap("getProperty", "TAG_PENDING_TERMINATION", 12, this), ScriptBytecodeAdapter.createPojoWrapper((Object)((String)((Object)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "currentTimeMillis", 0, System.class), String.class))), String.class)));
                }
                CallSite amazonEC2 = IndyInterface.bootstrap("invoke", "getAmazonEC2", 0, IndyInterface.bootstrap("getProperty", "amazonClientProvider", 12, this), IndyInterface.bootstrap("getProperty", "credentials", 4, IndyInterface.bootstrap("getProperty", "description", 12, this)), IndyInterface.bootstrap("getProperty", "region", 4, IndyInterface.bootstrap("getProperty", "description", 12, this)), true);
                IndyInterface.bootstrap("invoke", "createTags", 0, amazonEC2, IndyInterface.bootstrap("invoke", "withTags", 0, IndyInterface.bootstrap("invoke", "withResources", 0, IndyInterface.bootstrap("init", "<init>", 0, CreateTagsRequest.class), validInstanceIds), tags));
                IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, validInstanceIds, ", ")}, new String[]{"Tagged instances (", ")."}));
                public final class _closure3
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference amazonAutoScaling;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure3(Object _outerInstance, Object _thisObject, Reference amazonAutoScaling) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.amazonAutoScaling = reference = amazonAutoScaling;
                    }

                    public Object doCall(Object it) {
                        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, it, ", "), IndyInterface.bootstrap("getProperty", "asgName", 4, IndyInterface.bootstrap("getProperty", "description", 12, this))}, new String[]{"Detaching instances (", ") from ASG (", ")."}));
                        IndyInterface.bootstrap("invoke", "detachInstances", 0, this.amazonAutoScaling.get(), IndyInterface.bootstrap("invoke", "withShouldDecrementDesiredCapacity", 0, IndyInterface.bootstrap("invoke", "withInstanceIds", 0, IndyInterface.bootstrap("invoke", "withAutoScalingGroupName", 0, IndyInterface.bootstrap("init", "<init>", 0, DetachInstancesRequest.class), IndyInterface.bootstrap("getProperty", "asgName", 4, IndyInterface.bootstrap("getProperty", "description", 12, this))), it), IndyInterface.bootstrap("getProperty", "decrementDesiredCapacity", 4, IndyInterface.bootstrap("getProperty", "description", 12, this))));
                        return IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, it, ", "), IndyInterface.bootstrap("getProperty", "asgName", 4, IndyInterface.bootstrap("getProperty", "description", 12, this))}, new String[]{"Detached instances (", ") from ASG (", ")."}));
                    }

                    @Generated
                    public Object getAmazonAutoScaling() {
                        return this.amazonAutoScaling.get();
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "collate", 0, validInstanceIds, IndyInterface.bootstrap("getProperty", "MAX_DETACH", 12, this)), new _closure3((Object)this, this.getThisObject(), this.amazonAutoScaling));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "terminateDetachedInstances", 4, IndyInterface.bootstrap("getProperty", "description", 12, this))) != false) {
                    IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, validInstanceIds, ", ")}, new String[]{"Terminating instances (", ")."}));
                    IndyInterface.bootstrap("invoke", "terminateInstances", 0, amazonEC2, IndyInterface.bootstrap("invoke", "withInstanceIds", 0, IndyInterface.bootstrap("init", "<init>", 0, TerminateInstancesRequest.class), validInstanceIds));
                    return IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("getProperty", "BASE_PHASE", 12, this), new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "join", 0, validInstanceIds, ", ")}, new String[]{"Terminated instances (", ")."}));
                }
                return null;
            }

            @Generated
            public Object call(AutoScalingGroup autoScalingGroup) {
                Reference autoScalingGroup2 = new Reference((Object)autoScalingGroup);
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, (AutoScalingGroup)autoScalingGroup2.get());
            }

            @Generated
            public Object getAmazonAutoScaling() {
                return this.amazonAutoScaling.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("getProperty", "autoScalingGroups", 0, IndyInterface.bootstrap("invoke", "describeAutoScalingGroups", 0, amazonAutoScaling.get(), IndyInterface.bootstrap("invoke", "withAutoScalingGroupNames", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeAutoScalingGroupsRequest.class), IndyInterface.bootstrap("getProperty", "asgName", 4, this.description)))), new _operate_closure1(this, this, amazonAutoScaling));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DetachInstancesAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "InService", 0, LifecycleState.class)), IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "Standby", 0, LifecycleState.class))});
        ALLOWED_LIFECYCLE_STATES = IndyInterface.bootstrap("cast", "()", 0, list);
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, "com.netflix.spinnaker.clouddriver.aws.deploy.ops.DetachInstancesAtomicOperation");
        log = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public void setAmazonClientProvider(AmazonClientProvider amazonClientProvider) {
        this.amazonClientProvider = amazonClientProvider;
    }
}

