/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.ResizeAsgDescription;
import com.netflix.spinnaker.clouddriver.aws.event.AfterResizeEvent;
import com.netflix.spinnaker.clouddriver.aws.event.AfterResizeEventHandler;
import com.netflix.spinnaker.clouddriver.aws.security.AmazonClientProvider;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.springframework.beans.factory.annotation.Autowired;

public class ResizeAsgAtomicOperation
implements AtomicOperation<Void>,
GroovyObject {
    private static final String PHASE = "RESIZE";
    @Autowired
    private AmazonClientProvider amazonClientProvider;
    @Autowired
    private List<AfterResizeEventHandler> afterResizeEventHandlers;
    private final ResizeAsgDescription description;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public ResizeAsgAtomicOperation(ResizeAsgDescription description) {
        ResizeAsgDescription resizeAsgDescription;
        MetaClass metaClass;
        List list;
        this.afterResizeEventHandlers = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.description = resizeAsgDescription = description;
    }

    private static Task getTask() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "threadLocalTask", 0, TaskRepository.class)));
    }

    public Void operate(List priorOutputs) {
        public final class _operate_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _operate_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "toString", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _operate_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite descriptor = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("getProperty", "asgs", 4, this.description), new _operate_closure1(this, this)));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), PHASE, new GStringImpl(new Object[]{descriptor}, new String[]{"Initializing Resize ASG operation for ", "..."}));
        Object asg = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("getProperty", "asgs", 4, this.description)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                asg = callSite.next();
                IndyInterface.bootstrap("invoke", "resizeAsg", 2, this, IndyInterface.bootstrap("getProperty", "serverGroupName", 0, asg), IndyInterface.bootstrap("getProperty", "region", 0, asg), IndyInterface.bootstrap("getProperty", "capacity", 0, asg), IndyInterface.bootstrap("getProperty", "constraints", 0, asg));
            }
        }
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), PHASE, new GStringImpl(new Object[]{descriptor}, new String[]{"Finished Resize ASG operation for ", "."}));
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private void resizeAsg(String asgName, String region, ServerGroup.Capacity capacity, ResizeAsgDescription.Constraints constraints) {
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), PHASE, new GStringImpl(new Object[]{asgName, region, capacity}, new String[]{"Beginning resize of ", " in ", " to ", "."}));
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "min", 0, capacity), null) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "max", 0, capacity), null) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "desired", 0, capacity), null)) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), PHASE, new GStringImpl(new Object[]{asgName, region, capacity}, new String[]{"Skipping resize of ", " in ", ", at least one field in ", " needs to be non-null"}));
            return;
        }
        CallSite autoScaling = IndyInterface.bootstrap("invoke", "getAutoScaling", 0, this.amazonClientProvider, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), region, true);
        CallSite describeAutoScalingGroups = IndyInterface.bootstrap("invoke", "describeAutoScalingGroups", 0, autoScaling, IndyInterface.bootstrap("invoke", "withAutoScalingGroupNames", 0, IndyInterface.bootstrap("init", "<init>", 0, DescribeAutoScalingGroupsRequest.class), asgName));
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("getProperty", "autoScalingGroups", 0, describeAutoScalingGroups))) || ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "status", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "autoScalingGroups", 0, describeAutoScalingGroups), false)), null)) {
            IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), PHASE, new GStringImpl(new Object[]{asgName, region}, new String[]{"Skipping resize of ", " in ", ", server group does not exist"}));
            return;
        }
        IndyInterface.bootstrap("invoke", "validateConstraints", 0, ResizeAsgAtomicOperation.class, constraints, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "getAutoScalingGroups", 0, describeAutoScalingGroups), false));
        CallSite request = IndyInterface.bootstrap("invoke", "withDesiredCapacity", 0, IndyInterface.bootstrap("invoke", "withMaxSize", 0, IndyInterface.bootstrap("invoke", "withMinSize", 0, IndyInterface.bootstrap("invoke", "withAutoScalingGroupName", 0, IndyInterface.bootstrap("init", "<init>", 0, UpdateAutoScalingGroupRequest.class), asgName), IndyInterface.bootstrap("getProperty", "min", 0, capacity)), IndyInterface.bootstrap("getProperty", "max", 0, capacity)), IndyInterface.bootstrap("getProperty", "desired", 0, capacity));
        IndyInterface.bootstrap("invoke", "updateAutoScalingGroup", 0, autoScaling, request);
        Reference event = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, AfterResizeEvent.class, IndyInterface.bootstrap("getProperty", "task", 12, this), IndyInterface.bootstrap("invoke", "getAmazonEC2", 0, this.amazonClientProvider, IndyInterface.bootstrap("getProperty", "credentials", 4, this.description), region, true), autoScaling, ScriptBytecodeAdapter.createPojoWrapper((Object)((AutoScalingGroup)IndyInterface.bootstrap("invoke", "asType", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "getAutoScalingGroups", 0, describeAutoScalingGroups), false), AutoScalingGroup.class)), AutoScalingGroup.class), capacity)));
        public final class _resizeAsg_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference event;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _resizeAsg_closure2(Object _outerInstance, Object _thisObject, Reference event) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.event = reference = event;
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("invoke", "handle", 0, it, IndyInterface.bootstrap("cast", "()", 0, this.event.get()));
            }

            @Generated
            public AfterResizeEvent getEvent() {
                return IndyInterface.bootstrap("cast", "()", 0, this.event.get());
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _resizeAsg_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, this.afterResizeEventHandlers, new _resizeAsg_closure2(this, this, event));
        IndyInterface.bootstrap("invoke", "updateStatus", 0, IndyInterface.bootstrap("getProperty", "task", 12, this), PHASE, new GStringImpl(new Object[]{asgName, region}, new String[]{"Completed resize of ", " in ", "."}));
    }

    public static void validateConstraints(ResizeAsgDescription.Constraints constraints, AutoScalingGroup autoScalingGroup) {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "capacity", 5, constraints)) == false) {
            return;
        }
        Reference current = new Reference((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"min", IndyInterface.bootstrap("getProperty", "minSize", 0, autoScalingGroup), "desired", IndyInterface.bootstrap("getProperty", "desiredCapacity", 0, autoScalingGroup), "max", IndyInterface.bootstrap("getProperty", "maxSize", 0, autoScalingGroup)}));
        Map expected = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"min", IndyInterface.bootstrap("getProperty", "min", 0, IndyInterface.bootstrap("getProperty", "capacity", 4, constraints)), "desired", IndyInterface.bootstrap("getProperty", "desired", 0, IndyInterface.bootstrap("getProperty", "capacity", 4, constraints)), "max", IndyInterface.bootstrap("getProperty", "max", 0, IndyInterface.bootstrap("getProperty", "capacity", 4, constraints))});
        public final class _validateConstraints_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference current;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _validateConstraints_closure3(Object _outerInstance, Object _thisObject, Reference current) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.current = reference = current;
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "value", 0, it), null) && ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, this.current.get(), IndyInterface.bootstrap("getProperty", "key", 0, it)), (Object)IndyInterface.bootstrap("getProperty", "value", 0, it));
            }

            @Generated
            public Object getCurrent() {
                return this.current.get();
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateConstraints_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        boolean hasViolation = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "find", 0, expected, new _validateConstraints_closure3(ResizeAsgAtomicOperation.class, ResizeAsgAtomicOperation.class, current)));
        if (hasViolation) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalStateException.class, IndyInterface.bootstrap("invoke", "format", 0, String.class, "Expected capacity constraint violated (expected: %s, was: %s)", expected, current.get(), IndyInterface.bootstrap("getProperty", "autoScalingGroupName", 0, autoScalingGroup))));
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ResizeAsgAtomicOperation.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public AmazonClientProvider getAmazonClientProvider() {
        return this.amazonClientProvider;
    }

    @Generated
    public void setAmazonClientProvider(AmazonClientProvider amazonClientProvider) {
        this.amazonClientProvider = amazonClientProvider;
    }

    @Generated
    public List<AfterResizeEventHandler> getAfterResizeEventHandlers() {
        return this.afterResizeEventHandlers;
    }

    @Generated
    public void setAfterResizeEventHandlers(List<AfterResizeEventHandler> list) {
        this.afterResizeEventHandlers = list;
    }

    @Generated
    public final ResizeAsgDescription getDescription() {
        return this.description;
    }
}

