/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops.actions;

import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.InstancesDistribution;
import com.amazonaws.services.autoscaling.model.LaunchTemplateSpecification;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.LaunchTemplateBlockDeviceMapping;
import com.amazonaws.services.ec2.model.LaunchTemplateIamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceMarketOptions;
import com.amazonaws.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.LaunchTemplateVersion;
import com.amazonaws.services.ec2.model.ResponseLaunchTemplateData;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.netflix.spinnaker.clouddriver.aws.deploy.AmiIdResolver;
import com.netflix.spinnaker.clouddriver.aws.deploy.InstanceTypeUtils;
import com.netflix.spinnaker.clouddriver.aws.deploy.ModifyServerGroupUtils;
import com.netflix.spinnaker.clouddriver.aws.deploy.ResolvedAmiResult;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AsgConfigHelper;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.ModifyServerGroupLaunchTemplateDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.ModifyServerGroupLaunchTemplateAtomicOperation;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.actions.ModifyServerGroupLaunchTemplate;
import com.netflix.spinnaker.clouddriver.aws.model.AmazonBlockDevice;
import com.netflix.spinnaker.clouddriver.aws.security.NetflixAmazonCredentials;
import com.netflix.spinnaker.clouddriver.aws.services.RegionScopedProviderFactory;
import com.netflix.spinnaker.clouddriver.event.EventMetadata;
import com.netflix.spinnaker.clouddriver.saga.SagaCommand;
import com.netflix.spinnaker.clouddriver.saga.flow.SagaAction;
import com.netflix.spinnaker.clouddriver.saga.models.Saga;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class PrepareModifyServerGroupLaunchTemplate
implements SagaAction<PrepareModifyServerGroupLaunchTemplateCommand> {
    private final InstanceTypeUtils.BlockDeviceConfig blockDeviceConfig;
    private final CredentialsRepository<NetflixAmazonCredentials> credentialsRepository;
    private final RegionScopedProviderFactory regionScopedProviderFactory;

    public PrepareModifyServerGroupLaunchTemplate(InstanceTypeUtils.BlockDeviceConfig blockDeviceConfig, CredentialsRepository<NetflixAmazonCredentials> credentialsRepository, RegionScopedProviderFactory regionScopedProviderFactory) {
        this.blockDeviceConfig = blockDeviceConfig;
        this.credentialsRepository = credentialsRepository;
        this.regionScopedProviderFactory = regionScopedProviderFactory;
    }

    @NotNull
    public SagaAction.Result apply(@NotNull PrepareModifyServerGroupLaunchTemplateCommand command, @NotNull Saga saga) {
        boolean isAsgBackedByMip;
        ModifyServerGroupLaunchTemplateDescription description = command.description;
        NetflixAmazonCredentials credentials = (NetflixAmazonCredentials)this.credentialsRepository.getOne(description.getAccount());
        saga.log("[SAGA_ACTION] Performing modifyServerGroupLaunchTemplate operation for server group " + description.getAsgName());
        RegionScopedProviderFactory.RegionScopedProvider regionScopedProvider = this.regionScopedProviderFactory.forRegion(credentials, description.getRegion());
        AutoScalingGroup autoScalingGroup = this.getAutoScalingGroup(description.getAsgName(), regionScopedProvider);
        LaunchTemplateVersion launchTemplateVersion = this.getLaunchTemplateVersion(autoScalingGroup, regionScopedProvider);
        ResponseLaunchTemplateData launchTemplateData = launchTemplateVersion.getLaunchTemplateData();
        boolean bl = isAsgBackedByMip = autoScalingGroup.getMixedInstancesPolicy() != null;
        if (autoScalingGroup.getMixedInstancesPolicy() != null) {
            this.populateDescWithMipFields(description, autoScalingGroup);
        }
        boolean asgUsesSpotLt = launchTemplateData.getInstanceMarketOptions() != null;
        Set<String> nonMetadataFieldsSet = ModifyServerGroupUtils.getNonMetadataFieldsSetInReq(description);
        boolean isReqToModifyMipFieldsOnly = nonMetadataFieldsSet.stream().allMatch(f -> ModifyServerGroupLaunchTemplateDescription.getMixedInstancesPolicyFieldNames().contains(f));
        if (isReqToModifyMipFieldsOnly && (isAsgBackedByMip || !asgUsesSpotLt)) {
            saga.log("[SAGA_ACTION] Skipping PrepareModifyServerGroupLaunchTemplate as only mixed instances policy will be updated.");
            return new SagaAction.Result((SagaCommand)ModifyServerGroupLaunchTemplate.ModifyServerGroupLaunchTemplateCommand.builder().description(description).isReqToModifyLaunchTemplate(false).isAsgBackedByMixedInstancesPolicy(isAsgBackedByMip).isReqToUpgradeAsgToMixedInstancesPolicy(!isAsgBackedByMip).sourceVersion(launchTemplateVersion).build(), Collections.emptyList());
        }
        saga.log("[SAGA_ACTION] Preparing for launch template modification");
        this.populateDescWithLaunchTemplateVersion(saga, description, launchTemplateVersion, credentials.getAccountId(), regionScopedProvider.getAmazonEC2(), autoScalingGroup);
        boolean isReqToModifyAtleastOneMipOnlyField = nonMetadataFieldsSet.stream().anyMatch(f -> ModifyServerGroupLaunchTemplateDescription.getMixedInstancesPolicyOnlyFieldNames().contains(f));
        return new SagaAction.Result((SagaCommand)ModifyServerGroupLaunchTemplate.ModifyServerGroupLaunchTemplateCommand.builder().description(description).isReqToModifyLaunchTemplate(true).isAsgBackedByMixedInstancesPolicy(isAsgBackedByMip).isReqToUpgradeAsgToMixedInstancesPolicy(!isAsgBackedByMip && isReqToModifyAtleastOneMipOnlyField).sourceVersion(launchTemplateVersion).build(), Collections.emptyList());
    }

    private AutoScalingGroup getAutoScalingGroup(String autoScalingGroupName, RegionScopedProviderFactory.RegionScopedProvider regionScopedProvider) {
        try {
            return regionScopedProvider.getAsgService().getAutoScalingGroup(autoScalingGroupName);
        }
        catch (Exception e) {
            throw new ModifyServerGroupLaunchTemplateAtomicOperation.LaunchTemplateException(String.format("Failed to get server group %s.", autoScalingGroupName), e);
        }
    }

    private LaunchTemplateVersion getLaunchTemplateVersion(AutoScalingGroup autoScalingGroup, RegionScopedProviderFactory.RegionScopedProvider regionScopedProvider) {
        LaunchTemplateSpecification launchTemplateSpec = Optional.ofNullable(autoScalingGroup.getMixedInstancesPolicy() != null ? autoScalingGroup.getMixedInstancesPolicy().getLaunchTemplate().getLaunchTemplateSpecification() : autoScalingGroup.getLaunchTemplate()).orElseThrow(() -> new IllegalArgumentException(String.format("Server group is not backed by a launch template.\n%s", autoScalingGroup)));
        return regionScopedProvider.getLaunchTemplateService().getLaunchTemplateVersion(launchTemplateSpec).orElseThrow(() -> new IllegalStateException(String.format("Requested launch template %s does not exist.", launchTemplateSpec)));
    }

    private void populateDescWithMipFields(ModifyServerGroupLaunchTemplateDescription modifyDesc, AutoScalingGroup autoScalingGroup) {
        InstancesDistribution distInAsg = autoScalingGroup.getMixedInstancesPolicy().getInstancesDistribution();
        modifyDesc.setOnDemandAllocationStrategy(Optional.ofNullable(modifyDesc.getOnDemandAllocationStrategy()).orElse(distInAsg.getOnDemandAllocationStrategy()));
        modifyDesc.setOnDemandBaseCapacity(Optional.ofNullable(modifyDesc.getOnDemandBaseCapacity()).orElse(distInAsg.getOnDemandBaseCapacity()));
        modifyDesc.setOnDemandPercentageAboveBaseCapacity(Optional.ofNullable(modifyDesc.getOnDemandPercentageAboveBaseCapacity()).orElse(distInAsg.getOnDemandPercentageAboveBaseCapacity()));
        modifyDesc.setSpotAllocationStrategy(Optional.ofNullable(modifyDesc.getSpotAllocationStrategy()).orElse(distInAsg.getSpotAllocationStrategy()));
        modifyDesc.setSpotInstancePools(Optional.ofNullable(modifyDesc.getSpotInstancePools()).orElse(modifyDesc.getSpotAllocationStrategy().equals("lowest-price") ? distInAsg.getSpotInstancePools() : null));
        modifyDesc.setLaunchTemplateOverridesForInstanceType(Optional.ofNullable(modifyDesc.getLaunchTemplateOverridesForInstanceType()).orElse(AsgConfigHelper.getDescriptionOverrides(autoScalingGroup.getMixedInstancesPolicy().getLaunchTemplate().getOverrides())));
        modifyDesc.setSpotPrice(this.getSpotMaxPrice(modifyDesc.getSpotPrice(), autoScalingGroup, null));
    }

    private void populateDescWithLaunchTemplateVersion(Saga saga, ModifyServerGroupLaunchTemplateDescription modifyDesc, LaunchTemplateVersion sourceLtVersion, String accountId, AmazonEC2 amazonEC2, AutoScalingGroup autoScalingGroup) {
        ResponseLaunchTemplateData sourceLtData = sourceLtVersion.getLaunchTemplateData();
        modifyDesc.setSpotPrice(this.getSpotMaxPrice(modifyDesc.getSpotPrice(), autoScalingGroup, sourceLtData));
        modifyDesc.setImageId(this.getImageId(saga, amazonEC2, accountId, modifyDesc).orElse(sourceLtData.getImageId()));
        HashSet<String> securityGroups = new HashSet<String>();
        if (modifyDesc.getSecurityGroups() != null) {
            securityGroups.addAll(modifyDesc.getSecurityGroups());
        }
        Boolean includePreviousGroups = Optional.ofNullable(modifyDesc.getSecurityGroupsAppendOnly()).orElseGet(securityGroups::isEmpty);
        if (includePreviousGroups.booleanValue()) {
            securityGroups.addAll(sourceLtData.getNetworkInterfaces().stream().filter(i -> i.getDeviceIndex() == 0).findFirst().map(LaunchTemplateInstanceNetworkInterfaceSpecification::getGroups).orElse(Collections.emptyList()));
        }
        modifyDesc.setSecurityGroups(new ArrayList<String>(securityGroups));
        LaunchTemplateIamInstanceProfileSpecification iamInstanceProfileInLt = sourceLtData.getIamInstanceProfile();
        String iamRoleInLt = null;
        if (iamInstanceProfileInLt != null) {
            iamRoleInLt = iamInstanceProfileInLt.getName();
        }
        modifyDesc.setIamRole(Optional.ofNullable(modifyDesc.getIamRole()).orElse(iamRoleInLt));
        modifyDesc.setKeyPair(Optional.ofNullable(modifyDesc.getKeyPair()).orElseGet(() -> ((ResponseLaunchTemplateData)sourceLtData).getKeyName()));
        modifyDesc.setRamdiskId(Optional.ofNullable(modifyDesc.getRamdiskId()).orElseGet(() -> ((ResponseLaunchTemplateData)sourceLtData).getRamDiskId()));
        modifyDesc.setBlockDevices(this.getBlockDeviceMapping(modifyDesc, sourceLtData));
    }

    private List<AmazonBlockDevice> getBlockDeviceMapping(ModifyServerGroupLaunchTemplateDescription modifyDesc, ResponseLaunchTemplateData ltDataOldVersion) {
        if (modifyDesc.getBlockDevices() != null) {
            return modifyDesc.getBlockDevices();
        }
        if (modifyDesc.getInstanceType() != null && !modifyDesc.getInstanceType().equals(ltDataOldVersion.getInstanceType())) {
            List<AmazonBlockDevice> defaultBdmForNewType = this.blockDeviceConfig.getBlockDevicesForInstanceType(modifyDesc.getInstanceType());
            if (!modifyDesc.isCopySourceCustomBlockDeviceMappings()) {
                return defaultBdmForNewType;
            }
            List<AmazonBlockDevice> defaultBdmForOldType = this.blockDeviceConfig.getBlockDevicesForInstanceType(ltDataOldVersion.getInstanceType());
            if (this.matchingBlockDevices(ltDataOldVersion.getBlockDeviceMappings(), defaultBdmForOldType)) {
                return defaultBdmForNewType;
            }
        }
        return null;
    }

    private Optional<String> getImageId(Saga saga, AmazonEC2 ec2, String accountId, ModifyServerGroupLaunchTemplateDescription modifyDesc) {
        if (modifyDesc.getImageId() != null) {
            return Optional.of(modifyDesc.getImageId());
        }
        String amiNameInReq = modifyDesc.getAmiName();
        if (amiNameInReq != null) {
            saga.log("Resolving Image Id for " + amiNameInReq);
            try {
                ResolvedAmiResult ami = AmiIdResolver.resolveAmiIdFromAllSources(ec2, modifyDesc.getRegion(), amiNameInReq, accountId);
                return Optional.ofNullable(ami.getAmiId());
            }
            catch (Exception e) {
                throw new ModifyServerGroupLaunchTemplateAtomicOperation.LaunchTemplateException(String.format("Failed to resolve image id for %s", amiNameInReq), e).setRetryable(true);
            }
        }
        return Optional.empty();
    }

    private String getSpotMaxPrice(String spotMaxPriceInReq, AutoScalingGroup autoScalingGroup, ResponseLaunchTemplateData ltData) {
        if (spotMaxPriceInReq != null) {
            return spotMaxPriceInReq.trim().equals("") ? null : spotMaxPriceInReq;
        }
        Optional<Object> spotMaxPriceForAsg = Optional.empty();
        if (autoScalingGroup.getMixedInstancesPolicy() != null) {
            spotMaxPriceForAsg = Optional.ofNullable(autoScalingGroup.getMixedInstancesPolicy().getInstancesDistribution().getSpotMaxPrice());
        } else {
            LaunchTemplateInstanceMarketOptions marketOptions = ltData.getInstanceMarketOptions();
            if (marketOptions != null && marketOptions.getSpotOptions() != null) {
                spotMaxPriceForAsg = Optional.ofNullable(marketOptions.getSpotOptions().getMaxPrice());
            }
        }
        if (spotMaxPriceForAsg.isPresent()) {
            return ((String)spotMaxPriceForAsg.get()).trim().equals("") ? null : (String)spotMaxPriceForAsg.get();
        }
        return null;
    }

    private boolean matchingBlockDevices(List<LaunchTemplateBlockDeviceMapping> mappings, List<AmazonBlockDevice> defaultBlockDevicesForInstanceType) {
        for (LaunchTemplateBlockDeviceMapping mapping : mappings) {
            if (!defaultBlockDevicesForInstanceType.stream().anyMatch(deviceForType -> !this.matchesDevice((AmazonBlockDevice)deviceForType, mapping))) continue;
            return false;
        }
        return true;
    }

    private boolean matchesDevice(AmazonBlockDevice deviceForType, LaunchTemplateBlockDeviceMapping mapping) {
        BlockDevice device1 = new BlockDevice().withDeviceName(deviceForType.getDeviceName()).withVirtualName(deviceForType.getVirtualName()).withSize(deviceForType.getSize());
        BlockDevice device2 = new BlockDevice().withDeviceName(mapping.getDeviceName()).withVirtualName(mapping.getVirtualName()).withSize(mapping.getEbs().getVolumeSize());
        return device1.equals(device2);
    }

    @JsonDeserialize(builder=PrepareModifyServerGroupLaunchTemplateCommandBuilder.class)
    @JsonTypeName(value="prepareModifyServerGroupLaunchTemplateCommand")
    public static final class PrepareModifyServerGroupLaunchTemplateCommand
    implements SagaCommand {
        @Nonnull
        private final ModifyServerGroupLaunchTemplateDescription description;
        private EventMetadata metadata;

        public void setMetadata(@NotNull EventMetadata metadata) {
            this.metadata = metadata;
        }

        @Generated
        PrepareModifyServerGroupLaunchTemplateCommand(@Nonnull ModifyServerGroupLaunchTemplateDescription description, EventMetadata metadata) {
            if (description == null) {
                throw new IllegalArgumentException("description is marked non-null but is null");
            }
            this.description = description;
            this.metadata = metadata;
        }

        @Generated
        public static PrepareModifyServerGroupLaunchTemplateCommandBuilder builder() {
            return new PrepareModifyServerGroupLaunchTemplateCommandBuilder();
        }

        @Generated
        public PrepareModifyServerGroupLaunchTemplateCommandBuilder toBuilder() {
            return new PrepareModifyServerGroupLaunchTemplateCommandBuilder().description(this.description).metadata(this.metadata);
        }

        @Nonnull
        @Generated
        public ModifyServerGroupLaunchTemplateDescription getDescription() {
            return this.description;
        }

        @Generated
        public EventMetadata getMetadata() {
            return this.metadata;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrepareModifyServerGroupLaunchTemplateCommand)) {
                return false;
            }
            PrepareModifyServerGroupLaunchTemplateCommand other = (PrepareModifyServerGroupLaunchTemplateCommand)o;
            ModifyServerGroupLaunchTemplateDescription this$description = this.getDescription();
            ModifyServerGroupLaunchTemplateDescription other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            EventMetadata this$metadata = this.getMetadata();
            EventMetadata other$metadata = other.getMetadata();
            return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ModifyServerGroupLaunchTemplateDescription $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            EventMetadata $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PrepareModifyServerGroupLaunchTemplate.PrepareModifyServerGroupLaunchTemplateCommand(description=" + String.valueOf(this.getDescription()) + ", metadata=" + String.valueOf(this.getMetadata()) + ")";
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class PrepareModifyServerGroupLaunchTemplateCommandBuilder {
            @Generated
            private ModifyServerGroupLaunchTemplateDescription description;
            @Generated
            private EventMetadata metadata;

            @Generated
            PrepareModifyServerGroupLaunchTemplateCommandBuilder() {
            }

            @Generated
            public PrepareModifyServerGroupLaunchTemplateCommandBuilder description(@Nonnull ModifyServerGroupLaunchTemplateDescription description) {
                if (description == null) {
                    throw new IllegalArgumentException("description is marked non-null but is null");
                }
                this.description = description;
                return this;
            }

            @Generated
            public PrepareModifyServerGroupLaunchTemplateCommandBuilder metadata(EventMetadata metadata) {
                this.metadata = metadata;
                return this;
            }

            @Generated
            public PrepareModifyServerGroupLaunchTemplateCommand build() {
                return new PrepareModifyServerGroupLaunchTemplateCommand(this.description, this.metadata);
            }

            @Generated
            public String toString() {
                return "PrepareModifyServerGroupLaunchTemplate.PrepareModifyServerGroupLaunchTemplateCommand.PrepareModifyServerGroupLaunchTemplateCommandBuilder(description=" + String.valueOf(this.description) + ", metadata=" + String.valueOf(this.metadata) + ")";
            }
        }
    }

    private static class BlockDevice {
        private String deviceName;
        private String virtualName;
        private Integer size;

        private BlockDevice() {
        }

        public BlockDevice withDeviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public BlockDevice withVirtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public BlockDevice withSize(Integer size) {
            this.size = size;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockDevice that = (BlockDevice)o;
            return Objects.equals(this.deviceName, that.deviceName) && Objects.equals(this.virtualName, that.virtualName) && Objects.equals(this.size, that.size);
        }

        public int hashCode() {
            return Objects.hash(this.deviceName, this.virtualName, this.size);
        }
    }
}

