/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.aws.deploy.ops.actions;

import com.amazonaws.services.autoscaling.model.LaunchTemplateOverrides;
import com.amazonaws.services.ec2.model.LaunchTemplateVersion;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.netflix.spinnaker.clouddriver.aws.deploy.asg.AsgConfigHelper;
import com.netflix.spinnaker.clouddriver.aws.deploy.description.ModifyServerGroupLaunchTemplateDescription;
import com.netflix.spinnaker.clouddriver.aws.deploy.ops.actions.UpdateAutoScalingGroup;
import com.netflix.spinnaker.clouddriver.aws.deploy.validators.ModifyServerGroupLaunchTemplateValidator;
import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidationErrors;
import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidationException;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.clouddriver.event.EventMetadata;
import com.netflix.spinnaker.clouddriver.saga.SagaCommand;
import com.netflix.spinnaker.clouddriver.saga.flow.SagaAction;
import com.netflix.spinnaker.clouddriver.saga.models.Saga;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class PrepareUpdateAutoScalingGroup
implements SagaAction<PrepareUpdateAutoScalingGroupCommand> {
    private final ModifyServerGroupLaunchTemplateValidator validator;

    public PrepareUpdateAutoScalingGroup(ModifyServerGroupLaunchTemplateValidator validator) {
        this.validator = validator;
    }

    @NotNull
    public SagaAction.Result apply(@NotNull PrepareUpdateAutoScalingGroupCommand command, @NotNull Saga saga) {
        ModifyServerGroupLaunchTemplateDescription description = command.description;
        saga.log("[SAGA_ACTION] Preparing to update EC2 Auto Scaling Group " + description.getAsgName());
        saga.log("[SAGA_ACTION] Validating configuration for modify");
        DescriptionValidationErrors validationErrors = new DescriptionValidationErrors((Object)description);
        this.validator.validate(Collections.emptyList(), description, (ValidationErrors)validationErrors);
        if (validationErrors.hasErrors()) {
            saga.log("[SAGA_ACTION] Validation failed with errors: " + validationErrors.toString());
            throw new DescriptionValidationException((Errors)validationErrors);
        }
        List<LaunchTemplateOverrides> ltOverrides = AsgConfigHelper.getLaunchTemplateOverrides(description.getLaunchTemplateOverridesForInstanceType());
        UpdateAutoScalingGroup.UpdateAutoScalingGroupCommand updateCommand = UpdateAutoScalingGroup.UpdateAutoScalingGroupCommand.builder().description(description).launchTemplateVersion(command.launchTemplateVersion).launchTemplateOverrides(ltOverrides).isReqToUpgradeAsgToMixedInstancesPolicy(command.isReqToUpgradeAsgToMixedInstancesPolicy).newLaunchTemplateVersionNumber(command.newLaunchTemplateVersionNumber).build();
        return new SagaAction.Result((SagaCommand)updateCommand, Collections.emptyList());
    }

    @JsonDeserialize(builder=PrepareUpdateAutoScalingGroupCommandBuilder.class)
    @JsonTypeName(value="PrepareUpdateAutoScalingGroupCommand")
    public static final class PrepareUpdateAutoScalingGroupCommand
    implements SagaCommand {
        @Nonnull
        private final ModifyServerGroupLaunchTemplateDescription description;
        @Nonnull
        private final LaunchTemplateVersion launchTemplateVersion;
        @Nonnull
        private final Boolean isReqToUpgradeAsgToMixedInstancesPolicy;
        @Nullable
        private final Long newLaunchTemplateVersionNumber;
        private EventMetadata metadata;

        public void setMetadata(@NotNull EventMetadata metadata) {
            this.metadata = metadata;
        }

        @Generated
        PrepareUpdateAutoScalingGroupCommand(@Nonnull ModifyServerGroupLaunchTemplateDescription description, @Nonnull LaunchTemplateVersion launchTemplateVersion, @Nonnull Boolean isReqToUpgradeAsgToMixedInstancesPolicy, @Nullable Long newLaunchTemplateVersionNumber, EventMetadata metadata) {
            if (description == null) {
                throw new IllegalArgumentException("description is marked non-null but is null");
            }
            if (launchTemplateVersion == null) {
                throw new IllegalArgumentException("launchTemplateVersion is marked non-null but is null");
            }
            if (isReqToUpgradeAsgToMixedInstancesPolicy == null) {
                throw new IllegalArgumentException("isReqToUpgradeAsgToMixedInstancesPolicy is marked non-null but is null");
            }
            this.description = description;
            this.launchTemplateVersion = launchTemplateVersion;
            this.isReqToUpgradeAsgToMixedInstancesPolicy = isReqToUpgradeAsgToMixedInstancesPolicy;
            this.newLaunchTemplateVersionNumber = newLaunchTemplateVersionNumber;
            this.metadata = metadata;
        }

        @Generated
        public static PrepareUpdateAutoScalingGroupCommandBuilder builder() {
            return new PrepareUpdateAutoScalingGroupCommandBuilder();
        }

        @Generated
        public PrepareUpdateAutoScalingGroupCommandBuilder toBuilder() {
            return new PrepareUpdateAutoScalingGroupCommandBuilder().description(this.description).launchTemplateVersion(this.launchTemplateVersion).isReqToUpgradeAsgToMixedInstancesPolicy(this.isReqToUpgradeAsgToMixedInstancesPolicy).newLaunchTemplateVersionNumber(this.newLaunchTemplateVersionNumber).metadata(this.metadata);
        }

        @Nonnull
        @Generated
        public ModifyServerGroupLaunchTemplateDescription getDescription() {
            return this.description;
        }

        @Nonnull
        @Generated
        public LaunchTemplateVersion getLaunchTemplateVersion() {
            return this.launchTemplateVersion;
        }

        @Nonnull
        @Generated
        public Boolean getIsReqToUpgradeAsgToMixedInstancesPolicy() {
            return this.isReqToUpgradeAsgToMixedInstancesPolicy;
        }

        @Nullable
        @Generated
        public Long getNewLaunchTemplateVersionNumber() {
            return this.newLaunchTemplateVersionNumber;
        }

        @Generated
        public EventMetadata getMetadata() {
            return this.metadata;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrepareUpdateAutoScalingGroupCommand)) {
                return false;
            }
            PrepareUpdateAutoScalingGroupCommand other = (PrepareUpdateAutoScalingGroupCommand)o;
            Boolean this$isReqToUpgradeAsgToMixedInstancesPolicy = this.getIsReqToUpgradeAsgToMixedInstancesPolicy();
            Boolean other$isReqToUpgradeAsgToMixedInstancesPolicy = other.getIsReqToUpgradeAsgToMixedInstancesPolicy();
            if (this$isReqToUpgradeAsgToMixedInstancesPolicy == null ? other$isReqToUpgradeAsgToMixedInstancesPolicy != null : !((Object)this$isReqToUpgradeAsgToMixedInstancesPolicy).equals(other$isReqToUpgradeAsgToMixedInstancesPolicy)) {
                return false;
            }
            Long this$newLaunchTemplateVersionNumber = this.getNewLaunchTemplateVersionNumber();
            Long other$newLaunchTemplateVersionNumber = other.getNewLaunchTemplateVersionNumber();
            if (this$newLaunchTemplateVersionNumber == null ? other$newLaunchTemplateVersionNumber != null : !((Object)this$newLaunchTemplateVersionNumber).equals(other$newLaunchTemplateVersionNumber)) {
                return false;
            }
            ModifyServerGroupLaunchTemplateDescription this$description = this.getDescription();
            ModifyServerGroupLaunchTemplateDescription other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            LaunchTemplateVersion this$launchTemplateVersion = this.getLaunchTemplateVersion();
            LaunchTemplateVersion other$launchTemplateVersion = other.getLaunchTemplateVersion();
            if (this$launchTemplateVersion == null ? other$launchTemplateVersion != null : !this$launchTemplateVersion.equals(other$launchTemplateVersion)) {
                return false;
            }
            EventMetadata this$metadata = this.getMetadata();
            EventMetadata other$metadata = other.getMetadata();
            return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isReqToUpgradeAsgToMixedInstancesPolicy = this.getIsReqToUpgradeAsgToMixedInstancesPolicy();
            result = result * 59 + ($isReqToUpgradeAsgToMixedInstancesPolicy == null ? 43 : ((Object)$isReqToUpgradeAsgToMixedInstancesPolicy).hashCode());
            Long $newLaunchTemplateVersionNumber = this.getNewLaunchTemplateVersionNumber();
            result = result * 59 + ($newLaunchTemplateVersionNumber == null ? 43 : ((Object)$newLaunchTemplateVersionNumber).hashCode());
            ModifyServerGroupLaunchTemplateDescription $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            LaunchTemplateVersion $launchTemplateVersion = this.getLaunchTemplateVersion();
            result = result * 59 + ($launchTemplateVersion == null ? 43 : $launchTemplateVersion.hashCode());
            EventMetadata $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PrepareUpdateAutoScalingGroup.PrepareUpdateAutoScalingGroupCommand(description=" + String.valueOf(this.getDescription()) + ", launchTemplateVersion=" + String.valueOf(this.getLaunchTemplateVersion()) + ", isReqToUpgradeAsgToMixedInstancesPolicy=" + this.getIsReqToUpgradeAsgToMixedInstancesPolicy() + ", newLaunchTemplateVersionNumber=" + this.getNewLaunchTemplateVersionNumber() + ", metadata=" + String.valueOf(this.getMetadata()) + ")";
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class PrepareUpdateAutoScalingGroupCommandBuilder {
            @Generated
            private ModifyServerGroupLaunchTemplateDescription description;
            @Generated
            private LaunchTemplateVersion launchTemplateVersion;
            @Generated
            private Boolean isReqToUpgradeAsgToMixedInstancesPolicy;
            @Generated
            private Long newLaunchTemplateVersionNumber;
            @Generated
            private EventMetadata metadata;

            @Generated
            PrepareUpdateAutoScalingGroupCommandBuilder() {
            }

            @Generated
            public PrepareUpdateAutoScalingGroupCommandBuilder description(@Nonnull ModifyServerGroupLaunchTemplateDescription description) {
                if (description == null) {
                    throw new IllegalArgumentException("description is marked non-null but is null");
                }
                this.description = description;
                return this;
            }

            @Generated
            public PrepareUpdateAutoScalingGroupCommandBuilder launchTemplateVersion(@Nonnull LaunchTemplateVersion launchTemplateVersion) {
                if (launchTemplateVersion == null) {
                    throw new IllegalArgumentException("launchTemplateVersion is marked non-null but is null");
                }
                this.launchTemplateVersion = launchTemplateVersion;
                return this;
            }

            @Generated
            public PrepareUpdateAutoScalingGroupCommandBuilder isReqToUpgradeAsgToMixedInstancesPolicy(@Nonnull Boolean isReqToUpgradeAsgToMixedInstancesPolicy) {
                if (isReqToUpgradeAsgToMixedInstancesPolicy == null) {
                    throw new IllegalArgumentException("isReqToUpgradeAsgToMixedInstancesPolicy is marked non-null but is null");
                }
                this.isReqToUpgradeAsgToMixedInstancesPolicy = isReqToUpgradeAsgToMixedInstancesPolicy;
                return this;
            }

            @Generated
            public PrepareUpdateAutoScalingGroupCommandBuilder newLaunchTemplateVersionNumber(@Nullable Long newLaunchTemplateVersionNumber) {
                this.newLaunchTemplateVersionNumber = newLaunchTemplateVersionNumber;
                return this;
            }

            @Generated
            public PrepareUpdateAutoScalingGroupCommandBuilder metadata(EventMetadata metadata) {
                this.metadata = metadata;
                return this;
            }

            @Generated
            public PrepareUpdateAutoScalingGroupCommand build() {
                return new PrepareUpdateAutoScalingGroupCommand(this.description, this.launchTemplateVersion, this.isReqToUpgradeAsgToMixedInstancesPolicy, this.newLaunchTemplateVersionNumber, this.metadata);
            }

            @Generated
            public String toString() {
                return "PrepareUpdateAutoScalingGroup.PrepareUpdateAutoScalingGroupCommand.PrepareUpdateAutoScalingGroupCommandBuilder(description=" + String.valueOf(this.description) + ", launchTemplateVersion=" + String.valueOf(this.launchTemplateVersion) + ", isReqToUpgradeAsgToMixedInstancesPolicy=" + this.isReqToUpgradeAsgToMixedInstancesPolicy + ", newLaunchTemplateVersionNumber=" + this.newLaunchTemplateVersionNumber + ", metadata=" + String.valueOf(this.metadata) + ")";
            }
        }
    }
}

